/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.admin.ZkSecurityMigrator$;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

public final class ConfigCommand$
implements kafka.common.Config {
    public static final ConfigCommand$ MODULE$ = new ConfigCommand$();
    private static final String BrokerDefaultEntityName = "";
    private static final String BrokerLoggerConfigType = "broker-loggers";
    private static final Seq<String> BrokerSupportedConfigTypes = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Topic(), ConfigType$.MODULE$.Broker(), MODULE$.BrokerLoggerConfigType()}));
    private static final int DefaultScramIterations = 4096;
    private static final Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()}));
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public void validateChars(String prop, String value) {
        kafka.common.Config.validateChars$(this, prop, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String BrokerDefaultEntityName() {
        return BrokerDefaultEntityName;
    }

    public String BrokerLoggerConfigType() {
        return BrokerLoggerConfigType;
    }

    public Seq<String> BrokerSupportedConfigTypes() {
        return BrokerSupportedConfigTypes;
    }

    public int DefaultScramIterations() {
        return DefaultScramIterations;
    }

    public Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning() {
        return BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manipulate and describe entity config for a topic, client, user or broker");
            opts.checkArgs();
            if (!opts.options().has(opts.zkConnectOpt())) {
                this.processCommand(opts);
                return;
            }
            String println_x = "Warning: --zookeeper is deprecated and will be removed in a future version of Kafka.";
            Console$.MODULE$.println((Object)println_x);
            Object var11_3 = null;
            String println_x2 = "Use --bootstrap-server instead to specify a broker to connect to.";
            Console$.MODULE$.println((Object)println_x2);
            Object var12_4 = null;
            this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException);
            if (bl) {
                if (this.logger().underlying().isDebugEnabled()) {
                    void mkString_end;
                    void mkString_sep;
                    ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])args);
                    String string = " ";
                    if (ofRef2 == null) {
                        throw null;
                    }
                    ArraySeq.ofRef mkString_this = ofRef2;
                    String string2 = "";
                    String mkString_start = "";
                    Object var13_10 = null;
                    string2 = null;
                    Object var5_8 = null;
                    string = null;
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end)).append("'").toString(), throwable);
                }
                System.err.println(throwable.getMessage());
                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
            }
            if (throwable != null) {
                void mkString_end;
                void mkString_sep;
                if (this.logger().underlying().isDebugEnabled()) {
                    void mkString_end2;
                    void mkString_sep2;
                    ArraySeq.ofRef ofRef3 = Predef$.MODULE$.wrapRefArray((Object[])args);
                    String string = " ";
                    if (ofRef3 == null) {
                        throw null;
                    }
                    ArraySeq.ofRef mkString_this = ofRef3;
                    String string3 = "";
                    String mkString_start = "";
                    Object var15_14 = null;
                    string3 = null;
                    Object var7_12 = null;
                    string = null;
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep2, (String)mkString_end2)).append("'").toString(), throwable);
                }
                ArraySeq.ofRef ofRef4 = Predef$.MODULE$.wrapRefArray((Object[])args);
                String string = " ";
                if (ofRef4 == null) {
                    throw null;
                }
                ArraySeq.ofRef mkString_this = ofRef4;
                String string4 = "";
                String mkString_start = "";
                Object var17_18 = null;
                string4 = null;
                Object var9_16 = null;
                string = null;
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end)).append("'").toString());
                throwable.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
            }
            throw null;
        }
    }

    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        None$ none$;
        String string;
        String string2;
        Object object;
        Option<ZKClientConfig> option = ZkSecurityMigrator$.MODULE$.createZkClientConfigFromOption(opts.options(), opts.zkTlsConfigFile());
        if (option == null) {
            throw null;
        }
        Option<ZKClientConfig> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ZKClientConfig zKClientConfig;
            ZKClientConfig zKClientConfig2 = zKClientConfig = new ZKClientConfig();
            zKClientConfig = null;
            object = zKClientConfig2;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var13_3 = null;
        object = null;
        ZKClientConfig zkClientConfig = (ZKClientConfig)object2;
        boolean x$2 = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
        Time x$6 = Time.SYSTEM;
        Some x$7 = new Some((Object)zkClientConfig);
        String string3 = string2 = "kafka.server";
        string2 = null;
        String x$8 = string3;
        String string4 = string = "SessionExpireListener";
        string = null;
        String x$9 = string4;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$2;
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, x$2, 30000, 30000, Integer.MAX_VALUE, x$6, x$8, x$9, (Option<String>)x$10, (Option<ZKClientConfig>)x$7);
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfigWithZk(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfigWithZk(zkClient, opts, adminZkClient);
            }
        }
        finally {
            zkClient.close();
        }
    }

    public void alterConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        } else {
            Set dynamicBrokerConfigs;
            String string3 = entityType;
            String string4 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && (dynamicBrokerConfigs = (Set)((MapOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfigWithZk$1(elem)))).nonEmpty()) {
                String string5 = entityName;
                String string6 = ConfigEntityName$.MODULE$.Default();
                boolean perBrokerConfig = string5 == null ? string6 != null : !string5.equals(string6);
                String errorMessage = new StringBuilder(70).append("--bootstrap-server option must be specified to update broker configs ").append(dynamicBrokerConfigs).append(".").toString();
                String info = "Broker configuration updates using ZooKeeper are supported for bootstrapping before brokers are started to enable encrypted password configs to be stored in ZooKeeper.";
                if (perBrokerConfig) {
                    Option<Object> option = adminZkClient.parseBroker(entityName);
                    if (option == null) {
                        throw null;
                    }
                    Option<Object> foreach_this = option;
                    if (!foreach_this.isEmpty()) {
                        int n = BoxesRunTime.unboxToInt((Object)foreach_this.get());
                        ConfigCommand$.$anonfun$alterConfigWithZk$2(zkClient, errorMessage, entityName, info, n);
                    }
                    Object var18_16 = null;
                } else if (!zkClient.getAllBrokersInCluster().isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$alterConfigWithZk$4(errorMessage, info)).toString());
                }
                this.preProcessBrokerConfigs(configsToBeAdded, perBrokerConfig);
            }
        }
        Properties configs = adminZkClient.fetchEntityConfig(entityType, entityName);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)configs.containsKey(x$1)));
        if (invalidConfigs.nonEmpty()) {
            String mkString_sep = ",";
            Object var19_20 = null;
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString("", mkString_sep, "")).toString());
        }
        new Implicits.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable)x$2 -> configs.remove(x$2));
        adminZkClient.changeConfigs(entityType, entityName, configs);
        String println_x = new StringBuilder(39).append("Completed updating config for entity: ").append(entity).append(".").toString();
        Console$.MODULE$.println((Object)println_x);
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        for (ScramMechanism scramMechanism : ScramMechanism.values()) {
            ConfigCommand$.$anonfun$preProcessScramCredentials$1(this, configsToBeAdded, scramMechanism);
        }
    }

    public PasswordEncoder createPasswordEncoder(Map<String, String> encoderConfigs) {
        Object object;
        Object object2;
        Object object3;
        encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        String encoderSecret = (String)encoderConfigs.getOrElse((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Password encoder secret not specified");
        });
        Password password = new Password(encoderSecret);
        Option option = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp());
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            String string;
            String string2 = string = Defaults$.MODULE$.PasswordEncoderCipherAlgorithm();
            string = null;
            object3 = string2;
        } else {
            object3 = getOrElse_this.get();
        }
        Object object4 = object3;
        Object var3_3 = null;
        object3 = null;
        String string = (String)object4;
        Option option2 = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp());
        if (option2 == null) {
            throw null;
        }
        Option map_this = option2;
        Object object5 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommand$.$anonfun$createPasswordEncoder$3((String)map_this.get()));
        None$ none$ = object5;
        Object var5_6 = null;
        object5 = null;
        None$ getOrElse_this2 = none$;
        if (getOrElse_this2.isEmpty()) {
            Integer n;
            Integer n2 = n = Integer.valueOf(Defaults$.MODULE$.PasswordEncoderKeyLength());
            n = null;
            object2 = n2;
        } else {
            object2 = getOrElse_this2.get();
        }
        Object object6 = object2;
        Object var7_8 = null;
        object2 = null;
        int n = BoxesRunTime.unboxToInt((Object)object6);
        Option option3 = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp());
        if (option3 == null) {
            throw null;
        }
        Option map_this2 = option3;
        Object object7 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommand$.$anonfun$createPasswordEncoder$5((String)map_this2.get()));
        None$ none$2 = object7;
        Object var9_11 = null;
        object7 = null;
        None$ getOrElse_this3 = none$2;
        if (getOrElse_this3.isEmpty()) {
            Integer n3;
            Integer n4 = n3 = Integer.valueOf(Defaults$.MODULE$.PasswordEncoderIterations());
            n3 = null;
            object = n4;
        } else {
            object = getOrElse_this3.get();
        }
        Object object8 = object;
        Object var11_13 = null;
        object = null;
        return new PasswordEncoder(password, (Option<String>)None$.MODULE$, string, n, BoxesRunTime.unboxToInt((Object)object8));
    }

    private void preProcessBrokerConfigs(Properties configsToBeAdded, boolean perBrokerConfig) {
        Properties passwordEncoderConfigs = new Properties();
        new Implicits.PropertiesOps(passwordEncoderConfigs).$plus$plus$eq((Map<String, Object>)((Map)((IterableOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$preProcessBrokerConfigs$1(x0$1)))));
        if (!passwordEncoderConfigs.isEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = ConfigCommand$.$anonfun$preProcessBrokerConfigs$2(passwordEncoderConfigs);
                Object var6_4 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            ((MapOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()).keySet().foreach((Function1 & Serializable)x$1 -> configsToBeAdded.remove(x$1));
        }
        DynamicBrokerConfig$.MODULE$.validateConfigs(configsToBeAdded, perBrokerConfig);
        Set passwordConfigs = (Set)((MapOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)));
        if (passwordConfigs.nonEmpty()) {
            if (!passwordEncoderConfigs.containsKey(KafkaConfig$.MODULE$.PasswordEncoderSecretProp())) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$preProcessBrokerConfigs$5(passwordConfigs)).toString());
            }
            PasswordEncoder passwordEncoder = this.createPasswordEncoder((Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()));
            passwordConfigs.foreach((Function1 & Serializable)configName -> {
                String encodedValue = passwordEncoder.encode(new Password(configsToBeAdded.getProperty((String)configName)));
                return configsToBeAdded.setProperty((String)configName, encodedValue);
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var6_5 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        configEntity.getAllEntities(zkClient).foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$describeConfigWithZk$1$adapted(kafka.zk.AdminZkClient boolean kafka.admin.ConfigCommand$ConfigEntity ), (Lkafka/admin/ConfigCommand$ConfigEntity;)Ljava/lang/Object;)((AdminZkClient)adminZkClient, (boolean)describeAllUsers));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        Properties props = new Properties();
        if (opts.options().has(opts.addConfig())) {
            boolean bl;
            String[][] configsToBeAdded;
            block7: {
                Object var7_7;
                void map$extension_ct;
                String pattern = "(?=[^\\]]*(?:\\[|$))";
                ClassTag classTag = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class));
                String[] map$extension_$this = ((String)opts.options().valueOf(opts.addConfig())).split(new StringBuilder(1).append(",").append(pattern).toString());
                int n = map$extension_$this.length;
                Object map$extension_ys = map$extension_ct.newArray(n);
                if (n > 0) {
                    for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                        String string = map$extension_$this[map$extension_i];
                        ScalaRunTime$.MODULE$.array_update(map$extension_ys, map$extension_i, (Object)string.split(new StringBuilder(7).append("\\s*=\\s*").append(pattern).toString(), -1));
                    }
                }
                void v0 = var7_7;
                Object var5_5 = null;
                classTag = null;
                var7_7 = null;
                configsToBeAdded = (String[][])v0;
                for (int forall$extension_i = 0; forall$extension_i < configsToBeAdded.length; ++forall$extension_i) {
                    if (ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(configsToBeAdded[forall$extension_i])) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Invalid entity config: all configs to be added must be in the format \"key=val\".").toString());
            }
            for (String[] stringArray : configsToBeAdded) {
                props.setProperty(stringArray[0].trim(), stringArray[1].replaceAll("\\[?\\]?", "").trim());
            }
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                String println_x = new StringBuilder(0).append(new StringBuilder(43).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").toString()).append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString();
                Console$.MODULE$.println((Object)println_x);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map((Function1 & Serializable)x$7 -> x$7.trim());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable)x$8 -> propsToBeDeleted.setProperty((String)x$8, ""));
            return var2_2;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    private void processCommand(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        Admin adminClient = Admin.create((Properties)props);
        List<String> list = opts.entityTypes();
        if (list == null) {
            throw null;
        }
        if (SeqOps.size$(list) != 1) {
            void mkString_sep;
            Seq<String> seq = this.BrokerSupportedConfigTypes();
            String string = ",";
            if (seq == null) {
                throw null;
            }
            string = null;
            throw new IllegalArgumentException(new StringBuilder(75).append("Exactly one entity type (out of ").append(seq.mkString("", (String)mkString_sep, "")).append(") must be specified with --bootstrap-server").toString());
        }
        List<String> entityNames = opts.entityNames();
        if (entityNames == null) {
            throw null;
        }
        if (SeqOps.size$(entityNames) > 1) {
            throw new IllegalArgumentException("At most one entity name must be specified with --bootstrap-server");
        }
        if (opts.options().has((OptionSpec)opts.alterOpt()) && SeqOps.size$(entityNames) != 1) {
            throw new IllegalArgumentException("Exactly one entity name must be specified with --bootstrap-server for --alter");
        }
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(adminClient, opts);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(adminClient, opts);
            }
        }
        finally {
            adminClient.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        String entityType = (String)opts.entityTypes().head();
        String entityName = (String)opts.entityNames().head();
        scala.collection.mutable.Map configsToBeAdded = (scala.collection.mutable.Map)((MapOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.parseConfigsToBeAdded(opts)).asScala()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            return tuple2;
        });
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            void $plus$plus_suffix;
            scala.collection.immutable.Map oldConfig = ((IterableOnceOps)this.getConfig(adminClient, entityType, entityName, false, false).map((Function1 & Serializable)entry -> new Tuple2((Object)entry.name(), entry))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
            if (invalidConfigs.nonEmpty()) {
                String mkString_sep = ",";
                Object var24_9 = null;
                throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString("", mkString_sep, "")).toString());
            }
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, entityName);
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Integer.valueOf(30000)).validateOnly(false);
            IterableOps iterableOps = (IterableOps)configsToBeAdded.values().map((Function1 & Serializable)x$9 -> new AlterConfigOp(x$9, AlterConfigOp.OpType.SET));
            IterableOnce iterableOnce = (IterableOnce)configsToBeDeleted.map((Function1 & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE));
            if (iterableOps == null) {
                throw null;
            }
            iterableOnce = null;
            Iterable asJavaCollectionConverter_i = (Iterable)iterableOps.concat((IterableOnce)$plus$plus_suffix);
            Object var31_13 = null;
            Collection alterEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
            Object[] objectArray = new Tuple2[1];
            objectArray[0] = new Tuple2((Object)configResource, (Object)alterEntries);
            Void cfr_ignored_0 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        } else {
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
                scala.collection.immutable.Map oldConfig = ((IterableOnceOps)this.getConfig(adminClient, entityType, entityName, false, false).map((Function1 & Serializable)entry -> new Tuple2((Object)entry.name(), entry))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
                if (invalidConfigs.nonEmpty()) {
                    String mkString_sep = ",";
                    Object var26_17 = null;
                    throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString("", mkString_sep, "")).toString());
                }
                scala.collection.immutable.MapOps mapOps = (scala.collection.immutable.MapOps)oldConfig.$plus$plus((IterableOnce)configsToBeAdded);
                if (mapOps == null) {
                    throw null;
                }
                scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)mapOps.removedAll(configsToBeDeleted);
                scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$8(x$10)));
                if (sensitiveEntries.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(84).append("All sensitive broker config entries must be specified for --alter, missing entries: ").append(sensitiveEntries.keySet()).toString());
                }
                Config newConfig = new Config(((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Integer.valueOf(30000)).validateOnly(false);
                Object[] objectArray = new Tuple2[1];
                objectArray[0] = new Tuple2((Object)configResource, (Object)newConfig);
                Void cfr_ignored_1 = (Void)adminClient.alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else {
                String string3 = this.BrokerLoggerConfigType();
                if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
                    void $plus$plus_suffix;
                    void $plus$plus_suffix2;
                    scala.collection.immutable.Seq validLoggers = (scala.collection.immutable.Seq)this.getConfig(adminClient, entityType, entityName, true, false).map((Function1 & Serializable)x$11 -> x$11.name());
                    IterableOps iterableOps = (IterableOps)configsToBeDeleted.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)));
                    IterableOnce iterableOnce = (IterableOnce)configsToBeAdded.keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)));
                    if (iterableOps == null) {
                        throw null;
                    }
                    iterableOnce = null;
                    Seq invalidBrokerLoggers = (Seq)iterableOps.concat((IterableOnce)$plus$plus_suffix2);
                    if (invalidBrokerLoggers.nonEmpty()) {
                        String mkString_sep = ",";
                        Object var28_26 = null;
                        throw new InvalidConfigurationException(new StringBuilder(26).append("Invalid broker logger(s): ").append(invalidBrokerLoggers.mkString("", mkString_sep, "")).toString());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityName);
                    AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Integer.valueOf(30000)).validateOnly(false);
                    IterableOps iterableOps2 = (IterableOps)configsToBeAdded.values().map((Function1 & Serializable)x$12 -> new AlterConfigOp(x$12, AlterConfigOp.OpType.SET));
                    IterableOnce iterableOnce2 = (IterableOnce)configsToBeDeleted.map((Function1 & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE));
                    if (iterableOps2 == null) {
                        throw null;
                    }
                    iterableOnce2 = null;
                    Iterable asJavaCollectionConverter_i = (Iterable)iterableOps2.concat((IterableOnce)$plus$plus_suffix);
                    Object var32_30 = null;
                    Collection alterLogLevelEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
                    Object[] objectArray = new Tuple2[1];
                    objectArray[0] = new Tuple2((Object)configResource, (Object)alterLogLevelEntries);
                    Void cfr_ignored_2 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported entity type: ").append(entityType).toString());
                }
            }
        }
        boolean bl = !entityName.isEmpty();
        if (bl) {
            String println_x = new StringBuilder(32).append("Completed updating config for ").append(StringOps$.MODULE$.dropRight$extension(entityType, 1)).append(" ").append(entityName).append(".").toString();
            Console$.MODULE$.println((Object)println_x);
            return;
        }
        String println_x = new StringBuilder(54).append("Completed updating default config for ").append(entityType).append(" in the cluster.").toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public void describeConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        None$ none$;
        String entityType = (String)opts.entityTypes().head();
        Option entityName = opts.entityNames().headOption();
        boolean describeAll = opts.options().has((OptionSpec)opts.allOpt());
        if (entityName == null) {
            throw null;
        }
        if (entityName.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string = (String)entityName.get();
            none$ = new Some((Object)new .colon.colon((Object)string, (List)Nil$.MODULE$));
        }
        None$ none$2 = none$;
        none$ = null;
        None$ getOrElse_this = none$2;
        Object object = getOrElse_this.isEmpty() ? ConfigCommand$.$anonfun$describeConfig$2(entityType, adminClient) : getOrElse_this.get();
        Object object2 = object;
        Object var7_8 = null;
        object = null;
        ((scala.collection.immutable.Seq)object2).foreach((Function1 & Serializable)entity -> {
            ConfigCommand$.$anonfun$describeConfig$4(entityType, describeAll, adminClient, entity);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Seq<ConfigEntry> getConfig(Admin adminClient, String entityType, String entityName, boolean includeSynonyms, boolean describeAll) {
        void var6_10;
        ConfigResource.Type type;
        Some some;
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            if (!entityName.isEmpty()) {
                Topic.validate((String)entityName);
            }
            some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG);
            type = ConfigResource.Type.TOPIC;
        } else {
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
                ConfigResource.Type type2;
                Some some2;
                String string3 = this.BrokerDefaultEntityName();
                if (!(string3 != null ? !string3.equals(entityName) : entityName != null)) {
                    some2 = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG);
                    type2 = ConfigResource.Type.BROKER;
                } else {
                    ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    some2 = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG);
                    type2 = ConfigResource.Type.BROKER;
                }
                some = some2;
                type = type2;
            } else {
                String string4 = this.BrokerLoggerConfigType();
                if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
                    if (!entityName.isEmpty()) {
                        ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    }
                    some = None$.MODULE$;
                    type = ConfigResource.Type.BROKER_LOGGER;
                } else {
                    throw new MatchError((Object)entityType);
                }
            }
        }
        Option dynamicConfigSource = (Option)some;
        None$ configSourceFilter = describeAll ? None$.MODULE$ : var6_10;
        ConfigResource configResource = new ConfigResource(type, entityName);
        DescribeConfigsOptions describeOptions = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOptions).all().get(30L, TimeUnit.SECONDS);
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).filter(arg_0 -> ConfigCommand$.$anonfun$getConfig$1$adapted((Option)configSourceFilter, arg_0))).toSeq();
    }

    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        String string;
        List<String> entityNames;
        List<String> entityTypes;
        block3: {
            block2: {
                entityTypes = opts.entityTypes();
                entityNames = opts.entityNames();
                Object object = entityTypes.head();
                String string2 = ConfigType$.MODULE$.User();
                if (!(object == null ? string2 != null : !object.equals(string2))) break block2;
                Object object2 = entityTypes.head();
                String string3 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string3) : string3 != null) break block3;
            }
            return this.parseQuotaEntity(opts, entityTypes, entityNames);
        }
        Option option = entityNames.headOption();
        Object object = option instanceof Some && "".equals(string = (String)((Some)option).value()) ? new Some((Object)ConfigEntityName$.MODULE$.Default()) : option;
        return new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)object), (Option<ConfigCommand.Entity>)None$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts, List<String> types, List<String> names) {
        if (opts.options().has((OptionSpec)opts.alterOpt())) {
            if (names == null) {
                throw null;
            }
            if (types == null) {
                throw null;
            }
            if (SeqOps.size$(names) != SeqOps.size$(types)) {
                throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
            }
        }
        if (types == null) {
            throw null;
        }
        if (SeqOps.size$(types) != 2) ** GOTO lbl-1000
        v0 = types.head();
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? types.reverse() : types;
        sortedNames = (reverse != false && names.length() == 2 ? names.reverse() : names).iterator();
        if (entityTypes == null) {
            throw null;
        }
        if (entityTypes == Nil$.MODULE$) {
            var14_8 = Nil$.MODULE$;
        } else {
            var15_9 = (String)entityTypes.head();
            map_t = map_h = new .colon.colon((Object)ConfigCommand$.$anonfun$parseQuotaEntity$1(sortedNames, var15_9), (List)Nil$.MODULE$);
            for (map_rest = (List)entityTypes.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                var15_9 = (String)map_rest.head();
                map_nx = new .colon.colon((Object)ConfigCommand$.$anonfun$parseQuotaEntity$1(sortedNames, var15_9), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            var14_8 = map_h;
        }
        v2 = var14_8;
        var10_10 = null;
        var11_11 = null;
        var12_12 = null;
        var13_13 = null;
        var14_8 = null;
        entities = v2;
        v3 = (ConfigCommand.Entity)entities.head();
        if (SeqOps.size$((SeqOps)entities) > 1) {
            apply_n = 1;
            v4 = new Some(LinearSeqOps.apply$((LinearSeqOps)entities, (int)apply_n));
            v5 = v4;
        } else {
            v5 = None$.MODULE$;
        }
        return new ConfigCommand.ConfigEntity(v3, (Option<ConfigCommand.Entity>)v5);
    }

    public static final /* synthetic */ ZKClientConfig $anonfun$processCommandWithZk$1() {
        return new ZKClientConfig();
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigWithZk$1(String elem) {
        return MODULE$.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning().contains((Object)elem);
    }

    public static final /* synthetic */ String $anonfun$alterConfigWithZk$3(String errorMessage$1, String entityName$1, String info$1) {
        return new StringBuilder(26).append(errorMessage$1).append(" when broker ").append(entityName$1).append(" is running. ").append(info$1).toString();
    }

    public static final /* synthetic */ void $anonfun$alterConfigWithZk$2(KafkaZkClient zkClient$1, String errorMessage$1, String entityName$1, String info$1, int brokerId) {
        if (!zkClient$1.getBroker(brokerId).isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$alterConfigWithZk$3(errorMessage$1, entityName$1, info$1)).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$alterConfigWithZk$4(String errorMessage$1, String info$1) {
        return new StringBuilder(47).append(errorMessage$1).append(" for default cluster if any broker is running. ").append(info$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String scramCredential$1(ScramMechanism mechanism, String credentialStr) {
        void var6_6;
        Option option;
        Regex pattern = StringOps$.MODULE$.r$extension("(?:iterations=([0-9]*),)?password=(.*)");
        if (credentialStr == null || (option = pattern.unapplySeq((CharSequence)credentialStr)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(2) != 0) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        String iterations = (String)((LinearSeqOps)option.get()).apply(0);
        String password = (String)((LinearSeqOps)option.get()).apply(1);
        int n = iterations != null ? Integer.parseInt(iterations) : this.DefaultScramIterations();
        if (n < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append(n).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism).toString());
        }
        return ScramCredentialUtils.credentialToString((ScramCredential)new ScramFormatter(mechanism).generateCredential((String)var6_6, n));
    }

    public static final /* synthetic */ Object $anonfun$preProcessScramCredentials$1(ConfigCommand$ $this, Properties configsToBeAdded$1, ScramMechanism mechanism) {
        String string = configsToBeAdded$1.getProperty(mechanism.mechanismName());
        Object object = string == null ? BoxedUnit.UNIT : configsToBeAdded$1.setProperty(mechanism.mechanismName(), $this.scramCredential$1(mechanism, string));
        return object;
    }

    public static final /* synthetic */ String $anonfun$createPasswordEncoder$2() {
        return Defaults$.MODULE$.PasswordEncoderCipherAlgorithm();
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$3(String x$4) {
        return Integer.parseInt(x$4);
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$4() {
        return Defaults$.MODULE$.PasswordEncoderKeyLength();
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$5(String x$5) {
        return Integer.parseInt(x$5);
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$6() {
        return Defaults$.MODULE$.PasswordEncoderIterations();
    }

    public static final /* synthetic */ boolean $anonfun$preProcessBrokerConfigs$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((String)x0$1._1()).startsWith("password.encoder.");
        return bl;
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$2(Properties passwordEncoderConfigs$1) {
        return new StringBuilder(48).append(new StringBuilder(53).append("Password encoder configs ").append(passwordEncoderConfigs$1.keySet()).append(" will be used for encrypting").toString()).append(" passwords, but will not be stored in ZooKeeper.").toString();
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$5(Set passwordConfigs$1) {
        return new StringBuilder(196).append(new StringBuilder(30).append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append(" must be specified to update ").append(passwordConfigs$1).append(".").toString()).append(" Other password encoder configs like cipher algorithm and iterations may also be specified").append(" to override the default encoding parameters. Password encoder configs will not be persisted").append(" in ZooKeeper.").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$describeConfigWithZk$1(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        Properties configs = adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
        if (!configs.isEmpty() || !describeAllUsers$1) {
            void mkString_sep;
            Object[] objectArray = new Object[2];
            objectArray[0] = entity;
            IterableOnceOps iterableOnceOps = (IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1 & Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString());
            String string = ",";
            if (iterableOnceOps == null) {
                throw null;
            }
            string = null;
            objectArray[1] = iterableOnceOps.mkString("", (String)mkString_sep, "");
            String println_x = StringOps$.MODULE$.format$extension("Configs for %s are %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
            Console$.MODULE$.println((Object)println_x);
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$2(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ String $anonfun$parseConfigsToBeAdded$3() {
        return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$8(Tuple2 x$10) {
        return ((ConfigEntry)x$10._2()).value() == null;
    }

    public static final /* synthetic */ List $anonfun$describeConfig$1(String name) {
        return new .colon.colon((Object)name, (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ scala.collection.immutable.Seq $anonfun$describeConfig$2(String entityType$1, Admin adminClient$1) {
        scala.collection.immutable.Seq seq;
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType$1) : entityType$1 != null)) {
            seq = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)adminClient$1.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).asScala()).toSeq();
        } else {
            boolean bl;
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityType$1) : entityType$1 != null)) {
                bl = true;
            } else {
                String string3 = MODULE$.BrokerLoggerConfigType();
                bl = !(string3 != null ? !string3.equals(entityType$1) : entityType$1 != null);
            }
            if (bl) {
                void $colon$plus_elem;
                scala.collection.immutable.Seq seq2 = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient$1.describeCluster(new DescribeClusterOptions()).nodes().get()).asScala()).map((Function1 & Serializable)x$13 -> x$13.idString())).toSeq();
                String string4 = MODULE$.BrokerDefaultEntityName();
                if (seq2 == null) {
                    throw null;
                }
                string4 = null;
                seq = (scala.collection.immutable.Seq)seq2.appended((Object)$colon$plus_elem);
            } else {
                throw new MatchError((Object)entityType$1);
            }
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$describeConfig$5(ConfigEntry entry) {
        void mkString_sep;
        String string;
        IterableOnceOps iterableOnceOps = (IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(entry.synonyms()).asScala()).map((Function1 & Serializable)synonym -> new StringBuilder(2).append(synonym.source()).append(":").append(synonym.name()).append("=").append(synonym.value()).toString());
        String string2 = ", ";
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps mkString_this = iterableOnceOps;
        String string3 = string = mkString_this.mkString("", (String)mkString_sep, "");
        Object var2_2 = null;
        string2 = null;
        string = null;
        String synonyms = string3;
        String println_x = new StringBuilder(26).append("  ").append(entry.name()).append("=").append(entry.value()).append(" sensitive=").append(entry.isSensitive()).append(" synonyms={").append(synonyms).append("}").toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public static final /* synthetic */ void $anonfun$describeConfig$4(String entityType$1, boolean describeAll$1, Admin adminClient$1, String entity) {
        String string = MODULE$.BrokerDefaultEntityName();
        if (!(string != null ? !string.equals(entity) : entity != null)) {
            String println_x = new StringBuilder(40).append("Default configs for ").append(entityType$1).append(" in the cluster are:").toString();
            Console$.MODULE$.println((Object)println_x);
            Object var5_4 = null;
        } else {
            String configSourceStr = describeAll$1 ? "All" : "Dynamic";
            String println_x = new StringBuilder(19).append(configSourceStr).append(" configs for ").append(StringOps$.MODULE$.dropRight$extension(entityType$1, 1)).append(" ").append(entity).append(" are:").toString();
            Console$.MODULE$.println((Object)println_x);
            Object var6_6 = null;
        }
        MODULE$.getConfig(adminClient$1, entityType$1, entity, true, describeAll$1).foreach((Function1 & Serializable)entry -> {
            ConfigCommand$.$anonfun$describeConfig$5(entry);
            return BoxedUnit.UNIT;
        });
    }

    private static final void validateBrokerId$1(String entityName$2, String entityType$2) {
        try {
            Integer.parseInt(entityName$2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(63).append("The entity name for ").append(entityType$2).append(" must be a valid integer broker id, found: ").append(entityName$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getConfig$1(Option configSourceFilter$1, ConfigEntry entry) {
        boolean bl;
        if (configSourceFilter$1 instanceof Some) {
            ConfigEntry.ConfigSource configSource = (ConfigEntry.ConfigSource)((Some)configSourceFilter$1).value();
            ConfigEntry.ConfigSource configSource2 = entry.source();
            bl = !(configSource2 != null ? !configSource2.equals(configSource) : configSource != null);
        } else if (None$.MODULE$.equals(configSourceFilter$1)) {
            bl = true;
        } else {
            throw new MatchError((Object)configSourceFilter$1);
        }
        return bl;
    }

    private static final String sanitizeName$1(String entityType, String name) {
        boolean bl;
        if (name.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        String string = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            bl = true;
        } else {
            String string2 = ConfigType$.MODULE$.Client();
            bl = !(string2 != null ? !string2.equals(entityType) : entityType != null);
        }
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Invalid entity type ").append(entityType).toString());
        }
        String string3 = Sanitizer.sanitize((String)name);
        return string3;
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseQuotaEntity$1(Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$createPasswordEncoder$3$adapted(String x$4) {
        return BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$3(x$4));
    }

    public static final /* synthetic */ Object $anonfun$createPasswordEncoder$5$adapted(String x$5) {
        return BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$5(x$5));
    }

    public static final /* synthetic */ Object $anonfun$describeConfigWithZk$1$adapted(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        ConfigCommand$.$anonfun$describeConfigWithZk$1(adminZkClient$1, describeAllUsers$1, entity);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$parseConfigsToBeAdded$2$adapted(String[] config) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(config));
    }

    public static final /* synthetic */ Object $anonfun$getConfig$1$adapted(Option configSourceFilter$1, ConfigEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$getConfig$1(configSourceFilter$1, entry));
    }
}

