/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConsumerGroupCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ConsumerGroupCommand$
implements Logging {
    public static final ConsumerGroupCommand$ MODULE$ = new ConsumerGroupCommand$();
    private static final String MISSING_COLUMN_VALUE = "-";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to list all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
        if (Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.listOpt(), opts.describeOpt(), opts.deleteOpt(), opts.resetOffsetsOpt(), opts.deleteOffsetsOpt()})).count(arg_0 -> ConsumerGroupCommand$.$anonfun$main$1$adapted(opts.options(), arg_0)) != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets");
        }
        opts.checkArgs();
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = new ConsumerGroupCommand.ConsumerGroupService(opts, (Map<String, String>)((Map)Map$.MODULE$.empty()));){
            try {
                if (opts.options().has((OptionSpec)opts.listOpt())) {
                    List list = consumerGroupService.listGroups();
                    if (list == null) {
                        throw null;
                    }
                    List foreach_these = list;
                    while (!foreach_these.isEmpty()) {
                        String string = (String)foreach_these.head();
                        Console$.MODULE$.println((Object)string);
                        foreach_these = (List)foreach_these.tail();
                    }
                    Object var8_4 = null;
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    consumerGroupService.describeGroups();
                } else if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                    consumerGroupService.deleteGroups();
                } else if (opts.options().has((OptionSpec)opts.resetOffsetsOpt())) {
                    Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = consumerGroupService.resetOffsets();
                    if (opts.options().has((OptionSpec)opts.exportOpt())) {
                        String exported = consumerGroupService.exportOffsetsToCsv(offsetsToReset);
                        Console$.MODULE$.println((Object)exported);
                    } else {
                        this.printOffsetsToReset(offsetsToReset);
                    }
                } else if (opts.options().has((OptionSpec)opts.deleteOffsetsOpt())) {
                    consumerGroupService.deleteOffsets();
                }
            }
            catch (Throwable e) {
                this.printError(new StringBuilder(47).append("Executing consumer group command failed due to ").append(e.getMessage()).toString(), (Option<Throwable>)new Some((Object)e));
            }
        }
    }

    public String MISSING_COLUMN_VALUE() {
        return MISSING_COLUMN_VALUE;
    }

    public void printError(String msg, Option<Throwable> e) {
        String println_x = new StringBuilder(8).append("\nError: ").append(msg).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var3_3 = null;
        if (e == null) {
            throw null;
        }
        if (!e.isEmpty()) {
            ((Throwable)e.get()).printStackTrace();
        }
    }

    public Option<Throwable> printError$default$2() {
        return None$.MODULE$;
    }

    public Long convertTimestamp(String timeString) {
        Date date;
        String string = timeString.split("T")[1].contains("+") || timeString.split("T")[1].contains("-") || timeString.split("T")[1].contains("Z") ? timeString.toString() : new StringBuilder(1).append(timeString).append("Z").toString();
        try {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(string);
        }
        catch (ParseException parseException) {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse(string);
        }
        return date.getTime();
    }

    public void printOffsetsToReset(Map<String, Map<TopicPartition, OffsetAndMetadata>> groupAssignmentsToReset) {
        if (groupAssignmentsToReset.nonEmpty()) {
            String println_x = StringOps$.MODULE$.format$extension("\n%-30s %-30s %-10s %-15s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"GROUP", "TOPIC", "PARTITION", "NEW-OFFSET"}));
            Console$.MODULE$.println((Object)println_x);
            Object var2_2 = null;
        }
        groupAssignmentsToReset.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$4 -> {
            ConsumerGroupCommand$.$anonfun$printOffsetsToReset$2(x$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$4(String groupId$1, Tuple2 x$3) {
        if (x$3 != null) {
            TopicPartition consumerAssignment = (TopicPartition)x$3._1();
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)x$3._2();
            String println_x = StringOps$.MODULE$.format$extension("%-30s %-30s %-10s %-15s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupId$1, consumerAssignment.topic(), consumerAssignment.partition(), offsetAndMetadata.offset()}));
            Console$.MODULE$.println((Object)println_x);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$2(Tuple2 x$4) {
        if (x$4 != null) {
            String groupId = (String)x$4._1();
            ((Map)x$4._2()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$3 -> {
                ConsumerGroupCommand$.$anonfun$printOffsetsToReset$4(groupId, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    private ConsumerGroupCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }

    public static final /* synthetic */ Object $anonfun$main$2$adapted(String x$1) {
        Predef$.MODULE$.println((Object)x$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$printError$1$adapted(Throwable x$2) {
        x$2.printStackTrace();
        return BoxedUnit.UNIT;
    }
}

