/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.KafkaThread;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g!B\u0010!\u0001\t\"\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011A\u0019\t\u0011a\u0002!\u0011!Q\u0001\nIB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005w!A!\t\u0001BC\u0002\u0013\u0005!\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003<\u0011!!\u0005A!A!\u0002\u0013Y\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011%\u0003!\u0011!Q\u0001\n)CQ!\u0016\u0001\u0005\u0002YCqA\u0018\u0001C\u0002\u0013%q\f\u0003\u0004k\u0001\u0001\u0006I\u0001\u0019\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019\u0001\b\u0001)A\u0005[\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002@\u0001A\u0003%1\u000f\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\t9\u0002\u0001Q\u0001\n\u0005\r\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005u\u0001\u0002CA\u001b\u0001\u0011\u0005\u0001%a\u000e\t\u0011\u00055\u0003\u0001\"\u0001!\u0003\u001fBq!!\u0014\u0001\t\u0013\t\u0019\u0006\u0003\u0005\u0002b\u0001!\t\u0001IA2\u0011\u001d\t\u0019\b\u0001C!\u0003kBq!a\u001e\u0001\t\u0003\t)\bC\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0006bBA[\u0001\u0011\u0005\u0011Q\u000f\u0002\t\u0003\u000e\u001cW\r\u001d;pe*\u0011\u0011EI\u0001\b]\u0016$xo\u001c:l\u0015\u0005\u0019\u0013!B6bM.\f7c\u0001\u0001&SA\u0011aeJ\u0007\u0002A%\u0011\u0001\u0006\t\u0002\u0015\u0003\n\u001cHO]1diN+'O^3s)\"\u0014X-\u00193\u0011\u0005)jS\"A\u0016\u000b\u00051\u0012\u0013aB7fiJL7m]\u0005\u0003]-\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003!)g\u000e\u001a)pS:$8\u0001A\u000b\u0002eA\u00111GN\u0007\u0002i)\u0011QGI\u0001\bG2,8\u000f^3s\u0013\t9DG\u0001\u0005F]\u0012\u0004v.\u001b8u\u0003%)g\u000e\u001a)pS:$\b%\u0001\btK:$')\u001e4gKJ\u001c\u0016N_3\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u00121!\u00138u\u0003=\u0019XM\u001c3Ck\u001a4WM]*ju\u0016\u0004\u0013A\u0004:fGZ\u0014UO\u001a4feNK'0Z\u0001\u0010e\u0016\u001cgOQ;gM\u0016\u00148+\u001b>fA\u0005A!M]8lKJLE-\u0001\td_:tWm\u0019;j_:\fVo\u001c;bgB\u0011aeR\u0005\u0003\u0011\u0002\u0012\u0001cQ8o]\u0016\u001cG/[8o#V|G/Y:\u0002\u00195,GO]5d!J,g-\u001b=\u0011\u0005-\u0013fB\u0001'Q!\tiU(D\u0001O\u0015\ty\u0005'\u0001\u0004=e>|GOP\u0005\u0003#v\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011+P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f]C\u0016LW.];B\u0011a\u0005\u0001\u0005\u0006_)\u0001\rA\r\u0005\u0006s)\u0001\ra\u000f\u0005\u0006\u0005*\u0001\ra\u000f\u0005\u0006\t*\u0001\ra\u000f\u0005\u0006\u000b*\u0001\rA\u0012\u0005\u0006\u0013*\u0001\rAS\u0001\f]&|7+\u001a7fGR|'/F\u0001a!\t\t\u0007.D\u0001c\u0015\t\u0019G-\u0001\u0005dQ\u0006tg.\u001a7t\u0015\t)g-A\u0002oS>T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jE\nA1+\u001a7fGR|'/\u0001\u0007oS>\u001cV\r\\3di>\u0014\b%A\u0007tKJ4XM]\"iC:tW\r\\\u000b\u0002[B\u0011\u0011M\\\u0005\u0003_\n\u00141cU3sm\u0016\u00148k\\2lKR\u001c\u0005.\u00198oK2\fab]3sm\u0016\u00148\t[1o]\u0016d\u0007%\u0001\u0006qe>\u001cWm]:peN,\u0012a\u001d\t\u0004if\\X\"A;\u000b\u0005Y<\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003qv\n!bY8mY\u0016\u001cG/[8o\u0013\tQXOA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u0001\u0014}\u0013\ti\bEA\u0005Qe>\u001cWm]:pe\u0006Y\u0001O]8dKN\u001cxN]:!\u0003E\u0001(o\\2fgN|'o]*uCJ$X\rZ\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00145\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u001b\ty!\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\u0005g\u0003\u0011)H/\u001b7\n\t\u0005U\u0011q\u0001\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002%A\u0014xnY3tg>\u00148o\u0015;beR,G\rI\u0001\u0014E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]\u000b\u0003\u0003;\u0001B!a\b\u000205\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003d_J,'b\u0001\u0017\u0002()!\u0011\u0011FA\u0016\u0003\u0019I\u0018-\\7fe*\u0011\u0011QF\u0001\u0004G>l\u0017\u0002BA\u0019\u0003C\u0011Q!T3uKJ\fAC\u00197pG.,G\rU3sG\u0016tG/T3uKJ\u0004\u0013!D1eIB\u0013xnY3tg>\u00148\u000f\u0006\u0004\u0002:\u0005}\u0012\u0011\n\t\u0004y\u0005m\u0012bAA\u001f{\t!QK\\5u\u0011\u001d\t\t%\u0006a\u0001\u0003\u0007\nQB\\3x!J|7-Z:t_J\u001c\b\u0003\u0002;\u0002FmL1!a\u0012v\u0005\u0019\u0011UO\u001a4fe\"1\u00111J\u000bA\u0002)\u000bQ\u0003\u001d:pG\u0016\u001c8o\u001c:UQJ,\u0017\r\u001a)sK\u001aL\u00070A\bti\u0006\u0014H\u000f\u0015:pG\u0016\u001c8o\u001c:t)\u0011\tI$!\u0015\t\r\u0005-c\u00031\u0001K)\u0019\tI$!\u0016\u0002`!1\u0011o\u0006a\u0001\u0003/\u0002R!!\u0017\u0002\\ml\u0011a^\u0005\u0004\u0003;:(aA*fc\"1\u00111J\fA\u0002)\u000b\u0001C]3n_Z,\u0007K]8dKN\u001cxN]:\u0015\r\u0005e\u0012QMA5\u0011\u0019\t9\u0007\u0007a\u0001w\u0005Y!/Z7pm\u0016\u001cu.\u001e8u\u0011\u001d\tY\u0007\u0007a\u0001\u0003[\naB]3rk\u0016\u001cHo\u00115b]:,G\u000eE\u0002'\u0003_J1!!\u001d!\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003s\t1A];o\u0003Ay\u0007/\u001a8TKJ4XM]*pG.,G\u000fF\u0003n\u0003{\n\t\t\u0003\u0004\u0002\u0000m\u0001\rAS\u0001\u0005Q>\u001cH\u000f\u0003\u0004\u0002\u0004n\u0001\raO\u0001\u0005a>\u0014H/\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0005\u0003\u0013\u000b)\nE\u0003=\u0003\u0017\u000by)C\u0002\u0002\u000ev\u0012aa\u00149uS>t\u0007cA1\u0002\u0012&\u0019\u00111\u00132\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0011\u001d\t9\n\ba\u0001\u00033\u000b1a[3z!\r\t\u00171T\u0005\u0004\u0003;\u0013'\u0001D*fY\u0016\u001cG/[8o\u0017\u0016L\u0018aE1tg&<gNT3x\u0007>tg.Z2uS>tG\u0003CAR\u0003S\u000bi+!-\u0011\u0007q\n)+C\u0002\u0002(v\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002,v\u0001\r!a$\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0011\u0019\ty+\ba\u0001w\u0006I\u0001O]8dKN\u001cxN\u001d\u0005\b\u0003gk\u0002\u0019AAR\u0003!i\u0017-\u001f\"m_\u000e\\\u0017AB<bW\u0016,\b\u000fK\u0002\u001f\u0003s\u0003B!a/\u0002B6\u0011\u0011Q\u0018\u0006\u0004\u0003\u007f3\u0017\u0001\u00027b]\u001eLA!a1\u0002>\nAqJ^3se&$W\r")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int brokerId;
    private final ConnectionQuotas connectionQuotas;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        ArrayBuffer<Processor> arrayBuffer = this.processors();
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addAll(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        ArrayBuffer<Processor> arrayBuffer = this.processors();
        if (arrayBuffer == null) {
            throw null;
        }
        this.processors().remove(SeqOps.size$(arrayBuffer) - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable)x$17 -> {
            x$17.shutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable)x$18 -> {
                x$18.shutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            int n = 0;
            while (this.isRunning()) {
                try {
                    if (this.nioSelector().select(500L) <= 0) continue;
                    Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
                    while (iter.hasNext() && this.isRunning()) {
                        try {
                            SelectionKey key = iter.next();
                            iter.remove();
                            if (key.isAcceptable()) {
                                Option<SocketChannel> foreach_this;
                                if (this.accept(key) == null) {
                                    throw null;
                                }
                                if (!foreach_this.isEmpty()) {
                                    Processor processor;
                                    int n2;
                                    SocketChannel socketChannel = (SocketChannel)foreach_this.get();
                                    synchronized (this) {
                                        n2 = this.processors().length();
                                    }
                                    int $anonfun$run$1_retriesLeft = n2;
                                    do {
                                        --$anonfun$run$1_retriesLeft;
                                        synchronized (this) {
                                            processor = (Processor)this.processors().apply(n %= this.processors().length());
                                        }
                                        ++n;
                                    } while (!this.assignNewConnection(socketChannel, processor, $anonfun$run$1_retriesLeft == 0));
                                    processor = null;
                                }
                                Object var6_6 = null;
                                continue;
                            }
                            throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                        }
                        catch (Throwable e) {
                            this.error((Function0<String>)(Function0 & Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                        }
                    }
                }
                catch (ControlThrowable controlThrowable) {
                    throw controlThrowable;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Closing server socket and selector.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").toString()).append(new StringBuilder(32).append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").toString()).append(new StringBuilder(39).append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").toString()).append(new StringBuilder(39).append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString()).toString());
            return true;
        }
        return false;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.brokerId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        Object var3_3 = null;
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$run$1(Acceptor $this, IntRef currentProcessorIndex$1, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                currentProcessorIndex$1.elem %= $this.processors().length();
                processor = (Processor)$this.processors().apply(currentProcessorIndex$1.elem);
            }
            ++currentProcessorIndex$1.elem;
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    /*
     * WARNING - void declaration
     */
    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int brokerId, ConnectionQuotas connectionQuotas, String metricPrefix) {
        void $minus$greater$extension_y;
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.brokerId = brokerId;
        this.connectionQuotas = connectionQuotas;
        super(connectionQuotas);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        Object[] objectArray = new Tuple2[1];
        String string = endPoint.listenerName().value();
        String $minus$greater$extension_$this = Processor$.MODULE$.ListenerMetricTag();
        Object var7_8 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
    }

    public static final /* synthetic */ Object $anonfun$run$1$adapted(Acceptor $this, IntRef currentProcessorIndex$1, SocketChannel socketChannel) {
        Acceptor.$anonfun$run$1($this, currentProcessorIndex$1, socketChannel);
        return BoxedUnit.UNIT;
    }
}

