/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import kafka.common.ZkNodeChangeNotificationListener;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.CreateTokenResult;
import kafka.server.DelegationTokenManager$;
import kafka.server.DelegationTokenManager$TokenChangedNotificationHandler$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.DelegationTokenChangeNotificationSequenceZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r]t!\u0002)R\u0011\u00031f!\u0002-R\u0011\u0003I\u0006\"\u00021\u0002\t\u0003\t\u0007b\u00022\u0002\u0005\u0004%\ta\u0019\u0005\u0007Y\u0006\u0001\u000b\u0011\u00023\t\u000f5\f!\u0019!C\u0001G\"1a.\u0001Q\u0001\n\u0011Dqa\\\u0001C\u0002\u0013\u00051\r\u0003\u0004q\u0003\u0001\u0006I\u0001\u001a\u0005\bc\u0006\u0011\r\u0011\"\u0001d\u0011\u0019\u0011\u0018\u0001)A\u0005I\"91/\u0001b\u0001\n\u0003\u0019\u0007B\u0002;\u0002A\u0003%A\rC\u0004v\u0003\t\u0007I\u0011A2\t\rY\f\u0001\u0015!\u0003e\u0011\u001d9\u0018A1A\u0005\u0002\rDa\u0001_\u0001!\u0002\u0013!\u0007bB=\u0002\u0005\u0004%\ta\u0019\u0005\u0007u\u0006\u0001\u000b\u0011\u00023\t\u000fm\f!\u0019!C\u0001y\"9\u0011\u0011A\u0001!\u0002\u0013i\b\u0002CA\u0002\u0003\t\u0007I\u0011\u0001?\t\u000f\u0005\u0015\u0011\u0001)A\u0005{\"9\u0011qA\u0001\u0005\u0002\u0005%\u0001bBA\u001a\u0003\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0017\nA\u0011AA'\u0011\u001d\t9!\u0001C\u0001\u0003'Bq!!\u0017\u0002\t\u0003\tY\u0006C\u0004\u0002\u000e\u0006!\t!a$\t\u000f\u0005\u0005\u0016\u0001\"\u0001\u0002$\u001a)\u0001,\u0015\u0001\u0002`\"Q\u0011\u0011 \u0010\u0003\u0006\u0004%\t!a?\t\u0015\t\raD!A!\u0002\u0013\ti\u0010\u0003\u0006\u0003\u0006y\u0011)\u0019!C\u0001\u0005\u000fA!B!\u0006\u001f\u0005\u0003\u0005\u000b\u0011\u0002B\u0005\u0011)\u00119B\bBC\u0002\u0013\u0005!\u0011\u0004\u0005\u000b\u0005Kq\"\u0011!Q\u0001\n\tm\u0001B\u0003B\u0014=\t\u0015\r\u0011\"\u0001\u0003*!Q!q\u0007\u0010\u0003\u0002\u0003\u0006IAa\u000b\t\r\u0001tB\u0011\u0001B\u001d\u000b\u0019\u0011)E\b\u0001\u0003H\u00151!Q\u000b\u0010\u0001\u0005/*aAa\u001c\u001f\u0001\t]SA\u0002B9=\u0001\u0011\u0019\bC\u0005\u00022y\u0011\r\u0011\"\u0001\u0003x!A!\u0011\u0010\u0010!\u0002\u0013\t9\u0004C\u0005\u0003|y\u0011\r\u0011\"\u0001\u0003~!A!q\u0010\u0010!\u0002\u0013\u0011I\u0007C\u0005\u0003\u0002z\u0011\r\u0011\"\u0001\u0003~!A!1\u0011\u0010!\u0002\u0013\u0011I\u0007C\u0005\u0003\u0006z\u0011\r\u0011\"\u0001\u0003~!A!q\u0011\u0010!\u0002\u0013\u0011I\u0007C\u0005\u0003\nz\u0011\r\u0011\"\u0003\u0003\f\"A!1\u0013\u0010!\u0002\u0013\u0011i\tC\u0005\u0003\u0016z\u0001\r\u0011\"\u0003\u0003\u0018\"I!1\u0015\u0010A\u0002\u0013%!Q\u0015\u0005\t\u0005Ws\u0002\u0015)\u0003\u0003\u001a\"9!Q\u0016\u0010\u0005\u0002\t=\u0006b\u0002BY=\u0011\u0005!q\u0016\u0005\b\u0005gsB\u0011\u0002BX\u0011\u001d\u0011)L\bC\u0005\u0005oCqA!0\u001f\t\u0013\u0011y\fC\u0004\u0003Dz!IA!2\t\u000f\teg\u0004\"\u0001\u0003\\\"9!\u0011\u001f\u0010\u0005\u0002\tM\bbBB\n=\u0011%1Q\u0003\u0005\b\u00073qB\u0011BB\u000e\u0011\u001d\u0019yB\bC\u0005\u0007CAqa!\u0007\u001f\t\u0003\u0019I\u0003C\u0004\u0004\u001ay!Ia!\f\t\u000f\rEb\u0004\"\u0001\u00044!911\t\u0010\u0005\n\r\u0015\u0003bBB%=\u0011%11\n\u0005\b\u0007\u001frB\u0011\u0001BX\u0011\u001d\u0019\tF\bC\u0001\u0007'Bqaa\u0016\u001f\t\u0003\u0019IfB\u0004\u0004`yA\ta!\u0019\u0007\u000f\r\rd\u0004#\u0001\u0004f!1\u0001-\u0014C\u0001\u0007[Bqaa\u001cN\t\u0003\u001a\t(\u0001\fEK2,w-\u0019;j_:$vn[3o\u001b\u0006t\u0017mZ3s\u0015\t\u00116+\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0006)1.\u00194lC\u000e\u0001\u0001CA,\u0002\u001b\u0005\t&A\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u0014\u0005\u0005Q\u0006CA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002-\u0006!B)\u001a4bk2$\b*\\1d\u00032<wN]5uQ6,\u0012\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\fA\u0001\\1oO*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\u0019\u0019FO]5oO\u0006)B)\u001a4bk2$\b*\\1d\u00032<wN]5uQ6\u0004\u0013\u0001C(x]\u0016\u00148*Z=\u0002\u0013=;h.\u001a:LKf\u0004\u0013a\u0003*f]\u0016<XM]:LKf\fABU3oK^,'o]&fs\u0002\n\u0011#S:tk\u0016$\u0016.\\3ti\u0006l\u0007oS3z\u0003II5o];f)&lWm\u001d;b[B\\U-\u001f\u0011\u0002\u001f5\u000b\u0007\u0010V5nKN$\u0018-\u001c9LKf\f\u0001#T1y)&lWm\u001d;b[B\\U-\u001f\u0011\u0002%\u0015C\b/\u001b:z)&lWm\u001d;b[B\\U-_\u0001\u0014\u000bb\u0004\u0018N]=US6,7\u000f^1na.+\u0017\u0010I\u0001\u000b)>\\WM\\%e\u0017\u0016L\u0018a\u0003+pW\u0016t\u0017\nZ&fs\u0002\n!BV3sg&|gnS3z\u0003-1VM]:j_:\\U-\u001f\u0011\u0002\u001d\r+(O]3oiZ+'o]5p]V\tQ\u0010\u0005\u0002\\}&\u0011q\u0010\u0018\u0002\u0004\u0013:$\u0018aD\"veJ,g\u000e\u001e,feNLwN\u001c\u0011\u0002\u001d\u0015\u0013(o\u001c:US6,7\u000f^1na\u0006yQI\u001d:peRKW.Z:uC6\u0004\b%\u0001\u0006de\u0016\fG/\u001a%nC\u000e$b!a\u0003\u0002\u0018\u0005=\u0002#B.\u0002\u000e\u0005E\u0011bAA\b9\n)\u0011I\u001d:bsB\u00191,a\u0005\n\u0007\u0005UAL\u0001\u0003CsR,\u0007bBA\r/\u0001\u0007\u00111D\u0001\bi>\\WM\\%e!\u0011\ti\"a\u000b\u000f\t\u0005}\u0011q\u0005\t\u0004\u0003CaVBAA\u0012\u0015\r\t)#V\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%B,\u0001\u0004Qe\u0016$WMZ\u0005\u0004W\u00065\"bAA\u00159\"9\u0011\u0011G\fA\u0002\u0005m\u0011!C:fGJ,GoS3z\u0003=\u0019'/Z1uKN+7M]3u\u0017\u0016LH\u0003BA\u001c\u0003\u000f\u0002B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0004def\u0004Ho\u001c\u0006\u0003\u0003\u0003\nQA[1wCbLA!!\u0012\u0002<\tI1+Z2sKR\\U-\u001f\u0005\b\u0003\u0013B\u0002\u0019AA\u0006\u0003!YW-\u001f2zi\u0016\u001c\u0018\u0001E2sK\u0006$XMQ1tKZ\"\u0004*T!D)\u0019\tY\"a\u0014\u0002R!9\u0011\u0011D\rA\u0002\u0005m\u0001bBA\u00193\u0001\u0007\u0011q\u0007\u000b\u0007\u0003\u0017\t)&a\u0016\t\u000f\u0005e!\u00041\u0001\u0002\u001c!9\u0011\u0011\u0007\u000eA\u0002\u0005]\u0012a\u0005;p\u0015N|gnQ8na\u0006$\u0018N\u00197f\u001b\u0006\u0004H\u0003BA/\u0003S\u0002\u0002\"!\b\u0002`\u0005m\u00111M\u0005\u0005\u0003C\niCA\u0002NCB\u00042aWA3\u0013\r\t9\u0007\u0018\u0002\u0004\u0003:L\bbBA67\u0001\u0007\u0011QN\u0001\u0006i>\\WM\u001c\t\u0005\u0003_\nI)\u0004\u0002\u0002r)!\u00111OA;\u0003)!W\r\\3hCRLwN\u001c\u0006\u0005\u0003W\n9H\u0003\u0003\u0002z\u0005m\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\t\u0005u\u0014qP\u0001\u0007G>lWn\u001c8\u000b\u0007Q\u000b\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015AB1qC\u000eDWM\u0003\u0002\u0002\b\u0006\u0019qN]4\n\t\u0005-\u0015\u0011\u000f\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\u0006IaM]8n\u0005f$Xm\u001d\u000b\u0005\u0003#\u000bi\nE\u0003\\\u0003'\u000b9*C\u0002\u0002\u0016r\u0013aa\u00149uS>t\u0007\u0003BA8\u00033KA!a'\u0002r\t\u0001Bk\\6f]&sgm\u001c:nCRLwN\u001c\u0005\b\u0003?c\u0002\u0019AA\u0006\u0003\u0015\u0011\u0017\u0010^3t\u0003-1\u0017\u000e\u001c;feR{7.\u001a8\u0015\u0015\u0005\u0015\u00161VA^\u0003'\f)\u000eE\u0002\\\u0003OK1!!+]\u0005\u001d\u0011un\u001c7fC:Dq!!,\u001e\u0001\u0004\ty+\u0001\nsKF,Xm\u001d;fIB\u0013\u0018N\\2ja\u0006d\u0007\u0003BAY\u0003ok!!a-\u000b\t\u0005U\u0016qO\u0001\u0005CV$\b.\u0003\u0003\u0002:\u0006M&AD&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\u0005\b\u0003{k\u0002\u0019AA`\u0003\u0019ywO\\3sgB)1,a%\u0002BB1\u00111YAg\u0003_sA!!2\u0002J:!\u0011\u0011EAd\u0013\u0005i\u0016bAAf9\u00069\u0001/Y2lC\u001e,\u0017\u0002BAh\u0003#\u0014A\u0001T5ti*\u0019\u00111\u001a/\t\u000f\u0005-T\u00041\u0001\u0002\u0018\"9\u0011q[\u000fA\u0002\u0005e\u0017AD1vi\"|'/\u001b>f)>\\WM\u001c\t\b7\u0006m\u00171DAS\u0013\r\ti\u000e\u0018\u0002\n\rVt7\r^5p]F\u001abA\b.\u0002b\u00065\b\u0003BAr\u0003Sl!!!:\u000b\u0007\u0005\u001d8+A\u0003vi&d7/\u0003\u0003\u0002l\u0006\u0015(a\u0002'pO\u001eLgn\u001a\t\u0005\u0003_\f)0\u0004\u0002\u0002r*\u0019\u00111_*\u0002\u000f5,GO]5dg&!\u0011q_Ay\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u0007G>tg-[4\u0016\u0005\u0005u\bcA,\u0002\u0000&\u0019!\u0011A)\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003)!xn[3o\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0005\u0013\u0001BAa\u0003\u0003\u00125\u0011!Q\u0002\u0006\u0005\u0005\u001f\t\t(A\u0005j]R,'O\\1mg&!!1\u0003B\u0007\u0005Q!U\r\\3hCRLwN\u001c+pW\u0016t7)Y2iK\u0006YAo\\6f]\u000e\u000b7\r[3!\u0003\u0011!\u0018.\\3\u0016\u0005\tm\u0001\u0003\u0002B\u000f\u0005Ci!Aa\b\u000b\t\u0005\u001d\u00181P\u0005\u0005\u0005G\u0011yB\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001\u0003>l\u00072LWM\u001c;\u0016\u0005\t-\u0002\u0003\u0002B\u0017\u0005gi!Aa\f\u000b\u0007\tE2+\u0001\u0002{W&!!Q\u0007B\u0018\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006I!p[\"mS\u0016tG\u000f\t\u000b\u000b\u0005w\u0011iDa\u0010\u0003B\t\r\u0003CA,\u001f\u0011\u001d\tIp\na\u0001\u0003{DqA!\u0002(\u0001\u0004\u0011I\u0001C\u0004\u0003\u0018\u001d\u0002\rAa\u0007\t\u000f\t\u001dr\u00051\u0001\u0003,\t12I]3bi\u0016\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0004\\\u00037\u0014IEa\u0014\u0011\u0007]\u0013Y%C\u0002\u0003NE\u0013\u0011c\u0011:fCR,Gk\\6f]J+7/\u001e7u!\rY&\u0011K\u0005\u0004\u0005'b&\u0001B+oSR\u0014QCU3oK^\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0005\\\u00053\u0012iF!\u001b\u0003P%\u0019!1\f/\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003\u0002B0\u0005Kj!A!\u0019\u000b\t\t\r\u00141P\u0001\taJ|Go\\2pY&!!q\rB1\u0005\u0019)%O]8sgB\u00191La\u001b\n\u0007\t5DL\u0001\u0003M_:<'AF#ya&\u0014XMU3ta>t7/Z\"bY2\u0014\u0017mY6\u00031\u0011+7o\u0019:jE\u0016\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0005\\\u00053\u0012iF!\u001e\u0003PA1\u00111YAg\u0003[*\"!a\u000e\u0002\u0015M,7M]3u\u0017\u0016L\b%\u0001\tu_.,g.T1y\u0019&4W\r^5nKV\u0011!\u0011N\u0001\u0012i>\\WM\\'bq2Kg-\u001a;j[\u0016\u0004\u0013!\u00063fM\u0006,H\u000e\u001e+pW\u0016t'+\u001a8foRKW.Z\u0001\u0017I\u00164\u0017-\u001e7u)>\\WM\u001c*f]\u0016<H+[7fA\u0005ABo\\6f]J+Wn\u001c<feN\u001b\u0017M\\%oi\u0016\u0014h/\u00197\u00023Q|7.\u001a8SK6|g/\u001a:TG\u0006t\u0017J\u001c;feZ\fG\u000eI\u0001\u0005Y>\u001c7.\u0006\u0002\u0003\u000eB\u0019QMa$\n\u0007\tEeM\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\u0014i>\\WM\\\"iC:<W\rT5ti\u0016tWM]\u000b\u0003\u00053\u0003BAa'\u0003 6\u0011!Q\u0014\u0006\u0004\u0003{\u001a\u0016\u0002\u0002BQ\u0005;\u0013\u0001EW6O_\u0012,7\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u0019&\u001cH/\u001a8fe\u00069Bo\\6f]\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u0005\u0005\u001f\u00129\u000bC\u0005\u0003*^\n\t\u00111\u0001\u0003\u001a\u0006\u0019\u0001\u0010J\u0019\u0002)Q|7.\u001a8DQ\u0006tw-\u001a'jgR,g.\u001a:!\u0003\u001d\u0019H/\u0019:ukB$\"Aa\u0014\u0002\u0011MDW\u000f\u001e3po:\f\u0011\u0002\\8bI\u000e\u000b7\r[3\u0002\u001d\u001d,G\u000fV8lK:4%o\\7[WR!!\u0011\u0018B^!\u0015Y\u00161SA7\u0011\u001d\tI\u0002\u0010a\u0001\u00037\t1\"\u001e9eCR,7)Y2iKR!!q\nBa\u0011\u001d\tY'\u0010a\u0001\u0003[\nq\u0003\u001d:fa\u0006\u0014XmU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\t\u001d'Q\u001b\t\t\u0003;\ty&a\u0007\u0003JB!!1\u001aBi\u001b\t\u0011iM\u0003\u0003\u0003P\u0006]\u0014!B:de\u0006l\u0017\u0002\u0002Bj\u0005\u001b\u0014qbU2sC6\u001c%/\u001a3f]RL\u0017\r\u001c\u0005\b\u0005/t\u0004\u0019AA\u000e\u0003)AW.Y2TiJLgnZ\u0001\fGJ,\u0017\r^3U_.,g\u000e\u0006\u0006\u0003P\tu'\u0011\u001dBs\u0005SDqAa8@\u0001\u0004\ty+A\u0003po:,'\u000fC\u0004\u0003d~\u0002\r!!1\u0002\u0011I,g.Z<feNDqAa:@\u0001\u0004\u0011I'A\u0007nCbd\u0015NZ3US6,Wj\u001d\u0005\b\u0005W|\u0004\u0019\u0001Bw\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0002\u0003p\"j\u0011AH\u0001\u000be\u0016tWm\u001e+pW\u0016tGC\u0003B(\u0005k\u0014Ip!\u0003\u0004\u000e!9!q\u001f!A\u0002\u0005=\u0016!\u00039sS:\u001c\u0017\u000e]1m\u0011\u001d\u0011Y\u0010\u0011a\u0001\u0005{\fA\u0001[7bGB!!q`B\u0003\u001b\t\u0019\tAC\u0002\u0004\u0004!\f1A\\5p\u0013\u0011\u00199a!\u0001\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0004\f\u0001\u0003\rA!\u001b\u0002\u001fI,g.Z<MS\u001a,G+[7f\u001bNDqaa\u0004A\u0001\u0004\u0019\t\"A\u0007sK:,woQ1mY\n\f7m\u001b\t\u0004\u0005_L\u0013aC;qI\u0006$X\rV8lK:$BAa\u0014\u0004\u0018!9\u00111N!A\u0002\u00055\u0014\u0001C4fiR{7.\u001a8\u0015\t\te6Q\u0004\u0005\b\u0005w\u0014\u0005\u0019\u0001B\u007f\u00039\tG\u000e\\8xK\u0012$vNU3oK^$b!!*\u0004$\r\u0015\u0002b\u0002B|\u0007\u0002\u0007\u0011q\u0016\u0005\b\u0007O\u0019\u0005\u0019AAL\u0003%!xn[3o\u0013:4w\u000e\u0006\u0003\u0003:\u000e-\u0002bBA\r\t\u0002\u0007\u00111\u0004\u000b\u0005\u0003[\u001ay\u0003C\u0004\u0004(\u0015\u0003\r!a&\u0002\u0017\u0015D\b/\u001b:f)>\\WM\u001c\u000b\u000b\u0005\u001f\u001a)da\u000e\u0004:\ru\u0002b\u0002B|\r\u0002\u0007\u0011q\u0016\u0005\b\u0005w4\u0005\u0019\u0001B\u007f\u0011\u001d\u0019YD\u0012a\u0001\u0005S\n\u0001#\u001a=qSJ,G*\u001b4f)&lW-T:\t\u000f\r}b\t1\u0001\u0004B\u00051R\r\u001f9je\u0016\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0002\u0003p*\n1B]3n_Z,Gk\\6f]R!!qJB$\u0011\u001d\tIb\u0012a\u0001\u00037\t1B]3n_Z,7)Y2iKR!!qJB'\u0011\u001d\tI\u0002\u0013a\u0001\u00037\tA\"\u001a=qSJ,Gk\\6f]N\facZ3u\u00032dGk\\6f]&sgm\u001c:nCRLwN\u001c\u000b\u0003\u0007+\u0002b!a1\u0002N\u0006]\u0015!C4fiR{7.\u001a8t)\u0011\u0011)ha\u0017\t\u000f\u0005\u00056\n1\u0001\u0004^A91,a7\u0002\u0018\u0006\u0015\u0016a\b+pW\u0016t7\t[1oO\u0016$gj\u001c;jM&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7feB\u0019!q^'\u0003?Q{7.\u001a8DQ\u0006tw-\u001a3O_RLg-[2bi&|g\u000eS1oI2,'o\u0005\u0003N5\u000e\u001d\u0004\u0003\u0002BN\u0007SJAaa\u001b\u0003\u001e\n\u0019bj\u001c;jM&\u001c\u0017\r^5p]\"\u000bg\u000e\u001a7feR\u00111\u0011M\u0001\u0014aJ|7-Z:t\u001d>$\u0018NZ5dCRLwN\u001c\u000b\u0005\u0005\u001f\u001a\u0019\bC\u0004\u0004v=\u0003\r!a\u0003\u0002\u0019Q|7.\u001a8JI\nKH/Z:")
public class DelegationTokenManager
implements KafkaMetricsGroup {
    private volatile DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$module;
    private final KafkaConfig config;
    private final DelegationTokenCache tokenCache;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final SecretKey secretKey;
    private final long tokenMaxLifetime;
    private final long defaultTokenRenewTime;
    private final long tokenRemoverScanInterval;
    private final Object kafka$server$DelegationTokenManager$$lock;
    private ZkNodeChangeNotificationListener tokenChangeListener;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean filterToken(KafkaPrincipal kafkaPrincipal, Option<List<KafkaPrincipal>> option, TokenInformation tokenInformation, Function1<String, Object> function1) {
        if (!option.isEmpty()) {
            boolean bl;
            block6: {
                List list = (List)option.get();
                if (list == null) {
                    throw null;
                }
                List filterToken_exists_these = list;
                while (!filterToken_exists_these.isEmpty()) {
                    KafkaPrincipal kafkaPrincipal2 = (KafkaPrincipal)filterToken_exists_these.head();
                    if (tokenInformation.ownerOrRenewer(kafkaPrincipal2)) {
                        bl = true;
                        break block6;
                    }
                    filterToken_exists_these = (List)filterToken_exists_these.tail();
                }
                bl = false;
            }
            Object var4_4 = null;
            if (!bl) {
                return false;
            }
        }
        if (tokenInformation.ownerOrRenewer(kafkaPrincipal)) {
            return true;
        }
        return BoxesRunTime.unboxToBoolean((Object)function1.apply((Object)tokenInformation.tokenId()));
    }

    public static Option<TokenInformation> fromBytes(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.fromBytes(byArray);
    }

    public static scala.collection.immutable.Map<String, Object> toJsonCompatibleMap(DelegationToken delegationToken) {
        return DelegationTokenManager$.MODULE$.toJsonCompatibleMap(delegationToken);
    }

    public static byte[] createHmac(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createHmac(string, secretKey);
    }

    public static String createBase64HMAC(String string, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createBase64HMAC(string, secretKey);
    }

    public static SecretKey createSecretKey(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.createSecretKey(byArray);
    }

    public static byte[] createHmac(String string, String string2) {
        return DelegationTokenManager$.MODULE$.createHmac(string, string2);
    }

    public static int ErrorTimestamp() {
        return DelegationTokenManager$.MODULE$.ErrorTimestamp();
    }

    public static int CurrentVersion() {
        return DelegationTokenManager$.MODULE$.CurrentVersion();
    }

    public static String VersionKey() {
        return DelegationTokenManager$.MODULE$.VersionKey();
    }

    public static String TokenIdKey() {
        return DelegationTokenManager$.MODULE$.TokenIdKey();
    }

    public static String ExpiryTimestampKey() {
        return DelegationTokenManager$.MODULE$.ExpiryTimestampKey();
    }

    public static String MaxTimestampKey() {
        return DelegationTokenManager$.MODULE$.MaxTimestampKey();
    }

    public static String IssueTimestampKey() {
        return DelegationTokenManager$.MODULE$.IssueTimestampKey();
    }

    public static String RenewersKey() {
        return DelegationTokenManager$.MODULE$.RenewersKey();
    }

    public static String OwnerKey() {
        return DelegationTokenManager$.MODULE$.OwnerKey();
    }

    public static String DefaultHmacAlgorithm() {
        return DelegationTokenManager$.MODULE$.DefaultHmacAlgorithm();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler() {
        if (this.TokenChangedNotificationHandler$module == null) {
            this.TokenChangedNotificationHandler$lzycompute$1();
        }
        return this.TokenChangedNotificationHandler$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public Time time() {
        return this.time;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }

    public long tokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long defaultTokenRenewTime() {
        return this.defaultTokenRenewTime;
    }

    public long tokenRemoverScanInterval() {
        return this.tokenRemoverScanInterval;
    }

    public Object kafka$server$DelegationTokenManager$$lock() {
        return this.kafka$server$DelegationTokenManager$$lock;
    }

    private ZkNodeChangeNotificationListener tokenChangeListener() {
        return this.tokenChangeListener;
    }

    private void tokenChangeListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.tokenChangeListener = x$1;
    }

    public void startup() {
        if (this.config().tokenAuthEnabled()) {
            this.zkClient().createDelegationTokenPaths();
            this.loadCache();
            this.tokenChangeListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), DelegationTokenChangeNotificationZNode$.MODULE$.path(), DelegationTokenChangeNotificationSequenceZNode$.MODULE$.SequenceNumberPrefix(), this.TokenChangedNotificationHandler(), 900000L, Time.SYSTEM));
            this.tokenChangeListener().init();
        }
    }

    public void shutdown() {
        if (this.config().tokenAuthEnabled() && this.tokenChangeListener() != null) {
            this.tokenChangeListener().close();
            return;
        }
    }

    private void loadCache() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Seq<String> tokens = this.zkClient().getChildren(DelegationTokensZNode$.MODULE$.path());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading the token cache. Total token count: ").append(tokens.length()).toString());
            tokens.foreach((Function1 & Serializable)tokenId -> {
                DelegationTokenManager.$anonfun$loadCache$2(this, tokenId);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Option<DelegationToken> kafka$server$DelegationTokenManager$$getTokenFromZk(String tokenId) {
        None$ none$;
        Option<TokenInformation> option = this.zkClient().getDelegationTokenInfo(tokenId);
        if (option instanceof Some) {
            TokenInformation tokenInformation = (TokenInformation)((Some)option).value();
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            none$ = new Some((Object)new DelegationToken(tokenInformation, hmac));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public void kafka$server$DelegationTokenManager$$updateCache(DelegationToken token) {
        String hmacString = token.hmacAsBase64String();
        scala.collection.immutable.Map<String, ScramCredential> scramCredentialMap = this.prepareScramCredentials(hmacString);
        this.tokenCache().updateCache(token, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(scramCredentialMap).asJava());
    }

    private scala.collection.immutable.Map<String, ScramCredential> prepareScramCredentials(String hmacString) {
        scala.collection.mutable.Map scramCredentialMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        for (ScramMechanism scramMechanism : ScramMechanism.values()) {
            scramCredentialMap.update((Object)scramMechanism.mechanismName(), (Object)DelegationTokenManager.scramCredential$1(scramMechanism, hmacString));
        }
        Object var3_3 = null;
        return scramCredentialMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void createToken(KafkaPrincipal owner, List<KafkaPrincipal> renewers, long maxLifeTimeMs, Function1<CreateTokenResult, BoxedUnit> responseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            responseCallback.apply((Object)new CreateTokenResult(-1L, -1L, -1L, "", (byte[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), Errors.DELEGATION_TOKEN_AUTH_DISABLED));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            String tokenId = CoreUtils$.MODULE$.generateUuidAsBase64();
            long issueTimeStamp = this.time().milliseconds();
            long maxLifeTime = maxLifeTimeMs <= 0L ? this.tokenMaxLifetime() : Math.min(maxLifeTimeMs, this.tokenMaxLifetime());
            long maxLifeTimeStamp = issueTimeStamp + maxLifeTime;
            long expiryTimeStamp = Math.min(maxLifeTimeStamp, issueTimeStamp + this.defaultTokenRenewTime());
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimeStamp, maxLifeTimeStamp, expiryTimeStamp);
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            DelegationToken token = new DelegationToken(tokenInfo, hmac);
            this.updateToken(token);
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Created a delegation token: ").append(tokenId).append(" for owner: ").append(owner).toString());
            responseCallback.apply((Object)new CreateTokenResult(issueTimeStamp, expiryTimeStamp, maxLifeTimeStamp, tokenId, hmac, Errors.NONE));
            return;
        }
    }

    public void renewToken(KafkaPrincipal principal, ByteBuffer hmac, long renewLifeTimeMs, Function2<Errors, Object, BoxedUnit> renewCallback) {
        if (!this.config().tokenAuthEnabled()) {
            renewCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)-1L);
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                long now = this.time().milliseconds();
                TokenInformation tokenInfo = token.tokenInfo();
                if (!this.allowedToRenew(principal, tokenInfo)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)-1L);
                } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)-1L);
                } else {
                    long renewLifeTime = renewLifeTimeMs < 0L ? this.defaultTokenRenewTime() : renewLifeTimeMs;
                    long renewTimeStamp = now + renewLifeTime;
                    long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), renewTimeStamp);
                    tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                    this.updateToken(token);
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Delegation token renewed for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)renewCallback.apply((Object)Errors.NONE, (Object)expiryTimeStamp);
                }
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_3 = (BoxedUnit)renewCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)-1L);
            } else {
                throw new MatchError(option);
            }
            return;
        }
    }

    private void updateToken(DelegationToken token) {
        this.zkClient().setOrCreateDelegationToken(token);
        this.kafka$server$DelegationTokenManager$$updateCache(token);
        this.zkClient().createTokenChangeNotification(token.tokenInfo().tokenId());
    }

    private Option<DelegationToken> getToken(ByteBuffer hmac) {
        None$ none$;
        try {
            byte[] byteArray = new byte[hmac.remaining()];
            hmac.get(byteArray);
            String base64Pwd = Base64.getEncoder().encodeToString(byteArray);
            TokenInformation tokenInfo = this.tokenCache().tokenForHmac(base64Pwd);
            if (tokenInfo != null) {
                return new Some((Object)new DelegationToken(tokenInfo, byteArray));
            }
            none$ = None$.MODULE$;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Exception while getting token for hmac", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private boolean allowedToRenew(KafkaPrincipal principal, TokenInformation tokenInfo) {
        return principal.equals((Object)tokenInfo.owner()) || ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewers()).asScala()).toList().contains((Object)principal);
    }

    public Option<DelegationToken> getToken(String tokenId) {
        TokenInformation tokenInfo = this.tokenCache().token(tokenId);
        if (tokenInfo != null) {
            return new Some((Object)this.getToken(tokenInfo));
        }
        return None$.MODULE$;
    }

    private DelegationToken getToken(TokenInformation tokenInfo) {
        byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenInfo.tokenId(), this.secretKey());
        return new DelegationToken(tokenInfo, hmac);
    }

    public void expireToken(KafkaPrincipal principal, ByteBuffer hmac, long expireLifeTimeMs, Function2<Errors, Object, BoxedUnit> expireResponseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)-1L);
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                TokenInformation tokenInfo = token.tokenInfo();
                long now = this.time().milliseconds();
                if (!this.allowedToRenew(principal, tokenInfo)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)-1L);
                } else if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)-1L);
                } else if (expireLifeTimeMs < 0L) {
                    this.removeToken(tokenInfo.tokenId());
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Token expired for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)now);
                } else {
                    long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), now + expireLifeTimeMs);
                    tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                    this.updateToken(token);
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Updated expiry time for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
                    BoxedUnit cfr_ignored_3 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.NONE, (Object)expiryTimeStamp);
                }
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit cfr_ignored_4 = (BoxedUnit)expireResponseCallback.apply((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)-1L);
            } else {
                throw new MatchError(option);
            }
            return;
        }
    }

    private void removeToken(String tokenId) {
        this.zkClient().deleteDelegationToken(tokenId);
        this.kafka$server$DelegationTokenManager$$removeCache(tokenId);
        this.zkClient().createTokenChangeNotification(tokenId);
    }

    public void kafka$server$DelegationTokenManager$$removeCache(String tokenId) {
        this.tokenCache().removeCache(tokenId);
    }

    public void expireTokens() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            List list = this.getAllTokenInformation();
            if (list == null) {
                throw null;
            }
            List foreach_these = list;
            while (!foreach_these.isEmpty()) {
                TokenInformation tokenInformation = (TokenInformation)foreach_these.head();
                DelegationTokenManager.$anonfun$expireTokens$1(this, tokenInformation);
                foreach_these = (List)foreach_these.tail();
            }
            return;
        }
    }

    public List<TokenInformation> getAllTokenInformation() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.tokenCache().tokens()).asScala()).toList();
    }

    /*
     * WARNING - void declaration
     */
    public List<DelegationToken> getTokens(Function1<TokenInformation, Object> filterToken) {
        Nil$ nil$;
        Object var10_19;
        Nil$ nil$2;
        Object var15_8;
        Object var14_7;
        List list;
        Object var23_16;
        Object var22_15;
        Object var21_14;
        Object var20_13;
        Object var19_12;
        Object var18_11;
        Object var17_10;
        Object var16_9;
        Nil$ nil$3;
        List list2 = this.getAllTokenInformation();
        if (list2 == null) {
            throw null;
        }
        List filter_this = list2;
        boolean filter_filterImpl_isFlipped = false;
        List filter_filterImpl_noneIn$1_l = filter_this;
        while (true) {
            if (filter_filterImpl_noneIn$1_l.isEmpty()) {
                nil$3 = Nil$.MODULE$;
                break;
            }
            Object filter_filterImpl_noneIn$1_h = filter_filterImpl_noneIn$1_l.head();
            List filter_filterImpl_noneIn$1_t = (List)filter_filterImpl_noneIn$1_l.tail();
            if (BoxesRunTime.unboxToBoolean((Object)filterToken.apply(filter_filterImpl_noneIn$1_h)) != filter_filterImpl_isFlipped) {
                List list3;
                block14: {
                    List filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next;
                    List filter_filterImpl_noneIn$1_allIn$1_remaining = filter_filterImpl_noneIn$1_t;
                    while (true) {
                        if (filter_filterImpl_noneIn$1_allIn$1_remaining.isEmpty()) {
                            list3 = filter_filterImpl_noneIn$1_l;
                            break block14;
                        }
                        Object filter_filterImpl_noneIn$1_allIn$1_x = filter_filterImpl_noneIn$1_allIn$1_remaining.head();
                        if (BoxesRunTime.unboxToBoolean((Object)filterToken.apply(filter_filterImpl_noneIn$1_allIn$1_x)) == filter_filterImpl_isFlipped) break;
                        filter_filterImpl_noneIn$1_allIn$1_remaining = (List)filter_filterImpl_noneIn$1_allIn$1_remaining.tail();
                    }
                    .colon.colon filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newHead = new .colon.colon(filter_filterImpl_noneIn$1_l.head(), (List)Nil$.MODULE$);
                    .colon.colon filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newHead;
                    for (List filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterImpl_noneIn$1_l.tail(); filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess != filter_filterImpl_noneIn$1_allIn$1_remaining; filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess.tail()) {
                        .colon.colon filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess.head(), (List)Nil$.MODULE$);
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem);
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem;
                    }
                    List filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterImpl_noneIn$1_allIn$1_remaining.tail();
                    while (!filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.isEmpty()) {
                        Object filter_filterImpl_noneIn$1_allIn$1_partialFill$1_head = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.head();
                        if (BoxesRunTime.unboxToBoolean((Object)filterToken.apply(filter_filterImpl_noneIn$1_allIn$1_partialFill$1_head)) != filter_filterImpl_isFlipped) {
                            filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.tail();
                            continue;
                        }
                        while (filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy != filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next) {
                            .colon.colon filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy.head(), (List)Nil$.MODULE$);
                            filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem);
                            filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem;
                            filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy.tail();
                        }
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.tail();
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.tail();
                    }
                    if (!filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy.isEmpty()) {
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq(filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy);
                    }
                    list3 = var16_9;
                    var16_9 = null;
                    var17_10 = null;
                    var18_11 = null;
                    var19_12 = null;
                    var20_13 = null;
                    var21_14 = null;
                    var22_15 = null;
                    var23_16 = null;
                }
                list = list3;
                nil$3 = list;
                var14_7 = null;
                var15_8 = null;
                var16_9 = null;
                var17_10 = null;
                var18_11 = null;
                var19_12 = null;
                var20_13 = null;
                var21_14 = null;
                var22_15 = null;
                var23_16 = null;
                list = null;
                break;
            }
            filter_filterImpl_noneIn$1_l = filter_filterImpl_noneIn$1_t;
        }
        Nil$ nil$4 = nil$2 = nil$3;
        Object var11_4 = null;
        Object var12_5 = null;
        Object var13_6 = null;
        var14_7 = null;
        var15_8 = null;
        var16_9 = null;
        var17_10 = null;
        var18_11 = null;
        var19_12 = null;
        var20_13 = null;
        var21_14 = null;
        var22_15 = null;
        var23_16 = null;
        list = null;
        nil$2 = null;
        Nil$ filter_filterImpl_result = nil$4;
        Statics.releaseFence();
        void v4 = var10_19;
        Object var8_2 = null;
        var10_19 = null;
        void map_this = v4;
        if (map_this == Nil$.MODULE$) {
            nil$ = Nil$.MODULE$;
        } else {
            void var3_23;
            .colon.colon map_h;
            TokenInformation tokenInformation = (TokenInformation)map_this.head();
            .colon.colon map_t = map_h = new .colon.colon((Object)this.getToken(tokenInformation), (List)Nil$.MODULE$);
            for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                tokenInformation = (TokenInformation)map_rest.head();
                .colon.colon map_nx = new .colon.colon((Object)this.getToken(tokenInformation), (List)Nil$.MODULE$);
                map_t.next_$eq((List)map_nx);
                map_t = map_nx;
            }
            Statics.releaseFence();
            nil$ = var3_23;
        }
        return nil$;
    }

    private final void TokenChangedNotificationHandler$lzycompute$1() {
        synchronized (this) {
            if (this.TokenChangedNotificationHandler$module == null) {
                this.TokenChangedNotificationHandler$module = new DelegationTokenManager$TokenChangedNotificationHandler$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$loadCache$2(DelegationTokenManager $this, String tokenId) {
        try {
            Option<DelegationToken> option = $this.kafka$server$DelegationTokenManager$$getTokenFromZk(tokenId);
            if (option instanceof Some) {
                DelegationToken token = (DelegationToken)((Some)option).value();
                $this.kafka$server$DelegationTokenManager$$updateCache(token);
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError(option);
            }
        }
        catch (Throwable ex) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Error while getting Token for tokenId: ").append(tokenId).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> ex);
        }
    }

    private static final ScramCredential scramCredential$1(ScramMechanism mechanism, String hmacString$1) {
        return new ScramFormatter(mechanism).generateCredential(hmacString$1, mechanism.minIterations());
    }

    public static final /* synthetic */ void $anonfun$expireTokens$1(DelegationTokenManager $this, TokenInformation tokenInfo) {
        long now = $this.time().milliseconds();
        if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Delegation token expired for token: ").append(tokenInfo.tokenId()).append(" for owner: ").append(tokenInfo.owner()).toString());
            $this.removeToken(tokenInfo.tokenId());
        }
    }

    public DelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        this.config = config;
        this.tokenCache = tokenCache;
        this.time = time;
        this.zkClient = zkClient;
        this.logIdent_$eq(new StringBuilder(28).append("[Token Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        byte[] keyBytes = config.tokenAuthEnabled() ? config.delegationTokenMasterKey().value().getBytes(StandardCharsets.UTF_8) : null;
        this.secretKey = keyBytes == null || keyBytes.length == 0 ? null : DelegationTokenManager$.MODULE$.createSecretKey(keyBytes);
        this.tokenMaxLifetime = BoxesRunTime.unboxToLong((Object)config.delegationTokenMaxLifeMs());
        this.defaultTokenRenewTime = BoxesRunTime.unboxToLong((Object)config.delegationTokenExpiryTimeMs());
        this.tokenRemoverScanInterval = BoxesRunTime.unboxToLong((Object)config.delegationTokenExpiryCheckIntervalMs());
        this.kafka$server$DelegationTokenManager$$lock = new Object();
        this.tokenChangeListener = null;
    }

    public static final /* synthetic */ Object $anonfun$prepareScramCredentials$1$adapted(scala.collection.mutable.Map scramCredentialMap$1, String hmacString$1, ScramMechanism mechanism) {
        scramCredentialMap$1.update((Object)mechanism.mechanismName(), (Object)DelegationTokenManager.scramCredential$1(mechanism, hmacString$1));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$expireTokens$1$adapted(DelegationTokenManager $this, TokenInformation tokenInfo) {
        DelegationTokenManager.$anonfun$expireTokens$1($this, tokenInfo);
        return BoxedUnit.UNIT;
    }
}

