/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.utils.CoreUtils$;
import kafka.utils.CoreUtilsTest;
import kafka.utils.CoreUtilsTest$TestException$2$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom;
import scala.collection.BuildFrom$;
import scala.collection.BuildFromLowPriority2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.BatchingExecutor;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005a3A!\u0005\n\u0001/!)!\u0005\u0001C\u0001G!9Q\u0005\u0001b\u0001\n\u00031\u0003BB\u0019\u0001A\u0003%q\u0005C\u00033\u0001\u0011\u00051\u0007C\u0003A\u0001\u0011\u00051\u0007C\u0003C\u0001\u0011\u00051\u0007C\u0003E\u0001\u0011\u00051\u0007C\u0003G\u0001\u0011\u00051\u0007C\u0003I\u0001\u0011\u00051\u0007C\u0003K\u0001\u0011\u00051\u0007C\u0003M\u0001\u0011\u00051\u0007C\u0003O\u0001\u0011\u00051\u0007C\u0003Q\u0001\u0011\u00051\u0007C\u0003S\u0001\u0011\u00051\u0007C\u0003U\u0001\u0011\u00051\u0007C\u0003W\u0001\u0011\u00051GA\u0007D_J,W\u000b^5mgR+7\u000f\u001e\u0006\u0003'Q\tQ!\u001e;jYNT\u0011!F\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"\u0001\n\n\u0005\u0005\u0012\"a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"a\b\u0001\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#A\u0014\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013!\u0002:fO\u0016D(B\u0001\u0017.\u0003\u0011)H/\u001b7\u000b\u00039\nAA[1wC&\u0011\u0001'\u000b\u0002\b!\u0006$H/\u001a:o\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000eI\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u00015!\tIR'\u0003\u000275\t!QK\\5uQ\t!\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u0005)!.\u001e8ji*\tQ(A\u0002pe\u001eL!a\u0010\u001e\u0003\tQ+7\u000f^\u0001\u000bi\u0016\u001cH\u000f\u0016:z\u00032d\u0007FA\u00039\u0003Q!Xm\u001d;DSJ\u001cW\u000f\\1s\u0013R,'/\u0019;pe\"\u0012a\u0001O\u0001\u000ei\u0016\u001cHOU3bI\nKH/Z:)\u0005\u001dA\u0014a\u0002;fgR\f%m\u001d\u0015\u0003\u0011a\n\u0011\u0003^3tiJ+\u0007\u000f\\1dKN+hMZ5yQ\tI\u0001(A\u0006uKN$(+Z1e\u0013:$\bF\u0001\u00069\u0003-!Xm\u001d;DgZd\u0015n\u001d;)\u0005-A\u0014A\u0003;fgR\u001c5O^'ba\"\u0012A\u0002O\u0001\u000bi\u0016\u001cH/\u00138M_\u000e\\\u0007FA\u00079\u0003m!Xm\u001d;Ve2\u001c\u0016MZ3CCN,g\u0007N#oG>$W-V+J\t\"\u0012a\u0002O\u0001\u0019i\u0016\u001cHoR3oKJ\fG/Z+vS\u0012\f5OQ1tKZ\"\u0004FA\b9\u0003U!Xm\u001d;Bi>l\u0017nY$fi>\u0013X\u000b\u001d3bi\u0016D#\u0001\u0005\u001d")
public class CoreUtilsTest
implements Logging {
    private final Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        CoreUtils$.MODULE$.swallow((Function0 & Serializable)() -> {
            throw new KafkaException("test");
        }, (Logging)this, Level.INFO);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTryAll() {
        public class Kafka_utils_CoreUtilsTest$TestException$1
        extends Exception
        implements Product {
            private final String key;
            private final /* synthetic */ CoreUtilsTest $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public String key() {
                return this.key;
            }

            public Kafka_utils_CoreUtilsTest$TestException$1 copy(String key) {
                return new Kafka_utils_CoreUtilsTest$TestException$1(this.$outer, key);
            }

            public String copy$default$1() {
                return this.key();
            }

            public String productPrefix() {
                return "TestException";
            }

            public int productArity() {
                return 1;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return this.key();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return new /* Unavailable Anonymous Inner Class!! */;
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_utils_CoreUtilsTest$TestException$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "key";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                return MurmurHash3$.MODULE$.productHash((Product)this, -889275714, false);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        boolean bl = x$1 instanceof Kafka_utils_CoreUtilsTest$TestException$1;
                        if (!bl) break block3;
                        Kafka_utils_CoreUtilsTest$TestException$1 var3_3 = (Kafka_utils_CoreUtilsTest$TestException$1)x$1;
                        String string = this.key();
                        String string2 = var3_3.key();
                        if (!(!(string != null ? !string.equals(string2) : string2 != null))) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Kafka_utils_CoreUtilsTest$TestException$1(CoreUtilsTest $outer, String key) {
                this.key = key;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_value;
        Left left;
        void $minus$greater$extension_y2;
        void apply_value2;
        Left left2;
        void apply_elems2;
        void $minus$greater$extension_y3;
        void apply_value3;
        Right right;
        void $minus$greater$extension_y4;
        void apply_value4;
        Right right2;
        void apply_elems3;
        void $minus$greater$extension_y5;
        void apply_value5;
        Left left3;
        void $minus$greater$extension_y6;
        void apply_value6;
        Right right3;
        void $minus$greater$extension_y7;
        void apply_value7;
        Left left4;
        void $minus$greater$extension_y8;
        void apply_value8;
        Right right4;
        LazyRef TestException$module = new LazyRef();
        scala.collection.mutable.Map recorded = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
            void apply_value;
            String string = "valid-0";
            if (package$.MODULE$.Right() == null) {
                throw null;
            }
            string = null;
            CoreUtilsTest.recordingFunction$1((Either)new Right((Object)apply_value), recorded);
        }, (JFunction0.mcV.sp & Serializable)() -> {
            void apply_value;
            Kafka_utils_CoreUtilsTest$TestException$1 var2_2 = new Kafka_utils_CoreUtilsTest$TestException$1(this, "exception-1");
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            var2_2 = null;
            CoreUtilsTest.recordingFunction$1((Either)new Left((Object)apply_value), recorded);
        }, (JFunction0.mcV.sp & Serializable)() -> {
            void apply_value;
            String string = "valid-2";
            if (package$.MODULE$.Right() == null) {
                throw null;
            }
            string = null;
            CoreUtilsTest.recordingFunction$1((Either)new Right((Object)apply_value), recorded);
        }, (JFunction0.mcV.sp & Serializable)() -> {
            void apply_value;
            Kafka_utils_CoreUtilsTest$TestException$1 var2_2 = new Kafka_utils_CoreUtilsTest$TestException$1(this, "exception-3");
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            var2_2 = null;
            CoreUtilsTest.recordingFunction$1((Either)new Left((Object)apply_value), recorded);
        }})));
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[4];
        String string = "valid-0";
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right5 = right4 = new Right((Object)apply_value8);
        string = null;
        right4 = null;
        Right right6 = right5;
        String $minus$greater$extension_$this = "valid-0";
        Object var3_6 = null;
        right6 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y8);
        Kafka_utils_CoreUtilsTest$TestException$1 var24_7 = this.TestException$3(TestException$module).apply("exception-1");
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        Left left5 = left4 = new Left((Object)apply_value7);
        var24_7 = null;
        left4 = null;
        Left left6 = left5;
        String $minus$greater$extension_$this2 = "exception-1";
        Object var5_10 = null;
        left6 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y7);
        String string2 = "valid-2";
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right7 = right3 = new Right((Object)apply_value6);
        string2 = null;
        right3 = null;
        Right right8 = right7;
        String $minus$greater$extension_$this3 = "valid-2";
        Object var7_14 = null;
        right8 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y6);
        Kafka_utils_CoreUtilsTest$TestException$1 var28_15 = this.TestException$3(TestException$module).apply("exception-3");
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        Left left7 = left3 = new Left((Object)apply_value5);
        var28_15 = null;
        left3 = null;
        Left left8 = left7;
        String $minus$greater$extension_$this4 = "exception-3";
        Object var9_18 = null;
        left8 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y5);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3)), (Object)recorded);
        recorded.clear();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
            void apply_value;
            String string = "valid-0";
            if (package$.MODULE$.Right() == null) {
                throw null;
            }
            string = null;
            CoreUtilsTest.recordingFunction$1((Either)new Right((Object)apply_value), recorded);
        }, (JFunction0.mcV.sp & Serializable)() -> {
            void apply_value;
            String string = "valid-1";
            if (package$.MODULE$.Right() == null) {
                throw null;
            }
            string = null;
            CoreUtilsTest.recordingFunction$1((Either)new Right((Object)apply_value), recorded);
        }})));
        scala.collection.immutable.Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[2];
        String string3 = "valid-0";
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right9 = right2 = new Right((Object)apply_value4);
        string3 = null;
        right2 = null;
        Right right10 = right9;
        String $minus$greater$extension_$this5 = "valid-0";
        Object var11_23 = null;
        right10 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y4);
        String string4 = "valid-1";
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Right right11 = right = new Right((Object)apply_value3);
        string4 = null;
        right = null;
        Right right12 = right11;
        String $minus$greater$extension_$this6 = "valid-1";
        Object var13_27 = null;
        right12 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems2)), (Object)recorded);
        recorded.clear();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
            void apply_value;
            Kafka_utils_CoreUtilsTest$TestException$1 var2_2 = new Kafka_utils_CoreUtilsTest$TestException$1(this, "exception-0");
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            var2_2 = null;
            CoreUtilsTest.recordingFunction$1((Either)new Left((Object)apply_value), recorded);
        }, (JFunction0.mcV.sp & Serializable)() -> {
            void apply_value;
            Kafka_utils_CoreUtilsTest$TestException$1 var2_2 = new Kafka_utils_CoreUtilsTest$TestException$1(this, "exception-1");
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            var2_2 = null;
            CoreUtilsTest.recordingFunction$1((Either)new Left((Object)apply_value), recorded);
        }})));
        scala.collection.immutable.Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[2];
        Kafka_utils_CoreUtilsTest$TestException$1 var34_29 = this.TestException$3(TestException$module).apply("exception-0");
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        Left left9 = left2 = new Left((Object)apply_value2);
        var34_29 = null;
        left2 = null;
        Left left10 = left9;
        String $minus$greater$extension_$this7 = "exception-0";
        Object var15_32 = null;
        left10 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y2);
        Kafka_utils_CoreUtilsTest$TestException$1 var36_33 = this.TestException$3(TestException$module).apply("exception-1");
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        Left left11 = left = new Left((Object)apply_value);
        var36_33 = null;
        left = null;
        Left left12 = left11;
        String $minus$greater$extension_$this8 = "exception-1";
        Object var17_36 = null;
        left12 = null;
        objectArray3[1] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems)), (Object)recorded);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCircularIterator() {
        void apply_elems;
        List l = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator itl = CoreUtils$.MODULE$.circularIterator((Iterable)l);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertFalse((boolean)itl.isEmpty());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set s = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        Iterator its = CoreUtils$.MODULE$.circularIterator((Iterable)s);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
    }

    @Test
    public void testReadBytes() {
        .colon.colon foreach_these = new .colon.colon((Object)"", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"abcd", (List)Nil$.MODULE$)));
        while (!foreach_these.isEmpty()) {
            CoreUtilsTest.$anonfun$testReadBytes$1((String)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((long)0L, (long)Utils.abs((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)-1));
        Assert.assertEquals((long)0L, (long)Utils.abs((int)0));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testReplaceSuffix() {
        Assert.assertEquals((Object)"blah.foo.text", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ".text"));
        Assert.assertEquals((Object)"blah.foo", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ""));
        Assert.assertEquals((Object)"txt.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("txt.txt.txt", ".txt", ""));
        Assert.assertEquals((Object)"foo.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("foo", "", ".txt"));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * values.length);
        int n = 0;
        int until$extension_end = values.length;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                CoreUtilsTest.$anonfun$testReadInt$1(buffer, values, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        Seq emptyList = CoreUtils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = CoreUtils$.MODULE$.parseCsvList(null);
        scala.collection.immutable.Seq emptyStringList = (scala.collection.immutable.Seq)Seq$.MODULE$.empty();
        Assert.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assert.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testCsvMap() {
        Map.EmptyMap$ emptyMap$;
        String emptyString = "";
        Map emptyMap = CoreUtils$.MODULE$.parseCsvMap(emptyString);
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        Map.EmptyMap$ emptyMap$2 = emptyMap$ = Map.EmptyMap$.MODULE$;
        emptyMap$ = null;
        Map.EmptyMap$ emptyStringMap = emptyMap$2;
        Assert.assertTrue((emptyMap != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringMap.equals((Object)emptyStringMap));
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV6).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$1(m);
            return BoxedUnit.UNIT;
        });
        String singleEntry = "key:value";
        Assert.assertTrue((boolean)CoreUtils$.MODULE$.parseCsvMap(singleEntry).getOrElse((Object)"key", (Function0)(JFunction0.mcI.sp & Serializable)() -> 0).equals("value"));
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV4).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$3(m);
            return BoxedUnit.UNIT;
        });
        String kvPairsSpaces = "key:value      , key:   value";
        CoreUtils$.MODULE$.parseCsvMap(kvPairsSpaces).foreach((Function1 & Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$4(m);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInLock() {
        int n;
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            n = CoreUtilsTest.$anonfun$testInLock$1(lock);
        }
        finally {
            lock.unlock();
        }
        int result = n;
        Assert.assertEquals((long)2L, (long)result);
        Assert.assertFalse((String)"Should be unlocked", (boolean)lock.isLocked());
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assert.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assert.assertEquals((long)clusterId1.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assert.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assert.assertEquals((long)clusterId2.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assert.assertEquals((long)clusterId.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAtomicGetOrUpdate() {
        int count = 1000;
        int nThreads = 5;
        AtomicInteger createdCount = new AtomicInteger();
        scala.collection.concurrent.Map map = AsScalaExtensions.ConcurrentMapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, new ConcurrentHashMap()).asScala();
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(nThreads));
        try {
            void apply_unit;
            void traverse_fn;
            void traverse_bf;
            void traverse_in;
            BuildFrom buildFrom;
            int n = 1;
            BuildFrom$ buildFromIterableOps_this = BuildFrom$.MODULE$;
            BuildFrom buildFrom2 = buildFrom = BuildFromLowPriority2.buildFromIterableOps$((BuildFromLowPriority2)buildFromIterableOps_this);
            Object var9_7 = null;
            buildFrom = null;
            BuildFrom buildFrom3 = buildFrom2;
            Function1 & Serializable intersect = (Function1 & Serializable)i -> CoreUtilsTest.$anonfun$testAtomicGetOrUpdate$1(map, createdCount, executionContext, BoxesRunTime.unboxToInt((Object)i));
            Range.Inclusive inclusive = new Range.Inclusive(n, count, 1);
            Future$ traverse_this = Future$.MODULE$;
            Object var11_12 = null;
            inclusive = null;
            intersect = null;
            buildFrom3 = null;
            TimeUnit timeUnit = TimeUnit.MINUTES;
            long apply_length = 1L;
            timeUnit = null;
            Await$.MODULE$.result((Awaitable)((Future)traverse_in.iterator().foldLeft((Object)traverse_this.successful((Object)traverse_bf.newBuilder((Object)traverse_in)), (arg_0, arg_1) -> Future$.$anonfun$traverse$1((Function1)traverse_fn, (ExecutionContext)executionContext, arg_0, arg_1))).map(Future$::$anonfun$traverse$2, (ExecutionContext)(executionContext instanceof BatchingExecutor ? executionContext : ExecutionContext.parasitic$.MODULE$)), (Duration)new FiniteDuration(apply_length, (TimeUnit)apply_unit));
            Assert.assertEquals((long)count, (long)((AtomicInteger)map.apply((Object)0)).get());
            int created = createdCount.get();
            Assert.assertTrue((String)new StringBuilder(19).append("Too many creations ").append(created).toString(), (created > 0 && created <= nThreads ? 1 : 0) != 0);
        }
        finally {
            executionContext.shutdownNow();
        }
    }

    private final /* synthetic */ CoreUtilsTest$TestException$2$ TestException$lzycompute$1(LazyRef TestException$module$1) {
        synchronized (TestException$module$1) {
            CoreUtilsTest$TestException$2$ coreUtilsTest$TestException$2$ = TestException$module$1.initialized() ? (CoreUtilsTest$TestException$2$)TestException$module$1.value() : (CoreUtilsTest$TestException$2$)TestException$module$1.initialize((Object)new CoreUtilsTest$TestException$2$(this));
            return coreUtilsTest$TestException$2$;
        }
    }

    private final CoreUtilsTest$TestException$2$ TestException$3(LazyRef TestException$module$1) {
        if (TestException$module$1.initialized()) {
            return (CoreUtilsTest$TestException$2$)TestException$module$1.value();
        }
        return this.TestException$lzycompute$1(TestException$module$1);
    }

    private static final void recordingFunction$1(Either v, scala.collection.mutable.Map recorded$1) {
        String string;
        if (v instanceof Right) {
            string = (String)((Right)v).value();
        } else if (v instanceof Left) {
            string = ((Kafka_utils_CoreUtilsTest$TestException$1)((Left)v).value()).key();
        } else {
            throw new MatchError((Object)v);
        }
        recorded$1.update((Object)string, (Object)v);
    }

    public static final /* synthetic */ void $anonfun$testReadBytes$1(String testCase) {
        byte[] bytes = testCase.getBytes();
        Assert.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
    }

    public static final /* synthetic */ void $anonfun$testReadInt$1(ByteBuffer buffer$1, int[] values$1, int i) {
        buffer$1.putInt(i * 4, values$1[i]);
        Assert.assertEquals((String)"Written value should match read value.", (long)values$1[i], (long)CoreUtils$.MODULE$.readInt(buffer$1.array(), i * 4));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$1(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("a:b:c"));
        Assert.assertTrue((boolean)((String)m._2()).equals("v"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$3(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("192.168.2.1/30"));
        Assert.assertTrue((boolean)((String)m._2()).equals("allow"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$4(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("key"));
        Assert.assertTrue((boolean)((String)m._2()).equals("value"));
    }

    public static final /* synthetic */ int $anonfun$testInLock$1(ReentrantLock lock$1) {
        Assert.assertTrue((String)"Should be in lock", (boolean)lock$1.isHeldByCurrentThread());
        return 2;
    }

    public static final /* synthetic */ AtomicInteger $anonfun$testAtomicGetOrUpdate$3(AtomicInteger createdCount$1) {
        createdCount$1.incrementAndGet();
        return new AtomicInteger();
    }

    public static final /* synthetic */ Future $anonfun$testAtomicGetOrUpdate$1(scala.collection.concurrent.Map map$1, AtomicInteger createdCount$1, ExecutionContextExecutorService executionContext$1, int i) {
        JFunction0.mcI.sp & Serializable apply_body = (JFunction0.mcI.sp & Serializable)() -> {
            Object var6_7;
            Object object;
            Object object2;
            Integer n;
            Integer n2 = n = Integer.valueOf(0);
            n = null;
            Integer atomicGetOrUpdate_key = n2;
            Option option = map$1.get((Object)atomicGetOrUpdate_key);
            if (option instanceof Some) {
                object2 = ((Some)option).value();
            } else if (None$.MODULE$.equals(option)) {
                AtomicInteger atomicGetOrUpdate_value = CoreUtilsTest.$anonfun$testAtomicGetOrUpdate$3(createdCount$1);
                Option option2 = map$1.putIfAbsent((Object)atomicGetOrUpdate_key, (Object)atomicGetOrUpdate_value);
                if (option2 == null) {
                    throw null;
                }
                Option atomicGetOrUpdate_getOrElse_this = option2;
                object = atomicGetOrUpdate_getOrElse_this.isEmpty() ? atomicGetOrUpdate_value : atomicGetOrUpdate_getOrElse_this.get();
                Object object3 = object;
                var6_7 = null;
                object = null;
                object2 = object3;
            } else {
                throw new MatchError((Object)option);
            }
            Object object4 = object2;
            Object var2_3 = null;
            object2 = null;
            option = null;
            Object var5_6 = null;
            var6_7 = null;
            object = null;
            return ((AtomicInteger)object4).incrementAndGet();
        };
        return Future$.MODULE$.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), (ExecutionContext)executionContext$1);
    }

    public static final /* synthetic */ Object $anonfun$testReadBytes$1$adapted(String testCase) {
        CoreUtilsTest.$anonfun$testReadBytes$1(testCase);
        return BoxedUnit.UNIT;
    }
}

