/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.utils.KafkaThread;
import scala.Function0;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\r\u001b\u0001}A\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\te\u0001\u0011\t\u0011)A\u0005_!A1\u0007\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u00036\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\"B#\u0001\t\u00031\u0005bB&\u0001\u0001\u0004%I\u0001\u0014\u0005\b/\u0002\u0001\r\u0011\"\u0003Y\u0011\u0019q\u0006\u0001)Q\u0005\u001b\"9q\f\u0001b\u0001\n\u0013\u0001\u0007BB4\u0001A\u0003%\u0011\rC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0003k\u0001\u0011\u0005\u0013\u000eC\u0003l\u0001\u0011\u0005A\u000eC\u0003u\u0001\u0011\u0005Q\u000f\u0003\u0005\u0002(\u0001!\t\u0001HA\u0015\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0011\u0001\t\u0003\t\u0019\u0005\u0003\u0004\u0002F\u0001!I![\u0004\n\u0003\u001fR\u0012\u0011!E\u0001\u0003#2\u0001\"\u0007\u000e\u0002\u0002#\u0005\u00111\u000b\u0005\u0007\u000bV!\t!!\u0016\t\u0013\u0005]S#%A\u0005\u0002\u0005e\u0003\"CA8+E\u0005I\u0011AA9\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJT!a\u0007\u000f\u0002\u000bU$\u0018\u000e\\:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001A\u0019R\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\t!$\u0003\u0002*5\tI1k\u00195fIVdWM\u001d\t\u0003O-J!\u0001\f\u000e\u0003\u000f1{wmZ5oO\u00069A\u000f\u001b:fC\u0012\u001cX#A\u0018\u0011\u0005\u0005\u0002\u0014BA\u0019#\u0005\rIe\u000e^\u0001\ti\"\u0014X-\u00193tA\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u000b\u0002kA\u0011a'\u0010\b\u0003om\u0002\"\u0001\u000f\u0012\u000e\u0003eR!A\u000f\u0010\u0002\rq\u0012xn\u001c;?\u0013\ta$%\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f#\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u0007I\u0006,Wn\u001c8\u0011\u0005\u0005\u001a\u0015B\u0001##\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003B$I\u0013*\u0003\"a\n\u0001\t\u000b52\u0001\u0019A\u0018\t\u000fM2\u0001\u0013!a\u0001k!9\u0011I\u0002I\u0001\u0002\u0004\u0011\u0015\u0001C3yK\u000e,Ho\u001c:\u0016\u00035\u0003\"AT+\u000e\u0003=S!\u0001U)\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002S'\u0006!Q\u000f^5m\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV(\u00037M\u001b\u0007.\u001a3vY\u0016$G\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u00031)\u00070Z2vi>\u0014x\fJ3r)\tIF\f\u0005\u0002\"5&\u00111L\t\u0002\u0005+:LG\u000fC\u0004^\u0011\u0005\u0005\t\u0019A'\u0002\u0007a$\u0013'A\u0005fq\u0016\u001cW\u000f^8sA\u0005\t2o\u00195fIVdWM\u001d+ie\u0016\fG-\u00133\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001Z(\u0002\r\u0005$x.\\5d\u0013\t17MA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0013g\u000eDW\rZ;mKJ$\u0006N]3bI&#\u0007%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003e\u000b\u0001b\u001d5vi\u0012|wO\\\u0001\rg\u000eDW\rZ;mK>s7-\u001a\u000b\u000436|\u0007\"\u00028\u000f\u0001\u0004)\u0014\u0001\u00028b[\u0016DQ\u0001\u001d\bA\u0002E\f1AZ;o!\r\t#/W\u0005\u0003g\n\u0012\u0011BR;oGRLwN\u001c\u0019\u0002\u0011M\u001c\u0007.\u001a3vY\u0016$2B^A\u0006\u0003\u001b\ty!!\u0007\u0002\u001eA\u0012q\u000f \t\u0004\u001dbT\u0018BA=P\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007CA>}\u0019\u0001!\u0011\"`\b\u0002\u0002\u0003\u0005)\u0011\u0001@\u0003\u0007}##'E\u0002\u0000\u0003\u000b\u00012!IA\u0001\u0013\r\t\u0019A\t\u0002\b\u001d>$\b.\u001b8h!\r\t\u0013qA\u0005\u0004\u0003\u0013\u0011#aA!os\")an\u0004a\u0001k!)\u0001o\u0004a\u0001c\"I\u0011\u0011C\b\u0011\u0002\u0003\u0007\u00111C\u0001\u0006I\u0016d\u0017-\u001f\t\u0004C\u0005U\u0011bAA\fE\t!Aj\u001c8h\u0011%\tYb\u0004I\u0001\u0002\u0004\t\u0019\"\u0001\u0004qKJLw\u000e\u001a\u0005\n\u0003?y\u0001\u0013!a\u0001\u0003C\tA!\u001e8jiB\u0019a*a\t\n\u0007\u0005\u0015rJ\u0001\u0005US6,WK\\5u\u0003-!\u0018m]6Sk:t\u0017N\\4\u0015\u0007\t\u000bY\u0003C\u0004\u0002.A\u0001\r!a\f\u0002\tQ\f7o\u001b\u0019\u0005\u0003c\t)\u0004\u0005\u0003Oq\u0006M\u0002cA>\u00026\u0011Y\u0011qGA\u0016\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryFeM\u0001\u0011e\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$2!WA\u001f\u0011\u0019\ty$\u0005a\u0001_\u00059a.Z<TSj,\u0017!C5t'R\f'\u000f^3e+\u0005\u0011\u0015!D3ogV\u0014XMU;o]&tw\rK\u0002\u0001\u0003\u0013\u00022aJA&\u0013\r\tiE\u0007\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0017AD&bM.\f7k\u00195fIVdWM\u001d\t\u0003OU\u0019\"!\u0006\u0011\u0015\u0005\u0005E\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\\)\u001aQ'!\u0018,\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001b#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\n\u0019GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA:U\r\u0011\u0015Q\f")
public class KafkaScheduler
implements Scheduler,
Logging {
    private final int threads;
    private final String threadNamePrefix;
    private final boolean daemon;
    private ScheduledThreadPoolExecutor executor;
    private final AtomicInteger schedulerThreadId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return true;
    }

    public static String $lessinit$greater$default$2() {
        return "kafka-scheduler-";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public long schedule$default$3() {
        return Scheduler.schedule$default$3$(this);
    }

    @Override
    public long schedule$default$4() {
        return Scheduler.schedule$default$4$(this);
    }

    @Override
    public TimeUnit schedule$default$5() {
        return Scheduler.schedule$default$5$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int threads() {
        return this.threads;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void executor_$eq(ScheduledThreadPoolExecutor x$1) {
        this.executor = x$1;
    }

    private AtomicInteger schedulerThreadId() {
        return this.schedulerThreadId;
    }

    @Override
    public void startup() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Initializing task scheduler.");
        synchronized (this) {
            if (this.isStarted()) {
                throw new IllegalStateException("This scheduler has already been started!");
            }
            this.executor_$eq(new ScheduledThreadPoolExecutor(this.threads()));
            this.executor().setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.executor().setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executor().setRemoveOnCancelPolicy(true);
            this.executor().setThreadFactory(runnable -> new KafkaThread(new StringBuilder(0).append(this.threadNamePrefix()).append(this.schedulerThreadId().getAndIncrement()).toString(), runnable, $this.daemon));
            return;
        }
    }

    @Override
    public void shutdown() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Shutting down task scheduler.");
        ScheduledThreadPoolExecutor cachedExecutor = this.executor();
        if (cachedExecutor != null) {
            synchronized (this) {
                cachedExecutor.shutdown();
                this.executor_$eq(null);
            }
            cachedExecutor.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    public void scheduleOnce(String name, Function0<BoxedUnit> fun) {
        this.schedule(name, fun, 0L, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> schedule(String name, Function0<BoxedUnit> fun, long delay, long period, TimeUnit unit) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Scheduling task %s with initial delay %d ms and period %d ms.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name, TimeUnit.MILLISECONDS.convert(delay, unit), TimeUnit.MILLISECONDS.convert(period, unit)})));
        synchronized (this) {
            this.ensureRunning();
            Runnable runnable = () -> {
                try {
                    try {
                        this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Beginning execution of scheduled task '%s'.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                        fun.apply$mcV$sp();
                    }
                    catch (Throwable t) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Uncaught exception in scheduled task '").append(name).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    }
                }
                finally {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Completed execution of scheduled task '%s'.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
            };
            ScheduledFuture<?> scheduledFuture = period >= 0L ? this.executor().scheduleAtFixedRate(runnable, delay, period, unit) : this.executor().schedule(runnable, delay, unit);
            return scheduledFuture;
        }
    }

    public boolean taskRunning(ScheduledFuture<?> task) {
        return this.executor().getQueue().contains(task);
    }

    public void resizeThreadPool(int newSize) {
        this.executor().setCorePoolSize(newSize);
    }

    @Override
    public synchronized boolean isStarted() {
        return this.executor() != null;
    }

    private void ensureRunning() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Kafka scheduler is not running.");
        }
    }

    public KafkaScheduler(int threads, String threadNamePrefix, boolean daemon) {
        this.threads = threads;
        this.threadNamePrefix = threadNamePrefix;
        this.daemon = daemon;
        this.executor = null;
        this.schedulerThreadId = new AtomicInteger(0);
    }
}

