/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$;
import kafka.admin.ConfigCommandTest$CredentialChange$2$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfigTest;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005h\u0001B-[\u0001}CQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001d\u0001\u0005\u0002EDa!a\u0001\u0001\t\u0003\t\bBBA\u0004\u0001\u0011\u0005\u0011\u000fC\u0004\u0002\f\u0001!I!!\u0004\t\r\u0005=\u0002\u0001\"\u0001r\u0011\u0019\t\u0019\u0004\u0001C\u0001c\"1\u0011q\u0007\u0001\u0005\u0002EDa!a\u000f\u0001\t\u0003\t\bBBA \u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002D\u0001!\t!\u001d\u0005\u0007\u0003\u000f\u0002A\u0011A9\t\r\u0005-\u0003\u0001\"\u0001r\u0011\u0019\ty\u0005\u0001C\u0001c\"9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003BBA3\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002\u0000\u0001!\t!\u001d\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u0019\tI\t\u0001C\u0001c\"1\u0011Q\u0012\u0001\u0005\u0002EDa!!%\u0001\t\u0003\t\bBBAK\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002\u001a\u0002!\t!\u001d\u0005\u0007\u0003;\u0003A\u0011A9\t\r\u0005\u0005\u0006\u0001\"\u0001r\u0011\u0019\t)\u000b\u0001C\u0001c\"1\u0011\u0011\u0016\u0001\u0005\u0002EDa!!,\u0001\t\u0003\t\bBBAY\u0001\u0011\u0005\u0011\u000fC\u0004\u00026\u0002!\t!a.\t\r\u0005\u001d\u0007\u0001\"\u0001r\u0011\u0019\tY\r\u0001C\u0001c\"1\u0011q\u001a\u0001\u0005\u0002EDa!a5\u0001\t\u0003\t\bBBAl\u0001\u0011\u0005\u0011\u000fC\u0004\u0002\\\u0002!\t!!8\t\r\u0005\r\b\u0001\"\u0001r\u0011\u0019\t9\u000f\u0001C\u0001c\"1\u00111\u001e\u0001\u0005\u0002EDa!a<\u0001\t\u0003\t\bBBAz\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002x\u0002!\t!\u001d\u0005\u0007\u0003w\u0004A\u0011A9\t\r\u0005}\b\u0001\"\u0001r\u0011\u0019\u0011\u0019\u0001\u0001C\u0001c\"1!q\u0001\u0001\u0005\u0002EDaAa\u0003\u0001\t\u0003\t\bB\u0002B\u0014\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0003,\u0001!\t!\u001d\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u0019\u0011i\u0005\u0001C\u0001c\"9!\u0011\u000b\u0001\u0005\u0002\tM\u0003B\u0002B9\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0003v\u0001!\t!\u001d\u0005\u0007\u0005s\u0002A\u0011A9\t\r\tu\u0004\u0001\"\u0001r\u0011\u0019\u0011\t\t\u0001C\u0001c\"1!Q\u0011\u0001\u0005\u0002EDaA!#\u0001\t\u0003\t\bB\u0002BG\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0003\u0012\u0002!\t!\u001d\u0005\u0007\u0005+\u0003A\u0011A9\t\r\te\u0005\u0001\"\u0001r\u0011\u0019\u0011i\n\u0001C\u0001c\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006B\u0002BT\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0003,\u0002!\t!\u001d\u0005\b\u0005_\u0003A\u0011\u0001BY\u0011\u0019\u0011)\f\u0001C\u0001c\"1!\u0011\u0018\u0001\u0005\u0002EDaA!0\u0001\t\u0003\t\bb\u0002Ba\u0001\u0011%!1\u0019\u0004\u0007\u0005\u001f\u0004\u0001A!5\t\u0015\te\u0017J!A!\u0002\u0013\u0011Y\u000e\u0003\u0004m\u0013\u0012\u0005!\u0011\u001d\u0005\b\u0005SLE\u0011\tBv\u0011\u001d\u0019\t\"\u0013C!\u0007'Aqa!\u0007J\t\u0003\u001aY\u0002C\u0004\u0004\"%#\tea\t\t\u000f\r-\u0012\n\"\u0011\u0004.\u001911Q\u0007\u0001\u0001\u0007oA!B!\u000eR\u0005\u0003\u0005\u000b\u0011\u0002B\u001c\u0011\u0019a\u0017\u000b\"\u0001\u0004@!91QI)\u0005B\r\u001d\u0003bBB8#\u0012\u00053\u0011\u000f\u0005\b\u0007#\u000bF\u0011IBJ\u0011\u001d\u0019\t+\u0015C!\u0007GCqaa1R\t\u0003\u001a)MA\tD_:4\u0017nZ\"p[6\fg\u000e\u001a+fgRT!a\u0017/\u0002\u000b\u0005$W.\u001b8\u000b\u0003u\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001A\u001a\u0004\"!\u00193\u000e\u0003\tT!a\u0019/\u0002\u0005i\\\u0017BA3c\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eX\u0001\u0006kRLGn]\u0005\u0003W\"\u0014q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002]B\u0011q\u000eA\u0007\u00025\u0006)3\u000f[8vY\u0012,\u00050\u001b;XSRDgj\u001c8[KJ|7\u000b^1ukN|e.\u0011:h\u000bJ\u0014xN\u001d\u000b\u0002eB\u00111O^\u0007\u0002i*\tQ/A\u0003tG\u0006d\u0017-\u0003\u0002xi\n!QK\\5uQ\t\u0011\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006)!.\u001e8ji*\ta0A\u0002pe\u001eL1!!\u0001|\u0005\u0011!Vm\u001d;\u0002WMDw.\u001e7e\u000bbLGoV5uQ:{gNW3s_N#\u0018\r^;t\u001f:T6nQ8n[\u0006tG-\u0012:s_JD#aA=\u0002_MDw.\u001e7e\u000bbLGoV5uQ:{gNW3s_N#\u0018\r^;t\u001f:\u0014%o\\6fe\u000e{W.\\1oI\u0016\u0013(o\u001c:)\u0005\u0011I\u0018aF1tg\u0016\u0014HOT8o5\u0016\u0014xn\u0015;biV\u001cX\t_5u)\r\u0011\u0018q\u0002\u0005\b\u0003#)\u0001\u0019AA\n\u0003\u0011\t'oZ:\u0011\u000bM\f)\"!\u0007\n\u0007\u0005]AOA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\u001c\u0005%b\u0002BA\u000f\u0003K\u00012!a\bu\u001b\t\t\tCC\u0002\u0002$y\u000ba\u0001\u0010:p_Rt\u0014bAA\u0014i\u00061\u0001K]3eK\u001aLA!a\u000b\u0002.\t11\u000b\u001e:j]\u001eT1!a\nu\u0003Y\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'o\u00117jK:$8/\u00128uSRLH+\u001f9f+NLgn\u001a.p_.,W\r]3sQ\t1\u00110\u0001\u0015tQ>,H\u000e\u001a)beN,\u0017I]4v[\u0016tGo\u001d$pe\u000ec\u0017.\u001a8ug\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002\bs\u0006!4\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN]+tKJ\u001cXI\u001c;jif$\u0016\u0010]3Vg&twMW8pW\u0016,\u0007/\u001a:)\u0005!I\u0018AJ:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s+N,'o]#oi&$\u0018\u0010V=qK\"\u0012\u0011\"_\u00016g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J$v\u000e]5dg\u0016sG/\u001b;z)f\u0004X-V:j]\u001eTvn\\6fKB,'\u000f\u000b\u0002\u000bs\u000693\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d+pa&\u001c7/\u00128uSRLH+\u001f9fQ\tY\u00110\u0001\u001ctQ>,H\u000e\u001a)beN,\u0017I]4v[\u0016tGo\u001d$pe\n\u0013xn[3sg\u0016sG/\u001b;z)f\u0004X-V:j]\u001eTvn\\6fKB,'\u000f\u000b\u0002\rs\u0006A3\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN\u001d\"s_.,'o]#oi&$\u0018\u0010V=qK\"\u0012Q\"_\u0001/g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J\u0014%o\\6fe2{wmZ3sg\u0016sG/\u001b;z)f\u0004X\r\u000b\u0002\u000fs\u0006\tB/Z:u\u0003J<W/\\3oiB\u000b'o]3\u0015\u000bI\f9&a\u0017\t\u000f\u0005es\u00021\u0001\u0002\u001a\u0005QQM\u001c;jif$\u0016\u0010]3\t\u000f\u0005us\u00021\u0001\u0002`\u0005A!p[\"p]\u001aLw\rE\u0002t\u0003CJ1!a\u0019u\u0005\u001d\u0011un\u001c7fC:\f\u0011d\u001d5pk2$g)Y5m\u0013\u001a\fE\rZ!oI\u0006#GMR5mK\"2\u0001#_A5\u0003W\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003[\u0002B!a\u001c\u0002z9!\u0011\u0011OA;\u001d\u0011\ty\"a\u001d\n\u0003UL1!a\u001eu\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001f\u0002~\tA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005]D/A\u0015uKN$\b+\u0019:tK\u000e{gNZ5hgR{')Z!eI\u0016$gi\u001c:BI\u0012\u001cuN\u001c4jO\u001aKG.\u001a\u0015\u0003#e\f1\u0004Z8UKN$x\n\u001d;j_:,e\u000e^5usRK\b/\u001a(b[\u0016\u001cHc\u0001:\u0002\b\"9\u0011Q\f\nA\u0002\u0005}\u0013a\n;fgR|\u0005\u000f^5p]\u0016sG/\u001b;z)f\u0004XMT1nKN,6/\u001b8h5>|7.Z3qKJD#aE=\u00023Q,7\u000f^(qi&|g.\u00128uSRLH+\u001f9f\u001d\u0006lWm\u001d\u0015\u0003)e\f\u0001g\u001d5pk2$g)Y5m\u0013\u001a,fN]3d_\u001et\u0017n]3e\u000b:$\u0018\u000e^=UsB,Wk]5oOj{wn[3fa\u0016\u0014\bFB\u000bz\u0003S\nY'\u0001\u0012tQ>,H\u000e\u001a$bS2Le-\u00168sK\u000e|wM\\5tK\u0012,e\u000e^5usRK\b/\u001a\u0015\u0007-e\fI'a\u001b\u0002qMDw.\u001e7e\r\u0006LG.\u00134Ce>\\WM]#oi&$\u0018\u0010V=qK&\u001bhj\u001c;B]&sG/Z4feV\u001b\u0018N\\4[_>\\W-\u001a9fe\"2q#_A5\u0003W\n!f\u001d5pk2$g)Y5m\u0013\u001a\u0014%o\\6fe\u0016sG/\u001b;z)f\u0004X-S:O_R\fe.\u00138uK\u001e,'\u000f\u000b\u0004\u0019s\u0006%\u00141N\u0001>g\"|W\u000f\u001c3GC&d\u0017JZ*i_J$(I]8lKJ,e\u000e^5usRK\b/Z%t\u001d>$\u0018I\\%oi\u0016<WM]+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u00073e\fI'a\u001b\u0002_MDw.\u001e7e\r\u0006LG.\u00134TQ>\u0014HO\u0011:pW\u0016\u0014XI\u001c;jif$\u0016\u0010]3Jg:{G/\u00118J]R,w-\u001a:)\riI\u0018\u0011NA6\u00039\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u001b&DX\rZ#oi&$\u0018\u0010V=qK\u001ac\u0017mZ:Vg&twMW8pW\u0016,\u0007/\u001a:)\rmI\u0018\u0011NA6\u0003\u0001\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u001b&DX\rZ#oi&$\u0018\u0010V=qK\u001ac\u0017mZ:)\rqI\u0018\u0011NA6\u0003\r\u001a\bn\\;mI\u0006#Gm\u00117jK:$8i\u001c8gS\u001e,6/\u001b8h5>|7.Z3qKJD#!H=\u00023Q,7\u000f^*i_VdG-\u00113e\u00072LWM\u001c;D_:4\u0017n\u001a\u000b\u0006e\u0006e\u00161\u0019\u0005\b\u0003ws\u0002\u0019AA_\u0003\u0011)8/\u001a:\u0011\u000bM\fy,!\u0007\n\u0007\u0005\u0005GO\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000bt\u0002\u0019AA_\u0003!\u0019G.[3oi&#\u0017!F:i_VdG-\u00113e\u00072LWM\u001c;D_:4\u0017n\u001a\u0015\u0003?e\fag\u001d5pk2$gj\u001c;BYR,'OT8o#V|G/Y\"mS\u0016tGoQ8oM&<Wk]5oO\n{w\u000e^:ue\u0006\u00048+\u001a:wKJD#\u0001I=\u0002EMDw.\u001e7e\u0003\u0012$Gk\u001c9jG\u000e{gNZ5h+NLgn\u001a.p_.,W\r]3sQ\t\t\u00130\u0001\ftQ>,H\u000eZ!mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5hQ\t\u0011\u00130\u0001\u000etQ>,H\u000eZ!mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5h\r&dW\r\u000b\u0002$s\u0006ABm\\*i_VdG-\u00117uKJ$v\u000e]5d\u0007>tg-[4\u0015\u0007I\fy\u000eC\u0004\u0002b\u0012\u0002\r!a\u0018\u0002\t\u0019LG.Z\u0001\u001dg\"|W\u000f\u001c3EKN\u001c'/\u001b2f\u0007>tg-[4Ts:|g._7tQ\t)\u00130\u0001\u000etQ>,H\u000eZ!eI\n\u0013xn[3s#V|G/Y\"p]\u001aLw\r\u000b\u0002's\u0006Y2\u000f[8vY\u0012\fE\r\u001a\"s_.,'\u000fT8hO\u0016\u00148i\u001c8gS\u001eD#aJ=\u0002wQ,7\u000f\u001e(p'B,7-\u001b4jK\u0012,e\u000e^5us>\u0003H/[8o/&$\b\u000eR3tGJL'-\u001a\"s_.,'o]%o5.K5/\u00117m_^,G\r\u000b\u0002)s\u0006AE/Z:u\u001d>\u001c\u0006/Z2jM&,G-\u00128uSRLx\n\u001d;j_:<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0005J|7.\u001a:t\u0013:\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u0014\u0018j]!mY><X\r\u001a\u0015\u0003Se\f1\u0004^3ti\u0012+7o\u0019:jE\u0016\fE\u000e\u001c\"s_.,'oQ8oM&<\u0007F\u0001\u0016z\u0003i!Xm\u001d;EKN\u001c'/\u001b2f\u00032dGk\u001c9jG\u000e{gNZ5hQ\tY\u00130\u0001\u001auKN$H)Z:de&\u0014W-\u00117m\u0005J|7.\u001a:D_:4\u0017n\u001a\"p_R\u001cHO]1q'\u0016\u0014h/\u001a:SKF,\u0018N]3eQ\u0019a\u00130!\u001b\u0002l\u0005YD/Z:u\u000b:$\u0018\u000e^=EK\u001a\fW\u000f\u001c;PaRLwN\\,ji\"$Um]2sS\n,'I]8lKJdunZ4fe&\u001bhj\u001c;BY2|w/\u001a3)\r5J\u0018\u0011NA6\u0003a\"Xm\u001d;F]RLG/\u001f#fM\u0006,H\u000e^(qi&|gnV5uQ\u0006cG/\u001a:Ce>\\WM\u001d'pO\u001e,'/S:O_R\fE\u000e\\8xK\u0012DcAL=\u0002j\u0005-\u0014aS:i_VdGMU1jg\u0016LeN^1mS\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0016C8-\u001a9uS>tw\u000b[3o\u0003\u0012$\u0017N\\4J]Z\fG.\u001b3Ce>\\WM\u001d'pO\u001e,'oQ8oM&<\u0007FB\u0018z\u0003S\u0012ya\t\u0002\u0003\u0012A!!1\u0003B\u0012\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011AB3se>\u00148O\u0003\u0003\u0003\u001c\tu\u0011AB2p[6|gNC\u0002^\u0005?Q1A!\t~\u0003\u0019\t\u0007/Y2iK&!!Q\u0005B\u000b\u0005uIeN^1mS\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0016C8-\u001a9uS>t\u0017aI:i_VdG-\u00113e\t\u00164\u0017-\u001e7u\u0005J|7.\u001a:Es:\fW.[2D_:4\u0017n\u001a\u0015\u0003ae\fAd\u001d5pk2$\u0017\t\u001a3Ce>\\WM\u001d#z]\u0006l\u0017nY\"p]\u001aLw\r\u000b\u00022s\u00069b/\u001a:jMf\fE\u000e^3s\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\be\nM\"q\bB\"\u0011\u001d\u0011)D\ra\u0001\u0005o\tAA\\8eKB!!\u0011\bB\u001e\u001b\t\u0011I\"\u0003\u0003\u0003>\te!\u0001\u0002(pI\u0016DqA!\u00113\u0001\u0004\tI\"\u0001\u0007sKN|WO]2f\u001d\u0006lW\rC\u0004\u0003FI\u0002\rAa\u0012\u0002\u0019I,7o\\;sG\u0016|\u0005\u000f^:\u0011\r\u0005=$\u0011JA\r\u0013\u0011\u0011Y%! \u0003\t1K7\u000f^\u0001,g\"|W\u000f\u001c3EKN\u001c'/\u001b2f\u0007>tg-[4Ce>\\WM],ji\"|W\u000f^#oi&$\u0018PT1nK\"\u00121'_\u0001\u001em\u0016\u0014\u0018NZ=BYR,'O\u0011:pW\u0016\u0014Hj\\4hKJ\u001cuN\u001c4jORI!O!\u0016\u0003X\te#Q\f\u0005\b\u0005k!\u0004\u0019\u0001B\u001c\u0011\u001d\u0011\t\u0005\u000ea\u0001\u00033AqAa\u00175\u0001\u0004\tI\"\u0001\u0006f]RLG/\u001f(b[\u0016DqAa\u00185\u0001\u0004\u0011\t'A\u000beKN\u001c'/\u001b2f\u0007>tg-[4F]R\u0014\u0018.Z:\u0011\r\u0005=$\u0011\nB2!\u0011\u0011)G!\u001c\u000e\u0005\t\u001d$bA.\u0003j)!!1\u000eB\u000f\u0003\u001d\u0019G.[3oiNLAAa\u001c\u0003h\tY1i\u001c8gS\u001e,e\u000e\u001e:z\u0003=\u001a\bn\\;mIN+\b\u000f]8si\u000e{W.\\1TKB\f'/\u0019;fIZ\u000bG.^3t+NLgn\u001a.p_.,W\r]3sQ\t)\u00140\u0001 tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012,e\u000e^5us:\u000bW.Z+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0007me\fI'a\u001b\u0002aMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,G-\u00128uSRLh*Y7fQ\u00199\u00140!\u001b\u0002l\u0005YC/Z:u\tft\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ+qI\u0006$X-V:j]\u001eTvn\\&fKB,'\u000f\u000b\u00029s\u0006Q4\u000f[8vY\u0012tu\u000e^+qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001eLe-T1mM>\u0014X.\u001a3D_:4\u0017nZ+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0007se\fI'a\u001b\u0002YMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,GmQ8oM&<\u0007F\u0002\u001ez\u0003S\nY'A!tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012\u0014%/Y2lKR\u001cuN\u001c4jOV\u001b\u0018N\\4[_>\\W-\u001a9fe\"21(_A5\u0003W\n1g\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0005J\f7m[3u\u0007>tg-[4)\rqJ\u0018\u0011NA6\u0003y\u001a\bn\\;mI:{G/\u00169eCR,7i\u001c8gS\u001eLeMT8o\u000bbL7\u000f^5oO\u000e{gNZ5h\u0013N$U\r\\3uK\u0012,6/\u001b8h5>|7.\u001a9fe\"2Q(_A5\u0005\u001f\t\u0011g\u001d5pk2$gj\u001c;Va\u0012\fG/Z\"p]\u001aLw-\u00134O_:,\u00050[:uS:<7i\u001c8gS\u001eL5\u000fR3mKR,G\r\u000b\u0004?s\u0006%$qB\u0001\u0019g\"|W\u000f\u001c3EK2,G/\u001a\"s_.,'oQ8oM&<\u0007FA z\u0003Q!Xm\u001d;TGJ\fWn\u0011:fI\u0016tG/[1mg\"\u0012\u0001)_\u0001\u0018I>$Vm\u001d;Rk>$\u0018mQ8oM&<WI\u001c;jif$2A\u001dBS\u0011\u001d\ti&\u0011a\u0001\u0003?\n1\u0005^3tiF+x\u000e^1D_:4\u0017nZ#oi&$\u00180V:j]\u001eTvn\\6fKB,'\u000f\u000b\u0002Cs\u0006)B/Z:u#V|G/Y\"p]\u001aLw-\u00128uSRL\bFA\"z\u0003e!w\u000eV3tiV\u001bXM]\"mS\u0016tG/U;pi\u0006|\u0005\u000f^:\u0015\u0007I\u0014\u0019\fC\u0004\u0002^\u0011\u0003\r!a\u0018\u0002KQ,7\u000f^+tKJ\u001cE.[3oiF+x\u000e^1PaR\u001cXk]5oOj{wn[3fa\u0016\u0014\bFA#z\u0003]!Xm\u001d;Vg\u0016\u00148\t\\5f]R\fVo\u001c;b\u001fB$8\u000f\u000b\u0002Gs\u0006IB/Z:u#V|G/\u0019#fg\u000e\u0014\u0018NY3F]RLG/[3tQ\t9\u00150\u0001\nsK\u001eL7\u000f^3s\u0005J|7.\u001a:J]j[Gc\u0001:\u0003F\"9!q\u0019%A\u0002\t%\u0017AA5e!\r\u0019(1Z\u0005\u0004\u0005\u001b$(aA%oi\n\u0011B)^7ns\u0006#W.\u001b8[W\u000ec\u0017.\u001a8u'\rI%1\u001b\t\u0004C\nU\u0017b\u0001BlE\ni\u0011\tZ7j]j[7\t\\5f]R\f\u0001B_6DY&,g\u000e\u001e\t\u0004C\nu\u0017b\u0001BpE\ni1*\u00194lCj[7\t\\5f]R$BAa9\u0003hB\u0019!Q]%\u000e\u0003\u0001AqA!7L\u0001\u0004\u0011Y.\u0001\ndQ\u0006tw-\u001a\"s_.,'oQ8oM&<G#\u0002:\u0003n\nu\bb\u0002Bx\u0019\u0002\u0007!\u0011_\u0001\nEJ|7.\u001a:JIN\u0004bAa=\u0003z\n%WB\u0001B{\u0015\r\u00119\u0010^\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B~\u0005k\u00141aU3r\u0011\u001d\u0011y\u0010\u0014a\u0001\u0007\u0003\tqaY8oM&<7\u000f\u0005\u0003\u0004\u0004\r5QBAB\u0003\u0015\u0011\u00199a!\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0007\u0017\tAA[1wC&!1qBB\u0003\u0005)\u0001&o\u001c9feRLWm]\u0001\u0012M\u0016$8\r[#oi&$\u0018pQ8oM&<GCBB\u0001\u0007+\u00199\u0002C\u0004\u0002Z5\u0003\r!!\u0007\t\u000f\tmS\n1\u0001\u0002\u001a\u0005!2\r[1oO\u0016\u001cE.[3oi&#7i\u001c8gS\u001e$RA]B\u000f\u0007?Aq!!2O\u0001\u0004\tI\u0002C\u0004\u0003\u0000:\u0003\ra!\u0001\u0002=\rD\u0017M\\4f+N,'o\u0014:Vg\u0016\u00148\t\\5f]RLEmQ8oM&<G#\u0002:\u0004&\r%\u0002bBB\u0014\u001f\u0002\u0007\u0011\u0011D\u0001\u0014g\u0006t\u0017\u000e^5{K\u0012,e\u000e^5us:\u000bW.\u001a\u0005\b\u0005\u007f|\u0005\u0019AB\u0001\u0003E\u0019\u0007.\u00198hKR{\u0007/[2D_:4\u0017n\u001a\u000b\u0006e\u000e=21\u0007\u0005\b\u0007c\u0001\u0006\u0019AA\r\u0003\u0015!x\u000e]5d\u0011\u001d\u0011y\u0010\u0015a\u0001\u0007\u0003\u0011\u0001\u0003R;n[f\fE-\\5o\u00072LWM\u001c;\u0014\u0007E\u001bI\u0004\u0005\u0003\u0003f\rm\u0012\u0002BB\u001f\u0005O\u0012q\"T8dW\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0005\u0007\u0003\u001a\u0019\u0005E\u0002\u0003fFCqA!\u000eT\u0001\u0004\u00119$A\beKN\u001c'/\u001b2f\u0007>tg-[4t)\u0019\u0019Iea\u0014\u0004fA!!QMB&\u0013\u0011\u0019iEa\u001a\u0003+\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm];mi\"91\u0011\u000b+A\u0002\rM\u0013!\u0003:fg>,(oY3t!\u0019\u0019\u0019a!\u0016\u0004Z%!1qKB\u0003\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0005\u00077\u001a\t'\u0004\u0002\u0004^)!1q\fB\r\u0003\u0019\u0019wN\u001c4jO&!11MB/\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016Dqaa\u001aU\u0001\u0004\u0019I'A\u0004paRLwN\\:\u0011\t\t\u001541N\u0005\u0005\u0007[\u00129G\u0001\fEKN\u001c'/\u001b2f\u0007>tg-[4t\u001fB$\u0018n\u001c8t\u0003]Ign\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000f\u0006\u0004\u0004t\re4\u0011\u0012\t\u0005\u0005K\u001a)(\u0003\u0003\u0004x\t\u001d$AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDqAa@V\u0001\u0004\u0019Y\b\u0005\u0005\u0004\u0004\ru4\u0011LBA\u0013\u0011\u0019yh!\u0002\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0004\u0004\rU31\u0011\t\u0005\u0005K\u001a))\u0003\u0003\u0004\b\n\u001d$!D!mi\u0016\u00148i\u001c8gS\u001e|\u0005\u000fC\u0004\u0004hU\u0003\raa#\u0011\t\t\u00154QR\u0005\u0005\u0007\u001f\u00139GA\nBYR,'oQ8oM&<7o\u00149uS>t7/\u0001\u0007bYR,'oQ8oM&<7\u000f\u0006\u0004\u0004t\rU5q\u0014\u0005\b\u0005\u007f4\u0006\u0019ABL!!\u0019\u0019a! \u0004Z\re\u0005\u0003\u0002B3\u00077KAa!(\u0003h\t11i\u001c8gS\u001eDqaa\u001aW\u0001\u0004\u0019Y)\u0001\u000beKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0007\u0007K\u001bYka/\u0011\t\t\u00154qU\u0005\u0005\u0007S\u00139G\u0001\u000eEKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fgVdG\u000fC\u0004\u0004.^\u0003\raa,\u0002\r\u0019LG\u000e^3s!\u0011\u0019\tla.\u000e\u0005\rM&\u0002BB[\u00053\tQ!];pi\u0006LAa!/\u00044\n\t2\t\\5f]R\fVo\u001c;b\r&dG/\u001a:\t\u000f\r\u001dt\u000b1\u0001\u0004>B!!QMB`\u0013\u0011\u0019\tMa\u001a\u00037\u0011+7o\u0019:jE\u0016\u001cE.[3oiF+x\u000e^1t\u001fB$\u0018n\u001c8t\u0003E\tG\u000e^3s\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0007\u0007\u000f\u001cim!7\u0011\t\t\u00154\u0011Z\u0005\u0005\u0007\u0017\u00149GA\fBYR,'o\u00117jK:$\u0018+^8uCN\u0014Vm];mi\"91q\u001a-A\u0002\rE\u0017aB3oiJLWm\u001d\t\u0007\u0007\u0007\u0019)fa5\u0011\t\rE6Q[\u0005\u0005\u0007/\u001c\u0019LA\u000bDY&,g\u000e^)v_R\f\u0017\t\u001c;fe\u0006$\u0018n\u001c8\t\u000f\r\u001d\u0004\f1\u0001\u0004\\B!!QMBo\u0013\u0011\u0019yNa\u001a\u00031\u0005cG/\u001a:DY&,g\u000e^)v_R\f7o\u00149uS>t7\u000f")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        this.assertNonZeroStatusExit(new String[]{"--blah"});
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandError() {
        this.assertNonZeroStatusExit(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT"});
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        this.assertNonZeroStatusExit(new String[]{"--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe"});
    }

    private void assertNonZeroStatusExit(String[] args) {
        ObjectRef objectRef;
        None$ create_e = None$.MODULE$;
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e);
        Object var5_2 = null;
        objectRef = null;
        ObjectRef exitStatus = objectRef2;
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$1) -> ConfigCommandTest.$anonfun$assertNonZeroStatusExit$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_5 = null;
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit.resetExitProcedure();
        }
        Assert.assertEquals((Object)new Some((Object)1), (Object)((Option)exitStatus.elem));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForClientsEntityType() {
        this.testArgumentParse("clients", false);
    }

    @Test
    public void shouldParseArgumentsForUsersEntityTypeUsingZookeeper() {
        this.testArgumentParse("users", true);
    }

    @Test
    public void shouldParseArgumentsForUsersEntityType() {
        this.testArgumentParse("users", false);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityTypeUsingZookeeper() {
        this.testArgumentParse("topics", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics", false);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityTypeUsingZookeeper() {
        this.testArgumentParse("brokers", true);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers", false);
    }

    @Test
    public void shouldParseArgumentsForBrokerLoggersEntityType() {
        this.testArgumentParse("broker-loggers", false);
    }

    public void testArgumentParse(String entityType, boolean zkConfig) {
        String shortFlag = new StringBuilder(2).append("--").append(StringOps$.MODULE$.dropRight$extension(entityType, 1)).toString();
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--describe"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--describe"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config-file", "/tmp/new.properties"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config-file", "/tmp/new.properties"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--delete-config", "a,b,c"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"});
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        if (deletedProps == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)deletedProps.length());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=,d=e,f="});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=,d=e,f="});
        createOpts.checkArgs();
        Properties addedProps2 = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)4L, (long)addedProps2.size());
        Assert.assertEquals((Object)"b", (Object)addedProps2.getProperty("a"));
        Assert.assertEquals((Object)"e", (Object)addedProps2.getProperty("d"));
        Assert.assertTrue((boolean)addedProps2.getProperty("c").isEmpty());
        Assert.assertTrue((boolean)addedProps2.getProperty("f").isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfAddAndAddFile() {
        new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d", "--add-config-file", "/tmp/new.properties"}).checkArgs();
    }

    @Test
    public void testParseConfigsToBeAddedForAddConfigFile() {
        File file = TestUtils.tempFile((String)StringOps$.MODULE$.stripMargin$extension("a=b\n        |c = d\n        |json = {\"key\": \"val\"}\n        |nested = [[1, 2], [3, 4]]\n        |", '|'));
        String[] addConfigFileArgs = new String[]{"--add-config-file", file.getPath()};
        ClassTag $plus$plus$extension_evidence$25 = ClassTag$.MODULE$.apply(String.class);
        Object var5_3 = null;
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter"}, (Object)addConfigFileArgs, $plus$plus$extension_evidence$25));
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)4L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Assert.assertEquals((Object)"{\"key\": \"val\"}", (Object)addedProps.getProperty("json"));
        Assert.assertEquals((Object)"[[1, 2], [3, 4]]", (Object)addedProps.getProperty("nested"));
    }

    public void doTestOptionEntityTypeNames(boolean zkConfig) {
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics", "--entity-name", "A"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "0", "--entity-type", "brokers"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients", "--entity-name", "A", "--entity-default"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-default", "--entity-name", "B", "--entity-type", "users", "--entity-type", "clients"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", "A"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--broker", "0"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user", "A"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user-defaults"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--entity-name", "A"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)Nil$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$), (List)Nil$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users"}), connectOpts);
        ConfigCommandTest.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)Nil$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "brokers"}), connectOpts);
    }

    @Test
    public void testOptionEntityTypeNamesUsingZookeeper() {
        this.doTestOptionEntityTypeNames(true);
    }

    @Test
    public void testOptionEntityTypeNames() {
        this.doTestOptionEntityTypeNames(false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityTypeUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--broker", "A", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--broker", "A", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfMixedEntityTypeFlagsUsingZookeeper() {
        new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "users", "--client", "B", "--describe"}).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfMixedEntityTypeFlags() {
        new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A", "--entity-type", "users", "--client", "B", "--describe"}).checkArgs();
    }

    @Test
    public void shouldAddClientConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(null, this.zkClient()));
    }

    /*
     * WARNING - void declaration
     */
    public void testShouldAddClientConfig(Option<String> user, Option<String> clientId) {
        void var10_10;
        void var6_6;
        BooleanRef booleanRef;
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        Double d;
        BooleanRef booleanRef2;
        void var9_9;
        void var5_5;
        void var8_8;
        void var4_4;
        Tuple3 tuple3 = ConfigCommandTest.toValues$1(user, "user", "users");
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        String[] userArgs = (String[])tuple3._1();
        Option userEntity = (Option)tuple3._2();
        Option userComponent = (Option)tuple3._3();
        Tuple3 tuple32 = ConfigCommandTest.toValues$1(clientId, "client-id", "clients");
        if (tuple32 == null) {
            throw new MatchError(null);
        }
        String[] clientIdArgs = (String[])tuple32._1();
        Option clientIdEntity = (Option)tuple32._2();
        Option clientIdComponent = (Option)tuple32._3();
        ClassTag $plus$plus$extension_evidence$25 = ClassTag$.MODULE$.apply(String.class);
        Object var22_11 = null;
        ClassTag $plus$plus$extension_evidence$252 = ClassTag$.MODULE$.apply(String.class);
        Object var23_12 = null;
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)((Object[])ArrayOps$.MODULE$.appendedAll$extension((Object)new String[]{"--bootstrap-server", "localhost:9092", "--alter", "--add-config", "consumer_byte_rate=20000,producer_byte_rate=10000", "--delete-config", "request_percentage"}, (Object)var4_4, $plus$plus$extension_evidence$25)), (Object)var8_8, $plus$plus$extension_evidence$252));
        HashMap<String, String> entityMap = new HashMap<String, String>();
        if (var5_5 == null) {
            throw null;
        }
        if (!var5_5.isEmpty()) {
            String string = (String)var5_5.get();
            entityMap.put("user", string);
        }
        if (var9_9 == null) {
            throw null;
        }
        if (!var9_9.isEmpty()) {
            String string = (String)var9_9.get();
            entityMap.put("client-id", string);
        }
        ClientQuotaEntity entity = new ClientQuotaEntity(entityMap);
        boolean create_e = false;
        BooleanRef booleanRef3 = booleanRef2 = new BooleanRef(create_e);
        booleanRef2 = null;
        BooleanRef describedConfigs = booleanRef3;
        KafkaFutureImpl describeFuture = new KafkaFutureImpl();
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        scala.collection.immutable.Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        Double d2 = d = Double.valueOf(50.0);
        d = null;
        Double d3 = d2;
        String $minus$greater$extension_$this = "request_percentage";
        Object var24_24 = null;
        d3 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq = null;
        java.util.Map $minus$greater$extension_y2 = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems2))).asJava();
        Object var26_26 = null;
        objectArray[0] = new Tuple2((Object)entity, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq2 = null;
        describeFuture.complete((Object)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems))).asJava());
        DescribeClientQuotasResult describeResult = (DescribeClientQuotasResult)EasyMock.createNiceMock(DescribeClientQuotasResult.class);
        EasyMock.expect((Object)describeResult.entities()).andReturn((Object)describeFuture);
        boolean create_e2 = false;
        BooleanRef booleanRef4 = booleanRef = new BooleanRef(create_e2);
        booleanRef = null;
        BooleanRef alteredConfigs = booleanRef4;
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterClientQuotasResult alterResult = (AlterClientQuotasResult)EasyMock.createNiceMock(AlterClientQuotasResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, (Option)var6_6, (Option)var10_10, describedConfigs, describeResult, entity, alteredConfigs, alterResult){
            private final Option userComponent$1;
            private final Option clientIdComponent$1;
            private final BooleanRef describedConfigs$1;
            private final DescribeClientQuotasResult describeResult$1;
            private final ClientQuotaEntity entity$1;
            private final BooleanRef alteredConfigs$1;
            private final AlterClientQuotasResult alterResult$1;

            public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
                Assert.assertTrue((boolean)filter.strict());
                scala.collection.immutable.Seq components = AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)filter.components()).asScala().toSeq();
                Option option = this.userComponent$1;
                if (option == null) {
                    throw null;
                }
                Option foreach_this = option;
                if (!foreach_this.isEmpty()) {
                    ClientQuotaFilterComponent clientQuotaFilterComponent = (ClientQuotaFilterComponent)foreach_this.get();
                    $anon$1.$anonfun$describeClientQuotas$1(components, clientQuotaFilterComponent);
                }
                Object var4_4 = null;
                Option option2 = this.clientIdComponent$1;
                if (option2 == null) {
                    throw null;
                }
                Option foreach_this2 = option2;
                if (!foreach_this2.isEmpty()) {
                    ClientQuotaFilterComponent clientQuotaFilterComponent = (ClientQuotaFilterComponent)foreach_this2.get();
                    $anon$1.$anonfun$describeClientQuotas$2(components, clientQuotaFilterComponent);
                }
                this.describedConfigs$1.elem = true;
                return this.describeResult$1;
            }

            /*
             * WARNING - void declaration
             */
            public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries, AlterClientQuotasOptions options) {
                void apply_elems;
                Assert.assertFalse((boolean)options.validateOnly());
                Assert.assertEquals((long)1L, (long)entries.size());
                ClientQuotaAlteration alteration = (ClientQuotaAlteration)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, entries).asScala().head();
                Assert.assertEquals((Object)this.entity$1, (Object)alteration.entity());
                Iterable ops = AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)alteration.ops()).asScala();
                Assert.assertEquals((long)3L, (long)ops.size());
                Set$ set$ = Predef$.MODULE$.Set();
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaAlteration.Op[]{new ClientQuotaAlteration.Op("consumer_byte_rate", Double.valueOf(20000.0)), new ClientQuotaAlteration.Op("producer_byte_rate", Double.valueOf(10000.0)), new ClientQuotaAlteration.Op("request_percentage", null)});
                if (set$ == null) {
                    throw null;
                }
                arraySeq = null;
                Assert.assertEquals((Object)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Object)ops.toSet());
                this.alteredConfigs$1.elem = true;
                return this.alterResult$1;
            }

            public static final /* synthetic */ void $anonfun$describeClientQuotas$1(scala.collection.immutable.Seq components$1, ClientQuotaFilterComponent c) {
                Assert.assertTrue((boolean)components$1.contains((Object)c));
            }

            public static final /* synthetic */ void $anonfun$describeClientQuotas$2(scala.collection.immutable.Seq components$1, ClientQuotaFilterComponent c) {
                Assert.assertTrue((boolean)components$1.contains((Object)c));
            }
            {
                this.userComponent$1 = userComponent$1;
                this.clientIdComponent$1 = clientIdComponent$1;
                this.describedConfigs$1 = describedConfigs$1;
                this.describeResult$1 = describeResult$1;
                this.entity$1 = entity$1;
                this.alteredConfigs$1 = alteredConfigs$1;
                this.alterResult$1 = alterResult$1;
                super(Collections.singletonList(node$1), node$1);
            }

            public static final /* synthetic */ Object $anonfun$describeClientQuotas$1$adapted(scala.collection.immutable.Seq components$1, ClientQuotaFilterComponent c) {
                $anon$1.$anonfun$describeClientQuotas$1(components$1, c);
                return BoxedUnit.UNIT;
            }

            public static final /* synthetic */ Object $anonfun$describeClientQuotas$2$adapted(scala.collection.immutable.Seq components$1, ClientQuotaFilterComponent c) {
                $anon$1.$anonfun$describeClientQuotas$2(components$1, c);
                return BoxedUnit.UNIT;
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, createOpts);
        Assert.assertTrue((boolean)describedConfigs.elem);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldAddClientConfig() {
        this.testShouldAddClientConfig((Option<String>)new Some((Object)"test-user-1"), (Option<String>)new Some((Object)"test-client-1"));
        this.testShouldAddClientConfig((Option<String>)new Some((Object)"test-user-2"), (Option<String>)new Some(null));
        this.testShouldAddClientConfig((Option<String>)new Some((Object)"test-user-3"), (Option<String>)None$.MODULE$);
        this.testShouldAddClientConfig((Option<String>)new Some(null), (Option<String>)new Some((Object)"test-client-2"));
        this.testShouldAddClientConfig((Option<String>)new Some(null), (Option<String>)new Some(null));
        this.testShouldAddClientConfig((Option<String>)new Some(null), (Option<String>)None$.MODULE$);
        this.testShouldAddClientConfig((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"test-client-3"));
        this.testShouldAddClientConfig((Option<String>)None$.MODULE$, (Option<String>)new Some(null));
    }

    @Test
    public void shouldNotAlterNonQuotaClientConfigUsingBootstrapServer() {
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(Collections.singletonList(node), node);
        ConfigCommandTest.verifyCommand$1("users", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--add-config", "consumer_byte_rate=20000,producer_byte_rate=10000,some_config=10"}), mockAdminClient);
        ConfigCommandTest.verifyCommand$1("clients", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--add-config", "some_config=10"}), mockAdminClient);
        ConfigCommandTest.verifyCommand$1("users", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--delete-config", "consumer_byte_rate=20000,some_config=10"}), mockAdminClient);
        ConfigCommandTest.verifyCommand$1("clients", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--delete-config", "some_config=10"}), mockAdminClient);
    }

    @Test
    public void shouldAddTopicConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(null, this.zkClient()));
    }

    @Test
    public void shouldAlterTopicConfig() {
        this.doShouldAlterTopicConfig(false);
    }

    @Test
    public void shouldAlterTopicConfigFile() {
        this.doShouldAlterTopicConfig(true);
    }

    /*
     * WARNING - void declaration
     */
    public void doShouldAlterTopicConfig(boolean file) {
        BooleanRef booleanRef;
        String string;
        String filePath = "";
        Seq addedConfigs = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"delete.retention.ms=1000000", "min.insync.replicas=2"}));
        if (file) {
            void mkString_sep;
            String string2 = "\n";
            if (addedConfigs == null) {
                throw null;
            }
            string2 = null;
            filePath = TestUtils.tempFile((String)addedConfigs.mkString("", (String)mkString_sep, "")).getPath();
        }
        String resourceName = "my-topic";
        String[] stringArray = new String[11];
        stringArray[0] = "--bootstrap-server";
        stringArray[1] = "localhost:9092";
        stringArray[2] = "--entity-name";
        stringArray[3] = resourceName;
        stringArray[4] = "--entity-type";
        stringArray[5] = "topics";
        stringArray[6] = "--alter";
        String string3 = stringArray[7] = file ? "--add-config-file" : "--add-config";
        if (file) {
            string = filePath;
        } else {
            void mkString_sep;
            String string4 = ",";
            if (addedConfigs == null) {
                throw null;
            }
            string = addedConfigs.mkString("", (String)mkString_sep, "");
            string4 = null;
        }
        stringArray[8] = string;
        stringArray[9] = "--delete-config";
        stringArray[10] = "unclean.leader.election.enable";
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(stringArray);
        boolean create_e = false;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef alteredConfigs = booleanRef2;
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "1"), (List)new .colon.colon((Object)ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", "1"), (List)Nil$.MODULE$))).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(this, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String resourceName$1;
            private final DescribeConfigsResult describeResult$2;
            private final BooleanRef alteredConfigs$2;
            private final AlterConfigsResult alterResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$1);
                return this.describeResult$2;
            }

            /*
             * WARNING - void declaration
             */
            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                void apply_elems;
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.TOPIC, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Set$ set$ = Predef$.MODULE$.Set();
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("delete.retention.ms", "1000000"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "2"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", ""), AlterConfigOp.OpType.DELETE)});
                if (set$ == null) {
                    throw null;
                }
                arraySeq = null;
                Assert.assertEquals((Object)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Object)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, alterConfigOps).asScala().toSet());
                this.alteredConfigs$2.elem = true;
                return this.alterResult$2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resourceName$1 = resourceName$1;
                this.describeResult$2 = describeResult$2;
                this.alteredConfigs$2 = alteredConfigs$2;
                this.alterResult$2 = alterResult$2;
                super(Collections.singletonList(node$2), node$2);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldDescribeConfigSynonyms() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--describe", "--all"});
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(Collections.emptyList())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resource, describeResult){
            private final ConfigResource resource$1;
            private final DescribeConfigsResult describeResult$3;

            /*
             * WARNING - void declaration
             */
            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                void apply_elems;
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                Set$ set$ = Predef$.MODULE$.Set();
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.resource$1});
                if (set$ == null) {
                    throw null;
                }
                arraySeq = null;
                Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, resources).asScala().toSet());
                return this.describeResult$3;
            }
            {
                this.resource$1 = resource$1;
                this.describeResult$3 = describeResult$3;
                super(Collections.singletonList(node$3), node$3);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldAddBrokerQuotaConfig() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"10", (Object)configChange.get("leader.replication.throttled.rate"));
                Assert.assertEquals((Object)"20", (Object)configChange.get("follower.replication.throttled.rate"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, alterOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(null, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.log.LogCleaner", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.ReplicaManager", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$))));
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInZKIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--zookeeper", (List)new .colon.colon((Object)this.zkConnect(), (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInBootstrapServerIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllBrokerConfig() {
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllTopicConfig() {
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Topic(), "--entity-name", "foo", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDescribeAllBrokerConfigBootstrapServerRequired() {
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithDescribeBrokerLoggerIsNotAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigCommand$.MODULE$.BrokerLoggerConfigType(), (List)new .colon.colon((Object)"--entity-default", (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$))))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithAlterBrokerLoggerIsNotAllowed() {
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--entity-default", "--alter", "--add-config", "kafka.log.LogCleaner=DEBUG"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldRaiseInvalidConfigurationExceptionWhenAddingInvalidBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", (List<String>)new .colon.colon((Object)"--entity-default", (List)Nil$.MODULE$));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", (List<String>)new .colon.colon((Object)"--entity-name", (List)new .colon.colon((Object)"1", (List)Nil$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyAlterBrokerConfig(Node node, String resourceName, List<String> resourceOpts) {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        List optsList = (List)new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)"brokers", (List)new .colon.colon((Object)"--alter", (List)new .colon.colon((Object)"--add-config", (List)new .colon.colon((Object)"message.max.bytes=10", (List)Nil$.MODULE$))))))).concat(resourceOpts);
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        Object[] objectArray = new Tuple2[1];
        String string = "5";
        String $minus$greater$extension_$this = "num.io.threads";
        Object var14_7 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        scala.collection.mutable.Map brokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        java.util.List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, brokerConfigs, alterResult){
            private final String resourceName$2;
            private final DescribeConfigsResult describeResult$4;
            private final scala.collection.mutable.Map brokerConfigs$1;
            private final AlterConfigsResult alterResult$3;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$2, (Object)resource.name());
                return this.describeResult$4;
            }

            public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Config config = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                config.entries().forEach(e -> $this.brokerConfigs$1.put((Object)e.name(), (Object)e.value()));
                return this.alterResult$3;
            }
            {
                this.resourceName$2 = resourceName$2;
                this.describeResult$4 = describeResult$4;
                this.brokerConfigs$1 = brokerConfigs$1;
                this.alterResult$3 = alterResult$3;
                super(Collections.singletonList(node$4), node$4);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[2];
        String string2 = "10";
        String $minus$greater$extension_$this2 = "message.max.bytes";
        Object var16_17 = null;
        string2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string3 = "5";
        String $minus$greater$extension_$this3 = "num.io.threads";
        Object var18_19 = null;
        string3 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Object)brokerConfigs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldDescribeConfigBrokerWithoutEntityName() {
        void apply_elems;
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--describe"});
        String BrokerDefaultEntityName = "";
        ConfigResource resourceCustom = new ConfigResource(ConfigResource.Type.BROKER, "1");
        ConfigResource resourceDefault = new ConfigResource(ConfigResource.Type.BROKER, BrokerDefaultEntityName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        Config emptyConfig = new Config(Collections.emptyList());
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = new Tuple2((Object)resourceCustom, (Object)emptyConfig);
        objectArray[1] = new Tuple2((Object)resourceDefault, (Object)emptyConfig);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        java.util.Map resultMap = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems))).asJava();
        future.complete((Object)resultMap);
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).times(2);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceCustom, resourceDefault, describeResult){
            private final ConfigResource resourceCustom$1;
            private final ConfigResource resourceDefault$1;
            private final DescribeConfigsResult describeResult$5;

            /*
             * Unable to fully structure code
             */
            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                v0 = this.resourceCustom$1.name();
                var4_4 = resource.name();
                if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
                v1 = this.resourceDefault$1.name();
                var5_5 = resource.name();
                if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                Assert.assertTrue((boolean)v2);
                Assert.assertEquals((long)1L, (long)resources.size());
                return this.describeResult$5;
            }
            {
                this.resourceCustom$1 = resourceCustom$1;
                this.resourceDefault$1 = resourceDefault$1;
                this.describeResult$5 = describeResult$5;
                super(Collections.singletonList(node$5), node$5);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.verify((Object[])new Object[]{describeResult});
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    public void verifyAlterBrokerLoggerConfig(Node node, String resourceName, String entityName, List<ConfigEntry> describeConfigEntries) {
        BooleanRef booleanRef;
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--alter", "--entity-name", entityName, "--add-config", "kafka.log.LogCleaner=DEBUG", "--delete-config", "kafka.server.ReplicaManager,kafka.server.KafkaApi"}));
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        boolean create_e = false;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef alteredConfigs = booleanRef2;
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, describeConfigEntries).asJava())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final String resourceName$3;
            private final DescribeConfigsResult describeResult$6;
            private final BooleanRef alteredConfigs$3;
            private final AlterConfigsResult alterResult$4;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$3, (Object)resource.name());
                return this.describeResult$6;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Assert.assertEquals((Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "DEBUG"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaApi", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (Object)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, alterConfigOps).asScala().toList());
                this.alteredConfigs$3.elem = true;
                return this.alterResult$4;
            }
            {
                this.resourceName$3 = resourceName$3;
                this.describeResult$6 = describeResult$6;
                this.alteredConfigs$3 = alteredConfigs$3;
                this.alterResult$4 = alterResult$4;
                super(Collections.singletonList(node$6), node$6);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldSupportCommaSeparatedValuesUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(null, this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityNameUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void apply_elems3;
        void $minus$greater$extension_y7;
        void apply_elems4;
        void $minus$greater$extension_y8;
        void apply_elems5;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_y10;
        void apply_elems6;
        void apply_elems7;
        void $minus$greater$extension_y11;
        void apply_elems8;
        void apply_elems9;
        void apply_elems10;
        void $minus$greater$extension_y12;
        void apply_elems11;
        void $minus$greater$extension_y13;
        void apply_elems12;
        void $minus$greater$extension_y14;
        void apply_elems13;
        void $minus$greater$extension_y15;
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        String[] alterOpts = new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "brokers", "--alter"};
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        String string = "110000";
        String $minus$greater$extension_$this = "message.max.size";
        Object var12_5 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y15);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems13), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        scala.collection.immutable.Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        String string2 = "120000";
        String $minus$greater$extension_$this2 = "message.max.size";
        Object var14_8 = null;
        string2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y14);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems12), (Option)None$.MODULE$, alterOpts, adminZkClient);
        scala.collection.immutable.Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        String string3 = "130000";
        String $minus$greater$extension_$this3 = "message.max.size";
        Object var16_11 = null;
        string3 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y13);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems11), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        scala.collection.immutable.Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        String string4 = "140000";
        String $minus$greater$extension_$this4 = "message.max.size";
        Object var18_14 = null;
        string4 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y12);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$4, (scala.collection.immutable.Seq)apply_elems10), (Option)None$.MODULE$, alterOpts, adminZkClient);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"});
        if (set$ == null) {
            throw null;
        }
        arraySeq5 = null;
        this.deleteAndVerifyConfig$1((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems9), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"});
        if (set$2 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.deleteAndVerifyConfig$1((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems8), (Option)None$.MODULE$, alterOpts, adminZkClient);
        scala.collection.immutable.Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[1];
        String string5 = "/tmp/test.jks";
        String $minus$greater$extension_$this5 = "listener.name.external.ssl.keystore.location";
        Object var20_19 = null;
        string5 = null;
        objectArray5[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y11);
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        arraySeq7 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$5, (scala.collection.immutable.Seq)apply_elems7), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "/tmp/test.jks";
            String $minus$greater$extension_$this = "ssl.keystore.location";
            Object var4_5 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 984));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "/tmp/test.jks";
            String $minus$greater$extension_$this = "listener.name.external.ssl.keystore.location";
            Object var3_4 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)None$.MODULE$, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.ssl.keystore.location"});
        if (set$3 == null) {
            throw null;
        }
        arraySeq8 = null;
        this.deleteAndVerifyConfig$1((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems6), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "secret";
            String $minus$greater$extension_$this = "listener.name.external.ssl.keystore.password";
            Object var4_5 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 991));
        scala.collection.immutable.Map$ map$6 = Predef$.MODULE$.Map();
        Object[] objectArray6 = new Tuple2[2];
        String string6 = "secret";
        String $minus$greater$extension_$this6 = "listener.name.external.ssl.keystore.password";
        Object var22_23 = null;
        string6 = null;
        objectArray6[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y10);
        String string7 = "2";
        String $minus$greater$extension_$this7 = "log.cleaner.threads";
        Object var24_25 = null;
        string7 = null;
        objectArray6[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y9);
        ArraySeq arraySeq9 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray6);
        if (map$6 == null) {
            throw null;
        }
        arraySeq9 = null;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$6, (scala.collection.immutable.Seq)apply_elems5);
        scala.collection.immutable.Map$ map$7 = Predef$.MODULE$.Map();
        Object[] objectArray7 = new Tuple2[1];
        String string8 = "encoder-secret";
        String $minus$greater$extension_$this8 = KafkaConfig$.MODULE$.PasswordEncoderSecretProp();
        Object var26_29 = null;
        string8 = null;
        objectArray7[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        ArraySeq arraySeq10 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray7);
        if (map$7 == null) {
            throw null;
        }
        arraySeq10 = null;
        scala.collection.immutable.Map encoderConfigs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$7, (scala.collection.immutable.Seq)apply_elems4);
        this.alterConfigWithZk$1(configs, (Option)new Some((Object)brokerId), encoderConfigs, alterOpts, adminZkClient);
        Properties brokerConfigs = this.zkClient().getEntityConfigs("brokers", brokerId);
        Assert.assertFalse((String)"Encoder secret stored in ZooKeeper", (boolean)brokerConfigs.contains(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()));
        Assert.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs);
        Assert.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assert.assertEquals((long)configs.size(), (long)brokerConfigs.size());
        scala.collection.immutable.Map$ map$8 = Predef$.MODULE$.Map();
        Object[] objectArray8 = new Tuple2[1];
        String string9 = "secret2";
        String $minus$greater$extension_$this9 = "listener.name.internal.ssl.keystore.password";
        Object var28_36 = null;
        string9 = null;
        objectArray8[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y7);
        ArraySeq arraySeq11 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray8);
        if (map$8 == null) {
            throw null;
        }
        arraySeq11 = null;
        scala.collection.immutable.Map configs2 = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$8, (scala.collection.immutable.Seq)apply_elems3);
        scala.collection.immutable.Map$ map$9 = Predef$.MODULE$.Map();
        Object[] objectArray9 = new Tuple2[5];
        String string10 = "encoder-secret";
        String $minus$greater$extension_$this10 = KafkaConfig$.MODULE$.PasswordEncoderSecretProp();
        Object var30_40 = null;
        string10 = null;
        objectArray9[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y6);
        String string11 = "DES/CBC/PKCS5Padding";
        String $minus$greater$extension_$this11 = KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp();
        Object var32_42 = null;
        string11 = null;
        objectArray9[1] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y5);
        String string12 = "1024";
        String $minus$greater$extension_$this12 = KafkaConfig$.MODULE$.PasswordEncoderIterationsProp();
        Object var34_44 = null;
        string12 = null;
        objectArray9[2] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y4);
        String string13 = "PBKDF2WithHmacSHA1";
        String $minus$greater$extension_$this13 = KafkaConfig$.MODULE$.PasswordEncoderKeyFactoryAlgorithmProp();
        Object var36_46 = null;
        string13 = null;
        objectArray9[3] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y3);
        String string14 = "64";
        String $minus$greater$extension_$this14 = KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp();
        Object var38_48 = null;
        string14 = null;
        objectArray9[4] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq12 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray9);
        if (map$9 == null) {
            throw null;
        }
        arraySeq12 = null;
        scala.collection.immutable.Map encoderConfigs2 = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$9, (scala.collection.immutable.Seq)apply_elems2);
        this.alterConfigWithZk$1(configs2, (Option)new Some((Object)brokerId), encoderConfigs2, alterOpts, adminZkClient);
        String encodedPassword2 = this.zkClient().getEntityConfigs("brokers", brokerId).getProperty("listener.name.internal.ssl.keystore.password");
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs).decode(encodedPassword2).value());
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs2).decode(encodedPassword2).value());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.alterConfigWithZk$1(configs, (Option)None$.MODULE$, encoderConfigs, alterOpts, adminZkClient), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1020));
        this.registerBrokerInZk(Integer.parseInt(brokerId));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "210000";
            String $minus$greater$extension_$this = "message.max.size";
            Object var4_5 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "220000";
            String $minus$greater$extension_$this = "message.max.size";
            Object var3_4 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)None$.MODULE$, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
        scala.collection.immutable.Map$ map$10 = Predef$.MODULE$.Map();
        Object[] objectArray10 = new Tuple2[1];
        String string15 = "230000";
        String $minus$greater$extension_$this15 = "message.max.size";
        Object var40_53 = null;
        string15 = null;
        objectArray10[0] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq13 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray10);
        if (map$10 == null) {
            throw null;
        }
        arraySeq13 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$10, (scala.collection.immutable.Seq)apply_elems), (Option)new Some((Object)"2"), alterOpts, adminZkClient);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeletedUsingZookeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeleted() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"});
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)Nil$.MODULE$).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult){
            private final String resourceName$4;
            private final DescribeConfigsResult describeResult$7;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$4);
                return this.describeResult$7;
            }
            {
                this.resourceName$4 = resourceName$4;
                this.describeResult$7 = describeResult$7;
                super(Collections.singletonList(node$7), node$7);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, createOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            /*
             * WARNING - void declaration
             */
            public Properties fetchEntityConfig(String entityType, String entityName) {
                void var3_3;
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return var3_3;
            }

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(null, this.zkClient()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testScramCredentials() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        LazyRef CredentialChange$module = new LazyRef();
        scala.collection.mutable.Map credentials = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        public class Kafka_admin_ConfigCommandTest$CredentialChange$1
        extends AdminZkClient
        implements Product,
        Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final scala.collection.mutable.Map credentials$1;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0 & Serializable)() -> new Properties());
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1 & Serializable)mechanism -> {
                    String value = configChange.getProperty((String)mechanism);
                    Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                    ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                    Assert.assertEquals((long)this.iterations(), (long)scramCredential.iterations());
                    return $this.credentials$1.put((Object)this.user(), (Object)configChange);
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$1 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$1(this.$outer, user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return this.user();
                    }
                    case 1: {
                        return this.mechanisms();
                    }
                    case 2: {
                        return this.iterations();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return new /* Unavailable Anonymous Inner Class!! */;
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "user";
                    }
                    case 1: {
                        return "mechanisms";
                    }
                    case 2: {
                        return "iterations";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)"CredentialChange".hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                int finalizeHash_length = 3;
                return Statics.avalanche((int)(n ^ finalizeHash_length));
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                if (!(x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$1 var3_3 = (Kafka_admin_ConfigCommandTest$CredentialChange$1)x$1;
                if (this.iterations() != var3_3.iterations()) return false;
                String string = this.user();
                String string2 = var3_3.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var3_3.mechanisms();
                if (set == null) {
                    if (set2 == null) return true;
                    return false;
                } else {
                    if (!set.equals(set2)) return false;
                    return true;
                }
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$1(String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                super($outer.zkClient());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$changeUserOrUserClientIdConfig$1(kafka.admin.ConfigCommandTest$CredentialChange$1 java.util.Properties java.lang.String ), $anonfun$fetchEntityConfig$1()}, serializedLambda);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsA, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userA", (Set<String>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems4)), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsB, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems3)), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del256, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems2)), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        Set$ set$4 = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$4 == null) {
            throw null;
        }
        nil$ = null;
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del512, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems)), 4096));
    }

    /*
     * WARNING - void declaration
     */
    public void doTestQuotaConfigEntity(boolean zkConfig) {
        void $plus$plus$extension_evidence$25;
        void $plus$plus$extension_evidence$252;
        void $plus$plus$extension_evidence$253;
        void $plus$plus$extension_evidence$254;
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        String[] describeOpts = new String[]{"--describe"};
        String[] alterOpts = new String[]{"--alter", "--add-config", "a=b,c=d"};
        String clientId = "client-1";
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts})).foreach((Function1 & Serializable)opts -> {
            ConfigCommandTest.$anonfun$doTestQuotaConfigEntity$1(clientId, connectOpts, opts);
            return BoxedUnit.UNIT;
        });
        ConfigCommandTest.checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts, connectOpts);
        ConfigCommandTest.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts, connectOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts})).foreach((Function1 & Serializable)opts -> {
            ConfigCommandTest.$anonfun$doTestQuotaConfigEntity$2(principal, sanitizedPrincipal, connectOpts, opts);
            return BoxedUnit.UNIT;
        });
        ConfigCommandTest.checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts, connectOpts);
        ConfigCommandTest.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts, connectOpts);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts})).foreach((Function1 & Serializable)opts -> {
            ConfigCommandTest.$anonfun$doTestQuotaConfigEntity$3(principal, userClient, clientId, sanitizedPrincipal, describeOpts, connectOpts, opts);
            return BoxedUnit.UNIT;
        });
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = new String[]{"--entity-type", "clients"};
        Object var9_10 = null;
        classTag = null;
        ConfigCommandTest.checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder(8).append(sanitizedPrincipal).append("/clients").toString(), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)describeOpts, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$254), connectOpts);
        ClassTag classTag2 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs2 = new String[]{"--entity-type", "clients"};
        Object var11_12 = null;
        classTag2 = null;
        ConfigCommandTest.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts, (Object)$plus$plus$extension_xs2, (ClassTag)$plus$plus$extension_evidence$253), connectOpts);
        ClassTag classTag3 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs3 = ConfigCommandTest.clientIdOpts$1(clientId);
        Object var13_14 = null;
        classTag3 = null;
        ConfigCommandTest.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts, (Object)$plus$plus$extension_xs3, (ClassTag)$plus$plus$extension_evidence$252), connectOpts);
        ClassTag classTag4 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs4 = new String[]{"--entity-type", "clients"};
        Object var15_16 = null;
        classTag4 = null;
        ConfigCommandTest.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts, (Object)$plus$plus$extension_xs4, (ClassTag)$plus$plus$extension_evidence$25), connectOpts);
    }

    @Test
    public void testQuotaConfigEntityUsingZookeeper() {
        this.doTestQuotaConfigEntity(true);
    }

    @Test
    public void testQuotaConfigEntity() {
        this.doTestQuotaConfigEntity(false);
    }

    public void doTestUserClientQuotaOpts(boolean zkConfig) {
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        ConfigCommandTest.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}), connectOpts);
        ConfigCommandTest.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}), connectOpts);
        ConfigCommandTest.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}), connectOpts);
        ConfigCommandTest.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}), connectOpts);
        ConfigCommandTest.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}), connectOpts);
        ConfigCommandTest.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}), connectOpts);
        ConfigCommandTest.checkEntity$2("users", new StringBuilder(8).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}), connectOpts);
        ConfigCommandTest.checkEntity$2("users", "/clients", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}), connectOpts);
        ConfigCommandTest.checkEntity$2("users", new StringBuilder(9).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/").append(Sanitizer.sanitize((String)"client1?@%")).toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}), connectOpts);
    }

    @Test
    public void testUserClientQuotaOptsUsingZookeeper() {
        this.doTestUserClientQuotaOpts(true);
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.doTestUserClientQuotaOpts(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaDescribeEntities() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void apply_elems3;
        void $minus$greater$extension_y3;
        void apply_elems4;
        void $minus$greater$extension_y4;
        void apply_elems5;
        void $minus$greater$extension_y5;
        void apply_elems6;
        void $minus$greater$extension_y6;
        void apply_elems7;
        void $minus$greater$extension_y7;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        String[] opts = new String[]{"--entity-type", "clients", "--entity-name", clientId};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = new String[]{"--entity-type", "clients", "--entity-default"};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = new String[]{"--entity-type", "clients"};
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{clientId}));
        String $minus$greater$extension_$this = "clients";
        Object var9_8 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y7);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems7), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-name", principal};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-default"};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = new String[]{"--entity-type", "users"};
        scala.collection.immutable.Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal}));
        String $minus$greater$extension_$this2 = "users";
        Object var11_11 = null;
        seqOps2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y6);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems6), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append(sanitizedPrincipal).append("/clients/<default>").toString()})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"};
        scala.collection.immutable.Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"}));
        String $minus$greater$extension_$this3 = new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString();
        Object var13_14 = null;
        seqOps3 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y5);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems5), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-4").toString()})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"};
        scala.collection.immutable.Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        SeqOps seqOps4 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"}));
        String $minus$greater$extension_$this4 = "users/<default>/clients";
        Object var15_17 = null;
        seqOps4 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$4, (scala.collection.immutable.Seq)apply_elems4), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-type", "clients"};
        scala.collection.immutable.Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[1];
        SeqOps seqOps5 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"}));
        String $minus$greater$extension_$this5 = new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString();
        Object var17_20 = null;
        seqOps5 = null;
        objectArray5[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$5, (scala.collection.immutable.Seq)apply_elems3);
        scala.collection.immutable.Map$ map$6 = Predef$.MODULE$.Map();
        Object[] objectArray6 = new Tuple2[1];
        SeqOps seqOps6 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"}));
        String $minus$greater$extension_$this6 = "users/<default>/clients";
        Object var19_24 = null;
        seqOps6 = null;
        objectArray6[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray6);
        if (map$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$6, (scala.collection.immutable.Seq)apply_elems2);
        scala.collection.immutable.Map$ map$7 = Predef$.MODULE$.Map();
        Object[] objectArray7 = new Tuple2[1];
        SeqOps seqOps7 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal}));
        String $minus$greater$extension_$this7 = "users";
        Object var21_28 = null;
        seqOps7 = null;
        objectArray7[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray7);
        if (map$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)((MapOps)((MapOps)MapFactory.apply$((MapFactory)map$7, (scala.collection.immutable.Seq)apply_elems)).$plus$plus((IterableOnce)defaultUserMap)).$plus$plus((IterableOnce)userMap), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-2").toString()})), zkClient);
    }

    private void registerBrokerInZk(int id) {
        this.zkClient().createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$), ApiVersion$.MODULE$.latestVersion(), 9192);
        this.zkClient().registerBroker(brokerInfo);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertNonZeroStatusExit$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)status);
        throw new RuntimeException();
    }

    private static final void testExpectedEntityTypeNames$1(List expectedTypes, List expectedNames, scala.collection.immutable.Seq args, Tuple2 connectOpts$1) {
        ClassTag $plus$plus$extension_evidence$24 = ClassTag$.MODULE$.apply(String.class);
        Object var5_4 = null;
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)new String[]{(String)connectOpts$1._1(), (String)connectOpts$1._2(), "--describe"}, (IterableOnce)args, $plus$plus$extension_evidence$24));
        createOpts.checkArgs();
        Assert.assertEquals((Object)createOpts.entityTypes(), (Object)expectedTypes);
        Assert.assertEquals((Object)createOpts.entityNames(), (Object)expectedNames);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Tuple3 toValues$1(Option entityName, String entityType, String command) {
        boolean bl = false;
        Some some = null;
        if (entityName instanceof Some) {
            bl = true;
            some = (Some)entityName;
            if ((String)some.value() == null) {
                return new Tuple3((Object)new String[]{"--entity-type", command, "--entity-default"}, (Object)new Some(null), (Object)new Some((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)entityType)));
            }
        }
        if (bl) {
            String name = (String)some.value();
            return new Tuple3((Object)new String[]{"--entity-type", command, "--entity-name", name}, (Object)new Some((Object)name), (Object)new Some((Object)ClientQuotaFilterComponent.ofEntity((String)entityType, (String)name)));
        }
        if (!None$.MODULE$.equals(entityName)) throw new MatchError((Object)entityName);
        return new Tuple3((Object)new String[0], (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$testShouldAddClientConfig$1(HashMap entityMap$1, String u) {
        return entityMap$1.put("user", u);
    }

    public static final /* synthetic */ String $anonfun$testShouldAddClientConfig$2(HashMap entityMap$1, String c) {
        return entityMap$1.put("client-id", c);
    }

    private static final void verifyCommand$1(String entityType, scala.collection.immutable.Seq alterOpts, MockAdminClient mockAdminClient$1) {
        ClassTag $plus$plus$extension_evidence$24 = ClassTag$.MODULE$.apply(String.class);
        Object var5_3 = null;
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", entityType, "--entity-name", "admin", "--alter"}, (IterableOnce)alterOpts, $plus$plus$extension_evidence$24));
        IllegalArgumentException e = (IllegalArgumentException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient$1, opts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        Assert.assertTrue((String)new StringBuilder(22).append("Unexpected exception: ").append(e).toString(), (boolean)e.getMessage().contains("some_config"));
    }

    public static final ConfigEntry kafka$admin$ConfigCommandTest$$newConfigEntry$1(String name, String value) {
        return ConfigTest.newConfigEntry((String)name, (String)value, (ConfigEntry.ConfigSource)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, (boolean)false, (boolean)false, (java.util.List)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)Nil$.MODULE$).asJava());
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$1(String id) {
        return new String[]{"--entity-name", id};
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() {
        return new String[]{"--entity-default"};
    }

    private static final String[] entityOpt$1(Option brokerId) {
        Object object = brokerId.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommandTest.$anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$1((String)brokerId.get()));
        None$ none$ = object;
        object = null;
        None$ getOrElse_this = none$;
        Object object2 = getOrElse_this.isEmpty() ? ConfigCommandTest.$anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() : getOrElse_this.get();
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private final void alterConfigWithZk$1(scala.collection.immutable.Map configs, Option brokerId, scala.collection.immutable.Map encoderConfigs, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        void $plus$plus$extension_evidence$25;
        void mkString_sep;
        String string;
        IterableOnceOps iterableOnceOps = (IterableOnceOps)configs.$plus$plus((IterableOnce)encoderConfigs).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        });
        String string2 = ",";
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps mkString_this = iterableOnceOps;
        String string3 = string = mkString_this.mkString("", (String)mkString_sep, "");
        Object var8_7 = null;
        string2 = null;
        string = null;
        String configStr = string3;
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = ConfigCommandTest.entityOpt$1(brokerId);
        Object var11_11 = null;
        classTag = null;
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)((Object[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts$1, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$25)), (Object)new String[]{"--add-config", configStr}, ClassTag$.MODULE$.apply(String.class)));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), addOpts, adminZkClient$1);
    }

    private static final scala.collection.immutable.Map alterConfigWithZk$default$3$1() {
        Predef$.MODULE$.Map();
        return Map.EmptyMap$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$4() {
        return ConfigEntityName$.MODULE$.Default();
    }

    private final void verifyConfig$1(scala.collection.immutable.Map configs, Option brokerId) {
        Object object;
        KafkaZkClient kafkaZkClient = this.zkClient();
        if (brokerId == null) {
            throw null;
        }
        if (brokerId.isEmpty()) {
            String string;
            String string2 = string = ConfigEntityName$.MODULE$.Default();
            string = null;
            object = string2;
        } else {
            object = brokerId.get();
        }
        Object object2 = object;
        object = null;
        Properties entityConfigs = kafkaZkClient.getEntityConfigs("brokers", (String)object2);
        Assert.assertEquals((Object)configs, (Object)AsScalaExtensions.PropertiesHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Properties)entityConfigs).asScala());
    }

    private final void alterAndVerifyConfig$1(scala.collection.immutable.Map configs, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        this.alterConfigWithZk$1(configs, brokerId, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts$1, adminZkClient$1);
        this.verifyConfig$1(configs, brokerId);
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteAndVerifyConfig$1(Set configNames, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        void $plus$plus$extension_evidence$25;
        void mkString_sep;
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = ConfigCommandTest.entityOpt$1(brokerId);
        Object var6_6 = null;
        classTag = null;
        String[] stringArray = new String[2];
        stringArray[0] = "--delete-config";
        String string = ",";
        if (configNames == null) {
            throw null;
        }
        string = null;
        stringArray[1] = configNames.mkString("", (String)mkString_sep, "");
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)((Object[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts$1, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$25)), (Object)stringArray, ClassTag$.MODULE$.apply(String.class)));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), deleteOpts, adminZkClient$1);
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        this.verifyConfig$1((scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, brokerId);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config});
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism});
    }

    private final /* synthetic */ ConfigCommandTest$CredentialChange$2$ CredentialChange$lzycompute$1(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        synchronized (CredentialChange$module$1) {
            ConfigCommandTest$CredentialChange$2$ configCommandTest$CredentialChange$2$ = CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$2$)CredentialChange$module$1.value() : (ConfigCommandTest$CredentialChange$2$)CredentialChange$module$1.initialize((Object)new ConfigCommandTest$CredentialChange$2$(this, credentials$1));
            return configCommandTest$CredentialChange$2$;
        }
    }

    private final ConfigCommandTest$CredentialChange$2$ CredentialChange$3(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        if (CredentialChange$module$1.initialized()) {
            return (ConfigCommandTest$CredentialChange$2$)CredentialChange$module$1.value();
        }
        return this.CredentialChange$lzycompute$1(CredentialChange$module$1, credentials$1);
    }

    private static final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs, Tuple2 connectOpts$2) {
        String[] stringArray;
        String[] optArray = new String[]{(String)connectOpts$2._1(), (String)connectOpts$2._2(), "--entity-type", entityType};
        if (entityName instanceof Some) {
            String name = (String)((Some)entityName).value();
            stringArray = new String[]{"--entity-name", name};
        } else if (None$.MODULE$.equals(entityName)) {
            stringArray = (String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)entityName);
        }
        ClassTag $plus$plus$extension_evidence$25 = ClassTag$.MODULE$.apply(String.class);
        Object var7_7 = null;
        ClassTag $plus$plus$extension_evidence$252 = ClassTag$.MODULE$.apply(String.class);
        Object var8_8 = null;
        return new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)((Object[])ArrayOps$.MODULE$.appendedAll$extension((Object)optArray, (Object)stringArray, $plus$plus$extension_evidence$25)), (Object)otherArgs, $plus$plus$extension_evidence$252));
    }

    private static final void checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs, Tuple2 connectOpts$2) {
        ConfigCommand.ConfigCommandOptions opts = ConfigCommandTest.createOpts$2(entityType, entityName, otherArgs, connectOpts$2);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private static final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs, Tuple2 connectOpts$2) {
        ConfigCommand.ConfigCommandOptions opts = ConfigCommandTest.createOpts$2(entityType, entityName, otherArgs, connectOpts$2);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            Assert.fail((String)"Did not fail with invalid argument list");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$doTestQuotaConfigEntity$1(String clientId$1, Tuple2 connectOpts$2, String[] opts) {
        ConfigCommandTest.checkEntity$1("clients", (Option)new Some((Object)clientId$1), clientId$1, opts, connectOpts$2);
        ConfigCommandTest.checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts, connectOpts$2);
    }

    public static final /* synthetic */ void $anonfun$doTestQuotaConfigEntity$2(String principal$1, String sanitizedPrincipal$1, Tuple2 connectOpts$2, String[] opts) {
        ConfigCommandTest.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1, opts, connectOpts$2);
        ConfigCommandTest.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts, connectOpts$2);
    }

    private static final String[] clientIdOpts$1(String name) {
        return new String[]{"--entity-type", "clients", "--entity-name", name};
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$doTestQuotaConfigEntity$3(String principal$1, String userClient$1, String clientId$1, String sanitizedPrincipal$1, String[] describeOpts$1, Tuple2 connectOpts$2, String[] opts) {
        void $plus$plus$extension_evidence$25;
        void $plus$plus$extension_evidence$252;
        void $plus$plus$extension_evidence$253;
        void $plus$plus$extension_evidence$254;
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = ConfigCommandTest.clientIdOpts$1(clientId$1);
        Object var7_8 = null;
        classTag = null;
        ConfigCommandTest.checkEntity$1("users", (Option)new Some((Object)principal$1), userClient$1, (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)opts, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$254), connectOpts$2);
        ClassTag classTag2 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs2 = ConfigCommandTest.clientIdOpts$1("");
        Object var9_10 = null;
        classTag2 = null;
        ConfigCommandTest.checkEntity$1("users", (Option)new Some((Object)principal$1), new StringBuilder(9).append(sanitizedPrincipal$1).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)opts, (Object)$plus$plus$extension_xs2, (ClassTag)$plus$plus$extension_evidence$253), connectOpts$2);
        ClassTag classTag3 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs3 = ConfigCommandTest.clientIdOpts$1(clientId$1);
        Object var11_12 = null;
        classTag3 = null;
        ConfigCommandTest.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(clientId$1).toString(), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)describeOpts$1, (Object)$plus$plus$extension_xs3, (ClassTag)$plus$plus$extension_evidence$252), connectOpts$2);
        ClassTag classTag4 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs4 = ConfigCommandTest.clientIdOpts$1("");
        Object var13_14 = null;
        classTag4 = null;
        ConfigCommandTest.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)opts, (Object)$plus$plus$extension_xs4, (ClassTag)$plus$plus$extension_evidence$25), connectOpts$2);
    }

    private static final void checkEntity$2(String expectedEntityType, String expectedEntityName, scala.collection.immutable.Seq args, Tuple2 connectOpts$3) {
        ClassTag $plus$plus$extension_evidence$24 = ClassTag$.MODULE$.apply(String.class);
        Object var6_4 = null;
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)new String[]{(String)connectOpts$3._1(), (String)connectOpts$3._2()}, (IterableOnce)args, $plus$plus$extension_evidence$24));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, KafkaZkClient zkClient$1) {
        void $colon$plus$extension_evidence$11;
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String $colon$plus$extension_x = "--describe";
        Object var6_5 = null;
        classTag = null;
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appended$extension((Object)opts, (Object)$colon$plus$extension_x, (ClassTag)$colon$plus$extension_evidence$11)));
        expectedFetches.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            Seq values = (Seq)x0$1._2();
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)zkClient$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
            return iExpectationSetters;
        });
        EasyMock.replay((Object[])new Object[]{zkClient$1});
        Seq entities = entity.getAllEntities(zkClient$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1 & Serializable)e -> e.fullSanitizedName()));
        EasyMock.reset((Object[])new Object[]{zkClient$1});
    }

    public class DummyAdminClient
    extends MockAdminClient {
        public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
            return (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        }

        public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
            return (DescribeClientQuotasResult)EasyMock.createNiceMock(DescribeClientQuotasResult.class);
        }

        public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries, AlterClientQuotasOptions options) {
            return (AlterClientQuotasResult)EasyMock.createNiceMock(AlterClientQuotasResult.class);
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminClient(Node node) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
        }
    }

    public class DummyAdminZkClient
    extends AdminZkClient {
        public void changeBrokerConfig(Seq<Object> brokerIds, Properties configs) {
        }

        public Properties fetchEntityConfig(String entityType, String entityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String clientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminZkClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminZkClient(KafkaZkClient zkClient) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(zkClient);
        }
    }
}

