/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.security.auth.login.Configuration;
import kafka.admin.ZkSecurityMigrator$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ReplicaAssignment;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkData$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=f\u0001B\f\u0019\u0001}AQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0019\u0005\u0001)A\u0005{!)A\t\u0001C!\u000b\")Q\u000b\u0001C!\u000b\")!\f\u0001C\u0001\u000b\")q\f\u0001C\u0001\u000b\")\u0011\r\u0001C\u0005E\"I\u0011q\u0003\u0001\u0012\u0002\u0013%\u0011\u0011\u0004\u0005\u0007\u0003_\u0001A\u0011A#\t\r\u0005M\u0002\u0001\"\u0001F\u0011\u0019\t9\u0004\u0001C\u0001\u000b\"1\u00111\b\u0001\u0005\u0002\u0015Ca!a\u0010\u0001\t\u0003)\u0005bBA\"\u0001\u0011%\u0011Q\t\u0005\b\u00033\u0002A\u0011BA.\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBa!a%\u0001\t\u0013)\u0005bBAK\u0001\u0011%\u0011q\u0013\u0005\u0007\u0003W\u0003A\u0011A#\u0003'i[\u0017)\u001e;i_JL'0\u0019;j_:$Vm\u001d;\u000b\u0005eQ\u0012\u0001B1vi\"T!a\u0007\u000f\u0002\u0011M,7-\u001e:jifT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0003Gq\t!A_6\n\u0005\u0015\u0012#\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002(U5\t\u0001F\u0003\u0002*9\u0005)Q\u000f^5mg&\u00111\u0006\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u00020\u00015\t\u0001$\u0001\u0005kC\u0006\u001ch)\u001b7f+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\tIwNC\u00018\u0003\u0011Q\u0017M^1\n\u0005e\"$\u0001\u0002$jY\u0016\f\u0011B[1bg\u001aKG.\u001a\u0011\u0002\u0019\u0005,H\u000f\u001b)s_ZLG-\u001a:\u0016\u0003u\u0002\"AP!\u000e\u0003}R!\u0001\u0011\u001c\u0002\t1\fgnZ\u0005\u0003\u0005~\u0012aa\u0015;sS:<\u0017!D1vi\"\u0004&o\u001c<jI\u0016\u0014\b%A\u0003tKR,\u0006\u000fF\u0001G!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0011)f.\u001b;)\u0005\u0019i\u0005C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0016aA8sO&\u0011Ak\u0014\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D#aB,\u0011\u00059C\u0016BA-P\u0005\u0015\te\r^3s\u0003]!Xm\u001d;Jgj[7+Z2ve&$\u00180\u00128bE2,G\r\u000b\u0002\t9B\u0011a*X\u0005\u0003=>\u0013A\u0001V3ti\u0006\tB/Z:u\u0017\u000647.\u0019.l\u00072LWM\u001c;)\u0005%a\u0016\u0001E2sK\u0006$XM\u0011:pW\u0016\u0014\u0018J\u001c4p)\u001d\u0019gm[<z\u0003\u001b\u0001\"!\t3\n\u0005\u0015\u0014#A\u0003\"s_.,'/\u00138g_\")qM\u0003a\u0001Q\u0006\u0011\u0011\u000e\u001a\t\u0003\u000f&L!A\u001b%\u0003\u0007%sG\u000fC\u0003m\u0015\u0001\u0007Q.\u0001\u0003i_N$\bC\u00018v\u001d\ty7\u000f\u0005\u0002q\u00116\t\u0011O\u0003\u0002s=\u00051AH]8pizJ!\u0001\u001e%\u0002\rA\u0013X\rZ3g\u0013\t\u0011eO\u0003\u0002u\u0011\")\u0001P\u0003a\u0001Q\u0006!\u0001o\u001c:u\u0011\u0015Q(\u00021\u0001|\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000eE\u0002}\u0003\u0013i\u0011! \u0006\u00033yT!aG@\u000b\t\u0005\u0005\u00111A\u0001\u0007G>lWn\u001c8\u000b\u0007u\t)AC\u0002\u0002\bE\u000ba!\u00199bG\",\u0017bAA\u0006{\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\n\u0003\u001fQ\u0001\u0013!a\u0001\u0003#\tAA]1dWB!q)a\u0005n\u0013\r\t)\u0002\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u00025\r\u0014X-\u0019;f\u0005J|7.\u001a:J]\u001a|G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005m!\u0006BA\t\u0003;Y#!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003SA\u0015AC1o]>$\u0018\r^5p]&!\u0011QFA\u0012\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010i\u0016\u001cHOW6NS\u001e\u0014\u0018\r^5p]\"\u0012A\u0002X\u0001\u0014i\u0016\u001cHOW6B]RLW*[4sCRLwN\u001c\u0015\u0003\u001bq\u000b!\u0002^3ti\u0012+G.\u001a;fQ\tqA,A\nuKN$H)\u001a7fi\u0016\u0014VmY;sg&4X\r\u000b\u0002\u00109\u0006QA/Z:u\u0007\"\u0014xn\u001c;)\u0005Aa\u0016!\u0004;fgRl\u0015n\u001a:bi&|g\u000eF\u0004G\u0003\u000f\nY%!\u0016\t\r\u0005%\u0013\u00031\u0001n\u0003\u0015Q8.\u0016:m\u0011\u001d\ti%\u0005a\u0001\u0003\u001f\nqAZ5sgRT6\u000eE\u0002\"\u0003#J1!a\u0015#\u00055Y\u0015MZ6b5.\u001cE.[3oi\"9\u0011qK\tA\u0002\u0005=\u0013\u0001C:fG>tGMW6\u0002\rY,'/\u001b4z)\r1\u0015Q\f\u0005\u0007\u0003?\u0012\u0002\u0019A7\u0002\tA\fG\u000f[\u0001\rSN\f5\r\\\"peJ,7\r\u001e\u000b\t\u0003K\nY'a#\u0002\u0010B\u0019q)a\u001a\n\u0007\u0005%\u0004JA\u0004C_>dW-\u00198\t\u000f\u000554\u00031\u0001\u0002p\u0005!A.[:u!\u0019\t\t(a\u001e\u0002|5\u0011\u00111\u000f\u0006\u0004\u0003kB\u0015AC2pY2,7\r^5p]&!\u0011\u0011PA:\u0005\r\u0019V-\u001d\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003\u0011!\u0017\r^1\u000b\t\u0005\u0015\u0015QA\u0001\nu>|7.Z3qKJLA!!#\u0002\u0000\t\u0019\u0011i\u0011'\t\u000f\u000555\u00031\u0001\u0002f\u000511/Z2ve\u0016Dq!!%\u0014\u0001\u0004\t)'A\u0005tK:\u001c\u0018\u000e^5wK\u0006\tB-\u001a7fi\u0016\fE\u000e\\+og\u0016\u001cWO]3\u0002\u001f\u0011,G.\u001a;f%\u0016\u001cWO]:jm\u0016$b!!'\u0002&\u0006%\u0006CBAN\u0003C\u000b)'\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014%\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\u000biJA\u0002UefDq!a*\u0016\u0001\u0004\ty%\u0001\u0005{W\u000ec\u0017.\u001a8u\u0011\u0019\ty&\u0006a\u0001[\u0006QB/Z:u\u0007>t7/^7fe>3gm]3u!\u0006$\b.Q2mg\"\u0012a\u0003\u0018")
public class ZkAuthorizationTest
extends ZooKeeperTestHarness {
    private final File jaasFile = JaasTestUtils$.MODULE$.writeJaasContextsToFile(JaasTestUtils$.MODULE$.zkSections());
    private final String authProvider;

    public File jaasFile() {
        return this.jaasFile;
    }

    public String authProvider() {
        return this.authProvider;
    }

    @Override
    @Before
    public void setUp() {
        System.setProperty("java.security.auth.login.config", this.jaasFile().getAbsolutePath());
        Configuration.setConfiguration(null);
        System.setProperty(this.authProvider(), "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        System.clearProperty(this.authProvider());
        Configuration.setConfiguration(null);
    }

    @Test
    public void testIsZkSecurityEnabled() {
        Assert.assertTrue((boolean)JaasUtils.isZkSaslEnabled());
        Configuration.setConfiguration(null);
        System.clearProperty("java.security.auth.login.config");
        Assert.assertFalse((boolean)JaasUtils.isZkSaslEnabled());
        try {
            Configuration.setConfiguration(null);
            System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
            JaasUtils.isZkSaslEnabled();
            Assert.fail((String)"Should have thrown an exception");
            return;
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKafkaZkClient() {
        void $minus_key;
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        Assert.assertTrue((boolean)this.zkClient().secure());
        ZkData$.MODULE$.PersistentZkPaths().foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testKafkaZkClient$1(this, path);
            return BoxedUnit.UNIT;
        });
        BrokerInfo brokerInfo = this.createBrokerInfo(1, "test.host", 9999, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$);
        this.zkClient().registerBroker(brokerInfo);
        this.verify(brokerInfo.path());
        String topic1 = "topic1";
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[3];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartition $minus$greater$extension_$this = new TopicPartition(topic1, 0);
        Object var10_4 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartition $minus$greater$extension_$this2 = new TopicPartition(topic1, 1);
        Object var12_6 = null;
        seqOps2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        TopicPartition $minus$greater$extension_$this3 = new TopicPartition(topic1, 2);
        Object var14_8 = null;
        seqOps3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        this.zkClient().createTopicAssignment(topic1, (Map)assignment);
        this.verify(TopicZNode$.MODULE$.path(topic1));
        String seqPath = this.zkClient().createSequentialPersistentPath("/c", "".getBytes(StandardCharsets.UTF_8));
        this.verify(seqPath);
        BrokerInfo updatedBrokerInfo = this.createBrokerInfo(1, "test.host2", 9995, SecurityProtocol.SSL, (Option<String>)None$.MODULE$);
        this.zkClient().updateBrokerInfo(updatedBrokerInfo);
        Assert.assertEquals((Object)new Some((Object)updatedBrokerInfo.broker()), (Object)this.zkClient().getBroker(1));
        TopicPartition topicPartition = new TopicPartition(topic1, 2);
        if (assignment == null) {
            throw null;
        }
        topicPartition = null;
        scala.collection.immutable.Map updatedAssignment = (scala.collection.immutable.Map)assignment.removed((Object)$minus_key);
        KafkaZkClient qual$1 = this.zkClient();
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)updatedAssignment.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            void apply_removingReplicas;
            ReplicaAssignment replicaAssignment;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            Seq v = (Seq)x0$1._2();
            Nil$ nil$ = Nil$.MODULE$;
            Nil$ apply_addingReplicas = Nil$.MODULE$;
            ReplicaAssignment replicaAssignment2 = replicaAssignment = new ReplicaAssignment(v, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
            Object var6_4 = null;
            nil$ = null;
            replicaAssignment = null;
            ReplicaAssignment $minus$greater$extension_y = replicaAssignment2;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)k, (Object)$minus$greater$extension_y);
            Object var4_6 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
        int x$3 = qual$1.setTopicAssignment$default$3();
        qual$1.setTopicAssignment(topic1, (Map)x$2, x$3);
        Assert.assertEquals((long)updatedAssignment.size(), (long)BoxesRunTime.unboxToInt((Object)this.zkClient().getTopicPartitionCount(topic1).get()));
    }

    private BrokerInfo createBrokerInfo(int id, String host, int port, SecurityProtocol securityProtocol, Option<String> rack) {
        return BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndPoint[]{new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol)})), rack), ApiVersion$.MODULE$.latestVersion(), port + 10);
    }

    private Option<String> createBrokerInfo$default$5() {
        return None$.MODULE$;
    }

    @Test
    public void testZkMigration() {
        try (KafkaZkClient unsecureZkClient = KafkaZkClient$.MODULE$.apply(this.zkConnect(), false, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, "kafka.server", "SessionExpireListener", (Option)None$.MODULE$, (Option)None$.MODULE$);){
            this.testMigration(this.zkConnect(), unsecureZkClient, this.zkClient());
        }
    }

    @Test
    public void testZkAntiMigration() {
        try (KafkaZkClient unsecureZkClient = KafkaZkClient$.MODULE$.apply(this.zkConnect(), false, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, "kafka.server", "SessionExpireListener", (Option)None$.MODULE$, (Option)None$.MODULE$);){
            this.testMigration(this.zkConnect(), this.zkClient(), unsecureZkClient);
        }
    }

    @Test
    public void testDelete() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(this.zkConnect()).toString());
        ZkSecurityMigrator$.MODULE$.run(new String[]{"--zookeeper.acl=secure", new StringBuilder(20).append("--zookeeper.connect=").append(this.zkConnect()).toString()});
        this.deleteAllUnsecure();
    }

    @Test
    public void testDeleteRecursive() {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(this.zkConnect()).toString());
        ZkData$.MODULE$.SecureRootPaths().foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testDeleteRecursive$2(this, path);
            return BoxedUnit.UNIT;
        });
        this.zkClient().setAcl("/", this.zkClient().defaultAcls("/"));
        this.deleteAllUnsecure();
    }

    @Test
    public void testChroot() {
        String zkUrl = new StringBuilder(6).append(this.zkConnect()).append("/kafka").toString();
        KafkaZkClient qual$1 = this.zkClient();
        byte[] x$2 = qual$1.createRecursive$default$2();
        boolean x$3 = qual$1.createRecursive$default$3();
        qual$1.createRecursive("/kafka", x$2, x$3);
        KafkaZkClient unsecureZkClient = KafkaZkClient$.MODULE$.apply(zkUrl, false, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, "kafka.server", "SessionExpireListener", (Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaZkClient secureZkClient = KafkaZkClient$.MODULE$.apply(zkUrl, true, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, "kafka.server", "SessionExpireListener", (Option)None$.MODULE$, (Option)None$.MODULE$);
        try {
            this.testMigration(zkUrl, unsecureZkClient, secureZkClient);
        }
        finally {
            unsecureZkClient.close();
            secureZkClient.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testMigration(String zkUrl, KafkaZkClient firstZk, KafkaZkClient secondZk) {
        void $plus$plus_suffix;
        String string;
        void $plus$plus_suffix2;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("zkConnect string: ").append(zkUrl).toString());
        Seq seq = ZkData$.MODULE$.SecureRootPaths();
        Seq seq2 = ZkData$.MODULE$.SensitiveRootPaths();
        if (seq == null) {
            throw null;
        }
        seq2 = null;
        ((IterableOnceOps)seq.appendedAll((IterableOnce)$plus$plus_suffix2)).foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testMigration$2(this, firstZk, path);
            return BoxedUnit.UNIT;
        });
        if (secondZk.secure()) {
            firstZk.createRecursive("/consumers", firstZk.createRecursive$default$2(), firstZk.createRecursive$default$3());
            string = "secure";
        } else {
            secondZk.createRecursive("/consumers", secondZk.createRecursive$default$2(), secondZk.createRecursive$default$3());
            string = "unsecure";
        }
        String secureOpt = string;
        ZkSecurityMigrator$.MODULE$.run(new String[]{new StringBuilder(16).append("--zookeeper.acl=").append(secureOpt).toString(), new StringBuilder(20).append("--zookeeper.connect=").append(zkUrl).toString()});
        this.info((Function0<String>)(Function0 & Serializable)() -> "Done with migration");
        Seq seq3 = ZkData$.MODULE$.SecureRootPaths();
        Seq seq4 = ZkData$.MODULE$.SensitiveRootPaths();
        if (seq3 == null) {
            throw null;
        }
        seq4 = null;
        ((IterableOnceOps)seq3.appendedAll((IterableOnce)$plus$plus_suffix)).foreach((Function1 & Serializable)path -> {
            ZkAuthorizationTest.$anonfun$testMigration$5(this, secondZk, path);
            return BoxedUnit.UNIT;
        });
        Seq consumersAcl = firstZk.getAcl("/consumers");
        Assert.assertTrue((String)"/consumers", (boolean)this.isAclCorrect((Seq<ACL>)consumersAcl, false, false));
        Assert.assertTrue((String)"/kafka-acl-extended", (boolean)this.isAclCorrect((Seq<ACL>)firstZk.getAcl("/kafka-acl-extended"), secondZk.secure(), ZkData$.MODULE$.sensitivePath("/kafka-acl-extended")));
    }

    private void verify(String path) {
        boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
        Assert.assertTrue((boolean)this.zkClient().getAcl(path).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(x$1, sensitive))));
    }

    private boolean isAclCorrect(Seq<ACL> list, boolean secure, boolean sensitive) {
        boolean bl;
        if (secure && !sensitive) {
            if (list == null) {
                throw null;
            }
            bl = list.length() == 2;
        } else {
            if (list == null) {
                throw null;
            }
            bl = list.length() == 1;
        }
        return bl && list.forall((Function1)(secure ? (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclSecure(x$2, sensitive)) : (Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl))));
    }

    private void deleteAllUnsecure() {
        System.setProperty("zookeeper.sasl.client", "false");
        KafkaZkClient unsecureZkClient = KafkaZkClient$.MODULE$.apply(this.zkConnect(), false, 6000, 6000, Integer.MAX_VALUE, Time.SYSTEM, "kafka.server", "SessionExpireListener", (Option)None$.MODULE$, (Option)None$.MODULE$);
        Try<Object> result = this.deleteRecursive(unsecureZkClient, "/");
        unsecureZkClient.close();
        System.clearProperty("zookeeper.sasl.client");
        if (result instanceof Success) {
            return;
        }
        if (result instanceof Failure) {
            Assert.fail((String)((Failure)result).exception().getMessage());
            return;
        }
        throw new MatchError(result);
    }

    private Try<Object> deleteRecursive(KafkaZkClient zkClient, String path) {
        Try try_;
        block7: {
            Try try_2;
            ObjectRef result;
            block6: {
                ObjectRef objectRef;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Deleting ").append(path).toString());
                Success create_e = new Success((Object)true);
                ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e);
                Object var6_3 = null;
                objectRef = null;
                result = objectRef2;
                zkClient.getChildren(path).foreach((Function1 & Serializable)child -> {
                    ZkAuthorizationTest.$anonfun$deleteRecursive$2(this, result, path, zkClient, child);
                    return BoxedUnit.UNIT;
                });
                switch (path == null ? 0 : path.hashCode()) {
                    case 47: {
                        if ("/".equals(path)) {
                            break;
                        }
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                try_ = (Try)result.elem;
                break block7;
            }
            try {
                int x$3 = zkClient.deletePath$default$2();
                zkClient.deletePath(path, x$3, false);
                try_2 = new Failure((Throwable)new Exception(new StringBuilder(25).append("Have been able to delete ").append(path).toString()));
            }
            catch (Exception exception) {
                try_2 = (Try)result.elem;
            }
            try_ = try_2;
        }
        return try_;
    }

    @Test
    public void testConsumerOffsetPathAcls() {
        this.zkClient().makeSurePersistentPathExists("/consumers");
        List consumerPathAcls = this.zkClient().currentZooKeeper().getACL("/consumers", new Stat());
        Assert.assertTrue((String)"old consumer znode path acls are not open", (boolean)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)consumerPathAcls).asScala().forall((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.MODULE$.isAclUnsecure(acl))));
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$2(ACL acl) {
        Assert.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, true));
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$3(ACL acl) {
        Assert.assertTrue((boolean)TestUtils$.MODULE$.isAclSecure(acl, false));
    }

    public static final /* synthetic */ void $anonfun$testKafkaZkClient$1(ZkAuthorizationTest $this, String path) {
        $this.zkClient().makeSurePersistentPathExists(path);
        if (ZkData$.MODULE$.sensitivePath(path)) {
            Seq aclList = $this.zkClient().getAcl(path);
            if (aclList == null) {
                throw null;
            }
            Assert.assertEquals((String)new StringBuilder(29).append("Unexpected acl list size for ").append(path).toString(), (long)1L, (long)aclList.length());
            aclList.foreach((Function1 & Serializable)acl -> {
                ZkAuthorizationTest.$anonfun$testKafkaZkClient$2(acl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (!path.equals("/consumers")) {
            Seq aclList = $this.zkClient().getAcl(path);
            if (aclList == null) {
                throw null;
            }
            Assert.assertEquals((String)new StringBuilder(29).append("Unexpected acl list size for ").append(path).toString(), (long)2L, (long)aclList.length());
            aclList.foreach((Function1 & Serializable)acl -> {
                ZkAuthorizationTest.$anonfun$testKafkaZkClient$3(acl);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$testDeleteRecursive$2(ZkAuthorizationTest $this, String path) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Creating ").append(path).toString());
        $this.zkClient().makeSurePersistentPathExists(path);
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(11).append(path).append("/fpjwashere").toString();
        byte[] x$2 = "".getBytes(StandardCharsets.UTF_8);
        boolean x$3 = qual$1.createRecursive$default$3();
        qual$1.createRecursive(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testMigration$2(ZkAuthorizationTest $this, KafkaZkClient firstZk$1, String path) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(9).append("Creating ").append(path).toString());
        firstZk$1.makeSurePersistentPathExists(path);
        firstZk$1.createRecursive(new StringBuilder(11).append(path).append("/fpjwashere").toString(), "".getBytes(StandardCharsets.UTF_8), firstZk$1.createRecursive$default$3());
    }

    public static final /* synthetic */ void $anonfun$testMigration$5(ZkAuthorizationTest $this, KafkaZkClient secondZk$1, String path) {
        boolean sensitive = ZkData$.MODULE$.sensitivePath(path);
        Seq listParent = secondZk$1.getAcl(path);
        Assert.assertTrue((String)path, (boolean)$this.isAclCorrect((Seq<ACL>)listParent, secondZk$1.secure(), sensitive));
        String childPath = new StringBuilder(11).append(path).append("/fpjwashere").toString();
        Seq listChild = secondZk$1.getAcl(childPath);
        Assert.assertTrue((String)childPath, (boolean)$this.isAclCorrect((Seq<ACL>)listChild, secondZk$1.secure(), sensitive));
    }

    public static final /* synthetic */ void $anonfun$deleteRecursive$2(ZkAuthorizationTest $this, ObjectRef result$1, String path$3, KafkaZkClient zkClient$1, String child) {
        Try try_;
        Try<Object> try_2;
        block9: {
            block8: {
                switch (path$3 == null ? 0 : path$3.hashCode()) {
                    case 47: {
                        if ("/".equals(path$3)) {
                            break;
                        }
                        break block8;
                    }
                    default: {
                        break block8;
                    }
                }
                try_2 = $this.deleteRecursive(zkClient$1, new StringBuilder(1).append("/").append(child).toString());
                break block9;
            }
            try_2 = $this.deleteRecursive(zkClient$1, new StringBuilder(1).append(path$3).append("/").append(child).toString());
        }
        if (try_2 instanceof Success) {
            try_ = (Try)result$1.elem;
        } else if (try_2 instanceof Failure) {
            Throwable e = ((Failure)try_2).exception();
            try_ = new Failure(e);
        } else {
            throw new MatchError(try_2);
        }
        result$1.elem = try_;
    }

    public ZkAuthorizationTest() {
        this.authProvider = "zookeeper.authProvider.1";
    }
}

