/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Assert;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u001dt!B\u0015+\u0011\u0003yc!B\u0019+\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003ad!B\u0019+\u0003\u0003i\u0005\u0002\u0003(\u0005\u0005\u0003\u0005\u000b\u0011B(\t\u0011i#!\u0011!Q\u0001\nmC\u0001\"\u0019\u0003\u0003\u0002\u0003\u0006Ia\u0014\u0005\tE\u0012\u0011\t\u0011)A\u0005\u001f\"A1\r\u0002BC\u0002\u0013\u0005A\r\u0003\u0005s\t\t\u0005\t\u0015!\u0003f\u0011!\u0019HA!b\u0001\n\u0003!\b\u0002\u0003>\u0005\u0005\u0003\u0005\u000b\u0011B;\t\u000be\"A\u0011A>\t\u000f\u0005\u001dAA\"\u0001\u0002\n!9\u00111\u0005\u0003\u0007\u0002\u0005\u0015\u0002bBA\u0014\t\u0019E\u0011\u0011\u0006\u0005\b\u0003w!a\u0011CA\u001f\u0011\u001d\ty\u0005\u0002C\u0001\u0003#B\u0011\"a\u001a\u0005#\u0003%\t!!\u001b\t\u000f\u0005}D\u0001\"\u0001\u0002\u0002\"I\u0011q\u0011\u0003\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\b\u0003\u0013#A\u0011BAF\u0011\u001d\t9\u000b\u0002C\u0005\u0003SCq!!2\u0005\t\u0003\t9\rC\u0005\u0002T\u0012\t\n\u0011\"\u0001\u0002j!I\u0011Q\u001b\u0003\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\b\u0003/$A\u0011AAm\u0011%\t\t\u000fBI\u0001\n\u0003\tI\u0007C\u0005\u0002d\u0012\t\n\u0011\"\u0001\u0002j!9\u0011Q\u001d\u0003\u0005\n\u0005\u001d\bbBA|\t\u0011%\u0011\u0011 \u0005\b\u0005\u000b!A\u0011\u0001B\u0004\u0011\u001d\u0011\u0019\u0002\u0002C\u0005\u0005+AqAa\u0007\u0005\t\u0003\u0011i\u0002C\u0004\u0003 \u0011!IA!\t\t\u000f\t\u0015B\u0001\"\u0001\u0003(!I!Q\u0007\u0003\u0012\u0002\u0013\u0005!q\u0007\u0005\b\u0005w!A\u0011\u0001B\u001f\u0011\u001d\u0011)\u0006\u0002C\u0001\u0005/B\u0011B!\u0019\u0005#\u0003%\tAa\u0019\u0002!E+x\u000e^1UKN$8\t\\5f]R\u001c(BA\u0016-\u0003\r\t\u0007/\u001b\u0006\u0002[\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0019\u0002\u001b\u0005Q#\u0001E)v_R\fG+Z:u\u00072LWM\u001c;t'\t\t1\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\n1\"\\3ue&\u001cg+\u00197vKR\u0011Q\b\u0011\t\u0003iyJ!aP\u001b\u0003\r\u0011{WO\u00197f\u0011\u0015\t5\u00011\u0001C\u0003\u0019iW\r\u001e:jGB\u00111iS\u0007\u0002\t*\u0011QIR\u0001\u0007G>lWn\u001c8\u000b\u00055:%B\u0001%J\u0003\u0019\t\u0007/Y2iK*\t!*A\u0002pe\u001eL!\u0001\u0014#\u0003\r5+GO]5d'\t!1'A\u0003u_BL7\r\u0005\u0002Q/:\u0011\u0011+\u0016\t\u0003%Vj\u0011a\u0015\u0006\u0003):\na\u0001\u0010:p_Rt\u0014B\u0001,6\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y+\u0014A\u00037fC\u0012,'OT8eKB\u0011AlX\u0007\u0002;*\u0011a\fL\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0001l&aC&bM.\f7+\u001a:wKJ\f\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0002!\r|gn];nKJ\u001cE.[3oi&#\u0017\u0001\u00039s_\u0012,8-\u001a:\u0016\u0003\u0015\u0004BA\u001a6mY6\tqM\u0003\u0002dQ*\u0011\u0011NR\u0001\bG2LWM\u001c;t\u0013\tYwMA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004i5|\u0017B\u000186\u0005\u0015\t%O]1z!\t!\u0004/\u0003\u0002rk\t!!)\u001f;f\u0003%\u0001(o\u001c3vG\u0016\u0014\b%\u0001\u0005d_:\u001cX/\\3s+\u0005)\b\u0003\u0002<yY2l\u0011a\u001e\u0006\u0003g\"L!!_<\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s\u0003%\u0019wN\\:v[\u0016\u0014\b\u0005\u0006\u0006}{z|\u0018\u0011AA\u0002\u0003\u000b\u0001\"\u0001\r\u0003\t\u000b9k\u0001\u0019A(\t\u000bik\u0001\u0019A.\t\u000b\u0005l\u0001\u0019A(\t\u000b\tl\u0001\u0019A(\t\u000b\rl\u0001\u0019A3\t\u000bMl\u0001\u0019A;\u0002\u001d=4XM\u001d:jI\u0016\fVo\u001c;bgRA\u00111BA\t\u00037\ty\u0002E\u00025\u0003\u001bI1!a\u00046\u0005\u0011)f.\u001b;\t\u000f\u0005Ma\u00021\u0001\u0002\u0016\u0005i\u0001O]8ek\u000e,'/U;pi\u0006\u00042\u0001NA\f\u0013\r\tI\"\u000e\u0002\u0005\u0019>tw\rC\u0004\u0002\u001e9\u0001\r!!\u0006\u0002\u001b\r|gn];nKJ\fVo\u001c;b\u0011\u0019\t\tC\u0004a\u0001{\u0005a!/Z9vKN$\u0018+^8uC\u0006!\"/Z7pm\u0016\fVo\u001c;b\u001fZ,'O]5eKN$\"!a\u0003\u0002\u001bU\u001cXM\u001d)sS:\u001c\u0017\u000e]1m+\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u0003k!\u0015\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005e\u0012q\u0006\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003=\tXo\u001c;b\u001b\u0016$(/[2UC\u001e\u001cH\u0003BA \u0003\u0017\u0002b!!\u0011\u0002H={UBAA\"\u0015\r\t)%N\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u00121!T1q\u0011\u0019\ti%\u0005a\u0001\u001f\u0006A1\r\\5f]RLE-A\u000bqe>$WoY3V]RLG\u000e\u00165s_R$H.\u001a3\u0015\r\u0005M\u0013\u0011LA/!\r!\u0014QK\u0005\u0004\u0003/*$aA%oi\"9\u00111\f\nA\u0002\u0005M\u0013AC7bqJ+7m\u001c:eg\"I\u0011q\f\n\u0011\u0002\u0003\u0007\u0011\u0011M\u0001\u0019o\u0006LGOR8s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007c\u0001\u001b\u0002d%\u0019\u0011QM\u001b\u0003\u000f\t{w\u000e\\3b]\u0006y\u0002O]8ek\u000e,WK\u001c;jYRC'o\u001c;uY\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-$\u0006BA1\u0003[Z#!a\u001c\u0011\t\u0005E\u00141P\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003s*\u0014AC1o]>$\u0018\r^5p]&!\u0011QPA:\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016G>t7/^7f+:$\u0018\u000e\u001c+ie>$H\u000f\\3e)\u0019\t\u0019&a!\u0002\u0006\"9\u00111\f\u000bA\u0002\u0005M\u0003\"CA0)A\u0005\t\u0019AA1\u0003}\u0019wN\\:v[\u0016,f\u000e^5m)\"\u0014x\u000e\u001e;mK\u0012$C-\u001a4bk2$HEM\u0001\u0006cV|G/\u0019\u000b\t\u0003\u001b\u000bI*a)\u0002&B!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u0014\u0012\u000bq!\\3ue&\u001c7/\u0003\u0003\u0002\u0018\u0006E%!B)v_R\f\u0007bBAN-\u0001\u0007\u0011QT\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u00049\u0006}\u0015bAAQ;\n\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u001d\t9C\u0006a\u0001\u0003WAa!!\u0014\u0017\u0001\u0004y\u0015A\n<fe&4\u0017\u0010\u00165s_R$H.\u001a+j[\u0016\u0014V-];fgR\u001c\u0005.\u00198oK2lU\r\u001e:jGRQ\u00111BAV\u0003w\u000by,!1\t\u000f\u00055v\u00031\u0001\u00020\u00061\u0011\r]5LKf\u0004B!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003k#\u0015\u0001\u00039s_R|7m\u001c7\n\t\u0005e\u00161\u0017\u0002\b\u0003BL7*Z=t\u0011\u0019\til\u0006a\u0001\u001f\u0006\u0001R.\u001a;sS\u000et\u0015-\\3Tk\u001a4\u0017\u000e\u001f\u0005\u0007\u0003\u001b:\u0002\u0019A(\t\u000f\u0005\rw\u00031\u0001\u0002b\u0005qQ\r\u001f9fGR$\u0006N]8ui2,\u0017!\u0006<fe&4\u0017\u0010\u0015:pIV\u001cW\r\u00165s_R$H.\u001a\u000b\t\u0003\u0017\tI-a3\u0002P\"9\u00111\u0019\rA\u0002\u0005\u0005\u0004\"CAg1A\u0005\t\u0019AA1\u0003I1XM]5gs\u000ec\u0017.\u001a8u\u001b\u0016$(/[2\t\u0013\u0005E\u0007\u0004%AA\u0002\u0005\u0005\u0014A\u0007<fe&4\u0017PU3rk\u0016\u001cHo\u00115b]:,G.T3ue&\u001c\u0017a\b<fe&4\u0017\u0010\u0015:pIV\u001cW\r\u00165s_R$H.\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005yb/\u001a:jMf\u0004&o\u001c3vG\u0016$\u0006N]8ui2,G\u0005Z3gCVdG\u000fJ\u001a\u0002+Y,'/\u001b4z\u0007>t7/^7f)\"\u0014x\u000e\u001e;mKRA\u00111BAn\u0003;\fy\u000eC\u0004\u0002Dn\u0001\r!!\u0019\t\u0013\u000557\u0004%AA\u0002\u0005\u0005\u0004\"CAi7A\u0005\t\u0019AA1\u0003}1XM]5gs\u000e{gn];nKRC'o\u001c;uY\u0016$C-\u001a4bk2$HEM\u0001 m\u0016\u0014\u0018NZ=D_:\u001cX/\\3UQJ|G\u000f\u001e7fI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0007<fe&4\u0017\u0010\u00165s_R$H.\u001a+j[\u0016lU\r\u001e:jGRA\u00111BAu\u0003g\f)\u0010C\u0004\u0002lz\u0001\r!!<\u0002\u0013E,x\u000e^1UsB,\u0007c\u0001/\u0002p&\u0019\u0011\u0011_/\u0003\u0013E+x\u000e^1UsB,\u0007BBA'=\u0001\u0007q\nC\u0004\u0002Dz\u0001\r!!\u0019\u0002%QD'o\u001c;uY\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0007\u0003w\u0014\tAa\u0001\u0011\u0007\r\u000bi0C\u0002\u0002\u0000\u0012\u0013!\"T3ue&\u001cg*Y7f\u0011\u001d\tYo\ba\u0001\u0003[Da!!\u0014 \u0001\u0004y\u0015A\u0004;ie>$H\u000f\\3NKR\u0014\u0018n\u0019\u000b\u0007\u0005\u0013\u0011yA!\u0005\u0011\t\u0005=%1B\u0005\u0005\u0005\u001b\t\tJA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0007bBAvA\u0001\u0007\u0011Q\u001e\u0005\u0007\u0003\u001b\u0002\u0003\u0019A(\u0002E\t\u0014xn[3s%\u0016\fX/Z:u\u001b\u0016$(/[2t)\"\u0014x\u000e\u001e;mKRKW.Z't)\u0015i$q\u0003B\r\u0011\u001d\ti+\ta\u0001\u0003_Ca!!0\"\u0001\u0004y\u0015aE3yK6\u0004HOU3rk\u0016\u001cH/T3ue&\u001cWC\u0001B\u0005\u0003\u00192XM]5gsB\u0013x\u000eZ;dKJ\u001cE.[3oiRC'o\u001c;uY\u0016$\u0016.\\3NKR\u0014\u0018n\u0019\u000b\u0005\u0003\u0017\u0011\u0019\u0003C\u0004\u0002D\u000e\u0002\r!!\u0019\u0002MY,'/\u001b4z\u0007>t7/^7fe\u000ec\u0017.\u001a8u)\"\u0014x\u000e\u001e;mKRKW.Z'fiJL7\r\u0006\u0004\u0002\f\t%\"1\u0006\u0005\b\u0003\u0007$\u0003\u0019AA1\u0011%\u0011i\u0003\nI\u0001\u0002\u0004\u0011y#A\bnCb$\u0006N]8ui2,G+[7f!\u0011!$\u0011G\u001f\n\u0007\tMRG\u0001\u0004PaRLwN\\\u00011m\u0016\u0014\u0018NZ=D_:\u001cX/\\3s\u00072LWM\u001c;UQJ|G\u000f\u001e7f)&lW-T3ue&\u001cG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te\"\u0006\u0002B\u0018\u0003[\nq\"];pi\u0006\u0004&o\u001c9feRLWm\u001d\u000b\t\u0005\u007f\u0011yE!\u0015\u0003TA!!\u0011\tB&\u001b\t\u0011\u0019E\u0003\u0003\u0003F\t\u001d\u0013\u0001B;uS2T!A!\u0013\u0002\t)\fg/Y\u0005\u0005\u0005\u001b\u0012\u0019E\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a\u0005'\u0001\u0004\t)\u0002C\u0004\u0002\u001e\u0019\u0002\r!!\u0006\t\r\u0005\u0005b\u00051\u0001>\u0003I9\u0018-\u001b;G_J\fVo\u001c;b+B$\u0017\r^3\u0015\u0015\u0005-!\u0011\fB.\u0005;\u0012y\u0006C\u0004\u0002\u0014\u001d\u0002\r!!\u0006\t\u000f\u0005uq\u00051\u0001\u0002\u0016!1\u0011\u0011E\u0014A\u0002uBqAX\u0014\u0011\u0002\u0003\u00071,\u0001\u000fxC&$hi\u001c:Rk>$\u0018-\u00169eCR,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0015$fA.\u0002n\u0001")
public abstract class QuotaTestClients {
    private final String topic;
    private final KafkaServer leaderNode;
    private final String producerClientId;
    private final String consumerClientId;
    private final KafkaProducer<byte[], byte[]> producer;
    private final KafkaConsumer<byte[], byte[]> consumer;

    public static double metricValue(org.apache.kafka.common.Metric metric) {
        return BoxesRunTime.unboxToDouble((Object)metric.metricValue());
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    public abstract KafkaPrincipal userPrincipal();

    public abstract Map<String, String> quotaMetricTags(String var1);

    /*
     * WARNING - void declaration
     */
    public int produceUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        void var3_3;
        boolean throttled;
        int numProduced = 0;
        do {
            byte[] payload = ((Object)numProduced).toString().getBytes();
            Future future = this.producer().send(new ProducerRecord(this.topic, null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic, null, null, true));
            ++numProduced;
            do {
                boolean bl;
                KafkaMetric metric;
                if ((metric = this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId)) != null) {
                    if (BoxesRunTime.unboxToDouble((Object)metric.metricValue()) > 0.0) {
                        bl = true;
                        continue;
                    }
                }
                bl = throttled = false;
            } while (!future.isDone() && (!throttled || waitForRequestCompletion));
        } while (numProduced < maxRecords && !throttled);
        return (int)var3_3;
    }

    public boolean produceUntilThrottled$default$2() {
        return true;
    }

    public int consumeUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        boolean throttled;
        long timeoutMs = TimeUnit.MINUTES.toMillis(1L);
        this.consumer().subscribe(Collections.singleton(this.topic));
        int numConsumed = 0;
        long startMs = System.currentTimeMillis();
        do {
            boolean bl;
            numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count();
            KafkaMetric metric = this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId);
            if (metric != null) {
                if (BoxesRunTime.unboxToDouble((Object)metric.metricValue()) > 0.0) {
                    bl = true;
                    continue;
                }
            }
            bl = throttled = false;
        } while (numConsumed < maxRecords && !throttled && System.currentTimeMillis() < startMs + timeoutMs);
        if (throttled && numConsumed < maxRecords && waitForRequestCompletion) {
            int minRecords = numConsumed + 1;
            long startMs2 = System.currentTimeMillis();
            while (numConsumed < minRecords && System.currentTimeMillis() < startMs2 + timeoutMs) {
                numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count();
            }
        }
        return numConsumed;
    }

    public boolean consumeUntilThrottled$default$2() {
        return true;
    }

    private Quota quota(ClientQuotaManager quotaManager, KafkaPrincipal userPrincipal, String clientId) {
        return quotaManager.quota(userPrincipal, clientId);
    }

    private void verifyThrottleTimeRequestChannelMetric(ApiKeys apiKey, String metricNameSuffix, String clientId, boolean expectThrottle) {
        double throttleTimeMs = this.brokerRequestMetricsThrottleTimeMs(apiKey, metricNameSuffix);
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(44).append("Client with id=").append(clientId).append(" should have been throttled, ").append(throttleTimeMs).toString(), (throttleTimeMs > 0.0 ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((String)new StringBuilder(46).append("Client with id=").append(clientId).append(" should not have been throttled").toString(), (double)0.0, (double)throttleTimeMs, (double)0.0);
    }

    public void verifyProduceThrottle(boolean expectThrottle, boolean verifyClientMetric, boolean verifyRequestChannelMetric) {
        this.verifyThrottleTimeMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId, expectThrottle);
        if (verifyRequestChannelMetric) {
            this.verifyThrottleTimeRequestChannelMetric(ApiKeys.PRODUCE, "", this.producerClientId, expectThrottle);
        }
        if (verifyClientMetric) {
            this.verifyProducerClientThrottleTimeMetric(expectThrottle);
        }
    }

    public boolean verifyProduceThrottle$default$2() {
        return true;
    }

    public boolean verifyProduceThrottle$default$3() {
        return true;
    }

    public void verifyConsumeThrottle(boolean expectThrottle, boolean verifyClientMetric, boolean verifyRequestChannelMetric) {
        this.verifyThrottleTimeMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId, expectThrottle);
        if (verifyRequestChannelMetric) {
            this.verifyThrottleTimeRequestChannelMetric(ApiKeys.FETCH, "Consumer", this.consumerClientId, expectThrottle);
        }
        if (verifyClientMetric) {
            this.verifyConsumerClientThrottleTimeMetric(expectThrottle, this.verifyConsumerClientThrottleTimeMetric$default$2());
        }
    }

    public boolean verifyConsumeThrottle$default$2() {
        return true;
    }

    public boolean verifyConsumeThrottle$default$3() {
        return true;
    }

    private void verifyThrottleTimeMetric(QuotaType quotaType, String clientId, boolean expectThrottle) {
        double d = BoxesRunTime.unboxToDouble((Object)this.throttleMetric(quotaType, clientId).metricValue());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(42).append("Client with id=").append(clientId).append(" should have been throttled").toString(), (d > 0.0 ? 1 : 0) != 0);
            return;
        }
        Assert.assertTrue((String)new StringBuilder(46).append("Client with id=").append(clientId).append(" should not have been throttled").toString(), (boolean)Double.valueOf(d).isNaN());
    }

    private MetricName throttleMetricName(QuotaType quotaType, String clientId) {
        return this.leaderNode.metrics().metricName("throttle-time", quotaType.toString(), AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.quotaMetricTags(clientId)).asJava());
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, String clientId) {
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(this.throttleMetricName(quotaType, clientId));
    }

    private double brokerRequestMetricsThrottleTimeMs(ApiKeys apiKey, String metricNameSuffix) {
        return QuotaTestClients.yammerMetricValue$1(new StringBuilder(62).append("kafka.network:type=RequestMetrics,name=ThrottleTimeMs,request=").append(apiKey.name).append(metricNameSuffix).toString());
    }

    public KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode.metrics().metricName("exempt-request-time", "Request", "");
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(metricName);
    }

    private void verifyProducerClientThrottleTimeMetric(boolean expectThrottle) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId);
        org.apache.kafka.common.Metric avgMetric = (org.apache.kafka.common.Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        org.apache.kafka.common.Metric maxMetric = (org.apache.kafka.common.Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        if (expectThrottle) {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!QuotaTestClients.$anonfun$verifyProducerClientThrottleTimeMetric$1(avgMetric, maxMetric)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail(QuotaTestClients.$anonfun$verifyProducerClientThrottleTimeMetric$2(avgMetric, maxMetric), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                Thread.sleep(Math.min(l, l2));
            }
            return;
        }
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()), (double)0.0);
    }

    public void verifyConsumerClientThrottleTimeMetric(boolean expectThrottle, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId);
        org.apache.kafka.common.Metric avgMetric = (org.apache.kafka.common.Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        org.apache.kafka.common.Metric maxMetric = (org.apache.kafka.common.Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        if (expectThrottle) {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$1(avgMetric, maxMetric)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail(QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$2(avgMetric, maxMetric), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                Thread.sleep(Math.min(l, l2));
            }
            if (maxThrottleTime == null) {
                throw null;
            }
            if (!maxThrottleTime.isEmpty()) {
                double d = BoxesRunTime.unboxToDouble((Object)maxThrottleTime.get());
                QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$3(maxMetric, d);
            }
            return;
        }
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)BoxesRunTime.unboxToDouble((Object)maxMetric.metricValue()), (double)0.0);
    }

    public Option<Object> verifyConsumerClientThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    public Properties quotaProperties(long producerQuota, long consumerQuota, double requestQuota) {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)producerQuota).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)consumerQuota).toString());
        props.put(DynamicConfig.Client$.MODULE$.RequestPercentageOverrideProp(), ((Object)requestQuota).toString());
        return props;
    }

    /*
     * WARNING - void declaration
     */
    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota, KafkaServer server) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                QuotaTestClients.$anonfun$waitForQuotaUpdate$1(this, server, producerQuota, consumerQuota, requestQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var14_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public KafkaServer waitForQuotaUpdate$default$4() {
        return this.leaderNode;
    }

    public static final /* synthetic */ boolean $anonfun$brokerRequestMetricsThrottleTimeMs$1(String name$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith(name$1);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final double yammerMetricValue$1(String name) {
        double d;
        void var5_4;
        scala.collection.mutable.Map allMetrics = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Option option = allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaTestClients.$anonfun$brokerRequestMetricsThrottleTimeMs$1(name, x0$1)));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$4 -> x$4.getMBeanName())).toString(), new Position("BaseQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }
        Object var6_2 = null;
        Tuple2 tuple2 = (Tuple2)getOrElse_this.get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var5_4 instanceof Meter) {
            d = ((Meter)var5_4).count();
        } else if (var5_4 instanceof Histogram) {
            d = ((Histogram)var5_4).max();
        } else {
            throw Assertions$.MODULE$.fail(new StringBuilder(34).append("Unexpected broker metric of class ").append(var5_4.getClass()).toString(), new Position("BaseQuotaTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        }
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$verifyProducerClientThrottleTimeMetric$1(org.apache.kafka.common.Metric avgMetric$1, org.apache.kafka.common.Metric maxMetric$1) {
        if (BoxesRunTime.unboxToDouble((Object)avgMetric$1.metricValue()) > 0.0) {
            if (BoxesRunTime.unboxToDouble((Object)maxMetric$1.metricValue()) > 0.0) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$verifyProducerClientThrottleTimeMetric$2(org.apache.kafka.common.Metric avgMetric$1, org.apache.kafka.common.Metric maxMetric$1) {
        return new StringBuilder(47).append("Producer throttle metric not updated: avg=").append(BoxesRunTime.unboxToDouble((Object)avgMetric$1.metricValue())).append(" max=").append(BoxesRunTime.unboxToDouble((Object)maxMetric$1.metricValue())).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyConsumerClientThrottleTimeMetric$1(org.apache.kafka.common.Metric avgMetric$2, org.apache.kafka.common.Metric maxMetric$2) {
        if (BoxesRunTime.unboxToDouble((Object)avgMetric$2.metricValue()) > 0.0) {
            if (BoxesRunTime.unboxToDouble((Object)maxMetric$2.metricValue()) > 0.0) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$verifyConsumerClientThrottleTimeMetric$2(org.apache.kafka.common.Metric avgMetric$2, org.apache.kafka.common.Metric maxMetric$2) {
        return new StringBuilder(47).append("Consumer throttle metric not updated: avg=").append(BoxesRunTime.unboxToDouble((Object)avgMetric$2.metricValue())).append(" max=").append(BoxesRunTime.unboxToDouble((Object)maxMetric$2.metricValue())).toString();
    }

    public static final /* synthetic */ void $anonfun$verifyConsumerClientThrottleTimeMetric$3(org.apache.kafka.common.Metric maxMetric$2, double max) {
        Assert.assertTrue((String)new StringBuilder(36).append("Maximum consumer throttle too high: ").append(BoxesRunTime.unboxToDouble((Object)maxMetric$2.metricValue())).toString(), (BoxesRunTime.unboxToDouble((Object)maxMetric$2.metricValue()) <= max ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForQuotaUpdate$1(QuotaTestClients $this, KafkaServer server$1, long producerQuota$1, long consumerQuota$1, double requestQuota$1) {
        void quota_clientId;
        void quota_userPrincipal;
        Quota quota;
        void quota_clientId2;
        void quota_userPrincipal2;
        Quota quota2;
        void quota_clientId3;
        void quota_userPrincipal3;
        Quota quota3;
        void quota_clientId4;
        void quota_userPrincipal4;
        Quota quota4;
        QuotaFactory.QuotaManagers quotaManagers = server$1.dataPlaneRequestProcessor().quotas();
        String string = $this.producerClientId;
        KafkaPrincipal kafkaPrincipal = $this.userPrincipal();
        ClientQuotaManager quota_quotaManager = quotaManagers.produce();
        Quota quota5 = quota4 = quota_quotaManager.quota((KafkaPrincipal)quota_userPrincipal4, (String)quota_clientId4);
        Object var17_8 = null;
        kafkaPrincipal = null;
        string = null;
        quota4 = null;
        Quota overrideProducerQuota = quota5;
        String string2 = $this.consumerClientId;
        KafkaPrincipal kafkaPrincipal2 = $this.userPrincipal();
        ClientQuotaManager quota_quotaManager2 = quotaManagers.fetch();
        Quota quota6 = quota3 = quota_quotaManager2.quota((KafkaPrincipal)quota_userPrincipal3, (String)quota_clientId3);
        Object var21_13 = null;
        kafkaPrincipal2 = null;
        string2 = null;
        quota3 = null;
        Quota overrideConsumerQuota = quota6;
        String string3 = $this.producerClientId;
        KafkaPrincipal kafkaPrincipal3 = $this.userPrincipal();
        ClientRequestQuotaManager quota_quotaManager3 = quotaManagers.request();
        Quota quota7 = quota2 = quota_quotaManager3.quota((KafkaPrincipal)quota_userPrincipal2, (String)quota_clientId2);
        Object var25_18 = null;
        kafkaPrincipal3 = null;
        string3 = null;
        quota2 = null;
        Quota overrideProducerRequestQuota = quota7;
        String string4 = $this.consumerClientId;
        KafkaPrincipal kafkaPrincipal4 = $this.userPrincipal();
        ClientRequestQuotaManager quota_quotaManager4 = quotaManagers.request();
        Quota quota8 = quota = quota_quotaManager4.quota((KafkaPrincipal)quota_userPrincipal, (String)quota_clientId);
        Object var29_23 = null;
        kafkaPrincipal4 = null;
        string4 = null;
        quota = null;
        Quota overrideConsumerRequestQuota = quota8;
        double upperBound_upperBound = producerQuota$1;
        Assert.assertEquals((String)new StringBuilder(43).append("ClientId ").append($this.producerClientId).append(" of user ").append($this.userPrincipal()).append(" must have producer quota").toString(), (Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota);
        double upperBound_upperBound2 = consumerQuota$1;
        Assert.assertEquals((String)new StringBuilder(43).append("ClientId ").append($this.consumerClientId).append(" of user ").append($this.userPrincipal()).append(" must have consumer quota").toString(), (Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota);
        Assert.assertEquals((String)new StringBuilder(42).append("ClientId ").append($this.producerClientId).append(" of user ").append($this.userPrincipal()).append(" must have request quota").toString(), (Object)new Quota(requestQuota$1, true), (Object)overrideProducerRequestQuota);
        Assert.assertEquals((String)new StringBuilder(42).append("ClientId ").append($this.consumerClientId).append(" of user ").append($this.userPrincipal()).append(" must have request quota").toString(), (Object)new Quota(requestQuota$1, true), (Object)overrideConsumerRequestQuota);
    }

    public QuotaTestClients(String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        this.topic = topic;
        this.leaderNode = leaderNode;
        this.producerClientId = producerClientId;
        this.consumerClientId = consumerClientId;
        this.producer = producer;
        this.consumer = consumer;
    }
}

