/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableFactory;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\u0010!\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004;\u0001\u0001\u0006I\u0001\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0001\u0005\u0001)A\u0005{!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB&\u0001A\u0003%1\tC\u0003M\u0001\u0011\u0005Q\nC\u0003[\u0001\u0011\u0005Q\nC\u0003]\u0001\u0011\u0005Q\nC\u0003d\u0001\u0011\u0005Q\nC\u0003f\u0001\u0011\u0005Q\nC\u0003h\u0001\u0011\u0005Q\nC\u0003j\u0001\u0011\u0005Q\nC\u0003l\u0001\u0011\u0005Q\nC\u0003n\u0001\u0011\u0005Q\nC\u0003p\u0001\u0011\u0005Q\nC\u0003r\u0001\u0011\u0005Q\nC\u0003t\u0001\u0011\u0005Q\nC\u0003v\u0001\u0011\u0005Q\nC\u0003x\u0001\u0011\u0005Q\nC\u0003z\u0001\u0011\u0005Q\nC\u0003|\u0001\u0011\u0005Q\nC\u0003~\u0001\u0011\u0005Q\nC\u0003\u0000\u0001\u0011\u0005Q\n\u0003\u0004\u0002\u0004\u0001!\t!\u0014\u0005\u0007\u0003\u000f\u0001A\u0011A'\t\r]\u0004A\u0011BA\u0006\u0011\u001d\t9\u0002\u0001C\u0005\u00033A\u0011\"!\u0011\u0001#\u0003%I!a\u0011\u0003/Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1UKN$(BA\u0011#\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\r\"\u0013aC2p_J$\u0017N\\1u_JT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\r\u0001\u000e\u0003\u0001\nA\u0001^5nKV\tA\u0007\u0005\u00026q5\taG\u0003\u00028I\u0005)Q\u000f^5mg&\u0011\u0011H\u000e\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u0003u\u0002\"!\u000b \n\u0005}R#\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u0005yAO]1og\u0006\u001cG/[8oC2LE-F\u0001D!\t!\u0015*D\u0001F\u0015\t1u)\u0001\u0003mC:<'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0016\u0013aa\u0015;sS:<\u0017\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133!\u0003M!Xm\u001d;J]&$\u0018.\u00197ju\u0016,\u0005o\\2i)\u0005q\u0005CA\u0015P\u0013\t\u0001&F\u0001\u0003V]&$\bF\u0001\u0005S!\t\u0019\u0006,D\u0001U\u0015\t)f+A\u0003kk:LGOC\u0001X\u0003\ry'oZ\u0005\u00033R\u0013A\u0001V3ti\u0006\u0019B/Z:u\u001d>\u0014X.\u00197Fa>\u001c\u0007NQ;na\"\u0012\u0011BU\u0001)i\u0016\u001cHOQ;na\u0016\u0003xn\u00195O_R\fE\u000e\\8xK\u0012Le-\u00129pG\"\u001cX\t\u001f5bkN$X\r\u001a\u0015\u0005\u0015Isv,\u0001\u0005fqB,7\r^3eG\u0005\u0001\u0007C\u0001#b\u0013\t\u0011WIA\u000bJY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8\u0002UQ,7\u000f\u001e+pY\u0016\u0014\u0018\r^3Va\u0012\fG/\u001a+j[\u0016\u001c\u0006.\u001b4u\tV\u0014\u0018N\\4Fa>\u001c\u0007NQ;na\"\u00121BU\u00014i\u0016\u001cH\u000fV8mKJ\fG/Z+qI\u0006$X\rV5nKJ+7/\u001a;EkJLgn\u001a)s_\u0012,8-\u001a:JIJ{G/\u0019;j_:D#\u0001\u0004*\u0002QQ,7\u000f\u001e+pY\u0016\u0014\u0018\r^3US6,7\u000b[5gi\u0012+(/\u001b8h\u0003\u0012$\u0007+\u0019:uSRLwN\\:)\u00055\u0011\u0016\u0001\u000b;fgR$v\u000e\\3sCR,G+[7f'\"Lg\r\u001e#ve&tw\r\u0015:fa\u0006\u0014XmQ8n[&$\bF\u0001\bS\u0003\u001d\"Xm\u001d;U_2,'/\u0019;f)&lWm\u00155jMR$UO]5oOB\u0013X\r]1sK\u0006\u0013wN\u001d;)\u0005=\u0011\u0016!\u000b;fgR$v\u000e\\3sCR,G+[7f'\"Lg\r\u001e#ve&twmQ8na2,G/Z\"p[6LG\u000f\u000b\u0002\u0011%\u0006AC/Z:u)>dWM]1uKRKW.Z*iS\u001a$H)\u001e:j]\u001e\u001cu.\u001c9mKR,\u0017IY8si\"\u0012\u0011CU\u0001&i\u0016\u001cHOR3oG\u0016\u0004&o\u001c3vG\u0016\u0014\u0018I\u001a;fe\u0016\u0003xn\u00195t\u000bbD\u0017-^:uK\u0012D#A\u0005*\u0002YQ,7\u000f\u001e$f]\u000e,\u0007K]8ek\u000e,'OT8u\u00032dwn^3e\u0013\u001aLEoV8vY\u0012|e/\u001a:gY><\b\u0006B\nS=~\u000bA\u0003^3tiJ{G/\u0019;f!J|G-^2fe&#\u0007F\u0001\u000bS\u0003\t\"Xm\u001d;S_R\fG/\u001a)s_\u0012,8-\u001a:JI&swJ\\4pS:<7\u000b^1uK\"\"QC\u00150`\u0003\u001d\"Xm\u001d;S_R\fG/\u001a)s_\u0012,8-\u001a:JI&s\u0007K]3qCJ,\u0017IY8siN#\u0018\r^3)\tY\u0011flX\u0001)i\u0016\u001cHOU8uCR,\u0007K]8ek\u000e,'/\u00133J]B\u0013X\r]1sK\u000e{W.\\5u'R\fG/\u001a\u0015\u0005/Isv,\u0001\u0018uKN$\u0018\t\u001e;f[B$X\rZ#q_\u000eD')^7q/&$\bNT3xYf\u001c%/Z1uK\u0012lU\r^1eCR\f\u0007F\u0001\rS\u0003\u0015\"Xm\u001d;Fa>\u001c\u0007NQ;na^KG\u000f[\"veJ,g\u000e^#q_\u000eD\u0007K]8wS\u0012,G\r\u000b\u0002\u001a%\u0006\u0019C/Z:u\u0003R$X-\u001c9uK\u0012,\u0005o\\2i\u0005Vl\u0007oV5uQ2\u000b7\u000f^#q_\u000eD\u0007F\u0001\u000eS\u0003\u0015\"Xm\u001d;BiR,W\u000e\u001d;fI\u0016\u0003xn\u00195Ck6\u0004x+\u001b;i\r\u0016t7-\u001a3Fa>\u001c\u0007\u000e\u000b\u0002\u001c%R\u0019a*!\u0004\t\u000f\u0005=A\u00041\u0001\u0002\u0012\u0005)1\u000f^1uKB\u0019\u0011'a\u0005\n\u0007\u0005U\u0001E\u0001\tUe\u0006t7/Y2uS>t7\u000b^1uK\u00069\u0003O]3qCJ,7+^2dKN\u001ch-\u001e7J]\u000e\u0014X-\\3oiB\u0013x\u000eZ;dKJ,\u0005o\\2i)!\tY\"!\t\u0002,\u0005m\u0002cA\u0019\u0002\u001e%\u0019\u0011q\u0004\u0011\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\u0005\b\u0003Gi\u0002\u0019AA\u0013\u0003-!\bP\\'fi\u0006$\u0017\r^1\u0011\u0007E\n9#C\u0002\u0002*\u0001\u00121\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006Dq!!\f\u001e\u0001\u0004\ty#A\u000bfqB,7\r^3e!J|G-^2fe\u0016\u0003xn\u00195\u0011\u000b%\n\t$!\u000e\n\u0007\u0005M\"F\u0001\u0004PaRLwN\u001c\t\u0004S\u0005]\u0012bAA\u001dU\t)1\u000b[8si\"I\u0011QH\u000f\u0011\u0002\u0003\u0007\u0011qH\u0001\u0004]><\b\u0003B\u0015\u00022u\n\u0011\u0007\u001d:fa\u0006\u0014XmU;dG\u0016\u001c8OZ;m\u0013:\u001c'/Z7f]R\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0012\"WMZ1vYR$3'\u0006\u0002\u0002F)\"\u0011qHA$W\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA*U\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0013Q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();
    private final long producerId;
    private final String transactionalId;

    public MockTime time() {
        return this.time;
    }

    public long producerId() {
        return this.producerId;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    @Test
    public void testInitializeEpoch() {
        short producerEpoch = -1;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds());
    }

    @Test
    public void testTolerateUpdateTimeShiftDuringEpochBump() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)Option$.MODULE$.apply((Object)producerEpoch), (Option<Object>)new Some((Object)(this.time().milliseconds() - 1L)));
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateUpdateTimeResetDuringProducerIdRotation() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(this.producerId() + 1L, 30000, this.time().milliseconds() - 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)(this.producerId() + 1L), (long)txnMetadata.producerId());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTolerateTimeShiftDuringAddPartitions() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, (Set)Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems4), this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        scala.collection.immutable.Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems3), (Object)txnMetadata.topicPartitions());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
        scala.collection.immutable.Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems2), this.time().milliseconds() - 2L);
        txnMetadata.completeTransitionTo(transitMetadata);
        scala.collection.immutable.Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (Seq)apply_elems), (Object)txnMetadata.topicPartitions());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 2L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)PrepareCommit$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)PrepareAbort$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareAbort$.MODULE$, (Set)Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)CompleteAbort$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        TxnTransitMetadata fencingTransitMetadata = txnMetadata.prepareFenceProducerEpoch();
        Assert.assertEquals((long)32767L, (long)fencingTransitMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)fencingTransitMetadata.lastProducerEpoch());
        Assert.assertEquals((Object)new Some((Object)PrepareEpochFence$.MODULE$), (Object)txnMetadata.pendingState());
        txnMetadata.pendingState_$eq((Option)None$.MODULE$);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)transitMetadata.producerId());
    }

    @Test(expected=IllegalStateException.class)
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        short producerEpoch = Short.MAX_VALUE;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareFenceProducerEpoch();
    }

    @Test
    public void testRotateProducerId() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.lastProducerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInOngoingState() {
        this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareAbortState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareCommitState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void testAttemptedEpochBumpWithNewlyCreatedMetadata() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, -1, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)producerEpoch), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testEpochBumpWithCurrentEpochProvided() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, -1, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)producerEpoch), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithLastEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, -1L, producerEpoch, lastProducerEpoch, 30000, (TransactionState)x$7, x$8, l, x$9);
        TxnTransitMetadata transitMetadata = this.prepareSuccessfulIncrementProducerEpoch(txnMetadata, (Option<Object>)new Some((Object)lastProducerEpoch), (Option<Object>)None$.MODULE$);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)lastProducerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAttemptedEpochBumpWithFencedEpoch() {
        void apply_value;
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        Either result = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, lastProducerEpoch, 30000, (TransactionState)x$7, x$8, l, x$9).prepareIncrementProducerEpoch(30000, (Option)new Some((Object)((short)(lastProducerEpoch - 1))), this.time().milliseconds());
        Errors errors = Errors.INVALID_PRODUCER_EPOCH;
        if (package$.MODULE$.Left() == null) {
            throw null;
        }
        errors = null;
        Assert.assertEquals((Object)new Left((Object)apply_value), (Object)result);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state) {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        Set x$8 = (Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, -1, 30000, state, x$8, l, x$9);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), false);
    }

    private TxnTransitMetadata prepareSuccessfulIncrementProducerEpoch(TransactionMetadata txnMetadata, Option<Object> expectedProducerEpoch, Option<Object> now) {
        if (now == null) {
            throw null;
        }
        Object object = now.isEmpty() ? BoxesRunTime.boxToLong((long)TransactionMetadataTest.$anonfun$prepareSuccessfulIncrementProducerEpoch$1(this)) : now.get();
        Object object2 = object;
        object = null;
        Either result = txnMetadata.prepareIncrementProducerEpoch(30000, expectedProducerEpoch, BoxesRunTime.unboxToLong((Object)object2));
        if (result == null) {
            throw null;
        }
        if (!(result instanceof Right)) {
            throw Assertions$.MODULE$.fail(new StringBuilder(42).append("prepareIncrementProducerEpoch failed with ").append(result).toString(), new Position("TransactionMetadataTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        }
        Object object3 = ((Right)result).value();
        return (TxnTransitMetadata)object3;
    }

    private Option<Object> prepareSuccessfulIncrementProducerEpoch$default$3() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ long $anonfun$prepareSuccessfulIncrementProducerEpoch$1(TransactionMetadataTest $this) {
        return $this.time().milliseconds();
    }

    public TransactionMetadataTest() {
        this.producerId = 23423L;
        this.transactionalId = "txnlId";
    }
}

