/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.AdminManager;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0004\t\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0015\u0001A\u0003%!\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\r]\u0002\u0001\u0015!\u0003,\u0011\u001dA\u0004A1A\u0005\neBa!\u0010\u0001!\u0002\u0013Q\u0004b\u0002 \u0001\u0005\u0004%Ia\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002!\t\u000f%\u0003!\u0019!C\u0005\u0015\"1a\n\u0001Q\u0001\n-CQa\u0014\u0001\u0005\u0002ACQa\u0017\u0001\u0005\u0002qCQ\u0001\u0019\u0001\u0005\u0002A\u0013\u0001#\u00113nS:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005E\u0011\u0012AB:feZ,'OC\u0001\u0014\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t\u0001#\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005\u0011\u0003CA\u0012'\u001b\u0005!#BA\u0013\u0013\u0003\tQ8.\u0003\u0002(I\ti1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u000f5,GO]5dgV\t1\u0006\u0005\u0002-k5\tQF\u0003\u0002*])\u0011q\u0006M\u0001\u0007G>lWn\u001c8\u000b\u0005M\t$B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001eL!AN\u0017\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0005ce>\\WM]%e+\u0005Q\u0004CA\f<\u0013\ta\u0004DA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003\u0001\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\t1\fgn\u001a\u0006\u0002\u000b\u0006!!.\u0019<b\u0013\t9%I\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005Y\u0005CA\u0010M\u0013\ti\u0005CA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003!!X-\u0019:E_^tG#A)\u0011\u0005]\u0011\u0016BA*\u0019\u0005\u0011)f.\u001b;)\u00051)\u0006C\u0001,Z\u001b\u00059&B\u0001-4\u0003\u0015QWO\\5u\u0013\tQvKA\u0003BMR,'/\u0001\nde\u0016\fG/Z!e[&tW*\u00198bO\u0016\u0014H#A/\u0011\u0005}q\u0016BA0\u0011\u00051\tE-\\5o\u001b\u0006t\u0017mZ3s\u0003\u0011\"Xm\u001d;EKN\u001c'/\u001b2f\u0007>tg-[4t/&$\b\u000eR8dk6,g\u000e^1uS>t\u0007F\u0001\bc!\t16-\u0003\u0002e/\n!A+Z:u\u0001")
public class AdminManagerTest {
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final String topic;
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public AdminManager createAdminManager() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        return new AdminManager(KafkaConfig$.MODULE$.fromProps(props), this.metrics(), this.metadataCache(), this.zkClient());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeConfigsWithDocumentation() {
        void $minus$greater$extension_y;
        None$ none$;
        void $minus$greater$extension_y2;
        None$ none$2;
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)new Properties());
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), ((Object)this.brokerId()).toString())).andReturn((Object)new Properties());
        EasyMock.expect((Object)this.metadataCache().contains(this.topic())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        AdminManager adminManager = this.createAdminManager();
        Object[] objectArray = new Tuple2[2];
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ none$4 = none$3;
        ConfigResource $minus$greater$extension_$this = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        Object var4_4 = null;
        none$4 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        None$ none$5 = none$ = None$.MODULE$;
        none$ = null;
        None$ none$6 = none$5;
        ConfigResource $minus$greater$extension_$this2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)this.brokerId()).toString());
        Object var6_7 = null;
        none$6 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        Map resources = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Map results = adminManager.describeConfigs(resources, true, true);
        Assert.assertEquals((long)2L, (long)results.size());
        results.foreach((Function1 & Serializable)x0$1 -> {
            AdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDescribeConfigsWithDocumentation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            DescribeConfigsResponse.Config config = (DescribeConfigsResponse.Config)x0$1._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)config.error().error());
            Assert.assertFalse((String)"Should return configs", (boolean)config.entries().isEmpty());
            config.entries().forEach(c -> {
                Assert.assertNotNull((String)new StringBuilder(42).append("Config ").append(c.name()).append(" should have non null documentation").toString(), (Object)c.documentation());
                Assert.assertNotEquals((String)new StringBuilder(43).append("Config ").append(c.name()).append(" should have non blank documentation").toString(), (Object)"", (Object)c.documentation().trim());
            });
            return;
        }
        throw new MatchError(null);
    }

    public AdminManagerTest() {
        this.brokerId = 1;
        this.topic = "topic-1";
    }
}

