/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u0014\u0001\u0005\u0002UBQA\u0014\u0001\u0005\u0002UBQ\u0001\u0015\u0001\u0005\u0002UBQA\u0015\u0001\u0005\u0002UBQ\u0001\u0016\u0001\u0005\u0002UBqA\u0016\u0001C\u0002\u0013\u0005q\u000b\u0003\u0004_\u0001\u0001\u0006I\u0001\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0011\u00199\u0007\u0001)A\u0005C\"I\u0001\u000e\u0001a\u0001\u0002\u0004%\t!\u001b\u0005\nq\u0002\u0001\r\u00111A\u0005\u0002eD\u0011\u0002 \u0001A\u0002\u0003\u0005\u000b\u0015\u00026\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0003q\bbCA\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013A!\"!\u0004\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0000\u0011)\ty\u0001\u0001a\u0001\u0002\u0004%\t!\u001b\u0005\f\u0003#\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019\u0002\u0003\u0006\u0002\u0018\u0001\u0001\r\u0011!Q!\n)D!\"!\u0007\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u007f\u0011-\tY\u0002\u0001a\u0001\u0002\u0004%\t!!\b\t\u0015\u0005\u0005\u0002\u00011A\u0001B\u0003&q\u0010\u0003\u0006\u0002$\u0001\u0001\r\u00111A\u0005\u0002%D1\"!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002(!Q\u00111\u0006\u0001A\u0002\u0003\u0005\u000b\u0015\u00026\t\u0015\u00055\u0002\u00011AA\u0002\u0013\u0005a\u0010C\u0006\u00020\u0001\u0001\r\u00111A\u0005\u0002\u0005E\u0002BCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u007f\"1\u0011q\u0007\u0001\u0005\u0002UBa!!\u000f\u0001\t\u0003)\u0004BBA\u001f\u0001\u0011\u0005Q\u0007\u0003\u0004\u0002B\u0001!\t!\u000e\u0005\u0007\u0003\u000b\u0002A\u0011A\u001b\u0003)\r{W.\\1oI2Kg.Z+uS2\u001cH+Z:u\u0015\t)c%A\u0003vi&d7OC\u0001(\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0007\u0005\u00024\u00015\tA%A\tuKN$\b+\u0019:tK\u0016k\u0007\u000f^=Be\u001e$\u0012A\u000e\t\u0003W]J!\u0001\u000f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0005i\u00125\t\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005)!.\u001e8ji*\tq(A\u0002pe\u001eL!!\u0011\u001f\u0003\tQ+7\u000f^\u0001\tKb\u0004Xm\u0019;fI\u000e\nA\t\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|g.\u0001\u0011uKN$\b+\u0019:tK\u0016k\u0007\u000f^=Be\u001e<\u0016\u000e\u001e5O_\u0012+G.[7ji\u0016\u0014\b\u0006B\u0002;\u0005\u000e\u000b\u0001\u0004^3tiB\u000b'o]3F[B$\u00180\u0011:h\u0003N4\u0016\r\\5eQ\t!!(\u0001\nuKN$\b+\u0019:tKNKgn\u001a7f\u0003J<\u0007FA\u0003;\u00035!Xm\u001d;QCJ\u001cX-\u0011:hg\"\u0012aAO\u0001$i\u0016\u001cH\u000fU1sg\u0016\f%oZ:XSRDW*\u001e7uSBdW\rR3mS6LG/\u001a:tQ\t9!(A\u0003qe>\u00048/F\u0001Y!\tIF,D\u0001[\u0015\tY\u0006*\u0001\u0003vi&d\u0017BA/[\u0005)\u0001&o\u001c9feRLWm]\u0001\u0007aJ|\u0007o\u001d\u0011\u0002\rA\f'o]3s+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'\"\u00013\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0002gG\naq\n\u001d;j_:\u0004\u0016M]:fe\u00069\u0001/\u0019:tKJ\u0004\u0013!C:ue&twm\u00149u+\u0005Q\u0007c\u00012l[&\u0011An\u0019\u0002\u000b\u001fB$\u0018n\u001c8Ta\u0016\u001c\u0007C\u00018v\u001d\ty7\u000f\u0005\u0002qY5\t\u0011O\u0003\u0002sQ\u00051AH]8pizJ!\u0001\u001e\u0017\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003i2\nQb\u001d;sS:<w\n\u001d;`I\u0015\fHC\u0001\u001c{\u0011\u001dYX\"!AA\u0002)\f1\u0001\u001f\u00132\u0003)\u0019HO]5oO>\u0003H\u000fI\u0001\u0007S:$x\n\u001d;\u0016\u0003}\u0004BAY6\u0002\u0002A\u0019Q)a\u0001\n\u0007\u0005\u0015aIA\u0004J]R,w-\u001a:\u0002\u0015%tGo\u00149u?\u0012*\u0017\u000fF\u00027\u0003\u0017Aqa\u001f\t\u0002\u0002\u0003\u0007q0A\u0004j]R|\u0005\u000f\u001e\u0011\u0002)M$(/\u001b8h\u001fB$x\n\u001d;j_:\fG.\u0011:h\u0003a\u0019HO]5oO>\u0003Ho\u00149uS>t\u0017\r\\!sO~#S-\u001d\u000b\u0004m\u0005U\u0001bB>\u0014\u0003\u0003\u0005\rA[\u0001\u0016gR\u0014\u0018N\\4PaR|\u0005\u000f^5p]\u0006d\u0017I]4!\u0003EIg\u000e^(qi>\u0003H/[8oC2\f%oZ\u0001\u0016S:$x\n\u001d;PaRLwN\\1m\u0003J<w\fJ3r)\r1\u0014q\u0004\u0005\bwZ\t\t\u00111\u0001\u0000\u0003IIg\u000e^(qi>\u0003H/[8oC2\f%o\u001a\u0011\u0002;M$(/\u001b8h\u001fB$x\n\u001d;j_:\fG.\u0011:h\u001d>$UMZ1vYR\f\u0011e\u001d;sS:<w\n\u001d;PaRLwN\\1m\u0003J<gj\u001c#fM\u0006,H\u000e^0%KF$2ANA\u0015\u0011\u001dY\u0018$!AA\u0002)\fad\u001d;sS:<w\n\u001d;PaRLwN\\1m\u0003J<gj\u001c#fM\u0006,H\u000e\u001e\u0011\u00025%tGo\u00149u\u001fB$\u0018n\u001c8bY\u0006\u0013xMT8EK\u001a\fW\u000f\u001c;\u0002=%tGo\u00149u\u001fB$\u0018n\u001c8bY\u0006\u0013xMT8EK\u001a\fW\u000f\u001c;`I\u0015\fHc\u0001\u001c\u00024!91\u0010HA\u0001\u0002\u0004y\u0018aG5oi>\u0003Ho\u00149uS>t\u0017\r\\!sO:{G)\u001a4bk2$\b%\u0001\u0007tKR,\u0006o\u00149uS>t7/\u0001\u0014uKN$X*Y=cK6+'oZ3PaRLwN\\:Pm\u0016\u0014xO]5uK\u0016C\u0018n\u001d;j]\u001eD#a\b\u001e\u0002[Q,7\u000f^'bs\n,W*\u001a:hK>\u0003H/[8og\u0012+g-Y;mi>3XM]<sSR,W\t_5ti&tw\r\u000b\u0002!u\u0005YC/Z:u\u001b\u0006L(-Z'fe\u001e,w\n\u001d;j_:\u001cH)\u001a4bk2$h+\u00197vK&3gj\u001c;Fq&\u001cH\u000f\u000b\u0002\"u\u0005IC/Z:u\u001b\u0006L(-Z'fe\u001e,w\n\u001d;j_:\u001chj\u001c;Pm\u0016\u0014xO]5uK\u0016C\u0018n\u001d;j]\u001eD#A\t\u001e")
public class CommandLineUtilsTest {
    private final Properties props = new Properties();
    private final OptionParser parser = new OptionParser(false);
    private OptionSpec<String> stringOpt;
    private OptionSpec<Integer> intOpt;
    private OptionSpec<String> stringOptOptionalArg;
    private OptionSpec<Integer> intOptOptionalArg;
    private OptionSpec<String> stringOptOptionalArgNoDefault;
    private OptionSpec<Integer> intOptOptionalArgNoDefault;

    @Test(expected=IllegalArgumentException.class)
    public void testParseEmptyArg() {
        Object[] argArray = new String[]{"my.empty.property="};
        CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray(argArray), false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseEmptyArgWithNoDelimiter() {
        Object[] argArray = new String[]{"my.empty.property"};
        CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray(argArray), false);
    }

    @Test
    public void testParseEmptyArgAsValid() {
        Object[] argArray = new String[]{"my.empty.property=", "my.empty.property1"};
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray(argArray), true);
        Assert.assertEquals((String)"Value of a key with missing value should be an empty string", (Object)props.getProperty("my.empty.property"), (Object)"");
        Assert.assertEquals((String)"Value of a key with missing value with no delimiter should be an empty string", (Object)props.getProperty("my.empty.property1"), (Object)"");
    }

    @Test
    public void testParseSingleArg() {
        Object[] argArray = new String[]{"my.property=value"};
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray(argArray), true);
        Assert.assertEquals((String)"Value of a single property should be 'value' ", (Object)props.getProperty("my.property"), (Object)"value");
    }

    @Test
    public void testParseArgs() {
        Object[] argArray = new String[]{"first.property=first", "second.property=second"};
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray(argArray), true);
        Assert.assertEquals((String)"Value of first property should be 'first'", (Object)props.getProperty("first.property"), (Object)"first");
        Assert.assertEquals((String)"Value of second property should be 'second'", (Object)props.getProperty("second.property"), (Object)"second");
    }

    @Test
    public void testParseArgsWithMultipleDelimiters() {
        Object[] argArray = new String[]{"first.property==first", "second.property=second=", "third.property=thi=rd"};
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray(argArray), true);
        Assert.assertEquals((String)"Value of first property should be '=first'", (Object)props.getProperty("first.property"), (Object)"=first");
        Assert.assertEquals((String)"Value of second property should be 'second='", (Object)props.getProperty("second.property"), (Object)"second=");
        Assert.assertEquals((String)"Value of second property should be 'thi=rd'", (Object)props.getProperty("third.property"), (Object)"thi=rd");
    }

    public Properties props() {
        return this.props;
    }

    public OptionParser parser() {
        return this.parser;
    }

    public OptionSpec<String> stringOpt() {
        return this.stringOpt;
    }

    public void stringOpt_$eq(OptionSpec<String> x$1) {
        this.stringOpt = x$1;
    }

    public OptionSpec<Integer> intOpt() {
        return this.intOpt;
    }

    public void intOpt_$eq(OptionSpec<Integer> x$1) {
        this.intOpt = x$1;
    }

    public OptionSpec<String> stringOptOptionalArg() {
        return this.stringOptOptionalArg;
    }

    public void stringOptOptionalArg_$eq(OptionSpec<String> x$1) {
        this.stringOptOptionalArg = x$1;
    }

    public OptionSpec<Integer> intOptOptionalArg() {
        return this.intOptOptionalArg;
    }

    public void intOptOptionalArg_$eq(OptionSpec<Integer> x$1) {
        this.intOptOptionalArg = x$1;
    }

    public OptionSpec<String> stringOptOptionalArgNoDefault() {
        return this.stringOptOptionalArgNoDefault;
    }

    public void stringOptOptionalArgNoDefault_$eq(OptionSpec<String> x$1) {
        this.stringOptOptionalArgNoDefault = x$1;
    }

    public OptionSpec<Integer> intOptOptionalArgNoDefault() {
        return this.intOptOptionalArgNoDefault;
    }

    public void intOptOptionalArgNoDefault_$eq(OptionSpec<Integer> x$1) {
        this.intOptOptionalArgNoDefault = x$1;
    }

    public void setUpOptions() {
        this.stringOpt_$eq((OptionSpec<String>)this.parser().accepts("str").withRequiredArg().ofType(String.class).defaultsTo((Object)"default-string", (Object[])new String[0]));
        this.intOpt_$eq((OptionSpec<Integer>)this.parser().accepts("int").withRequiredArg().ofType(Integer.class).defaultsTo((Object)100, (Object[])new Integer[0]));
        this.stringOptOptionalArg_$eq((OptionSpec<String>)this.parser().accepts("str-opt").withOptionalArg().ofType(String.class).defaultsTo((Object)"default-string-2", (Object[])new String[0]));
        this.intOptOptionalArg_$eq((OptionSpec<Integer>)this.parser().accepts("int-opt").withOptionalArg().ofType(Integer.class).defaultsTo((Object)200, (Object[])new Integer[0]));
        this.stringOptOptionalArgNoDefault_$eq((OptionSpec<String>)this.parser().accepts("str-opt-nodef").withOptionalArg().ofType(String.class));
        this.intOptOptionalArgNoDefault_$eq((OptionSpec<Integer>)this.parser().accepts("int-opt-nodef").withOptionalArg().ofType(Integer.class));
    }

    @Test
    public void testMaybeMergeOptionsOverwriteExisting() {
        this.setUpOptions();
        this.props().put("skey", "existing-string");
        this.props().put("ikey", "300");
        this.props().put("sokey", "existing-string-2");
        this.props().put("iokey", "400");
        this.props().put("sondkey", "existing-string-3");
        this.props().put("iondkey", "500");
        OptionSet options = this.parser().parse(new String[]{"--str", "some-string", "--int", "600", "--str-opt", "some-string-2", "--int-opt", "700", "--str-opt-nodef", "some-string-3", "--int-opt-nodef", "800"});
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assert.assertEquals((Object)"some-string", (Object)this.props().get("skey"));
        Assert.assertEquals((Object)"600", (Object)this.props().get("ikey"));
        Assert.assertEquals((Object)"some-string-2", (Object)this.props().get("sokey"));
        Assert.assertEquals((Object)"700", (Object)this.props().get("iokey"));
        Assert.assertEquals((Object)"some-string-3", (Object)this.props().get("sondkey"));
        Assert.assertEquals((Object)"800", (Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsDefaultOverwriteExisting() {
        this.setUpOptions();
        this.props().put("sokey", "existing-string");
        this.props().put("iokey", "300");
        this.props().put("sondkey", "existing-string-2");
        this.props().put("iondkey", "400");
        OptionSet options = this.parser().parse(new String[]{"--str-opt", "--int-opt", "--str-opt-nodef", "--int-opt-nodef"});
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assert.assertEquals((Object)"default-string-2", (Object)this.props().get("sokey"));
        Assert.assertEquals((Object)"200", (Object)this.props().get("iokey"));
        Assert.assertNull((Object)this.props().get("sondkey"));
        Assert.assertNull((Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsDefaultValueIfNotExist() {
        this.setUpOptions();
        OptionSet options = this.parser().parse(new String[0]);
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assert.assertEquals((Object)"default-string", (Object)this.props().get("skey"));
        Assert.assertEquals((Object)"100", (Object)this.props().get("ikey"));
        Assert.assertEquals((Object)"default-string-2", (Object)this.props().get("sokey"));
        Assert.assertEquals((Object)"200", (Object)this.props().get("iokey"));
        Assert.assertNull((Object)this.props().get("sondkey"));
        Assert.assertNull((Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsNotOverwriteExisting() {
        this.setUpOptions();
        this.props().put("skey", "existing-string");
        this.props().put("ikey", "300");
        this.props().put("sokey", "existing-string-2");
        this.props().put("iokey", "400");
        this.props().put("sondkey", "existing-string-3");
        this.props().put("iondkey", "500");
        OptionSet options = this.parser().parse(new String[0]);
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assert.assertEquals((Object)"existing-string", (Object)this.props().get("skey"));
        Assert.assertEquals((Object)"300", (Object)this.props().get("ikey"));
        Assert.assertEquals((Object)"existing-string-2", (Object)this.props().get("sokey"));
        Assert.assertEquals((Object)"400", (Object)this.props().get("iokey"));
        Assert.assertEquals((Object)"existing-string-3", (Object)this.props().get("sondkey"));
        Assert.assertEquals((Object)"500", (Object)this.props().get("iondkey"));
    }
}

