/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.CustomQuotaCallbackTest$GroupedUser$;
import kafka.api.GroupedUserPrincipal;
import kafka.api.GroupedUserPrincipalBuilder;
import kafka.api.GroupedUserPrincipalBuilder$;
import kafka.api.GroupedUserQuotaCallback;
import kafka.api.GroupedUserQuotaCallback$;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.QuotaTestClients;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.JaasTestUtils$ScramLoginModule$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\r-h\u0001B-[\u0001}CQa\u001a\u0001\u0005\u0002!DQA\u001b\u0001\u0005R-DQa\u001f\u0001\u0005RqDa!a\u0002\u0001\t#b\bBCA\u0005\u0001!\u0015\r\u0011\"\u0015\u0002\f!I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u00131\u0006\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002.!I\u0011Q\u0007\u0001C\u0002\u0013%\u0011q\u0007\u0005\t\u0003+\u0002\u0001\u0015!\u0003\u0002:!I\u0011q\u000b\u0001C\u0002\u0013%\u0011\u0011\f\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002J!I\u0011Q\f\u0001C\u0002\u0013E\u0013q\f\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002b!I\u0011\u0011\u000f\u0001C\u0002\u0013E\u0013q\f\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002b!I\u0011Q\u000f\u0001C\u0002\u0013%\u0011q\u000f\u0005\t\u0003+\u0003\u0001\u0015!\u0003\u0002z!Y\u0011q\u0013\u0001A\u0002\u0003\u0007I\u0011BAM\u0011-\t\u0019\f\u0001a\u0001\u0002\u0004%I!!.\t\u0017\u0005\u0005\u0007\u00011A\u0001B\u0003&\u00111\u0014\u0005\n\u0003\u0007\u0004!\u0019!C\u0001\u0003WA\u0001\"!2\u0001A\u0003%\u0011Q\u0006\u0005\n\u0003\u000f\u0004!\u0019!C\u0001\u0003WA\u0001\"!3\u0001A\u0003%\u0011Q\u0006\u0005\n\u0003\u0017\u0004!\u0019!C\u0001\u0003WA\u0001\"!4\u0001A\u0003%\u0011Q\u0006\u0005\b\u0003\u001f\u0004A\u0011IAi\u0011\u001d\t\t\u000f\u0001C!\u0003#Dq!a;\u0001\t\u0003\n\t\u000eC\u0004\u0002n\u0002!\t!!5\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"911\u0012\u0001\u0005\n\r5\u0005bBBM\u0001\u0011%11\u0014\u0005\b\u0007;\u0003A\u0011BBP\u0011\u001d\u00199\u000b\u0001C\u0005\u0007S3a!a@\u0001\u0001\n\u0005\u0001B\u0003B\u0014I\tU\r\u0011\"\u0001\u0003*!Q!\u0011\b\u0013\u0003\u0012\u0003\u0006IAa\u000b\t\u0015\tmBE!f\u0001\n\u0003\u0011I\u0003\u0003\u0006\u0003>\u0011\u0012\t\u0012)A\u0005\u0005WA!Ba\u0010%\u0005+\u0007I\u0011\u0001B\u0015\u0011)\u0011\t\u0005\nB\tB\u0003%!1\u0006\u0005\u000b\u0005\u0007\"#Q3A\u0005\u0002\t\u0015\u0003B\u0003B*I\tE\t\u0015!\u0003\u0003H!Q!Q\u000b\u0013\u0003\u0016\u0004%\tA!\u000b\t\u0015\t]CE!E!\u0002\u0013\u0011Y\u0003\u0003\u0006\u0003Z\u0011\u0012)\u001a!C\u0001\u0005SA!Ba\u0017%\u0005#\u0005\u000b\u0011\u0002B\u0016\u0011)\t\t\u000b\nBK\u0002\u0013\u0005\u0013\u0011\u0014\u0005\r\u0005;\"#\u0011#Q\u0001\n\u0005m%q\f\u0005\u000b\u0005C\"#Q3A\u0005B\t\r\u0004\u0002\u0004B8I\tE\t\u0015!\u0003\u0003f\tE\u0004BB4%\t\u0003\u0011\u0019\bC\u0004\u0003\u0006\u0012\"\tEa\"\t\u000f\t=E\u0005\"\u0011\u0003\u0012\"9!Q\u0014\u0013\u0005B\t}\u0005b\u0002B]I\u0011\u0005\u0013\u0011\u001b\u0005\b\u0005w#C\u0011\u0001B_\u0011\u001d\u00119\r\nC\u0001\u0005\u0013D\u0011B!9%#\u0003%\tAa9\t\u0013\teH%%A\u0005\u0002\tm\bb\u0002B\u0000I\u0011\u00051\u0011\u0001\u0005\b\u0007#!C\u0011AAi\u0011\u001d\u0019\u0019\u0002\nC\u0005\u0007+A\u0011b!\u0007%\u0003\u0003%\taa\u0007\t\u0013\r5B%%A\u0005\u0002\r=\u0002\"CB\u001aIE\u0005I\u0011AB\u0018\u0011%\u0019)\u0004JI\u0001\n\u0003\u0019y\u0003C\u0005\u00048\u0011\n\n\u0011\"\u0001\u0004:!I1Q\b\u0013\u0012\u0002\u0013\u00051q\u0006\u0005\n\u0007\u007f!\u0013\u0013!C\u0001\u0007_A\u0011b!\u0011%#\u0003%\taa\u0011\t\u0013\r\u001dC%%A\u0005\u0002\r%\u0003\"CB'I\u0005\u0005I\u0011IA-\u0011%\u0019y\u0005JA\u0001\n\u0003\tY\u0003C\u0005\u0004R\u0011\n\t\u0011\"\u0001\u0004T!I1Q\f\u0013\u0002\u0002\u0013\u00053q\f\u0005\n\u0007S\"\u0013\u0011!C\u0001\u0007WB\u0011ba\u001c%\u0003\u0003%\te!\u001d\t\u0013\rUD%!A\u0005B\r]\u0004\"CB=I\u0005\u0005I\u0011IB>\u0011%\u0019i\bJA\u0001\n\u0003\u001ayhB\u0005\u00040\u0002\t\t\u0011#\u0001\u00042\u001aI\u0011q \u0001\u0002\u0002#\u000511\u0017\u0005\u0007OR#\ta!2\t\u0013\reD+!A\u0005F\rm\u0004\"CBd)\u0006\u0005I\u0011QBe\u0011%\u0019Y\u000eVA\u0001\n\u0003\u001biNA\fDkN$x.\\)v_R\f7)\u00197mE\u0006\u001c7\u000eV3ti*\u00111\fX\u0001\u0004CBL'\"A/\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u00193\u0011\u0005\u0005\u0014W\"\u0001.\n\u0005\rT&AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u0005\u0005,\u0017B\u00014[\u0005%\u0019\u0016m\u001d7TKR,\b/\u0001\u0004=S:LGO\u0010\u000b\u0002SB\u0011\u0011\rA\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012\u0001\u001c\t\u0003[fl\u0011A\u001c\u0006\u0003_B\fA!Y;uQ*\u0011\u0011O]\u0001\tg\u0016\u001cWO]5us*\u00111\u000f^\u0001\u0007G>lWn\u001c8\u000b\u0005u+(B\u0001<x\u0003\u0019\t\u0007/Y2iK*\t\u00010A\u0002pe\u001eL!A\u001f8\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017\u0001\u00047jgR,g.\u001a:OC6,W#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\tA]\u0001\b]\u0016$xo\u001c:l\u0013\r\t)a \u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0018S:$XM\u001d\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016\fa\u0002\u001e:vgR\u001cFo\u001c:f\r&dW-\u0006\u0002\u0002\u000eA1\u0011qBA\u000b\u00033i!!!\u0005\u000b\u0005\u0005M\u0011!B:dC2\f\u0017\u0002BA\f\u0003#\u0011AaU8nKB!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012AA5p\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003;\u0011AAR5mK\u0006Y!M]8lKJ\u001cu.\u001e8u+\t\ti\u0003\u0005\u0003\u0002\u0010\u0005=\u0012\u0002BA\u0019\u0003#\u00111!\u00138u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0005\u0005e\u0002CBA\u001e\u0003\u000b\nI%\u0004\u0002\u0002>)!\u0011qHA!\u0003%IW.\\;uC\ndWM\u0003\u0003\u0002D\u0005E\u0011AC2pY2,7\r^5p]&!\u0011qIA\u001f\u0005\r\u0019V-\u001d\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)!\u0011qJA\u0011\u0003\u0011a\u0017M\\4\n\t\u0005M\u0013Q\n\u0002\u0007'R\u0014\u0018N\\4\u00025-\fgm[1TKJ4XM]*bg2lUm\u00195b]&\u001cXn\u001d\u0011\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.\u0006\u0002\u0002J\u0005I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003Q\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fgV\u0011\u0011\u0011\r\t\u0007\u0003\u001f\t)\"a\u0019\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003ORA!!\u001b\u0002\"\u0005!Q\u000f^5m\u0013\u0011\ti'a\u001a\u0003\u0015A\u0013x\u000e]3si&,7/A\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm\u001d\u0011\u0002)\rd\u0017.\u001a8u'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t\u0003U\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002\nA\"\u00193nS:\u001cE.[3oiN,\"!!\u001f\u0011\r\u0005m\u0014\u0011QAC\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0003\u0007\u000biHA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0003\u001f#\u0018aB2mS\u0016tGo]\u0005\u0005\u0003'\u000bIIA\u0003BI6Lg.A\u0007bI6Lgn\u00117jK:$8\u000fI\u0001\u0015aJ|G-^2fe^KG\u000f[8viF+x\u000e^1\u0016\u0005\u0005m\u0005\u0003CAO\u0003G\u000b9+a*\u000e\u0005\u0005}%\u0002BAQ\u0003\u001b\u000b\u0001\u0002\u001d:pIV\u001cWM]\u0005\u0005\u0003K\u000byJA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0007\u0003\u001f\tI+!,\n\t\u0005-\u0016\u0011\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u001f\ty+\u0003\u0003\u00022\u0006E!\u0001\u0002\"zi\u0016\f\u0001\u0004\u001d:pIV\u001cWM],ji\"|W\u000f^)v_R\fw\fJ3r)\u0011\t9,!0\u0011\t\u0005=\u0011\u0011X\u0005\u0005\u0003w\u000b\tB\u0001\u0003V]&$\b\"CA`'\u0005\u0005\t\u0019AAN\u0003\rAH%M\u0001\u0016aJ|G-^2fe^KG\u000f[8viF+x\u000e^1!\u0003M!WMZ1vYR\u0014V-];fgR\fVo\u001c;b\u0003Q!WMZ1vYR\u0014V-];fgR\fVo\u001c;bA\u0005\u0019B-\u001a4bk2$\bK]8ek\u000e,\u0017+^8uC\u0006!B-\u001a4bk2$\bK]8ek\u000e,\u0017+^8uC\u0002\n1\u0003Z3gCVdGoQ8ogVlW-U;pi\u0006\fA\u0003Z3gCVdGoQ8ogVlW-U;pi\u0006\u0004\u0013!B:fiV\u0003HCAA\\Q\rY\u0012Q\u001b\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\\<\u0002\u000b),h.\u001b;\n\t\u0005}\u0017\u0011\u001c\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3\u0001HAs!\u0011\t9.a:\n\t\u0005%\u0018\u0011\u001c\u0002\u0006\u0003\u001a$XM]\u0001$G>tg-[4ve\u0016\u001cVmY;sSRL()\u001a4pe\u0016\u001cVM\u001d<feN\u001cF/\u0019:u\u0003]!Xm\u001d;DkN$x.\\)v_R\f7)\u00197mE\u0006\u001c7\u000eK\u0002\u001f\u0003c\u0004B!a6\u0002t&!\u0011Q_Am\u0005\u0011!Vm\u001d;\u0002-\r\u0014X-\u0019;f\u000fJ|W\u000f],ji\"|e.Z+tKJ$b!a?\u0004\u0004\u000e\u001d\u0005cAA\u007fI5\t\u0001AA\u0006He>,\b/\u001a3Vg\u0016\u00148c\u0002\u0013\u0003\u0004\t%!q\u0002\t\u0004C\n\u0015\u0011b\u0001B\u00045\n\u0001\u0012+^8uCR+7\u000f^\"mS\u0016tGo\u001d\t\u0005\u0003\u001f\u0011Y!\u0003\u0003\u0003\u000e\u0005E!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005#\u0011\tC\u0004\u0003\u0003\u0014\tua\u0002\u0002B\u000b\u00057i!Aa\u0006\u000b\u0007\tea,\u0001\u0004=e>|GOP\u0005\u0003\u0003'IAAa\b\u0002\u0012\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0012\u0005K\u0011AbU3sS\u0006d\u0017N_1cY\u0016TAAa\b\u0002\u0012\u0005!Qo]3s+\t\u0011Y\u0003\u0005\u0003\u0003.\tUb\u0002\u0002B\u0018\u0005c\u0001BA!\u0006\u0002\u0012%!!1GA\t\u0003\u0019\u0001&/\u001a3fM&!\u00111\u000bB\u001c\u0015\u0011\u0011\u0019$!\u0005\u0002\u000bU\u001cXM\u001d\u0011\u0002\u0013U\u001cXM]$s_V\u0004\u0018AC;tKJ<%o\\;qA\u0005)Ao\u001c9jG\u00061Ao\u001c9jG\u0002\n!\u0002\\3bI\u0016\u0014hj\u001c3f+\t\u00119\u0005\u0005\u0003\u0003J\t=SB\u0001B&\u0015\r\u0011i\u0005X\u0001\u0007g\u0016\u0014h/\u001a:\n\t\tE#1\n\u0002\f\u0017\u000647.Y*feZ,'/A\u0006mK\u0006$WM\u001d(pI\u0016\u0004\u0013\u0001\u00059s_\u0012,8-\u001a:DY&,g\u000e^%e\u0003E\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE\rI\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\f\u0011cY8ogVlWM]\"mS\u0016tG/\u00133!\u0003%\u0001(o\u001c3vG\u0016\u0014\b%\u0003\u0003\u0002\"\n\u0015\u0011\u0001C2p]N,X.\u001a:\u0016\u0005\t\u0015\u0004\u0003\u0003B4\u0005W\n9+a*\u000e\u0005\t%$\u0002\u0002B1\u0003\u001bKAA!\u001c\u0003j\ti1*\u00194lC\u000e{gn];nKJ\f\u0011bY8ogVlWM\u001d\u0011\n\t\t\u0005$Q\u0001\u000b\u0013\u0003w\u0014)Ha\u001e\u0003z\tm$Q\u0010B@\u0005\u0003\u0013\u0019\tC\u0004\u0003(U\u0002\rAa\u000b\t\u000f\tmR\u00071\u0001\u0003,!9!qH\u001bA\u0002\t-\u0002b\u0002B\"k\u0001\u0007!q\t\u0005\b\u0005+*\u0004\u0019\u0001B\u0016\u0011\u001d\u0011I&\u000ea\u0001\u0005WAq!!)6\u0001\u0004\tY\nC\u0004\u0003bU\u0002\rA!\u001a\u0002\u001bU\u001cXM\u001d)sS:\u001c\u0017\u000e]1m+\t\u0011I\tE\u0002n\u0005\u0017K1A!$o\u00059Y\u0015MZ6b!JLgnY5qC2\fq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\u000b\u0005\u0005'\u0013I\n\u0005\u0005\u0003.\tU%1\u0006B\u0016\u0013\u0011\u00119Ja\u000e\u0003\u00075\u000b\u0007\u000fC\u0004\u0003\u001c^\u0002\rAa\u000b\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\fab\u001c<feJLG-Z)v_R\f7\u000f\u0006\u0005\u00028\n\u0005&1\u0016BX\u0011\u001d\u0011\u0019\u000b\u000fa\u0001\u0005K\u000bQ\u0002\u001d:pIV\u001cWM])v_R\f\u0007\u0003BA\b\u0005OKAA!+\u0002\u0012\t!Aj\u001c8h\u0011\u001d\u0011i\u000b\u000fa\u0001\u0005K\u000bQbY8ogVlWM])v_R\f\u0007b\u0002BYq\u0001\u0007!1W\u0001\re\u0016\fX/Z:u#V|G/\u0019\t\u0005\u0003\u001f\u0011),\u0003\u0003\u00038\u0006E!A\u0002#pk\ndW-\u0001\u000bsK6|g/Z)v_R\fwJ^3se&$Wm]\u0001\u000fG>tg-[4ve\u0016\fVo\u001c;b))\t9La0\u0003B\n\r'Q\u0019\u0005\b\u0005wQ\u0004\u0019\u0001B\u0016\u0011\u001d\u0011\u0019K\u000fa\u0001\u0005KCqA!,;\u0001\u0004\u0011)\u000bC\u0004\u00032j\u0002\rAa-\u00021\r|gNZ5hkJ,\u0017I\u001c3XC&$hi\u001c:Rk>$\u0018\r\u0006\u0006\u00028\n-'q\u001aBj\u0005/DqA!4<\u0001\u0004\u0011)+\u0001\u0007qe>$WoY3Rk>$\u0018\rC\u0004\u0003Rn\u0002\rA!*\u0002\u0015\u0019,Go\u00195Rk>$\u0018\rC\u0005\u0003Vn\u0002\n\u00111\u0001\u0002.\u00059A-\u001b<jg>\u0014\b\"\u0003BmwA\u0005\t\u0019\u0001Bn\u0003\u00159'o\\;q!\u0019\tyA!8\u0003,%!!q\\A\t\u0005\u0019y\u0005\u000f^5p]\u0006\u00113m\u001c8gS\u001e,(/Z!oI^\u000b\u0017\u000e\u001e$peF+x\u000e^1%I\u00164\u0017-\u001e7uIM*\"A!:+\t\u00055\"q]\u0016\u0003\u0005S\u0004BAa;\u0003v6\u0011!Q\u001e\u0006\u0005\u0005_\u0014\t0A\u0005v]\u000eDWmY6fI*!!1_A\t\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005o\u0014iOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!eY8oM&<WO]3B]\u0012<\u0016-\u001b;G_J\fVo\u001c;bI\u0011,g-Y;mi\u0012\"TC\u0001B\u007fU\u0011\u0011YNa:\u0002\u001dA\u0014x\u000eZ;dK\u000e{gn];nKR1\u0011qWB\u0002\u0007\u001bAqa!\u0002?\u0001\u0004\u00199!A\u000bfqB,7\r\u001e)s_\u0012,8-\u001a+ie>$H\u000f\\3\u0011\t\u0005=1\u0011B\u0005\u0005\u0007\u0017\t\tBA\u0004C_>dW-\u00198\t\u000f\r=a\b1\u0001\u0004\b\u0005)R\r\u001f9fGR\u001cuN\\:v[\u0016$\u0006N]8ui2,\u0017!\u0006:f[>4X\r\u00165s_R$H.Z'fiJL7m]\u0001\u0010cV|G/Y#oi&$\u0018PT1nKR!!1FB\f\u0011\u001d\u0011Y\u0004\u0011a\u0001\u0005W\tAaY8qsR\u0011\u00121`B\u000f\u0007?\u0019\tca\t\u0004&\r\u001d2\u0011FB\u0016\u0011%\u00119#\u0011I\u0001\u0002\u0004\u0011Y\u0003C\u0005\u0003<\u0005\u0003\n\u00111\u0001\u0003,!I!qH!\u0011\u0002\u0003\u0007!1\u0006\u0005\n\u0005\u0007\n\u0005\u0013!a\u0001\u0005\u000fB\u0011B!\u0016B!\u0003\u0005\rAa\u000b\t\u0013\te\u0013\t%AA\u0002\t-\u0002\"CAQ\u0003B\u0005\t\u0019AAN\u0011%\u0011\t'\u0011I\u0001\u0002\u0004\u0011)'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rE\"\u0006\u0002B\u0016\u0005O\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u001111\b\u0016\u0005\u0005\u000f\u00129/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012:TCAB#U\u0011\tYJa:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u001111\n\u0016\u0005\u0005K\u00129/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019)fa\u0017\u0011\t\u0005=1qK\u0005\u0005\u00073\n\tBA\u0002B]fD\u0011\"a0M\u0003\u0003\u0005\r!!\f\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0019\u0011\r\r\r4QMB+\u001b\t\t\t%\u0003\u0003\u0004h\u0005\u0005#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$Baa\u0002\u0004n!I\u0011q\u0018(\u0002\u0002\u0003\u00071QK\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002J\rM\u0004\"CA`\u001f\u0006\u0005\t\u0019AA\u0017\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0017\u0003!!xn\u0015;sS:<GCAA%\u0003\u0019)\u0017/^1mgR!1qABA\u0011%\tyLUA\u0001\u0002\u0004\u0019)\u0006C\u0004\u0004\u0006~\u0001\rAa\u000b\u0002\u0013\u0019L'o\u001d;Vg\u0016\u0014\bbBBE?\u0001\u0007\u0011QF\u0001\tEJ|7.\u001a:JI\u0006Y1M]3bi\u0016$v\u000e]5d)!\t9la$\u0004\u0012\u000eU\u0005b\u0002B A\u0001\u0007!1\u0006\u0005\b\u0007'\u0003\u0003\u0019AA\u0017\u00035qW/\u001c)beRLG/[8og\"91q\u0013\u0011A\u0002\u00055\u0012A\u00027fC\u0012,'/A\tde\u0016\fG/Z!e[&t7\t\\5f]R$\"!!\"\u0002-A\u0014x\u000eZ;dK^KG\u000f[8viRC'o\u001c;uY\u0016$b!a.\u0004\"\u000e\r\u0006b\u0002B E\u0001\u0007!1\u0006\u0005\b\u0007K\u0013\u0003\u0019AA\u0017\u0003)qW/\u001c*fG>\u0014Hm]\u0001\bC\u0012$Wk]3s)\u0019\tYpa+\u0004.\"9!qE\u0012A\u0002\t-\u0002bBBLG\u0001\u0007\u0011QF\u0001\f\u000fJ|W\u000f]3e+N,'\u000fE\u0002\u0002~R\u001bR\u0001VB[\u0007\u0003\u0004bca.\u0004>\n-\"1\u0006B\u0016\u0005\u000f\u0012YCa\u000b\u0002\u001c\n\u0015\u00141`\u0007\u0003\u0007sSAaa/\u0002\u0012\u00059!/\u001e8uS6,\u0017\u0002BB`\u0007s\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c89!\u0011\tYba1\n\t\t\r\u0012Q\u0004\u000b\u0003\u0007c\u000bQ!\u00199qYf$\"#a?\u0004L\u000e57qZBi\u0007'\u001c)na6\u0004Z\"9!qE,A\u0002\t-\u0002b\u0002B\u001e/\u0002\u0007!1\u0006\u0005\b\u0005\u007f9\u0006\u0019\u0001B\u0016\u0011\u001d\u0011\u0019e\u0016a\u0001\u0005\u000fBqA!\u0016X\u0001\u0004\u0011Y\u0003C\u0004\u0003Z]\u0003\rAa\u000b\t\u000f\u0005\u0005v\u000b1\u0001\u0002\u001c\"9!\u0011M,A\u0002\t\u0015\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007?\u001c9\u000f\u0005\u0004\u0002\u0010\tu7\u0011\u001d\t\u0015\u0003\u001f\u0019\u0019Oa\u000b\u0003,\t-\"q\tB\u0016\u0005W\tYJ!\u001a\n\t\r\u0015\u0018\u0011\u0003\u0002\u0007)V\u0004H.\u001a\u001d\t\u0013\r%\b,!AA\u0002\u0005m\u0018a\u0001=%a\u0001")
public class CustomQuotaCallbackTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private volatile CustomQuotaCallbackTest$GroupedUser$ GroupedUser$module;
    private final int brokerCount;
    private final scala.collection.immutable.Seq<String> kafkaServerSaslMechanisms;
    private final String kafkaClientSaslMechanism;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final ArrayBuffer<Admin> adminClients;
    private KafkaProducer<byte[], byte[]> producerWithoutQuota;
    private final int defaultRequestQuota;
    private final int defaultProduceQuota;
    private final int defaultConsumeQuota;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    public CustomQuotaCallbackTest$GroupedUser$ GroupedUser() {
        if (this.GroupedUser$module == null) {
            this.GroupedUser$lzycompute$1();
        }
        return this.GroupedUser$module;
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName("BROKER");
    }

    private Some<File> trustStoreFile$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        if (!this.bitmap$0) {
            return this.trustStoreFile$lzycompute();
        }
        return this.trustStoreFile;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private scala.collection.immutable.Seq<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    private ArrayBuffer<Admin> adminClients() {
        return this.adminClients;
    }

    private KafkaProducer<byte[], byte[]> producerWithoutQuota() {
        return this.producerWithoutQuota;
    }

    private void producerWithoutQuota_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producerWithoutQuota = x$1;
    }

    public int defaultRequestQuota() {
        return this.defaultRequestQuota;
    }

    public int defaultProduceQuota() {
        return this.defaultProduceQuota;
    }

    public int defaultConsumeQuota() {
        return this.defaultConsumeQuota;
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)"SCRAM-SHA-256"), KafkaSasl$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp(), ((Object)Long.MAX_VALUE).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp(), ((Object)Long.MAX_VALUE).toString());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), GroupedUserQuotaCallback.class.getName());
        this.serverConfig().setProperty(new StringBuilder(0).append(this.listenerName().configPrefix()).append(KafkaConfig$.MODULE$.PrincipalBuilderClassProp()).toString(), GroupedUserPrincipalBuilder.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
        super.setUp();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.producerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword(), false, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        this.producerWithoutQuota_$eq(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()));
    }

    @Override
    @After
    public void tearDown() {
        this.adminClients().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        GroupedUserQuotaCallback$.MODULE$.tearDown();
        super.tearDown();
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Test
    public void testCustomQuotaCallback() {
        int brokerId = 0;
        GroupedUser user = this.createGroupWithOneUser("group0_user1", brokerId);
        int x$32 = user.configureAndWaitForQuota$default$3();
        Option<String> x$4 = user.configureAndWaitForQuota$default$4();
        user.configureAndWaitForQuota(1000000L, 2000000L, x$32, x$4);
        GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().values().foreach((Function1 & Serializable)x$3 -> {
            x$3.set(0);
            return BoxedUnit.UNIT;
        });
        user.produceConsume(false, false);
        Assert.assertEquals((long)1L, (long)((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.PRODUCE)).get());
        Assert.assertTrue((String)"quotaLimit must be called at least twice", (((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.FETCH)).get() > 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(26).append("Too many quotaLimit calls ").append(GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls()).toString(), (((AtomicInteger)GroupedUserQuotaCallback$.MODULE$.quotaLimitCalls().apply((Object)ClientQuotaType.REQUEST)).get() <= 10 ? 1 : 0) != 0);
        int x$7 = user.configureAndWaitForQuota$default$3();
        Option<String> x$8 = user.configureAndWaitForQuota$default$4();
        user.configureAndWaitForQuota(9000L, 3000L, x$7, x$8);
        user.produceConsume(true, true);
        user = this.addUser("group0_user2", brokerId);
        user.removeQuotaOverrides();
        long x$9 = this.defaultProduceQuota();
        long x$10 = this.defaultConsumeQuota();
        double x$11 = this.defaultRequestQuota();
        KafkaServer x$12 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(x$9, x$10, x$11, x$12);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        user.configureAndWaitForQuota(8000L, 2500L, 1, (Option<String>)None$.MODULE$);
        user.produceConsume(true, true);
        user = this.addUser("group0_user3", brokerId);
        int x$15 = user.configureAndWaitForQuota$default$3();
        Option<String> x$16 = user.configureAndWaitForQuota$default$4();
        user.configureAndWaitForQuota(2000000L, 2000000L, x$15, x$16);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        brokerId = 1;
        user = this.createGroupWithOneUser("group1_user1", brokerId);
        int x$19 = user.configureAndWaitForQuota$default$3();
        Option<String> x$20 = user.configureAndWaitForQuota$default$4();
        user.configureAndWaitForQuota(800000L, 250000L, x$19, x$20);
        user.produceConsume(false, false);
        String largeTopic = "group1_largeTopic";
        this.createTopic(largeTopic, 99, 0);
        double x$23 = this.defaultRequestQuota();
        KafkaServer x$24 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(8000L, 2500L, x$23, x$24);
        user.produceConsume(true, true);
        user = this.addUser("group1_user2", brokerId);
        long x$25 = this.defaultProduceQuota() / 100;
        long x$26 = this.defaultConsumeQuota() / 100;
        double x$27 = this.defaultRequestQuota();
        KafkaServer x$28 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(x$25, x$26, x$27, x$28);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        user.configureAndWaitForQuota(800000L, 250000L, 100, (Option<String>)None$.MODULE$);
        user.produceConsume(true, true);
        this.adminZkClient().deleteTopic(largeTopic);
        user = this.addUser("group1_user3", brokerId);
        double x$31 = this.defaultRequestQuota();
        KafkaServer x$322 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(800000L, 250000L, x$31, x$322);
        user.removeThrottleMetrics();
        user.produceConsume(false, false);
        Admin adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(GroupedUserQuotaCallback$.MODULE$.DefaultProduceQuotaProp(), "8000");
        newProps.put(GroupedUserQuotaCallback$.MODULE$.DefaultFetchQuotaProp(), "2500");
        TestUtils$.MODULE$.incrementalAlterConfigs((Seq<KafkaServer>)this.servers(), adminClient, newProps, false, AlterConfigOp.OpType.SET);
        double x$35 = this.defaultRequestQuota();
        KafkaServer x$36 = user.waitForQuotaUpdate$default$4();
        user.waitForQuotaUpdate(8000L, 2500L, x$35, x$36);
        user.produceConsume(true, true);
        Assert.assertEquals((long)this.brokerCount(), (long)GroupedUserQuotaCallback$.MODULE$.callbackInstances().get());
    }

    /*
     * WARNING - void declaration
     */
    private GroupedUser createGroupWithOneUser(String firstUser, int brokerId) {
        void var3_3;
        GroupedUser user = this.addUser(firstUser, brokerId);
        this.createTopic(user.topic(), 1, brokerId);
        user.configureAndWaitForQuota(this.defaultProduceQuota(), this.defaultConsumeQuota(), 1, (Option<String>)None$.MODULE$);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void createTopic(String topic, int numPartitions, int leader) {
        Tuple2 tuple2;
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numPartitions, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Tuple2 tuple22;
            Tuple2 tuple23 = tuple22 = CustomQuotaCallbackTest.$anonfun$createTopic$1(leader, BoxesRunTime.unboxToInt((Object)object));
            tuple22 = null;
            tuple2 = tuple23;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            tuple2 = null;
        }
        Object var6_5 = null;
        Object var7_6 = null;
        Object var8_7 = null;
        tuple2 = null;
        scala.collection.immutable.Map assignment = ((IndexedSeq)map_strictOptimizedMap_b.result()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)this.servers());
    }

    /*
     * WARNING - void declaration
     */
    private Admin createAdminClient() {
        void var2_2;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), new ListenerName("BROKER")));
        this.clientSecurityProps("admin-client").forEach((key, value) -> config.put(key.toString(), (String)value));
        config.put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword(), false, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        Admin adminClient = Admin.create(config);
        ArrayBuffer<Admin> arrayBuffer = this.adminClients();
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)adminClient);
        return var2_2;
    }

    public void kafka$api$CustomQuotaCallbackTest$$produceWithoutThrottle(String topic, int numRecords) {
        int n = 0;
        Range.Exclusive foreach_this = new Range.Exclusive(n, numRecords, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                CustomQuotaCallbackTest.$anonfun$produceWithoutThrottle$1(this, topic, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    private GroupedUser addUser(String user, int leader) {
        String password = new StringBuilder(7).append(user).append(":secret").toString();
        this.createScramCredentials(this.zkConnect(), user, password);
        this.servers().foreach((Function1 & Serializable)server -> {
            CustomQuotaCallbackTest.$anonfun$addUser$1(this, user, server);
            return BoxedUnit.UNIT;
        });
        String userGroup = GroupedUserPrincipalBuilder$.MODULE$.group(user);
        String topic = new StringBuilder(6).append(userGroup).append("_topic").toString();
        String producerClientId = new StringBuilder(19).append(user).append(":producer-client-id").toString();
        String consumerClientId = new StringBuilder(19).append(user).append(":consumer-client-id").toString();
        this.producerConfig().put("client.id", producerClientId);
        this.producerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(user, password, false, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.consumerConfig().put("client.id", consumerClientId);
        this.consumerConfig().put("max.partition.fetch.bytes", ((Object)4096).toString());
        this.consumerConfig().put("group.id", new StringBuilder(6).append(user).append("-group").toString());
        this.consumerConfig().put("sasl.jaas.config", new JaasTestUtils.ScramLoginModule(user, password, false, JaasTestUtils$ScramLoginModule$.MODULE$.apply$default$4()).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        return new GroupedUser(this, user, userGroup, topic, (KafkaServer)this.servers().apply(leader), producerClientId, consumerClientId, producer, consumer);
    }

    private final void GroupedUser$lzycompute$1() {
        synchronized (this) {
            if (this.GroupedUser$module == null) {
                this.GroupedUser$module = new CustomQuotaCallbackTest$GroupedUser$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$createTopic$1(int leader$1, int i) {
        SeqOps $minus$greater$extension_y = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader$1}));
        Integer $minus$greater$extension_$this = i;
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ Future $anonfun$produceWithoutThrottle$1(CustomQuotaCallbackTest $this, String topic$1, int i) {
        byte[] payload = ((Object)i).toString().getBytes();
        return $this.producerWithoutQuota().send(new ProducerRecord(topic$1, null, null, (Object)payload));
    }

    public static final /* synthetic */ boolean $anonfun$addUser$2(CredentialCache.Cache cache$1, String user$1) {
        return cache$1.get(user$1) != null;
    }

    public static final /* synthetic */ String $anonfun$addUser$3() {
        return "SCRAM credentials not created";
    }

    public static final /* synthetic */ void $anonfun$addUser$1(CustomQuotaCallbackTest $this, String user$1, KafkaServer server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache($this.kafkaClientSaslMechanism(), ScramCredential.class);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!CustomQuotaCallbackTest.$anonfun$addUser$2(cache, user$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("SCRAM credentials not created", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    public CustomQuotaCallbackTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 2;
        this.kafkaServerSaslMechanisms = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"}));
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.adminClients = new ArrayBuffer();
        this.defaultRequestQuota = 1000;
        this.defaultProduceQuota = 2000000000;
        this.defaultConsumeQuota = 1000000000;
        Statics.releaseFence();
    }

    public static final /* synthetic */ Tuple2 $anonfun$createTopic$1$adapted(int leader$1, Object i) {
        return CustomQuotaCallbackTest.$anonfun$createTopic$1(leader$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Future $anonfun$produceWithoutThrottle$1$adapted(CustomQuotaCallbackTest $this, String topic$1, Object i) {
        return CustomQuotaCallbackTest.$anonfun$produceWithoutThrottle$1($this, topic$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public class GroupedUser
    extends QuotaTestClients
    implements Product,
    Serializable {
        private final String user;
        private final String userGroup;
        private final String topic;
        private final KafkaServer leaderNode;
        private final String producerClientId;
        private final String consumerClientId;
        public final /* synthetic */ CustomQuotaCallbackTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String user() {
            return this.user;
        }

        public String userGroup() {
            return this.userGroup;
        }

        public String topic() {
            return this.topic;
        }

        public KafkaServer leaderNode() {
            return this.leaderNode;
        }

        public String producerClientId() {
            return this.producerClientId;
        }

        public String consumerClientId() {
            return this.consumerClientId;
        }

        @Override
        public KafkaProducer<byte[], byte[]> producer() {
            return super.producer();
        }

        @Override
        public KafkaConsumer<byte[], byte[]> consumer() {
            return super.consumer();
        }

        @Override
        public KafkaPrincipal userPrincipal() {
            return new GroupedUserPrincipal(this.user(), this.userGroup());
        }

        /*
         * WARNING - void declaration
         */
        public scala.collection.immutable.Map<String, String> quotaMetricTags(String clientId) {
            void apply_elems;
            Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String $minus$greater$extension_y = this.userGroup();
            String $minus$greater$extension_$this = GroupedUserQuotaCallback$.MODULE$.QuotaGroupTag();
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            return (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        }

        @Override
        public void overrideQuotas(long producerQuota, long consumerQuota, double requestQuota) {
            this.configureQuota(this.userGroup(), producerQuota, consumerQuota, requestQuota);
        }

        @Override
        public void removeQuotaOverrides() {
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().adminZkClient().changeUserOrUserClientIdConfig(this.quotaEntityName(this.userGroup()), new Properties());
        }

        public void configureQuota(String userGroup, long producerQuota, long consumerQuota, double requestQuota) {
            Properties quotaProps = this.quotaProperties(producerQuota, consumerQuota, requestQuota);
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().adminZkClient().changeUserOrUserClientIdConfig(this.quotaEntityName(userGroup), quotaProps);
        }

        public void configureAndWaitForQuota(long produceQuota, long fetchQuota, int divisor, Option<String> group) {
            Object object;
            if (group == null) {
                throw null;
            }
            if (group.isEmpty()) {
                String string;
                String string2 = string = "";
                string = null;
                object = string2;
            } else {
                object = group.get();
            }
            Object object2 = object;
            object = null;
            this.configureQuota((String)object2, produceQuota, fetchQuota, this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().defaultRequestQuota());
            this.waitForQuotaUpdate(produceQuota / (long)divisor, fetchQuota / (long)divisor, this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().defaultRequestQuota(), this.waitForQuotaUpdate$default$4());
        }

        public int configureAndWaitForQuota$default$3() {
            return 1;
        }

        public Option<String> configureAndWaitForQuota$default$4() {
            return new Some((Object)this.userGroup());
        }

        public void produceConsume(boolean expectProduceThrottle, boolean expectConsumeThrottle) {
            int numRecords = 1000;
            int produced = this.produceUntilThrottled(numRecords, false);
            this.verifyProduceThrottle(expectProduceThrottle, false, false);
            this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer().kafka$api$CustomQuotaCallbackTest$$produceWithoutThrottle(this.topic(), numRecords - produced);
            this.consumeUntilThrottled(numRecords, false);
            this.verifyConsumeThrottle(expectConsumeThrottle, false, false);
        }

        public void removeThrottleMetrics() {
            this.removeSensors$1((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Request$.MODULE$, this.producerClientId());
            this.removeSensors$1((QuotaType)QuotaType.Request$.MODULE$, this.consumerClientId());
        }

        private String quotaEntityName(String userGroup) {
            return new StringBuilder(1).append(userGroup).append("_").toString();
        }

        public GroupedUser copy(String user, String userGroup, String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
            return new GroupedUser(this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer(), user, userGroup, topic, leaderNode, producerClientId, consumerClientId, producer, consumer);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.userGroup();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public KafkaServer copy$default$4() {
            return this.leaderNode();
        }

        public String copy$default$5() {
            return this.producerClientId();
        }

        public String copy$default$6() {
            return this.consumerClientId();
        }

        public KafkaProducer<byte[], byte[]> copy$default$7() {
            return this.producer();
        }

        public KafkaConsumer<byte[], byte[]> copy$default$8() {
            return this.consumer();
        }

        public String productPrefix() {
            return "GroupedUser";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.userGroup();
                }
                case 2: {
                    return this.topic();
                }
                case 3: {
                    return this.leaderNode();
                }
                case 4: {
                    return this.producerClientId();
                }
                case 5: {
                    return this.consumerClientId();
                }
                case 6: {
                    return this.producer();
                }
                case 7: {
                    return this.consumer();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof GroupedUser;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "userGroup";
                }
                case 2: {
                    return "topic";
                }
                case 3: {
                    return "leaderNode";
                }
                case 4: {
                    return "producerClientId";
                }
                case 5: {
                    return "consumerClientId";
                }
                case 6: {
                    return "producer";
                }
                case 7: {
                    return "consumer";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -889275714, false);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof GroupedUser)) return false;
            if (((GroupedUser)x$1).kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer() != this.kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            GroupedUser groupedUser = (GroupedUser)x$1;
            String string = this.user();
            String string2 = groupedUser.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.userGroup();
            String string4 = groupedUser.userGroup();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.topic();
            String string6 = groupedUser.topic();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            KafkaServer kafkaServer = this.leaderNode();
            KafkaServer kafkaServer2 = groupedUser.leaderNode();
            if (kafkaServer == null) {
                if (kafkaServer2 != null) {
                    return false;
                }
            } else if (!kafkaServer.equals(kafkaServer2)) return false;
            String string7 = this.producerClientId();
            String string8 = groupedUser.producerClientId();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.consumerClientId();
            String string10 = groupedUser.consumerClientId();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            KafkaProducer<byte[], byte[]> kafkaProducer = this.producer();
            KafkaProducer<byte[], byte[]> kafkaProducer2 = groupedUser.producer();
            if (kafkaProducer == null) {
                if (kafkaProducer2 != null) {
                    return false;
                }
            } else if (!kafkaProducer.equals(kafkaProducer2)) return false;
            KafkaConsumer<byte[], byte[]> kafkaConsumer = this.consumer();
            KafkaConsumer<byte[], byte[]> kafkaConsumer2 = groupedUser.consumer();
            if (kafkaConsumer == null) {
                if (kafkaConsumer2 != null) {
                    return false;
                }
            } else if (!kafkaConsumer.equals(kafkaConsumer2)) return false;
            if (!groupedUser.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ CustomQuotaCallbackTest kafka$api$CustomQuotaCallbackTest$GroupedUser$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ String $anonfun$configureAndWaitForQuota$1() {
            return "";
        }

        /*
         * WARNING - void declaration
         */
        private final void removeSensors$1(QuotaType quotaType, String clientId) {
            void mkString_sep;
            String string;
            Iterable iterable = this.quotaMetricTags(clientId).values();
            String string2 = ":";
            if (iterable == null) {
                throw null;
            }
            Iterable mkString_this = iterable;
            String string3 = string = mkString_this.mkString("", (String)mkString_sep, "");
            Object var4_4 = null;
            string2 = null;
            string = null;
            String sensorSuffix = string3;
            this.leaderNode().metrics().removeSensor(new StringBuilder(13).append(quotaType).append("ThrottleTime-").append(sensorSuffix).toString());
            this.leaderNode().metrics().removeSensor(new StringBuilder(1).append(quotaType).append("-").append(sensorSuffix).toString());
        }

        public GroupedUser(CustomQuotaCallbackTest $outer, String user, String userGroup, String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
            this.user = user;
            this.userGroup = userGroup;
            this.topic = topic;
            this.leaderNode = leaderNode;
            this.producerClientId = producerClientId;
            this.consumerClientId = consumerClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(topic, leaderNode, producerClientId, consumerClientId, producer, consumer);
        }
    }
}

