/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\t-g\u0001\u0002'N\u0001ICQa\u0019\u0001\u0005\u0002\u0011DQA\u001a\u0001\u0005B\u001dDqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004}\u0001\u0001\u0006I\u0001\u001f\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\t)\u0001\u0001Q\u0001\n}D1\"a\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n!Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0015\u0011-\t)\u0004\u0001a\u0001\u0002\u0003\u0006K!a\u0003\t\u0017\u0005]\u0002\u00011AA\u0002\u0013%\u0011\u0011\b\u0005\f\u0003'\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0006C\u0006\u0002Z\u0001\u0001\r\u0011!Q!\n\u0005m\u0002bCA.\u0001\u0001\u0007\t\u0019!C\u0005\u0003;B1\"a\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002r!Y\u0011Q\u000f\u0001A\u0002\u0003\u0005\u000b\u0015BA0\u0011%\t9\b\u0001b\u0001\n\u0013\tI\b\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BA>\u0011\u001d\ti\t\u0001C\u0001\u0003sBq!!'\u0001\t\u0003\tY\nC\u0004\u0002,\u0002!\t!!,\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u00111\u0019\u0001\u0005\u0002\u0005\u0015\u0007\"CAh\u0001E\u0005I\u0011AAi\u0011\u001d\t9\u000f\u0001C\u0001\u0003SDq!a=\u0001\t\u0003\tI\u000fC\u0004\u0002~\u0002!\t!!;\t\u000f\t\u001d\u0001\u0001\"\u0001\u0002j\"9!1\u0002\u0001\u0005\u0002\u0005%\bb\u0002B\b\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005'\u0001A\u0011AAu\u0011\u001d\u00119\u0002\u0001C\u0001\u0003SDqAa\u0007\u0001\t\u0003\tI\u000fC\u0004\u0003 \u0001!\t!!;\t\u000f\t\r\u0002\u0001\"\u0001\u0002j\"9!q\u0005\u0001\u0005\u0002\u0005%\bb\u0002B\u0016\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005_\u0001A\u0011AAu\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0003SDqAa\u000e\u0001\t\u0003\tI\u000fC\u0004\u0003<\u0001!\t!!;\t\u000f\t}\u0002\u0001\"\u0001\u0002j\"9!1\t\u0001\u0005\u0002\u0005%\bb\u0002B$\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005\u0017\u0002A\u0011AAu\u0011\u001d\u0011y\u0005\u0001C\u0001\u0003SDqAa\u0015\u0001\t\u0003\tI\u000fC\u0004\u0003X\u0001!\t!!;\t\u000f\tm\u0003\u0001\"\u0001\u0002j\"9!q\f\u0001\u0005\u0002\u0005%\bb\u0002B2\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005O\u0002A\u0011AAu\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0003SDqAa\u001c\u0001\t\u0003\tI\u000fC\u0004\u0003t\u0001!\t!!;\t\u000f\t]\u0004\u0001\"\u0001\u0002j\"9!1\u0010\u0001\u0005\u0002\u0005%\bb\u0002B@\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005\u0007\u0003A\u0011AAu\u0011\u001d\u00119\t\u0001C\u0001\u0003SDqAa#\u0001\t\u0003\tI\u000fC\u0004\u0003\u0010\u0002!\t!!;\t\u000f\tM\u0005\u0001\"\u0001\u0002j\"9!q\u0013\u0001\u0005\u0002\u0005%\bb\u0002BN\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005?\u0003A\u0011AAu\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0003SDqAa*\u0001\t\u0003\tI\u000fC\u0004\u0003,\u0002!\t!!;\t\u000f\t=\u0006\u0001\"\u0001\u0002j\"9!1\u0017\u0001\u0005\u0002\u0005%\bb\u0002B\\\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005w\u0003A\u0011AAu\u0011\u001d\u0011y\f\u0001C\u0001\u0003SDqAa1\u0001\t\u0003\tI\u000fC\u0004\u0003H\u0002!\t!!;\u0003?Q{\u0007/[2D_6l\u0017M\u001c3XSRD\u0017\tZ7j]\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002O\u001f\u0006)\u0011\rZ7j]*\t\u0001+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0019\u0016l\u0018\t\u0003)^k\u0011!\u0016\u0006\u0003->\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011\u0001,\u0016\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011!,X\u0007\u00027*\u0011AlT\u0001\u0006kRLGn]\u0005\u0003=n\u0013q\u0001T8hO&tw\r\u0005\u0002aC6\tQ*\u0003\u0002c\u001b\ni!+Y2l\u0003^\f'/\u001a+fgR\fa\u0001P5oSRtD#A3\u0011\u0005\u0001\u0004\u0011aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003!\u00042!\u001b8q\u001b\u0005Q'BA6m\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002[\u0006)1oY1mC&\u0011qN\u001b\u0002\u0004'\u0016\f\bCA9u\u001b\u0005\u0011(BA:P\u0003\u0019\u0019XM\u001d<fe&\u0011QO\u001d\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002qB\u0011\u0011P_\u0007\u0002Y&\u00111\u0010\u001c\u0002\u0004\u0013:$\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0019I\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014X#A@\u0011\u0007e\f\t!C\u0002\u0002\u00041\u0014Qa\u00155peR\f\u0011\u0004Z3gCVdGOU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005aAo\u001c9jGN+'O^5dKV\u0011\u00111\u0002\t\u0005\u0003\u001b\t\tC\u0004\u0003\u0002\u0010\u0005ua\u0002BA\t\u00037qA!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/\t\u0016A\u0002\u001fs_>$h(C\u0001Q\u0013\tqu*C\u0002\u0002 5\u000bA\u0002V8qS\u000e\u001cu.\\7b]\u0012LA!a\t\u0002&\t9\u0012\tZ7j]\u000ec\u0017.\u001a8u)>\u0004\u0018nY*feZL7-\u001a\u0006\u0004\u0003?i\u0015\u0001\u0005;pa&\u001c7+\u001a:wS\u000e,w\fJ3r)\u0011\tY#!\r\u0011\u0007e\fi#C\u0002\u000201\u0014A!\u00168ji\"I\u00111\u0007\u0005\u0002\u0002\u0003\u0007\u00111B\u0001\u0004q\u0012\n\u0014!\u0004;pa&\u001c7+\u001a:wS\u000e,\u0007%A\u0006bI6Lgn\u00117jK:$XCAA\u001e!\u0011\ti$a\u0014\u000e\u0005\u0005}\"b\u0001(\u0002B)!\u00111IA#\u0003\u001d\u0019G.[3oiNT1\u0001UA$\u0015\u0011\tI%a\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti%A\u0002pe\u001eLA!!\u0015\u0002@\t)\u0011\tZ7j]\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005]\u0003\"CA\u001a\u0017\u0005\u0005\t\u0019AA\u001e\u00031\tG-\\5o\u00072LWM\u001c;!\u00035!Xm\u001d;U_BL7MT1nKV\u0011\u0011q\f\t\u0005\u0003C\nIG\u0004\u0003\u0002d\u0005\u0015\u0004cAA\nY&\u0019\u0011q\r7\u0002\rA\u0013X\rZ3g\u0013\u0011\tY'!\u001c\u0003\rM#(/\u001b8h\u0015\r\t9\u0007\\\u0001\u0012i\u0016\u001cH\u000fV8qS\u000et\u0015-\\3`I\u0015\fH\u0003BA\u0016\u0003gB\u0011\"a\r\u000f\u0003\u0003\u0005\r!a\u0018\u0002\u001dQ,7\u000f\u001e+pa&\u001cg*Y7fA\u0005Iq\f^3ti:\u000bW.Z\u000b\u0003\u0003w\u0002B!! \u0002\b6\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)A\u0003sk2,7O\u0003\u0003\u0002\u0006\u0006-\u0013!\u00026v]&$\u0018\u0002BAE\u0003\u007f\u0012\u0001\u0002V3ti:\u000bW.Z\u0001\u000b?R,7\u000f\u001e(b[\u0016\u0004\u0013\u0001\u0003;fgRt\u0015-\\3)\u0007I\t\t\n\u0005\u0003\u0002\u0014\u0006UUBAAB\u0013\u0011\t9*a!\u0003\tI+H.Z\u0001\u000fCN\u001cXM\u001d;Fq&$8i\u001c3f)\u0019\tY#!(\u0002\"\"1\u0011qT\nA\u0002a\f\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\b\u0003G\u001b\u0002\u0019AAS\u0003\u0019iW\r\u001e5pIB)\u00110a*\u0002,%\u0019\u0011\u0011\u00167\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014aF1tg\u0016\u0014Ho\u00115fG.\f%oZ:Fq&$8i\u001c3f)\u0019\tY#a,\u00022\"1\u0011q\u0014\u000bA\u0002aDq!a-\u0015\u0001\u0004\t),A\u0004paRLwN\\:\u0011\t\u00055\u0011qW\u0005\u0005\u0003s\u000b)CA\nU_BL7mQ8n[\u0006tGm\u00149uS>t7/\u0001\nde\u0016\fG/Z!oI^\u000b\u0017\u000e\u001e+pa&\u001cG\u0003BA\u0016\u0003\u007fCq!!1\u0016\u0001\u0004\t),\u0001\u0003paR\u001c\u0018aE<bSR4uN\u001d+pa&\u001c7I]3bi\u0016$GCBA\u0016\u0003\u000f\fY\rC\u0004\u0002JZ\u0001\r!a\u0018\u0002\u0013Q|\u0007/[2OC6,\u0007\u0002CAg-A\u0005\t\u0019\u0001=\u0002\u000fQLW.Z8vi\u0006ir/Y5u\r>\u0014Hk\u001c9jG\u000e\u0013X-\u0019;fI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002T*\u001a\u00010!6,\u0005\u0005]\u0007\u0003BAm\u0003Gl!!a7\u000b\t\u0005u\u0017q\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!9m\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\fYNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQa]3ukB$\"!a\u000b)\u0007a\ti\u000f\u0005\u0003\u0002\u0014\u0006=\u0018\u0002BAy\u0003\u0007\u0013aAQ3g_J,\u0017!B2m_N,\u0007fA\r\u0002xB!\u00111SA}\u0013\u0011\tY0a!\u0003\u000b\u00053G/\u001a:\u0002'Q,7\u000f\u001e)beN,\u0017i]:jO:lWM\u001c;)\u0007i\u0011\t\u0001\u0005\u0003\u0002\u0014\n\r\u0011\u0002\u0002B\u0003\u0003\u0007\u0013A\u0001V3ti\u0006\u0019C/Z:u!\u0006\u00148/Z!tg&<g.\\3oi\u0012+\b\u000f\\5dCR,WI\u001c;sS\u0016\u001c\bfA\u000e\u0003\u0002\u0005aC/Z:u!\u0006\u00148/Z!tg&<g.\\3oiB\u000b'\u000f^5uS>t7o\u00144ES\u001a4WM]3oiNK'0\u001a\u0015\u00049\t\u0005\u0011!\t;fgR\u001cuN\u001c4jO>\u0003HoV5uQ\n{w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001c\bfA\u000f\u0003\u0002\u0005QA/Z:u\u0007J,\u0017\r^3)\u0007y\u0011\t!\u0001\fuKN$8I]3bi\u0016<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;tQ\ry\"\u0011A\u0001!i\u0016\u001cHo\u0011:fCR,w+\u001b;i\t\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|g\u000eK\u0002!\u0005\u0003\tq\u0004^3ti\u000e\u0013X-\u0019;f/&$\b\u000eR3gCVdG\u000fU1si&$\u0018n\u001c8tQ\r\t#\u0011A\u0001\u0016i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0007>tg-[4tQ\r\u0011#\u0011A\u0001\u001ci\u0016\u001cHo\u0011:fCR,w\u000b[3o\u00032\u0014X-\u00193z\u000bbL7\u000f^:)\u0007\r\u0012\t!\u0001\u0016uKN$8I]3bi\u0016<\u0006.\u001a8BYJ,\u0017\rZ=Fq&\u001cHo],ji\"LeMT8u\u000bbL7\u000f^:)\u0007\u0011\u0012\t!A\u0010uKN$8I]3bi\u0016<\u0016\u000e\u001e5SKBd\u0017nY1BgNLwM\\7f]RD3!\nB\u0001\u0003\u0019\"Xm\u001d;De\u0016\fG/Z,ji\"LeN^1mS\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0015\u0004M\t\u0005\u0011a\n;fgR\u001c%/Z1uK^KG\u000f\u001b(fO\u0006$\u0018N^3SKBd\u0017nY1uS>tg)Y2u_JD3a\nB\u0001\u0003%\"Xm\u001d;De\u0016\fG/Z,ji\"\f5o]5h]6,g\u000e^!oIB\u000b'\u000f^5uS>t7i\\;oi\"\u001a\u0001F!\u0001\u0002YQ,7\u000f^\"sK\u0006$XmV5uQ\u0006\u001b8/[4o[\u0016tG/\u00118e%\u0016\u0004H.[2bi&|gNR1di>\u0014\bfA\u0015\u0003\u0002\u0005!C/Z:u\u0007J,\u0017\r^3XSRDg*Z4bi&4X\rU1si&$\u0018n\u001c8D_VtG\u000fK\u0002+\u0005\u0003\t1\u0004^3ti&sg/\u00197jIR{\u0007/[2MKZ,GnQ8oM&<\u0007fA\u0016\u0003\u0002\u0005qA/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001c\bf\u0001\u0017\u0003\u0002\u0005iB/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i\u0013:\u001cG.\u001e3f\u0019&\u001cH\u000fK\u0002.\u0005\u0003\t\u0011\u0005^3ti2K7\u000f\u001e+pa&\u001c7oV5uQ\u0016C8\r\\;eK&sG/\u001a:oC2D3A\fB\u0001\u0003]!Xm\u001d;BYR,'\u000fU1si&$\u0018n\u001c8D_VtG\u000fK\u00020\u0005\u0003\t1\u0003^3ti\u0006cG/\u001a:BgNLwM\\7f]RD3\u0001\rB\u0001\u0003M\"Xm\u001d;BYR,'/Q:tS\u001etW.\u001a8u/&$\b.T8sK\u0006\u001b8/[4o[\u0016tG\u000f\u00165b]B\u000b'\u000f^5uS>t7\u000fK\u00022\u0005\u0003\t1\u0007^3ti\u0006cG/\u001a:BgNLwM\\7f]R<\u0016\u000e\u001e5N_J,\u0007+\u0019:uSRLwN\\:UQ\u0006t\u0017i]:jO:lWM\u001c;)\u0007I\u0012\t!\u0001\u0012uKN$\u0018\t\u001c;fe^KG\u000f[%om\u0006d\u0017\u000e\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0004g\t\u0005\u0011A\n;fgR\fE\u000e^3s/&$\b.\u00168ta\u0016\u001c\u0017NZ5fIB\u000b'\u000f^5uS>t7i\\;oi\"\u001aAG!\u0001\u0002;Q,7\u000f^!mi\u0016\u0014x\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgRD3!\u000eB\u0001\u0003%\"Xm\u001d;BYR,'o\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$x+\u001b;i\u0013\u001a,\u00050[:ug\"\u001aaG!\u0001\u0002CQ,7\u000f^\"sK\u0006$X-\u00117uKJ$v\u000e]5d/&$\bNU1dW\u0006;\u0018M]3)\u0007]\u0012\t!A\u0018uKN$8i\u001c8gS\u001e\u0004&/Z:feZ\fG/[8o\u0003\u000e\u0014xn]:QCJ$\u0018\u000e^5p]\u0006cG/\u001a:bi&|g\u000eK\u00029\u0005\u0003\t\u0011\u0003^3tiR{\u0007/[2EK2,G/[8oQ\rI$\u0011A\u0001\u0018i\u0016\u001cH\u000fR3mKR,\u0017J\u001c;fe:\fG\u000eV8qS\u000eD3A\u000fB\u0001\u0003y!Xm\u001d;EK2,G/Z,iK:$v\u000e]5d\t>,7O\u001c;Fq&\u001cH\u000fK\u0002<\u0005\u0003\t!\u0006^3ti\u0012+G.\u001a;f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000fK\u0002=\u0005\u0003\tA\u0002^3ti\u0012+7o\u0019:jE\u0016D3!\u0010B\u0001\u0003\u0001\"Xm\u001d;EKN\u001c'/\u001b2f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;)\u0007y\u0012\t!\u0001\u0017uKN$H)Z:de&\u0014Wm\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$x+\u001b;i\u0013\u001a,\u00050[:ug\"\u001aqH!\u0001\u0002CQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u00064\u0018-\u001b7bE2,\u0007+\u0019:uSRLwN\\:)\u0007\u0001\u0013\t!A\u0013uKN$H)Z:de&\u0014W-\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8og\"\u001a\u0011I!\u0001\u0002CQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:)\u0007\t\u0013\t!A!uKN$H)Z:de&\u0014W-\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8og^CWM\u001c*fCN\u001c\u0018n\u001a8nK:$\u0018j]%o!J|wM]3tg\"\u001a1I!\u0001\u0002=Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3Bi6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001#\u0003\u0002\u00051C/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:NS:L5O\u001d)beRLG/[8og6K\u00070\u001a3)\u0007\u0015\u0013\t!A\u0012uKN$H)Z:de&\u0014WMU3q_J$xJ^3se&$G-\u001a8D_:4\u0017nZ:)\u0007\u0019\u0013\t!\u0001\u0018uKN$H)Z:de&\u0014W-\u00118e\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i_V$\u0018J\u001c;fe:\fG\u000eV8qS\u000e\u001c\bfA$\u0003\u0002\u0005aD/Z:u\t\u0016\u001c8M]5cK\u0012{Wm\u001d(pi\u001a\u000b\u0017\u000e\\,iK:d\u0015n\u001d;j]\u001e\u0014V-Y:tS\u001etW.\u001a8u\u0013N,f.Y;uQ>\u0014\u0018N_3eQ\rA%\u0011A\u0001<i\u0016\u001cHo\u0011:fCR,Gk\u001c9jG\u0012{Wm\u001d(piJ+GO]=UQJ|G\u000f\u001e7j]\u001e\fVo\u001c;b\u000bb\u001cW-\u001a3fI\u0016C8-\u001a9uS>t\u0007fA%\u0003\u0002\u0005YD/Z:u\t\u0016dW\r^3U_BL7\rR8fg:{GOU3uef$\u0006N]8ui2LgnZ)v_R\fW\t_2fK\u0012,G-\u0012=dKB$\u0018n\u001c8)\u0007)\u0013\t!\u0001!uKN$8I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d#pKNtu\u000e\u001e*fiJLH\u000b\u001b:piRd\u0017N\\4Rk>$\u0018-\u0012=dK\u0016$W\rZ#yG\u0016\u0004H/[8oQ\rY%\u0011\u0001")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor = (short)1;
    private TopicCommand.AdminClientTopicService topicService;
    private Admin adminClient;
    private String testTopicName;
    private final TestName _testName = new TestName();

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        String x$2 = this.zkConnect();
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[6];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var8_3 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var10_5 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var12_7 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var14_9 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 4;
        Object var16_11 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Integer $minus$greater$extension_$this6 = 5;
        Object var18_13 = null;
        string6 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$6;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 1;
        boolean bl7 = false;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(6, x$2, bl, bl2, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl3, bl4, bl5, bl6, (Map<Object, String>)x$3, n, bl7, x$4, x$5).map((Function1 & Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        });
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.AdminClientTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(exitCode, exitMessage) -> TopicCommandWithAdminClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_3 = null;
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> options.checkArgs());
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topicName, 0, timeout);
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setup() {
        void mkString_end;
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(Admin.create((Properties)props));
        Admin apply_adminClient = this.adminClient();
        Object var3_2 = null;
        this.topicService_$eq(new TopicCommand.AdminClientTopicService(apply_adminClient));
        LazyList lazyList = Random$.MODULE$.alphanumeric().take(10);
        if (lazyList == null) {
            throw null;
        }
        LazyList mkString_this = lazyList;
        String mkString_mkString_sep = "";
        String string = "";
        String mkString_start = "";
        Object var5_6 = null;
        string = null;
        Object var4_4 = null;
        Object var2_3 = null;
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_mkString_sep, (String)mkString_end)).toString());
    }

    @After
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testParseAssignment() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        Object object;
        void $minus$greater$extension_y2;
        void apply_elems3;
        Object object2;
        void apply_elems4;
        Object object3;
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[3];
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4});
        List$ apply_this = List$.MODULE$;
        Object object4 = object3 = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems4);
        Object var8_3 = null;
        arraySeq = null;
        object3 = null;
        Object $minus$greater$extension_y3 = object4;
        Integer $minus$greater$extension_$this = 0;
        Object var2_6 = null;
        Object var3_5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, $minus$greater$extension_y3);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2});
        List$ apply_this2 = List$.MODULE$;
        Object object5 = object2 = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems3);
        Object var11_8 = null;
        arraySeq2 = null;
        object2 = null;
        Object object6 = object5;
        Integer $minus$greater$extension_$this2 = 1;
        Object var4_11 = null;
        object6 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0});
        List$ apply_this3 = List$.MODULE$;
        Object object7 = object = IterableFactory.apply$((IterableFactory)apply_this3, (scala.collection.immutable.Seq)apply_elems2);
        Object var14_13 = null;
        arraySeq3 = null;
        object = null;
        Object object8 = object7;
        Integer $minus$greater$extension_$this3 = 2;
        Object var6_16 = null;
        object8 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)), (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"}));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"}));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"});
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)2L);
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)2L);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"}));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)1000, (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateWhenAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitions).toString(), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
    }

    @Test
    public void testCreateWhenAlreadyExistsWithIfNotExists() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-not-exists"});
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((TopicPartitionInfo)partitions.get(0)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((TopicPartitionInfo)partitions.get(1)).replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((TopicPartitionInfo)partitions.get(2)).replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", ((Object)32768).toString(), "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"}));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"}));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var1_1 = null;
        Object var2_2 = null;
        Assert.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithIncludeList() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, (short)2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_4 = null;
        Object var6_5 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, (short)2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        Assert.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id())));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName()}));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.AdminClientTopicService adminClientTopicService;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Admin apply_adminClient = this.adminClient();
        TopicCommand.AdminClientTopicService adminClientTopicService2 = adminClientTopicService = new TopicCommand.AdminClientTopicService(apply_adminClient);
        Object var3_2 = null;
        adminClientTopicService = null;
        TopicCommand.AdminClientTopicService topicService = adminClientTopicService2;
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> topicService.alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
    }

    @Test
    public void testAlterWhenTopicDoesntExistWithIfExists() {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAlterTopicWithRackAware() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[6];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var8_2 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var10_4 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var12_6 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var14_8 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 4;
        Object var16_10 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Integer $minus$greater$extension_$this6 = 5;
        Object var18_12 = null;
        string6 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3);
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitions).toString(), "--replication-factor", ((Object)replicationFactor).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Integer n;
            Integer n2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Integer n3 = n2 = Integer.valueOf(tp.partition());
            n2 = null;
            Integer n4 = n = n3;
            n = null;
            Integer $minus$greater$extension_$this = n4;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            Object var4_5 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)alteredNumPartitions).toString(), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            Integer n;
            Integer n2;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Integer n3 = n2 = Integer.valueOf(tp.partition());
            n2 = null;
            Integer n4 = n = n3;
            n = null;
            Integer $minus$greater$extension_$this = n4;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            Object var4_5 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsOriginal).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsModified).toString(), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
    }

    @Test
    public void testDeleteWhenTopicDoesntExistWithIfExists() {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_1 = null;
        Object var3_2 = null;
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)3L, (long)rows.length);
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:2").toString());
    }

    @Test
    public void testDescribeWhenTopicDoesntExist() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 582));
    }

    @Test
    public void testDescribeWhenTopicDoesntExistWithIfExists() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get())).asScala().apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)testTopicDescription.partitions()).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$1(x$8))).get()).partition();
            this.killBroker(0);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail(TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$7(this), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l, l2));
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var7_6 = null;
            Object var8_7 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$12)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var3_2 = null;
            Object var4_3 = null;
            Assert.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$13)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_3 = null;
            Object var5_4 = null;
            Assert.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress() {
        void apply_elems;
        String string;
        void apply_elems2;
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.servers().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$14)));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).all().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)testTopicDesc.partitions()).asScala().head();
        Buffer replicasOfFirstPartition = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)firstPartition.replicas()).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()));
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableOps)brokerIds.diff((Seq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(targetReplica))))).all().get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Reassignment didn't add the second node", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var19_14 = null;
        Object var20_15 = null;
        String[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assert.assertEquals((long)2L, (long)simpleDescribeOutputRows.length);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out2.toString();
        Object var22_18 = null;
        Object var23_19 = null;
        string = null;
        String underReplicatedOutput = string2;
        Assert.assertEquals((String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(underReplicatedOutput).append("'").toString(), (Object)"", (Object)underReplicatedOutput);
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Option option = Option$.MODULE$.apply((Object)reassignments);
        if (option == null) {
            throw null;
        }
        Option forall_this = option;
        boolean bl = forall_this.isEmpty() || TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7((PartitionReassignment)forall_this.get());
        Object var13_24 = null;
        Assert.assertFalse((boolean)bl);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
    }

    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--at-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_2 = null;
            Object var5_3 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertEquals((long)1L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList(new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(0, Collections.singletonList(0))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(0, Arrays.asList(1, 2, 3))))).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$17)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var9_7 = null;
            Object var10_8 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assert.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assert.assertEquals((long)2L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String string;
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out.toString();
        Object var3_2 = null;
        Object var4_3 = null;
        string = null;
        String output = string2;
        Assert.assertTrue((String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString(), (boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        String string;
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out.toString();
        Object var2_1 = null;
        Object var3_2 = null;
        string = null;
        String output = string2;
        Assert.assertTrue((String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString(), (boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_6 = null;
        Object var7_7 = null;
        output = grabConsoleOutput_out2.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized() {
        void apply_elems;
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        Admin apply_adminClient = this.adminClient();
        Object var6_1 = null;
        this.topicService_$eq(new TopicCommand.AdminClientTopicService(apply_adminClient));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments(AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)2L, (long)rows.length);
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:1").toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateTopicDoesNotRetryThrottlingQuotaExceededException() {
        void apply_elems;
        TopicCommand.AdminClientTopicService adminClientTopicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.AdminClientTopicService adminClientTopicService2 = adminClientTopicService = new TopicCommand.AdminClientTopicService(adminClient);
        adminClientTopicService = null;
        TopicCommand.AdminClientTopicService topicService = adminClientTopicService2;
        CreateTopicsResult result = AdminClientTestUtils.createTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assert.assertThrows(ThrottlingQuotaExceededException.class, () -> topicService.createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})));
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        NewTopic expectedNewTopic = new NewTopic(this.testTopicName(), Optional.empty(), Optional.empty()).configs(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)Map.EmptyMap$.MODULE$).asJava());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{expectedNewTopic});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createTopics((Collection)ArgumentMatchers.eq((Object)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava()), (CreateTopicsOptions)ArgumentMatchers.argThat(x$18 -> !x$18.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testDeleteTopicDoesNotRetryThrottlingQuotaExceededException() {
        TopicCommand.AdminClientTopicService adminClientTopicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.AdminClientTopicService adminClientTopicService2 = adminClientTopicService = new TopicCommand.AdminClientTopicService(adminClient);
        adminClientTopicService = null;
        TopicCommand.AdminClientTopicService topicService = adminClientTopicService2;
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        DeleteTopicsResult result = AdminClientTestUtils.deleteTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.deleteTopics((Collection)ArgumentMatchers.any(), (DeleteTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assert.assertTrue((boolean)(((ExecutionException)Assert.assertThrows(ExecutionException.class, () -> topicService.deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).deleteTopics((Collection)ArgumentMatchers.eq((Object)AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)this.testTopicName(), (List)Nil$.MODULE$)).asJavaCollection()), (DeleteTopicsOptions)ArgumentMatchers.argThat(x$19 -> !x$19.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testCreatePartitionsDoesNotRetryThrottlingQuotaExceededException() {
        TopicCommand.AdminClientTopicService adminClientTopicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.AdminClientTopicService adminClientTopicService2 = adminClientTopicService = new TopicCommand.AdminClientTopicService(adminClient);
        adminClientTopicService = null;
        TopicCommand.AdminClientTopicService topicService = adminClientTopicService2;
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(0, new Node(0, "", 0), Collections.emptyList(), Collections.emptyList());
        DescribeTopicsResult describeResult = AdminClientTestUtils.describeTopicsResult((String)this.testTopicName(), (TopicDescription)new TopicDescription(this.testTopicName(), false, Collections.singletonList(topicPartitionInfo)));
        Mockito.when((Object)adminClient.describeTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)describeResult);
        CreatePartitionsResult result = AdminClientTestUtils.createPartitionsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createPartitions((java.util.Map)ArgumentMatchers.any(), (CreatePartitionsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assert.assertTrue((boolean)(((ExecutionException)Assert.assertThrows(ExecutionException.class, () -> topicService.alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"})))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createPartitions((java.util.Map)ArgumentMatchers.argThat(x$20 -> ((NewPartitions)x$20.get(this.testTopicName())).totalCount() == 3), (CreatePartitionsOptions)ArgumentMatchers.argThat(x$21 -> !x$21.shouldRetryOnQuotaViolation()));
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$8) {
        return x$8.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandWithAdminClientTest $this, MetadataResponseData.MetadataResponseTopic x$10) {
        return x$10.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$11) {
        return x$11.partitionIndex() == partitionOnBroker0$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        void apply_elems;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)x$1, x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$10))).get()).partitions()).asScala().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$11)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw Assertions$.MODULE$.fail("Partition metadata is not found in metadata cache", new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        }
        if (!(testPartitionMetadata instanceof Some)) {
            throw new MatchError((Object)testPartitionMetadata);
        }
        MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
        boolean bl = result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.servers().filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$3(x$9)))).foldLeft((Object)true, (Function2 & Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandWithAdminClientTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$12) {
        return x$12.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$13) {
        return x$13.config().brokerId() == 0;
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaServer x$14) {
        return x$14.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandWithAdminClientTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$16) {
        return x$16.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$17) {
        return x$17.config().brokerId() == 0;
    }

    public TopicCommandWithAdminClientTest() {
        this.numPartitions = 1;
    }

    public static final /* synthetic */ Object $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7$adapted(PartitionReassignment x$16) {
        return BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$16));
    }
}

