/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.ConsumerGroupCommand;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001\u0002\u0017.\u0001IBQA\u000f\u0001\u0005\u0002mBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004H\u0001\u0001\u0006Ia\u0010\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019!\u0006\u0001)A\u0005\u0015\"9Q\u000b\u0001b\u0001\n#2\u0006B\u00024\u0001A\u0003%q\u000bC\u0004h\u0001\t\u0007I\u0011\u000b5\t\rM\u0004\u0001\u0015!\u0003j\u0011\u001d!\bA1A\u0005R!Da!\u001e\u0001!\u0002\u0013I\u0007b\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\u0007w\u0002\u0001\u000b\u0011\u0002=\t\u000fq\u0004!\u0019!C\u0001o\"1Q\u0010\u0001Q\u0001\naDqA \u0001C\u0002\u0013\u0005q\u000f\u0003\u0004\u0000\u0001\u0001\u0006I\u0001\u001f\u0005\t\u0003\u0003\u0001!\u0019!C\u0001}!9\u00111\u0001\u0001!\u0002\u0013y\u0004\u0002CA\u0003\u0001\t\u0007I\u0011A<\t\u000f\u0005\u001d\u0001\u0001)A\u0005q\"I\u0011\u0011\u0002\u0001C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u000e!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003k\u0001A\u0011IA\r\u0011\u001d\t)\u0005\u0001C!\u00033Aq!a\u0014\u0001\t\u0003\tI\u0002C\u0004\u0002Z\u0001!\t!!\u0007\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\u001a!9\u0011\u0011\r\u0001\u0005\u0002\u0005e\u0001bBA3\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\t9\t\u0001C\u0001\u00033Aq!a#\u0001\t\u0003\tI\u0002C\u0004\u0002\u0010\u0002!\t!!\u0007\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\"9\u0011Q\u0017\u0001\u0005\n\u0005e\u0001bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\n\u0003'\u0004\u0011\u0013!C\u0005\u0003+Dq!a;\u0001\t\u0013\ti\u000fC\u0004\u0002z\u0002!I!a?\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\t)3+Y:m\u00072LWM\u001c;t/&$\b.\u00138wC2LGm\u0011:fI\u0016tG/[1mgR+7\u000f\u001e\u0006\u0003]=\n1!\u00199j\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0004\u0001M:\u0004C\u0001\u001b6\u001b\u0005i\u0013B\u0001\u001c.\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bC\u0001\u001b9\u0013\tITFA\u0005TCNd7+\u001a;va\u00061A(\u001b8jiz\"\u0012\u0001\u0010\t\u0003i\u0001\t\u0001d[1gW\u0006\u001cE.[3oiN\u000b7\u000f\\'fG\"\fg.[:n+\u0005y\u0004C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\u0007'R\u0014\u0018N\\4\u00023-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX\u000eI\u0001\u001aW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7/F\u0001K!\rY%kP\u0007\u0002\u0019*\u0011QJT\u0001\nS6lW\u000f^1cY\u0016T!a\u0014)\u0002\u0015\r|G\u000e\\3di&|gNC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019FJ\u0001\u0003MSN$\u0018AG6bM.\f7+\u001a:wKJ\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[N\u0004\u0013\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\u00059\u0006C\u0001-e\u001b\u0005I&B\u0001.\\\u0003\u0011\tW\u000f\u001e5\u000b\u0005qk\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005y{\u0016AB2p[6|gN\u0003\u00021A*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0013\t)\u0017L\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0006\t2/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0011\u0002)M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3t+\u0005I\u0007c\u00016l[6\t\u0001+\u0003\u0002m!\n!1k\\7f!\tq\u0017/D\u0001p\u0015\t\u00018)\u0001\u0003vi&d\u0017B\u0001:p\u0005)\u0001&o\u001c9feRLWm]\u0001\u0016g\u0016\u0014h/\u001a:TCNd\u0007K]8qKJ$\u0018.Z:!\u0003Q\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0006)2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\u0004\u0013!D2p]N,X.\u001a:D_VtG/F\u0001y!\tQ\u00170\u0003\u0002{!\n\u0019\u0011J\u001c;\u0002\u001d\r|gn];nKJ\u001cu.\u001e8uA\u0005i\u0001O]8ek\u000e,'oQ8v]R\fa\u0002\u001d:pIV\u001cWM]\"pk:$\b%A\u0006ce>\\WM]\"pk:$\u0018\u0001\u00042s_.,'oQ8v]R\u0004\u0013!\u0002;pa&\u001c\u0017A\u0002;pa&\u001c\u0007%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003\t!\b/\u0006\u0002\u0002\u000eA!\u0011qBA\t\u001b\u0005i\u0016bAA\n;\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005\u00193m\u001c8gS\u001e,(/Z*fGV\u0014\u0018\u000e^=CK\u001a|'/Z*feZ,'o]*uCJ$HCAA\u000e!\rQ\u0017QD\u0005\u0004\u0003?\u0001&\u0001B+oSR\f1d\u0019:fCR,\u0007K]5wS2,w-\u001a3BI6Lgn\u00117jK:$HCAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tQ!\u00193nS:T1!a\f`\u0003\u001d\u0019G.[3oiNLA!a\r\u0002*\t)\u0011\tZ7j]\u0006)1/\u001a;Va\"\u001a!$!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010c\u0003\u0015QWO\\5u\u0013\u0011\t\u0019%!\u0010\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007fA\u000e\u0002JA!\u00111HA&\u0013\u0011\ti%!\u0010\u0003\u000b\u00053G/\u001a:\u0002KQ,7\u000f\u001e)s_\u0012,8-\u001a:XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007f\u0001\u000f\u0002TA!\u00111HA+\u0013\u0011\t9&!\u0010\u0003\tQ+7\u000f^\u00013i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'oV5uQ\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001aQ$a\u0015\u0002KQ,7\u000f^\"p]N,X.\u001a:XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007f\u0001\u0010\u0002T\u0005)D/Z:u\u001b\u0006tW/\u00197BgNLwM\\7f]R\u001cuN\\:v[\u0016\u0014x+\u001b;i\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:fQ\ry\u00121K\u0001Li\u0016\u001cH/T1ok\u0006d\u0017i]:jO:lWM\u001c;D_:\u001cX/\\3s/&$\b.Q;u_\u000e{W.\\5u\t&\u001c\u0018M\u00197fI^KG\u000f[!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u0004A\u0005M\u0013a\n<fe&4\u0017pQ8ogVlWM],ji\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016$B!a\u0007\u0002n!9\u0011qN\u0011A\u0002\u0005E\u0014\u0001C2p]N,X.\u001a:\u0011\u0011\u0005M\u0014qOA>\u0003wj!!!\u001e\u000b\t\u0005=\u0014QF\u0005\u0005\u0003s\n)HA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006U\u0006u\u0014\u0011Q\u0005\u0004\u0003\u007f\u0002&!B!se\u0006L\bc\u00016\u0002\u0004&\u0019\u0011Q\u0011)\u0003\t\tKH/Z\u0001.i\u0016\u001cHoS1gW\u0006\fE-\\5o\u00072LWM\u001c;XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007f\u0001\u0012\u0002T\u0005\tD/Z:u\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007fA\u0012\u0002T\u0005\tD/Z:u\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3XSRD\u0017)\u001e;iK:$\u0018nY1uS>t7+^2dKN\u001c\bf\u0001\u0013\u0002T\u0005Y\u0002O]3qCJ,7i\u001c8tk6,'o\u0012:pkB\u001cVM\u001d<jG\u0016,\"!a&\u0011\t\u0005e\u0015q\u0016\b\u0005\u00037\u000bIK\u0004\u0003\u0002\u001e\u0006\u001df\u0002BAP\u0003Kk!!!)\u000b\u0007\u0005\r\u0016'\u0001\u0004=e>|GOP\u0005\u0002a%\u0019\u00111F\u0018\n\t\u0005-\u0016QV\u0001\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9D_6l\u0017M\u001c3\u000b\u0007\u0005-r&\u0003\u0003\u00022\u0006M&\u0001F\"p]N,X.\u001a:He>,\boU3sm&\u001cWM\u0003\u0003\u0002,\u00065\u0016AF2sK\u0006$Xm\u00117jK:$8I]3eK:$\u0018.\u00197\u0002\u001bM,g\u000eZ(oKJ+7m\u001c:e)\u0019\tY\"a/\u0002J\"9\u0011QX\u0014A\u0002\u0005}\u0016\u0001\u00039s_\u0012,8-\u001a:\u0011\u0011\u0005\u0005\u0017QYA>\u0003wj!!a1\u000b\t\u0005u\u0016QF\u0005\u0005\u0003\u000f\f\u0019MA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\u0005\n\u0003\u0017<\u0003\u0013!a\u0001\u0003\u001b\f\u0011\"\\1y/\u0006LG/T:\u0011\u0007)\fy-C\u0002\u0002RB\u0013A\u0001T8oO\u000692/\u001a8e\u001f:,'+Z2pe\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003/TC!!4\u0002Z.\u0012\u00111\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003%)hn\u00195fG.,GMC\u0002\u0002fB\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI/a8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000fwKJLg-_!vi\",g\u000e^5dCRLwN\\#yG\u0016\u0004H/[8o)\u0011\tY\"a<\t\u0011\u0005E\u0018\u0006\"a\u0001\u0003g\fa!Y2uS>t\u0007#\u00026\u0002v\u0006m\u0011bAA|!\nAAHY=oC6,g(A\bwKJLg-_,ji\"\u0014V\r\u001e:z)\u0011\tY\"!@\t\u0011\u0005E(\u0006\"a\u0001\u0003g\f1d\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014HCAA`\u0001")
public class SaslClientsWithInvalidCredentialsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final SecurityProtocol securityProtocol;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final int consumerCount;
    private final int producerCount;
    private final int brokerCount;
    private final String topic;
    private final int numPartitions;
    private final TopicPartition tp;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return this.createAdminClient(this.brokerList(), this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties(), this.kafkaClientSaslMechanism(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
        this.createTopic(this.topic(), this.numPartitions(), this.brokerCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProducerWithAuthenticationFailure() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        try {
            this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 10000L);
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        try {
            producer.partitionsFor(this.topic());
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        this.createClientCredential();
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    @Test
    public void testTransactionalProducerWithAuthenticationFailure() {
        KafkaProducer<byte[], byte[]> txProducer = this.createTransactionalProducer();
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        try {
            txProducer.initTransactions();
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        this.createClientCredential();
        try {
            txProducer.initTransactions();
            Assert.fail((String)"Transaction initialization should fail after authentication failure");
            return;
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testConsumerWithAuthenticationFailure() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAuthenticationFailure() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAutoCommitDisabledWithAuthenticationFailure() {
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)false).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    private void verifyConsumerWithAuthenticationFailure(KafkaConsumer<byte[], byte[]> consumer) {
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        try {
            consumer.poll(Duration.ofMillis(1000L));
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        try {
            consumer.partitionsFor(this.topic());
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        this.createClientCredential();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        int n2 = 0;
        long l3 = 15000L;
        long l4 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n2;
                SaslClientsWithInvalidCredentialsTest.$anonfun$verifyConsumerWithAuthenticationFailure$4(consumer);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n2).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
    }

    @Test
    public void testKafkaAdminClientWithAuthenticationFailure() {
        Properties props = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties());
        props.put("bootstrap.servers", this.brokerList());
        try (Admin adminClient = Admin.create((Properties)props);){
            long verifyAuthenticationException_startMs = System.currentTimeMillis();
            try {
                this.describeTopic$1(adminClient);
                Assert.fail((String)"Expected an authentication exception");
            }
            catch (Exception exception) {
                long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
                Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
            }
            this.createClientCredential();
            int n = 0;
            long l = 15000L;
            long l2 = 100L;
            long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                boolean bl;
                try {
                    ++n;
                    this.describeTopic$1(adminClient);
                    bl = true;
                }
                catch (SaslAuthenticationException saslAuthenticationException) {
                    bl = false;
                }
                if (!bl) {
                    if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                        throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                    }
                    Thread.sleep(Math.min(l, l2));
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testConsumerGroupServiceWithAuthenticationFailure() {
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = this.prepareConsumerGroupService();){
            this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).subscribe((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
            long verifyAuthenticationException_startMs = System.currentTimeMillis();
            try {
                consumerGroupService.listGroups();
                Assert.fail((String)"Expected an authentication exception");
            }
            catch (Exception exception) {
                long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
                Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testConsumerGroupServiceWithAuthenticationSuccess() {
        this.createClientCredential();
        ConsumerGroupCommand.ConsumerGroupService consumerGroupService = this.prepareConsumerGroupService();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.subscribe((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
            int n = 0;
            long l = 15000L;
            long l2 = 100L;
            long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                boolean bl;
                try {
                    ++n;
                    consumer.poll(Duration.ofMillis(1000L));
                    bl = true;
                }
                catch (SaslAuthenticationException saslAuthenticationException) {
                    bl = false;
                }
                if (bl) break;
                if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                }
                Thread.sleep(Math.min(l, l2));
            }
            List list = consumerGroupService.listConsumerGroups();
            if (list == null) {
                throw null;
            }
            Assert.assertEquals((long)1L, (long)SeqOps.size$((SeqOps)list));
        }
        finally {
            consumerGroupService.close();
        }
    }

    private ConsumerGroupCommand.ConsumerGroupService prepareConsumerGroupService() {
        File propsFile = TestUtils.tempFile();
        try (OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);){
            propsStream.write("security.protocol=SASL_PLAINTEXT\n".getBytes());
            propsStream.write(new StringBuilder(15).append("sasl.mechanism=").append(this.kafkaClientSaslMechanism()).toString().getBytes());
        }
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "test.group", "--command-config", propsFile.getAbsolutePath()};
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        return new ConsumerGroupCommand.ConsumerGroupService(opts, (Map)Map$.MODULE$.empty());
    }

    private void createClientCredential() {
        this.createScramCredentialsViaPrivilegedAdminClient(JaasTestUtils$.MODULE$.KafkaScramUser2(), JaasTestUtils$.MODULE$.KafkaScramPassword2());
    }

    private void sendOneRecord(KafkaProducer<byte[], byte[]> producer, long maxWaitMs) {
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Integer.valueOf(this.tp().partition()), Long.valueOf(0L), (Object)"key".getBytes(), (Object)"value".getBytes());
        Future future = producer.send(record);
        producer.flush();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)future.get(maxWaitMs, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString(), (recordMetadata.offset() >= 0L ? 1 : 0) != 0);
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private long sendOneRecord$default$2() {
        return 15000L;
    }

    private void verifyAuthenticationException(Function0<BoxedUnit> action) {
        long startMs = System.currentTimeMillis();
        try {
            action.apply$mcV$sp();
            Assert.fail((String)"Expected an authentication exception");
            return;
        }
        catch (Exception exception) {
            long elapsedMs = System.currentTimeMillis() - startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(elapsedMs).toString(), (elapsedMs <= 5000L ? 1 : 0) != 0);
            return;
        }
    }

    private void verifyWithRetry(Function0<BoxedUnit> action) {
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                action.apply$mcV$sp();
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer() {
        this.producerConfig().setProperty("transactional.id", "txclient-1");
        this.producerConfig().put("enable.idempotence", "true");
        return this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
    }

    public static final /* synthetic */ void $anonfun$testTransactionalProducerWithAuthenticationFailure$1(KafkaProducer txProducer$1) {
        txProducer$1.initTransactions();
    }

    public static final /* synthetic */ void $anonfun$verifyConsumerWithAuthenticationFailure$4(KafkaConsumer consumer$1) {
        Assert.assertEquals((long)1L, (long)consumer$1.poll(Duration.ofMillis(1000L)).count());
    }

    private final void describeTopic$1(Admin adminClient$1) {
        try {
            java.util.Map response = (java.util.Map)adminClient$1.describeTopics(Collections.singleton(this.topic())).all().get();
            Assert.assertEquals((long)1L, (long)response.size());
            response.forEach((topic, description) -> Assert.assertEquals((long)this.numPartitions(), (long)description.partitions().size()));
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroupServiceWithAuthenticationFailure$1(ConsumerGroupCommand.ConsumerGroupService consumerGroupService$1) {
        consumerGroupService$1.listGroups();
    }

    public static final /* synthetic */ boolean $anonfun$verifyWithRetry$1(IntRef attempts$1, Function0 action$1) {
        try {
            ++attempts$1.elem;
            action$1.apply$mcV$sp();
            return true;
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyWithRetry$2(IntRef attempts$1) {
        return new StringBuilder(47).append("Operation did not succeed within timeout after ").append(attempts$1.elem).toString();
    }

    public SaslClientsWithInvalidCredentialsTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.consumerCount = 1;
        this.producerCount = 1;
        this.brokerCount = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.topic = "topic";
        this.numPartitions = 1;
        this.tp = new TopicPartition(this.topic(), 0);
        Statics.releaseFence();
    }
}

