/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SortedOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.IntegralProxy;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001A\u0002\u0013\u00051\u0006C\u00040\u0001\u0001\u0007I\u0011\u0001\u0019\t\rY\u0002\u0001\u0015)\u0003-\u0011\u001d9\u0004A1A\u0005\u0002aBa\u0001\u0010\u0001!\u0002\u0013I\u0004bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B \t\u000b\r\u0003A\u0011\u0001#\t\u000b9\u0003A\u0011\u0001#\t\u000bM\u0003A\u0011\u0001#\t\u000b\t\u0004A\u0011\u0001#\t\u000b\u0011\u0004A\u0011\u0001#\t\u000b\u0019\u0004A\u0011\u0001#\t\u000bY\u0004A\u0011\u0001#\t\u000ba\u0004A\u0011\u0001#\t\r\u00055\u0001\u0001\"\u0001E\u0011\u0019\t\t\u0002\u0001C\u0001\t\"1\u0011Q\u0003\u0001\u0005\u0002\u0011Ca!!\u0007\u0001\t\u0003!\u0005BBA\u000f\u0001\u0011\u0005A\tC\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m$aD(gMN,G/\u00138eKb$Vm\u001d;\u000b\u0005ma\u0012a\u00017pO*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u00025\u0005\u0019\u0011\u000e\u001a=\u0016\u00031\u0002\"!K\u0017\n\u00059R\"aC(gMN,G/\u00138eKb\fq!\u001b3y?\u0012*\u0017\u000f\u0006\u00022iA\u0011\u0011EM\u0005\u0003g\t\u0012A!\u00168ji\"9QgAA\u0001\u0002\u0004a\u0013a\u0001=%c\u0005!\u0011\u000e\u001a=!\u0003)i\u0017\r_#oiJLWm]\u000b\u0002sA\u0011\u0011EO\u0005\u0003w\t\u00121!\u00138u\u0003-i\u0017\r_#oiJLWm\u001d\u0011\u0002\u0015\t\f7/Z(gMN,G/F\u0001@!\t\t\u0003)\u0003\u0002BE\t!Aj\u001c8h\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\u0002\u000bM,G/\u001e9\u0015\u0003EB#!\u0003$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015!\u00026v]&$(\"A&\u0002\u0007=\u0014x-\u0003\u0002N\u0011\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0015A\u0003\"aR)\n\u0005IC%!B!gi\u0016\u0014\u0018\u0001\u0005:b]\u0012|W\u000eT8pWV\u0004H+Z:uQ\tYQ\u000b\u0005\u0002H-&\u0011q\u000b\u0013\u0002\u0005)\u0016\u001cH\u000f\u000b\u0003\f3~\u0003\u0007C\u0001.^\u001b\u0005Y&B\u0001/#\u0003)\tgN\\8uCRLwN\\\u0005\u0003=n\u0013aA\\8xCJt\u0017!\u0002<bYV,\u0017%A1\u0002\u001f\r\fG/\u00103faJ,7-\u0019;j_:\f!\u0003\\8pWV\u0004X\t\u001f;sK6,7)Y:fg\"\u0012A\"V\u0001\ni\u0016\u001cH/\u00128uefD#!D+\u0002#Q,7\u000f^#oiJLxJ^3sM2|w\u000f\u000b\u0003\u000f+\"L\u0017\u0001C3ya\u0016\u001cG/\u001a3$\u0003)\u0004\"a[:\u000f\u00051\fhBA7q\u001b\u0005q'BA8\u001f\u0003\u0019a$o\\8u}%\t1%\u0003\u0002sE\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0003e\n\nQ\"\u00199qK:$Gk\\8NC:L\bFA\bV\u0003A\t\u0007\u000f]3oI>+Ho\u00144Pe\u0012,'\u000f\u000b\u0003\u0011+\"T8%A>\u0011\u0007q\fI!D\u0001~\u0015\tqx0\u0001\u0004feJ|'o\u001d\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0004d_6lwN\u001c\u0006\u0004;\u0005\u0015!bAA\u0004\u0015\u00061\u0011\r]1dQ\u0016L1!a\u0003~\u0005YIeN^1mS\u0012|eMZ:fi\u0016C8-\u001a9uS>t\u0017!\u0007;fgR4U\r^2i+B\u0004XM\u001d\"pk:$wJ\u001a4tKRD#!E+\u0002\u0015Q,7\u000f\u001e*f_B,g\u000e\u000b\u0002\u0013+\u0006AAO];oG\u0006$X\r\u000b\u0002\u0014+\u0006qam\u001c:dKVsW.\u00199UKN$\bF\u0001\u000bV\u0003\u0015\"Xm\u001d;TC:LG/\u001f'bgR|eMZ:fi\u0016\u000bX/\u00197U_\n\u000b7/Z(gMN,G\u000f\u000b\u0002\u0016+\u0006\u0001\u0012m]:feR<&/\u001b;f\r\u0006LGn]\u000b\u0005\u0003K\ty\u0005F\u00052\u0003O\tY$!\u0010\u0002B!9\u0011\u0011\u0006\fA\u0002\u0005-\u0012aB7fgN\fw-\u001a\t\u0005\u0003[\t)D\u0004\u0003\u00020\u0005E\u0002CA7#\u0013\r\t\u0019DI\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0012\u0011\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005M\"\u0005C\u0003+-\u0001\u0007A\u0006\u0003\u0004\u0002@Y\u0001\r!O\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005\rc\u00031\u0001\u0002F\u0005)1\u000e\\1tgB1\u0011QFA$\u0003\u0017JA!!\u0013\u0002:\t)1\t\\1tgB!\u0011QJA(\u0019\u0001!q!!\u0015\u0017\u0005\u0004\t\u0019FA\u0001U#\u0011\t)&a\u0017\u0011\u0007\u0005\n9&C\u0002\u0002Z\t\u0012qAT8uQ&tw\rE\u0002\"\u0003;J1!a\u0018#\u0005\r\te._\u0001\r[>tw\u000e^8oS\u000e\u001cV-\u001d\u000b\u0007\u0003K\n\t(!\u001e\u0011\u000b\u0005\u001d\u0014QN\u001d\u000e\u0005\u0005%$bAA6E\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0014\u0011\u000e\u0002\u0004'\u0016\f\bBBA:/\u0001\u0007\u0011(\u0001\u0003cCN,\u0007BBA</\u0001\u0007\u0011(A\u0002mK:\f1C\\8o\u000bbL7\u000f^3oiR+W\u000e\u001d$jY\u0016$\"!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006\u0011\u0011n\u001c\u0006\u0003\u0003\u000f\u000bAA[1wC&!\u00111RAA\u0005\u00111\u0015\u000e\\3")
public class OffsetIndexTest {
    private OffsetIndex idx = null;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @Before
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240, true));
    }

    @After
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void randomLookupTest() {
        TreeMap treeMap;
        TreeMap treeMap2;
        TreeMap treeMap3;
        void $plus$plus_xs;
        TreeMap treeMap4;
        Assert.assertEquals((String)"Not present value should return physical offset 0.", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L));
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableOps)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable)x$1 -> x$1)).zip(this.monotonicSeq(0, size));
        vals.foreach((Function1 & Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        IterableOnce iterableOnce = (IterableOnce)vals.map((Function1 & Serializable)p -> new Tuple2((Object)p._1$mcJ$sp(), p));
        TreeMap $plus$plus_this = new TreeMap((Ordering)Ordering.Long$.MODULE$);
        TreeMap treeMap5 = treeMap4 = $plus$plus_this.concat((IterableOnce)$plus$plus_xs);
        treeMap4 = null;
        TreeMap treeMap6 = treeMap3 = treeMap5;
        treeMap3 = null;
        TreeMap treeMap7 = treeMap2 = treeMap6;
        treeMap2 = null;
        TreeMap treeMap8 = treeMap = treeMap7;
        Object var6_5 = null;
        iterableOnce = null;
        treeMap = null;
        TreeMap valMap = treeMap8;
        long[] offsets = (long[])IntegralProxy.until$((IntegralProxy)new RichLong(this.idx().baseOffset()), (Object)((int)((Tuple2)vals.last())._1$mcJ$sp())).toArray((ClassTag)ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList(new long[][]{offsets}));
        int take$extension_n = 30;
        for (long l : (long[])ArrayOps$.MODULE$.slice$extension((Object)offsets, 0, take$extension_n)) {
            OffsetIndexTest.$anonfun$randomLookupTest$6(this, valMap, l);
        }
    }

    @Test
    public void lookupExtremeCases() {
        Assert.assertEquals((String)"Lookup on empty file", (Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        int n = 0;
        int until$extension_end = this.idx().maxEntries();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$lookupExtremeCases$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var2_3 = null;
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assert.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        int n = 0;
        int until$extension_end = this.idx().maxEntries();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$testEntry$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var3_3 = null;
        int n2 = 0;
        int until$extension_end2 = this.idx().maxEntries();
        Range.Exclusive foreach$mVc$sp_this2 = new Range.Exclusive(n2, until$extension_end2, 1);
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                OffsetIndexTest.$anonfun$testEntry$2(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntryOverflow() {
        this.idx().entry(0);
    }

    @Test
    public void appendTooMany() {
        int n = 0;
        int until$extension_end = this.idx().maxEntries();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                OffsetIndexTest.$anonfun$appendTooMany$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var2_3 = null;
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test(expected=InvalidOffsetException.class)
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        this.idx().append(50L, 1);
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 5));
        .colon.colon foreach_these = new .colon.colon((Object)first, (List)new .colon.colon((Object)second, (List)new .colon.colon((Object)third, (List)new .colon.colon((Object)fourth, (List)Nil$.MODULE$))));
        while (!foreach_these.isEmpty()) {
            OffsetPosition offsetPosition = (OffsetPosition)foreach_these.head();
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            foreach_these = (List)foreach_these.tail();
        }
        Object var5_5 = null;
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assert.assertEquals((Object)new Some((Object)second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assert.assertEquals((Object)new Some((Object)third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assert.assertEquals((Object)new Some((Object)fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset(), first.position());
        this.idx().append(sec.offset(), sec.position());
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset(), -1, true);
        Assert.assertEquals((Object)first, (Object)idxRo.lookup(first.offset()));
        Assert.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset()));
        Assert.assertEquals((long)sec.offset(), (long)idxRo.lastOffset());
        Assert.assertEquals((long)2L, (long)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, true);
        idx.truncate();
        int n = 1;
        int until$extension_end = 10;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                idx.append((long)foreach$mVc$sp_i, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var3_4 = null;
        idx.truncateTo(12L);
        Assert.assertEquals((String)"Index should be unchanged by truncate past the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assert.assertEquals((String)"Index should be unchanged by truncate at the end", (Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"9 should be the last entry in the index", (long)9L, (long)idx.lastOffset());
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assert.assertEquals((String)"Index should truncate off last entry", (Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"8 should be the last entry in the index", (long)8L, (long)idx.lastOffset());
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assert.assertEquals((String)"4 should be the last entry in the index", (Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L));
        Assert.assertEquals((String)"4 should be the last entry in the index", (long)4L, (long)idx.lastOffset());
        idx.append(5L, 5);
        idx.truncate();
        Assert.assertEquals((String)"Full truncation should leave no entries", (long)0L, (long)idx.entries());
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80, true);
        idx.forceUnmap();
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> idx.lookup(1L), ClassTag$.MODULE$.apply(NullPointerException.class), new Position("OffsetIndexTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80, true);
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        try {
            idx.append((long)offset, 1);
            Assert.fail((String)message);
            return;
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Got an unexpected exception.", klass, e.getClass());
            return;
        }
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        int n = base;
        int n2 = 0;
        Range.Exclusive foreach_this = new Range.Exclusive(n2, len, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                Integer n3;
                Integer n4 = n3 = Integer.valueOf(n += rand.nextInt(15) + 1);
                n3 = null;
                Integer $anonfun$monotonicSeq$1_$plus$eq_elem = n4;
                Object var8_9 = null;
                ArrayBuffer cfr_ignored_0 = (ArrayBuffer)vals.addOne((Object)$anonfun$monotonicSeq$1_$plus$eq_elem);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils.tempFile();
        Files.delete(file.toPath());
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        if (x$2 != null) {
            long logical = x$2._1$mcJ$sp();
            int physical = x$2._2$mcI$sp();
            Assert.assertEquals((String)"Should be able to find values that are present.", (Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$6(OffsetIndexTest $this, TreeMap valMap$1, long offset) {
        OffsetPosition offsetPosition;
        if (offset < BoxesRunTime.unboxToLong((Object)valMap$1.firstKey())) {
            offsetPosition = new OffsetPosition($this.idx().baseOffset(), 0);
        } else {
            Long l;
            Long l2;
            Long l3 = l2 = Long.valueOf(offset);
            l2 = null;
            Long to_to = l3;
            Object var5_4 = null;
            Long l4 = l = Long.valueOf(offset);
            l = null;
            Long to_to2 = l4;
            Object var6_6 = null;
            OffsetPosition offsetPosition2 = new OffsetPosition(((TreeMap)SortedOps.to$((SortedOps)valMap$1, (Object)to_to)).last()._1$mcJ$sp(), ((Tuple2)((TreeMap)SortedOps.to$((SortedOps)valMap$1, (Object)to_to2)).last()._2())._2$mcI$sp());
            offsetPosition = offsetPosition2;
        }
        OffsetPosition rightAnswer = offsetPosition;
        Assert.assertEquals((String)"The index should give the same answer as the sorted map", (Object)rightAnswer, (Object)$this.idx().lookup(offset));
    }

    public static final /* synthetic */ void $anonfun$lookupExtremeCases$1(OffsetIndexTest $this, int i) {
        $this.idx().append($this.idx().baseOffset() + (long)i + 1L, i);
    }

    public static final /* synthetic */ void $anonfun$testEntry$1(OffsetIndexTest $this, int i) {
        $this.idx().append($this.idx().baseOffset() + (long)i + 1L, i);
    }

    public static final /* synthetic */ void $anonfun$testEntry$2(OffsetIndexTest $this, int i) {
        Assert.assertEquals((Object)new OffsetPosition($this.idx().baseOffset() + (long)i + 1L, i), (Object)$this.idx().entry(i));
    }

    public static final /* synthetic */ void $anonfun$appendTooMany$1(OffsetIndexTest $this, int i) {
        long offset = $this.idx().baseOffset() + (long)i + 1L;
        $this.idx().append(offset, i);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset(), offsetPosition.position());
    }

    public static final /* synthetic */ void $anonfun$truncate$1(OffsetIndex idx$1, int i) {
        idx$1.append((long)i, i);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int x$3) {
        void $plus$eq_elem;
        Integer n;
        last$1.elem += rand$1.nextInt(15) + 1;
        Integer n2 = n = Integer.valueOf(last$1.elem);
        n = null;
        Integer n3 = n2;
        if (vals$1 == null) {
            throw null;
        }
        return (ArrayBuffer)vals$1.addOne((Object)$plus$eq_elem);
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }

    public static final /* synthetic */ Object $anonfun$testFetchUpperBoundOffset$1$adapted(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1($this, offsetPosition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1$adapted(IntRef last$1, Random rand$1, ArrayBuffer vals$1, Object x$3) {
        return OffsetIndexTest.$anonfun$monotonicSeq$1(last$1, rand$1, vals$1, BoxesRunTime.unboxToInt((Object)x$3));
    }
}

