/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotasTest$ListenerDesc$;
import kafka.network.Processor$;
import kafka.network.SocketServer$;
import kafka.network.TooManyConnectionsException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntegralProxy;
import scala.runtime.LongRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005e\u0001\u0002(P\u0001QCQa\u0017\u0001\u0005\u0002qC\u0011b\u0018\u0001A\u0002\u0003\u0007I\u0011\u00021\t\u00135\u0004\u0001\u0019!a\u0001\n\u0013q\u0007\"\u0003;\u0001\u0001\u0004\u0005\t\u0015)\u0003b\u0011%)\b\u00011AA\u0002\u0013%a\u000fC\u0006\u0002\u0004\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0001BCA\u0005\u0001\u0001\u0007\t\u0011)Q\u0005o\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\t\u0017\u0005m\u0001\u00011A\u0001B\u0003&\u0011q\u0002\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?A\u0001\"a@\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0005\u0003\u0001!\u0019!C\u0005\u0005\u0007A\u0001B!\n\u0001A\u0003%!Q\u0001\u0005\n\u0005O\u0001!\u0019!C\u0005\u0003cB\u0001B!\u000b\u0001A\u0003%\u00111\u000f\u0005\n\u0005W\u0001!\u0019!C\u0005\u0003cB\u0001B!\f\u0001A\u0003%\u00111\u000f\u0005\n\u0005_\u0001!\u0019!C\u0005\u0003\u000bD\u0001B!\r\u0001A\u0003%\u0011q\u0019\u0005\n\u0005g\u0001!\u0019!C\u0005\u0003\u000bD\u0001B!\u000e\u0001A\u0003%\u0011q\u0019\u0004\u0007\u0003{\u0001\u0001)a\u0010\t\u0015\u0005}sC!f\u0001\n\u0003\t\t\u0007\u0003\u0006\u0002n]\u0011\t\u0012)A\u0005\u0003GB!\"a\u001c\u0018\u0005+\u0007I\u0011AA9\u0011)\tyh\u0006B\tB\u0003%\u00111\u000f\u0005\u00077^!\t!!!\t\u000f\u0005\u001du\u0003\"\u0011\u0002\n\"I\u0011\u0011T\f\u0002\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003C;\u0012\u0013!C\u0001\u0003GC\u0011\"!/\u0018#\u0003%\t!a/\t\u0013\u0005}v#!A\u0005B\u0005\u0005\u0007\"CAb/\u0005\u0005I\u0011AAc\u0011%\timFA\u0001\n\u0003\ty\rC\u0005\u0002Z^\t\t\u0011\"\u0011\u0002\\\"I\u00111]\f\u0002\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003_<\u0012\u0011!C!\u0003cD\u0011\"!>\u0018\u0003\u0003%\t%a>\t\u0013\u0005ex#!A\u0005B\u0005mx!\u0003B\u001c\u0001\u0005\u0005\t\u0012\u0001B\u001d\r%\ti\u0004AA\u0001\u0012\u0003\u0011Y\u0004\u0003\u0004\\U\u0011\u0005!1\u000b\u0005\n\u0003\u000fS\u0013\u0011!C#\u0005+B\u0011Ba\u0016+\u0003\u0003%\tI!\u0017\t\u0013\t}#&!A\u0005\u0002\n\u0005\u0004b\u0002B:\u0001\u0011\u0005!Q\u000f\u0005\b\u0005\u007f\u0002A\u0011\u0001BA\u0011\u001d\u0011\t\n\u0001C\u0001\u0005\u0003CqAa'\u0001\t\u0003\u0011\t\tC\u0004\u0003&\u0002!\tA!!\t\u000f\t%\u0006\u0001\"\u0001\u0003\u0002\"9!Q\u0016\u0001\u0005\u0002\t\u0005\u0005b\u0002BY\u0001\u0011\u0005!\u0011\u0011\u0005\b\u0005k\u0003A\u0011\u0001BA\u0011\u001d\u0011I\f\u0001C\u0001\u0005\u0003CqA!0\u0001\t\u0003\u0011\t\tC\u0004\u0003B\u0002!\tA!!\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003\u0002\"9!\u0011\u001a\u0001\u0005\u0002\t\u0005\u0005b\u0002Bg\u0001\u0011\u0005!\u0011\u0011\u0005\b\u0005#\u0004A\u0011\u0001BA\u0011\u001d\u0011)\u000e\u0001C\u0001\u0005\u0003CqA!7\u0001\t\u0013\u0011Y\u000eC\u0004\u0003Z\u0002!IAa<\t\u000f\r=\u0001\u0001\"\u0003\u0003\u0002\"91\u0011\u0003\u0001\u0005\n\t\u0005\u0005bBB\n\u0001\u0011%!\u0011\u0011\u0005\b\u0007+\u0001A\u0011BB\f\u0011\u001d\u0019y\u0002\u0001C\u0005\u0007CAqa!\f\u0001\t\u0013\u0019y\u0003C\u0004\u00044\u0001!Ia!\u000e\t\u000f\r]\u0002\u0001\"\u0003\u0004:!I1q\n\u0001\u0012\u0002\u0013%1\u0011\u000b\u0005\b\u0007+\u0002A\u0011BB,\u0011\u001d\u00199\u0004\u0001C\u0005\u0007SBqaa\u001e\u0001\t\u0013\u0019IH\u0001\u000bD_:tWm\u0019;j_:\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003!F\u000bqA\\3uo>\u00148NC\u0001S\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A+\u0011\u0005YKV\"A,\u000b\u0003a\u000bQa]2bY\u0006L!AW,\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\f\u0005\u0002_\u00015\tq*A\u0004nKR\u0014\u0018nY:\u0016\u0003\u0005\u0004\"AY6\u000e\u0003\rT!a\u00183\u000b\u0005\u00154\u0017AB2p[6|gN\u0003\u0002SO*\u0011\u0001.[\u0001\u0007CB\f7\r[3\u000b\u0003)\f1a\u001c:h\u0013\ta7MA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003_J\u0004\"A\u00169\n\u0005E<&\u0001B+oSRDqa]\u0002\u0002\u0002\u0003\u0007\u0011-A\u0002yIE\n\u0001\"\\3ue&\u001c7\u000fI\u0001\tKb,7-\u001e;peV\tq\u000f\u0005\u0002y\u007f6\t\u0011P\u0003\u0002{w\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005ql\u0018\u0001B;uS2T\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002e\u0014q\"\u0012=fGV$xN]*feZL7-Z\u0001\rKb,7-\u001e;pe~#S-\u001d\u000b\u0004_\u0006\u001d\u0001bB:\u0007\u0003\u0003\u0005\ra^\u0001\nKb,7-\u001e;pe\u0002\n\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0016\u0005\u0005=\u0001c\u00010\u0002\u0012%\u0019\u00111C(\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018\u0001F2p]:,7\r^5p]F+x\u000e^1t?\u0012*\u0017\u000fF\u0002p\u00033A\u0001b]\u0005\u0002\u0002\u0003\u0007\u0011qB\u0001\u0012G>tg.Z2uS>t\u0017+^8uCN\u0004\u0013!\u00037jgR,g.\u001a:t+\t\t\t\u0003\u0005\u0005\u0002$\u0005%\u0012QFA\u001d\u001b\t\t)CC\u0002\u0002(]\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY#!\n\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019$`\u0001\u0005Y\u0006tw-\u0003\u0003\u00028\u0005E\"AB*ue&tw\rE\u0002\u0002<]i\u0011\u0001\u0001\u0002\r\u0019&\u001cH/\u001a8fe\u0012+7oY\n\u0007/U\u000b\t%a\u0012\u0011\u0007Y\u000b\u0019%C\u0002\u0002F]\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002J\u0005ec\u0002BA&\u0003+rA!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#\u001a\u0016A\u0002\u001fs_>$h(C\u0001Y\u0013\r\t9fV\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY&!\u0018\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005]s+\u0001\u0007mSN$XM\\3s\u001d\u0006lW-\u0006\u0002\u0002dA!\u0011QMA5\u001b\t\t9G\u0003\u0002QI&!\u00111NA4\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u00035a\u0017n\u001d;f]\u0016\u0014h*Y7fA\u0005IA-\u001a4bk2$\u0018\n]\u000b\u0003\u0003g\u0002B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003sj\u0018a\u00018fi&!\u0011QPA<\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\u0002\u0015\u0011,g-Y;mi&\u0003\b\u0005\u0006\u0004\u0002:\u0005\r\u0015Q\u0011\u0005\b\u0003?b\u0002\u0019AA2\u0011\u001d\ty\u0007\ba\u0001\u0003g\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u0016:!\u0011qRAI!\r\tieV\u0005\u0004\u0003';\u0016A\u0002)sK\u0012,g-\u0003\u0003\u00028\u0005]%bAAJ/\u0006!1m\u001c9z)\u0019\tI$!(\u0002 \"I\u0011q\f\u0010\u0011\u0002\u0003\u0007\u00111\r\u0005\n\u0003_r\u0002\u0013!a\u0001\u0003g\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002&*\"\u00111MATW\t\tI\u000b\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\u0013Ut7\r[3dW\u0016$'bAAZ/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0016Q\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003{SC!a\u001d\u0002(\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0007c\u0001,\u0002J&\u0019\u00111Z,\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E\u0017q\u001b\t\u0004-\u0006M\u0017bAAk/\n\u0019\u0011I\\=\t\u0011M\u001c\u0013\u0011!a\u0001\u0003\u000f\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003;\u0004b!a\t\u0002`\u0006E\u0017\u0002BAq\u0003K\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q]Aw!\r1\u0016\u0011^\u0005\u0004\u0003W<&a\u0002\"p_2,\u0017M\u001c\u0005\tg\u0016\n\t\u00111\u0001\u0002R\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ti#a=\t\u0011M4\u0013\u0011!a\u0001\u0003\u000f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u000f\fa!Z9vC2\u001cH\u0003BAt\u0003{D\u0001b\u001d\u0015\u0002\u0002\u0003\u0007\u0011\u0011[\u0001\u000bY&\u001cH/\u001a8feN\u0004\u0013\u0001\u00062m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u00148/\u0006\u0002\u0003\u0006AA!q\u0001B\u0007\u0003\u0017\u0013y!\u0004\u0002\u0003\n)!!1BA\u0013\u0003\u001diW\u000f^1cY\u0016LA!a\u000b\u0003\nA!!\u0011\u0003B\u0011\u001b\t\u0011\u0019B\u0003\u0003\u0003\u0016\t]\u0011\u0001B2pe\u0016T1a\u0018B\r\u0015\u0011\u0011YB!\b\u0002\re\fW.\\3s\u0015\t\u0011y\"A\u0002d_6LAAa\t\u0003\u0014\t)Q*\u001a;fe\u0006)\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;feN\u0004\u0013!C6o_^t\u0007j\\:u\u0003)Ygn\\<o\u0011>\u001cH\u000fI\u0001\fk:\\gn\\<o\u0011>\u001cH/\u0001\u0007v].twn\u001e8I_N$\b%A\bok6\fVo\u001c;b'\u0006l\u0007\u000f\\3t\u0003AqW/\\)v_R\f7+Y7qY\u0016\u001c\b%\u0001\frk>$\u0018mV5oI><8+\u001b>f'\u0016\u001cwN\u001c3t\u0003]\tXo\u001c;b/&tGm\\<TSj,7+Z2p]\u0012\u001c\b%\u0001\u0007MSN$XM\\3s\t\u0016\u001c8\rE\u0002\u0002<)\u001aRA\u000bB\u001f\u0005\u0013\u0002\"Ba\u0010\u0003F\u0005\r\u00141OA\u001d\u001b\t\u0011\tEC\u0002\u0003D]\u000bqA];oi&lW-\u0003\u0003\u0003H\t\u0005#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!1\nB)\u001b\t\u0011iEC\u0002\u0003Pu\f!![8\n\t\u0005m#Q\n\u000b\u0003\u0005s!\"!!\f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005e\"1\fB/\u0011\u001d\ty&\fa\u0001\u0003GBq!a\u001c.\u0001\u0004\t\u0019(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r$q\u000e\t\u0006-\n\u0015$\u0011N\u0005\u0004\u0005O:&AB(qi&|g\u000eE\u0004W\u0005W\n\u0019'a\u001d\n\u0007\t5tK\u0001\u0004UkBdWM\r\u0005\n\u0005cr\u0013\u0011!a\u0001\u0003s\t1\u0001\u001f\u00131\u0003\u0019\u0012'o\\6feB\u0013x\u000e]:XSRDG)\u001a4bk2$8i\u001c8oK\u000e$\u0018n\u001c8MS6LGo]\u000b\u0003\u0005o\u0002BA!\u001f\u0003|5\t10C\u0002\u0003~m\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\u0005y\u0007f\u0001\u0019\u0003\u0006B!!q\u0011BG\u001b\t\u0011IIC\u0002\u0003\f&\fQA[;oSRLAAa$\u0003\n\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004c\tU\u0005\u0003\u0002BD\u0005/KAA!'\u0003\n\n)\u0011I\u001a;fe\u00069B/Z:u\r\u0006LGn\u00165f]:{G*[:uK:,'o\u001d\u0015\u0004e\t}\u0005\u0003\u0002BD\u0005CKAAa)\u0003\n\n!A+Z:u\u0003u!Xm\u001d;GC&dG)Z2sK6,g\u000e\u001e$peVs7N\\8x]&\u0003\bfA\u001a\u0003 \u0006yB/Z:u\u001d>\u001cuN\u001c8fGRLwN\u001c'j[&$8OQ=EK\u001a\fW\u000f\u001c;)\u0007Q\u0012y*A\fuKN$X*\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja\"\u001aQGa(\u0002AQ,7\u000f^'bq\n\u0013xn[3s/&$WmQ8o]\u0016\u001cG/[8o\u0019&l\u0017\u000e\u001e\u0015\u0004m\t}\u0015a\b;fgRl\u0015\r\u001f'jgR,g.\u001a:D_:tWm\u0019;j_:d\u0015.\\5ug\"\u001aqGa(\u0002kQ,7\u000f\u001e\"s_.,'oQ8o]\u0016\u001cG/[8o%\u0006$X\rT5nSR<\u0006.\u001a8BGR,\u0018\r\u001c*bi\u0016\u0014U\r\\8x\u0019&l\u0017\u000e\u001e\u0015\u0004q\t}\u0015!\u000e;fgR\u0014%o\\6fe\u000e{gN\\3di&|gNU1uK2KW.\u001b;XQ\u0016t\u0017i\u0019;vC2\u0014\u0016\r^3BE>4X\rT5nSRD3!\u000fBP\u0003]\"Xm\u001d;MSN$XM\\3s\u0007>tg.Z2uS>t'+\u0019;f\u0019&l\u0017\u000e^,iK:\f5\r^;bYJ\u000bG/\u001a\"fY><H*[7ji\"\u001a!Ha(\u0002oQ,7\u000f\u001e'jgR,g.\u001a:D_:tWm\u0019;j_:\u0014\u0016\r^3MS6LGo\u00165f]\u0006\u001bG/^1m%\u0006$X-\u00112pm\u0016d\u0015.\\5uQ\rY$qT\u00011i\u0016\u001cH/T1y\u0019&\u001cH/\u001a8fe\u000e{gN\\3di&|g\u000eT5ti\u0016tWM]'vgR\u0014U-\u00112pm\u0016TVM]8)\u0007q\u0012y*\u0001\u0017uKN$X*\u0019=MSN$XM\\3s\u0007>tg.Z2uS>t'+\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]\"\u001aQHa(\u0002UQ,7\u000f^'bq\n\u0013xn[3s\u0007>tg.Z2uS>t'+\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]\"\u001aaHa(\u0002]Q,7\u000f\u001e(p]\u0012+g-Y;mi\u000e{gN\\3di&|gnQ8v]Rd\u0015.\\5u\u0003:$'+\u0019;f\u0019&l\u0017\u000e\u001e\u0015\u0004\u007f\t}\u0015!F1eI2K7\u000f^3oKJ\u001c\u0018I\u001c3WKJLg-\u001f\u000b\u0006_\nu'Q\u001e\u0005\b\u0005?\u0004\u0005\u0019\u0001Bq\u0003\u0019\u0019wN\u001c4jOB!!1\u001dBu\u001b\t\u0011)OC\u0002\u0003hF\u000baa]3sm\u0016\u0014\u0018\u0002\u0002Bv\u0005K\u00141bS1gW\u0006\u001cuN\u001c4jO\"9\u00111\u0002!A\u0002\u0005=AcB8\u0003r\nM8Q\u0002\u0005\b\u0005?\f\u0005\u0019\u0001Bq\u0011\u001d\u0011)0\u0011a\u0001\u0005o\fa\u0002\\5ti\u0016tWM]\"p]\u001aLw\r\r\u0003\u0003z\u000e\u0005\u0001\u0003\u0003B=\u0005w\fYI!@\n\u0007\u0005-2\u0010\u0005\u0003\u0003\u0000\u000e\u0005A\u0002\u0001\u0003\r\u0007\u0007\u0011\u00190!A\u0001\u0002\u000b\u00051Q\u0001\u0002\u0004?\u0012\n\u0014\u0003BB\u0004\u0003#\u00042AVB\u0005\u0013\r\u0019Ya\u0016\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\tY!\u0011a\u0001\u0003\u001f\tAF^3sS\u001aLhj\u001c\"m_\u000e\\W\r\u001a)fe\u000e,g\u000e\u001e*fG>\u0014H-\u001a3P]\u0006cG\u000eT5ti\u0016tWM]:\u0002qY,'/\u001b4z\u001d>t',\u001a:p\u00052|7m[3e!\u0016\u00148-\u001a8u\u0003:$G\u000b\u001b:piRdW\rV5nK>s\u0017\t\u001c7MSN$XM\\3sg\u00069d/\u001a:jMf|e\u000e\\=O_:Le\u000e^3s\u0005J|7.\u001a:MSN$XM\\3sg\ncwnY6fIB+'oY3oiJ+7m\u001c:eK\u0012\fAE^3sS\u001aL8i\u001c8oK\u000e$\u0018n\u001c8D_VtGo\u00148Fm\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\u000b\u0006_\u000ee11\u0004\u0005\b\u0003\u0017)\u0005\u0019AA\b\u0011\u001d\u0019i\"\u0012a\u0001\u0003\u000f\fq#\u001a=qK\u000e$X\rZ\"p]:,7\r^5p]\u000e{WO\u001c;\u000251L7\u000f^3oKJ\u001cuN\u001c8UQJ|G\u000f\u001e7f\u001b\u0016$(/[2\u0015\t\r\r2\u0011\u0006\t\u0004E\u000e\u0015\u0012bAB\u0014G\nY1*\u00194lC6+GO]5d\u0011\u001d\u0019YC\u0012a\u0001\u0003\u0017\u000b\u0001\u0002\\5ti\u0016tWM]\u0001\u0017Y&\u001cH/\u001a8fe\u000e{gN\u001c*bi\u0016lU\r\u001e:jGR!11EB\u0019\u0011\u001d\u0019Yc\u0012a\u0001\u0003\u0017\u000bAC\u0019:pW\u0016\u00148i\u001c8o%\u0006$X-T3ue&\u001cGCAB\u0012\u0003E\t7mY3qi\u000e{gN\\3di&|gn\u001d\u000b\n_\u000em2QHB!\u0007\u0017Bq!a\u0003J\u0001\u0004\ty\u0001C\u0004\u0004@%\u0003\r!!\u000f\u0002\u00191L7\u000f^3oKJ$Um]2\t\u000f\r\r\u0013\n1\u0001\u0004F\u0005qa.^7D_:tWm\u0019;j_:\u001c\bc\u0001,\u0004H%\u00191\u0011J,\u0003\t1{gn\u001a\u0005\n\u0007\u001bJ\u0005\u0013!a\u0001\u0007\u000b\na\u0002^5nK&sG/\u001a:wC2l5/A\u000ebG\u000e,\u0007\u000f^\"p]:,7\r^5p]N$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007'RCa!\u0012\u0002(\u0006q\u0012mY2faR\u001cuN\u001c8fGRLwN\\:B]\u00124VM]5gsJ\u000bG/\u001a\u000b\u000e_\u000ee31LB/\u0007?\u001a\tg!\u001a\t\u000f\u0005-1\n1\u0001\u0002\u0010!91qH&A\u0002\u0005e\u0002bBB\"\u0017\u0002\u00071Q\t\u0005\b\u0007\u001bZ\u0005\u0019AB#\u0011\u001d\u0019\u0019g\u0013a\u0001\u0003\u000f\fA\"\u001a=qK\u000e$X\r\u001a*bi\u0016Dqaa\u001aL\u0001\u0004\t9-A\u0004faNLGn\u001c8\u0015\u0017=\u001cYg!\u001c\u0004p\rM4Q\u000f\u0005\b\u0003\u0017a\u0005\u0019AA\b\u0011\u001d\ty\u0006\u0014a\u0001\u0003GBqa!\u001dM\u0001\u0004\t\u0019(A\u0004bI\u0012\u0014Xm]:\t\u000f\r\rC\n1\u0001\u0004F!91Q\n'A\u0002\r\u0015\u0013!H1dG\u0016\u0004HoQ8o]\u0016\u001cG/[8og\u0006\u0013wN^3Ja2KW.\u001b;\u0015\u000f=\u001cYh! \u0004\u0000!9\u00111B'A\u0002\u0005=\u0001bBB \u001b\u0002\u0007\u0011\u0011\b\u0005\b\u0007\u0007j\u0005\u0019AB#\u0001")
public class ConnectionQuotasTest {
    private volatile ConnectionQuotasTest$ListenerDesc$ ListenerDesc$module;
    private Metrics metrics;
    private ExecutorService executor;
    private ConnectionQuotas connectionQuotas;
    private final Map<String, ListenerDesc> listeners;
    private final scala.collection.mutable.Map<String, Meter> blockedPercentMeters;
    private final InetAddress knownHost;
    private final InetAddress unknownHost;
    private final int numQuotaSamples;
    private final int quotaWindowSizeSeconds;

    public ConnectionQuotasTest$ListenerDesc$ ListenerDesc() {
        if (this.ListenerDesc$module == null) {
            this.ListenerDesc$lzycompute$1();
        }
        return this.ListenerDesc$module;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private Map<String, ListenerDesc> listeners() {
        return this.listeners;
    }

    private scala.collection.mutable.Map<String, Meter> blockedPercentMeters() {
        return this.blockedPercentMeters;
    }

    private InetAddress knownHost() {
        return this.knownHost;
    }

    private InetAddress unknownHost() {
        return this.unknownHost;
    }

    private int numQuotaSamples() {
        return this.numQuotaSamples;
    }

    private int quotaWindowSizeSeconds() {
        return this.quotaWindowSizeSeconds;
    }

    /*
     * WARNING - void declaration
     */
    public Properties brokerPropsWithDefaultConnectionLimits() {
        void var1_23;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 0, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1,ADMIN://localhost:2");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,ADMIN:PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.NumQuotaSamplesProp(), ((Object)this.numQuotaSamples()).toString());
        props.put(KafkaConfig$.MODULE$.QuotaWindowSizeSecondsProp(), ((Object)this.quotaWindowSizeSeconds()).toString());
        return var1_23;
    }

    @Before
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.listeners().keys().foreach((Function1 & Serializable)name -> {
            String string;
            Object[] objectArray = new Tuple2[1];
            String string2 = string = Processor$.MODULE$.ListenerMetricTag();
            string = null;
            String $minus$greater$extension_$this = string2;
            Object var2_3 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, name);
            return this.blockedPercentMeters().put(name, (Object)KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)KafkaMetricsGroup$.MODULE$, (String)new StringBuilder(14).append((String)name).append("BlockedPercent").toString(), (String)"blocked time", (TimeUnit)TimeUnit.NANOSECONDS, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))));
        });
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), Time.SYSTEM));
        this.executor_$eq(Executors.newFixedThreadPool(this.listeners().size()));
    }

    @After
    public void tearDown() {
        this.executor().shutdownNow();
        if (this.connectionQuotas() != null) {
            this.connectionQuotas().close();
        }
        this.metrics().close();
        TestUtils$.MODULE$.clearYammerMetrics();
        this.blockedPercentMeters().clear();
    }

    @Test
    public void testFailWhenNoListeners() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.connectionQuotas().inc(listener.listenerName(), listener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109))).get(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testFailDecrementForUnknownIp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), this.unknownHost()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }

    @Test
    public void testNoConnectionLimitsByDefault() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        int numConnections = 10000;
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, numConnections, 0L)))).foreach((Function1 & Serializable)x$4 -> x$4.get(10L, TimeUnit.SECONDS));
        Assert.assertTrue((String)"Expected broker-connection-accept-rate metric to get recorded", ((long)BoxesRunTime.unboxToDouble((Object)this.brokerConnRateMetric().metricValue()) > 0L ? 1 : 0) != 0);
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testNoConnectionLimitsByDefault$4(this, numConnections, listener);
            return BoxedUnit.UNIT;
        });
        this.verifyNoBlockedPercentRecordedOnAllListeners();
    }

    @Test
    public void testMaxConnectionsPerIp() {
        int maxConnectionsPerIp = 17;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)maxConnectionsPerIp).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener, maxConnectionsPerIp, 0L)).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)maxConnectionsPerIp, (long)this.connectionQuotas().get(externalListener.defaultIp()));
        this.executor().submit(() -> this.acceptConnectionsAboveIpLimit(this.connectionQuotas(), externalListener, 2L)).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)(maxConnectionsPerIp + 2), (long)this.connectionQuotas().get(externalListener.defaultIp()));
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener.listenerName(), this.knownHost(), maxConnectionsPerIp, 0L)).get(5L, TimeUnit.SECONDS);
        int n = 0;
        int until$extension_end = 4;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ConnectionQuotasTest.$anonfun$testMaxConnectionsPerIp$4(this, externalListener, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var6_7 = null;
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)(maxConnectionsPerIp - 2), (long)this.connectionQuotas().get(externalListener.defaultIp()));
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), externalListener, 2L, 0L)).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)maxConnectionsPerIp, (long)this.connectionQuotas().get(externalListener.defaultIp()));
    }

    @Test
    public void testMaxBrokerWideConnectionLimit() {
        int maxConnections = 800;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)maxConnections).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), maxConnections, 0L)).get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString(), (long)maxConnections, (long)this.connectionQuotas().get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
        Assert.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
        Assert.assertFalse((String)"Total number of connections is exactly the maximum.", (boolean)this.connectionQuotas().maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()));
        Future<?> future = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, 0L));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
        future.get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString(), (long)maxConnections, (long)this.connectionQuotas().get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
        Assert.assertTrue((String)"Expected BlockedPercentMeter metric to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, 0L)).get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected the number of connections to exceed the maximum.", (boolean)this.connectionQuotas().maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()));
        Future<?> future1 = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"ADMIN"), 1L, 0L));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future1.get(1L, TimeUnit.SECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, 0L)).get(5L, TimeUnit.SECONDS);
        int n = 0;
        int until$extension_end = 2;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ConnectionQuotasTest.$anonfun$testMaxBrokerWideConnectionLimit$8(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var7_8 = null;
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future1.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.connectionQuotas().dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
        future1.get(1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxListenerConnectionLimits() {
        void $minus$greater$extension_y;
        int maxConnections = 800;
        int listenerMaxConnections = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)maxConnections).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        Object[] objectArray = new Tuple2[1];
        String string = ((Object)listenerMaxConnections).toString();
        String $minus$greater$extension_$this = KafkaConfig$.MODULE$.MaxConnectionsProp();
        Object var7_6 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$1(this, listenerConfig, listener);
            return BoxedUnit.UNIT;
        });
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, listenerMaxConnections, 0L)))).foreach((Function1 & Serializable)x$7 -> x$7.get(5L, TimeUnit.SECONDS));
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$5(this, listenerMaxConnections, listener);
            return BoxedUnit.UNIT;
        });
        Iterable overLimitFutures = (Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, 1L, 0L)));
        overLimitFutures.foreach((Function1 & Serializable)future -> (TimeoutException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future.get(1L, TimeUnit.SECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296)));
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$10(this, listener);
            return BoxedUnit.UNIT;
        });
        overLimitFutures.foreach((Function1 & Serializable)x$8 -> x$8.get(5L, TimeUnit.SECONDS));
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), listenerMaxConnections);
    }

    @Test
    public void testBrokerConnectionRateLimitWhenActualRateBelowLimit() {
        int brokerRateLimit = 125;
        int connCreateIntervalMs = 25;
        int connectionsPerListener = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)brokerRateLimit).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs)))).foreach((Function1 & Serializable)x$9 -> x$9.get(10L, TimeUnit.SECONDS));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    @Test
    public void testBrokerConnectionRateLimitWhenActualRateAboveLimit() {
        int brokerRateLimit = 90;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)brokerRateLimit).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.addListenersAndVerify(config, this.connectionQuotas());
        int connCreateIntervalMs = 10;
        int connectionsPerListener = 400;
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs)))).foreach((Function1 & Serializable)x$10 -> x$10.get(20L, TimeUnit.SECONDS));
        this.verifyOnlyNonInterBrokerListenersBlockedPercentRecorded();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerConnectionRateLimitWhenActualRateBelowLimit() {
        void $minus$greater$extension_y;
        int brokerRateLimit = 125;
        int listenerRateLimit = 50;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)brokerRateLimit).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        Object[] objectArray = new Tuple2[1];
        String string = ((Object)listenerRateLimit).toString();
        String $minus$greater$extension_$this = KafkaConfig$.MODULE$.MaxConnectionCreationRateProp();
        Object var8_7 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        int connectionsPerListener = 200;
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs)))).foreach((Function1 & Serializable)x$11 -> x$11.get(10L, TimeUnit.SECONDS));
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListenerConnectionRateLimitWhenActualRateAboveLimit() {
        void $minus$greater$extension_y;
        int brokerRateLimit = 125;
        int listenerRateLimit = 30;
        int connCreateIntervalMs = 25;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)brokerRateLimit).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        Object[] objectArray = new Tuple2[1];
        String string = ((Object)listenerRateLimit).toString();
        String $minus$greater$extension_$this = KafkaConfig$.MODULE$.MaxConnectionCreationRateProp();
        Object var8_7 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        this.addListenersAndVerify(config, listenerConfig, this.connectionQuotas());
        int connectionsPerListener = 600;
        ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)listener, connectionsPerListener, connCreateIntervalMs, listenerRateLimit, 7)))).foreach((Function1 & Serializable)x$12 -> x$12.get(30L, TimeUnit.SECONDS));
        this.verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners();
        this.verifyConnectionCountOnEveryListener(this.connectionQuotas(), connectionsPerListener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxListenerConnectionListenerMustBeAboveZero() {
        void $minus$greater$extension_y;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        int maxListenerConnectionRate = 0;
        Object[] objectArray = new Tuple2[1];
        String string = ((Object)maxListenerConnectionRate).toString();
        String $minus$greater$extension_$this = KafkaConfig$.MODULE$.MaxConnectionCreationRateProp();
        Object var4_4 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).validateReconfiguration(listenerConfig), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxListenerConnectionRateReconfiguration() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        int listenerRateLimit = 20;
        Object[] objectArray = new Tuple2[1];
        String string = ((Object)listenerRateLimit).toString();
        String $minus$greater$extension_$this = KafkaConfig$.MODULE$.MaxConnectionCreationRateProp();
        Object var7_4 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        java.util.Map listenerConfig = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).configure(listenerConfig);
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).reconfigure(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.empty())).asJava());
        this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1000L, 0L)).get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"BlockedPercentMeter metric for EXTERNAL listener", (long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
        int newMaxListenerConnectionRate = 10;
        Object[] objectArray2 = new Tuple2[1];
        String string2 = ((Object)newMaxListenerConnectionRate).toString();
        String $minus$greater$extension_$this2 = KafkaConfig$.MODULE$.MaxConnectionCreationRateProp();
        Object var9_8 = null;
        string2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        java.util.Map newListenerConfig = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)))).asJava();
        ((ConnectionQuotas.ListenerConnectionQuota)this.connectionQuotas().maxConnectionsPerListener().apply((Object)((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName())).reconfigure(newListenerConfig);
        int connectionsPerListener = 200;
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), connectionsPerListener, 5L, newMaxListenerConnectionRate, 3)).get(30L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMaxBrokerConnectionRateReconfiguration() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.addListenersAndVerify(config, this.connectionQuotas());
        int maxBrokerConnectionRate = 50;
        this.connectionQuotas().updateBrokerMaxConnectionRate(maxBrokerConnectionRate);
        int totalConnections = 400;
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), totalConnections, 5L, maxBrokerConnectionRate, 20)).get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testNonDefaultConnectionCountLimitAndRateLimit() {
        int brokerRateLimit = 25;
        int maxConnections = 350;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)maxConnections).toString());
        props.put(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), ((Object)brokerRateLimit).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        this.connectionQuotas_$eq(new ConnectionQuotas(config, Time.SYSTEM, this.metrics()));
        this.connectionQuotas().addListener(config, ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName());
        this.addListenersAndVerify(config, this.connectionQuotas());
        ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
        this.executor().submit(() -> this.acceptConnectionsAndVerifyRate(this.connectionQuotas(), listener, maxConnections, 10L, brokerRateLimit, 8)).get(20L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Expected BlockedPercentMeter metric for EXTERNAL listener to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Number of connections on EXTERNAL listener:", (long)maxConnections, (long)this.connectionQuotas().get(listener.defaultIp()));
        Future<?> future = this.executor().submit(() -> this.acceptConnections(this.connectionQuotas(), (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, 0L));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
        future.get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Number of connections on EXTERNAL listener:", (long)maxConnections, (long)this.connectionQuotas().get(listener.defaultIp()));
    }

    private void addListenersAndVerify(KafkaConfig config, ConnectionQuotas connectionQuotas) {
        this.addListenersAndVerify(config, AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.empty())).asJava(), connectionQuotas);
    }

    private void addListenersAndVerify(KafkaConfig config, java.util.Map<String, ?> listenerConfig, ConnectionQuotas connectionQuotas) {
        Assert.assertNotNull((String)"Expected broker-connection-accept-rate metric to exist", (Object)this.brokerConnRateMetric());
        this.listeners().foreach((Function1 & Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$addListenersAndVerify$1(this, connectionQuotas, config, listenerConfig, x0$1);
            return BoxedUnit.UNIT;
        });
        this.verifyNoBlockedPercentRecordedOnAllListeners();
        Assert.assertEquals((String)"Broker-wide connection acceptance rate metric", (long)0L, (long)((long)BoxesRunTime.unboxToDouble((Object)this.brokerConnRateMetric().metricValue())));
    }

    private void verifyNoBlockedPercentRecordedOnAllListeners() {
        this.blockedPercentMeters().foreach((Function1 & Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$verifyNoBlockedPercentRecordedOnAllListeners$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners() {
        this.blockedPercentMeters().foreach((Function1 & Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$2(this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyOnlyNonInterBrokerListenersBlockedPercentRecorded() {
        this.blockedPercentMeters().foreach((Function1 & Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$verifyOnlyNonInterBrokerListenersBlockedPercentRecorded$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyConnectionCountOnEveryListener(ConnectionQuotas connectionQuotas, int expectedConnectionCount) {
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$verifyConnectionCountOnEveryListener$1(expectedConnectionCount, connectionQuotas, listener);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaMetric listenerConnThrottleMetric(String listener) {
        MetricName metricName = this.metrics().metricName("connection-accept-throttle-time", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric listenerConnRateMetric(String listener) {
        MetricName metricName = this.metrics().metricName("connection-accept-rate", SocketServer$.MODULE$.MetricsGroup(), Collections.singletonMap(Processor$.MODULE$.ListenerMetricTag(), listener));
        return this.metrics().metric(metricName);
    }

    private KafkaMetric brokerConnRateMetric() {
        MetricName metricName = this.metrics().metricName("broker-connection-accept-rate", SocketServer$.MODULE$.MetricsGroup());
        return this.metrics().metric(metricName);
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs) {
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs);
    }

    private void acceptConnectionsAndVerifyRate(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs, int expectedRate, int epsilon) {
        long startTimeMs = System.currentTimeMillis();
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs);
        long elapsedSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimeMs);
        int actualRate = (int)((double)numConnections / (double)elapsedSeconds);
        Assert.assertTrue((String)new StringBuilder(52).append("Expected rate (").append(expectedRate).append(" +- ").append(epsilon).append("), but got ").append(actualRate).append(" (").append(numConnections).append(" connections / ").append(elapsedSeconds).append(" sec)").toString(), (actualRate <= expectedRate + epsilon && actualRate >= expectedRate - epsilon ? 1 : 0) != 0);
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerName listenerName, InetAddress address, long numConnections, long timeIntervalMs) {
        LongRef longRef;
        long create_e = System.currentTimeMillis() + timeIntervalMs;
        LongRef longRef2 = longRef = new LongRef(create_e);
        longRef = null;
        LongRef nextSendTime = longRef2;
        IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)numConnections).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$13 -> {
            connectionQuotas.inc(listenerName, address, (Meter)this.blockedPercentMeters().apply((Object)listenerName.value()));
            long l = Math.max(nextSendTime$1.elem - System.currentTimeMillis(), 0L);
            if (l > 0L) {
                Utils.sleep((long)l);
            }
            nextSendTime$1.elem += timeIntervalMs;
        });
    }

    private long acceptConnections$default$4() {
        return 0L;
    }

    private void acceptConnectionsAboveIpLimit(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections) {
        ListenerName listenerName = listenerDesc.listenerName();
        IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)numConnections).foreach((Function1 & Serializable)i -> ConnectionQuotasTest.$anonfun$acceptConnectionsAboveIpLimit$1(this, connectionQuotas, listenerName, listenerDesc, BoxesRunTime.unboxToLong((Object)i)));
    }

    private final void ListenerDesc$lzycompute$1() {
        synchronized (this) {
            if (this.ListenerDesc$module == null) {
                this.ListenerDesc$module = new ConnectionQuotasTest$ListenerDesc$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testNoConnectionLimitsByDefault$4(ConnectionQuotasTest $this, int numConnections$1, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)numConnections$1, (long)$this.connectionQuotas().get(listener.defaultIp()));
        Assert.assertTrue((String)new StringBuilder(68).append("Expected connection-accept-rate metric to get recorded for listener ").append(listener).toString(), ((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnRateMetric(listener.listenerName().value()).metricValue()) > 0L ? 1 : 0) != 0);
        $this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)(numConnections$1 - 1), (long)$this.connectionQuotas().get(listener.defaultIp()));
    }

    public static final /* synthetic */ void $anonfun$testMaxConnectionsPerIp$4(ConnectionQuotasTest $this, ListenerDesc externalListener$1, int x$5) {
        $this.connectionQuotas().dec(externalListener$1.listenerName(), externalListener$1.defaultIp());
    }

    public static final /* synthetic */ void $anonfun$testMaxBrokerWideConnectionLimit$8(ConnectionQuotasTest $this, int x$6) {
        $this.connectionQuotas().dec(((ListenerDesc)$this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)$this.listeners().apply((Object)"EXTERNAL")).defaultIp());
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$1(ConnectionQuotasTest $this, java.util.Map listenerConfig$1, ListenerDesc listener) {
        ((ConnectionQuotas.ListenerConnectionQuota)$this.connectionQuotas().maxConnectionsPerListener().apply((Object)listener.listenerName())).configure(listenerConfig$1);
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$5(ConnectionQuotasTest $this, int listenerMaxConnections$1, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)listenerMaxConnections$1, (long)$this.connectionQuotas().get(listener.defaultIp()));
        Assert.assertFalse((String)new StringBuilder(62).append("Total number of connections on ").append(listener).append(" should be exactly the maximum.").toString(), (boolean)$this.connectionQuotas().maxConnectionsExceeded(listener.listenerName()));
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$10(ConnectionQuotasTest $this, ListenerDesc listener) {
        $this.connectionQuotas().dec(listener.listenerName(), listener.defaultIp());
    }

    public static final /* synthetic */ void $anonfun$addListenersAndVerify$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$1, KafkaConfig config$1, java.util.Map listenerConfig$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            ListenerDesc listener = (ListenerDesc)x0$1._2();
            ListenerName listenerName = listener.listenerName();
            connectionQuotas$1.addListener(config$1, listenerName);
            ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas$1.maxConnectionsPerListener().apply((Object)listenerName)).configure(listenerConfig$3);
            Assert.assertFalse((String)new StringBuilder(72).append("Should not exceed max connection limit on ").append(name).append(" listener after initialization").toString(), (boolean)connectionQuotas$1.maxConnectionsExceeded(listenerName));
            Assert.assertEquals((String)new StringBuilder(35).append("Number of connections on ").append(listener).append(" listener:").toString(), (long)0L, (long)connectionQuotas$1.get(listener.defaultIp()));
            Assert.assertNotNull((String)new StringBuilder(61).append("Expected connection-accept-rate metric to exist for listener ").append(listenerName.value()).toString(), (Object)$this.listenerConnRateMetric(listenerName.value()));
            Assert.assertEquals((String)new StringBuilder(47).append("Connection acceptance rate metric for listener ").append(listenerName.value()).toString(), (long)0L, (long)((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnRateMetric(listenerName.value()).metricValue())));
            Assert.assertNotNull((String)new StringBuilder(70).append("Expected connection-accept-throttle-time metric to exist for listener ").append(listenerName.value()).toString(), (Object)$this.listenerConnThrottleMetric(listenerName.value()));
            Assert.assertEquals((String)new StringBuilder(40).append("Connection throttle metric for listener ").append(listenerName.value()).toString(), (long)0L, (long)((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnThrottleMetric(listenerName.value()).metricValue())));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyNoBlockedPercentRecordedOnAllListeners$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Meter meter = (Meter)x0$1._2();
            Assert.assertEquals((String)new StringBuilder(40).append("BlockedPercentMeter metric for ").append(name).append(" listener").toString(), (long)0L, (long)meter.count());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            Meter meter = (Meter)x0$1._2();
            Assert.assertTrue((String)new StringBuilder(64).append("Expected BlockedPercentMeter metric for ").append(name).append(" listener to be recorded").toString(), (meter.count() > 0L ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyNonZeroBlockedPercentAndThrottleTimeOnAllListeners$2(ConnectionQuotasTest $this, ListenerDesc listener) {
        Assert.assertTrue((String)new StringBuilder(40).append("Connection throttle metric for listener ").append(listener.listenerName().value()).toString(), ((long)BoxesRunTime.unboxToDouble((Object)$this.listenerConnThrottleMetric(listener.listenerName().value()).metricValue()) > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$verifyOnlyNonInterBrokerListenersBlockedPercentRecorded$1(Tuple2 x0$1) {
        block4: {
            Meter meter;
            String name;
            block5: {
                if (x0$1 == null) break block4;
                name = (String)x0$1._1();
                meter = (Meter)x0$1._2();
                switch (name == null ? 0 : name.hashCode()) {
                    case 1090493356: {
                        if ("REPLICATION".equals(name)) {
                            break;
                        }
                        break block5;
                    }
                    default: {
                        break block5;
                    }
                }
                Assert.assertEquals((String)new StringBuilder(40).append("BlockedPercentMeter metric for ").append(name).append(" listener").toString(), (long)0L, (long)meter.count());
                return;
            }
            Assert.assertTrue((String)new StringBuilder(64).append("Expected BlockedPercentMeter metric for ").append(name).append(" listener to be recorded").toString(), (meter.count() > 0L ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConnectionCountOnEveryListener$1(int expectedConnectionCount$1, ConnectionQuotas connectionQuotas$2, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)expectedConnectionCount$1, (long)connectionQuotas$2.get(listener.defaultIp()));
    }

    public static final /* synthetic */ TooManyConnectionsException $anonfun$acceptConnectionsAboveIpLimit$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$4, ListenerName listenerName$2, ListenerDesc listenerDesc$1, long i) {
        return (TooManyConnectionsException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> connectionQuotas$4.inc(listenerName$2, listenerDesc$1.defaultIp(), (Meter)$this.blockedPercentMeters().apply((Object)listenerName$2.value())), ClassTag$.MODULE$.apply(TooManyConnectionsException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionQuotasTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        Object[] objectArray = new Tuple2[3];
        ListenerDesc $minus$greater$extension_y3 = new ListenerDesc(this, new ListenerName("EXTERNAL"), InetAddress.getByName("192.168.1.1"));
        String $minus$greater$extension_$this = "EXTERNAL";
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        ListenerDesc listenerDesc = new ListenerDesc(this, new ListenerName("ADMIN"), InetAddress.getByName("192.168.1.2"));
        String $minus$greater$extension_$this2 = "ADMIN";
        Object var3_4 = null;
        listenerDesc = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ListenerDesc listenerDesc2 = new ListenerDesc(this, new ListenerName("REPLICATION"), InetAddress.getByName("192.168.1.3"));
        String $minus$greater$extension_$this3 = "REPLICATION";
        Object var5_6 = null;
        listenerDesc2 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        this.listeners = (Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.blockedPercentMeters = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.knownHost = InetAddress.getByName("192.168.10.0");
        this.unknownHost = InetAddress.getByName("192.168.2.0");
        this.numQuotaSamples = 2;
        this.quotaWindowSizeSeconds = 1;
    }

    public class ListenerDesc
    implements Product,
    Serializable {
        private final ListenerName listenerName;
        private final InetAddress defaultIp;
        public final /* synthetic */ ConnectionQuotasTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public InetAddress defaultIp() {
            return this.defaultIp;
        }

        public String toString() {
            return new StringBuilder(20).append("(listener=").append(this.listenerName().value()).append(", client=").append(this.defaultIp().getHostAddress()).append(")").toString();
        }

        public ListenerDesc copy(ListenerName listenerName, InetAddress defaultIp) {
            return new ListenerDesc(this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer(), listenerName, defaultIp);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public InetAddress copy$default$2() {
            return this.defaultIp();
        }

        public String productPrefix() {
            return "ListenerDesc";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.listenerName();
                }
                case 1: {
                    return this.defaultIp();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ListenerDesc;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "listenerName";
                }
                case 1: {
                    return "defaultIp";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -889275714, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ListenerDesc)) return false;
            if (((ListenerDesc)x$1).kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() != this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ListenerDesc listenerDesc = (ListenerDesc)x$1;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = listenerDesc.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            InetAddress inetAddress = this.defaultIp();
            InetAddress inetAddress2 = listenerDesc.defaultIp();
            if (inetAddress == null) {
                if (inetAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetAddress).equals(inetAddress2)) return false;
            if (!listenerDesc.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ConnectionQuotasTest kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() {
            return this.$outer;
        }

        public ListenerDesc(ConnectionQuotasTest $outer, ListenerName listenerName, InetAddress defaultIp) {
            this.listenerName = listenerName;
            this.defaultIp = defaultIp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

