/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u0004:\u0001\u0001\u0006I\u0001\r\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001b\u0001\n\u0003!\u0005BB)\u0001A\u0003%Q\tC\u0004S\u0001\t\u0007I\u0011A*\t\re\u0003\u0001\u0015!\u0003U\u0011\u001dQ\u0006A1A\u0005\u0002mCa\u0001\u0019\u0001!\u0002\u0013a\u0006bB1\u0001\u0005\u0004%\ta\u0017\u0005\u0007E\u0002\u0001\u000b\u0011\u0002/\t\u000f\r\u0004!\u0019!C\u0001I\"9\u0011q\u0001\u0001!\u0002\u0013)\u0007bCA\u0005\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0017A1\"a\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0016!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0007\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\u000e\u0001\t\u0003\t)\u0003C\u0004\u0002:\u0001!\t!!\n\t\u000f\u0005u\u0002\u0001\"\u0001\u0002&!9\u0011\u0011\t\u0001\u0005\u0002\u0005\u0015\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\n\u0003O\u0002\u0011\u0013!C\u0001\u0003SB\u0011\"a \u0001#\u0003%\t!!!\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002&!9\u0011q\u0012\u0001\u0005\u0002\u0005E%\u0001\u0007*fa2L7-Y'b]\u0006<WM])v_R\f7\u000fV3ti*\u0011q\u0004I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0017\u0011\u00055\u0002Q\"\u0001\u0010\u0002\u000f\r|gNZ5hgV\t\u0001\u0007E\u00022iYj\u0011A\r\u0006\u0003g\u0019\n!bY8mY\u0016\u001cG/[8o\u0013\t)$GA\u0002TKF\u0004\"!L\u001c\n\u0005ar\"aC&bM.\f7i\u001c8gS\u001e\f\u0001bY8oM&<7\u000fI\u0001\u0005i&lW-F\u0001=!\ti\u0004)D\u0001?\u0015\ty\u0004%A\u0003vi&d7/\u0003\u0002B}\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003\u0015\u0003\"AR(\u000e\u0003\u001dS!a\u0011%\u000b\u0005%S\u0015AB2p[6|gN\u0003\u0002\"\u0017*\u0011A*T\u0001\u0007CB\f7\r[3\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001vIA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\naA]3d_J$W#\u0001+\u0011\u0005U;V\"\u0001,\u000b\u0005IC\u0015B\u0001-W\u00051\u0019\u0016.\u001c9mKJ+7m\u001c:e\u0003\u001d\u0011XmY8sI\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.M\u000b\u00029B\u0011QLX\u0007\u0002\u0011&\u0011q\f\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004%A\bu_BL7\rU1si&$\u0018n\u001c83\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004%A\u0005gKR\u001c\u0007.\u00138g_V\tQ\rE\u0002gS*l\u0011a\u001a\u0006\u0003QJ\n\u0011\"[7nkR\f'\r\\3\n\u0005U:\u0007\u0003B\u0013l96L!\u0001\u001c\u0014\u0003\rQ+\b\u000f\\33!\rq\u0017\u0011\u0001\b\u0003_vt!\u0001]>\u000f\u0005EThB\u0001:z\u001d\t\u0019\bP\u0004\u0002uo6\tQO\u0003\u0002wE\u00051AH]8pizJ\u0011AT\u0005\u0003\u00196K!!I&\n\u0005%S\u0015B\u0001?I\u0003!\u0011X-];fgR\u001c\u0018B\u0001@\u0000\u000311U\r^2i%\u0016\fX/Z:u\u0015\ta\b*\u0003\u0003\u0002\u0004\u0005\u0015!!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0002\u007f\u007f\u0006Qa-\u001a;dQ&sgm\u001c\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011Q\u0002\t\u0004[\u0005=\u0011bAA\t=\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$B!a\u0006\u0002\u001eA\u0019Q%!\u0007\n\u0007\u0005maE\u0001\u0003V]&$\b\"CA\u0010#\u0005\u0005\t\u0019AA\u0007\u0003\rAH%M\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005Q3\u000f[8vY\u0012,\u0005p\u00197vI\u0016\u001cVOY:fcV,g\u000e\u001e+ie>$H\u000f\\3e!\u0006\u0014H/\u001b;j_:\u001cHCAA\fQ\r\u0019\u0012\u0011\u0006\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF'\u0002\u000b),h.\u001b;\n\t\u0005M\u0012Q\u0006\u0002\u0005)\u0016\u001cH/A\u001dtQ>,H\u000eZ$fi:{W*Z:tC\u001e,7/\u00134Rk>$\u0018m]#yG\u0016,G-\u001a3P]N+(m]3rk\u0016tG\u000fU1si&$\u0018n\u001c8tQ\r!\u0012\u0011F\u0001#g\"|W\u000f\u001c3HKR\u0014u\u000e\u001e5NKN\u001c\u0018mZ3t\u0013\u001a\fVo\u001c;bg\u0006cGn\\<)\u0007U\tI#\u0001\u0013tQ>,H\u000eZ%oG2,H-Z%o'ft7\r\u00165s_R$H.\u001a3SKBd\u0017nY1tQ\r1\u0012\u0011F\u00010i\u0016\u001cHoQ8na2,G/Z%o\t\u0016d\u0017-_3e\r\u0016$8\r[,ji\"\u0014V\r\u001d7jG\u0006$\u0006N]8ui2Lgn\u001a\u0015\u0004/\u0005%\u0012AC:fiV\u0003Xj\\2lgRA\u0011qCA%\u00037\ni\u0006\u0003\u0004d1\u0001\u0007\u00111\n\t\u0006\u0003\u001b\n9F\u001b\b\u0005\u0003\u001f\n\u0019FD\u0002u\u0003#J\u0011aJ\u0005\u0004\u0003+2\u0013a\u00029bG.\fw-Z\u0005\u0004k\u0005e#bAA+M!9!\u000b\u0007I\u0001\u0002\u0004!\u0006\"CA01A\u0005\t\u0019AA1\u0003I\u0011w\u000e\u001e5SKBd\u0017nY1t\u0013:\u001c\u0016P\\2\u0011\u0007\u0015\n\u0019'C\u0002\u0002f\u0019\u0012qAQ8pY\u0016\fg.\u0001\u000btKR,\u0006/T8dWN$C-\u001a4bk2$HEM\u000b\u0003\u0003WR3\u0001VA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F:fiV\u0003Xj\\2lg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0004*\"\u0011\u0011MA7\u0003!!X-\u0019:E_^t\u0007fA\u000e\u0002\nB!\u00111FAF\u0013\u0011\ti)!\f\u0003\u000b\u00053G/\u001a:\u0002\u00135|7m[)v_R\fG\u0003BAJ\u00033\u00032!LAK\u0013\r\t9J\b\u0002\r%\u0016\u0004H.[2b#V|G/\u0019\u0005\b\u00037c\u0002\u0019AAO\u0003\u0015\u0011w.\u001e8e!\r)\u0013qT\u0005\u0004\u0003C3#\u0001\u0002'p]\u001e\u0004")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)x$1 -> {
        Properties fromProps_overrides = new Properties();
        return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
    });
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final scala.collection.immutable.Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public scala.collection.immutable.Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)quota.isQuotaExceeded()).andReturn((Object)false).once();
        EasyMock.expect((Object)quota.isQuotaExceeded()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$3))).get())._2()).info().records().batches()).asScala().size());
        Assert.assertEquals((String)"But we shouldn't get the second", (long)0L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$4))).get())._2()).info().records().batches()).asScala().size());
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)quota.isQuotaExceeded()).andReturn((Object)true).once();
        EasyMock.expect((Object)quota.isQuotaExceeded()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$5))).get())._2()).info().records().batches()).asScala().size());
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$6))).get())._2()).info().records().batches()).asScala().size());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)quota.isQuotaExceeded()).andReturn((Object)false).once();
        EasyMock.expect((Object)quota.isQuotaExceeded()).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$7))).get())._2()).info().records().batches()).asScala().size());
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$8))).get())._2()).info().records().batches()).asScala().size());
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        scala.collection.immutable.Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> x$1 = this.fetchInfo();
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, true);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)quota.isQuotaExceeded()).andReturn((Object)false).once();
        EasyMock.expect((Object)quota.isQuotaExceeded()).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$9))).get())._2()).info().records().batches()).asScala().size());
        Assert.assertEquals((String)"But we should get the second too since it's throttled but in sync", (long)1L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$10))).get())._2()).info().records().batches()).asScala().size());
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assert.assertTrue((String)"In sync replica should complete", (boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete());
        Assert.assertFalse((String)"Out of sync replica should not complete", (boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete());
    }

    /*
     * WARNING - void declaration
     */
    public void setUpMocks(scala.collection.immutable.Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        void withRecords_records;
        void withRecords_timestampType;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        EasyMock.expect((Object)log.logStartOffset()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)log.logEndOffset()).andReturn((Object)20L).anyTimes();
        EasyMock.expect((Object)log.highWatermark()).andReturn((Object)5L).anyTimes();
        EasyMock.expect((Object)log.lastStableOffset()).andReturn((Object)5L).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition())).anyTimes();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{record};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var10_8 = null;
        simpleRecordArray = null;
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), false, (Option)None$.MODULE$)).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$)).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])new File[0])).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        AlterIsrManager alterIsrManager = (AlterIsrManager)EasyMock.createMock(AlterIsrManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        Seq seq = ((KafkaConfig)this.configs().head()).logDirs();
        if (seq == null) {
            throw null;
        }
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), zkClient, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(leaderBrokerId), new LogDirFailureChannel(seq.length()), alterIsrManager, (Option)None$.MODULE$));
        fetchInfo.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$11 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$11);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @After
    public void tearDown() {
        if (this.replicaManager() != null) {
            this.replicaManager().shutdown(false);
        }
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)quota.isThrottled((TopicPartition)EasyMock.anyObject())).andReturn((Object)true).anyTimes();
        return var3_2;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$10) {
        Object object = x$10._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getPartitionOrException((TopicPartition)EasyMock.anyObject())).andReturn((Object)partition).anyTimes();
        EasyMock.expect((Object)replicaManager.shouldLeaderThrottle((ReplicaQuota)EasyMock.anyObject(), (Partition)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject()))).andReturn((Object)(!isReplicaInSync ? 1 : 0)).anyTimes();
        EasyMock.expect((Object)partition.getReplica(1)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{replicaManager, partition});
        TopicPartition tp = new TopicPartition("t1", 0);
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(50L, 0L, 1, Optional.empty()));
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, (Seq)new .colon.colon((Object)new Tuple2((Object)tp, (Object)fetchPartitionStatus), (List)Nil$.MODULE$));
        return new DelayedFetch(null, fetchMetadata, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, Log log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$11) {
        if (x$11 != null) {
            Set set;
            TopicPartition p = (TopicPartition)x$11._1();
            Partition partition = $this.replicaManager().createPartition(p);
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)leaderBrokerId$1));
            partition.setLog(log$1, false);
            Seq seq = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()}));
            if (bothReplicasInSync$1) {
                void apply_elems;
                Set$ set$ = Predef$.MODULE$.Set();
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()});
                if (set$ == null) {
                    throw null;
                }
                arraySeq = null;
                set = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
            } else {
                void apply_elems;
                Set$ set$ = Predef$.MODULE$.Set();
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1});
                if (set$ == null) {
                    throw null;
                }
                arraySeq = null;
                set = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
            }
            partition.updateAssignmentAndIsr(seq, set, (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaManagerQuotasTest() {
        void $minus$greater$extension_y;
        FetchRequest.PartitionData $minus$greater$extension_y2 = new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty());
        TopicPartition $minus$greater$extension_$this = this.topicPartition1();
        Object var1_2 = null;
        Object var2_1 = null;
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty());
        TopicPartition $minus$greater$extension_$this2 = this.topicPartition2();
        Object var3_4 = null;
        partitionData = null;
        this.fetchInfo = new .colon.colon((Object)new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2), (List)new .colon.colon((Object)new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y), (List)Nil$.MODULE$));
    }
}

