/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.Constants$;
import kafka.server.QuotaType;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.SensorAccess;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001B\u0010!\u0001\u0015B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001BC\u0002\u0013%Q\b\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003?\u0011!Y\u0005A!b\u0001\n\u0013a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011E\u0003!Q1A\u0005\nIC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u00063\u0002!\tA\u0017\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019q\u0007\u0001)A\u0005E\"9q\u000e\u0001b\u0001\n\u0013\u0001\bbBA\n\u0001\u0001\u0006I!\u001d\u0005\n\u0003+\u0001\u0001\u0019!C\u0005\u0003/A\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u0011\u00055\u0002\u0001)Q\u0005\u00033A\u0011\"a\f\u0001\u0005\u0004%I!!\r\t\u0011\u0005e\u0002\u0001)A\u0005\u0003gA\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003\u007fAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002P\u0001!\t%!\u0015\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003k\u0002A\u0011AAA\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!a#\u0001\t\u0003\ti\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\n9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0006\u0003C\t\naa]3sm\u0016\u0014(\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\n\u00173!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011Q\u0006M\u0007\u0002])\u0011qFI\u0001\u0006kRLGn]\u0005\u0003c9\u0012q\u0001T8hO&tw\r\u0005\u00024i5\t\u0001%\u0003\u00026A\ta!+\u001a9mS\u000e\f\u0017+^8uC\u000611m\u001c8gS\u001e,\u0012\u0001\u000f\t\u0003geJ!A\u000f\u0011\u0003;I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fqaY8oM&<\u0007%A\u0004nKR\u0014\u0018nY:\u0016\u0003y\u0002\"a\u0010%\u000e\u0003\u0001S!\u0001P!\u000b\u0005\t\u001b\u0015AB2p[6|gN\u0003\u0002$\t*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0013\tI\u0005IA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nqB]3qY&\u001c\u0017\r^5p]RK\b/Z\u000b\u0002\u001bB\u00111GT\u0005\u0003\u001f\u0002\u0012\u0011\"U;pi\u0006$\u0016\u0010]3\u0002!I,\u0007\u000f\\5dCRLwN\u001c+za\u0016\u0004\u0013\u0001\u0002;j[\u0016,\u0012a\u0015\t\u0003)Zk\u0011!\u0016\u0006\u0003_\u0005K!aV+\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bmcVLX0\u0011\u0005M\u0002\u0001\"\u0002\u001c\n\u0001\u0004A\u0004\"\u0002\u001f\n\u0001\u0004q\u0004\"B&\n\u0001\u0004i\u0005\"B)\n\u0001\u0004\u0019\u0016\u0001\u00027pG.,\u0012A\u0019\t\u0003G2l\u0011\u0001\u001a\u0006\u0003K\u001a\fQ\u0001\\8dWNT!a\u001a5\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002jU\u0006!Q\u000f^5m\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c3\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\fQ\u0001\\8dW\u0002\n1\u0003\u001e5s_R$H.\u001a3QCJ$\u0018\u000e^5p]N,\u0012!\u001d\t\u0006eN,\u0018\u0011A\u0007\u0002M&\u0011AO\u001a\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001<~\u001d\t98\u0010\u0005\u0002yQ5\t\u0011P\u0003\u0002{I\u00051AH]8pizJ!\u0001 \u0015\u0002\rA\u0013X\rZ3g\u0013\tqxP\u0001\u0004TiJLgn\u001a\u0006\u0003y\"\u0002b!a\u0001\u0002\n\u00055QBAA\u0003\u0015\r\t9\u0001K\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0006\u0003\u000b\u00111aU3r!\r9\u0013qB\u0005\u0004\u0003#A#aA%oi\u0006!B\u000f\u001b:piRdW\r\u001a)beRLG/[8og\u0002\nQ!];pi\u0006,\"!!\u0007\u0011\u0007}\nY\"C\u0002\u0002\u001e\u0001\u0013Q!U;pi\u0006\f\u0011\"];pi\u0006|F%Z9\u0015\t\u0005\r\u0012\u0011\u0006\t\u0004O\u0005\u0015\u0012bAA\u0014Q\t!QK\\5u\u0011%\tYcDA\u0001\u0002\u0004\tI\"A\u0002yIE\na!];pi\u0006\u0004\u0013\u0001D:f]N|'/Q2dKN\u001cXCAA\u001a!\r\u0019\u0014QG\u0005\u0004\u0003o\u0001#\u0001D*f]N|'/Q2dKN\u001c\u0018!D:f]N|'/Q2dKN\u001c\b%\u0001\bsCR,W*\u001a;sS\u000et\u0015-\\3\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u0007j\u0011!Q\u0005\u0004\u0003\u000b\n%AC'fiJL7MT1nK\u0006y!/\u0019;f\u001b\u0016$(/[2OC6,\u0007%A\u0006va\u0012\fG/Z)v_R\fG\u0003BA\u0012\u0003\u001bBq!!\u0006\u0016\u0001\u0004\tI\"A\bjgF+x\u000e^1Fq\u000e,W\rZ3e+\t\t\u0019\u0006E\u0002(\u0003+J1!a\u0016)\u0005\u001d\u0011un\u001c7fC:\f1\"[:UQJ|G\u000f\u001e7fIR!\u00111KA/\u0011\u001d\tyf\u0006a\u0001\u0003C\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002B\u0005\r\u0014bAA3\u0003\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u0002:fG>\u0014H\r\u0006\u0003\u0002$\u0005-\u0004bBA71\u0001\u0007\u0011qN\u0001\u0006m\u0006dW/\u001a\t\u0004O\u0005E\u0014bAA:Q\t!Aj\u001c8h\u00035i\u0017M]6UQJ|G\u000f\u001e7fIR1\u00111EA=\u0003{Ba!a\u001f\u001a\u0001\u0004)\u0018!\u0002;pa&\u001c\u0007bBA@3\u0001\u0007\u0011\u0011A\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001cH\u0003BA\u0012\u0003\u0007Ca!a\u001f\u001b\u0001\u0004)\u0018A\u0004:f[>4X\r\u00165s_R$H.\u001a\u000b\u0005\u0003G\tI\t\u0003\u0004\u0002|m\u0001\r!^\u0001\u000bkB\u0004XM\u001d\"pk:$WCAA8\u0003Q9W\r^)v_R\fW*\u001a;sS\u000e\u001cuN\u001c4jOR!\u00111SAM!\ry\u0014QS\u0005\u0004\u0003/\u0003%\u0001D'fiJL7mQ8oM&<\u0007bBA\u000b;\u0001\u0007\u0011\u0011D\u0001\u0007g\u0016t7o\u001c:\u0015\u0005\u0005}\u0005cA \u0002\"&\u0019\u00111\u0015!\u0003\rM+gn]8s\u0001")
public class ReplicationQuotaManager
implements Logging,
ReplicaQuota {
    private final ReplicationQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType replicationType;
    private final Time time;
    private final ReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, Seq<Object>> throttledPartitions;
    private Quota quota;
    private final SensorAccess sensorAccess;
    private final MetricName rateMetricName;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private QuotaType replicationType() {
        return this.replicationType;
    }

    private Time time() {
        return this.time;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ConcurrentHashMap<String, Seq<Object>> throttledPartitions() {
        return this.throttledPartitions;
    }

    private Quota quota() {
        return this.quota;
    }

    private void quota_$eq(Quota x$1) {
        this.quota = x$1;
    }

    private SensorAccess sensorAccess() {
        return this.sensorAccess;
    }

    private MetricName rateMetricName() {
        return this.rateMetricName;
    }

    public void updateQuota(Quota quota) {
        Lock inWriteLock_inLock_lock = this.lock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            ReplicationQuotaManager.$anonfun$updateQuota$1(this, quota);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.sensor().checkQuotas();
        }
        catch (QuotaViolationException qve) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(44).append(this.replicationType()).append(": Quota violated for sensor (").append(this.sensor().name()).append("), metric: (").append(qve.metric().metricName()).append("), ").toString()).append(new StringBuilder(27).append("metric-value: (").append(qve.value()).append("), bound: (").append(qve.bound()).append(")").toString()).toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        Seq<Object> partitions = this.throttledPartitions().get(topicPartition.topic());
        if (partitions != null) {
            return partitions == Constants$.MODULE$.AllReplicas() || partitions.contains((Object)topicPartition.partition());
        }
        return false;
    }

    @Override
    public void record(long value) {
        this.sensor().record((double)value, this.time().milliseconds(), false);
    }

    public void markThrottled(String topic, Seq<Object> partitions) {
        this.throttledPartitions().put(topic, partitions);
    }

    public void markThrottled(String topic) {
        this.markThrottled(topic, Constants$.MODULE$.AllReplicas());
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions().remove(topic);
    }

    public long upperBound() {
        long l;
        Lock inReadLock_inLock_lock = this.lock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            l = ReplicationQuotaManager.$anonfun$upperBound$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return l;
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    private Sensor sensor() {
        return this.sensorAccess().getOrCreate(this.replicationType().toString(), ReplicationQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable)sensor -> {
            sensor.add(this.rateMetricName(), (MeasurableStat)new SimpleRate(), this.getQuotaMetricConfig(this.quota()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$updateQuota$1(ReplicationQuotaManager $this, Quota quota$1) {
        $this.quota_$eq(quota$1);
        KafkaMetric metric = (KafkaMetric)$this.metrics().metrics().get($this.rateMetricName());
        if (metric != null) {
            metric.config($this.getQuotaMetricConfig(quota$1));
        }
    }

    public static final /* synthetic */ long $anonfun$upperBound$1(ReplicationQuotaManager $this) {
        if ($this.quota() != null) {
            return (long)$this.quota().bound();
        }
        return Long.MAX_VALUE;
    }

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType replicationType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.replicationType = replicationType;
        this.time = time;
        this.lock = new ReentrantReadWriteLock();
        this.throttledPartitions = new ConcurrentHashMap();
        this.quota = null;
        this.sensorAccess = new SensorAccess(this.lock(), metrics);
        this.rateMetricName = metrics.metricName("byte-rate", replicationType.toString(), new StringBuilder(23).append("Tracking byte-rate for ").append(replicationType).toString());
    }
}

