/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.admin.FeatureApis;
import kafka.admin.FeatureCommandOptions;
import kafka.admin.UpdateFeaturesException;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.cluster.Broker;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SetOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000554A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C!=!)Q\u0005\u0001C!M!9A\u0007\u0001b\u0001\n\u0013)\u0004B\u0002$\u0001A\u0003%a\u0007C\u0003H\u0001\u0011%\u0001\nC\u0003\\\u0001\u0011%A\fC\u0003_\u0001\u0011\u0005q\fC\u0003h\u0001\u0011\u0005q\fC\u0003j\u0001\u0011\u0005q\fC\u0003l\u0001\u0011\u0005qL\u0001\nGK\u0006$XO]3D_6l\u0017M\u001c3UKN$(B\u0001\b\u0010\u0003\u0015\tG-\\5o\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ!AF\b\u0002\rM,'O^3s\u0013\tARCA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\tQ\"A\u0006ce>\\WM]\"pk:$X#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u0007%sG/A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011qE\u000b\t\u0003A!J!!K\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006W\r\u0001\r\u0001L\u0001\u0006aJ|\u0007o\u001d\t\u0003[Ij\u0011A\f\u0006\u0003_A\nA!\u001e;jY*\t\u0011'\u0001\u0003kCZ\f\u0017BA\u001a/\u0005)\u0001&o\u001c9feRLWm]\u0001\u0019I\u00164\u0017-\u001e7u'V\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001cX#\u0001\u001c\u0011\u0007]\n5)D\u00019\u0015\tI$(A\u0004gK\u0006$XO]3\u000b\u0005mb\u0014AB2p[6|gN\u0003\u0002\u0011{)\u0011ahP\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u0011\u0005H\u0001\u0005GK\u0006$XO]3t!\t9D)\u0003\u0002Fq\t)2+\u001e9q_J$X\r\u001a,feNLwN\u001c*b]\u001e,\u0017!\u00073fM\u0006,H\u000e^*vaB|'\u000f^3e\r\u0016\fG/\u001e:fg\u0002\nq#\u001e9eCR,7+\u001e9q_J$X\r\u001a$fCR,(/Z:\u0015\u0007\u001dJ5\nC\u0003K\r\u0001\u0007a'\u0001\u0005gK\u0006$XO]3t\u0011\u0015ae\u00011\u0001N\u00035!\u0018M]4fiN+'O^3sgB\u0019a*\u0016-\u000f\u0005=\u001b\u0006C\u0001)\"\u001b\u0005\t&B\u0001*\u0012\u0003\u0019a$o\\8u}%\u0011A+I\u0001\u0007!J,G-\u001a4\n\u0005Y;&aA*fi*\u0011A+\t\t\u0003)eK!AW\u000b\u0003\u0017-\u000bgm[1TKJ4XM]\u0001$kB$\u0017\r^3TkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKNLe.\u00117m\u0005J|7.\u001a:t)\t9S\fC\u0003K\u000f\u0001\u0007a'A\u000euKN$H)Z:de&\u0014WMR3biV\u0014Xm]*vG\u000e,7o\u001d\u000b\u0002O!\u0012\u0001\"\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I~\nQA[;oSRL!AZ2\u0003\tQ+7\u000f^\u0001\u001ei\u0016\u001cH/\u00169he\u0006$W-\u00117m\r\u0016\fG/\u001e:fgN+8mY3tg\"\u0012\u0011\"Y\u0001\u001di\u0016\u001cH\u000fR8x]\u001e\u0014\u0018\rZ3GK\u0006$XO]3t'V\u001c7-Z:tQ\tQ\u0011-\u0001\u000euKN$X\u000b]4sC\u0012,g)Z1ukJ,7OR1jYV\u0014X\r\u000b\u0002\fC\u0002")
public class FeatureCommandTest
extends BaseRequestTest {
    private final Features<SupportedVersionRange> defaultSupportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 3)), Utils.mkEntry((Object)"feature_2", (Object)new SupportedVersionRange(1, 5))}));

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ApiVersion.toString$((ApiVersion)KAFKA_2_7_IV0$.MODULE$));
    }

    private Features<SupportedVersionRange> defaultSupportedFeatures() {
        return this.defaultSupportedFeatures;
    }

    private void updateSupportedFeatures(Features<SupportedVersionRange> features, Set<KafkaServer> targetServers) {
        targetServers.foreach((Function1 & Serializable)s -> {
            FeatureCommandTest.$anonfun$updateSupportedFeatures$1(features, s);
            return BoxedUnit.UNIT;
        });
        Set brokerIds = (Set)targetServers.map((Function1 & Serializable)s -> BoxesRunTime.boxToInteger((int)FeatureCommandTest.$anonfun$updateSupportedFeatures$2(s)));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!FeatureCommandTest.$anonfun$updateSupportedFeatures$3(this, brokerIds, features)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Controller did not get broker updates", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateSupportedFeaturesInAllBrokers(Features<SupportedVersionRange> features) {
        void $plus$plus_that;
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$ == null) {
            throw null;
        }
        nil$ = null;
        SetOps setOps = (SetOps)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems);
        Buffer<KafkaServer> buffer = this.servers();
        if (setOps == null) {
            throw null;
        }
        buffer = null;
        this.updateSupportedFeatures(features, (Set<KafkaServer>)((Set)setOps.concat((IterableOnce)$plus$plus_that)));
    }

    @Test
    public void testDescribeFeaturesSuccess() {
        this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
        featureApis.setSupportedFeatures(this.defaultSupportedFeatures());
        try (FeatureApis featureApis = new FeatureApis(new FeatureCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--from-controller"}));){
            String string;
            String string2;
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> featureApis.describeFeatures();
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String string3 = string2 = grabConsoleOutput_out.toString();
            Object var5_2 = null;
            Object var6_3 = null;
            string2 = null;
            String initialDescribeOutput = string3;
            Assert.assertEquals((Object)"Feature: feature_1\tSupportedMinVersion: 1\tSupportedMaxVersion: 3\tFinalizedMinVersionLevel: -\tFinalizedMaxVersionLevel: -\tEpoch: 0\nFeature: feature_2\tSupportedMinVersion: 1\tSupportedMaxVersion: 5\tFinalizedMinVersionLevel: -\tFinalizedMaxVersionLevel: -\tEpoch: 0\n", (Object)initialDescribeOutput);
            featureApis.upgradeAllFeatures();
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> featureApis.describeFeatures();
            ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String string4 = string = grabConsoleOutput_out2.toString();
            Object var9_7 = null;
            Object var10_8 = null;
            string = null;
            String finalDescribeOutput = string4;
            Assert.assertEquals((Object)"Feature: feature_1\tSupportedMinVersion: 1\tSupportedMaxVersion: 3\tFinalizedMinVersionLevel: 1\tFinalizedMaxVersionLevel: 3\tEpoch: 1\nFeature: feature_2\tSupportedMinVersion: 1\tSupportedMaxVersion: 5\tFinalizedMinVersionLevel: 1\tFinalizedMaxVersionLevel: 5\tEpoch: 1\n", (Object)finalDescribeOutput);
        }
    }

    @Test
    public void testUpgradeAllFeaturesSuccess() {
        FeatureCommandOptions upgradeOpts = new FeatureCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--upgrade-all"});
        try (FeatureApis featureApis = new FeatureApis(upgradeOpts);){
            String string;
            String string2;
            Features initialSupportedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 2))}));
            this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)initialSupportedFeatures);
            featureApis.setSupportedFeatures(initialSupportedFeatures);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> featureApis.upgradeAllFeatures();
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String string3 = string2 = grabConsoleOutput_out.toString();
            Object var6_4 = null;
            Object var7_5 = null;
            string2 = null;
            String output = string3;
            Assert.assertEquals((Object)"      [Add]\tFeature: feature_1\tExistingFinalizedMaxVersion: -\tNewFinalizedMaxVersion: 2\tResult: OK\n", (Object)output);
            this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
            featureApis.setSupportedFeatures(this.defaultSupportedFeatures());
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> featureApis.upgradeAllFeatures();
            ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String string4 = string = grabConsoleOutput_out2.toString();
            Object var10_9 = null;
            Object var11_10 = null;
            string = null;
            output = string4;
            Assert.assertEquals((Object)"  [Upgrade]\tFeature: feature_1\tExistingFinalizedMaxVersion: 2\tNewFinalizedMaxVersion: 3\tResult: OK\n      [Add]\tFeature: feature_2\tExistingFinalizedMaxVersion: -\tNewFinalizedMaxVersion: 5\tResult: OK\n", (Object)output);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f3 = (JFunction0.mcV.sp & Serializable)() -> featureApis.upgradeAllFeatures();
            ByteArrayOutputStream grabConsoleOutput_out3 = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out3, (Function0)grabConsoleOutput_f3);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var14_13 = null;
            Object var15_14 = null;
            output = grabConsoleOutput_out3.toString();
            Assert.assertTrue((boolean)output.isEmpty());
            featureApis.setOptions(upgradeOpts);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f4 = (JFunction0.mcV.sp & Serializable)() -> featureApis.upgradeAllFeatures();
            ByteArrayOutputStream grabConsoleOutput_out4 = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out4, (Function0)grabConsoleOutput_f4);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var17_16 = null;
            Object var18_17 = null;
            output = grabConsoleOutput_out4.toString();
            Assert.assertTrue((boolean)output.isEmpty());
        }
    }

    @Test
    public void testDowngradeFeaturesSuccess() {
        FeatureCommandOptions downgradeOpts = new FeatureCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--downgrade-all"});
        FeatureCommandOptions upgradeOpts = new FeatureCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--upgrade-all"});
        try (FeatureApis featureApis = new FeatureApis(upgradeOpts);){
            String string;
            String string2;
            this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
            featureApis.setSupportedFeatures(this.defaultSupportedFeatures());
            featureApis.upgradeAllFeatures();
            Features downgradedFeatures = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 2))}));
            featureApis.setSupportedFeatures(downgradedFeatures);
            featureApis.setOptions(downgradeOpts);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> featureApis.downgradeAllFeatures();
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String string3 = string2 = grabConsoleOutput_out.toString();
            Object var7_5 = null;
            Object var8_6 = null;
            string2 = null;
            String output = string3;
            Assert.assertEquals((Object)"[Downgrade]\tFeature: feature_1\tExistingFinalizedMaxVersion: 3\tNewFinalizedMaxVersion: 2\tResult: OK\n   [Delete]\tFeature: feature_2\tExistingFinalizedMaxVersion: 5\tNewFinalizedMaxVersion: -\tResult: OK\n", (Object)output);
            this.updateSupportedFeaturesInAllBrokers((Features<SupportedVersionRange>)downgradedFeatures);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> featureApis.downgradeAllFeatures();
            ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var11_10 = null;
            Object var12_11 = null;
            output = grabConsoleOutput_out2.toString();
            Assert.assertTrue((boolean)output.isEmpty());
            featureApis.setSupportedFeatures(Features.emptySupportedFeatures());
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f3 = (JFunction0.mcV.sp & Serializable)() -> featureApis.downgradeAllFeatures();
            ByteArrayOutputStream grabConsoleOutput_out3 = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out3, (Function0)grabConsoleOutput_f3);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String string4 = string = grabConsoleOutput_out3.toString();
            Object var14_13 = null;
            Object var15_14 = null;
            string = null;
            output = string4;
            Assert.assertEquals((Object)"   [Delete]\tFeature: feature_1\tExistingFinalizedMaxVersion: 2\tNewFinalizedMaxVersion: -\tResult: OK\n", (Object)output);
        }
    }

    @Test
    public void testUpgradeFeaturesFailure() {
        FeatureCommandOptions upgradeOpts = new FeatureCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--upgrade-all"});
        try (FeatureApis featureApis = new FeatureApis(upgradeOpts);){
            String string;
            this.updateSupportedFeaturesInAllBrokers(this.defaultSupportedFeatures());
            Features targetFeaturesWithIncompatibilities = Features.supportedFeatures((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"feature_1", (Object)new SupportedVersionRange(1, 4)), Utils.mkEntry((Object)"feature_2", (Object)new SupportedVersionRange(1, 5)), Utils.mkEntry((Object)"feature_3", (Object)new SupportedVersionRange(1, 3))}));
            featureApis.setSupportedFeatures(targetFeaturesWithIncompatibilities);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> {
                UpdateFeaturesException exception = (UpdateFeaturesException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> featureApis.upgradeAllFeatures(), ClassTag$.MODULE$.apply(UpdateFeaturesException.class), new Position("FeatureCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
                Assert.assertEquals((Object)"2 feature updates failed!", (Object)exception.getMessage());
            };
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String string2 = string = grabConsoleOutput_out.toString();
            Object var6_4 = null;
            Object var7_5 = null;
            string = null;
            String output = string2;
            Assert.assertEquals((Object)"      [Add]\tFeature: feature_1\tExistingFinalizedMaxVersion: -\tNewFinalizedMaxVersion: 4\tResult: FAILED due to org.apache.kafka.common.errors.InvalidRequestException: Could not apply finalized feature update because brokers were found to have incompatible versions for the feature.\n      [Add]\tFeature: feature_2\tExistingFinalizedMaxVersion: -\tNewFinalizedMaxVersion: 5\tResult: OK\n      [Add]\tFeature: feature_3\tExistingFinalizedMaxVersion: -\tNewFinalizedMaxVersion: 3\tResult: FAILED due to org.apache.kafka.common.errors.InvalidRequestException: Could not apply finalized feature update because the provided feature is not supported.\n", (Object)output);
        }
    }

    public static final /* synthetic */ void $anonfun$updateSupportedFeatures$1(Features features$1, KafkaServer s) {
        s.brokerFeatures().setSupportedFeatures(features$1);
        s.zkClient().updateBrokerInfo(s.createBrokerInfo());
    }

    public static final /* synthetic */ int $anonfun$updateSupportedFeatures$2(KafkaServer s) {
        return s.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$6(Features features$1, Broker b) {
        return b.features().equals((Object)features$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$4(Set brokerIds$1, Features features$1, KafkaServer s) {
        if (s.kafkaController().isActive()) {
            return ((IterableOnceOps)s.kafkaController().controllerContext().liveOrShuttingDownBrokers().filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds$1.contains((Object)b.id())))).forall((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)FeatureCommandTest.$anonfun$updateSupportedFeatures$6(features$1, b)));
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$updateSupportedFeatures$3(FeatureCommandTest $this, Set brokerIds$1, Features features$1) {
        return $this.servers().exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)FeatureCommandTest.$anonfun$updateSupportedFeatures$4(brokerIds$1, features$1, s)));
    }

    public static final /* synthetic */ String $anonfun$updateSupportedFeatures$7() {
        return "Controller did not get broker updates";
    }
}

