/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.AdminManager;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000594AAE\n\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB\u0016\u0001A\u0003%Q\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\t\ri\u0002\u0001\u0015!\u0003/\u0011\u001dY\u0004A1A\u0005\nqBa\u0001\u0011\u0001!\u0002\u0013i\u0004bB!\u0001\u0005\u0004%IA\u0011\u0005\u0007\u0017\u0002\u0001\u000b\u0011B\"\t\u000f1\u0003!\u0019!C\u0005\u001b\"1\u0011\u000b\u0001Q\u0001\n9CQA\u0015\u0001\u0005\u0002MCQA\u0018\u0001\u0005\u0002}CQa\u0019\u0001\u0005\u0002MCQ\u0001\u001b\u0001\u0005\u0002MCQA\u001b\u0001\u0005\u0002MCQ\u0001\u001c\u0001\u0005\u0002M\u0013\u0001#\u00113nS:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005Q)\u0012AB:feZ,'OC\u0001\u0017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t1#\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0016\u0003\tQ8.\u0003\u0002+O\ti1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u000f5,GO]5dgV\ta\u0006\u0005\u00020q5\t\u0001G\u0003\u0002-c)\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005Y!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0019\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0005ce>\\WM]%e+\u0005i\u0004C\u0001\u000e?\u0013\ty4DA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\u000bQ|\u0007/[2\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t1\fgn\u001a\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005q\u0005C\u0001\u0012P\u0013\t\u00016CA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003!!X-\u0019:E_^tG#\u0001+\u0011\u0005i)\u0016B\u0001,\u001c\u0005\u0011)f.\u001b;)\u00051A\u0006CA-]\u001b\u0005Q&BA.7\u0003\u0015QWO\\5u\u0013\ti&LA\u0003BMR,'/\u0001\nde\u0016\fG/Z!e[&tW*\u00198bO\u0016\u0014H#\u00011\u0011\u0005\t\n\u0017B\u00012\u0014\u00051\tE-\\5o\u001b\u0006t\u0017mZ3s\u00031\"Xm\u001d;EKN\u001c'/\u001b2f\u0007>tg-[4t/&$\bNT;mY\u000e{gNZ5hkJ\fG/[8o\u0017\u0016L8\u000f\u000b\u0002\u000fKB\u0011\u0011LZ\u0005\u0003Oj\u0013A\u0001V3ti\u0006iC/Z:u\t\u0016\u001c8M]5cK\u000e{gNZ5hg^KG\u000f[#naRL8i\u001c8gS\u001e,(/\u0019;j_:\\U-_:)\u0005=)\u0017\u0001\u000b;fgR$Um]2sS\n,7i\u001c8gS\u001e\u001cx+\u001b;i\u0007>tg-[4ve\u0006$\u0018n\u001c8LKf\u001c\bF\u0001\tf\u0003\u0011\"Xm\u001d;EKN\u001c'/\u001b2f\u0007>tg-[4t/&$\b\u000eR8dk6,g\u000e^1uS>t\u0007FA\tf\u0001")
public class AdminManagerTest {
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final String topic;
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    public AdminManager createAdminManager() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        return new AdminManager(KafkaConfig$.MODULE$.fromProps(props), this.metrics(), this.metadataCache(), this.zkClient());
    }

    @Test
    public void testDescribeConfigsWithNullConfigurationKeys() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        EasyMock.expect((Object)this.metadataCache().contains(this.topic())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(null), (List)Nil$.MODULE$);
        List results = this.createAdminManager().describeConfigs((List)resources, true, true);
        Assert.assertEquals((long)Errors.NONE.code(), (long)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assert.assertFalse((String)"Should return configs", (boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty());
    }

    @Test
    public void testDescribeConfigsWithEmptyConfigurationKeys() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        EasyMock.expect((Object)this.metadataCache().contains(this.topic())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), (List)Nil$.MODULE$);
        List results = this.createAdminManager().describeConfigs((List)resources, true, true);
        Assert.assertEquals((long)Errors.NONE.code(), (long)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Assert.assertFalse((String)"Should return configs", (boolean)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeConfigsWithConfigurationKeys() {
        void apply_elems;
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        EasyMock.expect((Object)this.metadataCache().contains(this.topic())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()).setConfigurationKeys(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)"retention.ms", (List)new .colon.colon((Object)"retention.bytes", (List)new .colon.colon((Object)"segment.bytes", (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$);
        List results = this.createAdminManager().describeConfigs((List)resources, true, true);
        Assert.assertEquals((long)Errors.NONE.code(), (long)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).errorCode());
        Set resultConfigKeys = ((IterableOnceOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((DescribeConfigsResponseData.DescribeConfigsResult)results.head()).configs()).asScala().map((Function1 & Serializable)r -> r.name())).toSet();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes", "segment.bytes"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)resultConfigKeys);
    }

    @Test
    public void testDescribeConfigsWithDocumentation() {
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), this.topic())).andReturn((Object)new Properties());
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Broker(), ((Object)this.brokerId()).toString())).andReturn((Object)new Properties());
        EasyMock.expect((Object)this.metadataCache().contains(this.topic())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.zkClient(), this.metadataCache()});
        AdminManager adminManager = this.createAdminManager();
        .colon.colon resources = new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(this.topic()).setResourceType(ConfigResource.Type.TOPIC.id()), (List)new .colon.colon((Object)new DescribeConfigsRequestData.DescribeConfigsResource().setResourceName(((Object)this.brokerId()).toString()).setResourceType(ConfigResource.Type.BROKER.id()), (List)Nil$.MODULE$));
        List results = adminManager.describeConfigs((List)resources, true, true);
        if (results == null) {
            throw null;
        }
        Assert.assertEquals((long)2L, (long)SeqOps.size$((SeqOps)results));
        List foreach_these = results;
        while (!foreach_these.isEmpty()) {
            AdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$1((DescribeConfigsResponseData.DescribeConfigsResult)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    public static final /* synthetic */ void $anonfun$testDescribeConfigsWithDocumentation$1(DescribeConfigsResponseData.DescribeConfigsResult r) {
        Assert.assertEquals((long)Errors.NONE.code(), (long)r.errorCode());
        Assert.assertFalse((String)"Should return configs", (boolean)r.configs().isEmpty());
        r.configs().forEach(c -> {
            Assert.assertNotNull((String)new StringBuilder(42).append("Config ").append(c.name()).append(" should have non null documentation").toString(), (Object)c.documentation());
            Assert.assertNotEquals((String)new StringBuilder(43).append("Config ").append(c.name()).append(" should have non blank documentation").toString(), (Object)"", (Object)c.documentation().trim());
        });
    }

    public AdminManagerTest() {
        this.brokerId = 1;
        this.topic = "topic-1";
    }

    public static final /* synthetic */ Object $anonfun$testDescribeConfigsWithDocumentation$1$adapted(DescribeConfigsResponseData.DescribeConfigsResult r) {
        AdminManagerTest.$anonfun$testDescribeConfigsWithDocumentation$1(r);
        return BoxedUnit.UNIT;
    }
}

