/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.BrokerIdsZNode$;
import kafka.zk.BrokerInfo;
import kafka.zk.FeatureZNode$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerIdZNode$ {
    public static final BrokerIdZNode$ MODULE$ = new BrokerIdZNode$();
    private static final String HostKey = "host";
    private static final String PortKey = "port";
    private static final String VersionKey = "version";
    private static final String EndpointsKey = "endpoints";
    private static final String RackKey = "rack";
    private static final String JmxPortKey = "jmx_port";
    private static final String ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
    private static final String TimestampKey = "timestamp";
    private static final String FeaturesKey = "features";

    private String HostKey() {
        return HostKey;
    }

    private String PortKey() {
        return PortKey;
    }

    private String VersionKey() {
        return VersionKey;
    }

    private String EndpointsKey() {
        return EndpointsKey;
    }

    private String RackKey() {
        return RackKey;
    }

    private String JmxPortKey() {
        return JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return TimestampKey;
    }

    private String FeaturesKey() {
        return FeaturesKey;
    }

    public String path(int id) {
        return new StringBuilder(1).append(BrokerIdsZNode$.MODULE$.path()).append("/").append(id).toString();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encode(int version, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack, Features<SupportedVersionRange> features) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        Integer n;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        Integer n2;
        String string;
        void $minus$greater$extension_y5;
        Integer n3;
        Object[] objectArray = new Tuple2[6];
        Integer n4 = n3 = Integer.valueOf(version);
        n3 = null;
        Integer n5 = n4;
        String $minus$greater$extension_$this = this.VersionKey();
        Object var9_10 = null;
        n5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y5);
        String string2 = string = this.HostKey();
        string = null;
        String $minus$greater$extension_$this2 = string2;
        Object var11_12 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)host);
        Integer n6 = n2 = Integer.valueOf(port);
        n2 = null;
        Integer n7 = n6;
        String $minus$greater$extension_$this3 = this.PortKey();
        Object var12_15 = null;
        n7 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        IterableOnceOps iterableOnceOps = (IterableOnceOps)advertisedEndpoints.map((Function1 & Serializable)x$1 -> x$1.connectionString());
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps toBuffer_this = iterableOnceOps;
        Object var14_16 = null;
        java.util.List list = AsJavaExtensions.BufferHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Buffer)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this))).asJava();
        String $minus$greater$extension_$this4 = this.EndpointsKey();
        Object var15_18 = null;
        list = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        Integer n8 = n = Integer.valueOf(jmxPort);
        n = null;
        Integer n9 = n8;
        String $minus$greater$extension_$this5 = this.JmxPortKey();
        Object var17_21 = null;
        n9 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string3 = ((Object)Time.SYSTEM.milliseconds()).toString();
        String $minus$greater$extension_$this6 = this.TimestampKey();
        Object var19_23 = null;
        string3 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (rack == null) {
            throw null;
        }
        if (!rack.isEmpty()) {
            String string4 = (String)rack.get();
            BrokerIdZNode$.$anonfun$encode$2(version, jsonMap, string4);
        }
        if (version >= 4) {
            void $plus$eq_elem;
            void $minus$greater$extension_y6;
            Tuple2 tuple2;
            java.util.Map map = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((IterableOnceOps)advertisedEndpoints.map((Function1 & Serializable)endPoint -> {
                String $minus$greater$extension_y = endPoint.securityProtocol().name;
                String $minus$greater$extension_$this = endPoint.listenerName().value();
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            String $minus$greater$extension_$this7 = this.ListenerSecurityProtocolMapKey();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y6);
            Object var21_27 = null;
            map = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            if (jsonMap == null) {
                throw null;
            }
            jsonMap.addOne((Object)$plus$eq_elem);
            tuple23 = null;
        }
        if (version >= 5) {
            void $plus$eq_elem;
            void $minus$greater$extension_y7;
            Tuple2 tuple2;
            java.util.Map map = features.toMap();
            String $minus$greater$extension_$this8 = this.FeaturesKey();
            Tuple2 tuple24 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y7);
            Object var25_31 = null;
            map = null;
            tuple2 = null;
            Tuple2 tuple25 = tuple24;
            if (jsonMap == null) {
                throw null;
            }
            jsonMap.addOne((Object)$plus$eq_elem);
            tuple25 = null;
        }
        return Json$.MODULE$.encodeAsBytes(AsJavaExtensions.MutableMapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (scala.collection.mutable.Map)jsonMap).asJava());
    }

    public byte[] encode(BrokerInfo brokerInfo) {
        Broker broker = brokerInfo.broker();
        Option option = broker.endPoints().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BrokerIdZNode$.$anonfun$encode$4(x$2)));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BrokerIdZNode$.$anonfun$encode$5() : getOrElse_this.get();
        Object object2 = object;
        Object var4_3 = null;
        object = null;
        EndPoint plaintextEndpoint = (EndPoint)object2;
        return this.encode(brokerInfo.version(), plaintextEndpoint.host(), plaintextEndpoint.port(), broker.endPoints(), brokerInfo.jmxPort(), broker.rack(), broker.features());
    }

    public java.util.Map<String, java.util.Map<String, Short>> featuresAsJavaMap(JsonObject brokerInfo) {
        Object object;
        Option<JsonValue> option = brokerInfo.get(this.FeaturesKey());
        if (option == null) {
            throw null;
        }
        Option<JsonValue> flatMap_this = option;
        Object object2 = flatMap_this.isEmpty() ? None$.MODULE$ : BrokerIdZNode$.$anonfun$featuresAsJavaMap$1((JsonValue)flatMap_this.get());
        None$ none$ = object2;
        Object var2_2 = null;
        object2 = null;
        if (none$ == null) {
            throw null;
        }
        None$ map_this = none$;
        Object object3 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BrokerIdZNode$.$anonfun$featuresAsJavaMap$2((Map)map_this.get()));
        None$ none$2 = object3;
        Object var4_4 = null;
        object3 = null;
        None$ getOrElse_this = none$2;
        if (getOrElse_this.isEmpty()) {
            Map map;
            Map map2 = map = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            map = null;
            object = map2;
        } else {
            object = getOrElse_this.get();
        }
        Object object4 = object;
        Object var6_6 = null;
        object = null;
        return FeatureZNode$.MODULE$.asJavaMap((Map<String, Map<String, Object>>)((Map)object4));
    }

    /*
     * WARNING - void declaration
     */
    public BrokerInfo decode(int id, byte[] jsonBytes) {
        Option<JsonValue> option;
        .colon.colon endpoints;
        int jmxPort;
        int version;
        JsonObject brokerInfo;
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            .colon.colon colon2;
            brokerInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            version = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            jmxPort = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.JmxPortKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < 1) {
                throw new KafkaException(new StringBuilder(44).append("Unsupported version of broker registration: ").append(String.valueOf(new String(jsonBytes, StandardCharsets.UTF_8))).toString());
            }
            if (version == 1) {
                String host = brokerInfo.apply(this.HostKey()).to(DecodeJson$DecodeString$.MODULE$);
                int port = BoxesRunTime.unboxToInt((Object)brokerInfo.apply(this.PortKey()).to(DecodeJson$DecodeInt$.MODULE$));
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
                colon2 = new .colon.colon((Object)endPoint, (List)Nil$.MODULE$);
            } else {
                void decodeSeq_factory;
                Factory factory;
                Option<JsonValue> option2 = brokerInfo.get(this.ListenerSecurityProtocolMapKey());
                if (option2 == null) {
                    throw null;
                }
                Option<JsonValue> map_this = option2;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BrokerIdZNode$.$anonfun$decode$2((JsonValue)map_this.get()));
                None$ none$ = object;
                Object var17_11 = null;
                object = null;
                None$ securityProtocolMap = none$;
                Seq$ iterableFactory_this = Seq$.MODULE$;
                Factory factory2 = factory = IterableFactory.iterableFactory$((IterableFactory)iterableFactory_this);
                Object var21_14 = null;
                factory = null;
                Factory factory3 = factory2;
                DecodeJson$DecodeString$ decodeSeq_decodeJson = DecodeJson$DecodeString$.MODULE$;
                Object var23_17 = null;
                factory3 = null;
                colon2 = (Seq)((Seq)brokerInfo.apply(this.EndpointsKey()).to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                    private final DecodeJson decodeJson$2;
                    private final Factory factory$1;

                    public Object decode(JsonNode node) {
                        return DecodeJson.decode$(this, node);
                    }

                    public final Either<String, S> decodeEither(JsonNode node) {
                        return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                    }
                    {
                        this.decodeJson$2 = decodeJson$2;
                        this.factory$1 = factory$1;
                    }
                })).map(arg_0 -> BrokerIdZNode$.$anonfun$decode$4((Option)securityProtocolMap, arg_0));
            }
            endpoints = colon2;
            option = brokerInfo.get(this.RackKey());
            if (option == null) {
                throw null;
            }
        } else {
            if (either instanceof Left) {
                JsonProcessingException e = (JsonProcessingException)((Left)either).value();
                throw new KafkaException(new StringBuilder(0).append(new StringBuilder(52).append("Failed to parse ZooKeeper registration for broker ").append(id).append(": ").toString()).append(String.valueOf(new String(jsonBytes, StandardCharsets.UTF_8))).toString(), (Throwable)e);
            }
            throw new MatchError(either);
        }
        Option<JsonValue> flatMap_this = option;
        Object object = flatMap_this.isEmpty() ? None$.MODULE$ : BrokerIdZNode$.$anonfun$decode$5((JsonValue)flatMap_this.get());
        None$ none$ = object;
        Object var19_19 = null;
        object = null;
        None$ rack = none$;
        java.util.Map<String, java.util.Map<String, Short>> features = this.featuresAsJavaMap(brokerInfo);
        BrokerInfo brokerInfo2 = new BrokerInfo(new Broker(id, (Seq<EndPoint>)endpoints, (Option<String>)rack, (Features<SupportedVersionRange>)Features.fromSupportedFeaturesMap(features)), version, jmxPort);
        return brokerInfo2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$encode$2(int version$1, scala.collection.mutable.Map jsonMap$1, String rack) {
        if (version$1 >= 3) {
            void $plus$eq_elem;
            Tuple2 tuple2;
            String string;
            String string2 = string = MODULE$.RackKey();
            string = null;
            String $minus$greater$extension_$this = string2;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)rack);
            Object var3_4 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            if (jsonMap$1 == null) {
                throw null;
            }
            return jsonMap$1.addOne((Object)$plus$eq_elem);
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$encode$4(EndPoint x$2) {
        SecurityProtocol securityProtocol = x$2.securityProtocol();
        SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
        return !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
    }

    public static final /* synthetic */ EndPoint $anonfun$encode$5() {
        return new EndPoint(null, -1, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Option $anonfun$featuresAsJavaMap$1(JsonValue x$3) {
        void decodeMap_factory;
        DecodeJson decodeJson;
        void decodeMap_factory2;
        Factory factory;
        Factory factory2;
        scala.collection.Map$ mapFactory_this = scala.collection.Map$.MODULE$;
        Factory factory3 = factory2 = MapFactory.mapFactory$((MapFactory)mapFactory_this);
        Object var1_1 = null;
        factory2 = null;
        Factory factory4 = factory3;
        DecodeJson$DecodeInt$ decodeMap_decodeJson = DecodeJson$DecodeInt$.MODULE$;
        Object var5_4 = null;
        factory4 = null;
        scala.collection.Map$ mapFactory_this2 = scala.collection.Map$.MODULE$;
        Factory factory5 = factory = MapFactory.mapFactory$((MapFactory)mapFactory_this2);
        Object var3_5 = null;
        factory = null;
        Factory factory6 = factory5;
        DecodeJson decodeMap_decodeJson2 = new DecodeJson<M>(decodeMap_decodeJson, (Factory)decodeMap_factory2){
            private final DecodeJson decodeJson$3;
            private final Factory factory$2;

            public Object decode(JsonNode node) {
                return DecodeJson.decode$(this, node);
            }

            public final Either<String, M> decodeEither(JsonNode node) {
                return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeMap$1(node, this.decodeJson$3, this.factory$2);
            }
            {
                this.decodeJson$3 = decodeJson$3;
                this.factory$2 = factory$2;
            }
        };
        DecodeJson decodeJson2 = decodeJson = new /* invalid duplicate definition of identical inner class */;
        Object var7_8 = null;
        factory6 = null;
        decodeJson = null;
        DecodeJson decodeOption_decodeJson = decodeJson2;
        Object var10_10 = null;
        return (Option)x$3.to(new DecodeJson<Option<E>>(decodeOption_decodeJson){
            private final DecodeJson decodeJson$1;

            public Object decode(JsonNode node) {
                return DecodeJson.decode$(this, node);
            }

            public final Either<String, Option<E>> decodeEither(JsonNode node) {
                return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeOption$1(node, this.decodeJson$1);
            }
            {
                this.decodeJson$1 = decodeJson$1;
            }
        });
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$featuresAsJavaMap$2(Map theMap) {
        return theMap.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String featureName = (String)x0$1._1();
            Map versionsInfo = (Map)x0$1._2();
            scala.collection.immutable.Map $minus$greater$extension_y = versionsInfo.map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2;
                Short s;
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                String label = (String)x0$2._1();
                int version = x0$2._2$mcI$sp();
                Short s2 = s = Short.valueOf((short)version);
                s = null;
                Short $minus$greater$extension_y = s2;
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)label, (Object)$minus$greater$extension_y);
                Object var4_4 = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                return tuple23;
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)featureName, (Object)$minus$greater$extension_y);
            Object var4_3 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Map $anonfun$featuresAsJavaMap$5() {
        return (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Map $anonfun$decode$2(JsonValue x$4) {
        void decodeMap_factory;
        Factory factory;
        scala.collection.Map$ mapFactory_this = scala.collection.Map$.MODULE$;
        Factory factory2 = factory = MapFactory.mapFactory$((MapFactory)mapFactory_this);
        Object var1_1 = null;
        factory = null;
        Factory factory3 = factory2;
        DecodeJson$DecodeString$ decodeMap_decodeJson = DecodeJson$DecodeString$.MODULE$;
        Object var3_4 = null;
        factory3 = null;
        return (Map)((MapOps)x$4.to(new /* invalid duplicate definition of identical inner class */)).map((Function1 & Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String listenerName = (String)x0$1._1();
            String securityProtocol = (String)x0$1._2();
            SecurityProtocol securityProtocol2 = SecurityProtocol.forName((String)securityProtocol);
            ListenerName $minus$greater$extension_$this = new ListenerName(listenerName);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var4_4 = null;
            securityProtocol2 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
    }

    public static final /* synthetic */ EndPoint $anonfun$decode$4(Option securityProtocolMap$1, String x$5) {
        return EndPoint$.MODULE$.createEndPoint(x$5, (Option<Map<ListenerName, SecurityProtocol>>)securityProtocolMap$1);
    }

    public static final /* synthetic */ Option $anonfun$decode$5(JsonValue x$6) {
        DecodeJson$DecodeString$ decodeOption_decodeJson = DecodeJson$DecodeString$.MODULE$;
        Object var1_1 = null;
        return (Option)x$6.to(new /* invalid duplicate definition of identical inner class */);
    }

    private BrokerIdZNode$() {
    }
}

