/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r\u0015tA\u0002%J\u0011\u0003IuJ\u0002\u0004R\u0013\"\u0005\u0011J\u0015\u0005\u00063\u0006!\ta\u0017\u0005\u00069\u0006!\t!\u0018\u0005\u00079\u0006!\tAa@\t\rq\u000bA\u0011AB\u0007\u0011\u001d\u0019y\"\u0001C\u0001\u0007CAqa!\f\u0002\t\u0003\u0019y\u0003C\u0005\u00048\u0005\u0011\r\u0011\"\u0003\u0004:!A1QI\u0001!\u0002\u0013\u0019Y\u0004C\u0004\u0004H\u0005!\ta!\u0013\t\u0013\r5\u0013!%A\u0005\u0002\r=c!B)J\u0001%{\u0006\u0002\u00034\r\u0005\u000b\u0007I\u0011A4\t\u0011Md!\u0011!Q\u0001\n!D\u0001\u0002\u001e\u0007\u0003\u0002\u0004%\t!\u001e\u0005\ts2\u0011\t\u0019!C\u0001u\"I\u0011\u0011\u0001\u0007\u0003\u0002\u0003\u0006KA\u001e\u0005\n\u0003\u0007a!\u00111A\u0005\u0002UD!\"!\u0002\r\u0005\u0003\u0007I\u0011AA\u0004\u0011%\tY\u0001\u0004B\u0001B\u0003&a\u000f\u0003\u0006\u0002\u000e1\u0011\t\u0019!C\u0001\u0003\u001fA!\"a\u0006\r\u0005\u0003\u0007I\u0011AA\r\u0011)\ti\u0002\u0004B\u0001B\u0003&\u0011\u0011\u0003\u0005\u000b\u0003?a!\u00111A\u0005\u0002\u0005=\u0001BCA\u0011\u0019\t\u0005\r\u0011\"\u0001\u0002$!Q\u0011q\u0005\u0007\u0003\u0002\u0003\u0006K!!\u0005\t\u0015\u0005%BB!a\u0001\n\u0003\tY\u0003\u0003\u0006\u000241\u0011\t\u0019!C\u0001\u0003kA!\"!\u000f\r\u0005\u0003\u0005\u000b\u0015BA\u0017\u0011)\tY\u0004\u0004BA\u0002\u0013\u0005\u0011Q\b\u0005\u000b\u0003\u000bb!\u00111A\u0005\u0002\u0005\u001d\u0003BCA&\u0019\t\u0005\t\u0015)\u0003\u0002@!Q\u0011Q\n\u0007\u0003\u0006\u0004%\t!a\u0014\t\u0015\u0005]DB!A!\u0002\u0013\t\t\u0006C\u0005\u0002z1\u0011\t\u0019!C\u0001k\"Q\u00111\u0010\u0007\u0003\u0002\u0004%\t!! \t\u0013\u0005\u0005EB!A!B\u00131\b\"CAF\u0019\t\u0005\r\u0011\"\u0001v\u0011)\ti\t\u0004BA\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0003'c!\u0011!Q!\nYDa!\u0017\u0007\u0005\u0002\u0005]\u0005\"CAW\u0019\u0001\u0007I\u0011AAX\u0011%\t9\f\u0004a\u0001\n\u0003\tI\f\u0003\u0005\u0002>2\u0001\u000b\u0015BAY\u0011%\ty\f\u0004a\u0001\n\u0003\t\t\rC\u0005\u0002J2\u0001\r\u0011\"\u0001\u0002L\"A\u0011q\u001a\u0007!B\u0013\t\u0019\r\u0003\u0006\u0002R2\u0011\r\u0011\"\u0001J\u0003'D\u0001\"!<\rA\u0003%\u0011Q\u001b\u0005\b\u0003_dA\u0011AAy\u0011\u001d\u0011)\u0002\u0004C\u0001\u0005/AqAa\t\r\t\u0003\u0011)\u0003C\u0004\u0003,1!\tA!\f\t\u000f\tUB\u0002\"\u0001\u0003.!9!q\u0007\u0007\u0005\u0002\te\u0002b\u0002B4\u0019\u0011\u0005!\u0011\u000e\u0005\b\u0005obA\u0011\u0001B=\u0011\u001d\u0011Y\t\u0004C\u0001\u0005\u001bCqA!&\r\t\u0003\u00119\nC\u0004\u0003\u001c2!\tA!\f\t\u000f\tuE\u0002\"\u0001\u0002B\"9!q\u0014\u0007\u0005\n\u0005\u0005\u0007b\u0002BQ\u0019\u0011%!1\u0015\u0005\b\u0005{cA\u0011\u0001B`\u0011\u001d\u0011)\r\u0004C\u0005\u0005\u000fDqAa3\r\t\u0013\u0011i\rC\u0004\u0003R2!IAa5\t\u000f\teG\u0002\"\u0001\u0002B\"9!1\u001c\u0007\u0005B\tu\u0007b\u0002Bp\u0019\u0011\u0005#\u0011\u001d\u0005\b\u0005OdA\u0011\tBu\u0003M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0015\tQ5*A\u0006ue\u0006t7/Y2uS>t'B\u0001'N\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u00039\u000bQa[1gW\u0006\u0004\"\u0001U\u0001\u000e\u0003%\u00131\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\"!A*\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0017y\u0013\u0019P!>\u0003x\ne(1 \t\u0003!2\u00192\u0001D*a!\t\tG-D\u0001c\u0015\t\u0019W*A\u0003vi&d7/\u0003\u0002fE\n9Aj\\4hS:<\u0017a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0016\u0003!\u0004\"!\u001b9\u000f\u0005)t\u0007CA6V\u001b\u0005a'BA7[\u0003\u0019a$o\\8u}%\u0011q.V\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002p+\u0006\u0001BO]1og\u0006\u001cG/[8oC2LE\rI\u0001\u000baJ|G-^2fe&#W#\u0001<\u0011\u0005Q;\u0018B\u0001=V\u0005\u0011auN\\4\u0002\u001dA\u0014x\u000eZ;dKJLEm\u0018\u0013fcR\u00111P \t\u0003)rL!!`+\u0003\tUs\u0017\u000e\u001e\u0005\b\u007fB\t\t\u00111\u0001w\u0003\rAH%M\u0001\faJ|G-^2fe&#\u0007%\u0001\bmCN$\bK]8ek\u000e,'/\u00133\u0002%1\f7\u000f\u001e)s_\u0012,8-\u001a:JI~#S-\u001d\u000b\u0004w\u0006%\u0001bB@\u0014\u0003\u0003\u0005\rA^\u0001\u0010Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]%eA\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\"!!\u0005\u0011\u0007Q\u000b\u0019\"C\u0002\u0002\u0016U\u0013Qa\u00155peR\f\u0011\u0003\u001d:pIV\u001cWM]#q_\u000eDw\fJ3r)\rY\u00181\u0004\u0005\t\u007fZ\t\t\u00111\u0001\u0002\u0012\u0005q\u0001O]8ek\u000e,'/\u00129pG\"\u0004\u0013!\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0006)B.Y:u!J|G-^2fe\u0016\u0003xn\u00195`I\u0015\fHcA>\u0002&!Aq0GA\u0001\u0002\u0004\t\t\"\u0001\nmCN$\bK]8ek\u000e,'/\u00129pG\"\u0004\u0013\u0001\u0004;y]RKW.Z8vi6\u001bXCAA\u0017!\r!\u0016qF\u0005\u0004\u0003c)&aA%oi\u0006\u0001B\u000f\u001f8US6,w.\u001e;Ng~#S-\u001d\u000b\u0004w\u0006]\u0002\u0002C@\u001d\u0003\u0003\u0005\r!!\f\u0002\u001bQDh\u000eV5nK>,H/T:!\u0003\u0015\u0019H/\u0019;f+\t\ty\u0004E\u0002Q\u0003\u0003J1!a\u0011J\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-A\u0005ti\u0006$Xm\u0018\u0013fcR\u001910!\u0013\t\u0011}|\u0012\u0011!a\u0001\u0003\u007f\taa\u001d;bi\u0016\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005E\u0003CBA*\u0003;\n\t'\u0004\u0002\u0002V)!\u0011qKA-\u0003\u001diW\u000f^1cY\u0016T1!a\u0017V\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\n)FA\u0002TKR\u0004B!a\u0019\u0002t5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0004d_6lwN\u001c\u0006\u0004\u001d\u0006-$\u0002BA7\u0003_\na!\u00199bG\",'BAA9\u0003\ry'oZ\u0005\u0005\u0003k\n)G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0013!\u0005;y]N#\u0018M\u001d;US6,7\u000f^1na\u0006)B\u000f\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fHcA>\u0002\u0000!9q\u0010JA\u0001\u0002\u00041\u0018A\u0005;y]N#\u0018M\u001d;US6,7\u000f^1na\u0002B3!JAC!\r!\u0016qQ\u0005\u0004\u0003\u0013+&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002-QDh\u000eT1tiV\u0003H-\u0019;f)&lWm\u001d;b[B\f!\u0004\u001e=o\u0019\u0006\u001cH/\u00169eCR,G+[7fgR\fW\u000e]0%KF$2a_AI\u0011\u001dyx%!AA\u0002Y\fq\u0003\u001e=o\u0019\u0006\u001cH/\u00169eCR,G+[7fgR\fW\u000e\u001d\u0011)\u0007!\n)\tF\u000b_\u00033\u000bY*!(\u0002 \u0006\u0005\u00161UAS\u0003O\u000bI+a+\t\u000b\u0019L\u0003\u0019\u00015\t\u000bQL\u0003\u0019\u0001<\t\r\u0005\r\u0011\u00061\u0001w\u0011\u001d\ti!\u000ba\u0001\u0003#Aq!a\b*\u0001\u0004\t\t\u0002C\u0004\u0002*%\u0002\r!!\f\t\u000f\u0005m\u0012\u00061\u0001\u0002@!9\u0011QJ\u0015A\u0002\u0005E\u0003\u0002CA=SA\u0005\t\u0019\u0001<\t\r\u0005-\u0015\u00061\u0001w\u00031\u0001XM\u001c3j]\u001e\u001cF/\u0019;f+\t\t\t\fE\u0003U\u0003g\u000by$C\u0002\u00026V\u0013aa\u00149uS>t\u0017\u0001\u00059f]\u0012LgnZ*uCR,w\fJ3r)\rY\u00181\u0018\u0005\t\u007f.\n\t\u00111\u0001\u00022\u0006i\u0001/\u001a8eS:<7\u000b^1uK\u0002\n1\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016,\"!a1\u0011\u0007Q\u000b)-C\u0002\u0002HV\u0013qAQ8pY\u0016\fg.A\fiCN4\u0015-\u001b7fI\u0016\u0003xn\u00195GK:\u001cWm\u0018\u0013fcR\u001910!4\t\u0011}t\u0013\u0011!a\u0001\u0003\u0007\fA\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016\u0004\u0013\u0001\u00027pG.,\"!!6\u0011\t\u0005]\u0017\u0011^\u0007\u0003\u00033TA!a7\u0002^\u0006)An\\2lg*!\u0011q\\Aq\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003G\f)/\u0001\u0003vi&d'BAAt\u0003\u0011Q\u0017M^1\n\t\u0005-\u0018\u0011\u001c\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002\r%tGj\\2l+\u0011\t\u00190!?\u0015\t\u0005U(1\u0002\t\u0005\u0003o\fI\u0010\u0004\u0001\u0005\u000f\u0005m(G1\u0001\u0002~\n\tA+\u0005\u0003\u0002\u0000\n\u0015\u0001c\u0001+\u0003\u0002%\u0019!1A+\u0003\u000f9{G\u000f[5oOB\u0019AKa\u0002\n\u0007\t%QKA\u0002B]fD\u0001B!\u00043\t\u0003\u0007!qB\u0001\u0004MVt\u0007#\u0002+\u0003\u0012\u0005U\u0018b\u0001B\n+\nAAHY=oC6,g(A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004w\ne\u0001b\u0002B\u000eg\u0001\u0007!QD\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B\u0010\u0005C\t\t'\u0004\u0002\u0002Z%!\u0011qLA-\u0003=\u0011X-\\8wKB\u000b'\u000f^5uS>tGcA>\u0003(!9!\u0011\u0006\u001bA\u0002\u0005\u0005\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011aJ,\u0007/\u0019:f\u001d>$&/\u00198tSR$\"Aa\f\u0011\u0007A\u0013\t$C\u0002\u00034%\u0013!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006I\u0002O]3qCJ,g)\u001a8dKB\u0013x\u000eZ;dKJ,\u0005o\\2i\u0003u\u0001(/\u001a9be\u0016Len\u0019:f[\u0016tG\u000f\u0015:pIV\u001cWM]#q_\u000eDG\u0003\u0003B\u001e\u00053\u0012iFa\u0019\u0011\u0011\tu\"q\tB'\u0005_qAAa\u0010\u0003D9\u00191N!\u0011\n\u0003YK1A!\u0012V\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0013\u0003L\t1Q)\u001b;iKJT1A!\u0012V!\u0011\u0011yE!\u0016\u000e\u0005\tE#\u0002\u0002B*\u0003K\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005/\u0012\tF\u0001\u0004FeJ|'o\u001d\u0005\b\u00057:\u0004\u0019AA\u0017\u0003=qWm\u001e+y]RKW.Z8vi6\u001b\bb\u0002B0o\u0001\u0007!\u0011M\u0001\u0016Kb\u0004Xm\u0019;fIB\u0013x\u000eZ;dKJ,\u0005o\\2i!\u0015!\u00161WA\t\u0011\u0019\u0011)g\u000ea\u0001m\u0006yQ\u000f\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007/A\rqe\u0016\u0004\u0018M]3Qe>$WoY3s\u0013\u0012\u0014v\u000e^1uS>tGC\u0003B\u0018\u0005W\u0012yG!\u001d\u0003t!1!Q\u000e\u001dA\u0002Y\fQB\\3x!J|G-^2fe&#\u0007b\u0002B.q\u0001\u0007\u0011Q\u0006\u0005\u0007\u0005KB\u0004\u0019\u0001<\t\u000f\tU\u0004\b1\u0001\u0002D\u0006y!/Z2pe\u0012d\u0015m\u001d;Fa>\u001c\u0007.\u0001\u000bqe\u0016\u0004\u0018M]3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0005_\u0011YH!#\t\u000f\tu\u0014\b1\u0001\u0003\u0000\u0005!\u0012\r\u001a3fIR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bA!!\u0003\b\u0006\u0005TB\u0001BB\u0015\u0011\u0011))!\u0017\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA0\u0005\u0007CaA!\u001a:\u0001\u00041\u0018\u0001\u00069sKB\f'/Z!c_J$xJ]\"p[6LG\u000f\u0006\u0004\u00030\t=%1\u0013\u0005\b\u0005#S\u0004\u0019AA \u0003!qWm^*uCR,\u0007B\u0002B3u\u0001\u0007a/A\bqe\u0016\u0004\u0018M]3D_6\u0004H.\u001a;f)\u0011\u0011yC!'\t\r\t\u00154\b1\u0001w\u0003-\u0001(/\u001a9be\u0016$U-\u00193\u00021%\u001c\bK]8ek\u000e,'/\u00129pG\",\u0005\u0010[1vgR,G-A\u000biCN\u0004VM\u001c3j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8\u0002'A\u0014X\r]1sKR\u0013\u0018M\\:ji&|g\u000eV8\u0015%\t=\"Q\u0015BT\u0005S\u0013iK!-\u00034\n]&1\u0018\u0005\b\u0005#{\u0004\u0019AA \u0011\u0019\u0011ig\u0010a\u0001m\"9!1V A\u0002\u0005E\u0011\u0001\u00038fo\u0016\u0003xn\u00195\t\u000f\t=v\b1\u0001\u0002\u0012\u0005aa.Z<MCN$X\t]8dQ\"9!1L A\u0002\u00055\u0002b\u0002B[\u007f\u0001\u0007!qP\u0001\u0013]\u0016<Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0003\u0004\u0003:~\u0002\rA^\u0001\u0015]\u0016<H\u000b\u001f8Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\t\r\t\u0015t\b1\u0001w\u0003Q\u0019w.\u001c9mKR,GK]1og&$\u0018n\u001c8U_R\u00191P!1\t\u000f\t\r\u0007\t1\u0001\u00030\u0005yAO]1og&$X*\u001a;bI\u0006$\u0018-\u0001\nwC2LG\r\u0015:pIV\u001cWM]#q_\u000eDG\u0003BAb\u0005\u0013DqAa1B\u0001\u0004\u0011y#\u0001\fwC2LG\r\u0015:pIV\u001cWM]#q_\u000eD')^7q)\u0011\t\u0019Ma4\t\u000f\t\r'\t1\u0001\u00030\u0005YB\u000f\u001b:poN#\u0018\r^3Ue\u0006t7/\u001b;j_:4\u0015-\u001b7ve\u0016$2a\u001fBk\u0011\u001d\u00119n\u0011a\u0001\u0005_\t!\u0003\u001e=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006Y\u0002/\u001a8eS:<GK]1og&$\u0018n\u001c8J]B\u0013xn\u001a:fgN\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002Q\u00061Q-];bYN$B!a1\u0003d\"9!Q\u001d$A\u0002\t\u0015\u0011\u0001\u0002;iCR\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003[A3\u0001\u0004Bw!\r\t'q^\u0005\u0004\u0005c\u0014'!\u00048p]RD'/Z1eg\u00064W\rC\u0003g\u0007\u0001\u0007\u0001\u000eC\u0003u\u0007\u0001\u0007a\u000fC\u0004\u0002\u000e\r\u0001\r!!\u0005\t\u000f\u0005%2\u00011\u0001\u0002.!1!Q`\u0002A\u0002Y\f\u0011\u0002^5nKN$\u0018-\u001c9\u0015\u001by\u001b\taa\u0001\u0004\u0006\r\u001d1\u0011BB\u0006\u0011\u00151G\u00011\u0001i\u0011\u0015!H\u00011\u0001w\u0011\u001d\ti\u0001\u0002a\u0001\u0003#Aq!!\u000b\u0005\u0001\u0004\ti\u0003C\u0004\u0002<\u0011\u0001\r!a\u0010\t\r\tuH\u00011\u0001w)Eq6qBB\t\u0007'\u0019)ba\u0006\u0004\u001a\rm1Q\u0004\u0005\u0006M\u0016\u0001\r\u0001\u001b\u0005\u0006i\u0016\u0001\rA\u001e\u0005\u0007\u0003\u0007)\u0001\u0019\u0001<\t\u000f\u00055Q\u00011\u0001\u0002\u0012!9\u0011qD\u0003A\u0002\u0005E\u0001bBA\u0015\u000b\u0001\u0007\u0011Q\u0006\u0005\b\u0003w)\u0001\u0019AA \u0011\u0019\u0011i0\u0002a\u0001m\u0006Y!-\u001f;f)>\u001cF/\u0019;f)\u0011\tyda\t\t\u000f\r\u0015b\u00011\u0001\u0004(\u0005!!-\u001f;f!\r!6\u0011F\u0005\u0004\u0007W)&\u0001\u0002\"zi\u0016\f\u0011#[:WC2LG\r\u0016:b]NLG/[8o)\u0019\t\u0019m!\r\u00046!911G\u0004A\u0002\u0005}\u0012\u0001C8mIN#\u0018\r^3\t\u000f\tEu\u00011\u0001\u0002@\u0005\u0019b/\u00197jIB\u0013XM^5pkN\u001cF/\u0019;fgV\u001111\b\t\bS\u000eu\u0012qHB!\u0013\r\u0019yD\u001d\u0002\u0004\u001b\u0006\u0004\b#B5\u0004D\u0005}\u0012bAA0e\u0006!b/\u00197jIB\u0013XM^5pkN\u001cF/\u0019;fg\u0002\n\u0001#[:Fa>\u001c\u0007.\u0012=iCV\u001cH/\u001a3\u0015\t\u0005\r71\n\u0005\b\u0003\u001bQ\u0001\u0019AA\t\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u00111\u0011\u000b\u0016\u0004m\u000eM3FAB+!\u0011\u00199f!\u0019\u000e\u0005\re#\u0002BB.\u0007;\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r}S+\u0001\u0006b]:|G/\u0019;j_:LAaa\u0019\u0004Z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long lastProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$9() {
        return -1L;
    }

    public static boolean isEpochExhausted(short s) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(s);
    }

    public static boolean isValidTransition(TransactionState transactionState, TransactionState transactionState2) {
        return TransactionMetadata$.MODULE$.isValidTransition(transactionState, transactionState2);
    }

    public static TransactionState byteToState(byte by) {
        return TransactionMetadata$.MODULE$.byteToState(by);
    }

    public static TransactionMetadata apply(String string, long l, long l2, short s, short s2, int n, TransactionState transactionState, long l3) {
        return TransactionMetadata$.MODULE$.apply(string, l, l2, s, s2, n, transactionState, l3);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long lastProducerId() {
        return this.lastProducerId;
    }

    public void lastProducerId_$eq(long x$1) {
        this.lastProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        Object object;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null || !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null || !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(68).append("Transaction metadata's current state is ").append(this.state()).append(", and its pending state is ").append(this.pendingState()).append(" ").toString()).append("while trying to remove partitions whose txn marker has been sent, this is not expected").toString());
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.lastProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), bumpedEpoch, (short)-1, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Left left;
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringBuilder(56).append("Cannot allocate any more producer epochs for producerId ").append(this.producerId()).toString());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            Right right2;
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Expected producer epoch ").append(expectedEpoch).append(" does not match current ").toString()).append(new StringBuilder(43).append("producer epoch ").append(this.producerEpoch()).append(" or previous producer epoch ").append(this.lastProducerEpoch()).toString()).toString());
                right2 = package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
            }
            right = right2;
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        if (right instanceof Right && (tuple2 = (Tuple2)right.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            left = package$.MODULE$.Right().apply((Object)this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp));
        } else if (right instanceof Left) {
            Errors err = (Errors)((Left)right).value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)right);
        }
        return left;
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch() : (short)-1, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), l, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        CompleteAbort$ newState = transactionState != null && transactionState.equals(prepareCommit$) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        this.hasFailedEpochFence_$eq(false);
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, short newLastEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(43).append("Preparing transaction state transition to ").append(newState).append(" ").toString()).append(new StringBuilder(33).append("while it already a pending state ").append(this.pendingState().get()).toString()).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Illegal new producer id ").append(newProducerId).toString());
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Illegal new producer epoch ").append(newEpoch).toString());
        }
        if (((SetOps)TransactionMetadata$.MODULE$.kafka$coordinator$transaction$TransactionMetadata$$validPreviousStates().apply((Object)newState)).contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, this.producerId(), newEpoch, newLastEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" prepare transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(72).append("Preparing transaction state transition to ").append(newState).append(" failed since the target state").toString()).append(new StringBuilder(53).append(" ").append(newState).append(" is not a valid previous state of the current state ").append(this.state()).toString()).toString());
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)this.pendingState().getOrElse((Function0 & Serializable)() -> {
            this.fatal((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append(this).append("'s transition to ").append(transitMetadata).append(" failed since pendingState is not defined: this should not happen").toString());
            throw new IllegalStateException(new StringBuilder(78).append(new StringBuilder(17).append("TransactionalId ").append(this.transactionalId()).append(" ").toString()).append("completing transaction state transition while it does not have a pending state").toString());
        });
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
            return;
        }
        if (Empty$.MODULE$.equals(toState)) {
            if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                this.producerEpoch_$eq(transitMetadata.producerEpoch());
                this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                this.producerId_$eq(transitMetadata.producerId());
                this.lastProducerId_$eq(transitMetadata.lastProducerId());
            }
        } else if (Ongoing$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
            }
        } else {
            boolean bl = PrepareAbort$.MODULE$.equals(toState) ? true : PrepareCommit$.MODULE$.equals(toState);
            if (bl) {
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(toState) ? true : CompleteCommit$.MODULE$.equals(toState);
                if (bl2) {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                    } else {
                        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                        this.topicPartitions().clear();
                    }
                } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else {
                    if (Dead$.MODULE$.equals(toState)) {
                        throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(55).append("TransactionalId ").append(this.transactionalId()).append(" is trying to complete a transition to ").toString()).append(new StringBuilder(95).append(toState).append(". This means that the transactionalId was being expired, and the only acceptable completion of ").toString()).append(new StringBuilder(100).append("this operation is to remove the transaction metadata from the cache, not to persist the ").append(toState).append(" in the log.").toString()).toString());
                    }
                    throw new MatchError((Object)toState);
                }
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("TransactionalId ").append(this.transactionalId()).append(" complete transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append(this.toString()).append("'s transition to ").append(txnTransitMetadata).append(" failed: this should not happen").toString());
        throw new IllegalStateException(new StringBuilder(26).append(new StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" failed transition to state ").append(txnTransitMetadata).append(" ").toString()).append("due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return new StringBuilder(20).append("TransactionMetadata(").append(new StringBuilder(18).append("transactionalId=").append(this.transactionalId()).append(", ").toString()).append(new StringBuilder(13).append("producerId=").append(this.producerId()).append(", ").toString()).append(new StringBuilder(16).append("producerEpoch=").append(this.producerEpoch()).append(", ").toString()).append(new StringBuilder(15).append("txnTimeoutMs=").append(this.txnTimeoutMs()).append(", ").toString()).append(new StringBuilder(8).append("state=").append(this.state()).append(", ").toString()).append(new StringBuilder(15).append("pendingState=").append(this.pendingState()).append(", ").toString()).append(new StringBuilder(18).append("topicPartitions=").append(this.topicPartitions()).append(", ").toString()).append(new StringBuilder(20).append("txnStartTimestamp=").append(this.txnStartTimestamp()).append(", ").toString()).append(new StringBuilder(24).append("txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp()).append(")").toString()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)that;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.lastProducerEpoch() != transactionMetadata.lastProducerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}))).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public TransactionMetadata(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.lastProducerId = lastProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

