/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractControllerMutationQuota;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\r3A\u0001C\u0005\u0001\u001d!A1\u0003\u0001BC\u0002\u0013%A\u0003\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u0016\u0011!\u0019\u0003A!b\u0001\n\u0013!\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u000b1\u0002A\u0011A\u0017\t\u000bE\u0002A\u0011\t\u001a\t\u000be\u0002A\u0011\t\u001e\u0003;M#(/[2u\u0007>tGO]8mY\u0016\u0014X*\u001e;bi&|g.U;pi\u0006T!AC\u0006\u0002\rM,'O^3s\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0003\u0001=\u0001\"\u0001E\t\u000e\u0003%I!AE\u0005\u0003?\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018-\u0001\u0003uS6,W#A\u000b\u0011\u0005Y\u0001S\"A\f\u000b\u0005aI\u0012!B;uS2\u001c(B\u0001\u000e\u001c\u0003\u0019\u0019w.\\7p]*\u0011A\u0002\b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"/\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003-\tXo\u001c;b'\u0016t7o\u001c:\u0016\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001K\r\u0002\u000f5,GO]5dg&\u0011!f\n\u0002\u0007'\u0016t7o\u001c:\u0002\u0019E,x\u000e^1TK:\u001cxN\u001d\u0011\u0002\rqJg.\u001b;?)\rqs\u0006\r\t\u0003!\u0001AQaE\u0003A\u0002UAQaI\u0003A\u0002\u0015\n!\"[:Fq\u000e,W\rZ3e+\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$a\u0002\"p_2,\u0017M\\\u0001\u0007e\u0016\u001cwN\u001d3\u0015\u0005mr\u0004C\u0001\u001b=\u0013\tiTG\u0001\u0003V]&$\b\"B \b\u0001\u0004\u0001\u0015a\u00029fe6LGo\u001d\t\u0003i\u0005K!AQ\u001b\u0003\r\u0011{WO\u00197f\u0001")
public class StrictControllerMutationQuota
extends AbstractControllerMutationQuota {
    private final Time time;
    private final Sensor quotaSensor;

    private Time time() {
        return this.time;
    }

    private Sensor quotaSensor() {
        return this.quotaSensor;
    }

    @Override
    public boolean isExceeded() {
        return this.lastThrottleTimeMs() > 0L;
    }

    @Override
    public void record(double permits) {
        long timeMs = this.time().milliseconds();
        try {
            Sensor sensor = this.quotaSensor();
            synchronized (sensor) {
                this.quotaSensor().checkQuotas(timeMs);
                this.quotaSensor().record(permits, timeMs, false);
            }
        }
        catch (QuotaViolationException e) {
            this.updateThrottleTime(e, timeMs);
            throw new ThrottlingQuotaExceededException((int)this.lastThrottleTimeMs(), Errors.THROTTLING_QUOTA_EXCEEDED.message());
        }
    }

    public StrictControllerMutationQuota(Time time, Sensor quotaSensor) {
        this.time = time;
        this.quotaSensor = quotaSensor;
        super(time);
    }
}

