/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import kafka.admin.LeaderElectionCommand$;
import kafka.admin.LeaderElectionCommandTest$;
import kafka.common.AdminCommandFailedException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\u000f\u001f\u0005\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001A\u0002\u0013\u0005q\u0006C\u0004?\u0001\u0001\u0007I\u0011A \t\r\u0019\u0003\u0001\u0015)\u00031\u0011\u001d9\u0005A1A\u0005\u0002!Ca\u0001\u0014\u0001!\u0002\u0013I\u0005bB'\u0001\u0005\u0004%\t\u0001\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B%\t\u000f=\u0003!\u0019!C\u0001\u0011\"1\u0001\u000b\u0001Q\u0001\n%CQ!\u0015\u0001\u0005BICQ\u0001\u0019\u0001\u0005BICQ!\u001a\u0001\u0005\u0002ICQA\u001b\u0001\u0005\u0002ICQ\u0001\u001c\u0001\u0005\u0002ICQA\u001c\u0001\u0005\u0002ICQ\u0001\u001d\u0001\u0005\u0002ICQA\u001d\u0001\u0005\u0002ICQ\u0001\u001e\u0001\u0005\u0002ICQA\u001e\u0001\u0005\u0002ICQ\u0001\u001f\u0001\u0005\u0002ICQA\u001f\u0001\u0005\u0002I;Q\u0001 \u0010\t\u0002u4Q!\b\u0010\t\u0002yDaA\u000b\r\u0005\u0002\u0005\u0015\u0001bBA\u00041\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003sAB\u0011AA\u001e\u0011\u001d\ty\u0004\u0007C\u0001\u0003\u0003\u0012\u0011\u0004T3bI\u0016\u0014X\t\\3di&|gnQ8n[\u0006tG\rV3ti*\u0011q\u0004I\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002C\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001%!\t)\u0003&D\u0001'\u0015\t9\u0003%\u0001\u0002{W&\u0011\u0011F\n\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005a\u0003CA\u0017\u0001\u001b\u0005q\u0012aB:feZ,'o]\u000b\u0002aA\u0019\u0011G\u000e\u001d\u000e\u0003IR!a\r\u001b\u0002\u0015\r|G\u000e\\3di&|gNC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9$GA\u0002TKF\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0011\u0002\rM,'O^3s\u0013\ti$HA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aC:feZ,'o]0%KF$\"\u0001\u0011#\u0011\u0005\u0005\u0013U\"\u0001\u001b\n\u0005\r#$\u0001B+oSRDq!R\u0002\u0002\u0002\u0003\u0007\u0001'A\u0002yIE\n\u0001b]3sm\u0016\u00148\u000fI\u0001\bEJ|7.\u001a:2+\u0005I\u0005CA!K\u0013\tYEGA\u0002J]R\f\u0001B\u0019:pW\u0016\u0014\u0018\u0007I\u0001\bEJ|7.\u001a:3\u0003!\u0011'o\\6feJ\u0002\u0013a\u00022s_.,'oM\u0001\tEJ|7.\u001a:4A\u0005)1/\u001a;VaR\t\u0001\t\u000b\u0002\f)B\u0011QKX\u0007\u0002-*\u0011q\u000bW\u0001\u0004CBL'BA-[\u0003\u001dQW\u000f]5uKJT!a\u0017/\u0002\u000b),h.\u001b;\u000b\u0003u\u000b1a\u001c:h\u0013\tyfK\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u0019\t\u0004\"!V2\n\u0005\u00114&!C!gi\u0016\u0014X)Y2i\u0003U!Xm\u001d;BY2$v\u000e]5d!\u0006\u0014H/\u001b;j_:D#!D4\u0011\u0005UC\u0017BA5W\u0005\u0011!Vm\u001d;\u0002%Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0015\u0003\u001d\u001d\f!\u0003^3tiB\u000bG\u000f\u001b+p\u0015N|gNR5mK\"\u0012qbZ\u0001\u001di\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8oQ\t\u0001r-A\ruKN$Hk\u001c9jG^KG\u000f[8viB\u000b'\u000f^5uS>t\u0007FA\th\u0003e!Xm\u001d;QCJ$\u0018\u000e^5p]^KG\u000f[8viR{\u0007/[2)\u0005I9\u0017!\u0006;fgR$v\u000e]5d\t>,7OT8u\u000bbL7\u000f\u001e\u0015\u0003'\u001d\fq\u0003^3ti6K7o]5oO\u0016cWm\u0019;j_:$\u0016\u0010]3)\u0005Q9\u0017A\t;fgRl\u0015n]:j]\u001e$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cV\r\\3di&|g\u000e\u000b\u0002\u0016O\u0006\tB/Z:u\u0013:4\u0018\r\\5e\u0005J|7.\u001a:)\u0005Y9\u0017!\u0007'fC\u0012,'/\u00127fGRLwN\\\"p[6\fg\u000e\u001a+fgR\u0004\"!\f\r\u0014\u0005ay\bcA!\u0002\u0002%\u0019\u00111\u0001\u001b\u0003\r\u0005s\u0017PU3g)\u0005i\u0018\u0001D2sK\u0006$XmQ8oM&<G\u0003BA\u0006\u0003o\u0001\u0002\"!\u0004\u0002\u001c\u0005\u0005\u0012q\u0005\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u0012Qj!!a\u0005\u000b\u0007\u0005U!%\u0001\u0004=e>|GOP\u0005\u0004\u00033!\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!aA'ba*\u0019\u0011\u0011\u0004\u001b\u0011\t\u00055\u00111E\u0005\u0005\u0003K\tyB\u0001\u0004TiJLgn\u001a\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006LA!!\u000e\u0002,\t1qJ\u00196fGRDQA\f\u000eA\u0002A\n\u0001CY8piN$(/\u00199TKJ4XM]:\u0015\t\u0005\u0005\u0012Q\b\u0005\u0006]m\u0001\r\u0001M\u0001\u0017i\u0016l\u0007\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gNR5mKR!\u00111IA*!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nAAZ5mK*!\u0011QJA\u0018\u0003\rq\u0017n\\\u0005\u0005\u0003#\n9E\u0001\u0003QCRD\u0007bBA+9\u0001\u0007\u0011qK\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBA\u0007\u00033\ni&\u0003\u0003\u0002\\\u0005}!aA*fiB!\u0011qLA6\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014AB2p[6|gNC\u0002\"\u0003OR1!!\u001b]\u0003\u0019\t\u0007/Y2iK&!\u0011QNA1\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004")
public final class LeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int broker1;
    private final int broker2;
    private final int broker3;

    public static Path tempTopicPartitionFile(Set<TopicPartition> set) {
        return LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile(set);
    }

    public static String bootstrapServers(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.bootstrapServers(seq);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return LeaderElectionCommandTest$.MODULE$.createConfig(seq);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable)config -> {
            void createServer_time;
            Time time;
            config.setProperty("auto.leader.rebalance.enable", "false");
            config.setProperty("controlled.shutdown.enable", "true");
            config.setProperty("controlled.shutdown.max.retries", "1");
            config.setProperty("controlled.shutdown.retry.backoff.ms", "1000");
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(config);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        })));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAllTopicPartition() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testAllTopicPartition$1(this, resource_resource);
        }
    }

    @Test
    public void testTopicPartition() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testTopicPartition$1(this, resource_resource);
        }
    }

    @Test
    public void testPathToJsonFile() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testPathToJsonFile$1(this, resource_resource);
        }
    }

    @Test
    public void testPreferredReplicaElection() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testPreferredReplicaElection$1(this, resource_resource);
        }
    }

    @Test
    public void testTopicWithoutPartition() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "unclean", "--topic", "some-topic"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Missing required option(s)"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" partition"));
    }

    @Test
    public void testPartitionWithoutTopic() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "unclean", "--all-topic-partitions", "--partition", "0"}));
        Assertions.assertEquals((Object)"Option partition is only allowed if topic is used", (Object)e.getMessage());
    }

    @Test
    public void testTopicDoesNotExist() {
        Assertions.assertTrue((boolean)(((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "preferred", "--topic", "unknown-topic-name", "--partition", "0"}))).getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
    }

    @Test
    public void testMissingElectionType() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--topic", "some-topic", "--partition", "0"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Missing required option(s)"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" election-type"));
    }

    @Test
    public void testMissingTopicPartitionSelection() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "preferred"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("One and only one of the following options is required: "));
        Assertions.assertTrue((boolean)e.getMessage().contains(" all-topic-partitions"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" topic"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" path-to-json-file"));
    }

    @Test
    public void testInvalidBroker() {
        Assertions.assertTrue((boolean)(((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", "example.com:1234", "--election-type", "unclean", "--all-topic-partitions"}, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds()))).getCause() instanceof TimeoutException));
    }

    public static final /* synthetic */ void $anonfun$testAllTopicPartition$1(LeaderElectionCommandTest $this, Admin client) {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--all-topic-partitions"});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    public static final /* synthetic */ void $anonfun$testTopicPartition$1(LeaderElectionCommandTest $this, Admin client) {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--topic", topic, "--partition", Integer.toString(partition)});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    public static final /* synthetic */ void $anonfun$testPathToJsonFile$1(LeaderElectionCommandTest $this, Admin client) {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--path-to-json-file", ((Object)topicPartitionPath).toString()});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplicaElection$1(LeaderElectionCommandTest $this, Admin client) {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
        ((KafkaServer)$this.servers().apply($this.broker2())).startup();
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2()}))));
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "preferred", "--all-topic-partitions"});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
    }

    public LeaderElectionCommandTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
    }

    public static final /* synthetic */ Object $anonfun$testAllTopicPartition$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testAllTopicPartition$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTopicPartition$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testTopicPartition$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPathToJsonFile$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testPathToJsonFile$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPreferredReplicaElection$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testPreferredReplicaElection$1($this, client);
        return BoxedUnit.UNIT;
    }
}

