/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.stream.Stream;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.AssignmentState;
import kafka.cluster.AssignmentStateTest$;
import kafka.cluster.SimpleAssignmentState;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005E<Qa\u0002\u0005\t\u000251Qa\u0004\u0005\t\u0002AAQaF\u0001\u0005\u0002aAQ!G\u0001\u0005\u0002i1Aa\u0004\u0005\u0001g!)q\u0003\u0002C\u0001o!)\u0011\b\u0002C\u0001u\u0005\u0019\u0012i]:jO:lWM\u001c;Ti\u0006$X\rV3ti*\u0011\u0011BC\u0001\bG2,8\u000f^3s\u0015\u0005Y\u0011!B6bM.\f7\u0001\u0001\t\u0003\u001d\u0005i\u0011\u0001\u0003\u0002\u0014\u0003N\u001c\u0018n\u001a8nK:$8\u000b^1uKR+7\u000f^\n\u0003\u0003E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u000e\u0003)\u0001\u0018M]1nKR,'o]\u000b\u00027A\u0019AdI\u0013\u000e\u0003uQ!AH\u0010\u0002\rM$(/Z1n\u0015\t\u0001\u0013%\u0001\u0003vi&d'\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003Iu\u0011aa\u0015;sK\u0006l\u0007C\u0001\u00142\u001b\u00059#B\u0001\u0015*\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001\u0016,\u0003\u0019\u0001\u0018M]1ng*\u0011A&L\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqs&A\u0003kk:LGOC\u00011\u0003\ry'oZ\u0005\u0003e\u001d\u0012\u0011\"\u0011:hk6,g\u000e^:\u0014\u0005\u0011!\u0004C\u0001\b6\u0013\t1\u0004BA\u000bBEN$(/Y2u!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u0015\u0003a\u0002\"A\u0004\u0003\u0002;Q,7\u000f\u001e)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$8\u000b^1ukN$ra\u000f S)ZC\u0006\r\u0005\u0002\u0013y%\u0011Qh\u0005\u0002\u0005+:LG\u000fC\u0003@\r\u0001\u0007\u0001)A\u0002jgJ\u00042!Q%M\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002F\u0019\u00051AH]8pizJ\u0011\u0001F\u0005\u0003\u0011N\tq\u0001]1dW\u0006<W-\u0003\u0002K\u0017\n!A*[:u\u0015\tA5\u0003\u0005\u0002N!6\taJ\u0003\u0002PC\u0005!A.\u00198h\u0013\t\tfJA\u0004J]R,w-\u001a:\t\u000bM3\u0001\u0019\u0001!\u0002\u0011I,\u0007\u000f\\5dCNDQ!\u0016\u0004A\u0002\u0001\u000ba!\u00193eS:<\u0007\"B,\u0007\u0001\u0004\u0001\u0015\u0001\u0003:f[>4\u0018N\\4\t\u000be3\u0001\u0019\u0001.\u0002\u0011=\u0014\u0018nZ5oC2\u00042!Q.^\u0013\ta6JA\u0002TKF\u0004\"A\u00050\n\u0005}\u001b\"aA%oi\")\u0011M\u0002a\u0001E\u0006\t\u0012n]+oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3\u0011\u0005I\u0019\u0017B\u00013\u0014\u0005\u001d\u0011un\u001c7fC:DCA\u00024jUB\u0011aeZ\u0005\u0003Q\u001e\u0012A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d\u0013a[\u0011\u00023!\u0012a!\u001c\t\u0003]>l\u0011!K\u0005\u0003a&\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0001")
public class AssignmentStateTest
extends AbstractPartitionTest {
    public static Stream<Arguments> parameters() {
        return AssignmentStateTest$.MODULE$.parameters();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testPartitionAssignmentStatus(List<Integer> isr, List<Integer> replicas, List<Integer> adding, List<Integer> removing, Seq<Object> original, boolean isUnderReplicated) {
        boolean isReassigning;
        int controllerEpoch = 3;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava(isr).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(replicas).asJava()).setIsNew(false);
        if (adding.nonEmpty()) {
            leaderState.setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(adding).asJava());
        }
        if (removing.nonEmpty()) {
            leaderState.setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(removing).asJava());
        }
        boolean bl = isReassigning = adding.nonEmpty() || removing.nonEmpty();
        if (original.nonEmpty()) {
            this.partition().assignmentState_$eq((AssignmentState)new SimpleAssignmentState(original));
        }
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning), (Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isReassigning()));
        if (adding.nonEmpty()) {
            adding.foreach((Function1 & Serializable)r -> {
                AssignmentStateTest.$anonfun$testPartitionAssignmentStatus$1(this, r);
                return BoxedUnit.UNIT;
            });
        }
        if (adding.contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId()))) {
            Assertions.assertTrue((boolean)this.partition().isAddingLocalReplica());
        } else {
            Assertions.assertFalse((boolean)this.partition().isAddingLocalReplica());
        }
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isUnderReplicated), (Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUnderReplicated()));
    }

    public static final /* synthetic */ void $anonfun$testPartitionAssignmentStatus$1(AssignmentStateTest $this, Integer r) {
        Assertions.assertTrue((boolean)$this.partition().isAddingReplica(Predef$.MODULE$.Integer2int(r)));
    }
}

