/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.cluster.Partition;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ZkMetadataCache;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013\u0005Q\u0005\u0003\u00040\u0001\u0001\u0006IA\n\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0011\u0019Q\u0004\u0001)A\u0005e!91\b\u0001b\u0001\n\u0003a\u0004BB\"\u0001A\u0003%Q\bC\u0004E\u0001\t\u0007I\u0011A#\t\r5\u0003\u0001\u0015!\u0003G\u0011\u001dq\u0005A1A\u0005\u0002=Ca\u0001\u0016\u0001!\u0002\u0013\u0001\u0006bB+\u0001\u0005\u0004%\tA\u0016\u0005\u0007C\u0002\u0001\u000b\u0011B,\t\u000b\t\u0004A\u0011A2\t\u000bQ\u0004A\u0011A2\t\u000be\u0004A\u0011A2\t\u000bm\u0004A\u0011\u0002?\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\ta\u0002*[4io\u0006$XM]7be.\u0004VM]:jgR,gnY3UKN$(BA\u000b\u0017\u0003\u0019\u0019XM\u001d<fe*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002)\u000591m\u001c8gS\u001e\u001cX#\u0001\u0014\u0011\u0007\u001dRC&D\u0001)\u0015\tIC$\u0001\u0006d_2dWm\u0019;j_:L!a\u000b\u0015\u0003\u0007M+\u0017\u000f\u0005\u0002$[%\u0011a\u0006\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:4\u0017nZ:!\u0003\u0015!x\u000e]5d+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011a\u0017M\\4\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003A\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180F\u0001>!\tq\u0014)D\u0001@\u0015\t\u0001E#\u0001\u0005nKR\fG-\u0019;b\u0013\t\u0011uH\u0001\fDC\u000eDW\rZ\"p]\u001aLwMU3q_NLGo\u001c:z\u0003E\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\fY><W*\u00198bO\u0016\u00148/F\u0001G!\r9#f\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015Z\t1\u0001\\8h\u0013\ta\u0015J\u0001\u0006M_\u001el\u0015M\\1hKJ\fA\u0002\\8h\u001b\u0006t\u0017mZ3sg\u0002\nQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d7/F\u0001Q!\r9#&\u0015\t\u0003GIK!a\u0015\u000b\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Yawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYN\u0004\u0013aD1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:\u0016\u0003]\u0003\"\u0001\u00170\u000f\u0005ecV\"\u0001.\u000b\u0005m3\u0012!B;uS2\u001c\u0018BA/[\u0003%!Vm\u001d;Vi&d7/\u0003\u0002`A\n\u0019Rj\\2l\u00032$XM]%te6\u000bg.Y4fe*\u0011QLW\u0001\u0011C2$XM]%te6\u000bg.Y4fe\u0002\n\u0001\u0002^3be\u0012|wO\u001c\u000b\u0002IB\u00111$Z\u0005\u0003Mr\u0011A!\u00168ji\"\u0012a\u0002\u001b\t\u0003SJl\u0011A\u001b\u0006\u0003W2\f1!\u00199j\u0015\tig.A\u0004kkBLG/\u001a:\u000b\u0005=\u0004\u0018!\u00026v]&$(\"A9\u0002\u0007=\u0014x-\u0003\u0002tU\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001,i\u0016\u001cH\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007+\u001a:tSN$XM\\2f'&tw\r\\3QCJ$\u0018\u000e^5p]\"\u0012qB\u001e\t\u0003S^L!\u0001\u001f6\u0003\tQ+7\u000f^\u0001/i\u0016\u001cH\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007+\u001a:tSN$XM\\2f\u001bVdG/\u001b9mKB\u000b'\u000f^5uS>t7\u000f\u000b\u0002\u0011m\u00061\u0011\r\u001d9f]\u0012$B\u0001Z?\u0002\f!)a0\u0005a\u0001\u007f\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\f\u0002\u000f\rdWo\u001d;fe&!\u0011\u0011BA\u0002\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u000eE\u0001\r!a\u0004\u0002\u000b\r|WO\u001c;\u0011\u0007m\t\t\"C\u0002\u0002\u0014q\u00111!\u00138u\u0003\u0019Aw/\u001c$peRA\u0011\u0011DA\u0010\u0003S\ty\u0004E\u0002\u001c\u00037I1!!\b\u001d\u0005\u0011auN\\4\t\u000f\u0005\u0005\"\u00031\u0001\u0002$\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bcA\u0012\u0002&%\u0019\u0011q\u0005\u000b\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"1\u0001G\u0005a\u0001\u0003W\u0001B!!\f\u0002<9!\u0011qFA\u001c!\r\t\t\u0004H\u0007\u0003\u0003gQ1!!\u000e\u0019\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\b\u000f\u0002\rA\u0013X\rZ3g\u0013\rI\u0014Q\b\u0006\u0004\u0003sa\u0002B\u0002@\u0013\u0001\u0004\ty\u0001")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    private final String topic;
    private final CachedConfigRepository configRepository = new CachedConfigRepository();
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1 & Serializable)config -> {
        MockTime mockTime;
        CachedConfigRepository cachedConfigRepository;
        LogConfig logConfig;
        Seq x$12 = (Seq)config.logDirs().map((Function1 & Serializable)x$1 -> new File((String)x$1));
        CleanerConfig x$2 = new CleanerConfig(1, 0x400000L, 0.9, 0x100000, 0x2000000, Double.MAX_VALUE, 15000L, true, "MD5");
        LogConfig logConfig2 = logConfig = LogConfig$.MODULE$.apply();
        logConfig = null;
        LogConfig x$3 = logConfig2;
        CachedConfigRepository cachedConfigRepository2 = cachedConfigRepository = new CachedConfigRepository();
        cachedConfigRepository = null;
        CachedConfigRepository x$4 = cachedConfigRepository2;
        MockTime mockTime2 = mockTime = new MockTime();
        mockTime = null;
        MockTime x$5 = mockTime2;
        return TestUtils$.MODULE$.createLogManager((Seq<File>)x$12, x$3, (ConfigRepository)x$4, x$2, x$5);
    });
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1 & Serializable)config -> new LogDirFailureChannel(config.logDirs().size()));
    private final TestUtils.MockAlterIsrManager alterIsrManager = new TestUtils.MockAlterIsrManager();

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public CachedConfigRepository configRepository() {
        return this.configRepository;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    @AfterEach
    public void teardown() {
        this.logManagers().foreach((Function1 & Serializable)manager -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$1(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        KafkaScheduler scheduler = new KafkaScheduler(2, "kafka-scheduler-", true);
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, "");
        int zkMetadataCache_brokerId = ((KafkaConfig)this.configs().head()).brokerId();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, (Option)None$.MODULE$, (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), quotaManager, new BrokerTopicStats(), (MetadataCache)new ZkMetadataCache(zkMetadataCache_brokerId), (LogDirFailureChannel)this.logDirFailureChannels().head(), (AlterIsrManager)this.alterIsrManager(), (ConfigRepository)this.configRepository(), (Option)None$.MODULE$);
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.createPartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$1 = new TopicPartition(this.topic(), 0);
            boolean x$2 = qual$1.getOrCreateLog$default$2();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            Log log0 = qual$1.getOrCreateLog(x$1, x$2, x$3);
            partition0.setLog(log0, false);
            partition0.updateAssignmentAndIsr((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId(), ((KafkaConfig)this.configs().last()).brokerId()})), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().head()).brokerId()})), (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty());
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
            partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assertions.assertEquals((long)log0.highWatermark(), (long)fooPartition0Hw);
        }
        finally {
            replicaManager.shutdown(false);
            quotaManager.shutdown();
            metrics.close();
            scheduler.shutdown();
        }
    }

    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        KafkaScheduler scheduler = new KafkaScheduler(2, "kafka-scheduler-", true);
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, "");
        int zkMetadataCache_brokerId = ((KafkaConfig)this.configs().head()).brokerId();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, (Option)None$.MODULE$, (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), quotaManager, new BrokerTopicStats(), (MetadataCache)new ZkMetadataCache(zkMetadataCache_brokerId), (LogDirFailureChannel)this.logDirFailureChannels().head(), (AlterIsrManager)this.alterIsrManager(), (ConfigRepository)this.configRepository(), (Option)None$.MODULE$);
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.createPartition(t1p0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            boolean x$2 = qual$1.getOrCreateLog$default$2();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            Log topic1Log0 = qual$1.getOrCreateLog(t1p0, x$2, x$3);
            topic1Partition0.setLog(topic1Log0, false);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)topic1Log0.highWatermark(), (long)topic1Partition0Hw);
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(5L);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)5L, (long)topic1Log0.highWatermark());
            Assertions.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.createPartition(t2p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            boolean x$5 = qual$2.getOrCreateLog$default$2();
            boolean x$6 = qual$2.getOrCreateLog$default$3();
            Log topic2Log0 = qual$2.getOrCreateLog(t2p0, x$5, x$6);
            topic2Partition0.setLog(topic2Log0, false);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assertions.assertEquals((long)topic2Log0.highWatermark(), (long)topic2Partition0Hw);
            this.append(topic2Partition0, 15);
            topic2Partition0.localLogOrException().updateHighWatermark(15L);
            Assertions.assertEquals((long)15L, (long)topic2Log0.highWatermark());
            this.append(topic1Partition0, 5);
            topic1Partition0.localLogOrException().updateHighWatermark(10L);
            Assertions.assertEquals((long)10L, (long)topic1Log0.highWatermark());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assertions.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assertions.assertEquals((long)10L, (long)topic1Partition0Hw);
        }
        finally {
            replicaManager.shutdown(false);
            quotaManager.shutdown();
            metrics.close();
            scheduler.shutdown();
        }
    }

    private void append(Partition partition, int count) {
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)i -> HighwatermarkPersistenceTest.$anonfun$append$1(BoxesRunTime.unboxToInt((Object)i))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        Log qual$1 = partition.localLogOrException();
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        qual$1.appendAsLeader(records, 0, x$3, x$4);
    }

    private long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$teardown$2(File dir) {
        Utils.delete((File)dir);
    }

    public static final /* synthetic */ void $anonfun$teardown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable)dir -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$2(dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$append$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

