/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeadershipChangeHandler;
import kafka.server.LogDirFailureChannel;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.RaftReplicaChangeDelegate;
import kafka.server.RaftReplicaManager;
import kafka.server.ReplicaManager;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MetadataBroker;
import kafka.server.metadata.MetadataBrokers;
import kafka.server.metadata.MetadataImage;
import kafka.server.metadata.MetadataImageBuilder;
import kafka.server.metadata.MetadataPartition;
import kafka.server.metadata.MetadataPartition$;
import kafka.server.metadata.RaftMetadataCache;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t}g\u0001\u0002%J\u00019CQ!\u0016\u0001\u0005\u0002YC\u0011\"\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002.\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013y\u0006\"C3\u0001\u0001\u0004\u0005\t\u0015)\u0003\\\u0011%1\u0007\u00011AA\u0002\u0013%q\rC\u0005l\u0001\u0001\u0007\t\u0019!C\u0005Y\"Ia\u000e\u0001a\u0001\u0002\u0003\u0006K\u0001\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0003q\u0011\u00199\b\u0001)A\u0005c\"9\u0001\u0010\u0001b\u0001\n\u0013I\bbBA\u0007\u0001\u0001\u0006IA\u001f\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0002C\u0006\u00020\u0001\u0001\r\u00111A\u0005\n\u0005E\u0002bCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003'A\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003wA1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u00111\u000b\u0001A\u0002\u0003\u0007I\u0011BA+\u0011-\tI\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0014\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011Q\f\u0005\f\u0003K\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0007C\u0006\u0002l\u0001\u0001\r\u0011!Q!\n\u0005}\u0003\"CA7\u0001\t\u0007I\u0011BA8\u0011!\t9\b\u0001Q\u0001\n\u0005E\u0004\"CA=\u0001\t\u0007I\u0011BA>\u0011!\t\u0019\t\u0001Q\u0001\n\u0005u\u0004\"CAC\u0001\t\u0007I\u0011BA8\u0011!\t9\t\u0001Q\u0001\n\u0005E\u0004\"CAE\u0001\t\u0007I\u0011BA>\u0011!\tY\t\u0001Q\u0001\n\u0005u\u0004\"CAG\u0001\t\u0007I\u0011BAH\u0011!\t\t\u000b\u0001Q\u0001\n\u0005E\u0005\"CAR\u0001\t\u0007I\u0011BAS\u0011!\ty\u000b\u0001Q\u0001\n\u0005\u001d\u0006\"CAY\u0001\t\u0007I\u0011BA8\u0011!\t\u0019\f\u0001Q\u0001\n\u0005E\u0004\"CA[\u0001\t\u0007I\u0011BA8\u0011!\t9\f\u0001Q\u0001\n\u0005E\u0004\"CA]\u0001\t\u0007I\u0011BA^\u0011!\t\u0019\r\u0001Q\u0001\n\u0005u\u0006\"CAc\u0001\t\u0007I\u0011BA^\u0011!\t9\r\u0001Q\u0001\n\u0005u\u0006\"CAe\u0001\t\u0007I\u0011BAf\u0011!\t9\u000e\u0001Q\u0001\n\u00055\u0007\"CAm\u0001\t\u0007I\u0011BAf\u0011!\tY\u000e\u0001Q\u0001\n\u00055\u0007\"CAo\u0001\t\u0007I\u0011BAp\u0011!\t9\u000f\u0001Q\u0001\n\u0005\u0005\b\"CAu\u0001\t\u0007I\u0011BAv\u0011!\t\u0019\u0010\u0001Q\u0001\n\u00055\b\"CA{\u0001\t\u0007I\u0011BAv\u0011!\t9\u0010\u0001Q\u0001\n\u00055\bbCA}\u0001\u0001\u0007\t\u0019!C\u0005\u0003wD1Ba\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0006!Y!\u0011\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA\u007f\u0011-\u0011Y\u0001\u0001a\u0001\u0002\u0004%IA!\u0004\t\u0017\tM\u0002\u00011AA\u0002\u0013%!Q\u0007\u0005\f\u0005s\u0001\u0001\u0019!A!B\u0013\u0011y\u0001C\u0006\u0003<\u0001\u0001\r\u00111A\u0005\n\tu\u0002b\u0003B#\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u000fB1Ba\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003@!9!Q\n\u0001\u0005\u0002\t=\u0003b\u0002B4\u0001\u0011\u0005!q\n\u0005\b\u0005c\u0002A\u0011\u0001B:\u0011\u001d\u0011Y\b\u0001C\u0001\u0005\u001fBqA!\"\u0001\t\u0003\u0011y\u0005C\u0004\u0003\n\u0002!\tAa\u0014\t\u000f\t5\u0005\u0001\"\u0003\u0003\u0010\"9!q\u0017\u0001\u0005\n\te\u0006b\u0002Bc\u0001\u0011%!q\u0019\u0005\b\u0005/\u0004A\u0011\u0002Bm\u0005Y\u0011\u0016M\u001a;SKBd\u0017nY1NC:\fw-\u001a:UKN$(B\u0001&L\u0003\u0019\u0019XM\u001d<fe*\tA*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0005C\u0001)T\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002/B\u0011\u0001\fA\u0007\u0002\u0013\u0006y\u0011\r\u001c;fe&\u001b(/T1oC\u001e,'/F\u0001\\!\tAF,\u0003\u0002^\u0013\ny\u0011\t\u001c;fe&\u001b(/T1oC\u001e,'/A\nbYR,'/S:s\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002aGB\u0011\u0001+Y\u0005\u0003EF\u0013A!\u00168ji\"9AmAA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005\u0001\u0012\r\u001c;fe&\u001b(/T1oC\u001e,'\u000fI\u0001\u0007G>tg-[4\u0016\u0003!\u0004\"\u0001W5\n\u0005)L%aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\t\u0001W\u000eC\u0004e\r\u0005\u0005\t\u0019\u00015\u0002\u000f\r|gNZ5hA\u0005\u00012m\u001c8gS\u001e\u0014V\r]8tSR|'/_\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011A/S\u0001\t[\u0016$\u0018\rZ1uC&\u0011ao\u001d\u0002\u0017\u0007\u0006\u001c\u0007.\u001a3D_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t2m\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\u0011\u0002\u000f5,GO]5dgV\t!\u0010E\u0002|\u0003\u0013i\u0011\u0001 \u0006\u0003qvT!A`@\u0002\r\r|W.\\8o\u0015\ra\u0015\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000f\t1a\u001c:h\u0013\r\tY\u0001 \u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001D9v_R\fW*\u00198bO\u0016\u0014XCAA\n!\u0011\t)\"!\u000b\u000f\t\u0005]\u0011Q\u0005\b\u0005\u00033\t\u0019C\u0004\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"T\u0001\u0007yI|w\u000e\u001e \n\u00031K!AS&\n\u0007\u0005\u001d\u0012*\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002,\u00055\"!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002(%\u000b\u0001#];pi\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0007\u0001\f\u0019\u0004\u0003\u0005e\u001b\u0005\u0005\t\u0019AA\n\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sA\u0005!A/[7f+\t\tY\u0004\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\teS\u0001\u0006kRLGn]\u0005\u0005\u0003\u000b\nyD\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u00031iwnY6EK2,w-\u0019;f+\t\ti\u0005E\u0002Y\u0003\u001fJ1!!\u0015J\u0005e\u0011\u0016M\u001a;SKBd\u0017nY1DQ\u0006tw-\u001a#fY\u0016<\u0017\r^3\u0002!5|7m\u001b#fY\u0016<\u0017\r^3`I\u0015\fHc\u00011\u0002X!AAMEA\u0001\u0002\u0004\ti%A\u0007n_\u000e\\G)\u001a7fO\u0006$X\rI\u0001\rS6\fw-\u001a\"vS2$WM]\u000b\u0003\u0003?\u00022A]A1\u0013\r\t\u0019g\u001d\u0002\u0015\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3Ck&dG-\u001a:\u0002!%l\u0017mZ3Ck&dG-\u001a:`I\u0015\fHc\u00011\u0002j!AA-FA\u0001\u0002\u0004\ty&A\u0007j[\u0006<WMQ;jY\u0012,'\u000fI\u0001\nEJ|7.\u001a:JIB*\"!!\u001d\u0011\u0007A\u000b\u0019(C\u0002\u0002vE\u00131!\u00138u\u0003)\u0011'o\\6fe&#\u0007\u0007I\u0001\u0010[\u0016$\u0018\rZ1uC\n\u0013xn[3saU\u0011\u0011Q\u0010\t\u0004e\u0006}\u0014bAAAg\nqQ*\u001a;bI\u0006$\u0018M\u0011:pW\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1Ce>\\WM\u001d\u0019!\u0003%\u0011'o\\6fe&#\u0017'\u0001\u0006ce>\\WM]%ec\u0001\nq\"\\3uC\u0012\fG/\u0019\"s_.,'/M\u0001\u0011[\u0016$\u0018\rZ1uC\n\u0013xn[3sc\u0001\n\u0011\u0002^8qS\u000et\u0015-\\3\u0016\u0005\u0005E\u0005\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001c\u0006!!.\u0019<b\u0013\u0011\ty*!&\u0003\rM#(/\u001b8h\u0003)!x\u000e]5d\u001d\u0006lW\rI\u0001\bi>\u0004\u0018nY%e+\t\t9\u000b\u0005\u0003\u0002*\u0006-V\"A?\n\u0007\u00055VP\u0001\u0003Vk&$\u0017\u0001\u0003;pa&\u001c\u0017\n\u001a\u0011\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0019\u0002\u001bA\f'\u000f^5uS>t\u0017\n\u001a\u0019!\u00031\u0001\u0018M\u001d;ji&|g.\u001332\u00035\u0001\u0018M\u001d;ji&|g.\u001332A\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007'\u0006\u0002\u0002>B!\u0011\u0011VA`\u0013\r\t\t- \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0004%A\bu_BL7\rU1si&$\u0018n\u001c82\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0004%A\u000bu_BL7\rU1si&$\u0018n\u001c8SK\u000e|'\u000f\u001a\u0019\u0016\u0005\u00055\u0007\u0003BAh\u0003'l!!!5\u000b\u0005Ql\u0018\u0002BAk\u0003#\u0014q\u0002U1si&$\u0018n\u001c8SK\u000e|'\u000fZ\u0001\u0017i>\u0004\u0018n\u0019)beRLG/[8o%\u0016\u001cwN\u001d31A\u0005)Bo\u001c9jGB\u000b'\u000f^5uS>t'+Z2pe\u0012\f\u0014A\u0006;pa&\u001c\u0007+\u0019:uSRLwN\u001c*fG>\u0014H-\r\u0011\u0002\u000f=4gm]3ucU\u0011\u0011\u0011\u001d\t\u0004!\u0006\r\u0018bAAs#\n!Aj\u001c8h\u0003!ygMZ:fiF\u0002\u0013AE7fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]B*\"!!<\u0011\u0007I\fy/C\u0002\u0002rN\u0014\u0011#T3uC\u0012\fG/\u0019)beRLG/[8o\u0003MiW\r^1eCR\f\u0007+\u0019:uSRLwN\u001c\u0019!\u0003IiW\r^1eCR\f\u0007+\u0019:uSRLwN\\\u0019\u0002'5,G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g.\r\u0011\u00023=tG*Z1eKJ\u001c\b.\u001b9DQ\u0006tw-\u001a%b]\u0012dWM]\u000b\u0003\u0003{\u00042\u0001WA\u0000\u0013\r\u0011\t!\u0013\u0002\u0018\u0019\u0016\fG-\u001a:tQ&\u00048\t[1oO\u0016D\u0015M\u001c3mKJ\fQd\u001c8MK\u0006$WM]:iSB\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe~#S-\u001d\u000b\u0004A\n\u001d\u0001\u0002\u000337\u0003\u0003\u0005\r!!@\u00025=tG*Z1eKJ\u001c\b.\u001b9DQ\u0006tw-\u001a%b]\u0012dWM\u001d\u0011\u0002%=tG*Z1eKJ\u001c\b.\u001b9DQ\u0006tw-Z\u000b\u0003\u0005\u001f\u0001\u0002\u0002\u0015B\t\u0005+\u0011)\u0002Y\u0005\u0004\u0005'\t&!\u0003$v]\u000e$\u0018n\u001c83!\u0019\u00119B!\t\u0003(9!!\u0011\u0004B\u000f\u001d\u0011\tYBa\u0007\n\u0003IK1Aa\bR\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\t\u0003&\tA\u0011\n^3sC\ndWMC\u0002\u0003 E\u0003BA!\u000b\u000305\u0011!1\u0006\u0006\u0004\u0005[Y\u0015aB2mkN$XM]\u0005\u0005\u0005c\u0011YCA\u0005QCJ$\u0018\u000e^5p]\u00061rN\u001c'fC\u0012,'o\u001d5ja\u000eC\u0017M\\4f?\u0012*\u0017\u000fF\u0002a\u0005oA\u0001\u0002Z\u001d\u0002\u0002\u0003\u0007!qB\u0001\u0014_:dU-\u00193feND\u0017\u000e]\"iC:<W\rI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\t}\u0002c\u0001:\u0003B%\u0019!1I:\u0003#I\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDW-A\tnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z0%KF$2\u0001\u0019B%\u0011!!G(!AA\u0002\t}\u0012AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002A\"\u001aaHa\u0015\u0011\t\tU#1M\u0007\u0003\u0005/RAA!\u0017\u0003\\\u0005\u0019\u0011\r]5\u000b\t\tu#qL\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u0011\t'!\u0002\u0002\u000b),h.\u001b;\n\t\t\u0015$q\u000b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007}\u0012Y\u0007\u0005\u0003\u0003V\t5\u0014\u0002\u0002B8\u0005/\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u00021\r\u0014X-\u0019;f%\u00064GOU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0006\u0002\u0003vA\u0019\u0001La\u001e\n\u0007\te\u0014J\u0001\nSC\u001a$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0005;fgR\u0014VM[3diNT6nQ8oM&<\u0007fA!\u0003\u0000A!!Q\u000bBA\u0013\u0011\u0011\u0019Ia\u0016\u0003\tQ+7\u000f^\u0001/i\u0016\u001cH\u000fR3gKJ\u001c8\t[1oO\u0016\u001c\u0018*\\7fI&\fG/\u001a7z)\",g.\u00119qY&,7o\u00115b]\u001e,7\u000fK\u0002C\u0005\u007f\n!\u0005^3ti\u0006\u0003\b\u000f\\5fg\u000eC\u0017M\\4fg^CWM\u001c(pi\u0012+g-\u001a:sS:<\u0007fA\"\u0003\u0000\u0005\tb/\u001a:jMfl\u0015m[3MK\u0006$WM]:\u0015\r\tE%\u0011\u0015BW!!\u0011\u0019J!(\u0003(\u00055XB\u0001BK\u0015\u0011\u00119J!'\u0002\u000f5,H/\u00192mK*\u0019!1T)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003 \nU%aA'ba\"9!1\u0015#A\u0002\t\u0015\u0016!J3ya\u0016\u001cG/\u001a3Qe\u00164\b+\u0019:uSRLwN\\:BYJ,\u0017\rZ=Fq&\u001cH/\u001b8h!\u0019\u00119K!+\u0002n6\u0011!\u0011T\u0005\u0005\u0005W\u0013IJA\u0002TKRDqAa,E\u0001\u0004\u0011\t,\u0001\ffqB,7\r^3e\u001b\u0016$\u0018\rZ1uC>3gm]3u!\u0015\u0001&1WAq\u0013\r\u0011),\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0002'Y,'/\u001b4z\u001b\u0006\\WMR8mY><XM]:\u0015\u0011\tE%1\u0018B_\u0005\u0007DqAa)F\u0001\u0004\u0011)\u000bC\u0004\u0003@\u0016\u0003\rA!1\u0002\u001f\u0015D\b/Z2uK\u0012\u0014%o\\6feN\u0004bAa*\u0003*\u0006E\u0004b\u0002BX\u000b\u0002\u0007!\u0011W\u0001 m\u0016\u0014\u0018NZ=MK\u0006$WM]:iSB\u001c\u0005.\u00198hK\u000e\u000bG\u000e\u001c2bG.\u001cH#\u00021\u0003J\nM\u0007b\u0002Bf\r\u0002\u0007!QZ\u0001\u0017Kb\u0004Xm\u0019;fIV\u0003H-\u0019;fI2+\u0017\rZ3sgB1!q\u0003Bh\u0005OIAA!5\u0003&\t!A*[:u\u0011\u001d\u0011)N\u0012a\u0001\u0005\u001b\f\u0001$\u001a=qK\u000e$X\rZ+qI\u0006$X\r\u001a$pY2|w/\u001a:t\u0003u\u0001(o\\2fgN$v\u000e]5d!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGc\u00011\u0003\\\"9!Q\\$A\u0002\tU\u0014A\u0005:bMR\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004")
public class RaftReplicaManagerTest {
    private AlterIsrManager alterIsrManager;
    private KafkaConfig config;
    private final CachedConfigRepository configRepository = new CachedConfigRepository();
    private final Metrics metrics = new Metrics();
    private QuotaFactory.QuotaManagers quotaManager;
    private final MockTime time = new MockTime();
    private RaftReplicaChangeDelegate mockDelegate;
    private MetadataImageBuilder imageBuilder;
    private final int brokerId0;
    private final MetadataBroker metadataBroker0 = new MetadataBroker(this.brokerId0(), null, (Map)Predef$.MODULE$.Map().empty(), false);
    private final int brokerId1;
    private final MetadataBroker metadataBroker1 = new MetadataBroker(this.brokerId1(), null, (Map)Predef$.MODULE$.Map().empty(), false);
    private final String topicName;
    private final Uuid topicId = Uuid.randomUuid();
    private final int partitionId0;
    private final int partitionId1;
    private final TopicPartition topicPartition0 = new TopicPartition(this.topicName(), this.partitionId0());
    private final TopicPartition topicPartition1 = new TopicPartition(this.topicName(), this.partitionId1());
    private final PartitionRecord topicPartitionRecord0 = new PartitionRecord().setPartitionId(this.partitionId0()).setTopicId(this.topicId()).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(this.brokerId0()), Predef$.MODULE$.int2Integer(this.brokerId1()))).setLeader(this.brokerId0()).setLeaderEpoch(0);
    private final PartitionRecord topicPartitionRecord1 = new PartitionRecord().setPartitionId(this.partitionId1()).setTopicId(this.topicId()).setReplicas(Arrays.asList(Predef$.MODULE$.int2Integer(this.brokerId0()), Predef$.MODULE$.int2Integer(this.brokerId1()))).setLeader(this.brokerId1()).setLeaderEpoch(0);
    private final long offset1;
    private final MetadataPartition metadataPartition0 = MetadataPartition$.MODULE$.apply(this.topicName(), this.topicPartitionRecord0());
    private final MetadataPartition metadataPartition1 = MetadataPartition$.MODULE$.apply(this.topicName(), this.topicPartitionRecord1());
    private LeadershipChangeHandler onLeadershipChangeHandler;
    private Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit> onLeadershipChange;
    private RaftMetadataCache metadataCache;

    private AlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    private void alterIsrManager_$eq(AlterIsrManager x$1) {
        this.alterIsrManager = x$1;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private CachedConfigRepository configRepository() {
        return this.configRepository;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    private void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    private RaftReplicaChangeDelegate mockDelegate() {
        return this.mockDelegate;
    }

    private void mockDelegate_$eq(RaftReplicaChangeDelegate x$1) {
        this.mockDelegate = x$1;
    }

    private MetadataImageBuilder imageBuilder() {
        return this.imageBuilder;
    }

    private void imageBuilder_$eq(MetadataImageBuilder x$1) {
        this.imageBuilder = x$1;
    }

    private int brokerId0() {
        return this.brokerId0;
    }

    private MetadataBroker metadataBroker0() {
        return this.metadataBroker0;
    }

    private int brokerId1() {
        return this.brokerId1;
    }

    private MetadataBroker metadataBroker1() {
        return this.metadataBroker1;
    }

    private String topicName() {
        return this.topicName;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private int partitionId0() {
        return this.partitionId0;
    }

    private int partitionId1() {
        return this.partitionId1;
    }

    private TopicPartition topicPartition0() {
        return this.topicPartition0;
    }

    private TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    private PartitionRecord topicPartitionRecord0() {
        return this.topicPartitionRecord0;
    }

    private PartitionRecord topicPartitionRecord1() {
        return this.topicPartitionRecord1;
    }

    private long offset1() {
        return this.offset1;
    }

    private MetadataPartition metadataPartition0() {
        return this.metadataPartition0;
    }

    private MetadataPartition metadataPartition1() {
        return this.metadataPartition1;
    }

    private LeadershipChangeHandler onLeadershipChangeHandler() {
        return this.onLeadershipChangeHandler;
    }

    private void onLeadershipChangeHandler_$eq(LeadershipChangeHandler x$1) {
        this.onLeadershipChangeHandler = x$1;
    }

    private Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit> onLeadershipChange() {
        return this.onLeadershipChange;
    }

    private void onLeadershipChange_$eq(Function2<Iterable<Partition>, Iterable<Partition>, BoxedUnit> x$1) {
        this.onLeadershipChange = x$1;
    }

    private RaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private void metadataCache_$eq(RaftMetadataCache x$1) {
        this.metadataCache = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @BeforeEach
    public void setUp() {
        Function2 & Serializable onLeadershipChange_$eq_x$1;
        void var2_2;
        this.alterIsrManager_$eq((AlterIsrManager)Mockito.mock(AlterIsrManager.class));
        int nodeId = this.brokerId0();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps((Properties)var2_2));
        this.metadataCache_$eq(new RaftMetadataCache(this.config().brokerId()));
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""));
        this.mockDelegate_$eq((RaftReplicaChangeDelegate)Mockito.mock(RaftReplicaChangeDelegate.class));
        this.imageBuilder_$eq(new MetadataImageBuilder(this.brokerId0(), (Logger)Mockito.mock(Logger.class), new MetadataImage()));
        this.onLeadershipChangeHandler_$eq((LeadershipChangeHandler)Mockito.mock(LeadershipChangeHandler.class));
        this.onLeadershipChange = onLeadershipChange_$eq_x$1 = (arg_0, arg_1) -> RaftReplicaManagerTest.$anonfun$setUp$1$adapted(this.onLeadershipChangeHandler(), arg_0, arg_1);
    }

    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$9 -> {
            x$9.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    public RaftReplicaManager createRaftReplicaManager() {
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)this.config().logDirs().map((Function1 & Serializable)x$10 -> new File((String)x$10))), LogConfig$.MODULE$.apply(), (ConfigRepository)new CachedConfigRepository(), TestUtils$.MODULE$.createLogManager$default$4(), new MockTime());
        return new RaftReplicaManager(this.config(), this.metrics(), (Time)this.time(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), this.metadataCache(), new LogDirFailureChannel(this.config().logDirs().size()), this.alterIsrManager(), (ConfigRepository)this.configRepository(), (Option)None$.MODULE$);
    }

    @Test
    public void testRejectsZkConfig() {
        Assertions.assertThrows(IllegalStateException.class, () -> {
            KafkaConfig zkConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
            LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)zkConfig.logDirs().map((Function1 & Serializable)x$11 -> new File((String)x$11))), LogConfig$.MODULE$.apply(), (ConfigRepository)new CachedConfigRepository(), TestUtils$.MODULE$.createLogManager$default$4(), new MockTime());
            new RaftReplicaManager(zkConfig, this.metrics(), (Time)this.time(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), this.metadataCache(), new LogDirFailureChannel(this.config().logDirs().size()), this.alterIsrManager(), (ConfigRepository)this.configRepository(), (Option)None$.MODULE$);
        });
    }

    @Test
    public void testDefersChangesImmediatelyThenAppliesChanges() {
        RaftReplicaManager rrm = this.createRaftReplicaManager();
        rrm.delegate_$eq(this.mockDelegate());
        Partition partition0 = Partition$.MODULE$.apply(this.topicPartition0(), (Time)this.time(), (ConfigRepository)this.configRepository(), (ReplicaManager)rrm);
        Partition partition1 = Partition$.MODULE$.apply(this.topicPartition1(), (Time)this.time(), (ConfigRepository)this.configRepository(), (ReplicaManager)rrm);
        this.processTopicPartitionMetadata(rrm);
        ArgumentCaptor partitionsNewMapCaptor = ArgumentCaptor.forClass(scala.collection.mutable.Map.class);
        ((RaftReplicaChangeDelegate)Mockito.verify((Object)this.mockDelegate())).makeDeferred((Map)partitionsNewMapCaptor.capture(), ArgumentMatchers.eq((long)this.offset1()));
        scala.collection.mutable.Map partitionsDeferredMap = (scala.collection.mutable.Map)partitionsNewMapCaptor.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)BoxesRunTime.boxToBoolean((boolean)true))})), (Object)partitionsDeferredMap);
        ((RaftReplicaChangeDelegate)Mockito.verify((Object)this.mockDelegate(), (VerificationMode)Mockito.never())).makeFollowers((Set)ArgumentMatchers.any(), (MetadataBrokers)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (OffsetCheckpoints)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        rrm.markPartitionDeferred(partition0, true);
        rrm.markPartitionDeferred(partition1, true);
        Mockito.when((Object)this.mockDelegate().makeLeaders((Set)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (OffsetCheckpoints)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn(Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        Mockito.when((Object)this.mockDelegate().makeFollowers((Set)ArgumentMatchers.any(), (MetadataBrokers)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (OffsetCheckpoints)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn(Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1})));
        rrm.endMetadataChangeDeferral(this.onLeadershipChange());
        scala.collection.mutable.Map<Partition, MetadataPartition> leaderPartitionStates = this.verifyMakeLeaders((Set<MetadataPartition>)((Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Option<Object>)None$.MODULE$);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)this.metadataPartition0())})), leaderPartitionStates);
        scala.collection.mutable.Map<Partition, MetadataPartition> followerPartitionStates = this.verifyMakeFollowers((Set<MetadataPartition>)((Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Set<Object>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId0(), this.brokerId1()}))), (Option<Object>)None$.MODULE$);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)this.metadataPartition1())})), followerPartitionStates);
        this.verifyLeadershipChangeCallbacks((List<Partition>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))), (List<Partition>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1}))));
    }

    @Test
    public void testAppliesChangesWhenNotDeferring() {
        RaftReplicaManager rrm = this.createRaftReplicaManager();
        rrm.delegate_$eq(this.mockDelegate());
        Partition partition0 = Partition$.MODULE$.apply(this.topicPartition0(), (Time)this.time(), (ConfigRepository)this.configRepository(), (ReplicaManager)rrm);
        Partition partition1 = Partition$.MODULE$.apply(this.topicPartition1(), (Time)this.time(), (ConfigRepository)this.configRepository(), (ReplicaManager)rrm);
        rrm.endMetadataChangeDeferral(this.onLeadershipChange());
        Mockito.when((Object)this.mockDelegate().makeLeaders((Set)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (OffsetCheckpoints)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)new Some((Object)BoxesRunTime.boxToLong((long)this.offset1()))))).thenReturn(Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        Mockito.when((Object)this.mockDelegate().makeFollowers((Set)ArgumentMatchers.any(), (MetadataBrokers)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (OffsetCheckpoints)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq((Object)new Some((Object)BoxesRunTime.boxToLong((long)this.offset1()))))).thenReturn(Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1})));
        this.processTopicPartitionMetadata(rrm);
        scala.collection.mutable.Map<Partition, MetadataPartition> leaderPartitionStates = this.verifyMakeLeaders((Set<MetadataPartition>)((Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.offset1())));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)this.metadataPartition0())})), leaderPartitionStates);
        scala.collection.mutable.Map<Partition, MetadataPartition> followerPartitionStates = this.verifyMakeFollowers((Set<MetadataPartition>)((Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Set<Object>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId0(), this.brokerId1()}))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.offset1())));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)this.metadataPartition1())})), followerPartitionStates);
        this.verifyLeadershipChangeCallbacks((List<Partition>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))), (List<Partition>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1}))));
    }

    private scala.collection.mutable.Map<Partition, MetadataPartition> verifyMakeLeaders(Set<MetadataPartition> expectedPrevPartitionsAlreadyExisting, Option<Object> expectedMetadataOffset) {
        ArgumentCaptor leaderPartitionStatesCaptor = ArgumentCaptor.forClass(scala.collection.mutable.Map.class);
        ((RaftReplicaChangeDelegate)Mockito.verify((Object)this.mockDelegate())).makeLeaders((Set)ArgumentMatchers.eq(expectedPrevPartitionsAlreadyExisting), (Map)leaderPartitionStatesCaptor.capture(), (OffsetCheckpoints)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq(expectedMetadataOffset));
        return (scala.collection.mutable.Map)leaderPartitionStatesCaptor.getValue();
    }

    private scala.collection.mutable.Map<Partition, MetadataPartition> verifyMakeFollowers(Set<MetadataPartition> expectedPrevPartitionsAlreadyExisting, Set<Object> expectedBrokers, Option<Object> expectedMetadataOffset) {
        ArgumentCaptor followerPartitionStatesCaptor = ArgumentCaptor.forClass(scala.collection.mutable.Map.class);
        ArgumentCaptor brokersCaptor = ArgumentCaptor.forClass(MetadataBrokers.class);
        ((RaftReplicaChangeDelegate)Mockito.verify((Object)this.mockDelegate())).makeFollowers((Set)ArgumentMatchers.eq(expectedPrevPartitionsAlreadyExisting), (MetadataBrokers)brokersCaptor.capture(), (Map)followerPartitionStatesCaptor.capture(), (OffsetCheckpoints)ArgumentMatchers.any(), (Option)ArgumentMatchers.eq(expectedMetadataOffset));
        MetadataBrokers brokers = (MetadataBrokers)brokersCaptor.getValue();
        Assertions.assertEquals((int)expectedBrokers.size(), (int)brokers.size());
        expectedBrokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((boolean)brokers.aliveBroker(brokerId).isDefined()));
        return (scala.collection.mutable.Map)followerPartitionStatesCaptor.getValue();
    }

    private void verifyLeadershipChangeCallbacks(List<Partition> expectedUpdatedLeaders, List<Partition> expectedUpdatedFollowers) {
        ArgumentCaptor updatedLeadersCaptor = ArgumentCaptor.forClass(Iterable.class);
        ArgumentCaptor updatedFollowersCaptor = ArgumentCaptor.forClass(Iterable.class);
        ((LeadershipChangeHandler)Mockito.verify((Object)this.onLeadershipChangeHandler())).onLeadershipChange((Iterable<Partition>)((Iterable)updatedLeadersCaptor.capture()), (Iterable<Partition>)((Iterable)updatedFollowersCaptor.capture()));
        Assertions.assertEquals(expectedUpdatedLeaders, (Object)((IterableOnceOps)updatedLeadersCaptor.getValue()).toList());
        Assertions.assertEquals(expectedUpdatedFollowers, (Object)((IterableOnceOps)updatedFollowersCaptor.getValue()).toList());
    }

    private void processTopicPartitionMetadata(RaftReplicaManager raftReplicaManager) {
        this.imageBuilder().brokersBuilder().add(this.metadataBroker0());
        this.imageBuilder().brokersBuilder().add(this.metadataBroker1());
        this.imageBuilder().partitionsBuilder().addUuidMapping(this.topicName(), this.topicId());
        this.imageBuilder().partitionsBuilder().set(this.metadataPartition0());
        this.imageBuilder().partitionsBuilder().set(this.metadataPartition1());
        this.metadataCache().image(this.imageBuilder().build());
        raftReplicaManager.handleMetadataRecords(this.imageBuilder(), this.offset1(), this.onLeadershipChange());
    }

    public RaftReplicaManagerTest() {
        this.brokerId0 = 0;
        this.brokerId1 = 1;
        this.topicName = "topicName";
        this.partitionId0 = 0;
        this.partitionId1 = 1;
        this.offset1 = 1L;
    }

    public static final /* synthetic */ Object $anonfun$setUp$1$adapted(LeadershipChangeHandler eta$0$1$1, Iterable updatedLeaders, Iterable updatedFollowers) {
        eta$0$1$1.onLeadershipChange((Iterable<Partition>)updatedLeaders, (Iterable<Partition>)updatedFollowers);
        return BoxedUnit.UNIT;
    }
}

