/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.network.ConnectionQuotas;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.ClientQuotaCache;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.QuotaRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001B\u0010!\u0001\u001dBQA\f\u0001\u0005\u0002=B\u0011B\r\u0001A\u0002\u0003\u0007I\u0011A\u001a\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0003A\u0004\"\u0003 \u0001\u0001\u0004\u0005\t\u0015)\u00035\u0011%y\u0004\u00011AA\u0002\u0013\u0005\u0001\tC\u0005E\u0001\u0001\u0007\t\u0019!C\u0001\u000b\"Iq\t\u0001a\u0001\u0002\u0003\u0006K!\u0011\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006/\u0002!\t!\u0013\u0005\u00069\u0002!\t!\u0013\u0005\u0006=\u0002!\t!\u0013\u0005\u0006A\u0002!\t!\u0013\u0005\u0006E\u0002!\t!\u0013\u0005\u0006I\u0002!\t!\u0013\u0005\u0006M\u0002!\t!\u0013\u0005\u0006Q\u0002!\t!\u0013\u0005\u0006U\u0002!\t!\u0013\u0005\u0006Y\u0002!\t!\u0013\u0005\u0006]\u0002!\t!\u0013\u0005\u0006a\u0002!\t!\u0013\u0005\u0006e\u0002!\t!\u0013\u0005\u0006i\u0002!\t!\u001e\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002n\u0001!\t!a\u001c\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0005y\u0019E.[3oiF+x\u000e^1NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\"E\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002$I\u000511/\u001a:wKJT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\r\u0001\u000e\u0003\u0001\nq!\\1oC\u001e,'/F\u00015!\t\tT'\u0003\u00027A\tQ2\t\\5f]R\fVo\u001c;b\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006YQ.\u00198bO\u0016\u0014x\fJ3r)\tID\b\u0005\u0002*u%\u00111H\u000b\u0002\u0005+:LG\u000fC\u0004>\u0007\u0005\u0005\t\u0019\u0001\u001b\u0002\u0007a$\u0013'\u0001\u0005nC:\fw-\u001a:!\u0003\u0015\u0019\u0017m\u00195f+\u0005\t\u0005CA\u0019C\u0013\t\u0019\u0005E\u0001\tDY&,g\u000e^)v_R\f7)Y2iK\u0006I1-Y2iK~#S-\u001d\u000b\u0003s\u0019Cq!\u0010\u0004\u0002\u0002\u0003\u0007\u0011)\u0001\u0004dC\u000eDW\rI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002s!\u0012\u0001b\u0013\t\u0003\u0019Vk\u0011!\u0014\u0006\u0003\u001d>\u000b1!\u00199j\u0015\t\u0001\u0016+A\u0004kkBLG/\u001a:\u000b\u0005I\u001b\u0016!\u00026v]&$(\"\u0001+\u0002\u0007=\u0014x-\u0003\u0002W\u001b\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002/Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3TiJL7\r^'bi\u000eD\u0007FA\u0005Z!\ta%,\u0003\u0002\\\u001b\n!A+Z:u\u0003i!Xm\u001d;EKN\u001c'/\u001b2f\u001d>t7\u000b\u001e:jGRl\u0015\r^2iQ\tQ\u0011,A\ruKN$H)Z:de&\u0014WMR5mi\u0016\u0014xJ\u001c+za\u0016\u001c\bFA\u0006Z\u0003e!Xm\u001d;F]RLG/_,ji\"$UMZ1vYRt\u0015-\\3)\u00051I\u0016\u0001\u0005;fgR\fVo\u001c;b%\u0016lwN^1mQ\ti\u0011,\u0001\u0019uKN$H)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCNLeN^1mS\u00124\u0015\u000e\u001c;fe\u000e{WNY5oCRLwN\u001c\u0015\u0003\u001de\u000bq\u0003^3ti\u0012+7o\u0019:jE\u0016,U\u000e\u001d;z\r&dG/\u001a:)\u0005=I\u0016!\t;fgR$Um]2sS\n,WK\\:vaB|'\u000f^3e\u000b:$\u0018\u000e^=UsB,\u0007F\u0001\tZ\u0003u!Xm\u001d;EKN\u001c'/\u001b2f\u001b&\u001c8/\u001b8h\u000b:$\u0018\u000e^=UsB,\u0007FA\tZ\u0003E!Xm\u001d;Rk>$\u0018-T1oC\u001e,'o\u001d\u0015\u0003%e\u000b1\u0002^3ti&\u0003\u0018+^8uC\"\u00121#W\u0001\u0016i\u0016\u001cH/\u00139Rk>$\u0018-\u00168l]><hnS3zQ\t!\u0012,A\fuKN$Xk]3s#V|G/Y+oW:|wO\\&fs\"\u0012Q#W\u0001\u000fg\u0016$X\u000f]!oIZ+'/\u001b4z)\rIdo\u001e\u0005\u0006eY\u0001\r\u0001\u000e\u0005\u0006qZ\u0001\r!_\u0001\tm\u0016\u0014\u0018NZ5feB1\u0011F\u001f?\u0002.eJ!a\u001f\u0016\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004#B?\u0002\f\u0005Eab\u0001@\u0002\b9\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002M\u00051AH]8pizJ\u0011aK\u0005\u0004\u0003\u0013Q\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001b\tyA\u0001\u0003MSN$(bAA\u0005UA!\u00111CA\u0014\u001d\u0011\t)\"a\t\u000e\u0005\u0005]!bA\u0011\u0002\u001a)!\u00111DA\u000f\u0003\u0019\u0019w.\\7p]*\u0019Q%a\b\u000b\u0007\u0005\u00052+\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003K\t9\"A\u0006Rk>$\u0018MU3d_J$\u0017\u0002BA\u0015\u0003W\u0011!\"\u00128uSRLH)\u0019;b\u0015\u0011\t)#a\u0006\u0011\u000f%\ny#a\r\u0002D%\u0019\u0011\u0011\u0007\u0016\u0003\rQ+\b\u000f\\33!\u0011\t)$!\u0010\u000f\t\u0005]\u0012\u0011\b\t\u0003\u007f*J1!a\u000f+\u0003\u0019\u0001&/\u001a3fM&!\u0011qHA!\u0005\u0019\u0019FO]5oO*\u0019\u00111\b\u0016\u0011\u0007%\n)%C\u0002\u0002H)\u0012a\u0001R8vE2,\u0017A\u00043fg\u000e\u0014\u0018NY3F]RLG/\u001f\u000b\u0005\u0003\u001b\n\u0019\u0006\u0005\u0005\u00026\u0005=\u00131GA\"\u0013\u0011\t\t&!\u0011\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u0002V]\u0001\r\u0001`\u0001\u0007K:$\u0018\u000e^=\u0002\u001d\u0005$G-U;pi\u0006\u0014VmY8sIR9\u0011(a\u0017\u0002^\u0005}\u0003\"\u0002\u001a\u0019\u0001\u0004!\u0004BBA+1\u0001\u0007A\u0010C\u0004\u0002ba\u0001\r!!\f\u0002\u000bE,x\u000e^1\u0002+\u0005$G-U;pi\u0006\u0014V-\\8wC2\u0014VmY8sIR9\u0011(a\u001a\u0002j\u0005-\u0004\"\u0002\u001a\u001a\u0001\u0004!\u0004BBA+3\u0001\u0007A\u0010C\u0004\u0002be\u0001\r!a\r\u0002\u001d\u0015tG/\u001b;z)>4\u0015\u000e\u001c;feR)\u0011(!\u001d\u0002t!1\u0011Q\u000b\u000eA\u0002qDq!!\u001e\u001b\u0001\u0004\t9(\u0001\u0006d_6\u0004xN\\3oiN\u0004b!!\u001f\u0002\u0004\u0006\u001dUBAA>\u0015\u0011\ti(a \u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011\u0011\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0006\u0006m$A\u0003'jgR\u0014UO\u001a4feB!\u0011\u0011RAG\u001b\t\tYI\u0003\u0003\u0002b\u0005e\u0011\u0002BAH\u0003\u0017\u0013!d\u00117jK:$\u0018+^8uC\u001aKG\u000e^3s\u0007>l\u0007o\u001c8f]R\fAb\u00197jK:$XI\u001c;jif$2\u0001`AK\u0011\u001d\t9j\u0007a\u0001\u0003g\t\u0001b\u00197jK:$\u0018\nZ\u0001\u000bkN,'/\u00128uSRLHc\u0001?\u0002\u001e\"9\u0011q\u0014\u000fA\u0002\u0005M\u0012\u0001B;tKJ\f\u0001#^:fe\u000ec\u0017.\u001a8u\u000b:$\u0018\u000e^=\u0015\u000bq\f)+a*\t\u000f\u0005}U\u00041\u0001\u00024!9\u0011qS\u000fA\u0002\u0005M\u0012\u0001C5q\u000b:$\u0018\u000e^=\u0015\u0007q\fi\u000bC\u0004\u00020z\u0001\r!a\r\u0002\u0005%\u0004\b")
public class ClientQuotaMetadataManagerTest {
    private ClientQuotaMetadataManager manager;
    private ClientQuotaCache cache;

    public ClientQuotaMetadataManager manager() {
        return this.manager;
    }

    public void manager_$eq(ClientQuotaMetadataManager x$1) {
        this.manager = x$1;
    }

    public ClientQuotaCache cache() {
        return this.cache;
    }

    public void cache_$eq(ClientQuotaCache x$1) {
        this.cache = x$1;
    }

    @BeforeEach
    public void setup() {
        Seq configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)x$3 -> {
            Properties fromProps_overrides = new Properties();
            return KafkaConfig$.MODULE$.fromProps(x$3, fromProps_overrides, true);
        });
        MockTime time = new MockTime();
        Metrics metrics = new Metrics();
        QuotaFactory.QuotaManagers quotaManagers = QuotaFactory$.MODULE$.instantiate((KafkaConfig)configs.head(), metrics, (Time)time, "quota-metadata-processor-test");
        QuotaFactory.QuotaManagers spiedQuotaManagers = new QuotaFactory.QuotaManagers((ClientQuotaManager)Mockito.spy((Object)quotaManagers.fetch()), (ClientQuotaManager)Mockito.spy((Object)quotaManagers.produce()), (ClientRequestQuotaManager)Mockito.spy((Object)quotaManagers.request()), (ControllerMutationQuotaManager)Mockito.spy((Object)quotaManagers.controllerMutation()), quotaManagers.leader(), quotaManagers.follower(), quotaManagers.alterLogDirs(), quotaManagers.clientQuotaCallback());
        ConnectionQuotas connectionQuotas = (ConnectionQuotas)Mockito.mock(ConnectionQuotas.class);
        this.cache_$eq(new ClientQuotaCache());
        this.manager_$eq(new ClientQuotaMetadataManager(spiedQuotaManagers, connectionQuotas, this.cache()));
    }

    @Test
    public void testDescribeStrictMatch() {
        this.setupAndVerify(this.manager(), (Function2<List<QuotaRecord.EntityData>, Tuple2<String, Object>, BoxedUnit>)(Function2 & Serializable)(x0$1, x1$1) -> {
            ClientQuotaMetadataManagerTest.$anonfun$testDescribeStrictMatch$1(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{this.userClientEntity("user-1", "client-id-2"), this.userClientEntity("user-3", "client-id-1"), this.userClientEntity("user-2", null), this.userEntity("user-4"), this.userClientEntity(null, "client-id-2"), this.clientEntity("client-id-1"), this.clientEntity("client-id-3")}))).foreach((Function1 & Serializable)entity -> {
            ClientQuotaMetadataManagerTest.$anonfun$testDescribeStrictMatch$2(this, entity);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeNonStrictMatch() {
        this.setupAndVerify(this.manager(), (Function2<List<QuotaRecord.EntityData>, Tuple2<String, Object>, BoxedUnit>)(Function2 & Serializable)(x0$1, x1$1) -> {
            ClientQuotaMetadataManagerTest.$anonfun$testDescribeNonStrictMatch$1(x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
        ListBuffer components = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.entityToFilter(this.userEntity("user-1"), (ListBuffer<ClientQuotaFilterComponent>)components);
        scala.collection.immutable.Map results = this.cache().describeClientQuotasInternal(components.toSeq(), false);
        Assertions.assertEquals((int)3, (int)results.size());
        Assertions.assertEquals((int)3, (int)results.keySet().count((Function1 & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean((boolean)(bl = quotaEntity instanceof UserEntity ? ((UserEntity)quotaEntity).user().equals("user-1") : (quotaEntity instanceof ExplicitUserDefaultClientIdEntity ? ((ExplicitUserDefaultClientIdEntity)quotaEntity).user().equals("user-1") : (quotaEntity instanceof ExplicitUserExplicitClientIdEntity ? ((ExplicitUserExplicitClientIdEntity)quotaEntity).user().equals("user-1") : false))))));
        results = this.cache().describeClientQuotasInternal(components.toSeq(), true);
        Assertions.assertEquals((int)1, (int)results.size());
        components.clear();
        this.entityToFilter(this.userEntity("unknown"), (ListBuffer<ClientQuotaFilterComponent>)components);
        results = this.cache().describeClientQuotasInternal(components.toSeq(), false);
        Assertions.assertEquals((int)0, (int)results.size());
        components.clear();
        this.entityToFilter(this.clientEntity("client-id-2"), (ListBuffer<ClientQuotaFilterComponent>)components);
        results = this.cache().describeClientQuotasInternal(components.toSeq(), false);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals((int)2, (int)results.keySet().count((Function1 & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean((boolean)(bl = quotaEntity instanceof ClientIdEntity ? ((ClientIdEntity)quotaEntity).clientId().equals("client-id-2") : (quotaEntity instanceof DefaultUserExplicitClientIdEntity ? ((DefaultUserExplicitClientIdEntity)quotaEntity).clientId().equals("client-id-2") : (quotaEntity instanceof ExplicitUserExplicitClientIdEntity ? ((ExplicitUserExplicitClientIdEntity)quotaEntity).clientId().equals("client-id-2") : false))))));
        results = this.cache().describeClientQuotasInternal((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofDefaultEntity((String)"user")})), false);
        Assertions.assertEquals((int)3, (int)results.size());
        Assertions.assertEquals((int)3, (int)results.keySet().count((Function1 & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotaMetadataManagerTest.$anonfun$testDescribeNonStrictMatch$4(quotaEntity))));
        results = this.cache().describeClientQuotasInternal((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofDefaultEntity((String)"client-id")})), false);
        Assertions.assertEquals((int)3, (int)results.size());
        Assertions.assertEquals((int)3, (int)results.keySet().count((Function1 & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotaMetadataManagerTest.$anonfun$testDescribeNonStrictMatch$5(quotaEntity))));
    }

    @Test
    public void testDescribeFilterOnTypes() {
        this.setupAndVerify(this.manager(), (Function2<List<QuotaRecord.EntityData>, Tuple2<String, Object>, BoxedUnit>)(Function2 & Serializable)(x0$1, x1$1) -> {
            ClientQuotaMetadataManagerTest.$anonfun$testDescribeFilterOnTypes$1(x0$1, x1$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map results = this.cache().describeClientQuotasInternal((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"user")})), false);
        Assertions.assertEquals((int)11, (int)results.size());
        Assertions.assertEquals((int)11, (int)results.keySet().count((Function1 & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotaMetadataManagerTest.$anonfun$testDescribeFilterOnTypes$2(quotaEntity))));
        results = this.cache().describeClientQuotasInternal((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"client-id")})), false);
        Assertions.assertEquals((int)8, (int)results.size());
        Assertions.assertEquals((int)8, (int)results.keySet().count((Function1 & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotaMetadataManagerTest.$anonfun$testDescribeFilterOnTypes$3(quotaEntity))));
        results = this.cache().describeClientQuotasInternal((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"user"), ClientQuotaFilterComponent.ofEntityType((String)"client-id")})), true);
        Assertions.assertEquals((int)7, (int)results.size());
        Assertions.assertEquals((int)7, (int)results.keySet().count((Function1 & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean((boolean)ClientQuotaMetadataManagerTest.$anonfun$testDescribeFilterOnTypes$4(quotaEntity))));
    }

    @Test
    public void testEntityWithDefaultName() {
        this.addQuotaRecord(this.manager(), this.clientEntity(ConfigEntityName$.MODULE$.Default()), (Tuple2<String, Object>)new Tuple2((Object)"producer_byte_rate", (Object)BoxesRunTime.boxToDouble((double)20000.0)));
        this.addQuotaRecord(this.manager(), this.clientEntity(null), (Tuple2<String, Object>)new Tuple2((Object)"producer_byte_rate", (Object)BoxesRunTime.boxToDouble((double)30000.0)));
        ListBuffer components = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.entityToFilter(this.clientEntity(ConfigEntityName$.MODULE$.Default()), (ListBuffer<ClientQuotaFilterComponent>)components);
        scala.collection.immutable.Map results = this.cache().describeClientQuotas(components.toSeq(), true);
        Assertions.assertEquals((int)1, (int)results.size());
        components.clear();
        this.entityToFilter(this.clientEntity(null), (ListBuffer<ClientQuotaFilterComponent>)components);
        results = this.cache().describeClientQuotas(components.toSeq(), true);
        Assertions.assertEquals((int)1, (int)results.size());
    }

    @Test
    public void testQuotaRemoval() {
        List<QuotaRecord.EntityData> entity = this.userClientEntity("user", "client-id");
        this.addQuotaRecord(this.manager(), entity, (Tuple2<String, Object>)new Tuple2((Object)"producer_byte_rate", (Object)BoxesRunTime.boxToDouble((double)10000.0)));
        this.addQuotaRecord(this.manager(), entity, (Tuple2<String, Object>)new Tuple2((Object)"consumer_byte_rate", (Object)BoxesRunTime.boxToDouble((double)20000.0)));
        scala.collection.immutable.Map<String, Object> quotas = this.describeEntity(entity);
        Assertions.assertEquals((int)2, (int)quotas.size());
        Assertions.assertEquals((double)10000.0, (double)BoxesRunTime.unboxToDouble((Object)quotas.apply((Object)"producer_byte_rate")), (double)1.0E-6);
        this.addQuotaRecord(this.manager(), entity, (Tuple2<String, Object>)new Tuple2((Object)"producer_byte_rate", (Object)BoxesRunTime.boxToDouble((double)10001.0)));
        quotas = this.describeEntity(entity);
        Assertions.assertEquals((int)2, (int)quotas.size());
        Assertions.assertEquals((double)10001.0, (double)BoxesRunTime.unboxToDouble((Object)quotas.apply((Object)"producer_byte_rate")), (double)1.0E-6);
        this.addQuotaRemovalRecord(this.manager(), entity, "producer_byte_rate");
        quotas = this.describeEntity(entity);
        Assertions.assertEquals((int)1, (int)quotas.size());
        Assertions.assertFalse((boolean)quotas.contains((Object)"producer_byte_rate"));
        this.addQuotaRemovalRecord(this.manager(), entity, "consumer_byte_rate");
        quotas = this.describeEntity(entity);
        Assertions.assertEquals((int)0, (int)quotas.size());
        this.addQuotaRemovalRecord(this.manager(), entity, "consumer_byte_rate");
        quotas = this.describeEntity(entity);
        Assertions.assertEquals((int)0, (int)quotas.size());
    }

    @Test
    public void testDescribeClientQuotasInvalidFilterCombination() {
        ClientQuotaFilterComponent ipFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"ip");
        ClientQuotaFilterComponent userFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"user");
        ClientQuotaFilterComponent clientIdFilterComponent = ClientQuotaFilterComponent.ofEntityType((String)"client-id");
        String expectedExceptionMessage = "Invalid entity filter component combination";
        Assertions.assertThrows(InvalidRequestException.class, () -> this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ipFilterComponent, userFilterComponent})), false), () -> expectedExceptionMessage);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ipFilterComponent, clientIdFilterComponent})), false), () -> expectedExceptionMessage);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ipFilterComponent, ipFilterComponent})), false), () -> expectedExceptionMessage);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{userFilterComponent, userFilterComponent})), false), () -> expectedExceptionMessage);
    }

    @Test
    public void testDescribeEmptyFilter() {
        scala.collection.immutable.Map results = this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), false);
        Assertions.assertEquals((int)0, (int)results.size());
        results = this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty(), true);
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testDescribeUnsupportedEntityType() {
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"other")})), false));
    }

    @Test
    public void testDescribeMissingEntityType() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntity((String)"", (String)"name")})), false));
    }

    @Test
    public void testQuotaManagers() {
        List<QuotaRecord.EntityData> entity = this.userClientEntity("user", "client");
        this.addQuotaRecord(this.manager(), entity, (Tuple2<String, Object>)new Tuple2((Object)"consumer_byte_rate", (Object)BoxesRunTime.boxToDouble((double)100.0)));
        ((ClientQuotaManager)Mockito.verify((Object)this.manager().quotaManagers().fetch(), (VerificationMode)Mockito.times((int)1))).updateQuota((Option)ArgumentMatchers.eq((Object)new Some((Object)"user")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.any(Option.class));
        this.addQuotaRecord(this.manager(), entity, (Tuple2<String, Object>)new Tuple2((Object)"producer_byte_rate", (Object)BoxesRunTime.boxToDouble((double)100.0)));
        ((ClientQuotaManager)Mockito.verify((Object)this.manager().quotaManagers().produce(), (VerificationMode)Mockito.times((int)1))).updateQuota((Option)ArgumentMatchers.eq((Object)new Some((Object)"user")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.any(Option.class));
        this.addQuotaRecord(this.manager(), entity, (Tuple2<String, Object>)new Tuple2((Object)"request_percentage", (Object)BoxesRunTime.boxToDouble((double)100.0)));
        ((ClientQuotaManager)Mockito.verify((Object)this.manager().quotaManagers().request(), (VerificationMode)Mockito.times((int)1))).updateQuota((Option)ArgumentMatchers.eq((Object)new Some((Object)"user")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.any(Option.class));
        this.addQuotaRecord(this.manager(), entity, (Tuple2<String, Object>)new Tuple2((Object)"controller_mutation_rate", (Object)BoxesRunTime.boxToDouble((double)100.0)));
        ((ClientQuotaManager)Mockito.verify((Object)this.manager().quotaManagers().controllerMutation(), (VerificationMode)Mockito.times((int)1))).updateQuota((Option)ArgumentMatchers.eq((Object)new Some((Object)"user")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.any(Option.class));
        this.addQuotaRemovalRecord(this.manager(), entity, "controller_mutation_rate");
        ((ClientQuotaManager)Mockito.verify((Object)this.manager().quotaManagers().controllerMutation(), (VerificationMode)Mockito.times((int)1))).updateQuota((Option)ArgumentMatchers.eq((Object)new Some((Object)"user")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.eq((Object)new Some((Object)"client")), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
    }

    @Test
    public void testIpQuota() {
        List<QuotaRecord.EntityData> defaultIp = this.ipEntity(null);
        List<QuotaRecord.EntityData> knownIp = this.ipEntity("1.2.3.4");
        this.addQuotaRecord(this.manager(), defaultIp, (Tuple2<String, Object>)new Tuple2((Object)"connection_creation_rate", (Object)BoxesRunTime.boxToDouble((double)100.0)));
        this.addQuotaRecord(this.manager(), knownIp, (Tuple2<String, Object>)new Tuple2((Object)"connection_creation_rate", (Object)BoxesRunTime.boxToDouble((double)99.0)));
        ((ConnectionQuotas)Mockito.verify((Object)this.manager().connectionQuotas(), (VerificationMode)Mockito.times((int)2))).updateIpConnectionRateQuota((Option)ArgumentMatchers.any(Option.class), (Option)ArgumentMatchers.any(Option.class));
        scala.collection.immutable.Map<String, Object> quotas = this.describeEntity(defaultIp);
        Assertions.assertEquals((int)1, (int)quotas.size());
        quotas = this.describeEntity(knownIp);
        Assertions.assertEquals((int)1, (int)quotas.size());
        scala.collection.immutable.Map results = this.cache().describeClientQuotas((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClientQuotaFilterComponent[]{ClientQuotaFilterComponent.ofEntityType((String)"ip")})), false);
        Assertions.assertEquals((int)2, (int)results.size());
        Mockito.reset((Object[])new ConnectionQuotas[]{this.manager().connectionQuotas()});
        this.addQuotaRecord(this.manager(), knownIp, (Tuple2<String, Object>)new Tuple2((Object)"connection_creation_rate", (Object)BoxesRunTime.boxToDouble((double)98.0)));
        ((ConnectionQuotas)Mockito.verify((Object)this.manager().connectionQuotas(), (VerificationMode)Mockito.times((int)1))).updateIpConnectionRateQuota((Option)ArgumentMatchers.any(Option.class), (Option)ArgumentMatchers.eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)98))));
        Mockito.reset((Object[])new ConnectionQuotas[]{this.manager().connectionQuotas()});
        this.addQuotaRemovalRecord(this.manager(), knownIp, "connection_creation_rate");
        ((ConnectionQuotas)Mockito.verify((Object)this.manager().connectionQuotas(), (VerificationMode)Mockito.times((int)1))).updateIpConnectionRateQuota((Option)ArgumentMatchers.any(Option.class), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
    }

    @Test
    public void testIpQuotaUnknownKey() {
        List<QuotaRecord.EntityData> defaultIp = this.ipEntity(null);
        this.addQuotaRecord(this.manager(), defaultIp, (Tuple2<String, Object>)new Tuple2((Object)"not-an-ip-quota-key", (Object)BoxesRunTime.boxToDouble((double)100.0)));
        ((ConnectionQuotas)Mockito.verify((Object)this.manager().connectionQuotas(), (VerificationMode)Mockito.times((int)0))).updateIpConnectionRateQuota((Option)ArgumentMatchers.any(Option.class), (Option)ArgumentMatchers.eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)100))));
        Assertions.assertEquals((int)0, (int)this.describeEntity(defaultIp).size());
    }

    @Test
    public void testUserQuotaUnknownKey() {
        List<QuotaRecord.EntityData> defaultUser = this.userEntity(null);
        this.addQuotaRecord(this.manager(), defaultUser, (Tuple2<String, Object>)new Tuple2((Object)"not-a-user-quota-key", (Object)BoxesRunTime.boxToDouble((double)100.0)));
        Assertions.assertEquals((int)0, (int)this.describeEntity(defaultUser).size());
    }

    public void setupAndVerify(ClientQuotaMetadataManager manager, Function2<List<QuotaRecord.EntityData>, Tuple2<String, Object>, BoxedUnit> verifier) {
        List toVerify = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(this.userClientEntity("user-1", "client-id-1"), (Object)BoxesRunTime.boxToDouble((double)50.5)), new Tuple2(this.userClientEntity("user-2", "client-id-1"), (Object)BoxesRunTime.boxToDouble((double)51.51)), new Tuple2(this.userClientEntity("user-3", "client-id-2"), (Object)BoxesRunTime.boxToDouble((double)52.52)), new Tuple2(this.userClientEntity(null, "client-id-1"), (Object)BoxesRunTime.boxToDouble((double)53.53)), new Tuple2(this.userClientEntity("user-1", null), (Object)BoxesRunTime.boxToDouble((double)54.54)), new Tuple2(this.userClientEntity("user-3", null), (Object)BoxesRunTime.boxToDouble((double)55.55)), new Tuple2(this.userEntity("user-1"), (Object)BoxesRunTime.boxToDouble((double)56.56)), new Tuple2(this.userEntity("user-2"), (Object)BoxesRunTime.boxToDouble((double)57.57)), new Tuple2(this.userEntity("user-3"), (Object)BoxesRunTime.boxToDouble((double)58.58)), new Tuple2(this.userEntity(null), (Object)BoxesRunTime.boxToDouble((double)59.59)), new Tuple2(this.clientEntity("client-id-2"), (Object)BoxesRunTime.boxToDouble((double)60.6)), new Tuple2(this.userClientEntity(null, null), (Object)BoxesRunTime.boxToDouble((double)61.61))}));
        toVerify.foreach((Function1 & Serializable)x0$1 -> {
            ClientQuotaMetadataManagerTest.$anonfun$setupAndVerify$1(this, manager, x0$1);
            return BoxedUnit.UNIT;
        });
        toVerify.foreach((Function1 & Serializable)x0$2 -> {
            ClientQuotaMetadataManagerTest.$anonfun$setupAndVerify$2(verifier, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public scala.collection.immutable.Map<String, Object> describeEntity(List<QuotaRecord.EntityData> entity) {
        ListBuffer components = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.entityToFilter(entity, (ListBuffer<ClientQuotaFilterComponent>)components);
        scala.collection.immutable.Map results = this.cache().describeClientQuotas(components.toSeq(), true);
        if (results.isEmpty()) {
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        }
        if (results.size() == 1) {
            return (scala.collection.immutable.Map)((Tuple2)results.head())._2();
        }
        throw new AssertionError((Object)"Matched more than one entity with strict=true describe filter");
    }

    public void addQuotaRecord(ClientQuotaMetadataManager manager, List<QuotaRecord.EntityData> entity, Tuple2<String, Object> quota) {
        manager.handleQuotaRecord(new QuotaRecord().setEntity(CollectionConverters$.MODULE$.SeqHasAsJava(entity).asJava()).setKey((String)quota._1()).setValue(quota._2$mcD$sp()));
    }

    public void addQuotaRemovalRecord(ClientQuotaMetadataManager manager, List<QuotaRecord.EntityData> entity, String quota) {
        manager.handleQuotaRecord(new QuotaRecord().setEntity(CollectionConverters$.MODULE$.SeqHasAsJava(entity).asJava()).setKey(quota).setRemove(true));
    }

    public void entityToFilter(List<QuotaRecord.EntityData> entity, ListBuffer<ClientQuotaFilterComponent> components) {
        entity.foreach((Function1 & Serializable)entityData -> {
            if (entityData.entityName() == null) {
                return (ListBuffer)components.append((Object)ClientQuotaFilterComponent.ofDefaultEntity((String)entityData.entityType()));
            }
            return (ListBuffer)components.append((Object)ClientQuotaFilterComponent.ofEntity((String)entityData.entityType(), (String)entityData.entityName()));
        });
    }

    public List<QuotaRecord.EntityData> clientEntity(String clientId) {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaRecord.EntityData[]{new QuotaRecord.EntityData().setEntityType("client-id").setEntityName(clientId)}));
    }

    public List<QuotaRecord.EntityData> userEntity(String user) {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaRecord.EntityData[]{new QuotaRecord.EntityData().setEntityType("user").setEntityName(user)}));
    }

    public List<QuotaRecord.EntityData> userClientEntity(String user, String clientId) {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaRecord.EntityData[]{new QuotaRecord.EntityData().setEntityType("user").setEntityName(user), new QuotaRecord.EntityData().setEntityType("client-id").setEntityName(clientId)}));
    }

    public List<QuotaRecord.EntityData> ipEntity(String ip) {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new QuotaRecord.EntityData[]{new QuotaRecord.EntityData().setEntityType("ip").setEntityName(ip)}));
    }

    public static final /* synthetic */ void $anonfun$testDescribeStrictMatch$1(ClientQuotaMetadataManagerTest $this, List x0$1, Tuple2 x1$1) {
        ListBuffer components = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        $this.entityToFilter((List<QuotaRecord.EntityData>)x0$1, (ListBuffer<ClientQuotaFilterComponent>)components);
        scala.collection.immutable.Map results = $this.cache().describeClientQuotas(components.toSeq(), true);
        Assertions.assertEquals((int)1, (int)results.size(), (String)new StringBuilder(32).append("Should only match one quota for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testDescribeStrictMatch$2(ClientQuotaMetadataManagerTest $this, List entity) {
        ListBuffer components = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        $this.entityToFilter((List<QuotaRecord.EntityData>)entity, (ListBuffer<ClientQuotaFilterComponent>)components);
        scala.collection.immutable.Map results = $this.cache().describeClientQuotas(components.toSeq(), true);
        Assertions.assertEquals((int)0, (int)results.size());
    }

    public static final /* synthetic */ void $anonfun$testDescribeNonStrictMatch$1(List x0$1, Tuple2 x1$1) {
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonStrictMatch$4(QuotaEntity quotaEntity) {
        boolean bl = DefaultUserEntity$.MODULE$.equals(quotaEntity) ? true : (quotaEntity instanceof DefaultUserExplicitClientIdEntity ? true : DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity));
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeNonStrictMatch$5(QuotaEntity quotaEntity) {
        boolean bl = DefaultClientIdEntity$.MODULE$.equals(quotaEntity) ? true : (quotaEntity instanceof ExplicitUserDefaultClientIdEntity ? true : DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity));
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$testDescribeFilterOnTypes$1(List x0$1, Tuple2 x1$1) {
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeFilterOnTypes$2(QuotaEntity quotaEntity) {
        boolean bl = quotaEntity instanceof UserEntity ? true : (DefaultUserEntity$.MODULE$.equals(quotaEntity) ? true : (quotaEntity instanceof ExplicitUserExplicitClientIdEntity ? true : (quotaEntity instanceof ExplicitUserDefaultClientIdEntity ? true : (quotaEntity instanceof DefaultUserExplicitClientIdEntity ? true : DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity)))));
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeFilterOnTypes$3(QuotaEntity quotaEntity) {
        boolean bl = quotaEntity instanceof ClientIdEntity ? true : (DefaultClientIdEntity$.MODULE$.equals(quotaEntity) ? true : (quotaEntity instanceof ExplicitUserExplicitClientIdEntity ? true : (quotaEntity instanceof ExplicitUserDefaultClientIdEntity ? true : (quotaEntity instanceof DefaultUserExplicitClientIdEntity ? true : DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity)))));
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeFilterOnTypes$4(QuotaEntity quotaEntity) {
        boolean bl = quotaEntity instanceof ExplicitUserExplicitClientIdEntity ? true : (quotaEntity instanceof ExplicitUserDefaultClientIdEntity ? true : (quotaEntity instanceof DefaultUserExplicitClientIdEntity ? true : DefaultUserDefaultClientIdEntity$.MODULE$.equals(quotaEntity)));
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$setupAndVerify$1(ClientQuotaMetadataManagerTest $this, ClientQuotaMetadataManager manager$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            List entity = (List)x0$1._1();
            double value = x0$1._2$mcD$sp();
            $this.addQuotaRecord(manager$1, (List<QuotaRecord.EntityData>)entity, (Tuple2<String, Object>)new Tuple2((Object)"request_percentage", (Object)BoxesRunTime.boxToDouble((double)value)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$setupAndVerify$2(Function2 verifier$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            List entity = (List)x0$2._1();
            double value = x0$2._2$mcD$sp();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)verifier$1.apply((Object)entity, (Object)new Tuple2((Object)"request_percentage", (Object)BoxesRunTime.boxToDouble((double)value)));
            return;
        }
        throw new MatchError(null);
    }
}

