/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.AppendOrigin;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogTest$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.raft.metadata.MetadataRecordSerde;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001\u0002\u0010 \u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\bu\u0001\u0011\r\u0011\"\u00011\u0011\u0019Y\u0004\u0001)A\u0005c!9A\b\u0001b\u0001\n\u0003i\u0004B\u0002#\u0001A\u0003%a\bC\u0004F\u0001\t\u0007I\u0011\u0001$\t\rE\u0003\u0001\u0015!\u0003H\u0011\u001d\u0011\u0006A1A\u0005\u0002\u0019Caa\u0015\u0001!\u0002\u00139\u0005b\u0002+\u0001\u0005\u0004%\tA\u0012\u0005\u0007+\u0002\u0001\u000b\u0011B$\t\u000fY\u0003!\u0019!C\u0001/\"1a\f\u0001Q\u0001\naCqa\u0018\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004m\u0001\u0001\u0006I!\u0019\u0005\n[\u0002\u0001\r\u00111A\u0005\u00029D\u0011\u0002\u001e\u0001A\u0002\u0003\u0007I\u0011A;\t\u0013m\u0004\u0001\u0019!A!B\u0013y\u0007\"\u0002?\u0001\t\u0003i\bBBA\f\u0001\u0011\u0005Q\u0010\u0003\u0004\u0002\u001a\u0001!\t! \u0005\u0007\u0003G\u0001A\u0011A?\t\r\u00055\u0002\u0001\"\u0001~\u0011\u0019\t\t\u0004\u0001C\u0001{\"1\u0011Q\u0007\u0001\u0005\u0002uDa!!\u000f\u0001\t\u0003i\bbBA\u001f\u0001\u0011%\u0011q\b\u0002\u0014\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugR+7\u000f\u001e\u0006\u0003A\u0005\nQ\u0001^8pYNT\u0011AI\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003}\ta\u0001^7q\t&\u0014X#A\u0019\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014AA5p\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013aC:fO6,g\u000e\u001e(b[\u0016,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003V\nA\u0001\\1oO&\u00111\t\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019M,w-\\3oi:\u000bW.\u001a\u0011\u0002\u00171|wMR5mKB\u000bG\u000f[\u000b\u0002\u000fB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"AS\u0014\u000e\u0003-S!\u0001T\u0012\u0002\rq\u0012xn\u001c;?\u0013\tqu%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007BS!AT\u0014\u0002\u00191|wMR5mKB\u000bG\u000f\u001b\u0011\u0002\u001b%tG-\u001a=GS2,\u0007+\u0019;i\u00039Ig\u000eZ3y\r&dW\rU1uQ\u0002\n\u0011\u0003^5nK&sG-\u001a=GS2,\u0007+\u0019;i\u0003I!\u0018.\\3J]\u0012,\u0007PR5mKB\u000bG\u000f\u001b\u0011\u0002\tQLW.Z\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111,I\u0001\u0006kRLGn]\u0005\u0003;j\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\bE\u0006$8\r[3t+\u0005\t\u0007c\u00012hS6\t1M\u0003\u0002eK\u00069Q.\u001e;bE2,'B\u00014(\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Q\u000e\u00141\"\u0011:sCf\u0014UO\u001a4feB\u0011aF[\u0005\u0003W~\u0011\u0011BQ1uG\"LeNZ8\u0002\u0011\t\fGo\u00195fg\u0002\n1\u0001\\8h+\u0005y\u0007C\u00019s\u001b\u0005\t(BA7\"\u0013\t\u0019\u0018OA\u0002M_\u001e\fq\u0001\\8h?\u0012*\u0017\u000f\u0006\u0002wsB\u0011ae^\u0005\u0003q\u001e\u0012A!\u00168ji\"9!pEA\u0001\u0002\u0004y\u0017a\u0001=%c\u0005!An\\4!\u0003\u0015\u0019X\r^+q)\u00051\bFA\u000b\u0000!\u0011\t\t!a\u0005\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t1!\u00199j\u0015\u0011\tI!a\u0003\u0002\u000f),\b/\u001b;fe*!\u0011QBA\b\u0003\u0015QWO\\5u\u0015\t\t\t\"A\u0002pe\u001eLA!!\u0006\u0002\u0004\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!\u0005$GmU5na2,'+Z2pe\u0012\u001c\u0018\u0001\u0003;fCJ$un\u001e8)\u0007]\ti\u0002\u0005\u0003\u0002\u0002\u0005}\u0011\u0002BA\u0011\u0003\u0007\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002!Q,7\u000f\u001e)sS:$H)\u0019;b\u0019><\u0007f\u0001\r\u0002(A!\u0011\u0011AA\u0015\u0013\u0011\tY#a\u0001\u0003\tQ+7\u000f^\u0001\u0018i\u0016\u001cH\u000fR;na&sG-\u001a=NSNl\u0017\r^2iKND3!GA\u0014\u0003]!Xm\u001d;Ek6\u0004H+[7f\u0013:$W\r_#se>\u00148\u000fK\u0002\u001b\u0003O\tq\u0003^3ti\u0012+X\u000e]'fi\u0006$\u0017\r^1SK\u000e|'\u000fZ:)\u0007m\t9#\u0001\nuKN$H)^7q\u000b6\u0004H/_%oI\u0016D\bf\u0001\u000f\u0002(\u0005\u0011\"/\u001e8Ek6\u0004Hj\\4TK\u001elWM\u001c;t)\r9\u0015\u0011\t\u0005\b\u0003\u0007j\u0002\u0019AA#\u0003\u0011\t'oZ:\u0011\t\u0019\n9eR\u0005\u0004\u0003\u0013:#!B!se\u0006L\b")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private Log log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2());
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        boolean bl = true;
        boolean bl2 = true;
        this.log_$eq(Log$.MODULE$.apply(x$1, x$2, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 3600000, x$9, x$10, bl, bl2));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)));
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable)batchInfo -> {
            void withRecords_records;
            void withRecords_partitionLeaderEpoch;
            MemoryRecords memoryRecords;
            Log qual$1 = this.log();
            SimpleRecord[] simpleRecordArray = (SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            boolean bl = false;
            CompressionType withRecords_compressionType = CompressionType.NONE;
            MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
            Object var6_5 = null;
            simpleRecordArray = null;
            memoryRecords = null;
            MemoryRecords x$1 = memoryRecords2;
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            ApiVersion x$4 = qual$1.appendAsLeader$default$4();
            return qual$1.appendAsLeader(x$1, 0, x$3, x$4);
        });
        this.log().flush();
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(true, new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()});
        this.verifyRecordsInOutput$1(false, new String[]{"--deep-iteration", "--files", this.logFilePath()});
        this.verifyNoRecordsInOutput$1(new String[]{"--files", this.logFilePath()});
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDumpMetadataRecords() {
        void withRecords_timestampType;
        void withRecords_records;
        void withRecords_timestampType2;
        void withRecords_timestampType3;
        String string;
        String string2;
        MockTime mockTime = new MockTime();
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string3 = string2 = Defaults$.MODULE$.CleanupPolicy();
        string2 = null;
        String x$6 = string3;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        String string4 = string = Defaults$.MODULE$.MessageFormatVersion();
        string = null;
        String x$10 = string4;
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTest$.MODULE$.createLogConfig(l, 0x100000, l2, l3, l4, x$6, n, n2, n3, x$10, l5);
        Log log = LogTest$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), mockTime.scheduler(), (Time)mockTime, 0L, 0L, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true, true);
        SimpleRecord[] records = (SimpleRecord[])((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))), (short)0)}))).map((Function1 & Serializable)message -> {
            MetadataRecordSerde serde = new MetadataRecordSerde();
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        })).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var25_17 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType3, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.flush();
        String output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "false", "--files", this.logFilePath()});
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "false", "--files", this.logFilePath()});
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(null, buf.array())};
        CompressionType withRecords_compressionType2 = CompressionType.NONE;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var26_25 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType2, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        byte withRecords_magic3 = 2;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset3 = 0L;
        timestampType3 = null;
        Object var28_29 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic3, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType3, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        output = this.runDumpLogSegments(new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "false", "--files", this.logFilePath()});
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        Predef$.MODULE$.assert(output.contains("skipping"));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)recordIndex -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((IterableOnceOps)this.batches().zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$2) {
        return x$2.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.batches().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$2)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(0).append(suffix).append(new StringBuilder(18).append(" key: message key ").append(offset$1.elem).toString()).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(0).append(suffix).append(new StringBuilder(24).append(" payload: message value ").append(offset$1.elem).toString()).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

