/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.FinalizedFeatureCache;
import kafka.server.FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$;
import kafka.server.FinalizedFeatureChangeListener$ZkStateChangeHandler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.FeatureZNodeStatus$Disabled$;
import kafka.zk.FeatureZNodeStatus$Enabled$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.internals.FatalExitError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\u0015+\u0001=B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%I!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005}!A1\t\u0001BC\u0002\u0013%A\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003F\u0011\u0015a\u0005\u0001\"\u0001N\r\u0011\t\u0006\u0001\u0002*\t\u0011M3!\u0011!Q\u0001\nQC\u0001b\u0018\u0004\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006\u0019\u001a!\t!\u001c\u0005\u0006\u0019\u001a!\tA\u001d\u0005\u0006i\u001a!\t!\u001e\u0005\u0006s\u001a!\tA\u001f\u0004\u0007\u0003\u0003\u0001A!a\u0001\t\u0017\u0005-QB!A!\u0002\u0013!\u0016Q\u0002\u0005\u0007\u00196!\t!a\u0004\t\r\u0005UQ\u0002\"\u0011v\u000f\u001d\t9\u0002\u0001E\u0001\u000331q!a\u0007\u0001\u0011\u0003\ti\u0002\u0003\u0004M%\u0011\u0005\u00111\u0006\u0005\n\u0003[\u0011\"\u0019!C!\u0003_Aq!!\r\u0013A\u0003%A\u000b\u0003\u0004\u00024I!\t%\u001e\u0005\u0007\u0003k\u0011B\u0011I;\t\r\u0005]\"\u0003\"\u0011v\u000f\u001d\tI\u0004\u0001E\u0001\u0003w1q!!\u0010\u0001\u0011\u0003\ty\u0004\u0003\u0004M5\u0011\u0005\u0011q\t\u0005\n\u0003[Q\"\u0019!C\u0001\u0003_Aq!!\r\u001bA\u0003%A\u000bC\u0005\u0002\fi\u0011\r\u0011\"\u0011\u00020!9\u0011\u0011\n\u000e!\u0002\u0013!\u0006BBA&5\u0011\u0005S\u000fC\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002P!A\u0011q\u000b\u0001!\u0002\u0013\t\t\u0006C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002\\!A\u0011Q\f\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002`\u0001!\t!!\u0019\t\r\u0005\u001d\u0004\u0001\"\u0001v\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!a\u001d\u0001\t\u0003\tYG\u0001\u0010GS:\fG.\u001b>fI\u001a+\u0017\r^;sK\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe*\u00111\u0006L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001aY\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0007CA\u001c;\u001b\u0005A$BA\u001d-\u0003\u0015)H/\u001b7t\u0013\tY\u0004HA\u0004M_\u001e<\u0017N\\4\u0002+\u0019Lg.\u00197ju\u0016$g)Z1ukJ,7)Y2iKV\ta\b\u0005\u0002@\u00016\t!&\u0003\u0002BU\t)b)\u001b8bY&TX\r\u001a$fCR,(/Z\"bG\",\u0017A\u00064j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:f\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u0011i\\7\t\\5f]R,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u00112\n!A_6\n\u0005);%!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u00051A(\u001b8jiz\"2AT(Q!\ty\u0004\u0001C\u0003=\u000b\u0001\u0007a\bC\u0003D\u000b\u0001\u0007QIA\nGK\u0006$XO]3DC\u000eDW-\u00169eCR,'o\u0005\u0002\u0007a\u0005\tb-Z1ukJ,'l\u001b(pI\u0016\u0004\u0016\r\u001e5\u0011\u0005UcfB\u0001,[!\t9&'D\u0001Y\u0015\tIf&\u0001\u0004=e>|GOP\u0005\u00037J\na\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111LM\u0001\u0010[\u0006L(-\u001a(pi&4\u0017p\u00148dKB\u0019\u0011'Y2\n\u0005\t\u0014$AB(qi&|g\u000e\u0005\u0002eW6\tQM\u0003\u0002gO\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005!L\u0017\u0001B;uS2T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mK\nq1i\\;oi\u0012{wO\u001c'bi\u000eDGc\u00018qcB\u0011qNB\u0007\u0002\u0001!)1+\u0003a\u0001)\")q,\u0003a\u0001AR\u0011an\u001d\u0005\u0006'*\u0001\r\u0001V\u0001\u0014kB$\u0017\r^3MCR,7\u000f^(s)\"\u0014xn\u001e\u000b\u0002mB\u0011\u0011g^\u0005\u0003qJ\u0012A!\u00168ji\u0006\u0011\u0012m^1jiV\u0003H-\u0019;f\u001fJ$\u0006N]8x)\t18\u0010C\u0003}\u0019\u0001\u0007Q0\u0001\u0006xC&$H+[7f\u001bN\u0004\"!\r@\n\u0005}\u0014$\u0001\u0002'p]\u001e\u0014\u0011e\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]B\u0013xnY3tg>\u0014H\u000b\u001b:fC\u0012\u001c2!DA\u0003!\r9\u0014qA\u0005\u0004\u0003\u0013A$AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\fAA\\1nK&!\u00111BA\u0004)\u0011\t\t\"a\u0005\u0011\u0005=l\u0001BBA\u0006\u001f\u0001\u0007A+\u0001\u0004e_^{'o[\u0001\u001a\r\u0016\fG/\u001e:f5:{G-Z\"iC:<W\rS1oI2,'\u000f\u0005\u0002p%\tIb)Z1ukJ,'LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s'\u0011\u0011\u0002'a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n-\u0003%Qxn\\6fKB,'/\u0003\u0003\u0002*\u0005\r\"A\u0005.O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJ$\"!!\u0007\u0002\tA\fG\u000f[\u000b\u0002)\u0006)\u0001/\u0019;iA\u0005q\u0001.\u00198eY\u0016\u001c%/Z1uS>t\u0017\u0001\u00055b]\u0012dW\rR1uC\u000eC\u0017M\\4f\u00039A\u0017M\u001c3mK\u0012+G.\u001a;j_:\fACW6Ti\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\bCA8\u001b\u0005QQ6n\u0015;bi\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7feN!!\u0004MA!!\u0011\t\t#a\u0011\n\t\u0005\u0015\u00131\u0005\u0002\u0013'R\fG/Z\"iC:<W\rS1oI2,'\u000f\u0006\u0002\u0002<\u0005)a.Y7fA\u0005A\u0012M\u001a;fe&s\u0017\u000e^5bY&T\u0018N\\4TKN\u001c\u0018n\u001c8\u0002\u000bE,X-^3\u0016\u0005\u0005E\u0003\u0003\u00023\u0002T9L1!!\u0016f\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f\u0003\u0019\tX/Z;fA\u00051A\u000f\u001b:fC\u0012,\"!!\u0005\u0002\u000fQD'/Z1eA\u0005Y\u0011N\\5u\u001fJ$\u0006N]8x)\r1\u00181\r\u0005\u0007\u0003K*\u0003\u0019A?\u00021]\f\u0017\u000e^(oG\u00164uN]\"bG\",W\u000b\u001d3bi\u0016l5/A\u0003dY>\u001cX-A\njg2K7\u000f^3oKJLe.\u001b;jCR,G-\u0006\u0002\u0002nA\u0019\u0011'a\u001c\n\u0007\u0005E$GA\u0004C_>dW-\u00198\u0002\u001d%\u001cH*[:uK:,'\u000fR3bI\u0002")
public class FinalizedFeatureChangeListener
implements Logging {
    private volatile FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$ FeatureZNodeChangeHandler$module;
    private volatile FinalizedFeatureChangeListener$ZkStateChangeHandler$ ZkStateChangeHandler$module;
    private final FinalizedFeatureCache kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache;
    private final KafkaZkClient kafka$server$FinalizedFeatureChangeListener$$zkClient;
    private final LinkedBlockingQueue<FeatureCacheUpdater> kafka$server$FinalizedFeatureChangeListener$$queue;
    private final ChangeNotificationProcessorThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$ FeatureZNodeChangeHandler() {
        if (this.FeatureZNodeChangeHandler$module == null) {
            this.FeatureZNodeChangeHandler$lzycompute$1();
        }
        return this.FeatureZNodeChangeHandler$module;
    }

    public FinalizedFeatureChangeListener$ZkStateChangeHandler$ ZkStateChangeHandler() {
        if (this.ZkStateChangeHandler$module == null) {
            this.ZkStateChangeHandler$lzycompute$1();
        }
        return this.ZkStateChangeHandler$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FinalizedFeatureCache kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache() {
        return this.kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache;
    }

    public KafkaZkClient kafka$server$FinalizedFeatureChangeListener$$zkClient() {
        return this.kafka$server$FinalizedFeatureChangeListener$$zkClient;
    }

    public LinkedBlockingQueue<FeatureCacheUpdater> kafka$server$FinalizedFeatureChangeListener$$queue() {
        return this.kafka$server$FinalizedFeatureChangeListener$$queue;
    }

    private ChangeNotificationProcessorThread thread() {
        return this.thread;
    }

    public void initOrThrow(long waitOnceForCacheUpdateMs) {
        if (waitOnceForCacheUpdateMs <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Expected waitOnceForCacheUpdateMs > 0, but provided: ").append(waitOnceForCacheUpdateMs).toString());
        }
        this.thread().start();
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().registerStateChangeHandler(this.ZkStateChangeHandler());
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().registerZNodeChangeHandlerAndCheckExistence(this.FeatureZNodeChangeHandler());
        FeatureCacheUpdater ensureCacheUpdateOnce = new FeatureCacheUpdater(this, this.FeatureZNodeChangeHandler().path(), (Option<CountDownLatch>)new Some((Object)new CountDownLatch(1)));
        this.kafka$server$FinalizedFeatureChangeListener$$queue().add(ensureCacheUpdateOnce);
        try {
            ensureCacheUpdateOnce.awaitUpdateOrThrow(waitOnceForCacheUpdateMs);
            return;
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().unregisterStateChangeHandler(this.ZkStateChangeHandler().name());
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().unregisterZNodeChangeHandler(this.FeatureZNodeChangeHandler().path());
        this.kafka$server$FinalizedFeatureChangeListener$$queue().clear();
        this.thread().shutdown();
        this.thread().join();
    }

    public boolean isListenerInitiated() {
        return this.thread().isRunning() && this.thread().isAlive();
    }

    public boolean isListenerDead() {
        return !this.thread().isRunning() && !this.thread().isAlive();
    }

    private final void FeatureZNodeChangeHandler$lzycompute$1() {
        synchronized (this) {
            if (this.FeatureZNodeChangeHandler$module == null) {
                this.FeatureZNodeChangeHandler$module = new FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$(this);
            }
            return;
        }
    }

    private final void ZkStateChangeHandler$lzycompute$1() {
        synchronized (this) {
            if (this.ZkStateChangeHandler$module == null) {
                this.ZkStateChangeHandler$module = new FinalizedFeatureChangeListener$ZkStateChangeHandler$(this);
            }
            return;
        }
    }

    public FinalizedFeatureChangeListener(FinalizedFeatureCache finalizedFeatureCache, KafkaZkClient zkClient) {
        this.kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache = finalizedFeatureCache;
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient = zkClient;
        this.kafka$server$FinalizedFeatureChangeListener$$queue = new LinkedBlockingQueue();
        this.thread = new ChangeNotificationProcessorThread("feature-zk-node-event-process-thread");
    }

    private class ChangeNotificationProcessorThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            try {
                this.kafka$server$FinalizedFeatureChangeListener$ChangeNotificationProcessorThread$$$outer().kafka$server$FinalizedFeatureChangeListener$$queue().take().updateLatestOrThrow();
                return;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to process feature ZK node change event. The broker will eventually exit.", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                throw new FatalExitError(1);
            }
        }

        public /* synthetic */ FinalizedFeatureChangeListener kafka$server$FinalizedFeatureChangeListener$ChangeNotificationProcessorThread$$$outer() {
            return FinalizedFeatureChangeListener.this;
        }

        public ChangeNotificationProcessorThread(String name) {
            if (FinalizedFeatureChangeListener.this == null) {
                throw null;
            }
            super(name, true);
        }
    }

    private class FeatureCacheUpdater {
        private final String featureZkNodePath;
        private final Option<CountDownLatch> maybeNotifyOnce;
        public final /* synthetic */ FinalizedFeatureChangeListener $outer;

        /*
         * WARNING - void declaration
         */
        public void updateLatestOrThrow() {
            this.maybeNotifyOnce.foreach((Function1 & Serializable)notifier -> {
                FeatureCacheUpdater.$anonfun$updateLatestOrThrow$1(notifier);
                return BoxedUnit.UNIT;
            });
            this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Reading feature ZK node at path: ").append($this.featureZkNodePath).toString());
            Tuple2<Option<byte[]>, Object> tuple2 = this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$zkClient().getDataAndVersion(this.featureZkNodePath);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (n == ZkVersion$.MODULE$.UnknownVersion()) {
                this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Feature ZK node at path: ").append($this.featureZkNodePath).append(" does not exist").toString());
                this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clear();
            } else {
                Option maybeFeatureZNode = Option$.MODULE$.empty();
                try {
                    void var2_2;
                    maybeFeatureZNode = new Some((Object)FeatureZNode$.MODULE$.decode((byte[])var2_2.get()));
                }
                catch (IllegalArgumentException e) {
                    this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Unable to deserialize feature ZK node at path: ").append($this.featureZkNodePath).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clear();
                }
                maybeFeatureZNode.foreach((Function1 & Serializable)featureZNode -> {
                    FeatureCacheUpdater.$anonfun$updateLatestOrThrow$6(this, n, featureZNode);
                    return BoxedUnit.UNIT;
                });
            }
            this.maybeNotifyOnce.foreach((Function1 & Serializable)notifier -> {
                notifier.countDown();
                return BoxedUnit.UNIT;
            });
        }

        public void awaitUpdateOrThrow(long waitTimeMs) {
            this.maybeNotifyOnce.foreach((Function1 & Serializable)notifier -> {
                FeatureCacheUpdater.$anonfun$awaitUpdateOrThrow$1(waitTimeMs, notifier);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ FinalizedFeatureChangeListener kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$updateLatestOrThrow$1(CountDownLatch notifier) {
            if (notifier.getCount() != 1L) {
                throw new IllegalStateException("Can not notify after updateLatestOrThrow was called more than once successfully.");
            }
        }

        public static final /* synthetic */ void $anonfun$updateLatestOrThrow$6(FeatureCacheUpdater $this, int version$1, FeatureZNode featureZNode) {
            FeatureZNodeStatus featureZNodeStatus = featureZNode.status();
            if (FeatureZNodeStatus$Disabled$.MODULE$.equals(featureZNodeStatus)) {
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Feature ZK node at path: ").append($this.featureZkNodePath).append(" is in disabled status.").toString());
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clear();
                return;
            }
            if (FeatureZNodeStatus$Enabled$.MODULE$.equals(featureZNodeStatus)) {
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().updateOrThrow(featureZNode.features(), version$1);
                return;
            }
            throw new IllegalStateException(new StringBuilder(39).append("Unexpected FeatureZNodeStatus found in ").append(featureZNode).toString());
        }

        public static final /* synthetic */ void $anonfun$awaitUpdateOrThrow$1(long waitTimeMs$1, CountDownLatch notifier) {
            if (!notifier.await(waitTimeMs$1, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException(new StringBuilder(62).append("Timed out after waiting for ").append(waitTimeMs$1).append("ms for FeatureCache to be updated.").toString());
            }
        }

        public FeatureCacheUpdater(FinalizedFeatureChangeListener $outer, String featureZkNodePath, Option<CountDownLatch> maybeNotifyOnce) {
            this.featureZkNodePath = featureZkNodePath;
            this.maybeNotifyOnce = maybeNotifyOnce;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }

        public FeatureCacheUpdater(FinalizedFeatureChangeListener $outer, String featureZkNodePath) {
            this($outer, featureZkNodePath, (Option<CountDownLatch>)Option$.MODULE$.empty());
        }
    }
}

