/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.CommittedIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.IsrState;
import kafka.cluster.OngoingReassignmentState;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PendingShrinkIsr;
import kafka.cluster.Replica;
import kafka.cluster.SimpleAssignmentState;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogReadInfo;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.ZkIsrManager;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001B\u001d;\u0001}BQ\u0001\u0012\u0001\u0005\u0002\u0015CQa\u0012\u0001\u0005\u0002!CQ\u0001\u0018\u0001\u0005\u0002!CQA\u0018\u0001\u0005\u0002!CQ\u0001\u0019\u0001\u0005\u0002!CQA\u0019\u0001\u0005\u0002!CQ\u0001\u001a\u0001\u0005\u0002!CQA\u001a\u0001\u0005\u0002!CQ\u0001\u001b\u0001\u0005\u0002!CQA\u001b\u0001\u0005\u0002!CQ\u0001\u001c\u0001\u0005\u0002!CQA\u001c\u0001\u0005\u0002!CQ\u0001\u001d\u0001\u0005\u0002!CQA\u001d\u0001\u0005\u0002!CQ\u0001\u001e\u0001\u0005\u0002!CQA\u001e\u0001\u0005\u0002!CQ\u0001\u001f\u0001\u0005\u0002!CQA\u001f\u0001\u0005\nmD\u0011\"!\t\u0001#\u0003%I!a\t\t\r\u0005e\u0002\u0001\"\u0001I\u0011\u0019\ti\u0004\u0001C\u0001\u0011\"1\u0011\u0011\t\u0001\u0005\u0002!Ca!!\u0012\u0001\t\u0003A\u0005BBA%\u0001\u0011\u0005\u0001\n\u0003\u0004\u0002N\u0001!\t\u0001\u0013\u0005\b\u0003#\u0002A\u0011AA*\u0011%\tY\nAI\u0001\n\u0003\ti\nC\u0004\u0002\"\u0002!\t!a)\t\r\u0005%\u0006\u0001\"\u0001I\u0011\u0019\ti\u000b\u0001C\u0001\u0011\"1\u0011\u0011\u0017\u0001\u0005\u0002!Ca!!.\u0001\t\u0003A\u0005BBA]\u0001\u0011\u0005\u0001\n\u0003\u0004\u0002>\u0002!\t\u0001\u0013\u0005\u0007\u0003\u0003\u0004A\u0011\u0001%\t\r\u0005\u0015\u0007\u0001\"\u0001I\u0011\u0019\tI\r\u0001C\u0001\u0011\"1\u0011Q\u001a\u0001\u0005\u0002!Ca!!5\u0001\t\u0003A\u0005bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\u0007\u0003g\u0004A\u0011\u0001%\t\r\u0005]\b\u0001\"\u0001I\u0011\u0019\tY\u0010\u0001C\u0001\u0011\"1\u0011q \u0001\u0005\u0002!CaAa\u0001\u0001\t\u0003A\u0005B\u0002B\u0004\u0001\u0011\u0005\u0001\n\u0003\u0004\u0003\f\u0001!\t\u0001\u0013\u0005\u0007\u0005\u001f\u0001A\u0011\u0001%\t\r\tM\u0001\u0001\"\u0001I\u0011\u001d\u00119\u0002\u0001C\u0005\u000531aAa\t\u0001\t\t\u0015\u0002BCA\u000bg\t\u0005\t\u0015!\u0003\u0002\u0018!Q!qE\u001a\u0003\u0002\u0003\u0006IA!\u000b\t\u0015\tU2G!A!\u0002\u0013\u00119\u0004\u0003\u0004Eg\u0011\u0005!1\n\u0005\b\u0005/\u001aD\u0011\tB-\u00055\u0001\u0016M\u001d;ji&|g\u000eV3ti*\u00111\bP\u0001\bG2,8\u000f^3s\u0015\u0005i\u0014!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0003\"!\u0011\"\u000e\u0003iJ!a\u0011\u001e\u0003+\u0005\u00137\u000f\u001e:bGR\u0004\u0016M\u001d;ji&|g\u000eV3ti\u00061A(\u001b8jiz\"\u0012A\u0012\t\u0003\u0003\u0002\tq\u0004^3ti2\u000b7\u000f\u001e$fi\u000eDW\rZ(gMN,GOV1mS\u0012\fG/[8o)\u0005I\u0005C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%\u0001B+oSRD#A\u0001)\u0011\u0005ESV\"\u0001*\u000b\u0005M#\u0016aA1qS*\u0011QKV\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0006,A\u0003kk:LGOC\u0001Z\u0003\ry'oZ\u0005\u00037J\u0013A\u0001V3ti\u0006yB/Z:u\u001b\u0006\\W\rT3bI\u0016\u0014X\u000b\u001d3bi\u0016\u001cX\t]8dQ\u000e\u000b7\r[3)\u0005\r\u0001\u0016A\r;fgRl\u0015m[3MK\u0006$WM\u001d#pKNtu\u000e^+qI\u0006$X-\u00129pG\"\u001c\u0015m\u00195f\r>\u0014x\n\u001c3G_Jl\u0017\r^:)\u0005\u0011\u0001\u0016\u0001\u000b;fgRl\u0015-\u001f2f%\u0016\u0004H.Y2f\u0007V\u0014(/\u001a8u/&$\bNR;ukJ,'+\u001a9mS\u000e\f\u0007FA\u0003Q\u00035\"Xm\u001d;NC.,gi\u001c7m_^,'oV5uQ^KG\u000f\u001b$pY2|w/\u001a:BaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0015\u0003\rA\u000bA\b^3ti6\u000b\u0017PY3SKBd\u0017mY3DkJ\u0014XM\u001c;XSRDg)\u001e;ve\u0016\u0014V\r\u001d7jG\u0006$\u0015N\u001a4fe\u0016tGOQ1tK>3gm]3ug\"\u0012q\u0001U\u00010i\u0016\u001cHOR3uG\"|eMZ:fiNs\u0017\r]:i_R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:MK\u0006$WM\u001d\u0015\u0003\u0011A\u000b\u0011\u0007^3ti\u001a+Go\u00195PM\u001a\u001cX\r^*oCB\u001c\bn\u001c;Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014hi\u001c7m_^,'\u000f\u000b\u0002\n!\u0006YC/Z:u\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d'fC\u0012,'\u000f\u000b\u0002\u000b!\u0006iC/Z:u\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d$pY2|w/\u001a:)\u0005-\u0001\u0016A\n;fgR\u0014V-\u00193SK\u000e|'\u000fZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\u0012A\u0002U\u0001)i\u0016\u001cHOU3bIJ+7m\u001c:e\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'OR8mY><XM\u001d\u0015\u0003\u001bA\u000b1\u0007^3ti\u001a+Go\u00195PM\u001a\u001cX\r\u001e$peRKW.Z:uC6\u0004X\t]8dQZ\u000bG.\u001b3bi&|gNR8s\u0019\u0016\fG-\u001a:)\u00059\u0001\u0016!\u000e;fgR4U\r^2i\u001f\u001a47/\u001a;G_J$\u0016.\\3ti\u0006l\u0007/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe\u001a{G\u000e\\8xKJD#a\u0004)\u0002QQ,7\u000f\u001e$fi\u000eDG*\u0019;fgR|eMZ:fi&s7\r\\;eKNdU-\u00193fe\u0016\u0003xn\u00195)\u0005A\u0001\u0016!\n;fgRluN\\8u_:L7m\u00144gg\u0016$8/\u00114uKJdU-\u00193fe\u000eC\u0017M\\4fQ\t\t\u0002+A\ftKR,\b\u000fU1si&$\u0018n\u001c8XSRDWj\\2lgR1Ap`A\u0005\u0003'\u0001\"!Q?\n\u0005yT$!\u0003)beRLG/[8o\u0011\u001d\t\tA\u0005a\u0001\u0003\u0007\t1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019!*!\u0002\n\u0007\u0005\u001d1JA\u0002J]RDq!a\u0003\u0013\u0001\u0004\ti!\u0001\u0005jg2+\u0017\rZ3s!\rQ\u0015qB\u0005\u0004\u0003#Y%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003+\u0011\u0002\u0013!a\u0001\u0003/\t1\u0001\\8h!\u0011\tI\"!\b\u000e\u0005\u0005m!bAA\u000by%!\u0011qDA\u000e\u0005\raunZ\u0001\"g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$C-\u001a4bk2$HeM\u000b\u0003\u0003KQC!a\u0006\u0002(-\u0012\u0011\u0011\u0006\t\u0005\u0003W\t)$\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003%)hn\u00195fG.,GMC\u0002\u00024-\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9$!\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0018uKN$\u0018\t\u001d9f]\u0012\u0014VmY8sIN\f5OR8mY><XM\u001d\"fY><Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bF\u0001\u000bQ\u0003u!Xm\u001d;MSN$xJ\u001a4tKRL5o\u001c7bi&|g\u000eT3wK2\u001c\bFA\u000bQ\u00039!Xm\u001d;HKR\u0014V\r\u001d7jG\u0006D#A\u0006)\u0002oQ,7\u000f^!qa\u0016tGMU3d_J$7\u000fV8G_2dwn^3s/&$\bNT8SKBd\u0017nY1UQJ|wo]#yG\u0016\u0004H/[8oQ\t9\u0002+\u0001\u0013uKN$X*Y6f\r>dGn\\<fe^KG\u000f\u001b(p\u0019\u0016\fG-\u001a:JI\u000eC\u0017M\\4fQ\tA\u0002+A$uKN$hi\u001c7m_^,'\u000fR8fg:{GOS8j]&\u001b&+\u00168uS2\u001c\u0015-^4iiV\u0003Hk\\(gMN,GoV5uQ&t7)\u001e:sK:$H*Z1eKJ,\u0005o\\2iQ\tI\u0002+A\u0007de\u0016\fG/\u001a*fG>\u0014Hm\u001d\u000b\t\u0003+\nY'!$\u0002\u0018B!\u0011qKA4\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013A\u0002:fG>\u0014HM\u0003\u0003\u0002`\u0005\u0005\u0014AB2p[6|gNC\u0002>\u0003GR1!!\u001aY\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011NA-\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011Q\u000e\u000eA\u0002\u0005=\u0014a\u0002:fG>\u0014Hm\u001d\t\u0007\u0003c\n\t)a\"\u000f\t\u0005M\u0014Q\u0010\b\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010 \u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0015bAA@\u0017\u00069\u0001/Y2lC\u001e,\u0017\u0002BAB\u0003\u000b\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u007fZ\u0005\u0003BA,\u0003\u0013KA!a#\u0002Z\ta1+[7qY\u0016\u0014VmY8sI\"9\u0011q\u0012\u000eA\u0002\u0005E\u0015A\u00032bg\u0016|eMZ:fiB\u0019!*a%\n\u0007\u0005U5J\u0001\u0003M_:<\u0007\"CAM5A\u0005\t\u0019AA\u0002\u0003Q\u0001\u0018M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t]8dQ\u000692M]3bi\u0016\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0003\u0003?SC!a\u0001\u0002(\u0005Q2M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYJ+7m\u001c:egR1\u0011QKAS\u0003OCq!!\u001c\u001d\u0001\u0004\ty\u0007C\u0004\u0002\u0010r\u0001\r!!%\u0002\u0019Q,7\u000f^!u\u001b&t\u0017j\u001d:)\u0005u\u0001\u0016\u0001\b;fgR,\u0006\u000fZ1uK\u001a{G\u000e\\8xKJ4U\r^2i'R\fG/\u001a\u0015\u0003=A\u000b\u0001\u0003^3ti&\u001b(/\u0012=qC:\u001c\u0018n\u001c8)\u0005}\u0001\u0016a\b;fgRL5O\u001d(pi\u0016C\b/\u00198eK\u0012Le-\u00169eCR,g)Y5mg\"\u0012\u0001\u0005U\u0001\u0013i\u0016\u001cH/T1zE\u0016\u001c\u0006N]5oW&\u001b(\u000f\u000b\u0002\"!\u0006yC/Z:u'\"|W\u000f\u001c3O_R\u001c\u0006N]5oW&\u001b(/\u00134Qe\u00164\u0018n\\;t\r\u0016$8\r[%t\u0007\u0006,x\r\u001b;Va\"\u0012!\u0005U\u00011i\u0016\u001cHo\u00155pk2$gj\u001c;TQJLgn[%te&3gi\u001c7m_^,'oQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\u0005\r\u0002\u0016!\b;fgRL5O\u001d(piNC'/\u001e8l\u0013\u001a,\u0006\u000fZ1uK\u001a\u000b\u0017\u000e\\:)\u0005\u0011\u0002\u0016\u0001\u0007;fgR\fE\u000e^3s\u0013N\u0014XK\\6o_^tGk\u001c9jG\"\u0012Q\u0005U\u0001\u001bi\u0016\u001cH/\u00117uKJL5O]%om\u0006d\u0017\u000e\u001a,feNLwN\u001c\u0015\u0003MA\u000b1\u0004^3ti\u0006cG/\u001a:JgJ,f.\u001a=qK\u000e$X\rZ#se>\u0014\bFA\u0014Q\u0003UA\u0017M\u001c3mK\u0006cG/\u001a:JgJ4\u0015-\u001b7ve\u0016$R!SAm\u0003SDq!a7)\u0001\u0004\ti.A\u0003feJ|'\u000f\u0005\u0003\u0002`\u0006\u0015XBAAq\u0015\u0011\t\u0019/!\u0018\u0002\u0011A\u0014x\u000e^8d_2LA!a:\u0002b\n1QI\u001d:peNDq!a;)\u0001\u0004\ti/\u0001\u0005dC2d'-Y2l!%Q\u0015q^A\u0002\u0003\u0007a\u0018*C\u0002\u0002r.\u0013\u0011BR;oGRLwN\\\u001a\u00025Q,7\u000f^*j]\u001edW-\u00138GY&<\u0007\u000e^!mi\u0016\u0014\u0018j\u001d:)\u0005%\u0002\u0016!\b;fgRT6.S:s\u001b\u0006t\u0017mZ3s\u0003NLhnY\"bY2\u0014\u0017mY6)\u0005)\u0002\u0016A\u000b;fgR,6/Z\"iK\u000e\\\u0007o\\5oiR{\u0017J\\5uS\u0006d\u0017N_3IS\u001eDw+\u0019;fe6\f'o\u001b\u0015\u0003WA\u000bq\u0003^3ti\u0006#G-\u00118e%\u0016lwN^3NKR\u0014\u0018nY:)\u00051\u0002\u0016!\f;fgR,f\u000eZ3s%\u0016\u0004H.[2bi\u0016$\u0007+\u0019:uSRLwN\\:D_J\u0014Xm\u0019;TK6\fg\u000e^5dg\"\u0012Q\u0006U\u0001\u001bi\u0016\u001cH/\u00169eCR,\u0017i]:jO:lWM\u001c;B]\u0012L5O\u001d\u0015\u0003]A\u000bQ\u0003^3ti2{wmQ8oM&<gj\u001c;ESJ$\u0018\u0010\u000b\u00020!\u0006\u0001C/Z:u\u0019><7i\u001c8gS\u001e$\u0015N\u001d;z\u0003N$v\u000e]5d+B$\u0017\r^3eQ\t\u0001\u0004+A\u0011uKN$Hj\\4D_:4\u0017n\u001a#jeRL\u0018i\u001d\"s_.,'/\u00169eCR,G\r\u000b\u00022!\u0006Y1/Z3e\u0019><G)\u0019;b)\u001dI%1\u0004B\u000f\u0005CAq!!\u00063\u0001\u0004\t9\u0002C\u0004\u0003 I\u0002\r!a\u0001\u0002\u00159,XNU3d_J$7\u000fC\u0004\u0002\u0002I\u0002\r!a\u0001\u0003\u000fMcwn\u001e'pON\u00191'a\u0006\u0002\u00115|7m\u001b+j[\u0016\u0004BAa\u000b\u000325\u0011!Q\u0006\u0006\u0004\u0005_a\u0014!B;uS2\u001c\u0018\u0002\u0002B\u001a\u0005[\u0011\u0001\"T8dWRKW.Z\u0001\u0010CB\u0004XM\u001c3TK6\f\u0007\u000f[8sKB!!\u0011\bB$\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012AC2p]\u000e,(O]3oi*!!\u0011\tB\"\u0003\u0011)H/\u001b7\u000b\u0005\t\u0015\u0013\u0001\u00026bm\u0006LAA!\u0013\u0003<\tI1+Z7ba\"|'/\u001a\u000b\t\u0005\u001b\u0012\tFa\u0015\u0003VA\u0019!qJ\u001a\u000e\u0003\u0001Aq!!\u00068\u0001\u0004\t9\u0002C\u0004\u0003(]\u0002\rA!\u000b\t\u000f\tUr\u00071\u0001\u00038\u0005\u0001\u0012\r\u001d9f]\u0012\f5OR8mY><XM\u001d\u000b\u0005\u00057\u0012\t\u0007\u0005\u0003\u0002\u001a\tu\u0013\u0002\u0002B0\u00037\u0011Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007bBA7q\u0001\u0007\u0011Q\u000b")
public class PartitionTest
extends AbstractPartitionTest {
    @Test
    public void testLastFetchedOffsetValidation() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        PartitionTest.append$1(0, 2, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(4, 5, log);
        PartitionTest.append$1(7, 1, log);
        PartitionTest.append$1(9, 3, log);
        Assertions.assertEquals((long)17L, (long)log.logEndOffset());
        int leaderEpoch = 10;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(2, 5L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(0, 4L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(6, 6L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(5, 9L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(10, 17L), PartitionTest.read$1(10, 18L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 2L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(7, 14L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(9, 17L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(10, 17L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(11, 5L, partition, leaderEpoch));
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(5L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(2, 5L), PartitionTest.read$1(2, 8L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 5L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(3, 5L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(0, 0L, partition, leaderEpoch));
        log.maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(5, 6L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(3, 6L, partition, leaderEpoch));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$12, x$2, x$3);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())};
        int n = 5;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 0L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assertions.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset())));
        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assertions.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assertions.assertEquals((int)leaderEpoch, (int)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        int leaderEpoch = 8;
        this.configRepository().setTopicConfig(this.topicPartition().topic(), LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_2_IV0$.MODULE$.shortVersion());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$22 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$22, x$3);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}))), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assertions.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.logEndOffset())));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assertions.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assertions.assertEquals((int)-1, (int)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Thread thread1 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                Partition qual$1 = this.$outer.partition();
                boolean x$1 = qual$1.removeFutureLocalReplica$default$1();
                qual$1.removeFutureLocalReplica(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread thread2 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                this.$outer.partition().maybeReplaceCurrentWithFutureReplica();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().futureLog());
    }

    @Test
    public void testMakeFollowerWithWithFollowerAppendRecords() {
        Semaphore appendSemaphore = new Semaphore(0);
        MockTime mockTime = new MockTime();
        this.partition_$eq(new Partition(this, mockTime, appendSemaphore){
            private final /* synthetic */ PartitionTest $outer;
            private final MockTime mockTime$1;
            private final Semaphore appendSemaphore$1;

            public Log createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints) {
                Log log = super.createLog(isNew, isFutureReplica, offsetCheckpoints);
                return new SlowLog(this.$outer, log, this.mockTime$1, this.appendSemaphore$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mockTime$1 = mockTime$1;
                this.appendSemaphore$1 = appendSemaphore$1;
                super($outer.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), $outer.brokerId(), (Time)$outer.time(), (IsrChangeListener)$outer.isrChangeListener(), $outer.delayedOperations(), $outer.metadataCache(), $outer.logManager(), (AlterIsrManager)$outer.alterIsrManager());
            }
        });
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        Thread appendThread = new Thread(this){
            private final /* synthetic */ PartitionTest $outer;

            public void run() {
                MemoryRecords records = this.$outer.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), 0L, this.$outer.createRecords$default$3());
                this.$outer.partition().appendRecordsToFollowerOrFutureReplica(records, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        appendThread.start();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!appendSemaphore.hasQueuedThreads()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"follower log append is not called.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
        appendSemaphore.release();
        appendThread.join();
        Assertions.assertEquals((long)2L, (long)this.partition().localLogOrException().logEndOffset());
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)this.partition().leaderReplicaIdOpt().get()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        void builder_partitionLeaderEpoch;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        void builder_baseOffset;
        void builder_timestampType;
        void builder_compressionType;
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Log currentLog = (Log)this.partition().log().get();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        compressionType = null;
        simpleRecordArray = null;
        currentLog.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        currentLog.roll(currentLog.roll$default$1());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())};
        boolean bl2 = false;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = 0L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        currentLog.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        boolean bl3 = false;
        long l = -1L;
        long l2 = 0L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType compressionType3 = CompressionType.NONE;
        byte builder_magic = 2;
        boolean bl4 = false;
        int n = -1;
        int n2 = -1;
        long builder_producerId = -1L;
        compressionType3 = null;
        timestampType = null;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)builder_baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        this.partition().futureLocalLogOrException().appendAsFollower(builder.build());
        Assertions.assertTrue((boolean)this.partition().maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Option timestampAndOffsetOpt = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3()).fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assertions.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assertions.assertEquals((int)leaderEpoch, (Integer)((Integer)timestampAndOffset.leaderEpoch.get()));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block51: {
            block53: {
                block52: {
                    block50: {
                        block47: {
                            block49: {
                                block48: {
                                    block46: {
                                        controllerEpoch = 3;
                                        leader = this.brokerId();
                                        follower1 = this.brokerId() + 1;
                                        follower2 = this.brokerId() + 2;
                                        replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2}));
                                        isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
                                        leaderEpoch = 8;
                                        batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes())}))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes())}))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(true);
                                        Assertions.assertTrue((boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints()), (String)"Expected first makeLeader() to return 'leader changed'");
                                        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch(), (String)"Current leader epoch");
                                        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().isr(), (String)"ISR");
                                        this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
                                        Assertions.assertEquals((long)this.partition().localLogOrException().logStartOffset(), (long)this.partition().localLogOrException().highWatermark(), (String)"Expected leader's HW not move");
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.alterIsrManager().completeIsrUpdate(2);
                                        Assertions.assertEquals((long)2L, (long)this.partition().localLogOrException().highWatermark());
                                        var11_11 = false;
                                        var12_12 = null;
                                        var13_13 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                        if (!(var13_13 instanceof Right)) ** GOTO lbl-1000
                                        var11_11 = true;
                                        var12_12 = (Right)var13_13;
                                        var14_14 = (Option)var12_12.value();
                                        if (var14_14 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var14_14).value();
                                            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                        } else if (var11_11 && None$.MODULE$.equals(var16_16 = (Option)var12_12.value())) {
                                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                                        } else if (var13_13 instanceof Left) {
                                            (BoxedUnit)Assertions.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var13_13);
                                        }
                                        var17_17 = false;
                                        var18_18 = null;
                                        var19_19 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var19_19 instanceof Right)) ** GOTO lbl-1000
                                        var17_17 = true;
                                        var18_18 = (Right)var19_19;
                                        var20_20 = (Option)var18_18.value();
                                        if (var20_20 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var20_20).value();
                                            Assertions.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                        } else if (var17_17 && None$.MODULE$.equals(var22_22 = (Option)var18_18.value())) {
                                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                                        } else if (var19_19 instanceof Left) {
                                            (BoxedUnit)Assertions.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var19_19);
                                        }
                                        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                        followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(4).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(false);
                                        Assertions.assertTrue((boolean)this.partition().makeFollower(followerState, this.offsetCheckpoints()));
                                        newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(5).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)())).asJava()).setIsNew(false);
                                        Assertions.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints()));
                                        var25_25 = false;
                                        var26_26 = null;
                                        var27_27 = false;
                                        var28_28 = null;
                                        var29_29 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var29_29 instanceof Right)) break block46;
                                        var25_25 = true;
                                        var26_26 = (Right)var29_29;
                                        if (!((Option)var26_26.value() instanceof Some)) break block46;
                                        (BoxedUnit)Assertions.fail((String)"Should have failed with OffsetNotAvailable");
                                        break block47;
                                    }
                                    if (!var25_25 || !None$.MODULE$.equals(var30_30 = (Option)var26_26.value())) break block48;
                                    (BoxedUnit)Assertions.fail((String)"Should have seen an error");
                                    break block47;
                                }
                                if (!(var29_29 instanceof Left)) break block49;
                                var27_27 = true;
                                var28_28 = (Left)var29_29;
                                if ((ApiException)var28_28.value() instanceof OffsetNotAvailableException) break block47;
                            }
                            if (var27_27 && (e = (ApiException)var28_28.value()) != null) {
                                (BoxedUnit)Assertions.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(e).toString());
                            } else {
                                throw new MatchError((Object)var29_29);
                            }
                        }
                        var32_32 = false;
                        var33_33 = null;
                        var34_34 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                        if (!(var34_34 instanceof Right)) ** GOTO lbl-1000
                        var32_32 = true;
                        var33_33 = (Right)var34_34;
                        var35_35 = (Option)var33_33.value();
                        if (var35_35 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var35_35).value();
                            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        } else if (var32_32 && None$.MODULE$.equals(var37_37 = (Option)var33_33.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var34_34 instanceof Left && (e = (ApiException)((Left)var34_34).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var34_34);
                        }
                        var39_39 = false;
                        var40_40 = null;
                        var41_41 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var41_41 instanceof Right)) ** GOTO lbl-1000
                        var39_39 = true;
                        var40_40 = (Right)var41_41;
                        var42_42 = (Option)var40_40.value();
                        if (var42_42 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var42_42).value();
                            Assertions.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        } else if (var39_39 && None$.MODULE$.equals(var44_44 = (Option)var40_40.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var41_41 instanceof Left && (e = (ApiException)((Left)var41_41).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var41_41);
                        }
                        var46_46 = false;
                        var47_47 = null;
                        var48_48 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var48_48 instanceof Right)) ** GOTO lbl-1000
                        var46_46 = true;
                        var47_47 = (Right)var48_48;
                        var49_49 = (Option)var47_47.value();
                        if (var49_49 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var49_49).value();
                            Assertions.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                            Assertions.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        } else if (var46_46 && None$.MODULE$.equals(var51_51 = (Option)var47_47.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var48_48 instanceof Left && (e = (ApiException)((Left)var48_48).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var48_48);
                        }
                        var53_53 = false;
                        var54_54 = null;
                        var55_55 = false;
                        var56_56 = null;
                        var57_57 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var57_57 instanceof Right)) break block50;
                        var53_53 = true;
                        var54_54 = (Right)var57_57;
                        if (!((Option)var54_54.value() instanceof Some)) break block50;
                        (BoxedUnit)Assertions.fail((String)"Should have failed");
                        break block51;
                    }
                    if (!var53_53 || !None$.MODULE$.equals(var58_58 = (Option)var54_54.value())) break block52;
                    (BoxedUnit)Assertions.fail((String)"Should have failed");
                    break block51;
                }
                if (!(var57_57 instanceof Left)) break block53;
                var55_55 = true;
                var56_56 = (Left)var57_57;
                if ((ApiException)var56_56.value() instanceof OffsetNotAvailableException) break block51;
            }
            if (var55_55 && (e = (ApiException)var56_56.value()) != null) {
                (BoxedUnit)Assertions.fail((String)new StringBuilder(50).append("Should have seen OffsetNotAvailableException, saw ").append(e).toString());
            } else {
                throw new MatchError((Object)var57_57);
            }
        }
        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.alterIsrManager().completeIsrUpdate(6);
        var60_60 = false;
        var61_61 = null;
        var62_62 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
        if (!(var62_62 instanceof Right)) ** GOTO lbl-1000
        var60_60 = true;
        var61_61 = (Right)var62_62;
        var63_63 = (Option)var61_61.value();
        if (var63_63 instanceof Some) {
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var63_63).value();
            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
        } else if (var60_60 && None$.MODULE$.equals(var65_65 = (Option)var61_61.value())) {
            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
        } else if (var62_62 instanceof Left && (e = (ApiException)((Left)var62_62).value()) != null) {
            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
        } else {
            throw new MatchError((Object)var62_62);
        }
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        int controllerEpoch = 0;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        if (isLeader) {
            Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Assertions.assertTrue((boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId() + 1).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        return qual$1.getOrCreateLog(x$1, x$2, x$3);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Log log = this.partition().localLogOrException();
        long initialLogStartOffset = 5L;
        this.partition().truncateFullyAndStartAt(initialLogStartOffset, false);
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logEndOffset(), (String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString());
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logStartOffset(), (String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString());
        Assertions.assertThrows(UnexpectedAppendOffsetException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 3L, this.createRecords$default$3()), false));
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logEndOffset(), (String)"Log end offset should not change after failure to append");
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())}))), newLogStartOffset, this.createRecords$default$3());
        this.partition().appendRecordsToFollowerOrFutureReplica(records, false);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset(), (String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString());
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 7L, this.createRecords$default$3()), false);
        Assertions.assertEquals((long)8L, (long)log.logEndOffset(), (String)"Log end offset after append of 1 record at offset 7:");
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)"Log start offset not expected to change:");
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), 3L, this.createRecords$default$3());
        Assertions.assertThrows(UnexpectedAppendOffsetException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(records2, false));
        Assertions.assertEquals((long)8L, (long)log.logEndOffset(), (String)"Log end offset should not change after failure to append");
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 8L, this.createRecords$default$3()), false);
        Assertions.assertEquals((long)9L, (long)log.logEndOffset(), (String)"Log end offset after append of 1 record at offset 8:");
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)"Log start offset not expected to change:");
    }

    @Test
    public void testListOffsetIsolationLevels() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())}))), 0L);
        this.partition().appendRecordsToLeader(records, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        Assertions.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        ((Log)this.partition().log().get()).updateHighWatermark(1L);
        Assertions.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
    }

    @Test
    public void testGetReplica() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().log());
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.partition().localLogOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())}))), 0L, this.createRecords$default$3()), false));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        this.partition().makeFollower(partitionState, this.offsetCheckpoints());
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava()).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava());
        Assertions.assertFalse((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints()));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v1".getBytes()), new SimpleRecord("k4".getBytes(), "v2".getBytes()), new SimpleRecord("k5".getBytes(), "v3".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k6".getBytes(), "v1".getBytes()), new SimpleRecord("k7".getBytes(), "v2".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        Assertions.assertTrue((boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints()), (String)"Expected first makeLeader() to return 'leader changed'");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch(), (String)"Current leader epoch");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().isr(), (String)"ISR");
        long lastOffsetOfFirstBatch = this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0).lastOffset();
        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        Assertions.assertEquals((long)this.partition().localLogOrException().logStartOffset(), (long)((Log)this.partition().log().get()).highWatermark(), (String)"Expected leader's HW not move");
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(0L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(lastOffsetOfFirstBatch, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((long)lastOffsetOfFirstBatch, (long)((Log)this.partition().log().get()).highWatermark(), (String)"Expected leader's HW");
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(followerState, this.offsetCheckpoints());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints()), (String)"Expected makeLeader() to return 'leader changed' after makeFollower()");
        long currentLeaderEpochStartOffset = this.partition().localLogOrException().logEndOffset();
        this.partition().appendRecordsToLeader(batch3, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(0L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(lastOffsetOfFirstBatch, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().isr(), (String)"ISR");
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(currentLeaderEpochStartOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().isr(), (String)"ISR");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().isrState().maximalIsr(), (String)"ISR");
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr().toSet(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2})), (String)"AlterIsr");
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        void builder_compressionType;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        long l = this.time().milliseconds();
        TimestampType timestampType = TimestampType.LOG_APPEND_TIME;
        CompressionType compressionType = CompressionType.NONE;
        byte builder_magic = 2;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        long builder_producerId = -1L;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)partitionLeaderEpoch);
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        compressionType = null;
        timestampType = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_partitionLeaderEpoch;
        void builder_logAppendTime;
        void builder_timestampType;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.IterableHasAsJava(records).asJava()));
        CompressionType builder_compressionType = CompressionType.NONE;
        int n = -1;
        long l = -1L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        byte builder_magic = 2;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)builder_magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)baseOffset, (long)builder_logAppendTime, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
        timestampType = null;
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        Object var11_8 = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader)}))).asJava();
        int leaderEpoch = 8;
        Assertions.assertFalse((boolean)this.partition().isAtMinIsr());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().isAtMinIsr());
    }

    @Test
    public void testUpdateFollowerFetchState() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 6, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(6L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((long)this.time().milliseconds(), (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)6L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testIsrExpansion() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testIsrExpansion$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().completeIsrUpdate(2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((int)this.isrChangeListener().expands().get(), (int)1);
        Assertions.assertEquals((int)this.isrChangeListener().shrinks().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().failures().get(), (int)0);
    }

    @Test
    public void testIsrNotExpandedIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_UPDATE_VERSION);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().expands().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().shrinks().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().failures().get(), (int)1);
    }

    @Test
    public void testMaybeShrinkIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testMaybeShrinkIsr$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(5000L);
        long firstFetchTimeMs = this.time().milliseconds();
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(5L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, firstFetchTimeMs, 10L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)5L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)5L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(5001L);
        this.seedLogData(log, 5, leaderEpoch);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 15L);
        Assertions.assertEquals((long)firstFetchTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    @Test
    public void testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    @Test
    public void testIsrNotShrunkIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_UPDATE_VERSION);
        Assertions.assertEquals(this.partition().isrState().getClass(), PendingShrinkIsr.class);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAlterIsrUnknownTopic() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_TOPIC_OR_PARTITION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnknownTopic$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrInvalidVersion() {
        this.handleAlterIsrFailure(Errors.INVALID_UPDATE_VERSION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrInvalidVersion$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrUnexpectedError() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_SERVER_ERROR, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnexpectedError$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    public void handleAlterIsrFailure(Errors error, Function3<Object, Object, Partition, BoxedUnit> callback) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(remoteBrokerId)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId())}))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().isrState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().failIsrUpdate(error);
        callback.apply((Object)BoxesRunTime.boxToInteger((int)this.brokerId()), (Object)BoxesRunTime.boxToInteger((int)remoteBrokerId), (Object)this.partition());
    }

    @Test
    public void testSingleInFlightAlterIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2), Predef$.MODULE$.int2Integer(follower3)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.partition().expandIsr(follower3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2})), (Object)this.partition().isrState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)this.partition().isrState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        this.partition().shrinkIsr((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{follower3})));
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
    }

    @Test
    public void testZkIsrManagerAsyncCallback() {
        KafkaScheduler scheduler = new KafkaScheduler(1, "zk-isr-test", true);
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        MockTime apply_time = this.time();
        Object var27_3 = null;
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)apply_time, kafkaZkClient);
        zkIsrManager.start();
        Partition partition = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), (ApiVersion)KAFKA_2_6_IV0$.MODULE$, this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)zkIsrManager);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$32 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$32);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2), Predef$.MODULE$.int2Integer(follower3)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)}))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        partition.createLogIfNotExists(false, false, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints()), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2})), (Object)partition.isrState().isr());
        Assertions.assertEquals((long)0L, (long)partition.localLogOrException().highWatermark());
        partition.expandIsr(follower3);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionTest.$anonfun$testZkIsrManagerAsyncCallback$2(partition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Expected ISR state to be committed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        IsrState isrState = partition.isrState();
        if (isrState instanceof CommittedIsr) {
            CommittedIsr committedIsr = (CommittedIsr)isrState;
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)committedIsr.isr());
        } else {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected a committed ISR following Zk expansion");
        }
        ((KafkaZkClient)Mockito.doAnswer(x$4 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)2), (Option)ArgumentMatchers.any());
        partition.expandIsr(follower3);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PartitionTest.$anonfun$testZkIsrManagerAsyncCallback$5(partition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Expected ISR state to be committed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
        scheduler.shutdown();
    }

    @Test
    public void testUseCheckpointToInitializeHighWatermark() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getOrCreateLog$default$2();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3);
        this.seedLogData(log, 6, 5);
        Mockito.when((Object)this.offsetCheckpoints().fetch(this.logDir1().getAbsolutePath(), this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)4L)));
        int controllerEpoch = 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assertions.assertEquals((long)4L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAddAndRemoveMetrics() {
        Assertions.assertTrue((boolean)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UnderReplicated", "UnderMinIsr", "InSyncReplicasCount", "ReplicasCount", "LastStableOffsetLag", "AtMinIsr"}))).forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$3(x$6))));
        Partition$.MODULE$.removeMetrics(this.topicPartition());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$4(x$7))));
    }

    @Test
    public void testUnderReplicatedPartitionsCorrectSemantics() {
        int controllerEpoch = 3;
        java.util.List replicas = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1), Predef$.MODULE$.int2Integer(this.brokerId() + 2)}))).asJava();
        java.util.List isr = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(this.brokerId()), Predef$.MODULE$.int2Integer(this.brokerId() + 1)}))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assertions.assertTrue((boolean)this.partition().isUnderReplicated());
        leaderState = leaderState.setIsr(replicas);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints());
        Assertions.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    @Test
    public void testUpdateAssignmentAndIsr() {
        TopicPartition topicPartition = new TopicPartition("test", 1);
        Partition partition = new Partition(topicPartition, 1000L, ApiVersion$.MODULE$.latestVersion(), 0, (Time)new SystemTime(), (IsrChangeListener)Mockito.mock(IsrChangeListener.class), (DelayedOperations)Mockito.mock(DelayedOperations.class), (MetadataCache)Mockito.mock(MetadataCache.class), (LogManager)Mockito.mock(LogManager.class), (AlterIsrManager)Mockito.mock(AlterIsrManager.class));
        scala.collection.immutable.Seq replicas = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        scala.collection.immutable.Seq adding = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5}));
        scala.collection.immutable.Seq removing = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
        partition.updateAssignmentAndIsr((Seq)replicas, isr, (Seq)adding, (Seq)removing);
        Assertions.assertTrue((boolean)(partition.assignmentState() instanceof OngoingReassignmentState), (String)"The assignmentState is not OngoingReassignmentState");
        Assertions.assertEquals((Object)replicas, (Object)partition.assignmentState().replicas());
        Assertions.assertEquals((Object)isr, (Object)partition.isrState().isr());
        Assertions.assertEquals((Object)adding, (Object)((OngoingReassignmentState)partition.assignmentState()).addingReplicas());
        Assertions.assertEquals((Object)removing, (Object)((OngoingReassignmentState)partition.assignmentState()).removingReplicas());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition.remoteReplicas().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId())));
        scala.collection.immutable.Seq replicas2 = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        scala.collection.immutable.Set isr2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        partition.updateAssignmentAndIsr((Seq)replicas2, isr2, (Seq)package$.MODULE$.Seq().empty(), (Seq)package$.MODULE$.Seq().empty());
        Assertions.assertTrue((boolean)(partition.assignmentState() instanceof SimpleAssignmentState), (String)"The assignmentState is not SimpleAssignmentState");
        Assertions.assertEquals((Object)replicas2, (Object)partition.assignmentState().replicas());
        Assertions.assertEquals((Object)isr2, (Object)partition.isrState().isr());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Object)partition.remoteReplicas().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId())));
    }

    @Test
    public void testLogConfigNotDirty() {
        String string;
        this.logManager().shutdown();
        CachedConfigRepository spyConfigRepository = (CachedConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), (ConfigRepository)spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time()));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(this.topicPartition().topic());
    }

    @Test
    public void testLogConfigDirtyAsTopicUpdated() {
        String string;
        this.logManager().shutdown();
        CachedConfigRepository spyConfigRepository = (CachedConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), (ConfigRepository)spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time()));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(x$10 -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsTopicUpdated$1(this, x$10);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)2))).topicConfig(this.topicPartition().topic());
    }

    @Test
    public void testLogConfigDirtyAsBrokerUpdated() {
        String string;
        this.logManager().shutdown();
        CachedConfigRepository spyConfigRepository = (CachedConfigRepository)Mockito.spy((Object)this.configRepository());
        int n = 1;
        long l = 0x400000L;
        double d = 0.9;
        int n2 = 0x100000;
        int n3 = 0x2000000;
        double d2 = Double.MAX_VALUE;
        long l2 = 15000L;
        String string2 = string = "MD5";
        string = null;
        String x$9 = string2;
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), (ConfigRepository)spyConfigRepository, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), this.time()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(x$11 -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsBrokerUpdated$1(this, x$11);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)2))).topicConfig(this.topicPartition().topic());
    }

    private void seedLogData(Log log, int numRecords, int leaderEpoch) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable)i -> PartitionTest.$anonfun$seedLogData$1(leaderEpoch, log, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testLastFetchedOffsetValidation$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    /*
     * WARNING - void declaration
     */
    private static final void append$1(int leaderEpoch, int count, Log log$1) {
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        IndexedSeq recordArray = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)i -> PartitionTest.$anonfun$testLastFetchedOffsetValidation$1(BoxesRunTime.unboxToInt((Object)i)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])recordArray.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        log$1.appendAsLeader(records, leaderEpoch, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
    }

    private static final FetchResponseData.EpochEndOffset epochEndOffset$1(int epoch, long endOffset) {
        return new FetchResponseData.EpochEndOffset().setEpoch(epoch).setEndOffset(endOffset);
    }

    private static final LogReadInfo read$1(int lastFetchedEpoch, long fetchOffset, Partition partition$1, int leaderEpoch$1) {
        return partition$1.readRecords(Optional.of(Predef$.MODULE$.int2Integer(lastFetchedEpoch)), fetchOffset, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch$1)), Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true, true);
    }

    private static final void assertDivergence$1(FetchResponseData.EpochEndOffset divergingEpoch, LogReadInfo readInfo) {
        Assertions.assertEquals((Object)new Some((Object)divergingEpoch), (Object)readInfo.divergingEpoch());
        Assertions.assertEquals((int)0, (int)readInfo.fetchedData().records().sizeInBytes());
    }

    private static final void assertNoDivergence$1(LogReadInfo readInfo) {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)readInfo.divergingEpoch());
    }

    public static final /* synthetic */ boolean $anonfun$testMakeFollowerWithWithFollowerAppendRecords$1(Semaphore appendSemaphore$1) {
        return appendSemaphore$1.hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testMakeFollowerWithWithFollowerAppendRecords$2() {
        return "follower log append is not called.";
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        try {
            partition$2.fetchOffsetSnapshot(currentLeaderEpoch, true);
            Assertions.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assertions.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        try {
            partition$3.fetchOffsetSnapshot(currentLeaderEpoch, fetchOnlyLeader);
            Assertions.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assertions.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assertions.assertEquals((short)error.code(), (short)endOffset.errorCode());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assertions.assertEquals((short)error.code(), (short)endOffset.errorCode());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final void updateFollowerFetchState$1(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation) {
        try {
            return package$.MODULE$.Right().apply((Object)this.partition().fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(this.partition().getLeaderEpoch())), true));
        }
        catch (ApiException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assertions.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assertions.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final void updateFollowerFetchState$2(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    public static final /* synthetic */ Integer $anonfun$testIsrExpansion$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMaybeShrinkIsr$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrUnknownTopic$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.isrState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.isrState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrInvalidVersion$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.isrState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.isrState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrUnexpectedError$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.isrState().isr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.isrState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)1);
    }

    public static final /* synthetic */ boolean $anonfun$testZkIsrManagerAsyncCallback$2(Partition partition$10) {
        return !partition$10.isrState().isInflight();
    }

    public static final /* synthetic */ String $anonfun$testZkIsrManagerAsyncCallback$3() {
        return "Expected ISR state to be committed";
    }

    public static final /* synthetic */ boolean $anonfun$testZkIsrManagerAsyncCallback$5(Partition partition$10) {
        return !partition$10.isrState().isInflight();
    }

    public static final /* synthetic */ String $anonfun$testZkIsrManagerAsyncCallback$6() {
        return "Expected ISR state to be committed";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$1(String metric$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.getName();
        if (string == null) {
            if (metric$1 != null) {
                return false;
            }
        } else if (!string.equals(metric$1)) return false;
        String string2 = metricName.getType();
        String string3 = "Partition";
        if (string2 == null) return false;
        if (!string2.equals(string3)) return false;
        return true;
    }

    private static final Option getMetric$1(String metric) {
        return ((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$1(metric, x0$1)))).headOption().map((Function1 & Serializable)x$5 -> (Metric)x$5._2());
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$3(String x$6) {
        return PartitionTest.getMetric$1(x$6).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$4(MetricName x$7) {
        String string = x$7.getType();
        String string2 = "Partition";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsTopicUpdated$1(PartitionTest $this, InvocationOnMock x$10) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().topicConfigUpdated($this.topicPartition().topic());
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsBrokerUpdated$1(PartitionTest $this, InvocationOnMock x$11) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().brokerConfigUpdated();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1(int leaderEpoch$2, Log log$2, int i) {
        void withRecords_records;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(new StringBuilder(1).append("k").append(i).toString().getBytes(), new StringBuilder(1).append("v").append(i).toString().getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)leaderEpoch$2, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        return log$2.appendAsLeader(records, leaderEpoch$2, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4());
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)x));
    }

    private class SlowLog
    extends Log {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionTest $outer;

        public LogAppendInfo appendAsFollower(MemoryRecords records) {
            this.appendSemaphore.acquire();
            return super.appendAsFollower(records);
        }

        public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionTest $outer, Log log, MockTime mockTime, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(log.dir(), log.config(), log.logStartOffset(), log.recoveryPoint(), (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), log.time(), log.maxProducerIdExpirationMs(), log.producerIdExpirationCheckIntervalMs(), log.topicPartition(), log.producerStateManager(), new LogDirFailureChannel(1), true, true);
        }
    }
}

