/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberMetadata$;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001\u0002(P\u0001YCQ!\u0018\u0001\u0005\u0002yCq!\u0019\u0001C\u0002\u0013%!\r\u0003\u0004l\u0001\u0001\u0006Ia\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019\t\b\u0001)A\u0005]\"9!\u000f\u0001b\u0001\n\u0013\u0011\u0007BB:\u0001A\u0003%1\rC\u0004u\u0001\t\u0007I\u0011\u00022\t\rU\u0004\u0001\u0015!\u0003d\u0011\u001d1\bA1A\u0005\n\tDaa\u001e\u0001!\u0002\u0013\u0019\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0005s\"1q\u0010\u0001Q\u0001\niD\u0001\u0002\u0015\u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0005\u0003\u0017A\u0001\"a\u0006\u0001A\u0003&\u00111\u0001\u0005\n\u00033\u0001\u0001\u0019!C\u0005\u00037A\u0011\"a\t\u0001\u0001\u0004%I!!\n\t\u0011\u0005%\u0002\u0001)Q\u0005\u0003;Aq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002J\u0001!\t!!\f\t\u000f\u0005M\u0003\u0001\"\u0001\u0002.!9\u0011q\u000b\u0001\u0005\u0002\u00055\u0002bBA.\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003?\u0002A\u0011AA\u0017\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003[Aq!a\u001a\u0001\t\u0003\ti\u0003C\u0004\u0002l\u0001!\t!!\f\t\u000f\u0005=\u0004\u0001\"\u0001\u0002.!9\u00111\u000f\u0001\u0005\u0002\u00055\u0002bBA<\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003w\u0002A\u0011AA\u0017\u0011\u001d\ty\b\u0001C\u0001\u0003[Aq!a!\u0001\t\u0003\ti\u0003C\u0004\u0002\b\u0002!\t!!\f\t\u000f\u0005-\u0005\u0001\"\u0001\u0002.!9\u0011q\u0012\u0001\u0005\u0002\u00055\u0002bBAJ\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003+\u0003A\u0011AA\u0017\u0011\u001d\tI\n\u0001C\u0001\u0003[Aq!!(\u0001\t\u0003\ti\u0003C\u0004\u0002\"\u0002!\t!!\f\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002.!9\u0011\u0011\u0016\u0001\u0005\u0002\u00055\u0002bBAW\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003c\u0003A\u0011AA\u0017\u0011\u001d\t)\f\u0001C\u0001\u0003[Aq!!/\u0001\t\u0003\ti\u0003C\u0004\u0002>\u0002!\t!!\f\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002.!9\u0011Q\u0019\u0001\u0005\u0002\u00055\u0002bBAe\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u001b\u0004A\u0011AA\u0017\u0011\u001d\t\t\u000e\u0001C\u0001\u0003[Aq!!6\u0001\t\u0003\ti\u0003C\u0004\u0002Z\u0002!\t!!\f\t\u000f\u0005u\u0007\u0001\"\u0001\u0002.!9\u0011\u0011\u001d\u0001\u0005\u0002\u00055\u0002bBAs\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003S\u0004A\u0011AA\u0017\u0011\u001d\ti\u000f\u0001C\u0001\u0003[Aq!!=\u0001\t\u0003\ti\u0003C\u0004\u0002v\u0002!\t!!\f\t\u000f\u0005e\b\u0001\"\u0001\u0002.!9\u0011Q \u0001\u0005\u0002\u00055\u0002b\u0002B\u0001\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0005\u000b\u0001A\u0011AA\u0017\u0011\u001d\u0011I\u0001\u0001C\u0001\u0003[AqA!\u0004\u0001\t\u0003\ti\u0003C\u0004\u0003\u0012\u0001!\t!!\f\t\u000f\tU\u0001\u0001\"\u0001\u0002.!9!\u0011\u0004\u0001\u0005\u0002\u00055\u0002b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\b\u0005[\u0001A\u0011\u0002B\u0018\u0011%\u0011Y\u0005AI\u0001\n\u0013\u0011iEA\tHe>,\b/T3uC\u0012\fG/\u0019+fgRT!\u0001U)\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005I\u001b\u0016aC2p_J$\u0017N\\1u_JT\u0011\u0001V\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u000b\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0003\"\u0001\u0019\u0001\u000e\u0003=\u000bA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\u0012a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fA\u0001\\1oO*\t\u0001.\u0001\u0003kCZ\f\u0017B\u00016f\u0005\u0019\u0019FO]5oO\u0006i\u0001O]8u_\u000e|G\u000eV=qK\u0002\nqb\u001a:pkBLen\u001d;b]\u000e,\u0017\nZ\u000b\u0002]B\u0019\u0001l\\2\n\u0005AL&\u0001B*p[\u0016\f\u0001c\u001a:pkBLen\u001d;b]\u000e,\u0017\n\u001a\u0011\u0002\u00115,WNY3s\u0013\u0012\f\u0011\"\\3nE\u0016\u0014\u0018\n\u001a\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\f\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u0015\rd\u0017.\u001a8u\u0011>\u001cH/A\u0006dY&,g\u000e\u001e%pgR\u0004\u0013A\u0005:fE\u0006d\u0017M\\2f)&lWm\\;u\u001bN,\u0012A\u001f\t\u00031nL!\u0001`-\u0003\u0007%sG/A\nsK\n\fG.\u00198dKRKW.Z8vi6\u001b\b%\u0001\ttKN\u001c\u0018n\u001c8US6,w.\u001e;Ng\u0006\t2/Z:tS>tG+[7f_V$Xj\u001d\u0011\u0016\u0005\u0005\r\u0001c\u00011\u0002\u0006%\u0019\u0011qA(\u0003\u001b\u001d\u0013x.\u001e9NKR\fG-\u0019;b\u0003%9'o\\;q?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005M\u0001c\u0001-\u0002\u0010%\u0019\u0011\u0011C-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003+\t\u0012\u0011!a\u0001\u0003\u0007\t1\u0001\u001f\u00132\u0003\u00199'o\\;qA\u00051Q.Z7cKJ,\"!!\b\u0011\u0007\u0001\fy\"C\u0002\u0002\"=\u0013a\"T3nE\u0016\u0014X*\u001a;bI\u0006$\u0018-\u0001\u0006nK6\u0014WM]0%KF$B!!\u0004\u0002(!I\u0011Q\u0003\u000b\u0002\u0002\u0003\u0007\u0011QD\u0001\b[\u0016l'-\u001a:!\u0003\u0015\u0019X\r^+q)\t\ti\u0001K\u0002\u0017\u0003c\u0001B!a\r\u0002F5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0002ba&TA!a\u000f\u0002>\u00059!.\u001e9ji\u0016\u0014(\u0002BA \u0003\u0003\nQA[;oSRT!!a\u0011\u0002\u0007=\u0014x-\u0003\u0003\u0002H\u0005U\"A\u0003\"fM>\u0014X-R1dQ\u0006QB/Z:u\u0007\u0006t'+\u001a2bY\u0006t7-Z,iK:\u001cF/\u00192mK\"\u001aq#!\u0014\u0011\t\u0005M\u0012qJ\u0005\u0005\u0003#\n)D\u0001\u0003UKN$\u0018a\n;fgR\u001c\u0015M\u001c*fE\u0006d\u0017M\\2f/\",gnQ8na2,G/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D3\u0001GA'\u0003%\"Xm\u001d;DC:tw\u000e\u001e*fE\u0006d\u0017M\\2f/\",g\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK\"\u001a\u0011$!\u0014\u00027Q,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016tG)Z1eQ\rQ\u0012QJ\u0001)i\u0016\u001cHo\u0015;bE2,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u00047\u00055\u0013A\u0007;fgR\u001cF/\u00192mKR{G)Z1e)J\fgn]5uS>t\u0007f\u0001\u000f\u0002N\u0005\u0019D/Z:u\u0003^\f\u0017\u000e^5oOJ+'-\u00197b]\u000e,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u0004;\u00055\u0013A\n;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001aa$!\u0014\u0002OQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.R7qif$&/\u00198tSRLwN\u001c\u0015\u0004?\u00055\u0013!\u0007;fgR,U\u000e\u001d;z)>$U-\u00193Ue\u0006t7/\u001b;j_:D3\u0001IA'\u0003\u001d\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,GK]1og&$\u0018n\u001c8)\u0007\u0005\ni%\u0001\u0012uKN$X)\u001c9usR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004E\u00055\u0013a\t;fgR\u001cF/\u00192mKR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004G\u00055\u0013!\f;fgR,U\u000e\u001d;z)>\fu/Y5uS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aA%!\u0014\u0002wQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002&\u0003\u001b\nq\u0006^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3AJA'\u0003e\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007fA\u0014\u0002N\u0005yB/Z:u\t\u0016\fG\rV8EK\u0006$\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8\u0002CQ,7\u000f\u001e#fC\u0012$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007%\ni%A\u0017uKN$H)Z1e)>\u0004&/\u001a9be&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3AKA'\u00031\"Xm\u001d;EK\u0006$Gk\\!xC&$\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002,\u0003\u001b\n!\u0003^3tiN+G.Z2u!J|Go\\2pY\"\u001aA&!\u0014\u0002GQ,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c*bSN,7/\u00134O_6+WNY3sg\"\u001aQ&!\u0014\u0002WQ,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\\\"i_>\u001cXm]\"p[B\fG/\u001b2mKB\u0013x\u000e^8d_2D3ALA'\u0003U!Xm\u001d;TkB\u0004xN\u001d;t!J|Go\\2pYND3aLA'\u0003Q\"Xm\u001d;PM\u001a\u001cX\r\u001e*f[>4\u0018\r\u001c#ve&tw\r\u0016:b]NLG/[8o\rJ|W.R7qif$vNT8o\u000b6\u0004H/\u001f\u0015\u0004a\u00055\u0013\u0001\u0006;fgR\u001cVOY:de&\u0014W\r\u001a+pa&\u001c7\u000fK\u00022\u0003\u001b\nA\u0005^3tiN+(m]2sS\n,G\rV8qS\u000e\u001chj\u001c8D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u0015\u0004e\u00055\u0013A\u0006;fgRLe.\u001b;OKb$x)\u001a8fe\u0006$\u0018n\u001c8)\u0007M\ni%\u0001\u0011uKN$\u0018J\\5u\u001d\u0016DHoR3oKJ\fG/[8o\u000b6\u0004H/_$s_V\u0004\bf\u0001\u001b\u0002N\u0005\u0001B/Z:u\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004k\u00055\u0013a\u0006;fgR|eMZ:fi\u000e{W.\\5u\r\u0006LG.\u001e:fQ\r1\u0014QJ\u0001*i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR4\u0015-\u001b7ve\u0016<\u0016\u000e\u001e5B]>$\b.\u001a:QK:$\u0017N\\4)\u0007]\ni%\u0001\u0012uKN$xJ\u001a4tKR\u001cu.\\7ji^KG\u000f[!o_RDWM\u001d)f]\u0012Lgn\u001a\u0015\u0004q\u00055\u0013A\u000b;fgR\u001cuN\\:v[\u0016\u0014()Z1ugR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004s\u00055\u0013\u0001\u000b;fgR$&/\u00198tC\u000e$\u0018n\u001c8CK\u0006$8oQ8ogVlWM](gMN,GoQ8n[&$\bf\u0001\u001e\u0002N\u0005)D/Z:u)J\fgn]1di&|g.\u00197D_6l\u0017\u000e^%t\u0003\n|'\u000f^3e\u0003:$7i\u001c8tk6,'oQ8n[&$x+\u001b8tQ\rY\u0014QJ\u0001.i\u0016\u001cHOR1jY\u0016$G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LG\u000fT3bm\u0016\u001chj\u001c)f]\u0012LgnZ*uCR,\u0007f\u0001\u001f\u0002N\u0005\u0001D/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3XSRDW)\u001c9us\u001e\u0013x.\u001e9J]N$\u0018M\\2f\u0013\u0012D3!PA'\u00035\"Xm\u001d;SKBd\u0017mY3He>,\b/\u00138ti\u0006t7-Z,ji\"tuN\\#ySN$\u0018N\\4NK6\u0014WM\u001d\u0015\u0004}\u00055\u0013\u0001\u0007;fgR\u0014V\r\u001d7bG\u0016<%o\\;q\u0013:\u001cH/\u00198dK\"\u001aq(!\u0014\u0002-Q,7\u000f^%om>\\WMS8j]\u000e\u000bG\u000e\u001c2bG.D3\u0001QA'\u0003e!Xm\u001d;O_RLeN^8lK*{\u0017N\\\"bY2\u0014\u0017mY6)\u0007\u0005\u000bi%\u0001\fuKN$\u0018J\u001c<pW\u0016\u001c\u0016P\\2DC2d'-Y2lQ\r\u0011\u0015QJ\u0001\u001ai\u0016\u001cHOT8u\u0013:4xn[3Ts:\u001c7)\u00197mE\u0006\u001c7\u000eK\u0002D\u0003\u001b\n1\u0004^3ti\"\u000b7\u000fU3oI&twMT8o)btwJ\u001a4tKR\u001c\bf\u0001#\u0002N\u0005AB/Z:u\u0011\u0006\u001c\b+\u001a8eS:<G\u000b\u001f8PM\u001a\u001cX\r^:)\u0007\u0015\u000bi%A\u0014uKN$8)\u00198o_R\fE\r\u001a)f]\u0012LgnZ*z]\u000e|e-\u00168l]><h.T3nE\u0016\u0014\bf\u0001$\u0002N\u0005QC/Z:u\u0007\u0006tgn\u001c;SK6|g/\u001a)f]\u0012LgnZ*z]\u000e|e-\u00168l]><h.T3nE\u0016\u0014\bfA$\u0002N\u0005!C/Z:u\u0007\u0006t\u0017\t\u001a3B]\u0012\u0014V-\\8wKB+g\u000eZ5oONKhnY'f[\n,'\u000fK\u0002I\u0003\u001b\nQ\u0006^3tiJ+Wn\u001c<bY\u001a\u0013x.\u001c)f]\u0012LgnZ*z]\u000e<\u0006.\u001a8NK6\u0014WM]%t%\u0016lwN^3eQ\rI\u0015QJ\u0001*i\u0016\u001cHOT3x\u000f\u0016tWM]1uS>t7\t\\3beN\u0004VM\u001c3j]\u001e\u001c\u0016P\\2NK6\u0014WM]:)\u0007)\u000bi%A\u0006bgN,'\u000f^*uCR,GCBA\u0007\u0005C\u0011\u0019\u0003\u0003\u0004Q\u0017\u0002\u0007\u00111\u0001\u0005\b\u0005KY\u0005\u0019\u0001B\u0014\u0003-!\u0018M]4fiN#\u0018\r^3\u0011\u0007\u0001\u0014I#C\u0002\u0003,=\u0013!b\u0012:pkB\u001cF/\u0019;f\u0003EygMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u000b\u0007\u0005c\u0011iDa\u0012\u0011\t\tM\"\u0011H\u0007\u0003\u0005kQ1Aa\u000eT\u0003\u0019\u0019w.\\7p]&!!1\bB\u001b\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u0005\b\u0005\u007fa\u0005\u0019\u0001B!\u0003\u0019ygMZ:fiB\u0019\u0001La\u0011\n\u0007\t\u0015\u0013L\u0001\u0003M_:<\u0007\"\u0003B%\u0019B\u0005\t\u0019\u0001B!\u0003%!\u0018.\\3ti\u0006l\u0007/A\u000epM\u001a\u001cX\r^!oI6+G/\u00193bi\u0006$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001fRCA!\u0011\u0003R-\u0012!1\u000b\t\u0005\u0005+\u0012y&\u0004\u0002\u0003X)!!\u0011\fB.\u0003%)hn\u00195fG.,GMC\u0002\u0003^e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tGa\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class GroupMetadataTest {
    private final String protocolType;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;
    private MemberMetadata member = null;

    private String protocolType() {
        return this.protocolType;
    }

    private Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    private MemberMetadata member() {
        return this.member;
    }

    private void member_$eq(MemberMetadata x$1) {
        this.member = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
        this.member_$eq(new MemberMetadata(this.memberId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9()));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test
    public void testEmptyToStableIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$3 = this.group();
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(lastMember, x$6);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolRaisesIfNoMembers() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), new Tuple2((Object)"blah", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetRemovalDuringTransitionFromEmptyToNonEmpty() {
        void offsetAndMetadata_timestamp;
        OffsetAndMetadata offsetAndMetadata;
        String topic = "foo";
        TopicPartition partition = new TopicPartition(topic, 0);
        MockTime time = new MockTime();
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, (Time)time));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).asJava()), (short)1).array())})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        long l = time.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", (long)offsetAndMetadata_timestamp);
        offsetAndMetadata = null;
        OffsetAndMetadata offset = offsetAndMetadata2;
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        long offsetRetentionMs = 50000L;
        time.sleep(offsetRetentionMs + 1L);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(this.memberId());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.group().removeExpiredOffsets(time.milliseconds(), offsetRetentionMs));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(member, x$4);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.group().removeExpiredOffsets(time.milliseconds(), offsetRetentionMs));
    }

    @Test
    public void testSubscribedTopics() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))).asJava()), (short)1).array())})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(memberWithFaultyProtocol, x$4);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        this.member().supportedProtocols_$eq((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(this.member(), (Function1 & Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testOffsetCommit() {
        OffsetAndMetadata offsetAndMetadata;
        TopicPartition partition = new TopicPartition("foo", 0);
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata = null;
        OffsetAndMetadata offset = offsetAndMetadata2;
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        OffsetAndMetadata offsetAndMetadata;
        TopicPartition partition = new TopicPartition("foo", 0);
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata = null;
        OffsetAndMetadata offset = offsetAndMetadata2;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        OffsetAndMetadata offsetAndMetadata;
        OffsetAndMetadata offsetAndMetadata2;
        TopicPartition partition = new TopicPartition("foo", 0);
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata3 = offsetAndMetadata2 = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata2 = null;
        OffsetAndMetadata firstOffset = offsetAndMetadata3;
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata offsetAndMetadata4 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", l2);
        offsetAndMetadata = null;
        OffsetAndMetadata secondOffset = offsetAndMetadata4;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        OffsetAndMetadata offsetAndMetadata;
        OffsetAndMetadata offsetAndMetadata2;
        TopicPartition partition = new TopicPartition("foo", 0);
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata3 = offsetAndMetadata2 = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata2 = null;
        OffsetAndMetadata firstOffset = offsetAndMetadata3;
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata offsetAndMetadata4 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", l2);
        offsetAndMetadata = null;
        OffsetAndMetadata secondOffset = offsetAndMetadata4;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        OffsetAndMetadata offsetAndMetadata;
        OffsetAndMetadata offsetAndMetadata2;
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata3 = offsetAndMetadata2 = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata2 = null;
        OffsetAndMetadata txnOffsetCommit = offsetAndMetadata3;
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata offsetAndMetadata4 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", l2);
        offsetAndMetadata = null;
        OffsetAndMetadata consumerOffsetCommit = offsetAndMetadata4;
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        OffsetAndMetadata offsetAndMetadata;
        OffsetAndMetadata offsetAndMetadata2;
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata3 = offsetAndMetadata2 = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata2 = null;
        OffsetAndMetadata txnOffsetCommit = offsetAndMetadata3;
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata offsetAndMetadata4 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", l2);
        offsetAndMetadata = null;
        OffsetAndMetadata consumerOffsetCommit = offsetAndMetadata4;
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        OffsetAndMetadata offsetAndMetadata;
        OffsetAndMetadata offsetAndMetadata2;
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata3 = offsetAndMetadata2 = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata2 = null;
        OffsetAndMetadata txnOffsetCommit = offsetAndMetadata3;
        long l2 = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset2 = 57L;
        OffsetAndMetadata offsetAndMetadata4 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset2, "", l2);
        offsetAndMetadata = null;
        OffsetAndMetadata consumerOffsetCommit = offsetAndMetadata4;
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        OffsetAndMetadata offsetAndMetadata;
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata = null;
        OffsetAndMetadata txnOffsetCommit = offsetAndMetadata2;
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testReplaceGroupInstanceWithEmptyGroupInstanceId() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceGroupInstance(this.memberId(), newMemberId, Option$.MODULE$.empty()));
    }

    @Test
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId()));
    }

    @Test
    public void testReplaceGroupInstance() {
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1 & Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
        Assertions.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assertions.assertEquals((Object)newMemberId, (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        Assertions.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assertions.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assertions.assertFalse((boolean)this.member().isAwaitingJoin());
        Assertions.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1 & Serializable)x$2 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(this.member(), JoinGroupResult$.MODULE$.apply(this.member().memberId(), Errors.NONE));
        Assertions.assertTrue((boolean)invoked.elem);
        Assertions.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assertions.assertFalse((boolean)this.member().isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(this.member(), JoinGroupResult$.MODULE$.apply(this.member().memberId(), Errors.NONE));
        Assertions.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable)x$3 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$3);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(this.member(), SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assertions.assertFalse((boolean)this.group().maybeInvokeSyncCallback(this.member(), SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testHasPendingNonTxnOffsets() {
        OffsetAndMetadata offsetAndMetadata;
        TopicPartition partition = new TopicPartition("foo", 0);
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata = null;
        OffsetAndMetadata offset = offsetAndMetadata2;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition));
    }

    @Test
    public void testHasPendingTxnOffsets() {
        OffsetAndMetadata offsetAndMetadata;
        TopicPartition txnPartition = new TopicPartition("foo", 1);
        long l = Time.SYSTEM.milliseconds();
        long offsetAndMetadata_offset = 37L;
        OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata = OffsetAndMetadata$.MODULE$.apply(offsetAndMetadata_offset, "", l);
        offsetAndMetadata = null;
        OffsetAndMetadata offset = offsetAndMetadata2;
        int producerId = 5;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)txnPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition));
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    @Test
    public void testCannotAddPendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingSyncMember(this.memberId()));
    }

    @Test
    public void testCannotRemovePendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().removePendingSyncMember(this.memberId()));
    }

    @Test
    public void testCanAddAndRemovePendingSyncMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().removePendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testRemovalFromPendingSyncWhenMemberIsRemoved() {
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().remove(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testNewGenerationClearsPendingSyncMembers() {
        MemberMetadata member = new MemberMetadata(this.memberId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))})), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        ((Set)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}))).$minus((Object)targetState)).foreach((Function1 & Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset, long timestamp) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", timestamp);
    }

    private long offsetAndMetadata$default$2() {
        return Time.SYSTEM.milliseconds();
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$3) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assertions.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

