/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAutoTopicCreationManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.server.ZkAdminManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tEc\u0001\u0002\u001b6\u0001iBQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013%a\t\u0003\u0004K\u0001\u0001\u0006Ia\u0012\u0005\n\u0017\u0002\u0001\r\u00111A\u0005\n1C\u0011\u0002\u0015\u0001A\u0002\u0003\u0007I\u0011B)\t\u0013]\u0003\u0001\u0019!A!B\u0013i\u0005b\u0002-\u0001\u0005\u0004%I!\u0017\u0005\u0007;\u0002\u0001\u000b\u0011\u0002.\t\u000fy\u0003!\u0019!C\u0005?\"11\r\u0001Q\u0001\n\u0001Dq\u0001\u001a\u0001C\u0002\u0013%Q\r\u0003\u0004j\u0001\u0001\u0006IA\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019\t\b\u0001)A\u0005Y\"9!\u000f\u0001b\u0001\n\u0013\u0019\bB\u0002?\u0001A\u0003%A\u000fC\u0004~\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005-\u0001\u0001)A\u0005\u007f\"Y\u0011Q\u0002\u0001A\u0002\u0003\u0007I\u0011BA\b\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%I!!\u0007\t\u0017\u0005u\u0001\u00011A\u0001B\u0003&\u0011\u0011\u0003\u0005\t\u0003?\u0001!\u0019!C\u0005\r\"9\u0011\u0011\u0005\u0001!\u0002\u00139\u0005\"CA\u0012\u0001\t\u0007I\u0011BA\u0013\u0011!\ti\u0003\u0001Q\u0001\n\u0005\u001d\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u001b\u0002A\u0011AA\u0019\u0011\u001d\t9\u0006\u0001C\u0001\u0003cAq!a\u0017\u0001\t\u0003\t\t\u0004C\u0004\u0002`\u0001!I!!\u0019\t\u0013\u0005=\u0005!%A\u0005\n\u0005E\u0005\"CAT\u0001E\u0005I\u0011BAU\u0011\u001d\ti\u000b\u0001C\u0001\u0003cAq!!-\u0001\t\u0003\t\t\u0004C\u0004\u00026\u0002!\t!!\r\t\u000f\u0005e\u0006\u0001\"\u0001\u00022!9\u0011Q\u0018\u0001\u0005\u0002\u0005E\u0002bBAa\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003\u000b\u0004A\u0011AA\u0019\u0011\u001d\tI\r\u0001C\u0001\u0003cAq!!4\u0001\t\u0003\t\t\u0004C\u0004\u0002R\u0002!\t!!\r\t\u000f\u0005U\u0007\u0001\"\u0001\u00022!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005E\u0002bBAo\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003C\u0004A\u0011BAr\u0011%\u0011i\u0001AI\u0001\n\u0013\u0011y\u0001C\u0004\u0003\u0014\u0001!IA!\u0006\t\u000f\tu\u0001\u0001\"\u0003\u0003 !I!Q\n\u0001\u0012\u0002\u0013%\u0011\u0011\u0013\u0005\n\u0005\u001f\u0002\u0011\u0013!C\u0005\u0003S\u0013A$Q;u_R{\u0007/[2De\u0016\fG/[8o\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u00027o\u000511/\u001a:wKJT\u0011\u0001O\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0003\"\u0001\u0012\u0001\u000e\u0003U\naB]3rk\u0016\u001cH\u000fV5nK>,H/F\u0001H!\ta\u0004*\u0003\u0002J{\t\u0019\u0011J\u001c;\u0002\u001fI,\u0017/^3tiRKW.Z8vi\u0002\naaY8oM&<W#A'\u0011\u0005\u0011s\u0015BA(6\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0002S+B\u0011AhU\u0005\u0003)v\u0012A!\u00168ji\"9a+BA\u0001\u0002\u0004i\u0015a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-F\u0001[!\t!5,\u0003\u0002]k\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%\u0001\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014X#\u00011\u0011\u0005\u0011\u000b\u0017B\u000126\u0005\u0001\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002'\t\u0014xn[3s)>\u001cuN\u001c;s_2dWM\u001d\u0011\u0002\u0019\u0005$W.\u001b8NC:\fw-\u001a:\u0016\u0003\u0019\u0004\"\u0001R4\n\u0005!,$A\u0004.l\u0003\u0012l\u0017N\\'b]\u0006<WM]\u0001\u000eC\u0012l\u0017N\\'b]\u0006<WM\u001d\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'/F\u0001m!\tiw.D\u0001o\u0015\tQw'\u0003\u0002q]\ny1*\u00194lC\u000e{g\u000e\u001e:pY2,'/A\u0006d_:$(o\u001c7mKJ\u0004\u0013\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\u00159'o\\;q\u0015\tIx'A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018BA>w\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'/A\the>,\boQ8pe\u0012Lg.\u0019;pe\u0002\na\u0003\u001e:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006a\f1\u0002\u001e:b]N\f7\r^5p]&!\u0011\u0011BA\u0002\u0005Y!&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014\u0018a\u0006;sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:!\u0003a\tW\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM]\u000b\u0003\u0003#\u00012\u0001RA\n\u0013\r\t)\"\u000e\u0002\u0019\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>tW*\u00198bO\u0016\u0014\u0018\u0001H1vi>$v\u000e]5d\u0007J,\u0017\r^5p]6\u000bg.Y4fe~#S-\u001d\u000b\u0004%\u0006m\u0001\u0002\u0003,\u0015\u0003\u0003\u0005\r!!\u0005\u00023\u0005,Ho\u001c+pa&\u001c7I]3bi&|g.T1oC\u001e,'\u000fI\u0001\u0018S:$XM\u001d8bYR{\u0007/[2QCJ$\u0018\u000e^5p]N\f\u0001$\u001b8uKJt\u0017\r\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003yIg\u000e^3s]\u0006dGk\u001c9jGJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'/\u0006\u0002\u0002(A\u0019A(!\u000b\n\u0007\u0005-RHA\u0003TQ>\u0014H/A\u0010j]R,'O\\1m)>\u0004\u0018n\u0019*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nQa]3ukB$\u0012A\u0015\u0015\u00045\u0005U\u0002\u0003BA\u001c\u0003\u0013j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0004CBL'\u0002BA \u0003\u0003\nqA[;qSR,'O\u0003\u0003\u0002D\u0005\u0015\u0013!\u00026v]&$(BAA$\u0003\ry'oZ\u0005\u0005\u0003\u0017\nID\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0003^3ti\u000e\u0013X-\u0019;f\u001f\u001a47/\u001a;U_BL7\rK\u0002\u001c\u0003#\u0002B!a\u000e\u0002T%!\u0011QKA\u001d\u0005\u0011!Vm\u001d;\u0002%Q,7\u000f^\"sK\u0006$X\r\u0016=o)>\u0004\u0018n\u0019\u0015\u00049\u0005E\u0013A\u0007;fgR\u001c%/Z1uK:{g.\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007fA\u000f\u0002R\u0005yA/Z:u\u0007J,\u0017\r^3U_BL7\rF\u0005S\u0003G\ni(a\"\u0002\f\"9\u0011Q\r\u0010A\u0002\u0005\u001d\u0014!\u0003;pa&\u001cg*Y7f!\u0011\tI'a\u001e\u000f\t\u0005-\u00141\u000f\t\u0004\u0003[jTBAA8\u0015\r\t\t(O\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005UT(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\nYH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003kj\u0004bBA@=\u0001\u0007\u0011\u0011Q\u0001\u000bSNLe\u000e^3s]\u0006d\u0007c\u0001\u001f\u0002\u0004&\u0019\u0011QQ\u001f\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\u0012\u0010\u0011\u0002\u0003\u0007q)A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\n\u0003\u001bs\u0002\u0013!a\u0001\u0003O\t\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0003e!Xm\u001d;De\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M%fA$\u0002\u0016.\u0012\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003%)hn\u00195fG.,GMC\u0002\u0002\"v\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)+a'\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\ruKN$8I]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\"TCAAVU\u0011\t9#!&\u0002MQ,7\u000f^\"sK\u0006$X\rV8qS\u000e\u001cx+\u001b;i\r>\u0014x/\u0019:eS:<G)[:bE2,G\rK\u0002\"\u0003#\n\u0001\u0007^3ti&sg/\u00197jIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'OR8s\u001d>t\u0017J\u001c;fe:\fG\u000eV8qS\u000e\u001c\bf\u0001\u0012\u0002R\u0005\u0019D/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2bi&|gNR1di>\u0014hi\u001c:D_:\u001cX/\\3s\u001f\u001a47/\u001a;t)>\u0004\u0018n\u0019\u0015\u0004G\u0005E\u0013!\f;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d$peRChn\u00144gg\u0016$Hk\u001c9jG\"\u001aA%!\u0015\u0002YQ,7\u000f\u001e+pa&\u001cW\t_5tiN,%O]8s'^\f\u0007OR8s\u001d>t\u0017J\u001c;fe:\fG\u000eV8qS\u000e\u001c\bfA\u0013\u0002R\u0005yC/Z:u)>\u0004\u0018nY#ySN$8/\u0012:s_J\u001cv/\u00199G_J\u001cuN\\:v[\u0016\u0014xJ\u001a4tKR\u001cHk\u001c9jG\"\u001aa%!\u0015\u0002SQ,7\u000f\u001e+pa&\u001cW\t_5tiN,%O]8s'^\f\u0007OR8s)btwJ\u001a4tKR$v\u000e]5dQ\r9\u0013\u0011K\u00010i\u0016\u001cHOU3rk\u0016\u001cH\u000fV5nK>,H/\u0012:s_J\u001cv/\u00199G_JtuN\\%oi\u0016\u0014h.\u00197U_BL7m\u001d\u0015\u0004Q\u0005E\u0013!\r;fgR\u0014V-];fgR$\u0016.\\3pkR,%O]8s'^\f\u0007OR8s\u0007>t7/^7fe>3gm]3u)>\u0004\u0018n\u0019\u0015\u0004S\u0005E\u0013\u0001\f;fgR\u0014V-];fgR$\u0016.\\3pkR,%O]8s'^\f\u0007OR8s)btwJ\u001a4tKR$v\u000e]5dQ\rQ\u0013\u0011K\u0001-i\u0016\u001cH/\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gNR8s\u001d>t\u0017J\u001c;feZ\fG\u000eV8qS\u000eD3aKA)\u0003=\"Xm\u001d;V].twn\u001e8U_BL7\rU1si&$\u0018n\u001c8G_J\u001cuN\\:v[\u0016\u0014xJ\u001a4tKR$v\u000e]5dQ\ra\u0013\u0011K\u0001+i\u0016\u001cH/\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gNR8s)btwJ\u001a4tKR$v\u000e]5dQ\ri\u0013\u0011K\u0001\u001ai\u0016\u001cH/\u0012:s_J<\u0016\u000e\u001e5De\u0016\fG/[8o\u0013:T6\u000eF\u0005S\u0003K\fyP!\u0001\u0003\u0004!9\u0011q\u001d\u0018A\u0002\u0005%\u0018!B3se>\u0014\b\u0003BAv\u0003wl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\taJ|Go\\2pY*!\u00111_A{\u0003\u0019\u0019w.\\7p]*\u0019\u0001(a>\u000b\t\u0005e\u0018QI\u0001\u0007CB\f7\r[3\n\t\u0005u\u0018Q\u001e\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u0005\u0015d\u00061\u0001\u0002h!9\u0011q\u0010\u0018A\u0002\u0005\u0005\u0005\"\u0003B\u0003]A\u0005\t\u0019\u0001B\u0004\u00035)\u0007\u0010]3di\u0016$WI\u001d:peB)AH!\u0003\u0002j&\u0019!1B\u001f\u0003\r=\u0003H/[8o\u0003\r\"Xm\u001d;FeJ|'oV5uQ\u000e\u0013X-\u0019;j_:LeNW6%I\u00164\u0017-\u001e7uIQ*\"A!\u0005+\t\t\u001d\u0011QS\u0001\u001bGJ,\u0017\r^3U_BL7-\u00118e-\u0016\u0014\u0018NZ=SKN,H\u000e\u001e\u000b\b%\n]!\u0011\u0004B\u000e\u0011\u001d\t9\u000f\ra\u0001\u0003SDq!!\u001a1\u0001\u0004\t9\u0007C\u0004\u0002\u0000A\u0002\r!!!\u0002\u0017\u001d,GOT3x)>\u0004\u0018n\u0019\u000b\t\u0005C\u00119E!\u0013\u0003LA!!1\u0005B!\u001d\u0011\u0011)Ca\u000f\u000f\t\t\u001d\"q\u0007\b\u0005\u0005S\u0011)D\u0004\u0003\u0003,\tMb\u0002\u0002B\u0017\u0005cqA!!\u001c\u00030%\u0011\u0011qI\u0005\u0005\u0003s\f)%C\u00029\u0003oLA!a=\u0002v&!!\u0011HAy\u0003\u001diWm]:bO\u0016LAA!\u0010\u0003@\u000592I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u0005s\t\t0\u0003\u0003\u0003D\t\u0015#AD\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u0006\u0005\u0005{\u0011y\u0004C\u0004\u0002fE\u0002\r!a\u001a\t\u0011\u0005%\u0015\u0007%AA\u0002\u001dC\u0011\"!$2!\u0003\u0005\r!a\n\u0002+\u001d,GOT3x)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%e\u0005)r-\u001a;OK^$v\u000e]5dI\u0011,g-Y;mi\u0012\u001a\u0004")
public class AutoTopicCreationManagerTest {
    private final int requestTimeout;
    private KafkaConfig config;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
    private final ZkAdminManager adminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
    private final KafkaController controller = (KafkaController)Mockito.mock(KafkaController.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private AutoTopicCreationManager autoTopicCreationManager;
    private final int internalTopicPartitions;
    private final short internalTopicReplicationFactor = (short)2;

    private int requestTimeout() {
        return this.requestTimeout;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ZkAdminManager adminManager() {
        return this.adminManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private TransactionCoordinator transactionCoordinator() {
        return this.transactionCoordinator;
    }

    private AutoTopicCreationManager autoTopicCreationManager() {
        return this.autoTopicCreationManager;
    }

    private void autoTopicCreationManager_$eq(AutoTopicCreationManager x$1) {
        this.autoTopicCreationManager = x$1;
    }

    private int internalTopicPartitions() {
        return this.internalTopicPartitions;
    }

    private short internalTopicReplicationFactor() {
        return this.internalTopicReplicationFactor;
    }

    @BeforeEach
    public void setup() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.setProperty(KafkaConfig$.MODULE$.RequestTimeoutMsProp(), Integer.toString(this.requestTimeout()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(this.internalTopicPartitions()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(this.internalTopicPartitions()));
        props.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Short.toString(this.internalTopicReplicationFactor()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        .colon.colon aliveBrokers = new .colon.colon((Object)TestUtils$.MODULE$.createBroker(0, "host0", 0, SecurityProtocol.PLAINTEXT), (List)new .colon.colon((Object)TestUtils$.MODULE$.createBroker(1, "host1", 1, SecurityProtocol.PLAINTEXT), (List)Nil$.MODULE$));
        Mockito.reset((Object[])new Object[]{this.metadataCache(), this.controller(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator()});
        Mockito.when((Object)this.metadataCache().getAliveBrokers()).thenReturn((Object)aliveBrokers);
    }

    @Test
    public void testCreateOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateTxnTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateNonInternalTopic() {
        this.testCreateTopic("topic", false, 1, (short)1);
    }

    private void testCreateTopic(String topicName, boolean isInternal, int numPartitions, short replicationFactor) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)new Some((Object)this.brokerToController()), (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, numPartitions, replicationFactor));
        CreateTopicsRequest.Builder requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal);
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.eq((Object)requestBody), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
    }

    private int testCreateTopic$default$3() {
        return 1;
    }

    private short testCreateTopic$default$4() {
        return 1;
    }

    @Test
    public void testCreateTopicsWithForwardingDisabled() {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
        String topicName = "topic";
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, false);
        ((ZkAdminManager)Mockito.verify((Object)this.adminManager())).createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)this.getNewTopic(topicName, 1, (short)1))}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Function1)ArgumentMatchers.any(Function1.class));
    }

    @Test
    public void testInvalidReplicationFactorForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "topic", false, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testInvalidReplicationFactorForConsumerOffsetsTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__consumer_offsets", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testInvalidReplicationFactorForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.INVALID_REPLICATION_FACTOR, "__transaction_state", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testTopicExistsErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForConsumerOffsetsTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testTopicExistsErrorSwapForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.TOPIC_ALREADY_EXISTS, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForNonInternalTopics() {
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "topic", false, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForConsumerOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__consumer_offsets", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testRequestTimeoutErrorSwapForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.REQUEST_TIMED_OUT, "__transaction_state", true, (Option<Errors>)new Some((Object)Errors.LEADER_NOT_AVAILABLE));
    }

    @Test
    public void testUnknownTopicPartitionForNonIntervalTopic() {
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "topic", false, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testUnknownTopicPartitionForConsumerOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().offsetsTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__consumer_offsets", true, (Option<Errors>)None$.MODULE$);
    }

    @Test
    public void testUnknownTopicPartitionForTxnOffsetTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testErrorWithCreationInZk(Errors.UNKNOWN_TOPIC_OR_PARTITION, "__transaction_state", true, (Option<Errors>)None$.MODULE$);
    }

    private void testErrorWithCreationInZk(Errors error, String topicName, boolean isInternal, Option<Errors> expectedError) {
        CreateTopicsRequestData.CreatableTopic creatableTopic;
        block9: {
            block5: {
                CreateTopicsRequestData.CreatableTopic creatableTopic2;
                block8: {
                    block6: {
                        block7: {
                            this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), (Option)None$.MODULE$, (Option)new Some((Object)this.adminManager()), (Option)new Some((Object)this.controller()), this.groupCoordinator(), this.transactionCoordinator()));
                            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            if (!isInternal) break block5;
                            switch (topicName == null ? 0 : topicName.hashCode()) {
                                case -970371369: {
                                    if ("__consumer_offsets".equals(topicName)) {
                                        break;
                                    }
                                    break block6;
                                }
                                case -253293552: {
                                    if (!"__transaction_state".equals(topicName)) break block6;
                                    break block7;
                                }
                                default: {
                                    break block6;
                                }
                            }
                            creatableTopic2 = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().offsetsTopicPartitions()), Predef$.MODULE$.Short2short(this.config().offsetsTopicReplicationFactor()));
                            break block8;
                        }
                        creatableTopic2 = this.getNewTopic(topicName, Predef$.MODULE$.Integer2int(this.config().transactionTopicPartitions()), Predef$.MODULE$.Short2short(this.config().transactionTopicReplicationFactor()));
                        break block8;
                    }
                    throw new MatchError((Object)topicName);
                }
                creatableTopic = creatableTopic2;
                break block9;
            }
            creatableTopic = this.getNewTopic(topicName, 1, (short)1);
        }
        CreateTopicsRequestData.CreatableTopic newTopic = creatableTopic;
        Errors errors = error;
        Errors errors2 = Errors.UNKNOWN_TOPIC_OR_PARTITION;
        Map topicErrors = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? null : (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)new ApiError(error))}));
        this.adminManager().createTopics(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((boolean)false), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)newTopic)}))), (Map)ArgumentMatchers.eq((Object)Map$.MODULE$.empty()), (ControllerMutationQuota)ArgumentMatchers.any(ControllerMutationQuota.class), (Function1)ArgumentMatchers.any(Function1.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            AutoTopicCreationManagerTest.$anonfun$testErrorWithCreationInZk$1(topicErrors, invocation);
            return BoxedUnit.UNIT;
        });
        this.createTopicAndVerifyResult((Errors)expectedError.getOrElse((Function0 & Serializable)() -> error), topicName, isInternal);
    }

    private Option<Errors> testErrorWithCreationInZk$default$4() {
        return None$.MODULE$;
    }

    private void createTopicAndVerifyResult(Errors error, String topicName, boolean isInternal) {
        Seq topicResponses = this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$);
        Assertions.assertEquals((Object)new .colon.colon((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setIsInternal(isInternal).setName(topicName), (List)Nil$.MODULE$), (Object)topicResponses);
    }

    private CreateTopicsRequestData.CreatableTopic getNewTopic(String topicName, int numPartitions, short replicationFactor) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor);
    }

    private int getNewTopic$default$2() {
        return 1;
    }

    private short getNewTopic$default$3() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testErrorWithCreationInZk$1(Map topicErrors$1, InvocationOnMock invocation) {
        ((Function1)invocation.getArgument(5)).apply((Object)topicErrors$1);
    }

    public AutoTopicCreationManagerTest() {
        this.requestTimeout = 100;
        this.internalTopicPartitions = 2;
    }
}

