/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013E!\u0005\u0003\u00041\u0001\u0001\u0006Ia\t\u0005\bc\u0001\u0001\r\u0011\"\u00053\u0011\u001d1\u0004\u00011A\u0005\u0012]Ba!\u0010\u0001!B\u0013\u0019\u0004b\u0002 \u0001\u0005\u0004%\tb\u0010\u0005\u0007\u000b\u0002\u0001\u000b\u0011\u0002!\t\u000b\u0019\u0003A\u0011A$\t\u000bM\u0003A\u0011\u0003+\t\u000b\u0005\u0004A\u0011\u00032\t\u0013\u0005E\u0001!%A\u0005\u0012\u0005M\u0001bBA\u0017\u0001\u0011E\u0011q\u0006\u0005\b\u00037\u0002A\u0011CA/\u0011\u001d\tI\b\u0001C\t\u0003w\u0012!DQ1tK\u000ec\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d+fgRT!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0012\u0003\u0011!\u0018.\\3\u0016\u0003\r\u0002\"\u0001\n\u0018\u000e\u0003\u0015R!AJ\u0014\u0002\u000bU$\u0018\u000e\\:\u000b\u0005!J\u0013AB2p[6|gN\u0003\u0002\u0015U)\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0013\tySE\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u00031qW/\\\"bY2\u0014\u0017mY6t+\u0005\u0019\u0004C\u0001\r5\u0013\t)\u0014DA\u0002J]R\f\u0001C\\;n\u0007\u0006dGNY1dWN|F%Z9\u0015\u0005aZ\u0004C\u0001\r:\u0013\tQ\u0014D\u0001\u0003V]&$\bb\u0002\u001f\u0006\u0003\u0003\u0005\raM\u0001\u0004q\u0012\n\u0014!\u00048v[\u000e\u000bG\u000e\u001c2bG.\u001c\b%A\u0004nKR\u0014\u0018nY:\u0016\u0003\u0001\u0003\"!Q\"\u000e\u0003\tS!AP\u0014\n\u0005\u0011\u0013%aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005AA/Z1s\t><h\u000eF\u00019Q\tI\u0011\n\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u0006\u0019\u0011\r]5\u000b\u00059{\u0015a\u00026va&$XM\u001d\u0006\u0003!2\nQA[;oSRL!AU&\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001C2bY2\u0014\u0017mY6\u0015\u0005a*\u0006\"\u0002,\u000b\u0001\u00049\u0016\u0001\u0003:fgB|gn]3\u0011\u0005asfBA-]\u001b\u0005Q&BA.\u0014\u0003\u001dqW\r^<pe.L!!\u0018.\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011q\f\u0019\u0002\t%\u0016\u001c\bo\u001c8tK*\u0011QLW\u0001\rEVLG\u000e\u001a*fcV,7\u000f^\u000b\u0003G&$B\u0001\u001a=\u0002\u0004A!\u0001$Z4v\u0013\t1\u0017D\u0001\u0004UkBdWM\r\t\u0003Q&d\u0001\u0001B\u0003k\u0017\t\u00071NA\u0001U#\taw\u000e\u0005\u0002\u0019[&\u0011a.\u0007\u0002\b\u001d>$\b.\u001b8h!\t\u00018/D\u0001r\u0015\t\u0011x%\u0001\u0005sKF,Xm\u001d;t\u0013\t!\u0018OA\bBEN$(/Y2u%\u0016\fX/Z:u!\tAf/\u0003\u0002xA\n9!+Z9vKN$\b\"B=\f\u0001\u0004Q\u0018a\u00022vS2$WM\u001d\t\u0004wz<gB\u00019}\u0013\ti\u0018/A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\ry\u0018\u0011\u0001\u0002\b\u0005VLG\u000eZ3s\u0015\ti\u0018\u000fC\u0005\u0002\u0006-\u0001\n\u00111\u0001\u0002\b\u0005aA.[:uK:,'OT1nKB!\u0011\u0011BA\u0007\u001b\t\tYA\u0003\u0002\\O%!\u0011qBA\u0006\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003Y\u0011W/\u001b7e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T\u0003BA\u000b\u0003W)\"!a\u0006+\t\u0005\u001d\u0011\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0019\u0011QE\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0005}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)!\u000e\u0004b\u0001W\u0006a!-^5mIN+7o]5p]R!\u0011\u0011GA$!\u0011\t\u0019$a\u0011\u000f\u0007\u0005UBL\u0004\u0003\u00028\u0005\u0005c\u0002BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005uR#\u0001\u0004=e>|GOP\u0005\u0002)%\u00111lE\u0005\u0004\u0003\u000b\u0002'aB*fgNLwN\u001c\u0005\b\u0003\u0013j\u0001\u0019AA&\u0003\u0011)8/\u001a:\u0011\t\u00055\u0013Q\u000b\b\u0005\u0003\u001f\n\t\u0006E\u0002\u0002:eI1!a\u0015\u001a\u0003\u0019\u0001&/\u001a3fM&!\u0011qKA-\u0005\u0019\u0019FO]5oO*\u0019\u00111K\r\u0002\u00175\f\u0017PY3SK\u000e|'\u000f\u001a\u000b\ng\u0005}\u0013\u0011NA6\u0003_Bq!!\u0019\u000f\u0001\u0004\t\u0019'\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000fE\u0002!\u0003KJ1!a\u001a\u0012\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u000f\u0005%c\u00021\u0001\u0002L!9\u0011Q\u000e\bA\u0002\u0005-\u0013\u0001C2mS\u0016tG/\u00133\t\u000f\u0005Ed\u00021\u0001\u0002t\u0005)a/\u00197vKB\u0019\u0001$!\u001e\n\u0007\u0005]\u0014D\u0001\u0004E_V\u0014G.Z\u0001\ti\"\u0014x\u000e\u001e;mKRY\u0001(! \u0002\u0000\u0005\u0005\u00151QAD\u0011\u001d\t\tg\u0004a\u0001\u0003GBq!!\u0013\u0010\u0001\u0004\tY\u0005C\u0004\u0002n=\u0001\r!a\u0013\t\r\u0005\u0015u\u00021\u00014\u00039!\bN]8ui2,G+[7f\u001bNDq!!#\u0010\u0001\u0004\tY)A\rdQ\u0006tg.\u001a7UQJ|G\u000f\u001e7j]\u001e\u001c\u0015\r\u001c7cC\u000e\\\u0007#\u0002\r\u0002\u000e^C\u0014bAAH3\tIa)\u001e8di&|g.\r")
public class BaseClientQuotaManagerTest {
    private final MockTime time = new MockTime();
    private int numCallbacks = 0;
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());

    public MockTime time() {
        return this.time;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    public void callback(RequestChannel.Response response) {
        if (response instanceof RequestChannel.StartThrottlingResponse) {
            return;
        }
        if (response instanceof RequestChannel.EndThrottlingResponse) {
            this.numCallbacks_$eq(this.numCallbacks() + 1);
            return;
        }
        throw new MatchError((Object)response);
    }

    public <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = RequestTestUtils.serializeRequestWithHeader((RequestHeader)new RequestHeader(builder.apiKey(), request.version(), "", 0), (AbstractRequest)request);
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics, (Option)None$.MODULE$));
    }

    public <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public RequestChannel.Session buildSession(String user) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return new RequestChannel.Session(principal, null);
    }

    public int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        return quotaManager.maybeRecordAndGetThrottleTimeMs(this.buildSession(user), clientId, value, this.time().milliseconds());
    }

    /*
     * WARNING - void declaration
     */
    public void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        void var7_7;
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        quotaManager.throttle((RequestChannel.Request)var7_7, throttleTimeMs, channelThrottlingCallback);
    }
}

