/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005e4A!\u0005\n\u0001/!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0003\u0019\u0003B\u0002\u0016\u0001A\u0003%A\u0005C\u0004,\u0001\t\u0007I\u0011A\u0012\t\r1\u0002\u0001\u0015!\u0003%\u0011\u001di\u0003\u00011A\u0005\u00029BqA\u0010\u0001A\u0002\u0013\u0005q\b\u0003\u0004F\u0001\u0001\u0006Ka\f\u0005\b\r\u0002\u0001\r\u0011\"\u0001H\u0011\u001dY\u0005\u00011A\u0005\u00021CaA\u0014\u0001!B\u0013A\u0005\"B(\u0001\t\u0003\u0002\u0006\"\u00020\u0001\t\u0003\u0002\u0006\"B2\u0001\t\u0003\u0001\u0006\"\u00025\u0001\t\u0003\u0001\u0006\"\u00026\u0001\t\u0013Y'A\u0005'fC\u0012,'/\u00127fGRLwN\u001c+fgRT!a\u0005\u000b\u0002\rM,'O^3s\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u000b\u0002\u0005i\\\u0017BA\u000f\u001b\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011AE\u0001\nEJ|7.\u001a:JIF*\u0012\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0004\u0013:$\u0018A\u00032s_.,'/\u001332A\u0005I!M]8lKJLEMM\u0001\u000bEJ|7.\u001a:JIJ\u0002\u0013aB:feZ,'o]\u000b\u0002_A\u0019\u0001\u0007O\u001e\u000f\u0005E2dB\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0017\u0003\u0019a$o\\8u}%\tq%\u0003\u00028M\u00059\u0001/Y2lC\u001e,\u0017BA\u001d;\u0005\r\u0019V-\u001d\u0006\u0003o\u0019\u0002\"!\t\u001f\n\u0005u\u0012\"aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011\u0001i\u0011\t\u0003K\u0005K!A\u0011\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\t\u001e\t\t\u00111\u00010\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005a2\u000f^1mK\u000e{g\u000e\u001e:pY2,'/\u00129pG\"$U\r^3di\u0016$W#\u0001%\u0011\u0005\u0015J\u0015B\u0001&'\u0005\u001d\u0011un\u001c7fC:\f\u0001e\u001d;bY\u0016\u001cuN\u001c;s_2dWM]#q_\u000eDG)\u001a;fGR,Gm\u0018\u0013fcR\u0011\u0001)\u0014\u0005\b\t*\t\t\u00111\u0001I\u0003u\u0019H/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0012+G/Z2uK\u0012\u0004\u0013!B:fiV\u0003H#\u0001!)\u00051\u0011\u0006CA*]\u001b\u0005!&BA+W\u0003\r\t\u0007/\u001b\u0006\u0003/b\u000bqA[;qSR,'O\u0003\u0002Z5\u0006)!.\u001e8ji*\t1,A\u0002pe\u001eL!!\u0018+\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\ti\u0001\r\u0005\u0002TC&\u0011!\r\u0016\u0002\n\u0003\u001a$XM]#bG\"\f!\u0004^3ti2+\u0017\rZ3s\u000b2,7\r^5p]\u0006sG-\u00129pG\"D#AD3\u0011\u0005M3\u0017BA4U\u0005\u0011!Vm\u001d;\u0002UQ,7\u000f\u001e'fC\u0012,'/\u00127fGRLwN\\,ji\"\u001cF/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"\u0012q\"Z\u0001\u001dgR\fG.Z\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195DC2d'-Y2l)\t\u0001E\u000eC\u0003n!\u0001\u0007a.\u0001\u0005sKN\u0004xN\\:f!\tyw/D\u0001q\u0015\t\t(/\u0001\u0005sKF,Xm\u001d;t\u0015\t\u0019H/\u0001\u0004d_6lwN\u001c\u0006\u0003+UT!A\u001e.\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tA\bO\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\u0002")
public class LeaderElectionTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private scala.collection.immutable.Seq<KafkaServer> servers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    private boolean staleControllerEpochDetected = false;

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public scala.collection.immutable.Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public boolean staleControllerEpochDetected() {
        return this.staleControllerEpochDetected;
    }

    public void staleControllerEpochDetected_$eq(boolean x$1) {
        this.staleControllerEpochDetected = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @BeforeEach
    public void setUp() {
        KafkaServer kafkaServer;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer2;
        Time time;
        KafkaServer kafkaServer3;
        void createServer_time2;
        void createServer_config2;
        KafkaServer kafkaServer4;
        Time time2;
        super.setUp();
        Properties configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), false, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        Properties configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), false, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        configProps1.put("unclean.leader.election.enable", "true");
        configProps2.put("unclean.leader.election.enable", "true");
        Time time3 = time2 = Time.SYSTEM;
        time2 = null;
        Time time4 = time3;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(configProps1);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        KafkaServer kafkaServer5 = kafkaServer4 = createServer_this.createServer((KafkaConfig)createServer_config2, (Time)createServer_time2, (Option<String>)createServer_createServer_threadNamePrefix, false);
        Object var8_7 = null;
        kafkaServer4 = null;
        KafkaServer kafkaServer6 = kafkaServer3 = kafkaServer5;
        Object var5_6 = null;
        kafkaConfig = null;
        time4 = null;
        kafkaServer3 = null;
        KafkaServer server1 = kafkaServer6;
        Time time5 = time = Time.SYSTEM;
        time = null;
        Time time6 = time5;
        KafkaConfig kafkaConfig2 = KafkaConfig$.MODULE$.fromProps(configProps2);
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix2 = None$.MODULE$;
        KafkaServer kafkaServer7 = kafkaServer2 = createServer_this2.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix2, false);
        Object var14_15 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer8 = kafkaServer = kafkaServer7;
        Object var11_14 = null;
        kafkaConfig2 = null;
        time6 = null;
        kafkaServer = null;
        KafkaServer server2 = kafkaServer8;
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)this.servers().$plus$plus((IterableOnce)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2})))));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        super.tearDown();
    }

    @Test
    public void testLeaderElectionAndEpoch() {
        None$ none$;
        None$ none$2;
        String topic = "new-topic";
        int partitionId = 0;
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), 15000L);
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaServer>)this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertTrue((leader1 == 0 ? 1 : 0) != 0, (String)"Leader should be broker 0");
        Assertions.assertEquals((int)0, (int)leaderEpoch1, (String)"First epoch value should be 0");
        ((KafkaServer)this.servers().head()).shutdown();
        KafkaZkClient x$1 = this.zkClient();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leader1));
        long l = 30000L;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$6 = none$3;
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, topic, partitionId, l, (Option<Object>)x$4, (Option<Object>)x$6);
        int leaderEpoch2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertEquals((int)1, (int)leader2, (String)"Leader must move to broker 1");
        Assertions.assertEquals((int)(leaderEpoch1 + 2), (int)leaderEpoch2, (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Second epoch value should be %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch1 + 2))})));
        ((KafkaServer)this.servers().head()).startup();
        long l2 = 15000L;
        long l3 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$1(this, topic, partitionId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l2) {
                Assertions.fail((String)"Inconsistent metadata after second broker startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l2), l3));
        }
        ((KafkaServer)this.servers().last()).shutdown();
        Thread.sleep(this.zookeeper().tickTime());
        KafkaZkClient x$7 = this.zkClient();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long l4 = 30000L;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$12 = none$4;
        int leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, topic, partitionId, l4, (Option<Object>)x$10, (Option<Object>)x$12);
        int leaderEpoch3 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertEquals((int)0, (int)leader3, (String)"Leader must return to 0");
        Assertions.assertEquals((int)(leaderEpoch2 + 2), (int)leaderEpoch3, (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Second epoch value should be %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch2 + 2))})));
    }

    @Test
    public void testLeaderElectionWithStaleControllerEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaServer>)this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("leader Epoch: ").append(leaderEpoch1).toString());
        this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Leader is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leader1)})));
        Assertions.assertTrue((leader1 == 0 || leader1 == 1 ? 1 : 0) != 0, (String)"Leader could be broker 0 or broker 1");
        Assertions.assertEquals((int)0, (int)leaderEpoch1, (String)"First epoch value should be 0");
        int controllerId = 2;
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Map brokerAndEpochs = ((IterableOnceOps)this.servers().map((Function1 & Serializable)s -> new Tuple2((Object)new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaServer)s, SecurityProtocol.PLAINTEXT), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)s.kafkaController().brokerEpoch())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Iterable nodes = (Iterable)brokerAndEpochs.keys().map((Function1 & Serializable)x$2 -> x$2.node(listenerName));
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.setLiveBrokers((Map)brokerAndEpochs);
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
        controllerChannelManager.startup();
        try {
            int staleControllerEpoch = 0;
            scala.collection.immutable.Seq partitionStates = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topic).setPartitionIndex(partitionId).setControllerEpoch(2).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setIsNew(false)}));
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, staleControllerEpoch, ((KafkaServer)this.servers().apply(this.brokerId2())).kafkaController().brokerEpoch(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitionStates).asJava(), Collections.singletonMap(topic, Uuid.randomUuid()), (Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)nodes.toSet()).asJava());
            controllerChannelManager.sendRequest(this.brokerId2(), (AbstractControlRequest.Builder)requestBuilder, (Function1 & Serializable)response -> {
                this.staleControllerEpochCallback(response);
                return BoxedUnit.UNIT;
            });
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.staleControllerEpochDetected()) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Controller epoch should be stale");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            Assertions.assertTrue((boolean)this.staleControllerEpochDetected(), (String)"Stale controller epoch not detected by the broker");
        }
        finally {
            controllerChannelManager.shutdown();
            metrics.close();
        }
    }

    private void staleControllerEpochCallback(AbstractResponse response) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)response;
        Errors errors = leaderAndIsrResponse.error();
        boolean bl = Errors.STALE_CONTROLLER_EPOCH.equals(errors);
        this.staleControllerEpochDetected_$eq(bl);
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionAndEpoch$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$1) {
        return x$1.isr().size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionAndEpoch$1(LeaderElectionTest $this, String topic$1, int partitionId$1) {
        return ((KafkaServer)$this.servers().last()).metadataCache().getPartitionInfo(topic$1, partitionId$1).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$2(x$1)));
    }

    public static final /* synthetic */ String $anonfun$testLeaderElectionAndEpoch$3() {
        return "Inconsistent metadata after second broker startup";
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionWithStaleControllerEpoch$8(LeaderElectionTest $this) {
        return $this.staleControllerEpochDetected();
    }

    public static final /* synthetic */ String $anonfun$testLeaderElectionWithStaleControllerEpoch$9() {
        return "Controller epoch should be stale";
    }

    public LeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }
}

