/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerMetadataException;
import kafka.common.InconsistentClusterIdException;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.RawMetaProperties;
import kafka.server.ZkMetaProperties;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0005\u0005-c\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001A\u0002\u0013\u0005Q\u0006C\u00042\u0001\u0001\u0007I\u0011\u0001\u001a\t\rm\u0002\u0001\u0015)\u0003/\u0011\u001da\u0004\u00011A\u0005\u00025Bq!\u0010\u0001A\u0002\u0013\u0005a\b\u0003\u0004A\u0001\u0001\u0006KA\f\u0005\b\u0003\u0002\u0001\r\u0011\"\u0001.\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCa!\u0012\u0001!B\u0013q\u0003b\u0002$\u0001\u0001\u0004%\ta\u0012\u0005\b#\u0002\u0001\r\u0011\"\u0001S\u0011\u0019!\u0006\u0001)Q\u0005\u0011\"9Q\u000b\u0001b\u0001\n\u00031\u0006BB0\u0001A\u0003%q\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0003p\u0001\u0011\u0005\u0013\rC\u0003u\u0001\u0011\u0005\u0011\rC\u0003z\u0001\u0011\u0005\u0011\rC\u0003|\u0001\u0011\u0005\u0011\rC\u0003~\u0001\u0011\u0005\u0011\rC\u0003\u0000\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002\u0004\u0001!\t!\u0019\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t9\u0001\u0001C\u0001\u0003gAq!!\u0010\u0001\t\u0003\tyDA\u000eTKJ4XM]$f]\u0016\u0014\u0018\r^3DYV\u001cH/\u001a:JIR+7\u000f\u001e\u0006\u0003;y\taa]3sm\u0016\u0014(\"A\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003Ky\t!A_6\n\u0005\u001d\"#\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00029\u000591m\u001c8gS\u001e\fT#\u0001\u0018\u0011\u0005-z\u0013B\u0001\u0019\u001d\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0017\r|gNZ5hc}#S-\u001d\u000b\u0003ge\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012A!\u00168ji\"9!hAA\u0001\u0002\u0004q\u0013a\u0001=%c\u0005A1m\u001c8gS\u001e\f\u0004%A\u0004d_:4\u0017n\u001a\u001a\u0002\u0017\r|gNZ5he}#S-\u001d\u000b\u0003g}BqA\u000f\u0004\u0002\u0002\u0003\u0007a&\u0001\u0005d_:4\u0017n\u001a\u001a!\u0003\u001d\u0019wN\u001c4jON\n1bY8oM&<7g\u0018\u0013fcR\u00111\u0007\u0012\u0005\bu%\t\t\u00111\u0001/\u0003!\u0019wN\u001c4jON\u0002\u0013aB:feZ,'o]\u000b\u0002\u0011B\u0019\u0011\n\u0014(\u000e\u0003)S!aS\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002N\u0015\n\u00191+Z9\u0011\u0005-z\u0015B\u0001)\u001d\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003gMCqA\u000f\u0007\u0002\u0002\u0003\u0007\u0001*\u0001\u0005tKJ4XM]:!\u0003M\u0011'o\\6fe6+G/\u0019)s_B\u001ch)\u001b7f+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0011a\u0017M\\4\u000b\u0003q\u000bAA[1wC&\u0011a,\u0017\u0002\u0007'R\u0014\u0018N\\4\u0002)\t\u0014xn[3s\u001b\u0016$\u0018\r\u0015:paN4\u0015\u000e\\3!\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0004F\u0001\td!\t!W.D\u0001f\u0015\t1w-A\u0002ba&T!\u0001[5\u0002\u000f),\b/\u001b;fe*\u0011!n[\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002Y\u0006\u0019qN]4\n\u00059,'A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0012cB\u0011AM]\u0005\u0003g\u0016\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u00023Q,7\u000f^!vi><UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a\u0015\u0003%Y\u0004\"\u0001Z<\n\u0005a,'\u0001\u0002+fgR\f!\u0007^3ti\u0006+Ho\\$f]\u0016\u0014\u0018\r^3DYV\u001cH/\u001a:JI\u001a{'oS1gW\u0006\u001cE.^:uKJ\u001cV-];f]RL\u0017\r\u001c\u0015\u0003'Y\f\u0001\u0007^3ti\u0006+Ho\\$f]\u0016\u0014\u0018\r^3DYV\u001cH/\u001a:JI\u001a{'oS1gW\u0006\u001cE.^:uKJ\u0004\u0016M]1mY\u0016d\u0007F\u0001\u000bw\u0003Q\"Xm\u001d;D_:\u001c\u0018n\u001d;f]R\u001cE.^:uKJLEM\u0012:p[j{wn[3fa\u0016\u0014\u0018I\u001c3Ge>lW*\u001a;b!J|\u0007o\u001d\u0015\u0003+Y\fa\u0007^3ti&s7m\u001c8tSN$XM\u001c;DYV\u001cH/\u001a:JI\u001a\u0013x.\u001c.p_.,W\r]3s\u0003:$gI]8n\u001b\u0016$\u0018\r\u0015:paND#A\u0006<\u0002iQ,7\u000f^%oG>t7/[:uK:$(I]8lKJlU\r^1eCR\f')\u001a;xK\u0016tW*\u001e7uSBdW\rT8h\t&\u00148\u000f\u000b\u0002\u0018m\u0006\u0019bm\u001c:hK\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR91'a\u0003\u0002&\u0005=\u0002bBA\u00071\u0001\u0007\u0011qB\u0001\bY><G)\u001b:t!\u0011IE*!\u0005\u0011\t\u0005M\u0011\u0011\u0005\b\u0005\u0003+\ti\u0002E\u0002\u0002\u0018Uj!!!\u0007\u000b\u0007\u0005m\u0001%\u0001\u0004=e>|GOP\u0005\u0004\u0003?)\u0014A\u0002)sK\u0012,g-C\u0002_\u0003GQ1!a\b6\u0011\u001d\t9\u0003\u0007a\u0001\u0003S\t\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0004i\u0005-\u0012bAA\u0017k\t\u0019\u0011J\u001c;\t\u000f\u0005E\u0002\u00041\u0001\u0002\u0012\u0005I1\r\\;ti\u0016\u0014\u0018\n\u001a\u000b\bg\u0005U\u0012\u0011HA\u001e\u0011\u001d\t9$\u0007a\u0001\u0003#\ta\u0001\\8h\t&\u0014\bbBA\u00143\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003cI\u0002\u0019AA\t\u0003Q1XM]5gs\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR1\u0011\u0011IA$\u0003\u0013\u00022\u0001NA\"\u0013\r\t)%\u000e\u0002\b\u0005>|G.Z1o\u0011\u001d\tiA\u0007a\u0001\u0003\u001fAq!!\r\u001b\u0001\u0004\t\t\u0002")
public class ServerGenerateClusterIdTest
extends ZooKeeperTestHarness {
    private KafkaConfig config1 = null;
    private KafkaConfig config2 = null;
    private KafkaConfig config3 = null;
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final String brokerMetaPropsFile;

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public KafkaConfig config3() {
        return this.config3;
    }

    public void config3_$eq(KafkaConfig x$1) {
        this.config3 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)));
        this.config3_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateClusterId() {
        KafkaServer kafkaServer;
        void createServer_threadNamePrefix;
        void createServer_config;
        KafkaServer kafkaServer2;
        KafkaServer kafkaServer3;
        void createServer_threadNamePrefix2;
        void createServer_config2;
        KafkaServer kafkaServer4;
        Assertions.assertFalse((boolean)this.zkClient().getClusterId().isDefined());
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig = this.config1();
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        KafkaServer kafkaServer5 = kafkaServer4 = createServer_this.createServer((KafkaConfig)createServer_config2, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix2, false);
        Object var7_4 = null;
        kafkaServer4 = null;
        KafkaServer kafkaServer6 = kafkaServer3 = kafkaServer5;
        Object var4_3 = null;
        kafkaConfig = null;
        option = null;
        kafkaServer3 = null;
        KafkaServer server1 = kafkaServer6;
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        String clusterIdOnFirstBoot = server1.clusterId();
        TestUtils.isValidClusterId((String)clusterIdOnFirstBoot);
        server1.shutdown();
        Assertions.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assertions.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        Option option2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig2 = this.config1();
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        Time createServer_createServer_time2 = Time.SYSTEM;
        KafkaServer kafkaServer7 = kafkaServer2 = createServer_this2.createServer((KafkaConfig)createServer_config, createServer_createServer_time2, (Option<String>)createServer_threadNamePrefix, false);
        Object var13_12 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer8 = kafkaServer = kafkaServer7;
        Object var10_11 = null;
        kafkaConfig2 = null;
        option2 = null;
        kafkaServer = null;
        server1 = kafkaServer8;
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        String clusterIdOnSecondBoot = server1.clusterId();
        Assertions.assertEquals((Object)clusterIdOnFirstBoot, (Object)clusterIdOnSecondBoot);
        server1.shutdown();
        Assertions.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assertions.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateClusterIdForKafkaClusterSequential() {
        void createServer_threadNamePrefix;
        void createServer_config;
        void createServer_threadNamePrefix2;
        void createServer_config2;
        void createServer_threadNamePrefix3;
        void createServer_config3;
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig = this.config1();
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        Object var10_4 = null;
        Object var7_3 = null;
        kafkaConfig = null;
        option = null;
        KafkaServer server1 = createServer_this.createServer((KafkaConfig)createServer_config3, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix3, false);
        String clusterIdFromServer1 = server1.clusterId();
        Option option2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig2 = this.config2();
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        Time createServer_createServer_time2 = Time.SYSTEM;
        Object var14_10 = null;
        Object var11_9 = null;
        kafkaConfig2 = null;
        option2 = null;
        KafkaServer server2 = createServer_this2.createServer((KafkaConfig)createServer_config2, createServer_createServer_time2, (Option<String>)createServer_threadNamePrefix2, false);
        String clusterIdFromServer2 = server2.clusterId();
        Option option3 = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig3 = this.config3();
        TestUtils$ createServer_this3 = TestUtils$.MODULE$;
        Time createServer_createServer_time3 = Time.SYSTEM;
        Object var18_16 = null;
        Object var15_15 = null;
        kafkaConfig3 = null;
        option3 = null;
        KafkaServer server3 = createServer_this3.createServer((KafkaConfig)createServer_config, createServer_createServer_time3, (Option<String>)createServer_threadNamePrefix, false);
        String clusterIdFromServer3 = server3.clusterId();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)clusterIdFromServer2, (String)clusterIdFromServer3);
        server1.startup();
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)server1.clusterId());
        server2.startup();
        Assertions.assertEquals((Object)clusterIdFromServer2, (Object)server2.clusterId());
        server3.startup();
        Assertions.assertEquals((Object)clusterIdFromServer3, (Object)server3.clusterId());
        this.servers().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateClusterIdForKafkaClusterParallel() {
        void var6_6;
        void var5_5;
        void var4_4;
        SeqOps seqOps;
        block3: {
            Seq<KafkaServer> seq;
            block2: {
                Future firstBoot = Future$.MODULE$.traverse((IterableOnce)new .colon.colon((Object)this.config1(), (List)new .colon.colon((Object)this.config2(), (List)new .colon.colon((Object)this.config3(), (List)Nil$.MODULE$))), (Function1 & Serializable)config -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
                    Option createServer_threadNamePrefix = Option$.MODULE$.apply((Object)this.getClass().getName());
                    TestUtils$ createServer_this = TestUtils$.MODULE$;
                    Time createServer_createServer_time = Time.SYSTEM;
                    return createServer_this.createServer((KafkaConfig)config, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, false);
                }, ExecutionContext.Implicits$.MODULE$.global()), BuildFrom$.MODULE$.buildFromIterableOps(), ExecutionContext.Implicits$.MODULE$.global());
                this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)firstBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
                seq = this.servers();
                if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = Seq$.MODULE$.unapplySeq(seq))) break block2;
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3) == 0) break block3;
            }
            throw new MatchError(seq);
        }
        KafkaServer server1 = (KafkaServer)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        KafkaServer server2 = (KafkaServer)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        KafkaServer server3 = (KafkaServer)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
        String clusterIdFromServer1 = var4_4.clusterId();
        String clusterIdFromServer2 = var5_5.clusterId();
        String clusterIdFromServer3 = var6_6.clusterId();
        this.servers().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)clusterIdFromServer2, (String)clusterIdFromServer3);
        Future secondBoot = Future$.MODULE$.traverse((IterableOnce)new .colon.colon((Object)var4_4, (List)new .colon.colon((Object)var5_5, (List)new .colon.colon((Object)var6_6, (List)Nil$.MODULE$))), (Function1 & Serializable)server -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
            server.startup();
            return server;
        }, ExecutionContext.Implicits$.MODULE$.global()), BuildFrom$.MODULE$.buildFromIterableOps(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)secondBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        this.servers().foreach((Function1 & Serializable)server -> {
            ServerGenerateClusterIdTest.$anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(clusterIdFromServer1, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsistentClusterIdFromZookeeperAndFromMetaProps() {
        void createServer_threadNamePrefix;
        void createServer_config;
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig = this.config1();
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Time createServer_createServer_time = Time.SYSTEM;
        Object var6_4 = null;
        Object var3_3 = null;
        kafkaConfig = null;
        option = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, createServer_createServer_time, (Option<String>)createServer_threadNamePrefix, false);
        String clusterId = server.clusterId();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), clusterId));
        server.shutdown();
        server.startup();
        Assertions.assertEquals((Object)clusterId, (Object)server.clusterId());
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), server.clusterId()));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentClusterIdFromZookeeperAndFromMetaProps() {
        Time time;
        this.forgeBrokerMetadata((Seq<String>)this.config1().logDirs(), this.config1().brokerId(), "aclusterid");
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        boolean bl = false;
        KafkaServer server = new KafkaServer(x$1, x$3, x$2, bl);
        Assertions.assertThrows(InconsistentClusterIdException.class, () -> server.startup());
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentBrokerMetadataBetweenMultipleLogDirs() {
        Time time;
        String logDir1 = TestUtils.tempDirectory(null, null).getAbsolutePath();
        String logDir2 = TestUtils.tempDirectory(null, null).getAbsolutePath();
        String logDirs = new StringBuilder(1).append(logDir1).append(",").append(logDir2).toString();
        this.forgeBrokerMetadata(logDir1, 1, "ebwOKU-zSieInaFQh_qP4g");
        this.forgeBrokerMetadata(logDir2, 1, "blaOKU-zSieInaFQh_qP4g");
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.setProperty("log.dir", logDirs);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time x$3 = time2;
        boolean bl = false;
        KafkaServer server = new KafkaServer(config, x$3, x$2, bl);
        Assertions.assertThrows(InconsistentBrokerMetadataException.class, () -> server.startup());
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public void forgeBrokerMetadata(Seq<String> logDirs, int brokerId, String clusterId) {
        logDirs.foreach((Function1 & Serializable)logDir -> {
            this.forgeBrokerMetadata(logDir, brokerId, clusterId);
            return BoxedUnit.UNIT;
        });
    }

    public void forgeBrokerMetadata(String logDir, int brokerId, String clusterId) {
        new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append(this.brokerMetaPropsFile()).toString())).write(new ZkMetaProperties(clusterId, brokerId).toProperties());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, String clusterId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable)logDir -> {
                ServerGenerateClusterIdTest.$anonfun$verifyBrokerMetadata$1(this, clusterId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(String clusterIdFromServer1$1, KafkaServer server) {
        Assertions.assertEquals((Object)clusterIdFromServer1$1, (Object)server.clusterId());
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMetadata$2(String clusterId$2, String x$6) {
        String string = x$6;
        return string == null ? clusterId$2 != null : !string.equals(clusterId$2);
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(ServerGenerateClusterIdTest $this, String clusterId$2, Object nonLocalReturnKey1$1, String logDir) {
        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString())).read();
        if (brokerMetadataOpt instanceof Some) {
            Properties properties = (Properties)((Some)brokerMetadataOpt).value();
            if (new RawMetaProperties(properties).clusterId().exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ServerGenerateClusterIdTest.$anonfun$verifyBrokerMetadata$2(clusterId$2, x$6)))) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
        } else {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public ServerGenerateClusterIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

