/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0005=3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0005=!)q\u0005\u0001C\u0001Q!)\u0011\b\u0001C\u0001Q!)1\b\u0001C\u0001Q!)Q\b\u0001C\u0001Q!)q\b\u0001C\u0001Q!)\u0011\t\u0001C\u0001Q!)1\t\u0001C\u0001Q!)Q\t\u0001C\u0001Q!)q\t\u0001C\u0001Q\ty1\u000b^8sC\u001e,Gk\\8m)\u0016\u001cHO\u0003\u0002\u000f\u001f\u0005)Ao\\8mg*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u001b\u0005Ab.Z<TK24W*\u00198bO\u0016$\u0007K]8qKJ$\u0018.Z:\u0015\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0006Qe>\u0004XM\u001d;jKN\f!\u0004^3ti\u000e{gNZ5h)>dun\u001a#je\u0016\u001cGo\u001c:jKN$\u0012!\u000b\t\u0003))J!aK\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u00075\u0002\"AL\u001c\u000e\u0003=R!\u0001M\u0019\u0002\u0007\u0005\u0004\u0018N\u0003\u00023g\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001b6\u0003\u0015QWO\\5u\u0015\u00051\u0014aA8sO&\u0011\u0001h\f\u0002\u0005)\u0016\u001cH/\u0001\u0015uKN$8i\u001c8gS\u001e$v\u000eT8h\t&\u0014Xm\u0019;pe&,7oV5uQ6+G/\u0019'pO\u0012K'\u000f\u000b\u0002\u0005[\u0005yB/Z:u\u0013:4wnQ8n[\u0006tGm\u00148F[B$\u0018\u0010R5sK\u000e$xN]=)\u0005\u0015i\u0013!\t;fgRLeNZ8D_6l\u0017M\u001c3P]6K7o]5oO\u0012K'/Z2u_JL\bF\u0001\u0004.\u0003\u0001\"Xm\u001d;J]\u001a|7i\\7nC:$wJ\u001c#je\u0016\u001cGo\u001c:z\u0003N4\u0015\u000e\\3)\u0005\u001di\u0013a\n;fgRLeNZ8XSRDW*[:nCR\u001c\u0007.\u001a3MK\u001e\f7-_&bM.\f7i\u001c8gS\u001eD#\u0001C\u0017\u0002YQ,7\u000f^%oM><\u0016\u000e\u001e5NSNl\u0017\r^2iK\u0012\u001cV\r\u001c4NC:\fw-\u001a3LC\u001a\\\u0017mQ8oM&<\u0007FA\u0005.\u0003a!Xm\u001d;G_Jl\u0017\r^#naRLH)\u001b:fGR|'/\u001f\u0015\u0003\u00155\na\u0004^3ti\u001a{'/\\1u/&$\b.\u00138wC2LGm\u00117vgR,'/\u00133)\u0005-i\u0003\u0006\u0002\u0001K\u001b:\u0003\"AL&\n\u00051{#a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002Q\u0001")
public class StorageToolTest {
    /*
     * WARNING - void declaration
     */
    private Properties newSelfManagedProperties() {
        void var1_1;
        Properties properties = new Properties();
        properties.setProperty(KafkaConfig$.MODULE$.LogDirsProp(), "/tmp/foo,/tmp/bar");
        properties.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        properties.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "2");
        return var1_1;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/tmp/bar", "/tmp/foo"})), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"/tmp/bar", "/tmp/baz", "/tmp/foo"})), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        File file;
        File file2;
        File file3;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tempDir = file6;
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempDir.toString()}))));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempDir.toString()}))));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        File file;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File file2 = file = TestUtils.tempFile();
        file = null;
        File tempFile = file2;
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempFile.toString()}))));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempDir.toString()}))));
            Assertions.assertEquals((Object)new StringBuilder(235).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedSelfManagedKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList("version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241")).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempDir.toString()}))));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatEmptyDirectory() {
        File file;
        File file2;
        File file3;
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tempDir = file6;
        try {
            MetaProperties metaProperties = new MetaProperties("XcZZOzUqS4yHOjhMQB6JLQ", 2);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempDir.toString()})), metaProperties, false));
            Assertions.assertEquals((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Formatting %s%n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{tempDir})), (Object)stream.toString());
            try {
                Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(new ByteArrayOutputStream()), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempDir.toString()})), metaProperties, false));
            }
            catch (TerseFailure e) {
                Assertions.assertEquals((Object)new StringBuilder(81).append(new StringBuilder(26).append("Log directory ").append(tempDir).append(" is already ").toString()).append("formatted. Use --ignore-formatted to ignore this directory and format the ").append("others.").toString(), (Object)e.getMessage());
            }
            ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
            Assertions.assertEquals((int)0, (int)StorageTool$.MODULE$.formatCommand(new PrintStream(stream2), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempDir.toString()})), metaProperties, true));
            Assertions.assertEquals((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("All of the log directories are already formatted.%n"), (Seq)Nil$.MODULE$), (Object)stream2.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testFormatWithInvalidClusterId() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)"Cluster ID string invalid does not appear to be a valid UUID: Input string `invalid` decoded as 5 bytes, which is not equal to the expected 16 bytes of a base64-encoded UUID", (Object)Assertions.assertThrows(TerseFailure.class, () -> StorageTool$.MODULE$.buildMetadataProperties("invalid", config)).getMessage());
    }
}

