/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\u0011EvAB7o\u0011\u0003\u0001(O\u0002\u0004u]\"\u0005\u0001/\u001e\u0005\u0006y\u0006!\tA \u0005\t\u007f\u0006\u0011\r\u0011\"\u0001\u0002\u0002!A\u00111C\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u0016\u0005\u0011\r\u0011\"\u0001\u0002\u0002!A\u0011qC\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u001a\u0005\u0011\r\u0011\"\u0001\u0002\u0002!A\u00111D\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u001e\u0005\u0011\r\u0011\"\u0001\u0002 !A\u0011qE\u0001!\u0002\u0013\t\tC\u0002\u0004u]\u0002\u0001\u0018\u0011\u0006\u0005\u000b\u0003{Y!Q1A\u0005\u0002\u0005}\u0001BCA \u0017\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011\u0011I\u0006\u0003\u0002\u0003\u0006I!a\u0011\t\u0015\u0005u3B!A!\u0002\u0013\t\t\u0003\u0003\u0006\u0002`-\u0011\t\u0011)A\u0005\u0003CB!\"a\u001a\f\u0005\u0003\u0005\u000b\u0011BA5\u0011)\tyg\u0003B\u0001B\u0003%\u0011\u0011\u000f\u0005\u000b\u0003oZ!\u0011!Q\u0001\n\u0005\u0005\u0002BCA=\u0017\t\u0005\t\u0015!\u0003\u0002|!Q\u0011QQ\u0006\u0003\u0002\u0003\u0006I!a\"\t\u0015\u0005]5B!A!\u0002\u0013\tI\n\u0003\u0006\u00028-\u0011\t\u0011)A\u0005\u0003KC!\"a,\f\u0005\u0003\u0005\u000b\u0011BAY\u0011)\tYl\u0003B\u0001B\u0003%\u0011Q\u0018\u0005\u000b\u0003\u0013\\!\u0011!Q\u0001\n\u0005-\u0007BCAi\u0017\t\u0005\t\u0015!\u0003\u0002\"!Q\u00111[\u0006\u0003\u0002\u0003\u0006I!!6\t\u0015\u0005m7B!A!\u0002\u0013\ti\u000e\u0003\u0004}\u0017\u0011\u0005\u00111]\u0004\b\u0005\u0013Y\u0001\u0012\u0002B\u0006\r\u001d\u0011ya\u0003E\u0005\u0005#Aa\u0001 \u0011\u0005\u0002\t}\u0001b\u0002B\u0011A\u0011\u0005!1\u0005\u0005\n\u0005[\u0004\u0013\u0011!CA\u0005_D\u0011Ba?!\u0003\u0003%\tI!@\u0007\u000f\t=1\u0002\u00118\u0003.!Q!1J\u0013\u0003\u0016\u0004%\tA!\u0014\t\u0015\tuSE!E!\u0002\u0013\u0011y\u0005\u0003\u0006\u0003`\u0015\u0012)\u001a!C\u0001\u0003?A!B!\u0019&\u0005#\u0005\u000b\u0011BA\u0011\u0011)\u0011\u0019'\nBK\u0002\u0013\u0005!Q\n\u0005\u000b\u0005K*#\u0011#Q\u0001\n\t=\u0003B\u0003B4K\tU\r\u0011\"\u0001\u0002 !Q!\u0011N\u0013\u0003\u0012\u0003\u0006I!!\t\t\u0015\t-TE!f\u0001\n\u0003\ty\u0002\u0003\u0006\u0003n\u0015\u0012\t\u0012)A\u0005\u0003CAa\u0001`\u0013\u0005\u0002\t=\u0004b\u0002B>K\u0011\u0005#Q\u0010\u0005\n\u0005\u007f*\u0013\u0011!C\u0001\u0005\u0003C\u0011B!$&#\u0003%\tAa$\t\u0013\t\u0015V%%A\u0005\u0002\t\u001d\u0006\"\u0003BVKE\u0005I\u0011\u0001BH\u0011%\u0011i+JI\u0001\n\u0003\u00119\u000bC\u0005\u00030\u0016\n\n\u0011\"\u0001\u0003(\"I!\u0011W\u0013\u0002\u0002\u0013\u0005\u0013\u0011\u0001\u0005\n\u0005g+\u0013\u0011!C\u0001\u0003?A\u0011B!.&\u0003\u0003%\tAa.\t\u0013\t\rW%!A\u0005B\t\u0015\u0007\"\u0003BjK\u0005\u0005I\u0011\u0001Bk\u0011%\u0011I.JA\u0001\n\u0003\u0012Y\u000eC\u0005\u0003`\u0016\n\t\u0011\"\u0011\u0003b\"I!1]\u0013\u0002\u0002\u0013\u0005#Q\u001d\u0005\n\u0007\u0017Y!\u0019!C\u0005\u0007\u001bA\u0001ba\f\fA\u0003%1q\u0002\u0005\n\u0007cY!\u0019!C\u0005\u0007gA\u0001ba\u0014\fA\u0003%1Q\u0007\u0005\n\u0007#Z!\u0019!C\u0005\u0007'B\u0001ba\u0017\fA\u0003%1Q\u000b\u0005\u000b\u0007;Z!\u0019!C\u0001a\u000e}\u0003\u0002CB4\u0017\u0001\u0006Ia!\u0019\t\u0013\r%4B1A\u0005\u0002\r-\u0004\u0002CB=\u0017\u0001\u0006Ia!\u001c\t\u0013\rm4B1A\u0005\n\ru\u0004\u0002CBD\u0017\u0001\u0006Iaa \t\u0013\r%5B1A\u0005\n\r-\u0005\u0002CBJ\u0017\u0001\u0006Ia!$\t\u0011\rU5\u0002\"\u0005o\u0007/C\u0011ba)\f\u0001\u0004%I!a\b\t\u0013\r\u00156\u00021A\u0005\n\r\u001d\u0006\u0002CBY\u0017\u0001\u0006K!!\t\t\u000f\rM6\u0002\"\u0011\u00046\"A1qW\u0006\u0005\u00029\u001cI\fC\u0004\u0004J.!Iaa3\t\u000f\rU7\u0002\"\u0003\u00046\"A1q[\u0006\u0005\u00129\u001cI\u000eC\u0004\u0004j.!Ia!.\t\u000f\r-8\u0002\"\u0005\u0004n\"9AqA\u0006\u0005\n\rU\u0006b\u0002C\u0005\u0017\u0011%1Q\u0017\u0005\b\t\u0017YA\u0011\u0002C\u0007\u0011\u001d!\tb\u0003C\u0005\u0007kCq\u0001b\u0005\f\t\u0013\u0019)\fC\u0004\u0005\u0016-!I\u0001b\u0006\t\u000f\u0011u1\u0002\"\u0001\u0005 !9A1I\u0006\u0005\n\rU\u0006b\u0002C#\u0017\u0011%1Q\u0017\u0005\t\t7YA\u0011\u00038\u0005H!AA\u0011L\u0006\u0005\u00029$Y\u0006C\u0004\u0005`-!I\u0001\"\u0019\t\u0011\u0011\r4\u0002\"\u0001o\u0003?A\u0001\u0002\"\u001a\f\t\u0003q\u0017q\u0004\u0005\t\tOZA\u0011\u00018\u0005j!9AQO\u0006\u0005\n\u0011]\u0004b\u0002CQ\u0017\u0011%A1\u0015\u0005\t\tO[A\u0011\u00018\u0005*\"9AQV\u0006\u0005B\rU\u0006b\u0002CX\u0017\u0011\u00053QW\u0001\n!J|7-Z:t_JT!a\u001c9\u0002\u000f9,Go^8sW*\t\u0011/A\u0003lC\u001a\\\u0017\r\u0005\u0002t\u00035\taNA\u0005Qe>\u001cWm]:peN\u0011\u0011A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0002s\u0006)1oY1mC&\u00111\u0010\u001f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A]\u0001\u0016\u0013\u0012dW\rU3sG\u0016tG/T3ue&\u001cg*Y7f+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\tAA[1wC&!\u0011\u0011CA\u0004\u0005\u0019\u0019FO]5oO\u00061\u0012\n\u001a7f!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007%A\rOKR<xN]6Qe>\u001cWm]:pe6+GO]5d)\u0006<\u0017A\u0007(fi^|'o\u001b)s_\u000e,7o]8s\u001b\u0016$(/[2UC\u001e\u0004\u0013!\u0005'jgR,g.\u001a:NKR\u0014\u0018n\u0019+bO\u0006\u0011B*[:uK:,'/T3ue&\u001cG+Y4!\u0003M\u0019uN\u001c8fGRLwN\\)vKV,7+\u001b>f+\t\t\t\u0003E\u0002x\u0003GI1!!\ny\u0005\rIe\u000e^\u0001\u0015\u0007>tg.Z2uS>t\u0017+^3vKNK'0\u001a\u0011\u0014\u000b-\tY#!\r\u0011\u0007M\fi#C\u0002\u000209\u0014A#\u00112tiJ\f7\r^*feZ,'\u000f\u00165sK\u0006$\u0007\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]\u0002/A\u0004nKR\u0014\u0018nY:\n\t\u0005m\u0012Q\u0007\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018AA5e\u0003\rIG\rI\u0001\u0005i&lW\r\u0005\u0003\u0002F\u0005eSBAA$\u0015\u0011\tI%a\u0013\u0002\u000bU$\u0018\u000e\\:\u000b\t\u00055\u0013qJ\u0001\u0007G>lWn\u001c8\u000b\u0007E\f\tF\u0003\u0003\u0002T\u0005U\u0013AB1qC\u000eDWM\u0003\u0002\u0002X\u0005\u0019qN]4\n\t\u0005m\u0013q\t\u0002\u0005)&lW-\u0001\bnCb\u0014V-];fgR\u001c\u0016N_3\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u00191/a\u0019\n\u0007\u0005\u0015dN\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002!\r|gN\\3di&|g.U;pi\u0006\u001c\bcA:\u0002l%\u0019\u0011Q\u000e8\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018\u0001F2p]:,7\r^5p]Nl\u0015\r_%eY\u0016l5\u000fE\u0002x\u0003gJ1!!\u001ey\u0005\u0011auN\\4\u00027\u0019\f\u0017\u000e\\3e\u0003V$\b.\u001a8uS\u000e\fG/[8o\t\u0016d\u0017-_'t\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\ti(!!\u000e\u0005\u0005}$bA8\u0002L%!\u00111QA@\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0003\u0002\n\u0006MUBAAF\u0015\u0011\ti)a$\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003#\u000bY%\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t)*a#\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017AB2p]\u001aLw\r\u0005\u0003\u0002\u001c\u0006\u0005VBAAO\u0015\r\ty\n]\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\r\u0016Q\u0014\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0005\u0003\u0002(\u0006-VBAAU\u0015\u0011\t9$a\u0013\n\t\u00055\u0016\u0011\u0016\u0002\b\u001b\u0016$(/[2t\u0003I\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0011\t\u0005M\u0016qW\u0007\u0003\u0003kS1!!%q\u0013\u0011\tI,!.\u0003%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM]\u0001\u000b[\u0016lwN]=Q_>d\u0007\u0003BA`\u0003\u000bl!!!1\u000b\t\u0005\r\u00171J\u0001\u0007[\u0016lwN]=\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u000b\u001b\u0016lwN]=Q_>d\u0017A\u00037pO\u000e{g\u000e^3yiB!\u0011QIAg\u0013\u0011\ty-a\u0012\u0003\u00151{wmQ8oi\u0016DH/A\nd_:tWm\u0019;j_:\fV/Z;f'&TX-\u0001\u000bjgB\u0013\u0018N^5mK\u001e,G\rT5ti\u0016tWM\u001d\t\u0004o\u0006]\u0017bAAmq\n9!i\\8mK\u0006t\u0017!E1qSZ+'o]5p]6\u000bg.Y4feB!\u00111TAp\u0013\u0011\t\t/!(\u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'\u000f\u0006\u0013\u0002f\u0006\u001d\u0018\u0011^Av\u0003[\fy/!=\u0002t\u0006U\u0018q_A}\u0003w\fi0a@\u0003\u0002\t\r!Q\u0001B\u0004!\t\u00198\u0002C\u0004\u0002>y\u0001\r!!\t\t\u000f\u0005\u0005c\u00041\u0001\u0002D!9\u0011Q\f\u0010A\u0002\u0005\u0005\u0002bBA0=\u0001\u0007\u0011\u0011\r\u0005\b\u0003Or\u0002\u0019AA5\u0011\u001d\tyG\ba\u0001\u0003cBq!a\u001e\u001f\u0001\u0004\t\t\u0003C\u0004\u0002zy\u0001\r!a\u001f\t\u000f\u0005\u0015e\u00041\u0001\u0002\b\"9\u0011q\u0013\u0010A\u0002\u0005e\u0005bBA\u001c=\u0001\u0007\u0011Q\u0015\u0005\b\u0003_s\u0002\u0019AAY\u0011\u001d\tYL\ba\u0001\u0003{Cq!!3\u001f\u0001\u0004\tY\rC\u0004\u0002Rz\u0001\r!!\t\t\u000f\u0005Mg\u00041\u0001\u0002V\"9\u00111\u001c\u0010A\u0002\u0005u\u0017\u0001D\"p]:,7\r^5p]&#\u0007c\u0001B\u0007A5\t1B\u0001\u0007D_:tWm\u0019;j_:LEm\u0005\u0003!m\nM\u0001\u0003\u0002B\u000b\u00057i!Aa\u0006\u000b\t\te\u00111B\u0001\u0003S>LAA!\b\u0003\u0018\ta1+\u001a:jC2L'0\u00192mKR\u0011!1B\u0001\u000bMJ|Wn\u0015;sS:<G\u0003\u0002B\u0013\u0005S\u0004Ra\u001eB\u0014\u0005WI1A!\u000by\u0005\u0019y\u0005\u000f^5p]B\u0019!QB\u0013\u0014\r\u00152(q\u0006B\u001b!\r9(\u0011G\u0005\u0004\u0005gA(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0005o\u00119E\u0004\u0003\u0003:\t\rc\u0002\u0002B\u001e\u0005\u0003j!A!\u0010\u000b\u0007\t}R0\u0001\u0004=e>|GOP\u0005\u0002s&\u0019!Q\t=\u0002\u000fA\f7m[1hK&!!Q\u0004B%\u0015\r\u0011)\u0005_\u0001\nY>\u001c\u0017\r\u001c%pgR,\"Aa\u0014\u0011\t\tE#\u0011\f\b\u0005\u0005'\u0012)\u0006E\u0002\u0003<aL1Aa\u0016y\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011\u0003B.\u0015\r\u00119\u0006_\u0001\u000bY>\u001c\u0017\r\u001c%pgR\u0004\u0013!\u00037pG\u0006d\u0007k\u001c:u\u0003)awnY1m!>\u0014H\u000fI\u0001\u000be\u0016lw\u000e^3I_N$\u0018a\u0003:f[>$X\rS8ti\u0002\n!B]3n_R,\u0007k\u001c:u\u0003-\u0011X-\\8uKB{'\u000f\u001e\u0011\u0002\u000b%tG-\u001a=\u0002\r%tG-\u001a=!)1\u0011YC!\u001d\u0003t\tU$q\u000fB=\u0011\u001d\u0011Y\u0005\ra\u0001\u0005\u001fBqAa\u00181\u0001\u0004\t\t\u0003C\u0004\u0003dA\u0002\rAa\u0014\t\u000f\t\u001d\u0004\u00071\u0001\u0002\"!9!1\u000e\u0019A\u0002\u0005\u0005\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t=\u0013\u0001B2paf$BBa\u000b\u0003\u0004\n\u0015%q\u0011BE\u0005\u0017C\u0011Ba\u00133!\u0003\u0005\rAa\u0014\t\u0013\t}#\u0007%AA\u0002\u0005\u0005\u0002\"\u0003B2eA\u0005\t\u0019\u0001B(\u0011%\u00119G\rI\u0001\u0002\u0004\t\t\u0003C\u0005\u0003lI\u0002\n\u00111\u0001\u0002\"\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BIU\u0011\u0011yEa%,\u0005\tU\u0005\u0003\u0002BL\u0005Ck!A!'\u000b\t\tm%QT\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa(y\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005G\u0013IJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003**\"\u0011\u0011\u0005BJ\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!/\u0003@B\u0019qOa/\n\u0007\tu\u0006PA\u0002B]fD\u0011B!1;\u0003\u0003\u0005\r!!\t\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\r\u0005\u0004\u0003J\n='\u0011X\u0007\u0003\u0005\u0017T1A!4y\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005#\u0014YM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAk\u0005/D\u0011B!1=\u0003\u0003\u0005\rA!/\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\u0011i\u000eC\u0005\u0003Bv\n\t\u00111\u0001\u0002\"\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\"\u00051Q-];bYN$B!!6\u0003h\"I!\u0011Y \u0002\u0002\u0003\u0007!\u0011\u0018\u0005\b\u0005W\u0014\u0003\u0019\u0001B(\u0003\u0005\u0019\u0018!B1qa2LH\u0003\u0004B\u0016\u0005c\u0014\u0019P!>\u0003x\ne\bb\u0002B&G\u0001\u0007!q\n\u0005\b\u0005?\u001a\u0003\u0019AA\u0011\u0011\u001d\u0011\u0019g\ta\u0001\u0005\u001fBqAa\u001a$\u0001\u0004\t\t\u0003C\u0004\u0003l\r\u0002\r!!\t\u0002\u000fUt\u0017\r\u001d9msR!!q`B\u0004!\u00159(qEB\u0001!5981\u0001B(\u0003C\u0011y%!\t\u0002\"%\u00191Q\u0001=\u0003\rQ+\b\u000f\\36\u0011%\u0019I\u0001JA\u0001\u0002\u0004\u0011Y#A\u0002yIA\naB\\3x\u0007>tg.Z2uS>t7/\u0006\u0002\u0004\u0010A11\u0011CB\u000e\u0007?i!aa\u0005\u000b\t\rU1qC\u0001\u000bG>t7-\u001e:sK:$(\u0002BB\r\u0003\u0017\tA!\u001e;jY&!1QDB\n\u0005I\t%O]1z\u00052|7m[5oOF+X-^3\u0011\t\r\u000521F\u0007\u0003\u0007GQAa!\n\u0004(\u0005A1\r[1o]\u0016d7O\u0003\u0003\u0004*\u0005-\u0011a\u00018j_&!1QFB\u0012\u00055\u0019vnY6fi\u000eC\u0017M\u001c8fY\u0006ya.Z<D_:tWm\u0019;j_:\u001c\b%A\tj]\u001ad\u0017n\u001a5u%\u0016\u001c\bo\u001c8tKN,\"a!\u000e\u0011\u0011\r]2Q\bB(\u0007\u0003j!a!\u000f\u000b\t\rm\"1Z\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0019yd!\u000f\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0004D\r%cbA:\u0004F%\u00191q\t8\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!11JB'\u0005!\u0011Vm\u001d9p]N,'bAB$]\u0006\u0011\u0012N\u001c4mS\u001eDGOU3ta>t7/Z:!\u00035\u0011Xm\u001d9p]N,\u0017+^3vKV\u00111Q\u000b\t\u0007\u0007#\u00199f!\u0011\n\t\re31\u0003\u0002\u0014\u0019&t7.\u001a3CY>\u001c7.\u001b8h\t\u0016\fX/Z\u0001\u000fe\u0016\u001c\bo\u001c8tKF+X-^3!\u0003)iW\r\u001e:jGR\u000bwm]\u000b\u0003\u0007C\u0002\u0002ba\u0019\u0004f\u0005\r\u00111A\u0007\u0003\u0007/IAaa\u0010\u0004\u0018\u0005YQ.\u001a;sS\u000e$\u0016mZ:!\u0003u)\u0007\u0010]5sK\u0012\u001cuN\u001c8fGRLwN\\:LS2dW\rZ\"pk:$XCAB7!\u0011\u0019yg!\u001e\u000e\u0005\rE$\u0002BB:\u0003S\u000bQa\u001d;biNLAaa\u001e\u0004r\ti1)^7vY\u0006$\u0018N^3Tk6\fa$\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e\u001e\u0011\u0002O\u0015D\b/\u001b:fI\u000e{gN\\3di&|gn]&jY2,GmQ8v]RlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0007\u007f\u0002Ba!!\u0004\u00046\u0011\u00111J\u0005\u0005\u0007\u000b\u000bYE\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\f\u0001&\u001a=qSJ,GmQ8o]\u0016\u001cG/[8og.KG\u000e\\3e\u0007>,h\u000e^'fiJL7MT1nK\u0002\n\u0001b]3mK\u000e$xN]\u000b\u0003\u0007\u001b\u0003B!! \u0004\u0010&!1\u0011SA@\u0005!\u0019V\r\\3di>\u0014\u0018!C:fY\u0016\u001cGo\u001c:!\u00039\u0019'/Z1uKN+G.Z2u_J$Ba!$\u0004\u001a\"911\u0014(A\u0002\ru\u0015AD2iC:tW\r\u001c\"vS2$WM\u001d\t\u0005\u0003{\u001ay*\u0003\u0003\u0004\"\u0006}$AD\"iC:tW\r\u001c\"vS2$WM]\u0001\u0014]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r_\u0001\u0018]\u0016DHoQ8o]\u0016\u001cG/[8o\u0013:$W\r_0%KF$Ba!+\u00040B\u0019qoa+\n\u0007\r5\u0006P\u0001\u0003V]&$\b\"\u0003Ba!\u0006\u0005\t\u0019AA\u0011\u0003QqW\r\u001f;D_:tWm\u0019;j_:Le\u000eZ3yA\u0005\u0019!/\u001e8\u0015\u0005\r%\u0016\u0001\u00059s_\u000e,7o]#yG\u0016\u0004H/[8o)\u0019\u0019Ika/\u0004@\"91QX*A\u0002\t=\u0013\u0001D3se>\u0014X*Z:tC\u001e,\u0007bBBa'\u0002\u000711Y\u0001\ni\"\u0014xn^1cY\u0016\u0004BAa\u000e\u0004F&!1q\u0019B%\u0005%!\u0006N]8xC\ndW-A\fqe>\u001cWm]:DQ\u0006tg.\u001a7Fq\u000e,\u0007\u000f^5p]RA1\u0011VBg\u0007#\u001c\u0019\u000eC\u0004\u0004PR\u0003\rAa\u0014\u0002\u0013\rD\u0017M\u001c8fY&#\u0007bBB_)\u0002\u0007!q\n\u0005\b\u0007\u0003$\u0006\u0019ABb\u0003M\u0001(o\\2fgNtUm\u001e*fgB|gn]3t\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\u0019\u0019Ika7\u0004`\"91Q\u001c,A\u0002\r\u0005\u0013\u0001\u0003:fgB|gn]3\t\u000f\r\u0005h\u000b1\u0001\u0004d\u0006a!/Z:q_:\u001cXmU3oIB!\u0011QPBs\u0013\u0011\u00199/a \u0003\tM+g\u000eZ\u0001\u0005a>dG.\u0001\nqCJ\u001cXMU3rk\u0016\u001cH\u000fS3bI\u0016\u0014H\u0003BBx\u0007w\u0004Ba!=\u0004x6\u001111\u001f\u0006\u0005\u0007k\fY%\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019Ipa=\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\u0019i\u0010\u0017a\u0001\u0007\u007f\faAY;gM\u0016\u0014\b\u0003\u0002C\u0001\t\u0007i!aa\n\n\t\u0011\u00151q\u0005\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018\u0001\u00079s_\u000e,7o]\"p[BdW\r^3e%\u0016\u001cW-\u001b<fg\u0006)\u0002O]8dKN\u001c8i\\7qY\u0016$X\rZ*f]\u0012\u001c\u0018\u0001F;qI\u0006$XMU3rk\u0016\u001cH/T3ue&\u001c7\u000f\u0006\u0003\u0004*\u0012=\u0001bBBo7\u0002\u00071\u0011I\u0001\u0014aJ|7-Z:t\t&\u001c8m\u001c8oK\u000e$X\rZ\u0001\u0017G2|7/Z#yG\u0016\u001c8oQ8o]\u0016\u001cG/[8og\u0006)1\r\\8tKR!1\u0011\u0016C\r\u0011\u001d!YB\u0018a\u0001\u0005\u001f\nAbY8o]\u0016\u001cG/[8o\u0013\u0012\fa!Y2dKB$H\u0003CAk\tC!)\u0003\"\u000b\t\u000f\u0011\rr\f1\u0001\u0004 \u0005i1o\\2lKR\u001c\u0005.\u00198oK2Dq\u0001b\n`\u0001\u0004\t).\u0001\u0005nCf\u0014En\\2l\u0011\u001d!Yc\u0018a\u0001\t[\t\u0001$Y2dKB$xN]%eY\u0016\u0004VM]2f]RlU\r^3s!\u0011!y\u0003b\u0010\u000e\u0005\u0011E\"\u0002\u0002C\u001a\tk\tAaY8sK*!\u0011q\u0007C\u001c\u0015\u0011!I\u0004b\u000f\u0002\re\fW.\\3s\u0015\t!i$A\u0002d_6LA\u0001\"\u0011\u00052\t)Q*\u001a;fe\u000692m\u001c8gS\u001e,(/\u001a(fo\u000e{gN\\3di&|gn]\u0001\tG2|7/Z!mYR!!q\nC%\u0011\u001d!YE\u0019a\u0001\t\u001b\naa]8dW\u0016$\b\u0003\u0002C(\t+j!\u0001\"\u0015\u000b\t\u0011M\u00131B\u0001\u0004]\u0016$\u0018\u0002\u0002C,\t#\u0012aaU8dW\u0016$\u0018aD3ocV,W/\u001a*fgB|gn]3\u0015\t\r%FQ\f\u0005\b\u0007;\u001c\u0007\u0019AB!\u0003=!W-];fk\u0016\u0014Vm\u001d9p]N,GCAB!\u0003E\u0011Xm\u001d9p]N,\u0017+^3vKNK'0Z\u0001\u0016S:4G.[4iiJ+7\u000f]8og\u0016\u001cu.\u001e8u\u0003Qy\u0007/\u001a8Pe\u000ecwn]5oO\u000eC\u0017M\u001c8fYR!A1\u000eC:!\u00159(q\u0005C7!\u0011\ti\bb\u001c\n\t\u0011E\u0014q\u0010\u0002\r\u0017\u000647.Y\"iC:tW\r\u001c\u0005\b\t79\u0007\u0019\u0001B(\u0003YA\u0017M\u001c3mK\u000eC\u0017M\u001c8fY6+H/Z#wK:$HCBBU\ts\"Y\bC\u0004\u0005\u001c!\u0004\rAa\u0014\t\u000f\u0011u\u0004\u000e1\u0001\u0005\u0000\u0005)QM^3oiB!A\u0011\u0011CN\u001d\u0011!\u0019\tb&\u000f\t\u0011\u0015EQ\u0013\b\u0005\t\u000f#\u0019J\u0004\u0003\u0005\n\u0012Ee\u0002\u0002CF\t\u001fsAAa\u000f\u0005\u000e&\u0011\u0011qK\u0005\u0005\u0003'\n)&C\u0002r\u0003#JA!!\u0014\u0002P%\u0019q.a\u0013\n\t\u0011e\u0015qP\u0001\r\u0017\u000647.Y\"iC:tW\r\\\u0005\u0005\t;#yJ\u0001\tDQ\u0006tg.\u001a7NkR,WI^3oi*!A\u0011TA@\u0003A!(/_+o[V$Xm\u00115b]:,G\u000e\u0006\u0003\u0004*\u0012\u0015\u0006b\u0002C\u000eS\u0002\u0007!qJ\u0001\bG\"\fgN\\3m)\u0011!Y\u0007b+\t\u000f\u0011m!\u000e1\u0001\u0003P\u00051q/Y6fkB\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final boolean isPrivilegedListener;
    private final ApiVersionManager apiVersionManager;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    private Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (ControlThrowable)throwable;
        }
        this.error((Function0<String>)(Function0 & Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            this.selector().send(new NetworkSend(connectionId, responseSend));
            this.inflightResponses().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    public RequestHeader parseRequestHeader(ByteBuffer buffer) {
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        if (this.apiVersionManager.isApiEnabled(header.apiKey())) {
            return header;
        }
        throw new InvalidRequestException(new StringBuilder(46).append("Received request api key ").append(header.apiKey()).append(" which is not enabled").toString());
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = this.parseRequestHeader(receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, () -> Predef$.MODULE$.long2Long($this.time.nanoseconds()))) {
                            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation(), $this.isPrivilegedListener, channel.principalSerde());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics(), (Option<RequestChannel.Request>)None$.MODULE$);
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data().clientSoftwareName(), apiVersionsRequest.data().clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                RequestChannel.Response response = (RequestChannel.Response)this.inflightResponses().remove((Object)send.destinationId()).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send.destinationId()).append(" completed, but not in `inflightResponses`").toString());
                });
                this.updateRequestMetrics(response);
                response.onComplete().foreach((Function1 & Serializable)onComplete -> {
                    onComplete.apply((Object)send);
                    return BoxedUnit.UNIT;
                });
                this.handleChannelMuteEvent(send.destinationId(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destinationId());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destinationId(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destinationId()).toString(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                String remoteHost = ((ConnectionId)this.ConnectionId().fromString((String)connectionId).getOrElse((Function0 & Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append((String)connectionId).toString());
                })).remoteHost();
                this.inflightResponses().remove(connectionId).foreach((Function1 & Serializable)response -> {
                    this.updateRequestMetrics(response);
                    return BoxedUnit.UNIT;
                });
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                return;
            }
            catch (Throwable e) {
                this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append((String)connectionId).toString(), e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)channel -> {
            Processor.$anonfun$close$2(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(this.id()))}))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)Integer.toString(this.id()))}))));
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$new$3(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public final /* synthetic */ double kafka$network$Processor$$$anonfun$new$1() {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.metrics.metric(this.metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$3(m))));
    }

    public static final /* synthetic */ void $anonfun$close$2(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        $this.inflightResponses().remove((Object)connectionId$3).foreach((Function1 & Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize, boolean isPrivilegedListener, ApiVersionManager apiVersionManager) {
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        this.isPrivilegedListener = isPrivilegedListener;
        this.apiVersionManager = apiVersionManager;
        super(connectionQuotas);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))).asJava();
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public final double value() {
                return this.$outer.kafka$network$Processor$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time, (LogContext)logContext, () -> $this.apiVersionManager.apiVersionResponse(0)));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.localPort());
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.remotePort());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.index());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "localHost";
                }
                case 1: {
                    return "localPort";
                }
                case 2: {
                    return "remoteHost";
                }
                case 3: {
                    return "remotePort";
                }
                case 4: {
                    return "index";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.localHost())), (int)this.localPort()), (int)Statics.anyHash((Object)this.remoteHost())), (int)this.remotePort()), (int)this.index()), (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            if (this.localPort() != connectionId.localPort()) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

