/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005g!\u00024h\u0003\u0003a\u0007\"B:\u0001\t\u0003!\bbB<\u0001\u0005\u0004%\t\u0001\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011B=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!I\u00111\u0002\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011\u0011\u0005\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u0011q\u0005\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002*!I\u0011\u0011\t\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002\u0006!I\u0011Q\t\u0001C\u0002\u0013\u0005\u0011q\u0005\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002*!I\u0011\u0011\n\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002\u0010!I\u0011Q\n\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002\u0010!I\u0011\u0011\u000b\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002\u0010!I\u0011Q\u000b\u0001C\u0002\u0013\u0005\u0011q\u000b\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002Z!9\u0011\u0011\r\u0001\u0005R\u0005\r\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0004\u0007\u0003'\u0003\u0001\"!&\t\rMLB\u0011AAW\u0011%\t\u0019,\u0007a\u0001\n\u0003\t\u0019\u0001C\u0005\u00026f\u0001\r\u0011\"\u0001\u00028\"A\u0011QX\r!B\u0013\t)\u0001C\u0005\u0002@f\u0001\r\u0011\"\u0001\u0002\u0004!I\u0011\u0011Y\rA\u0002\u0013\u0005\u00111\u0019\u0005\t\u0003\u000fL\u0002\u0015)\u0003\u0002\u0006!9\u0011\u0011Z\r\u0005\u0002\u0005-\u0007bBAl3\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003;\u0004A\u0011CAp\u0011\u001d\u0011Y\u0001\u0001C\t\u0005\u001bA\u0011Ba\u0010\u0001#\u0003%\tB!\u0011\t\u000f\t]\u0003\u0001\"\u0005\u0003Z!I!Q\u0011\u0001\u0012\u0002\u0013E!q\u0011\u0005\n\u0005\u0017\u0003\u0011\u0013!C\t\u0005\u0003B\u0011B!$\u0001#\u0003%\tBa$\t\u0013\tM\u0005!%A\u0005\u0012\tU\u0005\"\u0003BM\u0001E\u0005I\u0011\u0003BD\u0011\u001d\u0011Y\n\u0001C\t\u0005;C\u0011Ba7\u0001#\u0003%\tB!8\t\u000f\t\r\b\u0001\"\u0005\u0003f\"9!1 \u0001\u0005\u0012\tu\b\"CB\u0012\u0001E\u0005I\u0011CB\u0013\u0011\u001d\u0019y\u0003\u0001C\u0001\u0007cA\u0011b!=\u0001#\u0003%\taa=\t\u000f\r]\b\u0001\"\u0001\u0004z\"IAq\u0001\u0001\u0012\u0002\u0013\u000511\u001f\u0005\b\t\u0013\u0001A\u0011\u0001C\u0006\u0011%!\t\u0003AI\u0001\n\u0003!\u0019\u0003C\u0005\u0005(\u0001\t\n\u0011\"\u0001\u0003B!IA\u0011\u0006\u0001\u0012\u0002\u0013\u0005A1\u0006\u0005\b\t_\u0001A\u0011\u0001C\u0019\u0011%!I\u0004AI\u0001\n\u0003!Y\u0004C\u0004\u0005@\u0001!\t\u0002\"\u0011\t\u000f\u0011]\u0003\u0001\"\u0005\u0005Z\u00191Aq\u000e\u0001\t\tcBaa]\u001f\u0005\u0002\u0011e\u0004\"\u0003C?{\u0001\u0007I\u0011AA\u0002\u0011%!y(\u0010a\u0001\n\u0003!\t\t\u0003\u0005\u0005\u0006v\u0002\u000b\u0015BA\u0003\u0011%!9)\u0010a\u0001\n\u0003\t\u0019\u0001C\u0005\u0005\nv\u0002\r\u0011\"\u0001\u0005\f\"AAqR\u001f!B\u0013\t)\u0001C\u0005\u0005\u0012v\u0002\r\u0011\"\u0001\u0005\u0014\"IAQT\u001fA\u0002\u0013\u0005Aq\u0014\u0005\t\tGk\u0004\u0015)\u0003\u0005\u0016\"9AQU\u001f\u0005B\u0011\u001dfABB\"\u0001!\u0019)\u0005\u0003\u0006\u0002$&\u0013\t\u0011)A\u0005\u0005;B!ba\u0015J\u0005\u0003\u0005\u000b\u0011BB+\u0011)\u0019Y&\u0013B\u0001B\u0003%!q\u001d\u0005\u0007g&#\ta!\u0018\t\rMLE\u0011AB3\u0011\u0019\u0019\u0018\n\"\u0001\u0004l!I1\u0011O%A\u0002\u0013\u000511\u000f\u0005\n\u0007{J\u0005\u0019!C\u0001\u0007\u007fB\u0001ba!JA\u0003&1Q\u000f\u0005\n\u0007\u001bK\u0005\u0019!C\u0001\u0003\u0007A\u0011ba$J\u0001\u0004%\ta!%\t\u0011\rU\u0015\n)Q\u0005\u0003\u000bA\u0011b!'J\u0005\u0004%Iaa'\t\u0011\r\u0005\u0016\n)A\u0005\u0007;C\u0011ba)J\u0001\u0004%Ia!*\t\u0013\r5\u0016\n1A\u0005\n\r=\u0006\u0002CBZ\u0013\u0002\u0006Kaa*\t\u0013\r]\u0016\n1A\u0005\n\re\u0006\"CB^\u0013\u0002\u0007I\u0011BB_\u0011!\u0019\t-\u0013Q!\n\rU\u0003\"CBb\u0013\n\u0007I\u0011ABc\u0011!\u00199-\u0013Q\u0001\n\u0005u\u0005bBBe\u0013\u0012\u000511\u001a\u0005\b\u0007\u001bLE\u0011ABh\u0011\u001d\u0019).\u0013C\u0001\u0007KCqaa6J\t\u0003\u001aI\u000eC\u0004\u0004\\&#\t%! \t\u000f\u0011U\u0006\u0001\"\u0001\u00058\n!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgRT!\u0001[5\u0002\u0007\u0005\u0004\u0018NC\u0001k\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A7\u0011\u00059\fX\"A8\u000b\u0005AL\u0017AB:feZ,'/\u0003\u0002s_\ny!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002kB\u0011a\u000fA\u0007\u0002O\u00069Q\r]:jY>tW#A=\u0011\u0005ilX\"A>\u000b\u0003q\fQa]2bY\u0006L!A`>\u0003\r\u0011{WO\u00197f\u0003!)\u0007o]5m_:\u0004\u0013a\u00032s_.,'oQ8v]R,\"!!\u0002\u0011\u0007i\f9!C\u0002\u0002\nm\u00141!\u00138u\u0003\u0015!x\u000e]5d+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\t1\fgn\u001a\u0006\u0003\u00033\tAA[1wC&!\u0011QDA\n\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0001]1si\u0006)\u0001/\u0019:uA\u0005\u0011A\u000f]\u000b\u0003\u0003S\u0001B!a\u000b\u0002<5\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0004d_6lwN\u001c\u0006\u0004U\u0006M\"\u0002BA\u001b\u0003o\ta!\u00199bG\",'BAA\u001d\u0003\ry'oZ\u0005\u0005\u0003{\tiC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%A\u0003qCJ$('\u0001\u0004qCJ$(\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\nQa\u001a:pkB\faa\u001a:pkB\u0004\u0013\u0001\u00059s_\u0012,8-\u001a:DY&,g\u000e^%e\u0003E\u0001(o\u001c3vG\u0016\u00148\t\\5f]RLE\rI\u0001\u0011G>t7/^7fe\u000ec\u0017.\u001a8u\u0013\u0012\f\u0011cY8ogVlWM]\"mS\u0016tG/\u00133!\u0003a9'o\\;q\u001b\u0006D8+Z:tS>tG+[7f_V$Xj]\u000b\u0003\u00033\u00022A_A.\u0013\r\tif\u001f\u0002\u0005\u0019>tw-A\rhe>,\b/T1y'\u0016\u001c8/[8o)&lWm\\;u\u001bN\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\u0011\t)'a\u001b\u0011\u0007i\f9'C\u0002\u0002jm\u0014A!\u00168ji\"9\u0011QN\fA\u0002\u0005=\u0014A\u00039s_B,'\u000f^5fgB!\u0011\u0011OA<\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0011\u0001B;uS2LA!!\u001f\u0002t\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u000bM,G/\u00169\u0015\u0005\u0005\u0015\u0004f\u0001\r\u0002\u0002B!\u00111QAH\u001b\t\t)IC\u0002i\u0003\u000fSA!!#\u0002\f\u00069!.\u001e9ji\u0016\u0014(\u0002BAG\u0003o\tQA[;oSRLA!!%\u0002\u0006\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0003AQ+7\u000f^\"p]N,X.\u001a:SK\u0006\u001c8/[4o[\u0016tG\u000fT5ti\u0016tWM]\n\u00063\u0005]\u0015Q\u0014\t\u0005\u0003#\tI*\u0003\u0003\u0002\u001c\u0006M!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002 \u0006%VBAAQ\u0015\u0011\t\u0019+!*\u0002\u0011\r|gn];nKJTA!a*\u00022\u000591\r\\5f]R\u001c\u0018\u0002BAV\u0003C\u0013\u0011dQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feR\u0011\u0011q\u0016\t\u0004\u0003cKR\"\u0001\u0001\u0002\u001f\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012\f1cY1mYN$v.Q:tS\u001etW\rZ0%KF$B!!\u001a\u0002:\"I\u00111\u0018\u000f\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0014\u0001E2bY2\u001cHk\\!tg&<g.\u001a3!\u00039\u0019\u0017\r\u001c7t)>\u0014VM^8lK\u0012\f!cY1mYN$vNU3w_.,Gm\u0018\u0013fcR!\u0011QMAc\u0011%\tYlHA\u0001\u0002\u0004\t)!A\bdC2d7\u000fV8SKZ|7.\u001a3!\u0003Qyg\u000eU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR!\u0011QMAg\u0011\u001d\ty-\ta\u0001\u0003#\f!\u0002]1si&$\u0018n\u001c8t!\u0019\t\t(a5\u0002*%!\u0011Q[A:\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u0014_:\u0004\u0016M\u001d;ji&|gn\u001d*fm>\\W\r\u001a\u000b\u0005\u0003K\nY\u000eC\u0004\u0002P\n\u0002\r!!5\u00023\r\u0014X-\u0019;f\u0007>t7/^7fe^KG\u000f[$s_V\u0004\u0018\n\u001a\u000b\u0005\u0003C\f\u0019\u0010\u0005\u0005\u0002 \u0006\r\u0018q]At\u0013\u0011\t)/!)\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0015Q\u0018\u0011^Aw\u0013\r\tYo\u001f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004u\u0006=\u0018bAAyw\n!!)\u001f;f\u0011\u001d\t)p\ta\u0001\u0003o\fqa\u001a:pkBLE\r\u0005\u0003\u0002z\n\u001da\u0002BA~\u0005\u0007\u00012!!@|\u001b\t\tyPC\u0002\u0003\u0002-\fa\u0001\u0010:p_Rt\u0014b\u0001B\u0003w\u00061\u0001K]3eK\u001aLA!!\b\u0003\n)\u0019!QA>\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u000b\u0005\u001f\u0011iC!\u000e\u0003:\tm\u0002C\u0002B\t\u00057\u0011\tC\u0004\u0003\u0003\u0014\t]a\u0002BA\u007f\u0005+I\u0011\u0001`\u0005\u0004\u00053Y\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005;\u0011yBA\u0002TKFT1A!\u0007|!!\u0011\u0019C!\u000b\u0002h\u0006\u001dXB\u0001B\u0013\u0015\u0011\u00119#!*\u0002\u0011A\u0014x\u000eZ;dKJLAAa\u000b\u0003&\tq\u0001K]8ek\u000e,'OU3d_J$\u0007b\u0002B\u0014I\u0001\u0007!q\u0006\t\t\u0005G\u0011\t$a:\u0002h&!!1\u0007B\u0013\u00055Y\u0015MZ6b!J|G-^2fe\"9!q\u0007\u0013A\u0002\u0005\u0015\u0011A\u00038v[J+7m\u001c:eg\"9\u0011Q\u0005\u0013A\u0002\u0005%\u0002\"\u0003B\u001fIA\u0005\t\u0019AA-\u0003E\u0019H/\u0019:uS:<G+[7fgR\fW\u000e]\u0001\u0016g\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019E\u000b\u0003\u0002Z\t\u00153F\u0001B$!\u0011\u0011IEa\u0015\u000e\u0005\t-#\u0002\u0002B'\u0005\u001f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tE30\u0001\u0006b]:|G/\u0019;j_:LAA!\u0016\u0003L\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cHCEA3\u00057\u0012\u0019G!\u001a\u0003j\t5$q\u000eB@\u0005\u0003Cq!a)'\u0001\u0004\u0011i\u0006\u0005\u0005\u0002 \n}\u0013q]At\u0013\u0011\u0011\t'!)\u0003\u0011\r{gn];nKJDqAa\u000e'\u0001\u0004\t)\u0001C\u0004\u0003h\u0019\u0002\r!!\u0002\u0002\u001dM$\u0018M\u001d;j]\u001e|eMZ:fi\"I!1\u000e\u0014\u0011\u0002\u0003\u0007\u0011QA\u0001\u0019gR\f'\u000f^5oO.+\u00170\u00118e-\u0006dW/Z%oI\u0016D\b\"\u0003B\u001fMA\u0005\t\u0019AA-\u0011%\u0011\tH\nI\u0001\u0002\u0004\u0011\u0019(A\u0007uS6,7\u000f^1naRK\b/\u001a\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)!!\u0011PA\u0017\u0003\u0019\u0011XmY8sI&!!Q\u0010B<\u00055!\u0016.\\3ti\u0006l\u0007\u000fV=qK\"I\u0011Q\u0005\u0014\u0011\u0002\u0003\u0007\u0011\u0011\u0006\u0005\n\u0005\u00073\u0003\u0013!a\u0001\u0003\u000b\ta\"\\1y!>dGNU3d_J$7/A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\n*\"\u0011Q\u0001B#\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\tJ\u000b\u0003\u0003t\t\u0015\u0013!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012:TC\u0001BLU\u0011\tIC!\u0012\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001d\u0002\u001d\r|gn];nKJ+7m\u001c:egV1!q\u0014B^\u0005\u001f$\u0002B!)\u0003T\n]'\u0011\u001c\t\u0007\u0005G\u0013iK!-\u000e\u0005\t\u0015&\u0002\u0002BT\u0005S\u000bq!\\;uC\ndWMC\u0002\u0003,n\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yK!*\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\t\u0003?\u0013\u0019La.\u0003N&!!QWAQ\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004BA!/\u0003<2\u0001Aa\u0002B_Y\t\u0007!q\u0018\u0002\u0002\u0017F!!\u0011\u0019Bd!\rQ(1Y\u0005\u0004\u0005\u000b\\(a\u0002(pi\"Lgn\u001a\t\u0004u\n%\u0017b\u0001Bfw\n\u0019\u0011I\\=\u0011\t\te&q\u001a\u0003\b\u0005#d#\u0019\u0001B`\u0005\u00051\u0006bBARY\u0001\u0007!Q\u001b\t\t\u0003?\u0013yFa.\u0003N\"9!q\u0007\u0017A\u0002\u0005\u0015\u0001\"\u0003BBYA\u0005\t\u0019AA\u0003\u0003a\u0019wN\\:v[\u0016\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0007\u0005\u000f\u0013yN!9\u0005\u000f\tuVF1\u0001\u0003@\u00129!\u0011[\u0017C\u0002\t}\u0016!G2sK\u0006$X\rV8qS\u000e\fe\u000eZ*f]\u0012\u0014VmY8sIN$\"Ba:\u0003n\n=(1\u001fB|!\u0019\tIP!;\u0002*%!!1\u001eB\u0005\u0005\r\u0019V\r\u001e\u0005\b\u0005Oq\u0003\u0019\u0001B\u0018\u0011\u001d\u0011\tP\fa\u0001\u0003o\f\u0011\u0002^8qS\u000et\u0015-\\3\t\u000f\tUh\u00061\u0001\u0002\u0006\u0005ia.^7QCJ$\u0018\u000e^5p]NDqA!?/\u0001\u0004\t)!A\nsK\u000e|'\u000fZ:QKJ\u0004\u0016M\u001d;ji&|g.A\ftK:$\u0017I\u001c3Bo\u0006LG/Q:z]\u000e\u001cu.\\7jiV1!q`B\u0004\u0007\u0017!b!!\u001a\u0004\u0002\r5\u0001bBAR_\u0001\u000711\u0001\t\t\u0003?\u0013yf!\u0002\u0004\nA!!\u0011XB\u0004\t\u001d\u0011il\fb\u0001\u0005\u007f\u0003BA!/\u0004\f\u00119!\u0011[\u0018C\u0002\t}\u0006\"CB\b_A\u0005\t\u0019AB\t\u0003)ygMZ:fiN|\u0005\u000f\u001e\t\u0006u\u000eM1qC\u0005\u0004\u0007+Y(AB(qi&|g\u000e\u0005\u0005\u0002z\u000ee\u0011\u0011FB\u000f\u0013\u0011\u0019YB!\u0003\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002 \u000e}\u0011\u0002BB\u0011\u0003C\u0013\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0003\u0005\u001aXM\u001c3B]\u0012\fu/Y5u\u0003NLhnY\"p[6LG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0019\u00199ca\u000b\u0004.U\u00111\u0011\u0006\u0016\u0005\u0007#\u0011)\u0005B\u0004\u0003>B\u0012\rAa0\u0005\u000f\tE\u0007G1\u0001\u0003@\u0006a\u0013\r\u001a3D_:\u001cX/\\3sgR{wI]8va\u0006sGmV1ji\u001a{'o\u0012:pkB\f5o]5h]6,g\u000e\u001e\u000b\u000f\u0007g\u0019in!9\u0004f\u000e%81^Bx!\u001dQ8QGB\u001d\u0007\u007fI1aa\u000e|\u0005\u0019!V\u000f\u001d7feA1!1UB\u001e\u0003CLAa!\u0010\u0003&\n1!)\u001e4gKJ\u0004bAa)\u0004<\r\u0005\u0003cAAY\u0013\nA2i\u001c8tk6,'/Q:tS\u001etW.\u001a8u!>dG.\u001a:\u0014\u0007%\u001b9\u0005\u0005\u0003\u0004J\r=SBAB&\u0015\r\u0019i%[\u0001\u0006kRLGn]\u0005\u0005\u0007#\u001aYE\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017!\u0005;pa&\u001c7\u000fV8Tk\n\u001c8M]5cKB1!\u0011CB,\u0003oLAa!\u0017\u0003 \t!A*[:u\u0003I\u0001\u0018M\u001d;ji&|gn\u001d+p\u0003N\u001c\u0018n\u001a8\u0015\u0011\r\u00053qLB1\u0007GBq!a)N\u0001\u0004\u0011i\u0006C\u0004\u0004T5\u0003\ra!\u0016\t\u000f\rmS\n1\u0001\u0003hR11\u0011IB4\u0007SBq!a)O\u0001\u0004\u0011i\u0006C\u0004\u0004T9\u0003\ra!\u0016\u0015\r\r\u00053QNB8\u0011\u001d\t\u0019k\u0014a\u0001\u0005;Bqaa\u0017P\u0001\u0004\u00119/A\buQJ|wO\\#yG\u0016\u0004H/[8o+\t\u0019)\bE\u0003{\u0007'\u00199\b\u0005\u0003\u0003\u0012\re\u0014\u0002BB>\u0005?\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0002'QD'o\\<o\u000bb\u001cW\r\u001d;j_:|F%Z9\u0015\t\u0005\u00154\u0011\u0011\u0005\n\u0003w\u000b\u0016\u0011!a\u0001\u0007k\n\u0001\u0003\u001e5s_^tW\t_2faRLwN\u001c\u0011)\u0007I\u001b9\tE\u0002{\u0007\u0013K1aa#|\u0005!1x\u000e\\1uS2,\u0017\u0001\u0005:fG\u0016Lg/\u001a3NKN\u001c\u0018mZ3t\u0003Q\u0011XmY3jm\u0016$W*Z:tC\u001e,7o\u0018\u0013fcR!\u0011QMBJ\u0011%\tY\fVA\u0001\u0002\u0004\t)!A\tsK\u000e,\u0017N^3e\u001b\u0016\u001c8/Y4fg\u0002B3!VBD\u0003M\u0001\u0018M\u001d;ji&|g.Q:tS\u001etW.\u001a8u+\t\u0019i\n\u0005\u0004\u0003$\u000e}\u0015\u0011F\u0005\u0005\u0005W\u0014)+\u0001\u000bqCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000fI\u0001\u0014gV\u00147o\u0019:jaRLwN\\\"iC:<W\rZ\u000b\u0003\u0007O\u00032A_BU\u0013\r\u0019Yk\u001f\u0002\b\u0005>|G.Z1o\u0003]\u0019XOY:de&\u0004H/[8o\u0007\"\fgnZ3e?\u0012*\u0017\u000f\u0006\u0003\u0002f\rE\u0006\"CA^3\u0006\u0005\t\u0019ABT\u0003Q\u0019XOY:de&\u0004H/[8o\u0007\"\fgnZ3eA!\u001a!la\"\u0002%Q|\u0007/[2t'V\u00147o\u0019:jaRLwN\\\u000b\u0003\u0007+\na\u0003^8qS\u000e\u001c8+\u001e2tGJL\u0007\u000f^5p]~#S-\u001d\u000b\u0005\u0003K\u001ay\fC\u0005\u0002<r\u000b\t\u00111\u0001\u0004V\u0005\u0019Bo\u001c9jGN\u001cVOY:de&\u0004H/[8oA\u0005\t\"/\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\u0016\u0005\u0005u\u0015A\u0005:fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8fe\u0002\n!cY8ogVlWM]!tg&<g.\\3oiR\u0011!q]\u0001\ngV\u00147o\u0019:jE\u0016$B!!\u001a\u0004R\"911[1A\u0002\rU\u0013\u0001\u00068foR{\u0007/[2t)>\u001cVOY:de&\u0014W-A\u000ejgN+(m]2sS\n,'+Z9vKN$\bK]8dKN\u001cX\rZ\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"aa*\u0002\r\u0011|wk\u001c:l\u0011\u001d\u0019y.\ra\u0001\u0003\u000b\t1C\\;n\u001f\u001a\u001cuN\\:v[\u0016\u00148\u000fV8BI\u0012Dqaa92\u0001\u0004\u0019I$A\u0007d_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u0005\b\u0007O\f\u0004\u0019AB \u0003=\u0019wN\\:v[\u0016\u0014\bk\u001c7mKJ\u001c\bbBB*c\u0001\u00071Q\u000b\u0005\b\u0007[\f\u0004\u0019\u0001Bt\u00035\u0019XOY:de&\u0004H/[8og\"I\u0011\u0011J\u0019\u0011\u0002\u0003\u0007\u0011q_\u00017C\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f]!oI^\u000b\u0017\u000e\u001e$pe\u001e\u0013x.\u001e9BgNLwM\\7f]R$C-\u001a4bk2$HEN\u000b\u0003\u0007kTC!a>\u0003F\u0005\u0019\u0012\r\u001a3D_:\u001cX/\\3sgR{wI]8vaRq11GB~\u0007{\u001cy\u0010\"\u0001\u0005\u0004\u0011\u0015\u0001bBBpg\u0001\u0007\u0011Q\u0001\u0005\b\u0007G\u001c\u0004\u0019AB\u001d\u0011\u001d\u00199o\ra\u0001\u0007\u007fAqaa\u00154\u0001\u0004\u0019)\u0006C\u0004\u0004nN\u0002\rAa:\t\u0013\u0005%3\u0007%AA\u0002\u0005]\u0018!H1eI\u000e{gn];nKJ\u001cHk\\$s_V\u0004H\u0005Z3gCVdG\u000f\n\u001c\u0002/Y\fG.\u001b3bi\u0016<%o\\;q\u0003N\u001c\u0018n\u001a8nK:$H\u0003DA3\t\u001b!y\u0001\"\u0005\u0005\u0018\u0011m\u0001bBBtk\u0001\u00071q\b\u0005\b\u0007[,\u0004\u0019\u0001Bt\u0011%!\u0019\"\u000eI\u0001\u0002\u0004!)\"A\u0002ng\u001e\u0004RA_B\n\u0003oD\u0011\u0002\"\u00076!\u0003\u0005\r!!\u0017\u0002\u0011]\f\u0017\u000e\u001e+j[\u0016D\u0011\u0002\"\b6!\u0003\u0005\r\u0001b\b\u0002%\u0015D\b/Z2uK\u0012\f5o]5h]6,g\u000e\u001e\t\u0007\u0005G\u001bYDa:\u0002CY\fG.\u001b3bi\u0016<%o\\;q\u0003N\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0011\u0015\"\u0006\u0002C\u000b\u0005\u000b\n\u0011E^1mS\u0012\fG/Z$s_V\u0004\u0018i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIQ\n\u0011E^1mS\u0012\fG/Z$s_V\u0004\u0018i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIU*\"\u0001\"\f+\t\u0011}!QI\u0001!gV\u00147o\u0019:jE\u0016\u001cuN\\:v[\u0016\u0014\u0018I\u001c3Ti\u0006\u0014H\u000fU8mY&tw\r\u0006\u0005\u0004B\u0011MBQ\u0007C\u001c\u0011\u001d\t\u0019+\u000fa\u0001\u0005;Bqaa\u0015:\u0001\u0004\u0019)\u0006C\u0005\u0004\\e\u0002\n\u00111\u0001\u0003h\u0006Q3/\u001e2tGJL'-Z\"p]N,X.\u001a:B]\u0012\u001cF/\u0019:u!>dG.\u001b8hI\u0011,g-Y;mi\u0012\u001aTC\u0001C\u001fU\u0011\u00119O!\u0012\u0002\u001d\u0005<\u0018-\u001b;SK\n\fG.\u00198dKR1\u0011Q\rC\"\t+Bq!a)<\u0001\u0004!)\u0005\r\u0004\u0005H\u0011-C\u0011\u000b\t\t\u0003?\u0013y\u0006\"\u0013\u0005PA!!\u0011\u0018C&\t1!i\u0005b\u0011\u0002\u0002\u0003\u0005)\u0011\u0001B`\u0005\ryF%\r\t\u0005\u0005s#\t\u0006\u0002\u0007\u0005T\u0011\r\u0013\u0011!A\u0001\u0006\u0003\u0011yLA\u0002`IIBqaa1<\u0001\u0004\ty+A\tf]N,(/\u001a(p%\u0016\u0014\u0017\r\\1oG\u0016$b!!\u001a\u0005\\\u00115\u0004bBARy\u0001\u0007AQ\f\u0019\u0007\t?\"\u0019\u0007\"\u001b\u0011\u0011\u0005}%q\fC1\tO\u0002BA!/\u0005d\u0011aAQ\rC.\u0003\u0003\u0005\tQ!\u0001\u0003@\n\u0019q\fJ\u001a\u0011\t\teF\u0011\u000e\u0003\r\tW\"Y&!A\u0001\u0002\u000b\u0005!q\u0018\u0002\u0004?\u0012\"\u0004bBBby\u0001\u0007\u0011q\u0016\u0002\u001c\u0007>,h\u000e^\"p]N,X.\u001a:D_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0014\u000bu\n9\nb\u001d\u0011\t\u0005}EQO\u0005\u0005\to\n\tK\u0001\u000bPM\u001a\u001cX\r^\"p[6LGoQ1mY\n\f7m\u001b\u000b\u0003\tw\u00022!!->\u00031\u0019XoY2fgN\u001cu.\u001e8u\u0003A\u0019XoY2fgN\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002f\u0011\r\u0005\"CA^\u0001\u0006\u0005\t\u0019AA\u0003\u00035\u0019XoY2fgN\u001cu.\u001e8uA\u0005Ia-Y5m\u0007>,h\u000e^\u0001\u000eM\u0006LGnQ8v]R|F%Z9\u0015\t\u0005\u0015DQ\u0012\u0005\n\u0003w\u001b\u0015\u0011!a\u0001\u0003\u000b\t!BZ1jY\u000e{WO\u001c;!\u0003%a\u0017m\u001d;FeJ|'/\u0006\u0002\u0005\u0016B)!pa\u0005\u0005\u0018B!!\u0011\u0003CM\u0013\u0011!YJa\b\u0003\u0013\u0015C8-\u001a9uS>t\u0017!\u00047bgR,%O]8s?\u0012*\u0017\u000f\u0006\u0003\u0002f\u0011\u0005\u0006\"CA^\r\u0006\u0005\t\u0019\u0001CK\u0003)a\u0017m\u001d;FeJ|'\u000fI\u0001\u000b_:\u001cu.\u001c9mKR,GCBA3\tS#\t\fC\u0004\u0005,\"\u0003\r\u0001\",\u0002\u000f=4gm]3ugBA\u0011\u0011\u000fCX\u0003S\u0019i\"\u0003\u0003\u0004\u001c\u0005M\u0004b\u0002CZ\u0011\u0002\u0007AqS\u0001\nKb\u001cW\r\u001d;j_:\f!$[:QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tGOV1mS\u0012$\u0002ba*\u0005:\u0012uFq\u0018\u0005\b\tw+\u0007\u0019\u0001C\u0010\u0003-\t7o]5h]6,g\u000e^:\t\u000f\u0005=W\r1\u0001\u0003h\"9AQD3A\u0002\u0011}\u0001")
public abstract class AbstractConsumerTest
extends BaseRequestTest {
    private final double epsilon;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String group;
    private final String producerClientId;
    private final String consumerClientId;
    private final long groupMaxSessionTimeoutMs;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String group() {
        return this.group;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public long groupMaxSessionTimeoutMs() {
        return this.groupMaxSessionTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), Long.toString(this.groupMaxSessionTimeoutMs()));
        properties.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
    }

    public KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        Properties groupOverrideConfig = new Properties();
        groupOverrideConfig.setProperty("group.id", groupId);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        return this.createConsumer(x$2, x$3, groupOverrideConfig, x$4);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp, long startingTimestamp) {
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> AbstractConsumerTest.$anonfun$sendRecords$1(startingTimestamp, tp, producer, BoxesRunTime.unboxToInt((Object)i)));
        producer.flush();
        return records;
    }

    public long sendRecords$default$4() {
        return System.currentTimeMillis();
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assertions.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assertions.assertEquals((int)tp.partition(), (int)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertEquals((Object)timestampType, (Object)record.timestampType());
                Assertions.assertEquals((long)(startingTimestamp + (long)i), (long)record.timestamp());
            } else {
                Assertions.assertTrue((record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0, (String)new StringBuilder(60).append("Got unexpected timestamp ").append(record.timestamp()).append(". Timestamp should be between [").append(startingTimestamp).append(", ").append(now).append("}]").toString());
            }
            Assertions.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((int)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString().length(), (int)record.serializedKeySize());
            Assertions.assertEquals((int)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString().length(), (int)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        long pollRecordsUntilTrue_waitTimeMs = 60000L;
        long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractConsumerTest.pollAction$1(consumer.poll(Duration.ofMillis(100L)), maxPollRecords, records, numRecords)) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + pollRecordsUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$consumeRecords$2(numRecords, records));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollRecordsUntilTrue_waitTimeMs), pollRecordsUntilTrue_waitUntilTrue_pause));
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(KafkaProducer<byte[], byte[]> producer, String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.brokerCount(), this.createTopic$default$4());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> {
            TopicPartition tp = new TopicPartition(topicName, partition);
            this.sendRecords(producer, recordsPerPartition, tp, this.sendRecords$default$4());
            parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)parts$1.elem).$plus((Object)tp);
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        public class Kafka_api_AbstractConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final Option offsetsOpt$1;
            private final Consumer consumer$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (exception instanceof RetriableCommitFailedException) {
                    AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(this, this.offsetsOpt$1, this.consumer$1);
                    return;
                }
                this.isComplete_$eq(true);
                this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception));
            }

            public Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(AbstractConsumerTest $outer, Option offsetsOpt$1, Consumer consumer$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.consumer$1 = consumer$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_AbstractConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(this, offsetsOpt, consumer);
        AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(commitCallback, offsetsOpt, consumer);
        long pollUntilTrue_waitTimeMs = 10000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (commitCallback.isComplete()) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Failed to observe commit callback before timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(pollUntilTrue_waitTimeMs), pollUntilTrue_waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        Assertions.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        this.addConsumersToGroup(numOfConsumersToAdd, consumerGroup, consumerPollers, topicsToSubscribe, subscriptions, group);
        this.validateGroupAssignment(consumerPollers, subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroup(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1 & Serializable)x$1 -> AbstractConsumerTest.$anonfun$addConsumersToGroup$1(this, group, consumerGroup, consumerPollers, topicsToSubscribe, BoxesRunTime.unboxToInt((Object)x$1)));
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public String addConsumersToGroupAndWaitForGroupAssignment$default$6() {
        return this.group();
    }

    public String addConsumersToGroup$default$6() {
        return this.group();
    }

    public void validateGroupAssignment(Buffer<ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, Option<String> msg, long waitTime, Buffer<scala.collection.immutable.Set<TopicPartition>> expectedAssignment) {
        Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        long l = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractConsumerTest.$anonfun$validateGroupAssignment$1(this, assignments, consumerPollers, subscriptions, expectedAssignment)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTime) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$validateGroupAssignment$3(msg, subscriptions, assignments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), l));
        }
    }

    public Option<String> validateGroupAssignment$default$3() {
        return None$.MODULE$;
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public Buffer<scala.collection.immutable.Set<TopicPartition>> validateGroupAssignment$default$5() {
        return (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        ConsumerAssignmentPoller consumerPoller = topicsToSubscribe.nonEmpty() ? new ConsumerAssignmentPoller(this, consumer, topicsToSubscribe) : new ConsumerAssignmentPoller(this, consumer, partitionsToAssign);
        consumerPoller.start();
        return consumerPoller;
    }

    public scala.collection.immutable.Set<TopicPartition> subscribeConsumerAndStartPolling$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int numReassignments = rebalanceListener.callsToAssigned();
        long l = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (AbstractConsumerTest.$anonfun$awaitRebalance$1(rebalanceListener, numReassignments)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out before expected rebalance completed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), pollUntilTrue_waitUntilTrue_pause));
        }
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assertions.assertEquals((int)initialRevokeCalls, (int)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<scala.collection.immutable.Set<TopicPartition>> assignments, scala.collection.immutable.Set<TopicPartition> partitions, Buffer<scala.collection.immutable.Set<TopicPartition>> expectedAssignment) {
        Object object = new Object();
        try {
            if (!assignments.forall((Function1 & Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()))) {
                return false;
            }
            if (BoxesRunTime.unboxToInt((Object)assignments.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToInteger((int)AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$2(BoxesRunTime.unboxToInt((Object)x$3), x$4)))) != partitions.size()) {
                return false;
            }
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)assignments.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x$5, x$6) -> (scala.collection.immutable.Set)x$5.$plus$plus((IterableOnce)x$6));
            if (set == null || !set.equals(partitions)) {
                return false;
            }
            if (expectedAssignment.nonEmpty()) {
                assignments.foreach((Function1 & Serializable)assignment -> {
                    AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$4(expectedAssignment, object, assignment);
                    return BoxedUnit.UNIT;
                });
            }
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(long startingTimestamp$1, TopicPartition tp$1, KafkaProducer producer$1, int i) {
        long timestamp = startingTimestamp$1 + (long)i;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long(timestamp), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$1.send(record);
        return record;
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, int maxPollRecords$1, ArrayBuffer records$2, int numRecords$1) {
        Assertions.assertTrue((CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)polledRecords).asScala().size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ String $anonfun$consumeRecords$2(int numRecords$1, ArrayBuffer records$2) {
        return new StringBuilder(0).append(new StringBuilder(46).append("Timed out before consuming expected ").append(numRecords$1).append(" records. ").toString()).append(new StringBuilder(25).append("The number consumed was ").append(records$2.size()).append(".").toString()).toString();
    }

    public static final void kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback, Option offsetsOpt$1, Consumer consumer$1) {
        if (offsetsOpt$1 instanceof Some) {
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)((Some)offsetsOpt$1).value();
            consumer$1.commitAsync(CollectionConverters$.MODULE$.MapHasAsJava((Map)offsets).asJava(), callback);
            return;
        }
        if (None$.MODULE$.equals(offsetsOpt$1)) {
            consumer$1.commitAsync(callback);
            return;
        }
        throw new MatchError((Object)offsetsOpt$1);
    }

    public static final /* synthetic */ boolean $anonfun$sendAndAwaitAsyncCommit$1(RetryCommitCallback.1 commitCallback$1) {
        return commitCallback$1.isComplete();
    }

    public static final /* synthetic */ String $anonfun$sendAndAwaitAsyncCommit$2() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ Buffer $anonfun$addConsumersToGroup$1(AbstractConsumerTest $this, String group$1, Buffer consumerGroup$1, Buffer consumerPollers$1, List topicsToSubscribe$1, int x$1) {
        KafkaConsumer<byte[], byte[]> consumer = $this.createConsumerWithGroupId(group$1);
        consumerGroup$1.$plus$eq(consumer);
        return (Buffer)consumerPollers$1.$plus$eq((Object)$this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)topicsToSubscribe$1, $this.subscribeConsumerAndStartPolling$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$validateGroupAssignment$1(AbstractConsumerTest $this, Buffer assignments$1, Buffer consumerPollers$2, scala.collection.immutable.Set subscriptions$1, Buffer expectedAssignment$1) {
        assignments$1.clear();
        consumerPollers$2.foreach((Function1 & Serializable)x$2 -> (Buffer)assignments$1.$plus$eq(x$2.consumerAssignment()));
        return $this.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments$1, (scala.collection.immutable.Set<TopicPartition>)subscriptions$1, (Buffer<scala.collection.immutable.Set<TopicPartition>>)expectedAssignment$1);
    }

    public static final /* synthetic */ String $anonfun$validateGroupAssignment$3(Option msg$1, scala.collection.immutable.Set subscriptions$1, Buffer assignments$1) {
        return (String)msg$1.getOrElse((Function0 & Serializable)() -> new StringBuilder(59).append("Did not get valid assignment for partitions ").append(subscriptions$1).append(". Instead, got ").append(assignments$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$awaitRebalance$1(TestConsumerReassignmentListener rebalanceListener$1, int numReassignments$1) {
        return rebalanceListener$1.callsToAssigned() > numReassignments$1;
    }

    public static final /* synthetic */ String $anonfun$awaitRebalance$2() {
        return "Timed out before expected rebalance completed";
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$2(int x$3, scala.collection.immutable.Set x$4) {
        return x$3 + x$4.size();
    }

    public static final /* synthetic */ void $anonfun$isPartitionAssignmentValid$4(Buffer expectedAssignment$2, Object nonLocalReturnKey1$1, scala.collection.immutable.Set assignment) {
        if (!expectedAssignment$2.contains((Object)assignment)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public AbstractConsumerTest() {
        this.epsilon = 0.1;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.group = "my-test";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.groupMaxSessionTimeoutMs = 60000L;
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", this.group());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", "6000");
    }

    public static final /* synthetic */ Object $anonfun$consumeRecords$1$adapted(int maxPollRecords$1, ArrayBuffer records$2, int numRecords$1, ConsumerRecords polledRecords) {
        return BoxesRunTime.boxToBoolean((boolean)AbstractConsumerTest.pollAction$1(polledRecords, maxPollRecords$1, records$2, numRecords$1));
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        private final Consumer<byte[], byte[]> consumer;
        private final scala.collection.immutable.Set<TopicPartition> partitionsToAssign;
        private volatile Option<Throwable> thrownException;
        private volatile int receivedMessages;
        private final Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private volatile boolean subscriptionChanged;
        private List<String> topicsSubscription;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ AbstractConsumerTest $outer;

        public Option<Throwable> thrownException() {
            return this.thrownException;
        }

        public void thrownException_$eq(Option<Throwable> x$1) {
            this.thrownException = x$1;
        }

        public int receivedMessages() {
            return this.receivedMessages;
        }

        public void receivedMessages_$eq(int x$1) {
            this.receivedMessages = x$1;
        }

        public Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public scala.collection.immutable.Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().toSet();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            if (this.partitionsToAssign.nonEmpty()) {
                throw new IllegalStateException("Cannot call subscribe when configured to use manual partition assignment");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.receivedMessages_$eq(this.receivedMessages() + this.consumer.poll(Duration.ofMillis(50L)).count());
                return;
            }
            catch (WakeupException wakeupException) {
                return;
            }
            catch (Throwable e) {
                this.thrownException_$eq((Option<Throwable>)new Some((Object)e));
                throw e;
            }
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this.consumer = consumer;
            this.partitionsToAssign = partitionsToAssign;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.thrownException = None$.MODULE$;
            this.receivedMessages = 0;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.subscriptionChanged = false;
            this.topicsSubscription = topicsToSubscribe;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsLost(Collection<TopicPartition> x$1) {
                    super.onPartitionsLost(x$1);
                }

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])partitions.toArray(new TopicPartition[0])));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$minus$minus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])partitions.toArray(new TopicPartition[0])));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            if (partitionsToAssign.isEmpty()) {
                consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topicsToSubscribe).asJava(), this.rebalanceListener());
                return;
            }
            consumer.assign((Collection)CollectionConverters$.MODULE$.SetHasAsJava(partitionsToAssign).asJava());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this($outer, consumer, topicsToSubscribe, (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this($outer, consumer, (List<String>)package$.MODULE$.List().empty(), partitionsToAssign);
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
                return;
            }
            this.failCount_$eq(this.failCount() + 1);
            this.lastError_$eq((Option<Exception>)new Some((Object)exception));
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$CountConsumerCommitCallback$$$outer() {
            return AbstractConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public void onPartitionsLost(Collection<TopicPartition> x$1) {
            super.onPartitionsLost(x$1);
        }

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return AbstractConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

