/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Properties;
import kafka.admin.LeaderElectionCommand$;
import kafka.admin.LeaderElectionCommandTest$;
import kafka.common.AdminCommandFailedException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001\u0002\u0010 \u0005\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001A\u0002\u0013\u0005\u0001\u0007C\u0004@\u0001\u0001\u0007I\u0011\u0001!\t\r\u001d\u0003\u0001\u0015)\u00032\u0011\u001dA\u0005A1A\u0005\u0002%Ca!\u0014\u0001!\u0002\u0013Q\u0005b\u0002(\u0001\u0005\u0004%\t!\u0013\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002&\t\u000fA\u0003!\u0019!C\u0001\u0013\"1\u0011\u000b\u0001Q\u0001\n)CQA\u0015\u0001\u0005BMCQ!\u0019\u0001\u0005BMCQA\u001a\u0001\u0005\u0002MCQa\u001b\u0001\u0005\u0002MCQ!\u001c\u0001\u0005\u0002MCQa\u001c\u0001\u0005\u0002MCQ!\u001d\u0001\u0005\u0002MCQa\u001d\u0001\u0005\u0002MCQ!\u001e\u0001\u0005\u0002MCQa\u001e\u0001\u0005\u0002MCQ!\u001f\u0001\u0005\u0002MCQa\u001f\u0001\u0005\u0002MCQ! \u0001\u0005\u0002M;aa`\u0010\t\u0002\u0005\u0005aA\u0002\u0010 \u0011\u0003\t\u0019\u0001\u0003\u0004,3\u0011\u0005\u00111\u0002\u0005\b\u0003\u001bIB\u0011AA\b\u0011\u001d\ty$\u0007C\u0001\u0003\u0003Bq!!\u0012\u001a\t\u0003\t9EA\rMK\u0006$WM]#mK\u000e$\u0018n\u001c8D_6l\u0017M\u001c3UKN$(B\u0001\u0011\"\u0003\u0015\tG-\\5o\u0015\u0005\u0011\u0013!B6bM.\f7\u0001A\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001K\u0011\u0002\u0005i\\\u0017B\u0001\u0016(\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\f\t\u0003]\u0001i\u0011aH\u0001\bg\u0016\u0014h/\u001a:t+\u0005\t\u0004c\u0001\u001a8s5\t1G\u0003\u00025k\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001a\u0003\u0007M+\u0017\u000f\u0005\u0002;{5\t1H\u0003\u0002=C\u000511/\u001a:wKJL!AP\u001e\u0003\u0017-\u000bgm[1TKJ4XM]\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002B\u000bB\u0011!iQ\u0007\u0002k%\u0011A)\u000e\u0002\u0005+:LG\u000fC\u0004G\u0007\u0005\u0005\t\u0019A\u0019\u0002\u0007a$\u0013'\u0001\u0005tKJ4XM]:!\u0003\u001d\u0011'o\\6feF*\u0012A\u0013\t\u0003\u0005.K!\u0001T\u001b\u0003\u0007%sG/\u0001\u0005ce>\\WM]\u0019!\u0003\u001d\u0011'o\\6feJ\n\u0001B\u0019:pW\u0016\u0014(\u0007I\u0001\bEJ|7.\u001a:4\u0003!\u0011'o\\6feN\u0002\u0013!B:fiV\u0003H#A!)\u0005-)\u0006C\u0001,`\u001b\u00059&B\u0001-Z\u0003\r\t\u0007/\u001b\u0006\u00035n\u000bqA[;qSR,'O\u0003\u0002];\u0006)!.\u001e8ji*\ta,A\u0002pe\u001eL!\u0001Y,\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\ta1\r\u0005\u0002WI&\u0011Qm\u0016\u0002\n\u0003\u001a$XM]#bG\"\fQ\u0003^3ti\u0006cG\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u000eQB\u0011a+[\u0005\u0003U^\u0013A\u0001V3ti\u0006\u0011B/Z:u)>\u0004\u0018n\u0019)beRLG/[8oQ\tq\u0001.\u0001\nuKN$\b+\u0019;i)>T5o\u001c8GS2,\u0007FA\bi\u0003q!Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC\u0016cWm\u0019;j_:D#\u0001\u00055\u00023Q,7\u000f\u001e+pa&\u001cw+\u001b;i_V$\b+\u0019:uSRLwN\u001c\u0015\u0003#!\f\u0011\u0004^3tiB\u000b'\u000f^5uS>tw+\u001b;i_V$Hk\u001c9jG\"\u0012!\u0003[\u0001\u0016i\u0016\u001cH\u000fV8qS\u000e$u.Z:O_R,\u00050[:uQ\t\u0019\u0002.A\fuKN$X*[:tS:<W\t\\3di&|g\u000eV=qK\"\u0012A\u0003[\u0001#i\u0016\u001cH/T5tg&tw\rV8qS\u000e\u0004\u0016M\u001d;ji&|gnU3mK\u000e$\u0018n\u001c8)\u0005UA\u0017!\u0005;fgRLeN^1mS\u0012\u0014%o\\6fe\"\u0012a\u0003[\u0001\u0019i\u0016\u001cH/\u00127fGRLwN\u001c*fgVdGoT;uaV$\bFA\fi\u0003eaU-\u00193fe\u0016cWm\u0019;j_:\u001cu.\\7b]\u0012$Vm\u001d;\u0011\u00059J2cA\r\u0002\u0006A\u0019!)a\u0002\n\u0007\u0005%QG\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u0003\tAb\u0019:fCR,7i\u001c8gS\u001e$B!!\u0005\u0002>AA\u00111CA\u0011\u0003O\tiC\u0004\u0003\u0002\u0016\u0005u\u0001cAA\fk5\u0011\u0011\u0011\u0004\u0006\u0004\u00037\u0019\u0013A\u0002\u001fs_>$h(C\u0002\u0002 U\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u00111!T1q\u0015\r\ty\"\u000e\t\u0005\u0003'\tI#\u0003\u0003\u0002,\u0005\u0015\"AB*ue&tw\r\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\t1\fgn\u001a\u0006\u0003\u0003o\tAA[1wC&!\u00111HA\u0019\u0005\u0019y%M[3di\")qf\u0007a\u0001c\u0005\u0001\"m\\8ugR\u0014\u0018\r]*feZ,'o\u001d\u000b\u0005\u0003O\t\u0019\u0005C\u000309\u0001\u0007\u0011'\u0001\fuK6\u0004Hk\u001c9jGB\u000b'\u000f^5uS>tg)\u001b7f)\u0011\tI%!\u0017\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005!a-\u001b7f\u0015\u0011\t\u0019&!\u000e\u0002\u00079Lw.\u0003\u0003\u0002X\u00055#\u0001\u0002)bi\"Dq!a\u0017\u001e\u0001\u0004\ti&\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!a\u0005\u0002`\u0005\r\u0014\u0002BA1\u0003K\u00111aU3u!\u0011\t)'!\u001d\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\naaY8n[>t'b\u0001\u0012\u0002n)\u0019\u0011qN/\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u0019(a\u001a\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0002")
public final class LeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();
    private final int broker1;
    private final int broker2;
    private final int broker3;

    public static Path tempTopicPartitionFile(Set<TopicPartition> partitions) {
        return LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile(partitions);
    }

    public static String bootstrapServers(Seq<KafkaServer> servers) {
        return LeaderElectionCommandTest$.MODULE$.bootstrapServers(servers);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> servers) {
        return LeaderElectionCommandTest$.MODULE$.createConfig(servers);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0);
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable)config -> {
            void createServer_time;
            Time time;
            config.setProperty("auto.leader.rebalance.enable", "false");
            config.setProperty("controlled.shutdown.enable", "true");
            config.setProperty("controlled.shutdown.max.retries", "1");
            config.setProperty("controlled.shutdown.retry.backoff.ms", "1000");
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(config);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        })));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAllTopicPartition() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testAllTopicPartition$1(this, resource_resource);
        }
    }

    @Test
    public void testTopicPartition() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testTopicPartition$1(this, resource_resource);
        }
    }

    @Test
    public void testPathToJsonFile() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testPathToJsonFile$1(this, resource_resource);
        }
    }

    @Test
    public void testPreferredReplicaElection() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testPreferredReplicaElection$1(this, resource_resource);
        }
    }

    @Test
    public void testTopicWithoutPartition() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "unclean", "--topic", "some-topic"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Missing required option(s)"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" partition"));
    }

    @Test
    public void testPartitionWithoutTopic() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "unclean", "--all-topic-partitions", "--partition", "0"}));
        Assertions.assertEquals((Object)"Option partition is only allowed if topic is used", (Object)e.getMessage());
    }

    @Test
    public void testTopicDoesNotExist() {
        Assertions.assertTrue((boolean)(((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "preferred", "--topic", "unknown-topic-name", "--partition", "0"}))).getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
    }

    @Test
    public void testMissingElectionType() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--topic", "some-topic", "--partition", "0"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("Missing required option(s)"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" election-type"));
    }

    @Test
    public void testMissingTopicPartitionSelection() {
        Throwable e = Assertions.assertThrows(Throwable.class, () -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers(this.servers()), "--election-type", "preferred"}));
        Assertions.assertTrue((boolean)e.getMessage().startsWith("One and only one of the following options is required: "));
        Assertions.assertTrue((boolean)e.getMessage().contains(" all-topic-partitions"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" topic"));
        Assertions.assertTrue((boolean)e.getMessage().contains(" path-to-json-file"));
    }

    @Test
    public void testInvalidBroker() {
        Assertions.assertTrue((boolean)(((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", "example.com:1234", "--election-type", "unclean", "--all-topic-partitions"}, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds()))).getCause() instanceof TimeoutException));
    }

    @Test
    public void testElectionResultOutput() {
        try (Admin resource_resource = Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(LeaderElectionCommandTest$.MODULE$.createConfig(this.servers())).asJava());){
            LeaderElectionCommandTest.$anonfun$testElectionResultOutput$1(this, resource_resource);
        }
    }

    public static final /* synthetic */ void $anonfun$testAllTopicPartition$1(LeaderElectionCommandTest $this, Admin client) {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--all-topic-partitions"});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    public static final /* synthetic */ void $anonfun$testTopicPartition$1(LeaderElectionCommandTest $this, Admin client) {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--topic", topic, "--partition", Integer.toString(partition)});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    public static final /* synthetic */ void $anonfun$testPathToJsonFile$1(LeaderElectionCommandTest $this, Admin client) {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker3())).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(client, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3()}))));
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(client, topicPartition, (Option<Object>)None$.MODULE$);
        ((KafkaServer)$this.servers().apply($this.broker3())).startup();
        Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "unclean", "--path-to-json-file", ((Object)topicPartitionPath).toString()});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplicaElection$1(LeaderElectionCommandTest $this, Admin client) {
        String topic = "unclean-topic";
        int partition = 0;
        Seq assignment = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)assignment)}))), $this.servers());
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker3());
        ((KafkaServer)$this.servers().apply($this.broker2())).startup();
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2()}))));
        LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "preferred", "--all-topic-partitions"});
        TestUtils$.MODULE$.assertLeader(client, topicPartition, $this.broker2());
    }

    public static final /* synthetic */ void $anonfun$testElectionResultOutput$1(LeaderElectionCommandTest $this, Admin client) {
        String string;
        String topic = "non-preferred-topic";
        int partition0 = 0;
        int partition1 = 1;
        Seq assignment0 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2(), $this.broker3()}));
        Seq assignment1 = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker2()}));
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition0)), (Object)assignment0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition1)), (Object)assignment1)}))), $this.servers());
        TopicPartition topicPartition0 = new TopicPartition(topic, partition0);
        TopicPartition topicPartition1 = new TopicPartition(topic, partition1);
        TestUtils$.MODULE$.assertLeader(client, topicPartition0, $this.broker2());
        TestUtils$.MODULE$.assertLeader(client, topicPartition1, $this.broker3());
        ((KafkaServer)$this.servers().apply($this.broker2())).shutdown();
        TestUtils$.MODULE$.assertLeader(client, topicPartition0, $this.broker3());
        ((KafkaServer)$this.servers().apply($this.broker2())).startup();
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr(client, topicPartition1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{$this.broker2()}))));
        Path topicPartitionPath = LeaderElectionCommandTest$.MODULE$.tempTopicPartitionFile((Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition0, topicPartition1}))));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> LeaderElectionCommand$.MODULE$.main(new String[]{"--bootstrap-server", LeaderElectionCommandTest$.MODULE$.bootstrapServers($this.servers()), "--election-type", "preferred", "--path-to-json-file", ((Object)topicPartitionPath).toString()});
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out.toString();
        Object var12_10 = null;
        Object var13_11 = null;
        string = null;
        String output = string2;
        Iterator electionResultOutputIter = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])output.split("\n")));
        Assertions.assertTrue((boolean)electionResultOutputIter.hasNext());
        Assertions.assertTrue((boolean)((String)electionResultOutputIter.next()).contains(new StringBuilder(66).append("Successfully completed leader election (PREFERRED) for partitions ").append(topicPartition0).toString()));
        Assertions.assertTrue((boolean)electionResultOutputIter.hasNext());
        Assertions.assertTrue((boolean)((String)electionResultOutputIter.next()).contains(new StringBuilder(45).append("Valid replica already elected for partitions ").append(topicPartition1).toString()));
    }

    public LeaderElectionCommandTest() {
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
    }

    public static final /* synthetic */ Object $anonfun$testAllTopicPartition$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testAllTopicPartition$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTopicPartition$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testTopicPartition$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPathToJsonFile$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testPathToJsonFile$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testPreferredReplicaElection$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testPreferredReplicaElection$1($this, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testElectionResultOutput$1$adapted(LeaderElectionCommandTest $this, Admin client) {
        LeaderElectionCommandTest.$anonfun$testElectionResultOutput$1($this, client);
        return BoxedUnit.UNIT;
    }
}

