/*
 * Decompiled with CFR 0.152.
 */
package kafka.zookeeper;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaConfig$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.ExistsRequest;
import kafka.zookeeper.ExistsResponse;
import kafka.zookeeper.GetAclRequest;
import kafka.zookeeper.GetAclResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.SetAclRequest;
import kafka.zookeeper.SetAclResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.StateChangeHandler;
import kafka.zookeeper.ZNodeChangeHandler;
import kafka.zookeeper.ZNodeChildChangeHandler;
import kafka.zookeeper.ZooKeeperClient;
import kafka.zookeeper.ZooKeeperClientTest$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001\u0002\u001c8\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019\t\u0007\u0001)A\u0005)\"I!\r\u0001a\u0001\u0002\u0004%Ia\u0019\u0005\nO\u0002\u0001\r\u00111A\u0005\n!D\u0011\"\u001d\u0001A\u0002\u0003\u0005\u000b\u0015\u00023\t\u000bI\u0004A\u0011I:\t\u000b}\u0004A\u0011I:\t\r\u0005%\u0001\u0001\"\u0001t\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+Aa!a\u000e\u0001\t\u0003\u0019\bBBA\u001e\u0001\u0011\u00051\u000f\u0003\u0004\u0002@\u0001!\ta\u001d\u0005\u0007\u0003\u0007\u0002A\u0011A:\t\r\u0005\u001d\u0003\u0001\"\u0001t\u0011\u0019\tY\u0005\u0001C\u0001g\"1\u0011q\n\u0001\u0005\u0002MDa!a\u0015\u0001\t\u0003\u0019\bBBA,\u0001\u0011\u00051\u000f\u0003\u0004\u0002\\\u0001!\ta\u001d\u0005\u0007\u0003?\u0002A\u0011A:\t\r\u0005\r\u0004\u0001\"\u0001t\u0011\u0019\t9\u0007\u0001C\u0001g\"1\u00111\u000e\u0001\u0005\u0002MDa!a\u001c\u0001\t\u0003\u0019\bBBA:\u0001\u0011\u00051\u000f\u0003\u0004\u0002x\u0001!\ta\u001d\u0005\u0007\u0003w\u0002A\u0011A:\t\r\u0005}\u0004\u0001\"\u0001t\u0011\u0019\t\u0019\t\u0001C\u0001g\"1\u0011q\u0011\u0001\u0005\u0002MDa!a#\u0001\t\u0003\u0019\bBBAH\u0001\u0011\u00051\u000f\u0003\u0004\u0002\u0014\u0002!\ta\u001d\u0005\u0007\u0003/\u0003A\u0011A:\t\r\u0005m\u0005\u0001\"\u0001t\u0011\u0019\ty\n\u0001C\u0001g\"1\u00111\u0015\u0001\u0005\u0002MDa!a*\u0001\t\u0003\u0019\bBBAV\u0001\u0011\u00051\u000f\u0003\u0004\u00020\u0002!\ta\u001d\u0005\b\u0003g\u0003A\u0011AA[\u0011\u0019\ti\u000e\u0001C\u0001g\"1\u0011\u0011\u001d\u0001\u0005\u0002MDq!!:\u0001\t\u0013\t9\u000fC\u0005\u0003\u000e\u0001\t\n\u0011\"\u0003\u0003\u0010!I!Q\u0005\u0001\u0012\u0002\u0013%!q\u0005\u0005\n\u0005W\u0001\u0011\u0013!C\u0005\u0005OA\u0011B!\f\u0001#\u0003%IAa\f\t\r\tM\u0002\u0001\"\u0003t\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005o\u00111CW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e+fgRT!\u0001O\u001d\u0002\u0013i|wn[3fa\u0016\u0014(\"\u0001\u001e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001f\n!A_6\n\u0005\t{$\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB\u0011a\tA\u0007\u0002o\u0005AQn\\2l!\u0006$\b.F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!.\u0013aa\u0015;sS:<\u0017!C7pG.\u0004\u0016\r\u001e5!\u0003\u0011!\u0018.\\3\u0016\u0003Q\u0003\"!V0\u000e\u0003YS!a\u0016-\u0002\u000bU$\u0018\u000e\\:\u000b\u0005eS\u0016AB2p[6|gN\u0003\u0002;7*\u0011A,X\u0001\u0007CB\f7\r[3\u000b\u0003y\u000b1a\u001c:h\u0013\t\u0001gK\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004>p_.+W\r]3s\u00072LWM\u001c;\u0016\u0003\u0011\u0004\"AR3\n\u0005\u0019<$a\u0004.p_.+W\r]3s\u00072LWM\u001c;\u0002'i|wnS3fa\u0016\u00148\t\\5f]R|F%Z9\u0015\u0005%|\u0007C\u00016n\u001b\u0005Y'\"\u00017\u0002\u000bM\u001c\u0017\r\\1\n\u00059\\'\u0001B+oSRDq\u0001]\u0004\u0002\u0002\u0003\u0007A-A\u0002yIE\n\u0001C_8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0003%D#!C;\u0011\u0005YlX\"A<\u000b\u0005aL\u0018aA1qS*\u0011!p_\u0001\bUV\u0004\u0018\u000e^3s\u0015\taX,A\u0003kk:LG/\u0003\u0002\u007fo\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3ACA\u0002!\r1\u0018QA\u0005\u0004\u0003\u000f9(!C!gi\u0016\u0014X)Y2i\u0003u!Xm\u001d;V]J,7o\u001c7wC\ndWmQ8o]\u0016\u001cGo\u0015;sS:<\u0007fA\u0006\u0002\u000eA\u0019a/a\u0004\n\u0007\u0005EqO\u0001\u0003UKN$\u0018\u0001\u0006:v]:Lgn\u001a.l'\u0016tG\r\u00165sK\u0006$7/\u0006\u0002\u0002\u0018A1\u0011\u0011DA\u0010\u0003Gi!!a\u0007\u000b\u0007\u0005u1.\u0001\u0006d_2dWm\u0019;j_:LA!!\t\u0002\u001c\t\u00191+\u001a;\u0011\t\u0005\u0015\u00121\u0007\b\u0005\u0003O\ty\u0003E\u0002\u0002*-l!!a\u000b\u000b\u0007\u000552(\u0001\u0004=e>|GOP\u0005\u0004\u0003cY\u0017A\u0002)sK\u0012,g-C\u0002Q\u0003kQ1!!\rl\u0003U!Xm\u001d;D_:tWm\u0019;j_:$\u0016.\\3pkRD3!DA\u0007\u00039!Xm\u001d;D_:tWm\u0019;j_:D3ADA\u0007\u0003q!Xm\u001d;D_:tWm\u0019;j_:4\u0016.\u0019(fiRL8\t\\5f]RD3aDA\u0007\u0003i!Xm\u001d;EK2,G/\u001a(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\r\u0001\u0012QB\u0001\u0018i\u0016\u001cH\u000fR3mKR,W\t_5ti&twM\u0017(pI\u0016D3!EA\u0007\u0003i!Xm\u001d;Fq&\u001cHo\u001d(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\r\u0011\u0012QB\u0001\u0018i\u0016\u001cH/\u0012=jgR\u001cX\t_5ti&twM\u0017(pI\u0016D3aEA\u0007\u0003m!Xm\u001d;HKR$\u0015\r^1O_:,\u00050[:uK:$(LT8eK\"\u001aA#!\u0004\u00021Q,7\u000f^$fi\u0012\u000bG/Y#ySN$\u0018N\\4[\u001d>$W\rK\u0002\u0016\u0003\u001b\t1\u0004^3tiN+G\u000fR1uC:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007f\u0001\f\u0002\u000e\u0005AB/Z:u'\u0016$H)\u0019;b\u000bbL7\u000f^5oOjsu\u000eZ3)\u0007]\ti!\u0001\u000euKN$x)\u001a;BG2tuN\\#ySN$XM\u001c;[\u001d>$W\rK\u0002\u0019\u0003\u001b\tq\u0003^3ti\u001e+G/Q2m\u000bbL7\u000f^5oOjsu\u000eZ3)\u0007e\ti!\u0001\u000euKN$8+\u001a;BG2tuN\\#ySN$XM\u001c;[\u001d>$W\rK\u0002\u001b\u0003\u001b\tq\u0004^3ti\u001e+Go\u00115jY\u0012\u0014XM\u001c(p]\u0016C\u0018n\u001d;f]RTfj\u001c3fQ\rY\u0012QB\u0001\u001di\u0016\u001cHoR3u\u0007\"LG\u000e\u001a:f]\u0016C\u0018n\u001d;j]\u001eTfj\u001c3fQ\ra\u0012QB\u0001)i\u0016\u001cHoR3u\u0007\"LG\u000e\u001a:f]\u0016C\u0018n\u001d;j]\u001eTfj\u001c3f/&$\bn\u00115jY\u0012\u0014XM\u001c\u0015\u0004;\u00055\u0011\u0001\u0006;fgR\u0004\u0016\u000e]3mS:,GmR3u\t\u0006$\u0018\rK\u0002\u001f\u0003\u001b\t\u0011\u0003^3ti6K\u00070\u001a3QSB,G.\u001b8fQ\ry\u0012QB\u0001\"i\u0016\u001cHO\u0017(pI\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\u001a{'o\u0011:fCRLwN\u001c\u0015\u0004A\u00055\u0011!\t;fgRTfj\u001c3f\u0007\"\fgnZ3IC:$G.\u001a:G_J$U\r\\3uS>t\u0007fA\u0011\u0002\u000e\u0005\u0019C/Z:u5:{G-Z\"iC:<W\rS1oI2,'OR8s\t\u0006$\u0018m\u00115b]\u001e,\u0007f\u0001\u0012\u0002\u000e\u0005\u0011D/Z:u\u00052|7m[(o%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>tgI]8n'R\fG/Z\"iC:<W\rS1oI2,'\u000fK\u0002$\u0003\u001b\t\u0001\u0006^3ti\u0016C8-\u001a9uS>t\u0017J\u001c\"fM>\u0014X-\u00138ji&\fG.\u001b>j]\u001e\u001cVm]:j_:D3\u0001JA\u0007\u0003%\"Xm\u001d;[\u001d>$Wm\u00115jY\u0012\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\u001a{'o\u00115jY\u0012\u001c\u0005.\u00198hK\"\u001aQ%!\u0004\u0002kQ,7\u000f\u001e.O_\u0012,7\t[5mI\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\r>\u00148\t[5mI\u000eC\u0017M\\4f\u001d>$HK]5hO\u0016\u0014X\r\u001a\u0015\u0004M\u00055\u0011\u0001\n;fgR\u001cF/\u0019;f\u0007\"\fgnZ3IC:$G.\u001a:G_J\fU\u000f\u001e5GC&dWO]3)\u0007\u001d\ni!\u0001\u0013uKN$8i\u001c8oK\u000e$\u0018n\u001c8M_N\u001c(+Z9vKN$H+\u001a:nS:\fG/[8oQ\rA\u0013QB\u0001\u0012i\u0016\u001cHoU3tg&|g.\u0012=qSJL\bfA\u0015\u0002\u000e\u0005aB/Z:u'\u0016\u001c8/[8o\u000bb\u0004\u0018N]=EkJLgnZ\"m_N,\u0007f\u0001\u0016\u0002\u000e\u0005\u0001C/Z:u%\u0016Lg.\u001b;jC2L'0Z!gi\u0016\u0014\u0018)\u001e;i\r\u0006LG.\u001e:fQ\rY\u0013QB\u0001\u0015SN,\u0005\u0010]3di\u0016$W*\u001a;sS\u000et\u0015-\\3\u0015\r\u0005]\u0016QXAm!\rQ\u0017\u0011X\u0005\u0004\u0003w['a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u007fc\u0003\u0019AAa\u0003)iW\r\u001e:jG:\u000bW.\u001a\t\u0005\u0003\u0007\f).\u0004\u0002\u0002F*!\u0011qYAe\u0003\u0011\u0019wN]3\u000b\t\u0005-\u0017QZ\u0001\b[\u0016$(/[2t\u0015\u0011\ty-!5\u0002\re\fW.\\3s\u0015\t\t\u0019.A\u0002d_6LA!a6\u0002F\nQQ*\u001a;sS\u000et\u0015-\\3\t\u000f\u0005mG\u00061\u0001\u0002$\u0005!a.Y7f\u0003\r\"Xm\u001d;[_>\\U-\u001a9feN#\u0018\r^3DQ\u0006tw-\u001a*bi\u0016lU\r\u001e:jGND3!LA\u0007\u0003}!Xm\u001d;[_>\\U-\u001a9feN+7o]5p]N#\u0018\r^3NKR\u0014\u0018n\u0019\u0015\u0004]\u00055\u0011A\u00058foj{wnS3fa\u0016\u00148\t\\5f]R$\u0012\u0002ZAu\u0003[\f90a?\t\u0013\u0005-x\u0006%AA\u0002\u0005\r\u0012\u0001E2p]:,7\r^5p]N#(/\u001b8h\u0011%\tyo\fI\u0001\u0002\u0004\t\t0A\nd_:tWm\u0019;j_:$\u0016.\\3pkRl5\u000fE\u0002k\u0003gL1!!>l\u0005\rIe\u000e\u001e\u0005\n\u0003s|\u0003\u0013!a\u0001\u0003c\f1\"\\1y\u0013:4E.[4ii\"I\u0011Q`\u0018\u0011\u0002\u0003\u0007\u0011q`\u0001\rG2LWM\u001c;D_:4\u0017n\u001a\t\u0005\u0005\u0003\u0011I!\u0004\u0002\u0003\u0004)!!Q\u0001B\u0004\u0003\u0019\u0019G.[3oi*\u0011\u0001hW\u0005\u0005\u0005\u0017\u0011\u0019A\u0001\b[\u0017\u000ec\u0017.\u001a8u\u0007>tg-[4\u000299,wOW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0003\u0016\u0005\u0003G\u0011\u0019b\u000b\u0002\u0003\u0016A!!q\u0003B\u0011\u001b\t\u0011IB\u0003\u0003\u0003\u001c\tu\u0011!C;oG\",7m[3e\u0015\r\u0011yb[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0012\u00053\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003qqWm\u001e.p_.+W\r]3s\u00072LWM\u001c;%I\u00164\u0017-\u001e7uII*\"A!\u000b+\t\u0005E(1C\u0001\u001d]\u0016<(l\\8LK\u0016\u0004XM]\"mS\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003qqWm\u001e.p_.+W\r]3s\u00072LWM\u001c;%I\u00164\u0017-\u001e7uIQ*\"A!\r+\t\u0005}(1C\u0001\u0015G2,\u0017M\\'fiJL7m\u001d*fO&\u001cHO]=\u0002\u000b\tLH/Z:\u0016\u0005\te\u0002#\u00026\u0003<\t}\u0012b\u0001B\u001fW\n)\u0011I\u001d:bsB\u0019!N!\u0011\n\u0007\t\r3N\u0001\u0003CsR,\u0007")
public class ZooKeeperClientTest
extends ZooKeeperTestHarness {
    private final String kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    private final Time kafka$zookeeper$ZooKeeperClientTest$$time = Time.SYSTEM;
    private ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;

    public String kafka$zookeeper$ZooKeeperClientTest$$mockPath() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    }

    public Time kafka$zookeeper$ZooKeeperClientTest$$time() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$time;
    }

    public ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;
    }

    private void kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@BeforeEach");
        this.cleanMetricsRegistry();
        super.setUp();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(this.newZooKeeperClient(this.zkConnect(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), new ZKClientConfig()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() != null) {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        }
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@AfterEach");
    }

    @Test
    public void testUnresolvableConnectString() {
        try {
            this.newZooKeeperClient("some.invalid.hostname.foo.bar.local", 10, this.zkMaxInFlightRequests(), new ZKClientConfig());
            return;
        }
        catch (ZooKeeperClientTimeoutException zooKeeperClientTimeoutException) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.runningZkSendThreads(), (String)"ZooKeeper client threads still running");
            return;
        }
    }

    private Set<String> runningZkSendThreads() {
        return (Set)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isAlive()))).map((Function1 & Serializable)x$3 -> x$3.getName())).filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.contains("SendThread()")));
    }

    @Test
    public void testConnectionTimeout() {
        this.zookeeper().shutdown();
        Assertions.assertThrows(ZooKeeperClientTimeoutException.class, () -> {
            ZKClientConfig zKClientConfig;
            String string;
            String string2 = string = this.zkConnect();
            string = null;
            String x$2 = string2;
            int n = this.zkMaxInFlightRequests();
            ZKClientConfig zKClientConfig2 = zKClientConfig = new ZKClientConfig();
            zKClientConfig = null;
            ZKClientConfig x$4 = zKClientConfig2;
            this.newZooKeeperClient(x$2, 10, n, x$4).close();
        });
    }

    @Test
    public void testConnection() {
        try (ZooKeeperClient client = this.newZooKeeperClient(this.zkConnect(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), new ZKClientConfig());){
            scala.collection.mutable.Set threads = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(Thread.getAllStackTraces().keySet()).asScala().map((Function1 & Serializable)x$4 -> x$4.getName());
            Assertions.assertTrue((boolean)threads.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains(ZooKeeperTestHarness$.MODULE$.ZkClientEventThreadSuffix()))), (String)new StringBuilder(48).append("ZooKeeperClient event thread not found, threads=").append(threads).toString());
        }
    }

    @Test
    public void testConnectionViaNettyClient() {
        String string;
        ZKClientConfig clientConfig = new ZKClientConfig();
        String propKey = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        String propVal = "org.apache.zookeeper.ClientCnxnSocketNetty";
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, propKey, (Object)propVal);
        String string2 = string = this.zkConnect();
        string = null;
        String x$2 = string2;
        int n = this.zkConnectionTimeout();
        int n2 = this.zkMaxInFlightRequests();
        try (ZooKeeperClient client = this.newZooKeeperClient(x$2, n, n2, clientConfig);){
            Assertions.assertEquals((Object)new Some((Object)propVal), (Object)KafkaConfig$.MODULE$.zooKeeperClientProperty(client.clientConfig(), propKey));
            ZKClientConfig badClientConfig = new ZKClientConfig();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(badClientConfig, propKey, (Object)new StringBuilder(12).append(propVal).append("BadClassName").toString());
            Assertions.assertThrows(Exception.class, () -> {
                String string;
                String string2 = string = this.zkConnect();
                string = null;
                String x$6 = string2;
                int n = this.zkConnectionTimeout();
                int n2 = this.zkMaxInFlightRequests();
                this.newZooKeeperClient(x$6, n, n2, badClientConfig);
            });
        }
    }

    @Test
    public void testDeleteNonExistentZNode() {
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)deleteResponse.resultCode(), (String)"Response code should be NONODE");
        Assertions.assertThrows(KeeperException.NoNodeException.class, () -> deleteResponse.maybeThrow());
    }

    @Test
    public void testDeleteExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode(), (String)"Response code for delete should be OK");
    }

    @Test
    public void testExistsNonExistentZNode() {
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)existsResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testExistsExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)existsResponse.resultCode(), (String)"Response code for exists should be OK");
    }

    @Test
    public void testGetDataNonExistentZNode() {
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getDataResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])data, (byte[])getDataResponse.data(), (String)"Data for getData should match created znode data");
    }

    @Test
    public void testSetDataNonExistentZNode() {
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)setDataResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testSetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode(), (String)"Response code for setData should be OK");
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])data, (byte[])getDataResponse.data(), (String)"Data for getData should match setData's data");
    }

    @Test
    public void testGetAclNonExistentZNode() {
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getAclResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetAclExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getAclResponse.resultCode(), (String)"Response code for getAcl should be OK");
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), (Object)getAclResponse.acl(), (String)new StringBuilder(14).append("ACL should be ").append(CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala()).toString());
    }

    @Test
    public void testSetAclNonExistentZNode() {
        SetAclResponse setAclResponse = (SetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)setAclResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetChildrenNonExistentZNode() {
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)getChildrenResponse.resultCode(), (String)"Response code should be NONODE");
    }

    @Test
    public void testGetChildrenExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        Assertions.assertEquals((Object)Seq$.MODULE$.empty(), (Object)getChildrenResponse.children(), (String)"getChildren should return no children");
    }

    @Test
    public void testGetChildrenExistingZNodeWithChildren() {
        String child1 = "child1";
        String child2 = "child2";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        String child2Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child2).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        CreateResponse createResponseChild2 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child2Path, (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild2.resultCode(), (String)"Response code for create child2 should be OK");
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        Assertions.assertEquals((Object)new .colon.colon((Object)child1, (List)new .colon.colon((Object)child2, (List)Nil$.MODULE$)), (Object)getChildrenResponse.children().sorted((Ordering)Ordering.String$.MODULE$), (String)"getChildren should return two children");
    }

    @Test
    public void testPipelinedGetData() {
        ((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$1(BoxesRunTime.unboxToInt((Object)x))).map(arg_0 -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$2(this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient(), arg_0))).foreach((Function1 & Serializable)createResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$3(createResponse);
            return BoxedUnit.UNIT;
        });
        IndexedSeq getDataRequests = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$4(BoxesRunTime.unboxToInt((Object)x)));
        Seq getDataResponses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)getDataRequests);
        getDataResponses.foreach((Function1 & Serializable)getDataResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$5(getDataResponse);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)getDataResponses.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$6(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMixedPipeline() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        GetDataRequest getDataRequest = new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        SetDataRequest setDataRequest = new SetDataRequest("/nonexistent", (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), -1, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)getDataRequest, (List)new .colon.colon((Object)setDataRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for getData should be OK");
        Assertions.assertArrayEquals((byte[])((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte())), (byte[])((GetDataResponse)responses.head()).data(), (String)"Data for getData should be empty");
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for setData should be NONODE");
    }

    @Test
    public void testZNodeChangeHandlerForCreation() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)existsRequest, (List)new .colon.colon((Object)createRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be NONODE");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive create notification");
    }

    @Test
    public void testZNodeChangeHandlerForDeletion() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$2;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                this.znodeChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$2 = znodeChangeHandlerCountDownLatch$2;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)createRequest, (List)new .colon.colon((Object)existsRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be OK");
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode(), (String)"Response code for delete should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive delete notification");
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$3;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                this.znodeChangeHandlerCountDownLatch$3.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$3 = znodeChangeHandlerCountDownLatch$3;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)createRequest, (List)new .colon.colon((Object)existsRequest, (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode(), (String)"Response code for create should be OK");
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode(), (String)"Response code for exists should be OK");
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), -1, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode(), (String)"Response code for setData should be OK");
        Assertions.assertTrue((boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive data change notification");
    }

    @Test
    public void testBlockOnRequestCompletionFromStateChangeHandler() {
        CountDownLatch latch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, latch){
            private final String name;
            private final CountDownLatch latch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.latch$1.await();
            }
            {
                this.latch$1 = latch$1;
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(this.newZooKeeperClient(this.zkConnect(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), new ZKClientConfig()));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(stateChangeHandler);
        Thread requestThread = new Thread(this, latch){
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                try {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.$outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
                }
                finally {
                    this.latch$1.countDown();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread reinitializeThread = new Thread(this){
            private final /* synthetic */ ZooKeeperClientTest $outer;

            public void run() {
                this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        reinitializeThread.start();
        Thread.sleep(100L);
        requestThread.start();
        reinitializeThread.join();
        requestThread.join();
    }

    @Test
    public void testExceptionInBeforeInitializingSession() {
        StateChangeHandler faultyHandler = new StateChangeHandler(null){
            private final String name;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                throw new RuntimeException();
            }
            {
                this.name = this.getClass().getName();
            }
        };
        AtomicInteger goodCalls = new AtomicInteger(0);
        StateChangeHandler goodHandler = new StateChangeHandler(null, goodCalls){
            private final String name;
            private final AtomicInteger goodCalls$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.goodCalls$1.incrementAndGet();
            }
            {
                this.goodCalls$1 = goodCalls$1;
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(this.newZooKeeperClient(this.zkConnect(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), new ZKClientConfig()));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(faultyHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(goodHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
        Assertions.assertEquals((int)1, (int)goodCalls.get());
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChange() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$1;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$1 = zNodeChildChangeHandlerCountDownLatch$1;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        Assertions.assertTrue((boolean)zNodeChildChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive child change notification");
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChangeNotTriggered() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$2;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$2 = zNodeChildChangeHandlerCountDownLatch$2;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), false, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode(), (String)"Response code for getChildren should be OK");
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode(), (String)"Response code for create child1 should be OK");
        Assertions.assertFalse((boolean)zNodeChildChangeHandlerCountDownLatch.await(100L, TimeUnit.MILLISECONDS), (String)"Child change notification received");
    }

    @Test
    public void testStateChangeHandlerForAuthFailure() {
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        CountDownLatch stateChangeHandlerCountDownLatch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, stateChangeHandlerCountDownLatch){
            private final String name;
            private final CountDownLatch stateChangeHandlerCountDownLatch$1;

            public void beforeInitializingSession() {
                StateChangeHandler.beforeInitializingSession$((StateChangeHandler)this);
            }

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void onAuthFailure() {
                this.stateChangeHandlerCountDownLatch$1.countDown();
            }
            {
                this.stateChangeHandlerCountDownLatch$1 = stateChangeHandlerCountDownLatch$1;
                this.name = this.getClass().getName();
            }
        };
        try (ZooKeeperClient zooKeeperClient = this.newZooKeeperClient(this.zkConnect(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), new ZKClientConfig());){
            zooKeeperClient.registerStateChangeHandler(stateChangeHandler);
            zooKeeperClient.forceReinitialize();
            Assertions.assertTrue((boolean)stateChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive auth failed notification");
        }
    }

    @Test
    public void testConnectionLossRequestTermination() {
        ZKClientConfig zKClientConfig;
        String string;
        int batchSize = 10;
        String string2 = string = this.zkConnect();
        string = null;
        String x$2 = string2;
        int n = this.zkConnectionTimeout();
        ZKClientConfig zKClientConfig2 = zKClientConfig = new ZKClientConfig();
        zKClientConfig = null;
        ZKClientConfig x$4 = zKClientConfig2;
        this.zookeeper().shutdown();
        try (ZooKeeperClient zooKeeperClient = this.newZooKeeperClient(x$2, n, 2, x$4);){
            IndexedSeq requests = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), batchSize).map((Function1 & Serializable)i -> ZooKeeperClientTest.$anonfun$testConnectionLossRequestTermination$1(BoxesRunTime.unboxToInt((Object)i)));
            CountDownLatch countDownLatch = new CountDownLatch(1);
            AtomicBoolean running = new AtomicBoolean(true);
            ArrayBlockingQueue unexpectedResponses = new ArrayBlockingQueue(batchSize);
            Thread requestThread = new Thread(null, running, zooKeeperClient, requests, unexpectedResponses, countDownLatch){
                private final AtomicBoolean running$1;
                private final ZooKeeperClient zooKeeperClient$1;
                private final IndexedSeq requests$1;
                private final ArrayBlockingQueue unexpectedResponses$1;
                private final CountDownLatch countDownLatch$1;

                public void run() {
                    while (this.running$1.get()) {
                        Seq responses = this.zooKeeperClient$1.handleRequests((Seq)this.requests$1);
                        Seq suffix = (Seq)responses.dropWhile((Function1 & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$1(response)));
                        if (!suffix.forall((Function1 & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$2(response)))) {
                            responses.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$3(this, x$1)));
                        }
                        if (this.unexpectedResponses$1.isEmpty() && !suffix.nonEmpty()) continue;
                        this.running$1.set(false);
                    }
                    this.countDownLatch$1.countDown();
                }

                public static final /* synthetic */ boolean $anonfun$run$1(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return code == null ? code2 != null : !code.equals(code2);
                }

                public static final /* synthetic */ boolean $anonfun$run$2(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return !(code != null ? !code.equals(code2) : code2 != null);
                }

                public static final /* synthetic */ boolean $anonfun$run$3($anon$12 $this, GetDataResponse x$1) {
                    return $this.unexpectedResponses$1.add(x$1);
                }
                {
                    this.running$1 = running$1;
                    this.zooKeeperClient$1 = zooKeeperClient$1;
                    this.requests$1 = requests$1;
                    this.unexpectedResponses$1 = unexpectedResponses$1;
                    this.countDownLatch$1 = countDownLatch$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$2$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$3$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$12 kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            if (!countDownLatch.await(30L, TimeUnit.SECONDS)) {
                running.set(false);
                requestThread.join(5000L);
                Assertions.fail((String)"Failed to receive a CONNECTIONLOSS response code after zookeeper has shutdown.");
            } else if (!unexpectedResponses.isEmpty()) {
                Assertions.fail((String)new StringBuilder(114).append("Received an unexpected non-CONNECTIONLOSS response code after a CONNECTIONLOSS response code from a single batch: ").append(unexpectedResponses).toString());
            }
        }
    }

    @Test
    public void testSessionExpiry() {
        int maxInflightRequests = 2;
        ExecutorService responseExecutor = Executors.newSingleThreadExecutor();
        Semaphore sendSemaphore = new Semaphore(0);
        Semaphore sendCompleteSemaphore = new Semaphore(0);
        int sendSize = maxInflightRequests * 5;
        VolatileObjectRef resultCodes = VolatileObjectRef.create(null);
        ConcurrentLinkedQueue stateChanges = new ConcurrentLinkedQueue();
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this, maxInflightRequests, responseExecutor, sendCompleteSemaphore, sendSemaphore){
            private final ExecutorService responseExecutor$1;
            public final Semaphore sendCompleteSemaphore$1;
            public final Semaphore sendSemaphore$1;

            public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
                super.send(request, (Function1 & Serializable)response -> {
                    $anon$13.$anonfun$send$1(this, processResponse, response);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$send$1($anon$13 $this, Function1 processResponse$1, AsyncResponse response) {
                $this.responseExecutor$1.submit(new Runnable($this, processResponse$1, response){
                    private final /* synthetic */ $anon$13 $outer;
                    private final Function1 processResponse$1;
                    private final AsyncResponse response$1;

                    public void run() {
                        this.$outer.sendCompleteSemaphore$1.release();
                        this.$outer.sendSemaphore$1.acquire();
                        this.processResponse$1.apply((Object)this.response$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.processResponse$1 = processResponse$1;
                        this.response$1 = response$1;
                    }
                });
            }
            {
                this.responseExecutor$1 = responseExecutor$1;
                this.sendCompleteSemaphore$1 = sendCompleteSemaphore$1;
                this.sendSemaphore$1 = sendSemaphore$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), maxInflightRequests$1, $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName", new ZKClientConfig(), "ZooKeeperClientTest");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$send$1$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$13 scala.Function1 kafka.zookeeper.AsyncResponse )}, serializedLambda);
            }
        };
        try {
            zooKeeperClient.registerStateChangeHandler(new StateChangeHandler(null, stateChanges, sendSemaphore, sendSize, zooKeeperClient){
                private final String name;
                private final ConcurrentLinkedQueue stateChanges$1;
                private final Semaphore sendSemaphore$1;
                private final int sendSize$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void onAuthFailure() {
                    StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
                }

                public String name() {
                    return this.name;
                }

                public void afterInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("afterInitializingSession");
                }

                public void beforeInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("beforeInitializingSession");
                    this.sendSemaphore$1.release(this.sendSize$1);
                }

                private void verifyHandlerThread() {
                    String threadName = Thread.currentThread().getName();
                    Assertions.assertTrue((boolean)threadName.startsWith(this.zooKeeperClient$2.reinitializeScheduler().threadNamePrefix()), (String)new StringBuilder(20).append("Unexpected thread + ").append(threadName).toString());
                }
                {
                    this.stateChanges$1 = stateChanges$1;
                    this.sendSemaphore$1 = sendSemaphore$1;
                    this.sendSize$1 = sendSize$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                    this.name = "test-state-change-handler";
                }
            });
            Thread requestThread = new Thread(null, sendSize, resultCodes, zooKeeperClient){
                private final int sendSize$1;
                private final VolatileObjectRef resultCodes$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void run() {
                    IndexedSeq requests = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.sendSize$1).map((Function1 & Serializable)i -> $anon$16.$anonfun$run$4(BoxesRunTime.unboxToInt((Object)i)));
                    this.resultCodes$1.elem = (Seq)this.zooKeeperClient$2.handleRequests((Seq)requests).map((Function1 & Serializable)x$6 -> x$6.resultCode());
                }

                public static final /* synthetic */ GetDataRequest $anonfun$run$4(int i) {
                    return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), (Option)None$.MODULE$);
                }
                {
                    this.sendSize$1 = sendSize$1;
                    this.resultCodes$1 = resultCodes$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$4$adapted(java.lang.Object ), $anonfun$run$5(kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            sendCompleteSemaphore.acquire();
            ZooKeeper anotherZkClient = this.createZooKeeperClientToTriggerSessionExpiry(zooKeeperClient.currentZooKeeper());
            sendSemaphore.release(maxInflightRequests);
            anotherZkClient.close();
            sendSemaphore.release(maxInflightRequests);
            requestThread.join(10000L);
            if (requestThread.isAlive()) {
                requestThread.interrupt();
                Assertions.fail((String)"Request thread did not complete");
            }
            Assertions.assertEquals((Object)new .colon.colon((Object)"beforeInitializingSession", (List)new .colon.colon((Object)"afterInitializingSession", (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(stateChanges).asScala().toSeq());
            Assertions.assertEquals((int)((Seq)resultCodes.elem).size(), (int)sendSize);
            int connectionLostCount = ((Seq)resultCodes.elem).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$1(x$7)));
            Assertions.assertTrue((connectionLostCount <= maxInflightRequests ? 1 : 0) != 0, (String)new StringBuilder(36).append("Unexpected connection lost requests ").append((Seq)resultCodes.elem).toString());
            int expiredCount = ((Seq)resultCodes.elem).count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$2(x$8)));
            Assertions.assertTrue((expiredCount <= maxInflightRequests ? 1 : 0) != 0, (String)new StringBuilder(36).append("Unexpected session expired requests ").append((Seq)resultCodes.elem).toString());
            Assertions.assertTrue((connectionLostCount + expiredCount > 0 ? 1 : 0) != 0, (String)new StringBuilder(39).append("No connection lost or expired requests ").append((Seq)resultCodes.elem).toString());
            Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).head());
            Assertions.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).last());
            Assertions.assertTrue((boolean)((Seq)resultCodes.elem).forall(arg_0 -> ZooKeeperClientTest.$anonfun$testSessionExpiry$3$adapted((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeeperException.Code[]{KeeperException.Code.NONODE, KeeperException.Code.SESSIONEXPIRED, KeeperException.Code.CONNECTIONLOSS})), arg_0)), (String)new StringBuilder(23).append("Unexpected result code ").append((Seq)resultCodes.elem).toString());
        }
        finally {
            zooKeeperClient.close();
            responseExecutor.shutdownNow();
        }
        Assertions.assertFalse((boolean)zooKeeperClient.reinitializeScheduler().isStarted(), (String)"Expiry executor not shutdown");
    }

    @Test
    public void testSessionExpiryDuringClose() {
        Semaphore semaphore = new Semaphore(0);
        ExecutorService closeExecutor = Executors.newSingleThreadExecutor();
        try {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().reinitializeScheduler().schedule("test", (Function0)(JFunction0.mcV.sp & Serializable)() -> semaphore.acquireUninterruptibly(), 0L, -1L, TimeUnit.SECONDS);
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().scheduleReinitialize("session-expired", "Session expired.", 0L);
            Future<?> closeFuture = closeExecutor.submit(new Runnable(this){
                private final /* synthetic */ ZooKeeperClientTest $outer;

                public void run() {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assertions.assertFalse((boolean)closeFuture.isDone(), (String)"Close completed without shutting down expiry scheduler gracefully");
            Assertions.assertTrue((boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().currentZooKeeper().getState().isAlive());
            semaphore.release();
            closeFuture.get(10L, TimeUnit.SECONDS);
            Assertions.assertFalse((boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().reinitializeScheduler().isStarted(), (String)"Expiry executor not shutdown");
        }
        finally {
            closeExecutor.shutdownNow();
        }
    }

    @Test
    public void testReinitializeAfterAuthFailure() {
        CountDownLatch sessionInitializedCountDownLatch = new CountDownLatch(1);
        StateChangeHandler changeHandler = new StateChangeHandler(null, sessionInitializedCountDownLatch){
            private final String name;
            private final CountDownLatch sessionInitializedCountDownLatch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.sessionInitializedCountDownLatch$1.countDown();
            }
            {
                this.sessionInitializedCountDownLatch$1 = sessionInitializedCountDownLatch$1;
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        VolatileObjectRef connectionStateOverride = VolatileObjectRef.create((Object)None$.MODULE$);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this, connectionStateOverride){
            private final VolatileObjectRef connectionStateOverride$1;

            private /* synthetic */ ZooKeeper.States super$connectionState() {
                return super.connectionState();
            }

            public ZooKeeper.States connectionState() {
                return (ZooKeeper.States)((Option)this.connectionStateOverride$1.elem).getOrElse((Function0 & Serializable)() -> this.super$connectionState());
            }
            {
                this.connectionStateOverride$1 = connectionStateOverride$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), $outer.zkMaxInFlightRequests(), $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType", new ZKClientConfig(), "ZooKeeperClientTest");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$connectionState$1(kafka.zookeeper.ZooKeeperClientTest$$anon$19 )}, serializedLambda);
            }
        });
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(changeHandler);
        connectionStateOverride.elem = new Some((Object)ZooKeeper.States.CONNECTED);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
        Assertions.assertFalse((boolean)sessionInitializedCountDownLatch.await(10L, TimeUnit.MILLISECONDS), (String)"Unexpected session initialization when connection is alive");
        connectionStateOverride.elem = new Some((Object)ZooKeeper.States.AUTH_FAILED);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.AuthFailed, null));
        Assertions.assertTrue((boolean)sessionInitializedCountDownLatch.await(5L, TimeUnit.SECONDS), (String)"Failed to receive session initializing notification");
    }

    public boolean isExpectedMetricName(MetricName metricName, String name) {
        String string = metricName.getName();
        if (!(string != null ? !string.equals(name) : name != null)) {
            String string2 = metricName.getGroup();
            String string3 = "testMetricGroup";
            if (string2 != null && string2.equals(string3)) {
                String string4 = metricName.getType();
                String string5 = "testMetricType";
                if (string4 != null && string4.equals(string5)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Test
    public void testZooKeeperStateChangeRateMetrics() {
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        this.checkMeterCount$1(expiresPerSecName, 0L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 1L);
    }

    @Test
    public void testZooKeeperSessionStateMetric() {
        Assertions.assertEquals((Object)new Some((Object)ZooKeeper.States.CONNECTED.toString()), (Object)this.gaugeValue$1("SessionState"));
        Assertions.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.gaugeValue$1("SessionState"));
        Assertions.assertEquals((Object)ZooKeeper.States.CLOSED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
    }

    private ZooKeeperClient newZooKeeperClient(String connectionString, int connectionTimeoutMs, int maxInFlight, ZKClientConfig clientConfig) {
        return new ZooKeeperClient(connectionString, this.zkSessionTimeout(), connectionTimeoutMs, maxInFlight, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType", clientConfig, "ZooKeeperClientTest");
    }

    private String newZooKeeperClient$default$1() {
        return this.zkConnect();
    }

    private int newZooKeeperClient$default$2() {
        return this.zkConnectionTimeout();
    }

    private int newZooKeeperClient$default$3() {
        return this.zkMaxInFlightRequests();
    }

    private ZKClientConfig newZooKeeperClient$default$4() {
        return new ZKClientConfig();
    }

    private void cleanMetricsRegistry() {
        MetricsRegistry metrics = KafkaYammerMetrics.defaultRegistry();
        metrics.allMetrics().keySet().forEach(x$1 -> metrics.removeMetric(x$1));
    }

    private byte[] bytes() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ CreateRequest $anonfun$testPipelinedGetData$1(int x) {
        return new CreateRequest(new StringBuilder(1).append("/").append(x).toString(), Integer.toString(x * 2).getBytes(), (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ CreateResponse $anonfun$testPipelinedGetData$2(ZooKeeperClient eta$0$1$1, CreateRequest request) {
        return (CreateResponse)eta$0$1$1.handleRequest((AsyncRequest)request);
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$3(CreateResponse createResponse) {
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)createResponse.resultCode(), (String)"Response code for create should be OK");
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testPipelinedGetData$4(int x) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(x).toString(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$5(GetDataResponse getDataResponse) {
        Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$6(Tuple2 x0$1) {
        if (x0$1 != null) {
            GetDataResponse getDataResponse = (GetDataResponse)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode(), (String)"Response code for getData should be OK");
            Assertions.assertEquals((int)((i + 1) * 2), (Integer)Integer.valueOf(new String(getDataResponse.data())), (String)"Data for getData should match");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testConnectionLossRequestTermination$1(int i) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$1(KeeperException.Code x$7) {
        KeeperException.Code code = x$7;
        KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$2(KeeperException.Code x$8) {
        KeeperException.Code code = x$8;
        KeeperException.Code code2 = KeeperException.Code.SESSIONEXPIRED;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    private final void checkMeterCount$1(String name, long expected) {
        Meter meter = (Meter)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().collectFirst((PartialFunction)new Serializable(this, name){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric meter = (Metric)x1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$1)) {
                            object = meter2;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 == null) return false;
                MetricName metricName = (MetricName)x1._1();
                if (!((Metric)x1._2() instanceof Meter)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$1)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.error(new StringBuilder(31).append("Unable to find meter with name ").append(name).toString()));
        Assertions.assertEquals((long)expected, (long)meter.count(), (String)new StringBuilder(27).append("Unexpected meter count for ").append(name).toString());
    }

    private final Option gaugeValue$1(String name) {
        return CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().collectFirst((PartialFunction)new Serializable(this, name){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric gauge = (Metric)x1._2();
                    if (gauge instanceof Gauge) {
                        Gauge gauge2 = (Gauge)gauge;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$2)) {
                            object = (String)gauge2.value();
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 == null) return false;
                MetricName metricName = (MetricName)x1._1();
                if (!((Metric)x1._2() instanceof Gauge)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$2)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$2 = name$2;
            }
        });
    }

    public ZooKeeperClientTest() {
        this.kafka$zookeeper$ZooKeeperClientTest$$mockPath = "/foo";
    }

    public static final /* synthetic */ Object $anonfun$testSessionExpiry$3$adapted(scala.collection.immutable.Set eta$0$1$2, KeeperException.Code elem) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$2.contains((Object)elem));
    }
}

