/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LazyIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TimestampOffset$;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015a\u0001B,Y\u0001uC\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u001b\u0005\tq\u0002\u0011\t\u0011)A\u0005W\"A\u0011\u0010\u0001BC\u0002\u0013\u0005!\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005w\"Q\u0011q\u0001\u0001\u0003\u0006\u0004%\t!!\u0003\t\u0015\u0005M\u0001A!A!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0016\u0001\u0011)\u0019!C\u0001\u0003/A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t\t\u0003\u0001BC\u0002\u0013\u0005\u00111\u0005\u0005\u000b\u0003W\u0001!\u0011!Q\u0001\n\u0005\u0015\u0002BCA\u0017\u0001\t\u0015\r\u0011\"\u0001\u00020!Q\u0011q\u0007\u0001\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005e\u0002A!b\u0001\n\u0003\t\u0019\u0003\u0003\u0006\u0002<\u0001\u0011\t\u0011)A\u0005\u0003KA!\"!\u0010\u0001\u0005\u000b\u0007I\u0011AA \u0011)\tY\u0005\u0001B\u0001B\u0003%\u0011\u0011\t\u0005\t\u0003\u001b\u0002A\u0011\u0001-\u0002P!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003Cq!!$\u0001\t\u0003\ty\tC\u0005\u0002\u0016\u0002\u0001\r\u0011\"\u0003\u0002$!I\u0011q\u0013\u0001A\u0002\u0013%\u0011\u0011\u0014\u0005\t\u0003?\u0003\u0001\u0015)\u0003\u0002&!I\u0011\u0011\u0015\u0001A\u0002\u0013%\u0011q\u0006\u0005\n\u0003G\u0003\u0001\u0019!C\u0005\u0003KC\u0001\"!+\u0001A\u0003&\u0011\u0011\u0007\u0005\n\u0003W\u0003\u0001\u0019!C\u0005\u0003[C\u0011\"!.\u0001\u0001\u0004%I!a.\t\u0011\u0005m\u0006\u0001)Q\u0005\u0003_C\u0011\"!2\u0001\u0001\u0004%I!a2\t\u0013\u0005=\u0007\u00011A\u0005\n\u0005E\u0007\u0002CAk\u0001\u0001\u0006K!!3\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\u001d\u0007bBAr\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003K\u0004A\u0011AA\u0012\u0011\u001d\tY\t\u0001C\u0001\u0003_Aq!a:\u0001\t\u0003\tI\u000fC\u0004\u0002p\u0002!\t!!=\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014!9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0016\u0001\u0011\u0005!Q\u0006\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u0017B\u0001B!\u0019\u0001\t\u0003A&1\r\u0005\u000b\u00057\u0003\u0011\u0013!C\u00011\nu\u0005b\u0002BZ\u0001\u0011\u0005!Q\u0017\u0005\n\u0005+\u0004\u0011\u0013!C\u0001\u0005/D\u0011Ba7\u0001#\u0003%\tA!8\t\u000f\t\u0005\b\u0001\"\u0001\u0003d\"9!1\u001f\u0001\u0005\u0002\tU\b\"CB\u0007\u0001E\u0005I\u0011AB\b\u0011\u001d\u0019\u0019\u0002\u0001C\u0005\u0007+Aqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0004\u0004\u001c\u0001!\ta!\b\t\u000f\r5\u0002\u0001\"\u0011\u00040!91\u0011\t\u0001\u0005\u0002\r\r\u0003bBB%\u0001\u0011\u0005\u00111\u0005\u0005\b\u0007\u001b\u0002A\u0011AB\u000b\u0011\u001d\u0019\t\u0006\u0001C\u0001\u0007'Bqa!\u001b\u0001\t\u0003\u0019Y\u0007C\u0004\u0004v\u0001!\ta!\u0006\t\u000f\r]\u0004\u0001\"\u0003\u0004\u0016!91\u0011\u0010\u0001\u0005\u0002\rm\u0004bBBC\u0001\u0011\u00051q\u0011\u0005\b\u0007\u0013\u0003A\u0011ABF\u0011%\u0019i\nAI\u0001\n\u0003\u00119\u000eC\u0004\u0004 \u0002!\ta!\u0006\t\u000f\r\u0005\u0006\u0001\"\u0001\u0004\u0016!911\u0015\u0001\u0005\u0002\rU\u0001bBBS\u0001\u0011\u0005\u00111\u0005\u0005\b\u0007O\u0003A\u0011AAW\u0011\u001d\tI\u0010\u0001C\u0001\u0003GAqa!+\u0001\t\u0003\u0019YkB\u0004\u0004DbC\ta!2\u0007\r]C\u0006\u0012ABd\u0011\u001d\tiE\u0014C\u0001\u0007\u0013Dqaa3O\t\u0003\u0019i\rC\u0005\u0004p:\u000b\n\u0011\"\u0001\u0003^\"I1\u0011\u001f(\u0012\u0002\u0013\u0005!Q\u0014\u0005\n\u0007gt\u0015\u0013!C\u0001\u0005;D\u0011b!>O#\u0003%\taa>\t\u000f\r\rf\n\"\u0001\u0004|\"IA1\u0001(\u0012\u0002\u0013\u00051q\u001f\u0002\u000b\u0019><7+Z4nK:$(BA-[\u0003\rawn\u001a\u0006\u00027\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001_IB\u0011qLY\u0007\u0002A*\t\u0011-A\u0003tG\u0006d\u0017-\u0003\u0002dA\n1\u0011I\\=SK\u001a\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a.\u0002\u000bU$\u0018\u000e\\:\n\u0005%4'a\u0002'pO\u001eLgnZ\u000b\u0002WB\u0011AN^\u0007\u0002[*\u0011an\\\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005A\f\u0018AB2p[6|gN\u0003\u0002\\e*\u00111\u000f^\u0001\u0007CB\f7\r[3\u000b\u0003U\f1a\u001c:h\u0013\t9XNA\u0006GS2,'+Z2pe\u0012\u001c\u0018\u0001\u00027pO\u0002\nq\u0002\\1{s>3gm]3u\u0013:$W\r_\u000b\u0002wB\u0019A0`@\u000e\u0003aK!A -\u0003\u00131\u000b'0_%oI\u0016D\bc\u0001?\u0002\u0002%\u0019\u00111\u0001-\u0003\u0017=3gm]3u\u0013:$W\r_\u0001\u0011Y\u0006T\u0018p\u00144gg\u0016$\u0018J\u001c3fq\u0002\nQ\u0002\\1{sRKW.Z%oI\u0016DXCAA\u0006!\u0011aX0!\u0004\u0011\u0007q\fy!C\u0002\u0002\u0012a\u0013\u0011\u0002V5nK&sG-\u001a=\u0002\u001d1\f'0\u001f+j[\u0016Le\u000eZ3yA\u0005AA\u000f\u001f8J]\u0012,\u00070\u0006\u0002\u0002\u001aA\u0019A0a\u0007\n\u0007\u0005u\u0001L\u0001\tUe\u0006t7/Y2uS>t\u0017J\u001c3fq\u0006IA\u000f\u001f8J]\u0012,\u0007\u0010I\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$XCAA\u0013!\ry\u0016qE\u0005\u0004\u0003S\u0001'\u0001\u0002'p]\u001e\f1BY1tK>3gm]3uA\u0005\u0011\u0012N\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3t+\t\t\t\u0004E\u0002`\u0003gI1!!\u000ea\u0005\rIe\u000e^\u0001\u0014S:$W\r_%oi\u0016\u0014h/\u00197CsR,7\u000fI\u0001\re>dGNS5ui\u0016\u0014Xj]\u0001\u000ee>dGNS5ui\u0016\u0014Xj\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002H5\u0011\u0011Q\t\u0006\u0003O>LA!!\u0013\u0002F\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0012\u0011KA*\u0003+\n9&!\u0017\u0002\\\u0005u\u0013qLA1!\ta\b\u0001C\u0003Z#\u0001\u00071\u000eC\u0003z#\u0001\u00071\u0010C\u0004\u0002\bE\u0001\r!a\u0003\t\u000f\u0005U\u0011\u00031\u0001\u0002\u001a!9\u0011\u0011E\tA\u0002\u0005\u0015\u0002bBA\u0017#\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003s\t\u0002\u0019AA\u0013\u0011\u001d\ti$\u0005a\u0001\u0003\u0003\n1b\u001c4gg\u0016$\u0018J\u001c3fqV\tq0A\u0005uS6,\u0017J\u001c3fqV\u0011\u0011QB\u0001\u000bg\"|W\u000f\u001c3S_2dG\u0003BA8\u0003k\u00022aXA9\u0013\r\t\u0019\b\u0019\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\b\u0006a\u0001\u0003s\n!B]8mYB\u000b'/Y7t!\ra\u00181P\u0005\u0004\u0003{B&A\u0003*pY2\u0004\u0016M]1ng\u0006i!/Z:ju\u0016Le\u000eZ3yKN$B!a!\u0002\nB\u0019q,!\"\n\u0007\u0005\u001d\u0005M\u0001\u0003V]&$\bbBAF+\u0001\u0007\u0011\u0011G\u0001\u0005g&TX-A\u0006tC:LG/_\"iK\u000e\\G\u0003BAB\u0003#Cq!a%\u0017\u0001\u0004\ty'A\ruS6,\u0017J\u001c3fq\u001aKG.\u001a(fo2L8I]3bi\u0016$\u0017aB2sK\u0006$X\rZ\u0001\fGJ,\u0017\r^3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0004\u0006m\u0005\"CAO1\u0005\u0005\t\u0019AA\u0013\u0003\rAH%M\u0001\tGJ,\u0017\r^3eA\u0005A\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=\u00029\tLH/Z:TS:\u001cW\rT1ti&sG-\u001a=F]R\u0014\u0018p\u0018\u0013fcR!\u00111QAT\u0011%\tijGA\u0001\u0002\u0004\t\t$A\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\u0004\u0013!\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e]\u000b\u0003\u0003_\u0003RaXAY\u0003KI1!a-a\u0005\u0019y\u0005\u000f^5p]\u0006I\"o\u001c7mS:<')Y:fIRKW.Z:uC6\u0004x\fJ3r)\u0011\t\u0019)!/\t\u0013\u0005ue$!AA\u0002\u0005=\u0016A\u0006:pY2Lgn\u001a\"bg\u0016$G+[7fgR\fW\u000e\u001d\u0011)\u0007}\ty\fE\u0002`\u0003\u0003L1!a1a\u0005!1x\u000e\\1uS2,\u0017aG0nCb$\u0016.\\3ti\u0006l\u0007/\u00118e\u001f\u001a47/\u001a;T_\u001a\u000b'/\u0006\u0002\u0002JB\u0019A0a3\n\u0007\u00055\u0007LA\bUS6,7\u000f^1na>3gm]3u\u0003}yV.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$be~#S-\u001d\u000b\u0005\u0003\u0007\u000b\u0019\u000eC\u0005\u0002\u001e\u0006\n\t\u00111\u0001\u0002J\u0006ar,\\1y)&lWm\u001d;b[B\fe\u000eZ(gMN,GoU8GCJ\u0004\u0003f\u0001\u0012\u0002@\u0006qR.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$be~#S-\u001d\u000b\u0005\u0003\u0007\u000bi\u000eC\u0004\u0002`\u000e\u0002\r!!3\u0002\u001fQLW.Z:uC6\u0004xJ\u001a4tKR\f!$\\1y)&lWm\u001d;b[B\fe\u000eZ(gMN,GoU8GCJ\f\u0011#\\1y)&lWm\u001d;b[B\u001cvNR1s\u0003eygMZ:fi>3W*\u0019=US6,7\u000f^1naN{g)\u0019:\u00025\r\fgnQ8om\u0016\u0014H\u000fV8SK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\t\u0005=\u00141\u001e\u0005\b\u0003[D\u0003\u0019AA\u0013\u0003\u0019ygMZ:fi\u00061\u0011\r\u001d9f]\u0012$\"\"a!\u0002t\u0006]\u00181`A\u0000\u0011\u001d\t)0\u000ba\u0001\u0003K\tQ\u0002\\1sO\u0016\u001cHo\u00144gg\u0016$\bbBA}S\u0001\u0007\u0011QE\u0001\u0011Y\u0006\u0014x-Z:u)&lWm\u001d;b[BDq!!@*\u0001\u0004\t)#A\u000etQ\u0006dGn\\<PM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e\u001d\u0005\b\u0005\u0003I\u0003\u0019\u0001B\u0002\u0003\u001d\u0011XmY8sIN\u00042\u0001\u001cB\u0003\u0013\r\u00119!\u001c\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\u0007%\u0012Y\u0001E\u0002f\u0005\u001bI1Aa\u0004g\u00055qwN\u001c;ie\u0016\fGm]1gK\u0006\u0019RM\\:ve\u0016|eMZ:fi&s'+\u00198hKR!\u00111\u0011B\u000b\u0011\u001d\tiO\u000ba\u0001\u0003K\t1#\u00199qK:$7\t[;oW\u001a\u0013x.\u001c$jY\u0016$\u0002\"!\r\u0003\u001c\tu!\u0011\u0005\u0005\u0007\u0005\u0003Y\u0003\u0019A6\t\u000f\t}1\u00061\u0001\u00022\u0005A\u0001o\\:ji&|g\u000eC\u0004\u0003$-\u0002\rA!\n\u0002\u001d\t,hMZ3s'V\u0004\b\u000f\\5feB!\u00111\tB\u0014\u0013\u0011\u0011I#!\u0012\u0003\u001d\t+hMZ3s'V\u0004\b\u000f\\5fe\u0006q\u0011\r\u001d9f]\u00124%o\\7GS2,GCBA\u0019\u0005_\u0011\t\u0004\u0003\u0004\u0003\u00021\u0002\ra\u001b\u0005\b\u0005ga\u0003\u0019AA\u0019\u0003\u0015\u0019H/\u0019:u\u00039)\b\u000fZ1uKRCh.\u00138eKb$b!a!\u0003:\t\r\u0003b\u0002B\u001e[\u0001\u0007!QH\u0001\rG>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\t\u0004y\n}\u0012b\u0001B!1\na1i\\7qY\u0016$X\r\u001a+y]\"9!QI\u0017A\u0002\u0005\u0015\u0012\u0001\u00057bgR\u001cF/\u00192mK>3gm]3uQ\ri#1B\u0001\u0014kB$\u0017\r^3Qe>$WoY3s'R\fG/\u001a\u000b\u0007\u0003\u0007\u0013iEa\u0016\t\u000f\t=c\u00061\u0001\u0003R\u0005!\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u00042\u0001 B*\u0013\r\u0011)\u0006\u0017\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\t\u000f\tec\u00061\u0001\u0003\\\u0005)!-\u0019;dQB\u0019AN!\u0018\n\u0007\t}SNA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0017a\u0004;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;\u0015\r\t\u0015$Q\u0012BH!\u0011\u00119Ga\"\u000f\t\t%$1\u0011\b\u0005\u0005W\u0012\tI\u0004\u0003\u0003n\t}d\u0002\u0002B8\u0005{rAA!\u001d\u0003|9!!1\u000fB=\u001b\t\u0011)HC\u0002\u0003xq\u000ba\u0001\u0010:p_Rt\u0014\"A;\n\u0005M$\u0018BA.s\u0013\t\u0001\u0018/\u0003\u0002o_&\u0019!QQ7\u0002\u0017\u0019KG.\u001a*fG>\u0014Hm]\u0005\u0005\u0005\u0013\u0013YIA\tM_\u001e|eMZ:fiB{7/\u001b;j_:T1A!\"n\u0011\u001d\tio\fa\u0001\u0003KA\u0011B!%0!\u0003\u0005\r!!\r\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\ry#Q\u0013\t\u0004K\n]\u0015b\u0001BMM\nQA\u000f\u001b:fC\u0012\u001c\u0018MZ3\u00023Q\u0014\u0018M\\:mCR,wJ\u001a4tKR$C-\u001a4bk2$HEM\u000b\u0003\u0005?SC!!\r\u0003\".\u0012!1\u0015\t\u0005\u0005K\u0013y+\u0004\u0002\u0003(*!!\u0011\u0016BV\u0003%)hn\u00195fG.,GMC\u0002\u0003.\u0002\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tLa*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003sK\u0006$GC\u0003B\\\u0005\u0007\u00149Ma3\u0003PB!!\u0011\u0018B`\u001b\t\u0011YLC\u0002\u0003>j\u000baa]3sm\u0016\u0014\u0018\u0002\u0002Ba\u0005w\u0013QBR3uG\"$\u0015\r^1J]\u001a|\u0007b\u0002Bcc\u0001\u0007\u0011QE\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0003JF\u0002\r!!\r\u0002\u000f5\f\u0007pU5{K\"I!QZ\u0019\u0011\u0002\u0003\u0007\u0011QE\u0001\f[\u0006D\bk\\:ji&|g\u000eC\u0005\u0003RF\u0002\n\u00111\u0001\u0002p\u0005iQ.\u001b8P]\u0016lUm]:bO\u0016D3!\rBK\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIM*\"A!7+\t\u0005\u0015\"\u0011U\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yN\u000b\u0003\u0002p\t\u0005\u0016!\u00064fi\u000eDW\u000b\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u000b\u0007\u0003_\u0013)Oa<\t\u000f\t\u001dH\u00071\u0001\u0003j\u0006\u00192\u000f^1si>3gm]3u!>\u001c\u0018\u000e^5p]B\u0019APa;\n\u0007\t5\bL\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000f\tEH\u00071\u0001\u00022\u0005Ia-\u001a;dQNK'0Z\u0001\be\u0016\u001cwN^3s)\u0019\t\tDa>\u0003z\"9!qJ\u001bA\u0002\tE\u0003\"\u0003B~kA\u0005\t\u0019\u0001B\u007f\u0003AaW-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rE\u0003`\u0003c\u0013y\u0010\u0005\u0003\u0004\u0002\r\u001dQBAB\u0002\u0015\u0011\u0019)Aa/\u0002\u000b\u0015\u0004xn\u00195\n\t\r%11\u0001\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3)\u0007U\u0012Y!A\tsK\u000e|g/\u001a:%I\u00164\u0017-\u001e7uII*\"a!\u0005+\t\tu(\u0011U\u0001\u0015Y>\fG\rT1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9\u0015\u0005\u0005\r\u0015a\u00035bg>3XM\u001d4m_^,\"!a\u001c\u0002%\r|G\u000e\\3di\u0006\u0013wN\u001d;fIRChn\u001d\u000b\u0007\u0007?\u0019)c!\u000b\u0011\u0007q\u001c\t#C\u0002\u0004$a\u0013A\u0003\u0016=o\u0013:$W\r_*fCJ\u001c\u0007NU3tk2$\bbBB\u0014s\u0001\u0007\u0011QE\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0004,e\u0002\r!!\n\u0002!U\u0004\b/\u001a:C_VtGm\u00144gg\u0016$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\rE\u0002\u0003BB\u001a\u0007wqAa!\u000e\u00048A\u0019!1\u000f1\n\u0007\re\u0002-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007{\u0019yD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0007s\u0001\u0017A\u0003;sk:\u001c\u0017\r^3U_R!\u0011\u0011GB#\u0011\u001d\tio\u000fa\u0001\u0003KA3a\u000fB\u0006\u00039\u0011X-\u00193OKb$xJ\u001a4tKRD3\u0001\u0010BK\u0003\u00151G.^:iQ\ri$QS\u0001\u0010kB$\u0017\r^3QCJ,g\u000e\u001e#jeR!\u00111QB+\u0011\u001d\u00199F\u0010a\u0001\u00073\n1\u0001Z5s!\u0011\u0019Yf!\u001a\u000e\u0005\ru#\u0002BB0\u0007C\n!![8\u000b\u0005\r\r\u0014\u0001\u00026bm\u0006LAaa\u001a\u0004^\t!a)\u001b7f\u0003I\u0019\u0007.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:\u0015\r\u0005\r5QNB9\u0011\u001d\u0019yg\u0010a\u0001\u0007c\t\u0011b\u001c7e'V4g-\u001b=\t\u000f\rMt\b1\u0001\u00042\u0005Ia.Z<Tk\u001a4\u0017\u000e_\u0001\u0018_:\u0014UmY8nK&s\u0017m\u0019;jm\u0016\u001cVmZ7f]R\fq\u0003\\8bI\u001aK'o\u001d;CCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9\u0002#QLW.Z,bSR,GMR8s%>dG\u000e\u0006\u0004\u0002&\ru4\u0011\u0011\u0005\b\u0007\u007f\u0012\u0005\u0019AA\u0013\u0003\rqwn\u001e\u0005\b\u0007\u0007\u0013\u0005\u0019AA\u0013\u0003AiWm]:bO\u0016$\u0016.\\3ti\u0006l\u0007/\u0001\fhKR4\u0015N]:u\u0005\u0006$8\r\u001b+j[\u0016\u001cH/Y7q)\t\t)#A\u000bgS:$wJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9\u0015\r\r55QSBM!\u0015y\u0016\u0011WBH!\u0011\u00119g!%\n\t\rM%1\u0012\u0002\u0013)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fC\u0004\u0004\u0018\u0012\u0003\r!!\n\u0002\u0013QLW.Z:uC6\u0004\b\"CBN\tB\u0005\t\u0019AA\u0013\u00039\u0019H/\u0019:uS:<wJ\u001a4tKR\fqDZ5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003\u0015\u0019Gn\\:f\u00035\u0019Gn\\:f\u0011\u0006tG\r\\3sg\u0006qA-\u001a7fi\u0016Le-\u0012=jgR\u001c\u0018\u0001\u00047bgRlu\u000eZ5gS\u0016$\u0017A\u00067be\u001e,7\u000f\u001e*fG>\u0014H\rV5nKN$\u0018-\u001c9\u0002!1\f7\u000f^'pI&4\u0017.\u001a3`I\u0015\fH\u0003BBW\u0007{\u0003Baa,\u0004:6\u00111\u0011\u0017\u0006\u0005\u0007g\u001b),\u0001\u0003gS2,'\u0002BB\\\u0007C\n1A\\5p\u0013\u0011\u0019Yl!-\u0003\tA\u000bG\u000f\u001b\u0005\b\u0007\u007fc\u0005\u0019AA\u0013\u0003\ti7\u000fK\u0002\u0001\u0005\u0017\t!\u0002T8h'\u0016<W.\u001a8u!\tahj\u0005\u0002O=R\u00111QY\u0001\u0005_B,g\u000e\u0006\n\u0002R\r=7\u0011[Bj\u0007;\u001cyna9\u0004h\u000e-\bbBB,!\u0002\u00071\u0011\f\u0005\b\u0003C\u0001\u0006\u0019AA\u0013\u0011\u001d\u0019)\u000e\u0015a\u0001\u0007/\faaY8oM&<\u0007c\u0001?\u0004Z&\u001911\u001c-\u0003\u00131{wmQ8oM&<\u0007bBA\u001f!\u0002\u0007\u0011\u0011\t\u0005\n\u0007C\u0004\u0006\u0013!a\u0001\u0003_\n\u0011CZ5mK\u0006c'/Z1es\u0016C\u0018n\u001d;t\u0011%\u0019)\u000f\u0015I\u0001\u0002\u0004\t\t$\u0001\u0007j]&$h)\u001b7f'&TX\rC\u0005\u0004jB\u0003\n\u00111\u0001\u0002p\u0005Y\u0001O]3bY2|7-\u0019;f\u0011%\u0019i\u000f\u0015I\u0001\u0002\u0004\u0019\t$\u0001\u0006gS2,7+\u001e4gSb\fab\u001c9f]\u0012\"WMZ1vYR$S'\u0001\bpa\u0016tG\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d=\u0004XM\u001c\u0013eK\u001a\fW\u000f\u001c;%o\u0005qq\u000e]3oI\u0011,g-Y;mi\u0012BTCAB}U\u0011\u0019\tD!)\u0015\u0011\u0005\r5Q`B\u0000\t\u0003Aqaa\u0016V\u0001\u0004\u0019I\u0006C\u0004\u0002\"U\u0003\r!!\n\t\u0013\r5X\u000b%AA\u0002\rE\u0012\u0001\u00073fY\u0016$X-\u00134Fq&\u001cHo\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile TimestampOffset _maxTimestampAndOffsetSoFar;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return "";
    }

    public static String open$default$8() {
        return "";
    }

    public static boolean open$default$7() {
        return false;
    }

    public static int open$default$6() {
        return 0;
    }

    public static boolean open$default$5() {
        return false;
    }

    public static LogSegment open(File dir, long baseOffset, LogConfig config, Time time, boolean fileAlreadyExists, int initFileSize, boolean preallocate, String fileSuffix) {
        return LogSegment$.MODULE$.open(dir, baseOffset, config, time, fileAlreadyExists, initFileSize, preallocate, fileSuffix);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        if (this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated) {
                this.timeIndex().resize(0);
            }
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private TimestampOffset _maxTimestampAndOffsetSoFar() {
        return this._maxTimestampAndOffsetSoFar;
    }

    private void _maxTimestampAndOffsetSoFar_$eq(TimestampOffset x$1) {
        this._maxTimestampAndOffsetSoFar = x$1;
    }

    public void maxTimestampAndOffsetSoFar_$eq(TimestampOffset timestampOffset) {
        this._maxTimestampAndOffsetSoFar_$eq(timestampOffset);
    }

    public TimestampOffset maxTimestampAndOffsetSoFar() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset$.MODULE$.Unknown();
        if (!(timestampOffset != null ? !((Object)timestampOffset).equals(timestampOffset2) : timestampOffset2 != null)) {
            this._maxTimestampAndOffsetSoFar_$eq(this.timeIndex().lastEntry());
        }
        return this._maxTimestampAndOffsetSoFar();
    }

    public long maxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().timestamp();
    }

    public long offsetOfMaxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().offset();
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(45).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").toString()).append(new StringBuilder(42).append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString()).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = this.log().append(records);
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(largestTimestamp, shallowOffsetOfMaxTimestamp));
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.offsetIndex().append(largestOffset, physicalPosition);
                TimeIndex qual$1 = this.timeIndex();
                long x$1 = this.maxTimestampSoFar();
                long x$2 = this.offsetOfMaxTimestampSoFar();
                boolean x$3 = qual$1.maybeAppend$default$3();
                qual$1.maybeAppend(x$1, x$2, x$3);
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        CollectionConverters$.MODULE$.IterableHasAsScala(records.batchesFrom(position)).asScala().iterator().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin$Replication$.MODULE$);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, (Option<LogOffsetMetadata>)None$.MODULE$);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, scala.math.package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n = adjustedMaxSize = minOneMessage ? scala.math.package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, false, (Option<List<FetchResponseData.AbortedTransaction>>)None$.MODULE$);
        }
        int fetchSize = scala.math.package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, (Option<List<FetchResponseData.AbortedTransaction>>)None$.MODULE$);
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampAndOffsetSoFar_$eq(TimestampOffset$.MODULE$.Unknown());
        try {
            CollectionConverters$.MODULE$.IterableHasAsScala(this.log().batches()).asScala().foreach((Function1 & Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException;
            if (bl) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampAndOffsetSoFar_$eq(lastTimeIndexEntry);
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.TimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(maxTimestampOffsetAfterLastEntry.timestamp, maxTimestampOffsetAfterLastEntry.offset));
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.txnIndex().truncateTo(offset);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        return bytesTruncated;
    }

    public long readNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        if (fetchData == null) {
            return this.baseOffset();
        }
        return BoxesRunTime.unboxToLong((Object)CollectionConverters$.MODULE$.IterableHasAsScala(fetchData.records().batches()).asScala().lastOption().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.baseOffset()));
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateParentDir(File dir) {
        this.log().updateParentDir(dir);
        this.lazyOffsetIndex().updateParentDir(dir);
        this.lazyTimeIndex().updateParentDir(dir);
        this.txnIndex().updateParentDir(dir);
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.lazyOffsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.lazyTimeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FileRecords.TimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(scala.math.package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset));
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset$.MODULE$.Unknown();
        if (timestampOffset == null ? timestampOffset2 != null : !((Object)timestampOffset).equals(timestampOffset2)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, Level.WARN);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyOffsetIndex().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyTimeIndex().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.log().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.txnIndex().close(), this, Level.WARN);
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyOffsetIndex().closeHandler(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.lazyTimeIndex().closeHandler(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.log().closeHandlers(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.txnIndex().close(), this, Level.WARN);
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.log().file();
            String delete$1_fileType = "log";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$4(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyOffsetIndex().file();
            String delete$1_fileType = "offset index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$6(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyTimeIndex().file();
            String delete$1_fileType = "time index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$8(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (JFunction0.mcV.sp & Serializable)() -> {
            boolean bl = false;
            File delete$1_file = this.txnIndex().file();
            String delete$1_fileType = "transaction index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$10(this)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }}))));
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.maxTimestampSoFar()));
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.lastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0 && cache.latestEpoch().forall((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) {
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.ensureOffsetInRange(batch.lastOffset());
        if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
            $this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(batch.maxTimestamp(), batch.lastOffset()));
        }
        if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
            $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
            TimeIndex qual$1 = $this.timeIndex();
            long x$1 = $this.maxTimestampSoFar();
            long x$2 = $this.offsetOfMaxTimestampSoFar();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
            lastIndexEntry$1.elem = validBytes$1.elem;
        }
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            leaderEpochCache$1.foreach((Function1 & Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch);
        }
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$4(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$6(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$8(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$10(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampAndOffsetSoFar = TimestampOffset$.MODULE$.Unknown();
    }
}

