/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.admin.BrokerMetadata;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0015h\u0001\u0002\u0014(\u00019B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\"9Q\n\u0001a\u0001\n\u0013q\u0005b\u0002.\u0001\u0001\u0004%Ia\u0017\u0005\u0007C\u0002\u0001\u000b\u0015B(\t\u000f\u0019\u0004!\u0019!C\u0005O\"1a\u000e\u0001Q\u0001\n!DQa\u001c\u0001\u0005\nADq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u00111\u0016\u0001\u0005\n\u00055\u0006bBAa\u0001\u0011\u0005\u00131\u0019\u0005\n\u0003O\u0004\u0011\u0013!C\u0001\u0003SD\u0011\"a@\u0001#\u0003%\t!!;\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!Q\u0001\u0001\u0005B\t\u001d\u0001b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u00053\u0001A\u0011\tB\u000e\u0011\u001d\u0011I\u0002\u0001C\u0005\u0005_AqAa\r\u0001\t\u0003\u0012)\u0004C\u0004\u0003<\u0001!\tE!\u0010\t\u000f\t\r\u0003\u0001\"\u0011\u0003F!9!Q\f\u0001\u0005B\t}\u0003b\u0002B3\u0001\u0011\u0005#q\r\u0005\b\u0005_\u0002A\u0011\tB9\u0011\u001d\u0011y\b\u0001C!\u0005\u0003CqAa!\u0001\t\u0013\u0011)\tC\u0004\u0003\n\u0002!\tEa#\t\u000f\te\u0005\u0001\"\u0001\u0003\u001c\"9!Q\u0014\u0001\u0005\u0002\t}\u0005b\u0002BS\u0001\u0011\u0005#q\u0015\u0005\b\u0005K\u0003A\u0011\tBV\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005cCqAa.\u0001\t\u0003\u0012I\fC\u0004\u0003P\u0002!\tA!5\u0003%-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0006\u0003Q%\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003U-\naa]3sm\u0016\u0014(\"\u0001\u0017\u0002\u000b-\fgm[1\u0004\u0001M)\u0001aL\u001b:\u007fA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001c\u000e\u0003%J!\u0001O\u0015\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f!\tQT(D\u0001<\u0015\ta4&A\u0003vi&d7/\u0003\u0002?w\t9Aj\\4hS:<\u0007C\u0001!B\u001b\u00059\u0013B\u0001\"(\u0005A\u0019uN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005ce>\\WM]%e+\u0005)\u0005C\u0001\u0019G\u0013\t9\u0015GA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\rqJg.\u001b;?)\tYE\n\u0005\u0002A\u0001!)1i\u0001a\u0001\u000b\u0006iqlY;se\u0016tG/S7bO\u0016,\u0012a\u0014\t\u0003!bk\u0011!\u0015\u0006\u0003%N\u000bQ![7bO\u0016T!\u0001\f+\u000b\u0005U3\u0016AB1qC\u000eDWMC\u0001X\u0003\ry'oZ\u0005\u00033F\u0013Q\"T3uC\u0012\fG/Y%nC\u001e,\u0017!E0dkJ\u0014XM\u001c;J[\u0006<Wm\u0018\u0013fcR\u0011Al\u0018\t\u0003auK!AX\u0019\u0003\tUs\u0017\u000e\u001e\u0005\bA\u0016\t\t\u00111\u0001P\u0003\rAH%M\u0001\u000f?\u000e,(O]3oi&k\u0017mZ3!Q\t11\r\u0005\u00021I&\u0011Q-\r\u0002\tm>d\u0017\r^5mK\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0003!\u0004\"!\u001b7\u000e\u0003)T!a[\u0016\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002nU\n\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000fI\u0001\u0019[\u0006L(-\u001a$jYR,'/\u00117jm\u0016\u0014V\r\u001d7jG\u0006\u001cH\u0003C9\u0000\u0003\u0003\tY!a\b\u0011\u0007I<\u00180D\u0001t\u0015\t!X/\u0001\u0003vi&d'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u0014A\u0001T5tiB\u0011!0`\u0007\u0002w*\u0011A0^\u0001\u0005Y\u0006tw-\u0003\u0002\u007fw\n9\u0011J\u001c;fO\u0016\u0014\b\"\u0002*\n\u0001\u0004y\u0005bBA\u0002\u0013\u0001\u0007\u0011QA\u0001\bEJ|7.\u001a:t!\u0011\u0001\u0014qA#\n\u0007\u0005%\u0011GA\u0003BeJ\f\u0017\u0010C\u0004\u0002\u000e%\u0001\r!a\u0004\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u00059a.\u001a;x_J\\'bAA\r'\u000611m\\7n_:LA!!\b\u0002\u0014\taA*[:uK:,'OT1nK\"9\u0011\u0011E\u0005A\u0002\u0005\r\u0012A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bc\u0001\u0019\u0002&%\u0019\u0011qE\u0019\u0003\u000f\t{w\u000e\\3b]\u0006a1-\u001e:sK:$\u0018*\\1hKR\tq*\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\r\u0003c\t)(a\u001e\u0002\f\u00065\u0015\u0011\u0013\t\u0006a\u0005M\u0012qG\u0005\u0004\u0003k\t$AB(qi&|g\u000e\u0005\u0004\u0002:\u0005%\u0013q\n\b\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\rSBAA \u0015\r\t\t%L\u0001\u0007yI|w\u000e\u001e \n\u0003IJ1!a\u00122\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0013\u0002N\tA\u0011\n^3sCR|'OC\u0002\u0002HE\u0002B!!\u0015\u0002p9!\u00111KA5\u001d\u0011\t)&!\u001a\u000f\t\u0005]\u00131\r\b\u0005\u00033\n\tG\u0004\u0003\u0002\\\u0005}c\u0002BA\u001f\u0003;J\u0011aV\u0005\u0003+ZK!\u0001\f+\n\u0007\u0005e1+\u0003\u0003\u0002h\u0005]\u0011aB7fgN\fw-Z\u0005\u0005\u0003W\ni'\u0001\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0003O\n9\"\u0003\u0003\u0002r\u0005M$!G'fi\u0006$\u0017\r^1SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:TA!a\u001b\u0002n!)!k\u0003a\u0001\u001f\"9\u0011\u0011P\u0006A\u0002\u0005m\u0014!\u0003;pa&\u001cg*Y7f!\u0011\ti(!\"\u000f\t\u0005}\u0014\u0011\u0011\t\u0004\u0003{\t\u0014bAABc\u00051\u0001K]3eK\u001aLA!a\"\u0002\n\n11\u000b\u001e:j]\u001eT1!a!2\u0011\u001d\tia\u0003a\u0001\u0003\u001fAq!a$\f\u0001\u0004\t\u0019#A\rfeJ|'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bbBAJ\u0017\u0001\u0007\u00111E\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\nhKR|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006\u001cHcB9\u0002\u001a\u0006m\u0015\u0011\u0016\u0005\u0006%2\u0001\ra\u0014\u0005\b\u0003;c\u0001\u0019AAP\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0002\"\u0006\u0015VBAAR\u0015\tA3+\u0003\u0003\u0002(\u0006\r&!\u0006)beRLG/[8o%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\b\u0003\u001ba\u0001\u0019AA\b\u0003A9W\r^!mSZ,WI\u001c3q_&tG\u000f\u0006\u0005\u00020\u0006e\u00161XA`!\u0015\u0001\u00141GAY!\u0011\t\u0019,!.\u000e\u0005\u0005]\u0011\u0002BA\\\u0003/\u0011AAT8eK\")!+\u0004a\u0001\u001f\"1\u0011QX\u0007A\u0002\u0015\u000b!!\u001b3\t\u000f\u00055Q\u00021\u0001\u0002\u0010\u0005\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0003\u000b\f9.!9\u0002d\u0006\u0015\bCBAd\u0003\u001b\f\t.\u0004\u0002\u0002J*\u0019\u00111Z\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002P\u0006%'aA*fcB!\u0011\u0011KAj\u0013\u0011\t).a\u001d\u0003+5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,Gk\u001c9jG\"9\u0011\u0011\u001c\bA\u0002\u0005m\u0017A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002H\u0006u\u00171P\u0005\u0005\u0003?\fIMA\u0002TKRDq!!\u0004\u000f\u0001\u0004\ty\u0001C\u0005\u0002\u0010:\u0001\n\u00111\u0001\u0002$!I\u00111\u0013\b\u0011\u0002\u0003\u0007\u00111E\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0003WTC!a\t\u0002n.\u0012\u0011q\u001e\t\u0005\u0003c\fY0\u0004\u0002\u0002t*!\u0011Q_A|\u0003%)hn\u00195fG.,GMC\u0002\u0002zF\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti0a=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$C'\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7\u000f\u0006\u0002\u0002\\\u0006\u0011r-\u001a;U_BL7\rU1si&$\u0018n\u001c8t)\u0011\u0011IA!\u0005\u0011\r\u0005\u001d\u0017Q\u001cB\u0006!\u0011\t\u0019L!\u0004\n\t\t=\u0011q\u0003\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tIH\u0005a\u0001\u0003w\na\u0002[1t\u00032Lg/\u001a\"s_.,'\u000f\u0006\u0003\u0002$\t]\u0001\"B\"\u0014\u0001\u0004)\u0015aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\u0005\tu\u0001CBA\u001d\u0005?\u0011\u0019#\u0003\u0003\u0003\"\u00055#\u0001C%uKJ\f'\r\\3\u0011\t\t\u0015\"1F\u0007\u0003\u0005OQ1A!\u000b,\u0003\u0015\tG-\\5o\u0013\u0011\u0011iCa\n\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR!!Q\u0004B\u0019\u0011\u0015\u0011V\u00031\u0001P\u0003I9W\r^!mSZ,'I]8lKJtu\u000eZ3\u0015\r\u0005=&q\u0007B\u001d\u0011\u0015\u0019e\u00031\u0001F\u0011\u001d\tiA\u0006a\u0001\u0003\u001f\t1cZ3u\u00032Lg/\u001a\"s_.,'OT8eKN$BAa\u0010\u0003BA1\u0011qYAg\u0003cCq!!\u0004\u0018\u0001\u0004\ty!\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R1!q\tB,\u00053\u0002R\u0001MA\u001a\u0005\u0013\u0002BAa\u0013\u0003R9!\u00111\u000bB'\u0013\u0011\u0011y%!\u001c\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005'\u0012)F\u0001\u000fVa\u0012\fG/Z'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\t\t=\u0013Q\u000e\u0005\b\u0003sB\u0002\u0019AA>\u0011\u0019\u0011Y\u0006\u0007a\u0001\u000b\u0006Y\u0001/\u0019:uSRLwN\\%e\u00035qW/\u001c)beRLG/[8ogR!!\u0011\rB2!\u0011\u0001\u00141G#\t\u000f\u0005e\u0014\u00041\u0001\u0002|\u0005Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA\u0011q\u0016B5\u0005W\u0012i\u0007C\u0004\u0002zi\u0001\r!a\u001f\t\r\tm#\u00041\u0001F\u0011\u001d\tiA\u0007a\u0001\u0003\u001f\tAdZ3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000f\u0006\u0004\u0003t\te$Q\u0010\t\b\u0003{\u0012)(RAY\u0013\u0011\u00119(!#\u0003\u00075\u000b\u0007\u000fC\u0004\u0003|m\u0001\rAa\u0003\u0002\u0005Q\u0004\bbBA\u00077\u0001\u0007\u0011qB\u0001\u0010O\u0016$8i\u001c8ue>dG.\u001a:JIV\u0011!\u0011M\u0001\u0015O\u0016$(+\u00198e_6\fE.\u001b<f\u0005J|7.\u001a:\u0015\t\t\u0005$q\u0011\u0005\u0006%v\u0001\raT\u0001\u0013O\u0016$8\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0003\u000e\nM%q\u0013\t\u0005\u0003g\u0013y)\u0003\u0003\u0003\u0012\u0006]!aB\"mkN$XM\u001d\u0005\b\u0005+s\u0002\u0019AA>\u0003%\u0019G.^:uKJLE\rC\u0004\u0002\u000ey\u0001\r!a\u0004\u0002/M$\u0018\r^3DQ\u0006tw-\u001a+sC\u000e,WI\\1cY\u0016$GCAA\u0012\u0003MawnZ*uCR,7\t[1oO\u0016$&/Y2f)\ra&\u0011\u0015\u0005\b\u0005G\u0003\u0003\u0019AA>\u0003\r\u0019HO]\u0001\tG>tG/Y5ogR!\u00111\u0005BU\u0011\u001d\tI(\ta\u0001\u0003w\"B!a\t\u0003.\"9!1\u0010\u0012A\u0002\t-\u0011\u0001C:fi&k\u0017mZ3\u0015\u0007q\u0013\u0019\f\u0003\u0004\u00036\u000e\u0002\raT\u0001\t]\u0016<\u0018*\\1hK\u000611m\u001c8gS\u001e$BAa/\u0003BB\u0019!O!0\n\u0007\t}6O\u0001\u0006Qe>\u0004XM\u001d;jKNDqAa1%\u0001\u0004\u0011)-\u0001\bd_:4\u0017n\u001a*fg>,(oY3\u0011\t\t\u001d'1Z\u0007\u0003\u0005\u0013TAAa.\u0002\u0018%!!Q\u001aBe\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\fA\u0003Z3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001cH\u0003\u0002Bj\u00057\u0004BA!6\u0003X6\u0011\u0011QN\u0005\u0005\u00053\fiG\u0001\u0011EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fgB|gn]3ECR\f\u0007b\u0002BoK\u0001\u0007!q\\\u0001\be\u0016\fX/Z:u!\u0011\u0011)N!9\n\t\t\r\u0018Q\u000e\u0002 \t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:SKF,Xm\u001d;ECR\f\u0007")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        None$ none$;
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            none$ = new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                MetadataResponseData.MetadataResponsePartition metadataResponsePartition;
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(47).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").toString()).append(new StringBuilder(20).append("not found on leader ").append(partition$1.leader).toString()).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    metadataResponsePartition = new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                } else if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.intArrayOps(partition.replicas))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(75).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").toString()).append(new StringBuilder(18).append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString()).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.intArrayOps(partition.isr))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(83).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").toString()).append(new StringBuilder(18).append("following brokers ").append(Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString()).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    metadataResponsePartition = new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                } else {
                    throw new MatchError(maybeLeader);
                }
                return metadataResponsePartition;
            })).iterator());
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(image, offlineReplicas, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Set set;
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            set = (Set)Set$.MODULE$.empty();
        } else if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            set = (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$2 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$2)));
        } else {
            throw new MatchError((Object)option);
        }
        return set;
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$3))) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getAliveBrokers$1(x$4)))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(b.rack()))));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).flatMap((Function1 & Serializable)x$5 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$5.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getAliveBrokerNodes$1(x$6)))).flatMap((Function1 & Serializable)x$7 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$7.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> new Some(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch)));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        None$ none$;
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            None$ none$2;
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                none$2 = None$.MODULE$;
            } else if (option2 instanceof Some) {
                Some some;
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    some = new Some((Object)Node.noNode());
                } else if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    some = new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                } else {
                    throw new MatchError((Object)option3);
                }
                none$2 = some;
            } else {
                throw new MatchError((Object)option2);
            }
            none$ = none$2;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(result, image, listenerName, topic);
            return BoxedUnit.UNIT;
        });
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.size() == 0) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply(ThreadLocalRandom.current().nextInt(aliveBrokers.size()))).id()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().entrySet().forEach(entry -> {
            Integer partitionId = (Integer)entry.getKey();
            PartitionRegistration partition = (PartitionRegistration)entry.getValue();
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, partition, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> str);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        boolean bl;
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            bl = ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(MetadataImage image$3, ArrayList offlineReplicas$1, ListenerName listenerName$3, int brokerId) {
        Boolean bl;
        Option option = Option$.MODULE$.apply((Object)image$3.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            bl = BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        } else if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            bl = broker.fenced() || !broker.listeners().containsKey(listenerName$3.value()) ? BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId))) : BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$3) {
        return !x$3.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getAliveBrokers$1(BrokerRegistration x$4) {
        return !x$4.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getAliveBrokerNodes$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ Option $anonfun$getPartitionReplicaEndpoints$3(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, int x0$2) {
        Node node;
        Integer n = BoxesRunTime.boxToInteger((int)x0$2);
        Option option = Option$.MODULE$.apply((Object)image$5.cluster().broker(x0$2));
        if (None$.MODULE$.equals(option)) {
            node = Node.noNode();
        } else if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            node = (Node)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName$8.value()))).getOrElse((Function0 & Serializable)() -> Node.noNode());
        } else {
            throw new MatchError((Object)option);
        }
        return result$1.put((Object)n, (Object)node);
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(scala.collection.mutable.HashMap result$1, MetadataImage image$5, ListenerName listenerName$8, TopicImage topic) {
        topic.partitions().values().forEach(x0$1 -> ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(x0$1.replicas), (Function1 & Serializable)x0$2 -> KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$3(result$1, image$5, listenerName$8, BoxesRunTime.unboxToInt((Object)x0$2)), ClassTag$.MODULE$.apply(Option.class)));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

