/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.StressTestLog$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Records;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mr!B\u0011#\u0011\u0003)c!B\u0014#\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%\tA\r\u0005\u0007\u007f\u0005\u0001\u000b\u0011B\u001a\t\u000b\u0001\u000bA\u0011A!\u0007\u000bU\u000b\u0011\u0011\u0001,\t\u000b=2A\u0011A/\t\u000f\u00014!\u0019!C\u0001C\"1AM\u0002Q\u0001\n\tDQ!\u001a\u0004\u0005B\u0019DQa\u001a\u0004\u0007\u0002\u0019DQ\u0001\u001b\u0004\u0007\u0002%4q!\\\u0001\u0011\u0002\u0007\u0005a\u000eC\u0003p\u001b\u0011\u0005a\rC\u0004q\u001b\u0001\u0007I\u0011A9\t\u000fel\u0001\u0019!C\u0001u\"9Q0\u0004a\u0001\n\u0013\t\bb\u0002@\u000e\u0001\u0004%Ia \u0005\n\u0003\u0007i\u0001\u0019!C\u0005\u0003\u000bA\u0011\"!\u0004\u000e\u0001\u0004%I!a\u0004\t\u000b!lA\u0011A5\t\r\u0005MQ\u0002\"\u0001g\r\u0019\t)\"\u0001\u0001\u0002\u0018!Q\u00111D\f\u0003\u0006\u0004%\t!!\b\t\u0015\u0005%rC!A!\u0002\u0013\ty\u0002\u0003\u00040/\u0011\u0005\u00111\u0006\u0005\u0006O^!\tE\u001a\u0004\u0007\u0003c\t\u0001!a\r\t\u0015\u0005mAD!b\u0001\n\u0003\ti\u0002\u0003\u0006\u0002*q\u0011\t\u0011)A\u0005\u0003?Aaa\f\u000f\u0005\u0002\u0005U\u0002\"B4\u001d\t\u00032\u0017!D*ue\u0016\u001c8\u000fV3ti2{wMC\u0001$\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AJ\u0001\u000e\u0003\t\u0012Qb\u0015;sKN\u001cH+Z:u\u0019><7CA\u0001*!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!J\u0001\beVtg.\u001b8h+\u0005\u0019\u0004C\u0001\u001b>\u001b\u0005)$B\u0001\u001c8\u0003\u0019\tGo\\7jG*\u0011\u0001(O\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001e<\u0003\u0011)H/\u001b7\u000b\u0003q\nAA[1wC&\u0011a(\u000e\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0011I,hN\\5oO\u0002\nA!\\1j]R\u0011!)\u0012\t\u0003U\rK!\u0001R\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006\r\u0016\u0001\raR\u0001\u0005CJ<7\u000fE\u0002+\u0011*K!!S\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005-\u0013fB\u0001'Q!\ti5&D\u0001O\u0015\tyE%\u0001\u0004=e>|GOP\u0005\u0003#.\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011k\u000b\u0002\r/>\u00148.\u001a:UQJ,\u0017\rZ\n\u0003\r]\u0003\"\u0001W.\u000e\u0003eS!AW\u001e\u0002\t1\fgnZ\u0005\u00039f\u0013a\u0001\u00165sK\u0006$G#\u00010\u0011\u0005}3Q\"A\u0001\u0002\u0015QD'/Z1e\u0013:4w.F\u0001c!\tA6-\u0003\u0002T3\u0006YA\u000f\u001b:fC\u0012LeNZ8!\u0003\r\u0011XO\u001c\u000b\u0002\u0005\u0006!qo\u001c:l\u0003AI7/T1lS:<\u0007K]8he\u0016\u001c8\u000fF\u0001k!\tQ3.\u0003\u0002mW\t9!i\\8mK\u0006t'a\u0003'pOB\u0013xn\u001a:fgN\u001c\"!D\u0015\u0002\r\u0011Jg.\u001b;%\u00035\u0019WO\u001d:f]R|eMZ:fiV\t!\u000f\u0005\u0002+g&\u0011Ao\u000b\u0002\u0004\u0013:$\bFA\bw!\tQs/\u0003\u0002yW\tAao\u001c7bi&dW-A\tdkJ\u0014XM\u001c;PM\u001a\u001cX\r^0%KF$\"AQ>\t\u000fq\u0004\u0012\u0011!a\u0001e\u0006\u0019\u0001\u0010J\u0019\u0002-1\f7\u000f^(gMN,Go\u00115fG.\u0004x.\u001b8uK\u0012\f!\u0004\\1ti>3gm]3u\u0007\",7m\u001b9pS:$X\rZ0%KF$2AQA\u0001\u0011\u001da(#!AA\u0002I\fQ\u0003\\1tiB\u0013xn\u001a:fgN\u001c\u0005.Z2l)&lW-\u0006\u0002\u0002\bA\u0019!&!\u0003\n\u0007\u0005-1F\u0001\u0003M_:<\u0017!\u00077bgR\u0004&o\\4sKN\u001c8\t[3dWRKW.Z0%KF$2AQA\t\u0011!aH#!AA\u0002\u0005\u001d\u0011!D2iK\u000e\\\u0007K]8he\u0016\u001c8O\u0001\u0007Xe&$XM\u001d+ie\u0016\fGm\u0005\u0003\u0018=\u0006e\u0001CA0\u000e\u0003\rawnZ\u000b\u0003\u0003?\u0001B!!\t\u0002&5\u0011\u00111\u0005\u0006\u0004\u00037\u0011\u0013\u0002BA\u0014\u0003G\u00111\u0001T8h\u0003\u0011awn\u001a\u0011\u0015\t\u00055\u0012q\u0006\t\u0003?^Aq!a\u0007\u001b\u0001\u0004\tyB\u0001\u0007SK\u0006$WM\u001d+ie\u0016\fGm\u0005\u0003\u001d=\u0006eA\u0003BA\u001c\u0003s\u0001\"a\u0018\u000f\t\u000f\u0005mq\u00041\u0001\u0002 \u0001")
public final class StressTestLog {
    public static void main(String[] args) {
        StressTestLog$.MODULE$.main(args);
    }

    public static AtomicBoolean running() {
        return StressTestLog$.MODULE$.running();
    }

    public static interface LogProgress {
        public int currentOffset();

        public void currentOffset_$eq(int var1);

        public int kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed();

        public void kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed_$eq(int var1);

        public long kafka$StressTestLog$LogProgress$$lastProgressCheckTime();

        public void kafka$StressTestLog$LogProgress$$lastProgressCheckTime_$eq(long var1);

        default public boolean isMakingProgress() {
            if (this.currentOffset() > this.kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed()) {
                this.kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed_$eq(this.currentOffset());
                return true;
            }
            return false;
        }

        default public void checkProgress() {
            long curTime = System.currentTimeMillis();
            if (curTime - this.kafka$StressTestLog$LogProgress$$lastProgressCheckTime() > 500L) {
                Predef$.MODULE$.require(this.isMakingProgress(), (Function0 & Serializable)() -> "Thread not making progress");
                this.kafka$StressTestLog$LogProgress$$lastProgressCheckTime_$eq(curTime);
            }
        }

        public static void $init$(LogProgress $this) {
            $this.currentOffset_$eq(0);
            $this.kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed_$eq($this.currentOffset());
            $this.kafka$StressTestLog$LogProgress$$lastProgressCheckTime_$eq(System.currentTimeMillis());
        }
    }

    public static class ReaderThread
    extends WorkerThread
    implements LogProgress {
        private final Log log;
        private volatile int currentOffset;
        private int kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed;
        private long kafka$StressTestLog$LogProgress$$lastProgressCheckTime;

        @Override
        public boolean isMakingProgress() {
            return ((LogProgress)this).isMakingProgress();
        }

        @Override
        public void checkProgress() {
            ((LogProgress)this).checkProgress();
        }

        @Override
        public int currentOffset() {
            return this.currentOffset;
        }

        @Override
        public void currentOffset_$eq(int x$1) {
            this.currentOffset = x$1;
        }

        @Override
        public int kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed() {
            return this.kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed;
        }

        @Override
        public void kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed_$eq(int x$1) {
            this.kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed = x$1;
        }

        @Override
        public long kafka$StressTestLog$LogProgress$$lastProgressCheckTime() {
            return this.kafka$StressTestLog$LogProgress$$lastProgressCheckTime;
        }

        @Override
        public void kafka$StressTestLog$LogProgress$$lastProgressCheckTime_$eq(long x$1) {
            this.kafka$StressTestLog$LogProgress$$lastProgressCheckTime = x$1;
        }

        public Log log() {
            return this.log;
        }

        @Override
        public void work() {
            try {
                FileRecords fileRecords;
                Records records = this.log().read((long)this.currentOffset(), 1, (FetchIsolation)FetchLogEnd$.MODULE$, true).records();
                if (records instanceof FileRecords && (fileRecords = (FileRecords)records).sizeInBytes() > 0) {
                    FileLogInputStream.FileChannelRecordBatch first = (FileLogInputStream.FileChannelRecordBatch)fileRecords.batches().iterator().next();
                    Predef$.MODULE$.require(first.lastOffset() == (long)this.currentOffset(), (Function0 & Serializable)() -> "We should either read nothing or the message we asked for.");
                    Predef$.MODULE$.require(first.sizeInBytes() == fileRecords.sizeInBytes(), (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected %d but got %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)first.sizeInBytes()), BoxesRunTime.boxToInteger((int)fileRecords.sizeInBytes())})));
                    this.currentOffset_$eq(this.currentOffset() + 1);
                }
            }
            catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        }

        public ReaderThread(Log log) {
            this.log = log;
            LogProgress.$init$(this);
        }
    }

    public static abstract class WorkerThread
    extends Thread {
        private final String threadInfo = new StringBuilder(16).append("Thread: ").append(Thread.currentThread().getName()).append(" Class: ").append(this.getClass().getName()).toString();

        public String threadInfo() {
            return this.threadInfo;
        }

        @Override
        public void run() {
            try {
                try {
                    while (StressTestLog$.MODULE$.running().get()) {
                        this.work();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                StressTestLog$.MODULE$.running().set(false);
            }
        }

        public abstract void work();

        public abstract boolean isMakingProgress();
    }

    public static class WriterThread
    extends WorkerThread
    implements LogProgress {
        private final Log log;
        private volatile int currentOffset;
        private int kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed;
        private long kafka$StressTestLog$LogProgress$$lastProgressCheckTime;

        @Override
        public boolean isMakingProgress() {
            return ((LogProgress)this).isMakingProgress();
        }

        @Override
        public void checkProgress() {
            ((LogProgress)this).checkProgress();
        }

        @Override
        public int currentOffset() {
            return this.currentOffset;
        }

        @Override
        public void currentOffset_$eq(int x$1) {
            this.currentOffset = x$1;
        }

        @Override
        public int kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed() {
            return this.kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed;
        }

        @Override
        public void kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed_$eq(int x$1) {
            this.kafka$StressTestLog$LogProgress$$lastOffsetCheckpointed = x$1;
        }

        @Override
        public long kafka$StressTestLog$LogProgress$$lastProgressCheckTime() {
            return this.kafka$StressTestLog$LogProgress$$lastProgressCheckTime;
        }

        @Override
        public void kafka$StressTestLog$LogProgress$$lastProgressCheckTime_$eq(long x$1) {
            this.kafka$StressTestLog$LogProgress$$lastProgressCheckTime = x$1;
        }

        public Log log() {
            return this.log;
        }

        @Override
        public void work() {
            LogAppendInfo logAppendInfo = this.log().appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(this.currentOffset()).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, this.log().appendAsLeader$default$3(), this.log().appendAsLeader$default$4(), this.log().appendAsLeader$default$5());
            Predef$.MODULE$.require(logAppendInfo.firstOffset().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WriterThread.$anonfun$work$1(this, x$1))) && logAppendInfo.lastOffset() == (long)this.currentOffset());
            this.currentOffset_$eq(this.currentOffset() + 1);
            if (this.currentOffset() % 1000 == 0) {
                Thread.sleep(50L);
            }
        }

        public static final /* synthetic */ boolean $anonfun$work$1(WriterThread $this, LogOffsetMetadata x$1) {
            return x$1.messageOffset() == (long)$this.currentOffset();
        }

        public WriterThread(Log log) {
            this.log = log;
            LogProgress.$init$(this);
        }
    }
}

