/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsIntegrationTest$LogDirReassignment$;
import kafka.admin.ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$;
import kafka.api.KAFKA_2_7_IV1$;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ZkIsrManager$;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\u0011mb\u0001\u00022d\u0001!DQa\u001c\u0001\u0005\u0002ADqa\u001d\u0001A\u0002\u0013\u0005A\u000fC\u0005\u0002z\u0002\u0001\r\u0011\"\u0001\u0002|\"9\u0011q \u0001!B\u0013)\bb\u0002B\u0001\u0001\u0011\u0005\u0013\u0011\u001d\u0005\n\u00053\u0001!\u0019!C\u0001\u00057A\u0001Ba\f\u0001A\u0003%!Q\u0004\u0005\b\u0005c\u0001A\u0011AAq\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0003CDqAa\u0010\u0001\t\u0003\t\t\u000fC\u0004\u0003D\u0001!\t!!9\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002b\"9!\u0011\n\u0001\u0005\u0002\u0005\u0005\bb\u0002B'\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005#\u0002A\u0011AAq\u0011\u001d\u0011)\u0006\u0001C\u0001\u0003CDqA!\u0017\u0001\t\u0013\u0011Y\u0006C\u0004\u0003l\u0001!IA!\u001c\t\u000f\tU\u0004\u0001\"\u0003\u0003x!9!\u0011\u0011\u0001\u0005\n\t\r\u0005b\u0002BF\u0001\u0011%!Q\u0012\u0005\b\u0005'\u0003A\u0011AAq\u0011\u001d\u00119\n\u0001C\u0001\u0003C4aAa'\u0001\u0001\nu\u0005B\u0003B_1\tU\r\u0011\"\u0001\u0002\u0012!Q!q\u0018\r\u0003\u0012\u0003\u0006I!a\u0005\t\u0015\t\u0005\u0007D!f\u0001\n\u0003\t\t\u0002\u0003\u0006\u0003Db\u0011\t\u0012)A\u0005\u0003'A!B!2\u0019\u0005+\u0007I\u0011AA\t\u0011)\u00119\r\u0007B\tB\u0003%\u00111\u0003\u0005\u0007_b!\tA!3\t\u0013\tM\u0007$!A\u0005\u0002\tU\u0007\"\u0003Bo1E\u0005I\u0011\u0001Bp\u0011%\u0011)\u0010GI\u0001\n\u0003\u0011y\u000eC\u0005\u0003xb\t\n\u0011\"\u0001\u0003`\"I!\u0011 \r\u0002\u0002\u0013\u0005#1 \u0005\n\u0005{D\u0012\u0011!C\u0001\u0005\u007fD\u0011b!\u0001\u0019\u0003\u0003%\taa\u0001\t\u0013\r5\u0001$!A\u0005B\r=\u0001\"CB\f1\u0005\u0005I\u0011AB\r\u0011%\u0019\u0019\u0003GA\u0001\n\u0003\u001a)\u0003C\u0005\u0004*a\t\t\u0011\"\u0011\u0004,!I1Q\u0006\r\u0002\u0002\u0013\u00053q\u0006\u0005\n\u0007cA\u0012\u0011!C!\u0007g9\u0011ba\u000e\u0001\u0003\u0003E\ta!\u000f\u0007\u0013\tm\u0005!!A\t\u0002\rm\u0002BB8/\t\u0003\u0019i\u0005C\u0005\u0004.9\n\t\u0011\"\u0012\u00040!I1q\n\u0018\u0002\u0002\u0013\u00055\u0011\u000b\u0005\n\u00073r\u0013\u0011!CA\u00077Bqa!\u001c\u0001\t\u0013\u0019y\u0007C\u0004\u0004\n\u0002!Iaa#\t\u000f\r5\u0006\u0001\"\u0003\u00040\"911\u0018\u0001\u0005\n\ru\u0006bBBh\u0001\u0011%1\u0011\u001b\u0004\u0007\u0007S\u0004\u0001aa;\t\u0015\r5\bH!A!\u0002\u0013\u0019y\u000f\u0003\u0006\u0004\u0004b\u0012)\u0019!C\u0001\u0005\u007fD!b!>9\u0005\u0003\u0005\u000b\u0011BA!\u0011\u0019y\u0007\b\"\u0001\u0004x\"I1q \u001dC\u0002\u0013\u0005A\u0011\u0001\u0005\t\t\u0013A\u0004\u0015!\u0003\u0005\u0004!IA1\u0002\u001dC\u0002\u0013\u0005AQ\u0002\u0005\t\t+A\u0004\u0015!\u0003\u0005\u0010!IAq\u0003\u001dC\u0002\u0013\u0005AQ\u0002\u0005\t\t3A\u0004\u0015!\u0003\u0005\u0010\u0019!q\u000f\u0001\u0001y\u0011)\tya\u0011BC\u0002\u0013\u0005\u0011\u0011\u0003\u0005\u000b\u0003[\u0019%\u0011!Q\u0001\n\u0005M\u0001BCA\u0018\u0007\n\u0005\t\u0015!\u0003\u00022!Q\u0011QH\"\u0003\u0002\u0003\u0006I!a\u0010\t\r=\u001cE\u0011AA%\u0011%\t\tf\u0011b\u0001\n\u0003\t\u0019\u0006\u0003\u0005\u0002\\\r\u0003\u000b\u0011BA+\u0011%\tif\u0011b\u0001\n\u0003\ty\u0006\u0003\u0005\u0002l\r\u0003\u000b\u0011BA1\u0011%\tig\u0011b\u0001\n\u0003\ty\u0007\u0003\u0005\u0002\n\u000e\u0003\u000b\u0011BA9\u0011%\tYi\u0011a\u0001\n\u0003\ti\tC\u0005\u0002\"\u000e\u0003\r\u0011\"\u0001\u0002$\"A\u0011qV\"!B\u0013\ty\tC\u0005\u00022\u000e\u0003\r\u0011\"\u0001\u0002\u0012!I\u00111W\"A\u0002\u0013\u0005\u0011Q\u0017\u0005\t\u0003s\u001b\u0005\u0015)\u0003\u0002\u0014!I\u00111X\"A\u0002\u0013\u0005\u0011Q\u0018\u0005\n\u0003/\u001c\u0005\u0019!C\u0001\u00033D\u0001\"!8DA\u0003&\u0011q\u0018\u0005\b\u0003?\u001cE\u0011AAq\u0011\u001d\t\u0019o\u0011C\u0001\u0003CDq!!:D\t\u0003\t\t\u000fC\u0004\u0002h\u000e#\t!!;\t\u000f\u0005]8\t\"\u0011\u0002b\u001eIA1\u0004\u0001\u0002\u0002#\u0005AQ\u0004\u0004\to\u0002\t\t\u0011#\u0001\u0005 !1qN\u0018C\u0001\tCA\u0011\u0002b\t_#\u0003%\t\u0001\"\n\t\u0013\u0011%b,%A\u0005\u0002\u0011-\"!\t*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]NLe\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u00013f\u0003\u0015\tG-\\5o\u0015\u00051\u0017!B6bM.\f7\u0001A\n\u0003\u0001%\u0004\"A[7\u000e\u0003-T!\u0001\\3\u0002\u0005i\\\u0017B\u00018l\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\u001d\t\u0003e\u0002i\u0011aY\u0001\bG2,8\u000f^3s+\u0005)\bC\u0001<D\u001b\u0005\u0001!!\b*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N$Vm\u001d;DYV\u001cH/\u001a:\u0014\t\rK\u00181\u0001\t\u0003u~l\u0011a\u001f\u0006\u0003yv\fA\u0001\\1oO*\ta0\u0001\u0003kCZ\f\u0017bAA\u0001w\n1qJ\u00196fGR\u0004B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013i\u0018AA5p\u0013\u0011\ti!a\u0002\u0003\u0013\rcwn]3bE2,\u0017!\u0003>l\u0007>tg.Z2u+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005\u001db\u0002BA\f\u0003G\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;9\u0017A\u0002\u001fs_>$hH\u0003\u0002\u0002\"\u0005)1oY1mC&!\u0011QEA\u0010\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011FA\u0016\u0005\u0019\u0019FO]5oO*!\u0011QEA\u0010\u0003)Q8nQ8o]\u0016\u001cG\u000fI\u0001\u0010G>tg-[4Pm\u0016\u0014(/\u001b3fgBA\u00111GA\u001d\u0003'\t\u0019\"\u0004\u0002\u00026)!\u0011qGA\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\t)DA\u0002NCB\fQC\u0019:pW\u0016\u00148i\u001c8gS\u001e|e/\u001a:sS\u0012,7\u000f\u0005\u0005\u00024\u0005e\u0012\u0011IA\u0019!\u0011\t\u0019%!\u0012\u000e\u0005\u0005}\u0011\u0002BA$\u0003?\u00111!\u00138u)\u001d)\u00181JA'\u0003\u001fBq!a\u0004I\u0001\u0004\t\u0019\u0002C\u0005\u00020!\u0003\n\u00111\u0001\u00022!I\u0011Q\b%\u0011\u0002\u0003\u0007\u0011qH\u0001\bEJ|7.\u001a:t+\t\t)\u0006\u0005\u0005\u00024\u0005e\u0012\u0011IA,!\rQ\u0018\u0011L\u0005\u0004\u0003SY\u0018\u0001\u00032s_.,'o\u001d\u0011\u0002\rQ|\u0007/[2t+\t\t\t\u0007\u0005\u0005\u00024\u0005e\u0012qKA2!\u0019\t\u0019$!\u001a\u0002j%!\u0011qMA\u001b\u0005\r\u0019V-\u001d\t\u0007\u0003g\t)'!\u0011\u0002\u000fQ|\u0007/[2tA\u0005i!M]8lKJ\u001cuN\u001c4jON,\"!!\u001d\u0011\r\u0005M\u0014\u0011PA?\u001b\t\t)H\u0003\u0003\u0002x\u0005U\u0012aB7vi\u0006\u0014G.Z\u0005\u0005\u0003w\n)H\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111Q?\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000f\u000b\tI\u0001\u0006Qe>\u0004XM\u001d;jKN\faB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\b%A\u0004tKJ4XM]:\u0016\u0005\u0005=\u0005CBA:\u0003#\u000b)*\u0003\u0003\u0002\u0014\u0006U$aC!se\u0006L()\u001e4gKJ\u0004B!a&\u0002\u001e6\u0011\u0011\u0011\u0014\u0006\u0004\u00037+\u0017AB:feZ,'/\u0003\u0003\u0002 \u0006e%aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR!\u0011QUAV!\u0011\t\u0019%a*\n\t\u0005%\u0016q\u0004\u0002\u0005+:LG\u000fC\u0005\u0002.B\u000b\t\u00111\u0001\u0002\u0010\u0006\u0019\u0001\u0010J\u0019\u0002\u0011M,'O^3sg\u0002\n!B\u0019:pW\u0016\u0014H*[:u\u00039\u0011'o\\6fe2K7\u000f^0%KF$B!!*\u00028\"I\u0011QV*\u0002\u0002\u0003\u0007\u00111C\u0001\fEJ|7.\u001a:MSN$\b%A\u0006bI6Lgn\u00117jK:$XCAA`!\u0011\t\t-a5\u000e\u0005\u0005\r'b\u00013\u0002F*!\u0011qYAe\u0003\u001d\u0019G.[3oiNT1AZAf\u0015\u0011\ti-a4\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\t.A\u0002pe\u001eLA!!6\u0002D\n)\u0011\tZ7j]\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0006m\u0007\"CAW-\u0006\u0005\t\u0019AA`\u00031\tG-\\5o\u00072LWM\u001c;!\u0003\u0015\u0019X\r^;q)\t\t)+A\u0007de\u0016\fG/Z*feZ,'o]\u0001\rGJ,\u0017\r^3U_BL7m]\u0001\u0010aJ|G-^2f\u001b\u0016\u001c8/Y4fgRA\u0011QUAv\u0003_\f\u0019\u0010C\u0004\u0002nn\u0003\r!a\u0005\u0002\u000bQ|\u0007/[2\t\u000f\u0005E8\f1\u0001\u0002B\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003k\\\u0006\u0019AA!\u0003-qW/\\'fgN\fw-Z:\u0002\u000b\rdwn]3\u0002\u0017\rdWo\u001d;fe~#S-\u001d\u000b\u0005\u0003K\u000bi\u0010\u0003\u0005\u0002.\u000e\t\t\u00111\u0001v\u0003!\u0019G.^:uKJ\u0004\u0013\u0001\u0003;fCJ$un\u001e8)\u0007\u0015\u0011)\u0001\u0005\u0003\u0003\b\tUQB\u0001B\u0005\u0015\u0011\u0011YA!\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003\u0010\tE\u0011a\u00026va&$XM\u001d\u0006\u0005\u0005'\ty-A\u0003kk:LG/\u0003\u0003\u0003\u0018\t%!!C!gi\u0016\u0014X)Y2i\u0003a)h\u000e\u001e5s_R$H.\u001a3Ce>\\WM]\"p]\u001aLwm]\u000b\u0003\u0005;\u0001\u0002Ba\b\u0003&\u0005\u0005#qE\u0007\u0003\u0005CQAAa\t\u00026\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003w\u0011\t\u0003\u0005\u0005\u0003 \t\u0015\u0012q\u000bB\u0015!\u0011\t\u0019Ea\u000b\n\t\t5\u0012q\u0004\u0002\u0005\u0019>tw-A\rv]RD'o\u001c;uY\u0016$'I]8lKJ\u001cuN\u001c4jON\u0004\u0013\u0001\u0005;fgR\u0014V-Y:tS\u001etW.\u001a8uQ\rA!Q\u0007\t\u0005\u0005\u000f\u00119$\u0003\u0003\u0003:\t%!\u0001\u0002+fgR\fA\u0005^3tiJ+\u0017m]:jO:lWM\u001c;XSRD\u0017\t\u001c;fe&\u001b(\u000fR5tC\ndW\r\u001a\u0015\u0004\u0013\tU\u0012A\f;fgR\u0014V-Y:tS\u001etW.\u001a8u\u0007>l\u0007\u000f\\3uS>tG)\u001e:j]\u001e\u0004\u0016M\u001d;jC2,\u0006o\u001a:bI\u0016D3A\u0003B\u001b\u0003q)\u00070Z2vi\u0016\fe\u000e\u001a,fe&4\u0017PU3bgNLwM\\7f]R\f1\u0006^3ti\"Kw\r[,bi\u0016\u0014X*\u0019:l\u0003\u001a$XM\u001d)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004\u0019\tU\u0012!\b;fgR\fE\u000e^3s%\u0016\f7o]5h]6,g\u000e\u001e+ie>$H\u000f\\3)\u00075\u0011)$A\ruKN$H\u000b\u001b:piRdW\r\u001a*fCN\u001c\u0018n\u001a8nK:$\bf\u0001\b\u00036\u0005yC/Z:u!J|G-^2f\u0003:$7i\u001c8tk6,w+\u001b;i%\u0016\f7o]5h]6,g\u000e^%o!J|wM]3tg\"\u001aqB!\u000e\u0002!Q,7\u000f^\"b]\u000e,G\u000e\\1uS>t\u0007f\u0001\t\u00036\u0005)r/Y5u\r>\u0014Hj\\4ESJ$\u0006N]8ui2,GCBAS\u0005;\u00129\u0007C\u0004\u0003`E\u0001\rA!\u0019\u0002!QD'o\u001c;uY\u0016$'I]8lKJ\u001c\bCBA\u000b\u0005G\n\t%\u0003\u0003\u0003f\u0005-\"aA*fi\"9!\u0011N\tA\u0002\t%\u0012A\u00047pO\u0012K'\u000f\u00165s_R$H.Z\u0001\u001bo\u0006LGOR8s\u0013:$XM\u001d\"s_.,'\u000f\u00165s_R$H.\u001a\u000b\u0007\u0003K\u0013yG!\u001d\t\u000f\t}#\u00031\u0001\u0003b!9!1\u000f\nA\u0002\t%\u0012aE5oi\u0016\u0014(I]8lKJ$\u0006N]8ui2,\u0017AF<bSR4uN\u001d\"s_.,'\u000f\u00165s_R$H.Z:\u0015\r\u0005\u0015&\u0011\u0010B>\u0011\u001d\u0011yf\u0005a\u0001\u0005CBqA! \u0014\u0001\u0004\u0011y(\u0001\buQJ|G\u000f\u001e7f\u0007>tg-[4\u0011\u0011\u0005M\u0012\u0011HA\n\u0005S\t1d^1ji\u001a{'O\u0011:pW\u0016\u0014H*\u001a<fYRC'o\u001c;uY\u0016\u001cH\u0003BAS\u0005\u000bCqAa\"\u0015\u0001\u0004\u0011I)A\buCJ<W\r\u001e+ie>$H\u000f\\3t!!\t\u0019$!\u000f\u0002B\t}\u0014\u0001\b3fg\u000e\u0014\u0018NY3Ce>\\WM\u001d'fm\u0016dG\u000b\u001b:piRdWm\u001d\u000b\u0005\u0005\u0013\u0013y\tC\u0004\u0003\u0012V\u0001\r!!\u001b\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001c\u0018A\u0006;fgRdun\u001a#jeJ+\u0017m]:jO:lWM\u001c;)\u0007Y\u0011)$A\u0012uKN$\u0018\t\u001c;fe2{w\rR5s%\u0016\f7o]5h]6,g\u000e\u001e+ie>$H\u000f\\3)\u0007]\u0011)D\u0001\nM_\u001e$\u0015N\u001d*fCN\u001c\u0018n\u001a8nK:$8c\u0002\r\u0003 \n\u0015&1\u0016\t\u0005\u0003\u0007\u0012\t+\u0003\u0003\u0003$\u0006}!AB!osJ+g\r\u0005\u0003\u0002D\t\u001d\u0016\u0002\u0002BU\u0003?\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003.\n]f\u0002\u0002BX\u0005gsA!!\u0007\u00032&\u0011\u0011\u0011E\u0005\u0005\u0005k\u000by\"A\u0004qC\u000e\\\u0017mZ3\n\t\te&1\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u0005k\u000by\"\u0001\u0003kg>t\u0017!\u00026t_:\u0004\u0013AC2veJ,g\u000e\u001e#je\u0006Y1-\u001e:sK:$H)\u001b:!\u0003%!\u0018M]4fi\u0012K'/\u0001\u0006uCJ<W\r\u001e#je\u0002\"\u0002Ba3\u0003N\n='\u0011\u001b\t\u0003mbAqA!0 \u0001\u0004\t\u0019\u0002C\u0004\u0003B~\u0001\r!a\u0005\t\u000f\t\u0015w\u00041\u0001\u0002\u0014\u0005!1m\u001c9z)!\u0011YMa6\u0003Z\nm\u0007\"\u0003B_AA\u0005\t\u0019AA\n\u0011%\u0011\t\r\tI\u0001\u0002\u0004\t\u0019\u0002C\u0005\u0003F\u0002\u0002\n\u00111\u0001\u0002\u0014\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BqU\u0011\t\u0019Ba9,\u0005\t\u0015\b\u0003\u0002Bt\u0005cl!A!;\u000b\t\t-(Q^\u0001\nk:\u001c\u0007.Z2lK\u0012TAAa<\u0002 \u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM(\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011qK\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0003\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004\u0006\r-\u0001\u0003BA\"\u0007\u000fIAa!\u0003\u0002 \t\u0019\u0011I\\=\t\u0013\u00055f%!AA\u0002\u0005\u0005\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\rE\u0001CBA\u001a\u0007'\u0019)!\u0003\u0003\u0004\u0016\u0005U\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$Baa\u0007\u0004\"A!\u00111IB\u000f\u0013\u0011\u0019y\"a\b\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u0016\u0015\u0002\u0002\u0003\u00071QA\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002X\r\u001d\u0002\"CAWS\u0005\u0005\t\u0019AA!\u0003!A\u0017m\u001d5D_\u0012,GCAA!\u0003!!xn\u0015;sS:<GCAA,\u0003\u0019)\u0017/^1mgR!11DB\u001b\u0011%\ti\u000bLA\u0001\u0002\u0004\u0019)!\u0001\nM_\u001e$\u0015N\u001d*fCN\u001c\u0018n\u001a8nK:$\bC\u0001</'\u0015q3QHB%!1\u0019yd!\u0012\u0002\u0014\u0005M\u00111\u0003Bf\u001b\t\u0019\tE\u0003\u0003\u0004D\u0005}\u0011a\u0002:v]RLW.Z\u0005\u0005\u0007\u000f\u001a\tEA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!\u0002\u0004L%!!\u0011XA\u0004)\t\u0019I$A\u0003baBd\u0017\u0010\u0006\u0005\u0003L\u000eM3QKB,\u0011\u001d\u0011i,\ra\u0001\u0003'AqA!12\u0001\u0004\t\u0019\u0002C\u0004\u0003FF\u0002\r!a\u0005\u0002\u000fUt\u0017\r\u001d9msR!1QLB5!\u0019\t\u0019ea\u0018\u0004d%!1\u0011MA\u0010\u0005\u0019y\u0005\u000f^5p]BQ\u00111IB3\u0003'\t\u0019\"a\u0005\n\t\r\u001d\u0014q\u0004\u0002\u0007)V\u0004H.Z\u001a\t\u0013\r-$'!AA\u0002\t-\u0017a\u0001=%a\u00059\"-^5mI2{w\rR5s%\u0016\f7o]5h]6,g\u000e\u001e\u000b\t\u0005\u0017\u001c\th!!\u0004\u0006\"911O\u001aA\u0002\rU\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0007o\u001ai(\u0004\u0002\u0004z)!11PAe\u0003\u0019\u0019w.\\7p]&!1qPB=\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dqaa!4\u0001\u0004\t\t%\u0001\u0005ce>\\WM]%e\u0011\u001d\u00199i\ra\u0001\u0003S\n\u0001B]3qY&\u001c\u0017m]\u0001\u0014eVtg+\u001a:jMf\f5o]5h]6,g\u000e\u001e\u000b\t\u0007\u001b\u001b\u0019k!*\u0004*B!1qRBO\u001d\u0011\u0019\tj!'\u000f\t\rM5q\u0013\b\u0005\u00033\u0019)*C\u0001g\u0013\t!W-C\u0002\u0004\u001c\u000e\f\u0011DU3bgNLwM\u001c)beRLG/[8og\u000e{W.\\1oI&!1qTBQ\u0005Y1VM]5gs\u0006\u001b8/[4o[\u0016tGOU3tk2$(bABNG\"9\u00111\u0018\u001bA\u0002\u0005}\u0006bBBTi\u0001\u0007\u00111C\u0001\u000bUN|gn\u0015;sS:<\u0007bBBVi\u0001\u000711D\u0001\u0012aJ,7/\u001a:wKRC'o\u001c;uY\u0016\u001c\u0018aF<bSR4uN\u001d,fe&4\u00170Q:tS\u001etW.\u001a8u))\t)k!-\u00044\u000eU6q\u0017\u0005\b\u0003w+\u0004\u0019AA`\u0011\u001d\u00199+\u000ea\u0001\u0003'Aqaa+6\u0001\u0004\u0019Y\u0002C\u0004\u0004:V\u0002\ra!$\u0002\u001d\u0015D\b/Z2uK\u0012\u0014Vm];mi\u0006!\"/\u001e8Fq\u0016\u001cW\u000f^3BgNLwM\\7f]R$B\"!*\u0004@\u000e\u00057QYBe\u0007\u0017Dq!a/7\u0001\u0004\ty\fC\u0004\u0004DZ\u0002\raa\u0007\u0002\u0015\u0005$G-\u001b;j_:\fG\u000eC\u0004\u0004HZ\u0002\r!a\u0005\u0002!I,\u0017m]:jO:lWM\u001c;Kg>t\u0007b\u0002B:m\u0001\u0007!\u0011\u0006\u0005\b\u0007\u001b4\u0004\u0019\u0001B\u0015\u0003m\u0011X\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014x\u000e\u001e;mK\u0006\u0019\"/\u001e8DC:\u001cW\r\\!tg&<g.\\3oiRA11[Br\u0007K\u001c9\u000f\u0005\u0005\u0002D\rU7\u0011\\Bn\u0013\u0011\u00199.a\b\u0003\rQ+\b\u000f\\33!\u0019\t)Ba\u0019\u0004vA1\u0011Q\u0003B2\u0007;\u0004Baa\u001e\u0004`&!1\u0011]B=\u0005U!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006Dq!a/8\u0001\u0004\ty\fC\u0004\u0004(^\u0002\r!a\u0005\t\u000f\r-v\u00071\u0001\u0004\u001c\tQ!I]8lKJ$\u0015N]:\u0014\u0007a\u0012y*\u0001\u0004sKN,H\u000e\u001e\t\u0005\u0003\u0003\u001c\t0\u0003\u0003\u0004t\u0006\r'!\u0006#fg\u000e\u0014\u0018NY3M_\u001e$\u0015N]:SKN,H\u000e^\u0001\nEJ|7.\u001a:JI\u0002\"ba!?\u0004|\u000eu\bC\u0001<9\u0011\u001d\u0019i\u000f\u0010a\u0001\u0007_Dqaa!=\u0001\u0004\t\t%A\u0004m_\u001e$\u0015N]:\u0016\u0005\u0011\r\u0001CBA:\t\u000b\t\u0019\"\u0003\u0003\u0005\b\u0005U$a\u0002%bg\"\u001cV\r^\u0001\tY><G)\u001b:tA\u0005Q1-\u001e:M_\u001e$\u0015N]:\u0016\u0005\u0011=\u0001\u0003CA:\t#\u0019)(a\u0005\n\t\u0011M\u0011Q\u000f\u0002\b\u0011\u0006\u001c\b.T1q\u0003-\u0019WO\u001d'pO\u0012K'o\u001d\u0011\u0002\u001b\u0019,H/\u001e:f\u0019><G)\u001b:t\u000391W\u000f^;sK2{w\rR5sg\u0002\nQDU3bgNLwM\u001c)beRLG/[8ogR+7\u000f^\"mkN$XM\u001d\t\u0003mz\u001b2A\u0018BP)\t!i\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\tOQC!!\r\u0003d\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"\u0001\"\f+\t\u0005}\"1\u001d\u0015\b\u0001\u0011EBq\u0007C\u001d!\u0011\u00119\u0001b\r\n\t\u0011U\"\u0011\u0002\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\t\tA\u0006")
public class ReassignPartitionsIntegrationTest
extends ZooKeeperTestHarness {
    private volatile ReassignPartitionsIntegrationTest$LogDirReassignment$ LogDirReassignment$module;
    private volatile ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$ ReassignPartitionsTestCluster$module;
    private ReassignPartitionsTestCluster cluster = null;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$unthrottledBrokerConfigs$1(BoxesRunTime.unboxToInt((Object)brokerId))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());

    public ReassignPartitionsIntegrationTest$LogDirReassignment$ LogDirReassignment() {
        if (this.LogDirReassignment$module == null) {
            this.LogDirReassignment$lzycompute$1();
        }
        return this.LogDirReassignment$module;
    }

    public ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$ ReassignPartitionsTestCluster() {
        if (this.ReassignPartitionsTestCluster$module == null) {
            this.ReassignPartitionsTestCluster$lzycompute$1();
        }
        return this.ReassignPartitionsTestCluster$module;
    }

    public ReassignPartitionsTestCluster cluster() {
        return this.cluster;
    }

    public void cluster_$eq(ReassignPartitionsTestCluster x$1) {
        this.cluster = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.cluster(), (String)"ReassignPartitionsTestCluster");
        super.tearDown();
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs() {
        return this.unthrottledBrokerConfigs;
    }

    @Test
    public void testReassignment() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    @Test
    public void testReassignmentWithAlterIsrDisabled() {
        Map configOverrides = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp()), (Object)KAFKA_2_7_IV1$.MODULE$.version())}));
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)configOverrides, (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    @Test
    public void testReassignmentCompletionDuringPartialUpgrade() {
        Map map;
        ZkIsrManager$.MODULE$.DefaultIsrPropagationConfig_$eq(new IsrChangePropagationConfig(500L, 500L, 100L));
        Map oldIbpConfig = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp()), (Object)KAFKA_2_7_IV1$.MODULE$.version())}));
        Map brokerConfigOverrides = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)oldIbpConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)oldIbpConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)oldIbpConfig)}));
        String x$4 = this.zkConnect();
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        Map map2 = map = (Map)Map$.MODULE$.empty();
        map = null;
        Map x$6 = map2;
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, x$4, (Map<String, String>)x$6, (Map<Object, Map<String, String>>)brokerConfigOverrides));
        this.cluster().setup();
        this.executeAndVerifyReassignment();
    }

    public void executeAndVerifyReassignment() {
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"bar\",\"partition\":0,\"replicas\":[3,2,0],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Map initialAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true))}));
        Assertions.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).movesOngoing());
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
    }

    @Test
    public void testHighWaterMarkAfterPartitionReassignment() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[3,1,2],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        TopicPartition part = new TopicPartition("foo", 0);
        ((KafkaServer)this.cluster().servers().apply(0)).replicaManager().logManager().truncateFullyAndStartAt(part, 123L, false);
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testHighWaterMarkAfterPartitionReassignment$1(this, part)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"broker 3 should be the new leader");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)123L, (long)((KafkaServer)this.cluster().servers().apply(3)).replicaManager().localLogOrException(part).highWatermark(), (String)"Expected broker 3 to have the correct high water mark for the partition.");
    }

    @Test
    public void testAlterReassignmentThrottle() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":\n      [{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},\n      {\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}\n      ]}";
        long initialThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, initialThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), initialThrottle);
        long updatedThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), true, assignment, updatedThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), updatedThrottle);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    @Test
    public void testThrottledReassignment() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Map initialAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        Assertions.assertEquals((Object)new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, false, (Map)Map$.MODULE$.empty(), false), (Object)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false));
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 2)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$1(this, assignment, interBrokerThrottle)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Expected reassignment to complete.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    @Test
    public void testProduceAndConsumeWithReassignmentInProgress() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, 300L, -1L);
        this.cluster().produceMessages("baz", 2, 100);
        TopicPartition part = new TopicPartition("baz", 2);
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(this.cluster().brokerList(), "group", "earliest", true, false, 500, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArrayDeserializer(), new ByteArrayDeserializer());){
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)part, (List)Nil$.MODULE$)).asJava());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 100, 15000L);
        }
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.cluster().adminClient(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{part}))));
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)part), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true))}));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
    }

    @Test
    public void testCancellation() {
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 200);
        this.cluster().produceMessages("baz", 1, 200);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":1,\"replicas\":[0,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Assertions.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), false))})), true, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), false));
        Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("baz", 1)})), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.runCancelAssignment(this.cluster().adminClient(), assignment, true));
        this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle);
        Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.runCancelAssignment(this.cluster().adminClient(), assignment, false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        Assertions.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).partsOngoing());
    }

    private void waitForLogDirThrottle(Set<Object> throttledBrokers, long logDirThrottle) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)logDirThrottle))}));
        this.waitForBrokerThrottles(throttledBrokers, (Map<String, Object>)throttledConfigMap);
    }

    private void waitForInterBrokerThrottle(Set<Object> throttledBrokers, long interBrokerThrottle) {
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle()), (Object)BoxesRunTime.boxToLong((long)interBrokerThrottle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle()), (Object)BoxesRunTime.boxToLong((long)interBrokerThrottle)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle()), (Object)BoxesRunTime.boxToLong((long)-1L))}));
        this.waitForBrokerThrottles(throttledBrokers, (Map<String, Object>)throttledConfigMap);
    }

    private void waitForBrokerThrottles(Set<Object> throttledBrokers, Map<String, Object> throttleConfig) {
        scala.collection.immutable.Map throttledBrokerConfigs = (scala.collection.immutable.Map)this.unthrottledBrokerConfigs().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            scala.collection.immutable.Map unthrottledConfig = (scala.collection.immutable.Map)x0$1._2();
            Map expectedThrottleConfig = throttledBrokers.contains((Object)BoxesRunTime.boxToInteger((int)brokerId)) ? throttleConfig : unthrottledConfig;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)expectedThrottleConfig);
            return tuple2;
        });
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
    }

    private void waitForBrokerLevelThrottles(Map<Object, Map<String, Object>> targetThrottles) {
        Map<Object, Map<String, Object>> map;
        Map cfr_ignored_0 = (Map)Map$.MODULE$.empty();
        long l = 15000L;
        long waitUntilTrue_pause = 25L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!targetThrottles.equals(map = this.describeBrokerLevelThrottles((Seq<Object>)targetThrottles.keySet().toSeq()))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(0).append(new StringBuilder(51).append("timed out waiting for broker throttle to become ").append(targetThrottles).append(".  ").toString()).append(new StringBuilder(22).append("Latest throttles were ").append(map).toString()).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
    }

    private Map<Object, Map<String, Object>> describeBrokerLevelThrottles(Seq<Object> brokerIds) {
        return ((IterableOnceOps)brokerIds.map((Function1 & Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$describeBrokerLevelThrottles$1(this, BoxesRunTime.unboxToInt((Object)brokerId)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Test
    public void testLogDirReassignment() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages(topicPartition.topic(), topicPartition.partition(), 700);
        int targetBrokerId = 0;
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        LogDirReassignment reassignment = this.buildLogDirReassignment(topicPartition, targetBrokerId, (Seq<Object>)replicas);
        long logDirThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, reassignment.json(), -1L, logDirThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState(reassignment.currentDir(), reassignment.targetDir(), reassignment.targetDir()))})), true));
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), logDirThrottle);
        this.cluster().adminClient().incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, "0"), Collections.singletonList(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), ""), AlterConfigOp.OpType.DELETE)))).all().get();
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState(reassignment.targetDir()))})), false));
        BrokerDirs info1 = new BrokerDirs(this, this.cluster().adminClient().describeLogDirs(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$3 -> ReassignPartitionsIntegrationTest.$anonfun$testLogDirReassignment$1(BoxesRunTime.unboxToInt((Object)x$3)))).asJavaCollection()), 0);
        Assertions.assertEquals((Object)reassignment.targetDir(), (Object)info1.curLogDirs().getOrElse((Object)topicPartition, (Function0 & Serializable)() -> ""));
    }

    @Test
    public void testAlterLogDirReassignmentThrottle() {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        if (this.ReassignPartitionsTestCluster() == null) {
            throw null;
        }
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect(), (Map<String, String>)((Map)Map$.MODULE$.empty()), (Map<Object, Map<String, String>>)((Map)Map$.MODULE$.empty())));
        this.cluster().setup();
        this.cluster().produceMessages(topicPartition.topic(), topicPartition.partition(), 700);
        int targetBrokerId = 0;
        Seq replicas = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        LogDirReassignment reassignment = this.buildLogDirReassignment(topicPartition, targetBrokerId, (Seq<Object>)replicas);
        long initialLogDirThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, reassignment.json(), -1L, initialLogDirThrottle);
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), initialLogDirThrottle);
        long updatedLogDirThrottle = 3000000L;
        this.runExecuteAssignment(this.cluster().adminClient(), true, reassignment.json(), -1L, updatedLogDirThrottle);
        this.waitForLogDirThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))), updatedLogDirThrottle);
        this.waitForVerifyAssignment(this.cluster().adminClient(), reassignment.json(), true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true))})), false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topicPartition.topic(), topicPartition.partition(), targetBrokerId)), (Object)new ReassignPartitionsCommand.CompletedMoveState(reassignment.targetDir()))})), false));
    }

    private LogDirReassignment buildLogDirReassignment(TopicPartition topicPartition, int brokerId, Seq<Object> replicas) {
        DescribeLogDirsResult describeLogDirsResult = this.cluster().adminClient().describeLogDirs(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable)x$4 -> ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$1(BoxesRunTime.unboxToInt((Object)x$4)))).asJavaCollection());
        BrokerDirs logDirInfo = new BrokerDirs(this, describeLogDirsResult, brokerId);
        Assertions.assertTrue((boolean)logDirInfo.futureLogDirs().isEmpty());
        String currentDir = (String)logDirInfo.curLogDirs().apply((Object)topicPartition);
        String newDir = (String)logDirInfo.logDirs().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$2(currentDir, x$5))).get();
        Seq logDirs = (Seq)replicas.map((Function1 & Serializable)replicaId -> ReassignPartitionsIntegrationTest.$anonfun$buildLogDirReassignment$3(brokerId, newDir, BoxesRunTime.unboxToInt((Object)replicaId)));
        String reassignmentJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(246).append("\n         | { \"version\": 1,\n         |  \"partitions\": [\n         |    {\n         |     \"topic\": \"").append(topicPartition.topic()).append("\",\n         |     \"partition\": ").append(topicPartition.partition()).append(",\n         |     \"replicas\": [").append(replicas.mkString(",")).append("],\n         |     \"log_dirs\": [").append(logDirs.mkString(",")).append("]\n         |    }\n         |   ]\n         |  }\n         |").toString()));
        return new LogDirReassignment(this, reassignmentJson, currentDir, newDir);
    }

    private ReassignPartitionsCommand.VerifyAssignmentResult runVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("==> verifyAssignment(adminClient, jsonString=").append(jsonString).append(")").toString());
        return ReassignPartitionsCommand$.MODULE$.verifyAssignment(adminClient, jsonString, preserveThrottles);
    }

    private void waitForVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult) {
        ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignmentResult;
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!expectedResult.equals((Object)(verifyAssignmentResult = this.runVerifyAssignment(adminClient, jsonString, preserveThrottles)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)new StringBuilder(0).append(new StringBuilder(49).append("Timed out waiting for verifyAssignment result ").append(expectedResult).append(".  ").toString()).append(new StringBuilder(22).append("The latest result was ").append(verifyAssignmentResult).toString()).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
    }

    private void runExecuteAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long replicaAlterLogDirsThrottle) {
        Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(48).append("==> executeAssignment(adminClient, additional=").append(additional).append(", ").toString()).append(new StringBuilder(19).append("reassignmentJson=").append(reassignmentJson).append(", ").toString()).append(new StringBuilder(22).append("interBrokerThrottle=").append(interBrokerThrottle).append(", ").toString()).append(new StringBuilder(30).append("replicaAlterLogDirsThrottle=").append(replicaAlterLogDirsThrottle).append("))").toString()).toString());
        ReassignPartitionsCommand$.MODULE$.executeAssignment(adminClient, additional, reassignmentJson, interBrokerThrottle, replicaAlterLogDirsThrottle, 10000L, Time.SYSTEM);
    }

    private Tuple2<Set<TopicPartition>, Set<TopicPartitionReplica>> runCancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("==> cancelAssignment(adminClient, jsonString=").append(jsonString).append(")").toString());
        return ReassignPartitionsCommand$.MODULE$.cancelAssignment(adminClient, jsonString, preserveThrottles, 10000L, Time.SYSTEM);
    }

    private final void LogDirReassignment$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirReassignment$module == null) {
                this.LogDirReassignment$module = new ReassignPartitionsIntegrationTest$LogDirReassignment$(this);
            }
            return;
        }
    }

    private final void ReassignPartitionsTestCluster$lzycompute$1() {
        synchronized (this) {
            if (this.ReassignPartitionsTestCluster$module == null) {
                this.ReassignPartitionsTestCluster$module = new ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testHighWaterMarkAfterPartitionReassignment$1(ReassignPartitionsIntegrationTest $this, TopicPartition part$1) {
        return ((KafkaServer)$this.cluster().servers().apply(3)).replicaManager().onlinePartition(part$1).flatMap((Function1 & Serializable)x$1 -> x$1.leaderLogIfLocal()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testHighWaterMarkAfterPartitionReassignment$3() {
        return "broker 3 should be the new leader";
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$2(Tuple2 x$2) {
        return ((ReassignPartitionsCommand.PartitionReassignmentState)x$2._2()).done();
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$1(ReassignPartitionsIntegrationTest $this, String assignment$1, long interBrokerThrottle$1) {
        ReassignPartitionsCommand.VerifyAssignmentResult result = $this.runVerifyAssignment($this.cluster().adminClient(), assignment$1, true);
        if (!result.partsOngoing()) {
            return true;
        }
        Assertions.assertFalse((boolean)result.partStates().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$2(x$2))), (String)new StringBuilder(73).append("Expected at least one partition reassignment to be ongoing when result = ").append(result).toString());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("foo", 0))).targetReplicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("baz", 2))).targetReplicas());
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Current result: {}", (Object)result);
        }
        $this.waitForInterBrokerThrottle((Set<Object>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), interBrokerThrottle$1);
        return false;
    }

    public static final /* synthetic */ String $anonfun$testThrottledReassignment$3() {
        return "Expected reassignment to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, ObjectRef curThrottles$1, Map targetThrottles$1) {
        curThrottles$1.elem = $this.describeBrokerLevelThrottles((Seq<Object>)targetThrottles$1.keySet().toSeq());
        return targetThrottles$1.equals((Object)((Map)curThrottles$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForBrokerLevelThrottles$2(Map targetThrottles$1, ObjectRef curThrottles$1) {
        return new StringBuilder(0).append(new StringBuilder(51).append("timed out waiting for broker throttle to become ").append(targetThrottles$1).append(".  ").toString()).append(new StringBuilder(22).append("Latest throttles were ").append((Map)curThrottles$1.elem).toString()).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, int brokerId) {
        Properties props = $this.zkClient().getEntityConfigs("brokers", Integer.toString(brokerId));
        scala.collection.immutable.Map throttles = ((IterableOnceOps)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable)throttleName -> new Tuple2(throttleName, (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)props.getOrDefault(throttleName, "-1"))))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)throttles);
    }

    public static final /* synthetic */ Integer $anonfun$testLogDirReassignment$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ Integer $anonfun$buildLogDirReassignment$1(int x$4) {
        return BoxesRunTime.boxToInteger((int)x$4);
    }

    public static final /* synthetic */ boolean $anonfun$buildLogDirReassignment$2(String currentDir$1, String x$5) {
        return !x$5.equals(currentDir$1);
    }

    public static final /* synthetic */ String $anonfun$buildLogDirReassignment$3(int brokerId$1, String newDir$1, int replicaId) {
        if (replicaId == brokerId$1) {
            return new StringBuilder(2).append("\"").append(newDir$1).append("\"").toString();
        }
        return "\"any\"";
    }

    public static final /* synthetic */ boolean $anonfun$waitForVerifyAssignment$1(ReassignPartitionsIntegrationTest $this, ObjectRef latestResult$1, Admin adminClient$1, String jsonString$1, boolean preserveThrottles$1, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1) {
        latestResult$1.elem = $this.runVerifyAssignment(adminClient$1, jsonString$1, preserveThrottles$1);
        return expectedResult$1.equals((Object)((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForVerifyAssignment$2(ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1, ObjectRef latestResult$1) {
        return new StringBuilder(0).append(new StringBuilder(49).append("Timed out waiting for verifyAssignment result ").append(expectedResult$1).append(".  ").toString()).append(new StringBuilder(22).append("The latest result was ").append((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem).toString()).toString();
    }

    public class BrokerDirs {
        private final int brokerId;
        private final HashSet<String> logDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public HashSet<String> logDirs() {
            return this.logDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs() {
            return this.curLogDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs() {
            return this.futureLogDirs;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$BrokerDirs$$$outer() {
            return this.$outer;
        }

        public BrokerDirs(ReassignPartitionsIntegrationTest $outer, DescribeLogDirsResult result, int brokerId) {
            this.brokerId = brokerId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.logDirs = new HashSet();
            this.curLogDirs = new scala.collection.mutable.HashMap();
            this.futureLogDirs = new scala.collection.mutable.HashMap();
            ((java.util.Map)((KafkaFuture)result.descriptions().get(BoxesRunTime.boxToInteger((int)brokerId))).get()).forEach((x0$1, x1$1) -> {
                this.logDirs().add(x0$1);
                x1$1.replicaInfos().forEach((x0$2, x1$2) -> {
                    if (x1$2.isFuture()) {
                        this.futureLogDirs().put(x0$2, x0$1);
                        return;
                    }
                    this.curLogDirs().put(x0$2, x0$1);
                });
            });
        }
    }

    public class LogDirReassignment
    implements Product,
    Serializable {
        private final String json;
        private final String currentDir;
        private final String targetDir;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String json() {
            return this.json;
        }

        public String currentDir() {
            return this.currentDir;
        }

        public String targetDir() {
            return this.targetDir;
        }

        public LogDirReassignment copy(String json, String currentDir, String targetDir) {
            return new LogDirReassignment(this.kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer(), json, currentDir, targetDir);
        }

        public String copy$default$1() {
            return this.json();
        }

        public String copy$default$2() {
            return this.currentDir();
        }

        public String copy$default$3() {
            return this.targetDir();
        }

        public String productPrefix() {
            return "LogDirReassignment";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.json();
                }
                case 1: {
                    return this.currentDir();
                }
                case 2: {
                    return this.targetDir();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirReassignment;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "json";
                }
                case 1: {
                    return "currentDir";
                }
                case 2: {
                    return "targetDir";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof LogDirReassignment)) return false;
            if (((LogDirReassignment)x$1).kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer() != this.kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LogDirReassignment logDirReassignment = (LogDirReassignment)x$1;
            String string = this.json();
            String string2 = logDirReassignment.json();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.currentDir();
            String string4 = logDirReassignment.currentDir();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.targetDir();
            String string6 = logDirReassignment.targetDir();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!logDirReassignment.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$LogDirReassignment$$$outer() {
            return this.$outer;
        }

        public LogDirReassignment(ReassignPartitionsIntegrationTest $outer, String json, String currentDir, String targetDir) {
            this.json = json;
            this.currentDir = currentDir;
            this.targetDir = targetDir;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ReassignPartitionsTestCluster
    implements Closeable {
        private final String zkConnect;
        private final Map<String, String> configOverrides;
        private final Map<Object, Map<String, String>> brokerConfigOverrides;
        private final Map<Object, String> brokers;
        private final Map<String, Seq<Seq<Object>>> topics;
        private final Buffer<Properties> brokerConfigs;
        private ArrayBuffer<KafkaServer> servers;
        private String brokerList;
        private Admin adminClient;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public Map<Object, String> brokers() {
            return this.brokers;
        }

        public Map<String, Seq<Seq<Object>>> topics() {
            return this.topics;
        }

        public Buffer<Properties> brokerConfigs() {
            return this.brokerConfigs;
        }

        public ArrayBuffer<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(ArrayBuffer<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public void brokerList_$eq(String x$1) {
            this.brokerList = x$1;
        }

        public Admin adminClient() {
            return this.adminClient;
        }

        public void adminClient_$eq(Admin x$1) {
            this.adminClient = x$1;
        }

        public void setup() {
            this.createServers();
            this.createTopics();
        }

        public void createServers() {
            this.brokers().keySet().foreach((Function1 & Serializable)brokerId -> ReassignPartitionsTestCluster.$anonfun$createServers$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        }

        public void createTopics() {
            TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), 15000L);
            this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)));
            this.adminClient_$eq(Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava()));
            this.adminClient().createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)this.topics().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$1._1();
                Seq parts = (Seq)x0$1._2();
                HashMap partMap = new HashMap();
                ((IterableOnceOps)parts.zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    Seq part = (Seq)x0$2._1();
                    int index = x0$2._2$mcI$sp();
                    java.util.List list = partMap.put(Predef$.MODULE$.int2Integer(index), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)part.map((Function1 & Serializable)x$6 -> BoxesRunTime.unboxToInt((Object)x$6))).asJava());
                    return list;
                });
                NewTopic newTopic = new NewTopic(topicName, partMap);
                return newTopic;
            })).toList()).asJava()).all().get();
            this.topics().foreach((Function1 & Serializable)x0$3 -> {
                if (x0$3 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$3._1();
                Seq parts = (Seq)x0$3._2();
                Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> map = TestUtils$.MODULE$.waitForAllPartitionsMetadata((Seq<KafkaServer>)this.servers(), topicName, parts.size());
                return map;
            });
        }

        public void produceMessages(String topic, int partition, int numMessages) {
            IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable)x$7 -> ReassignPartitionsTestCluster.$anonfun$produceMessages$1(topic, partition, BoxesRunTime.unboxToInt((Object)x$7)));
            TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, -1);
        }

        @Override
        public void close() {
            this.brokerList_$eq(null);
            Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"adminClient");
            this.adminClient_$eq(null);
            try {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
            }
            finally {
                this.servers().clear();
            }
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$brokerConfigs$3(Properties config$1, Map overrides) {
            Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(x$1, x$2) -> config$1.setProperty((String)x$1, (String)x$2);
            overrides.foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ ArrayBuffer $anonfun$createServers$1(ReassignPartitionsTestCluster $this, int brokerId) {
            void createServer_time;
            void createServer_config;
            Time time;
            java.util.Map apply_props = (java.util.Map)$this.brokerConfigs().apply(brokerId);
            Object var2_2 = null;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig kafkaConfig = new KafkaConfig(apply_props, true);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            Object var6_7 = null;
            Object var3_6 = null;
            kafkaConfig = null;
            time3 = null;
            return (ArrayBuffer)$this.servers().$plus$eq((Object)createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false));
        }

        public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$1, int partition$1, int x$7) {
            return new ProducerRecord(topic$1, Predef$.MODULE$.int2Integer(partition$1), null, (Object)new byte[10000]);
        }

        public ReassignPartitionsTestCluster(ReassignPartitionsIntegrationTest $outer, String zkConnect, Map<String, String> configOverrides, Map<Object, Map<String, String>> brokerConfigOverrides) {
            this.zkConnect = zkConnect;
            this.configOverrides = configOverrides;
            this.brokerConfigOverrides = brokerConfigOverrides;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.brokers = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack1")}));
            this.topics = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1}))), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"baz"), (Object)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1}))), (List)Nil$.MODULE$))))}));
            this.brokerConfigs = ((IterableOnceOps)this.brokers().map((Function1 & Serializable)x0$1 -> {
                void var4_24;
                None$ none$;
                None$ none$2;
                None$ none$3;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int brokerId = x0$1._1$mcI$sp();
                String rack = (String)x0$1._2();
                String x$22 = this.zkConnect();
                Some x$3 = new Some((Object)rack);
                boolean bl = true;
                int n = TestUtils$.MODULE$.RandomPort();
                None$ none$4 = none$3 = None$.MODULE$;
                none$3 = null;
                None$ x$8 = none$4;
                None$ none$5 = none$2 = None$.MODULE$;
                none$2 = null;
                None$ x$9 = none$5;
                None$ none$6 = none$ = None$.MODULE$;
                none$ = null;
                None$ x$10 = none$6;
                boolean bl2 = true;
                boolean bl3 = false;
                int n2 = TestUtils$.MODULE$.RandomPort();
                boolean bl4 = false;
                int n3 = TestUtils$.MODULE$.RandomPort();
                boolean bl5 = false;
                int n4 = TestUtils$.MODULE$.RandomPort();
                boolean bl6 = false;
                int n5 = 1;
                short s = 1;
                Properties config = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$22, false, bl, n, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl2, bl3, n2, bl4, n3, bl5, n4, (Option<String>)x$3, 3, bl6, n5, s);
                config.setProperty(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), "100");
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
                $this.configOverrides.foreachEntry((arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(x$1, x$2) -> config.setProperty((String)x$1, (String)x$2), arg_0, arg_1));
                $this.brokerConfigOverrides.get((Object)BoxesRunTime.boxToInteger((int)brokerId)).foreach((Function1 & Serializable)overrides -> {
                    ReassignPartitionsTestCluster.$anonfun$brokerConfigs$3(config, overrides);
                    return BoxedUnit.UNIT;
                });
                return var4_24;
            })).toBuffer();
            this.servers = new ArrayBuffer();
            this.brokerList = null;
            this.adminClient = null;
        }
    }
}

