/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\u001f>\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004X\u0001\u0001\u0006I!\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019)\u0007\u0001)A\u00055\"9a\r\u0001b\u0001\n\u00139\u0007BB6\u0001A\u0003%\u0001\u000eC\u0004m\u0001\t\u0007I\u0011B7\t\rQ\u0004\u0001\u0015!\u0003o\u0011\u001d)\bA1A\u0005\n5DaA\u001e\u0001!\u0002\u0013q\u0007bB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007y\u0002\u0001\u000b\u0011B=\t\u000fu\u0004!\u0019!C\u0005q\"1a\u0010\u0001Q\u0001\neD\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011\u0011\u0004\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u001e!I\u0011Q\u0005\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u001e!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002.!I\u0011Q\u0007\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002.!I\u0011\u0011\b\u0001C\u0002\u0013%\u00111\b\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002>!I\u0011Q\t\u0001C\u0002\u0013%\u00111\b\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002>!I\u0011\u0011\n\u0001C\u0002\u0013%\u00111\b\u0005\t\u0003\u0017\u0002\u0001\u0015!\u0003\u0002>!I\u0011Q\n\u0001C\u0002\u0013%\u00111\b\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002>!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002V!I\u00111\r\u0001C\u0002\u0013%\u0011Q\r\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002h!I\u0011q\u000e\u0001C\u0002\u0013%\u0011Q\r\u0005\t\u0003c\u0002\u0001\u0015!\u0003\u0002h!I\u00111\u000f\u0001C\u0002\u0013%\u0011Q\u000f\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002x!I\u0011Q\u0014\u0001C\u0002\u0013%\u0011q\u0014\u0005\t\u0003[\u0003\u0001\u0015!\u0003\u0002\"\"I\u0011q\u0016\u0001C\u0002\u0013%\u0011\u0011\u0017\u0005\t\u0003s\u0003\u0001\u0015!\u0003\u00024\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBA`\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0003/\u0004A\u0011AA_\u0011\u001d\tY\u000e\u0001C\u0001\u0003{Cq!a8\u0001\t\u0003\ti\fC\u0004\u0002d\u0002!\t!!0\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002>\"9\u00111\u001e\u0001\u0005\u0002\u0005u\u0006bBAx\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0003g\u0004A\u0011AA_\u0011\u001d\t9\u0010\u0001C\u0005\u0003sDqA!\u0006\u0001\t\u0003\tiLA\u0012Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005yz\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:T!\u0001Q!\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u0005\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001F!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0014\t\u0003\u001d\u0002i\u0011!P\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001V!\u0002\rM,'O^3s\u0013\t16KA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u00035qW\r^<pe.\u001cE.[3oiV\t!\f\u0005\u0002\\G6\tAL\u0003\u0002^=\u000691\r\\5f]R\u001c(B\u0001\"`\u0015\t\u0001\u0017-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002E\u0006\u0019qN]4\n\u0005\u0011d&!\u0004(fi^|'o[\"mS\u0016tG/\u0001\boKR<xN]6DY&,g\u000e\u001e\u0011\u0002\u001fQDhn\u0015;bi\u0016l\u0015M\\1hKJ,\u0012\u0001\u001b\t\u0003\u001d&L!A[\u001f\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014\u0018\u0001\u0005;y]N#\u0018\r^3NC:\fw-\u001a:!\u0003)\u0001\u0018M\u001d;ji&|g.M\u000b\u0002]B\u0011qN]\u0007\u0002a*\u0011\u0011OX\u0001\u0007G>lWn\u001c8\n\u0005M\u0004(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\fa\u0006\u0014H/\u001b;j_:\f\u0004%\u0001\u0006qCJ$\u0018\u000e^5p]J\n1\u0002]1si&$\u0018n\u001c83A\u00059!M]8lKJ\fT#A=\u0011\u0005=T\u0018BA>q\u0005\u0011qu\u000eZ3\u0002\u0011\t\u0014xn[3sc\u0001\nqA\u0019:pW\u0016\u0014('\u0001\u0005ce>\\WM\u001d\u001a!\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017'\u0006\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00027b]\u001eT!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t9A\u0001\u0004TiJLgnZ\u0001\u0012iJ\fgn]1di&|g.\u00197JIF\u0002\u0013\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001333\u0003E!(/\u00198tC\u000e$\u0018n\u001c8bY&#'\u0007I\u0001\faJ|G-^2fe&#\u0017'\u0006\u0002\u0002\u001eA\u0019a)a\b\n\u0007\u0005\u0005rI\u0001\u0003M_:<\u0017\u0001\u00049s_\u0012,8-\u001a:JIF\u0002\u0013a\u00039s_\u0012,8-\u001a:JIJ\nA\u0002\u001d:pIV\u001cWM]%ee\u0001\nQ\u0002\u001d:pIV\u001cWM]#q_\u000eDWCAA\u0017!\r1\u0015qF\u0005\u0004\u0003c9%!B*i_J$\u0018A\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eI\u0001\u0012Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]#q_\u000eD\u0017A\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0002\n!\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8ocU\u0011\u0011Q\b\t\u0004\r\u0006}\u0012bAA!\u000f\n\u0019\u0011J\u001c;\u0002'QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g.\r\u0011\u0002%QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gNM\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t'\u0007I\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"\f\u0011cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195!\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u00035!\bP\u001c+j[\u0016|W\u000f^'tA\u0005IA\u000f\u001f8SKN,H\u000e^\u000b\u0003\u0003+\u0002B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u00037\u0002\u0018\u0001\u0003:fcV,7\u000f^:\n\t\u0005}\u0013\u0011\f\u0002\u0012)J\fgn]1di&|gNU3tk2$\u0018A\u0003;y]J+7/\u001e7uA\u0005aA\u000f\u001f8NKR\fG-\u0019;bcU\u0011\u0011q\r\t\u0004\u001d\u0006%\u0014bAA6{\t\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u0006iA\u000f\u001f8NKR\fG-\u0019;bc\u0001\nA\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCJ\nQ\u0002\u001e=o\u001b\u0016$\u0018\rZ1uCJ\u0002\u0013AF2baR,(/\u001a3FeJ|'o]\"bY2\u0014\u0017mY6\u0016\u0005\u0005]\u0004CBA=\u0003\u007f\n\u0019)\u0004\u0002\u0002|)\u0019\u0011QP1\u0002\u0011\u0015\f7/_7pG.LA!!!\u0002|\t91)\u00199ukJ,\u0007c\u0002$\u0002\u0006\u0006%\u0015QS\u0005\u0004\u0003\u000f;%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tY)!%\u000e\u0005\u00055%bAAHa\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u0014\u00065%AB#se>\u00148\u000fE\u0002G\u0003/K1!!'H\u0005\u0011)f.\u001b;\u0002/\r\f\u0007\u000f^;sK\u0012,%O]8sg\u000e\u000bG\u000e\u001c2bG.\u0004\u0013\u0001\u0002;j[\u0016,\"!!)\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KS1!a*q\u0003\u0015)H/\u001b7t\u0013\u0011\tY+!*\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nab\u00195b]:,G.T1oC\u001e,'/\u0006\u0002\u00024B\u0019a*!.\n\u0007\u0005]VHA\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\fqb\u00195b]:,G.T1oC\u001e,'\u000fI\u0001\n[>\u001c7nQ1dQ\u0016$\"!!&\u0002AMDw.\u001e7e\u001f:d\u0017p\u0016:ji\u0016$\u0006P\\\"p[BdW\r^5p]>s7-\u001a\u0015\u0004c\u0005\r\u0007\u0003BAc\u0003'l!!a2\u000b\t\u0005%\u00171Z\u0001\u0004CBL'\u0002BAg\u0003\u001f\fqA[;qSR,'OC\u0002\u0002R\u0006\fQA[;oSRLA!!6\u0002H\n!A+Z:u\u0003=\u001a\bn\\;mI\u001e+g.\u001a:bi\u0016,U\u000e\u001d;z\u001b\u0006\u0004x\u000b[3o\u001d>\u0014V-];fgR\u001cx*\u001e;ti\u0006tG-\u001b8hQ\r\u0011\u00141Y\u0001+g\"|W\u000f\u001c3HK:,'/\u0019;f%\u0016\fX/Z:u!\u0016\u0014\b+\u0019:uSRLwN\u001c)fe\n\u0013xn[3sQ\r\u0019\u00141Y\u0001(g\"|W\u000f\u001c3TW&\u00048+\u001a8e\u001b\u0006\u00148.\u001a:t/\",g\u000eT3bI\u0016\u0014hj\u001c;G_VtG\rK\u00025\u0003\u0007\f!g\u001d5pk2$7+\u0019<f\r>\u0014H*\u0019;fe^CWM\u001c'fC\u0012,'/\u00168l]><hNQ;u\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u0015\u0004k\u0005\r\u0017\u0001O:i_VdGMU3n_Z,W*\u0019:lKJ\u001chi\u001c:Uq:\u0004\u0016M\u001d;ji&|gn\u00165f]B\u000b'\u000f^5uS>tW)\\5he\u0006$X\r\u001a\u0015\u0004m\u0005\r\u0017aN:i_VdGmQ8na2,G/Z!qa\u0016tG\rV8M_\u001e|e.\u00128e)btw\u000b[3o'\u0016tG-T1sW\u0016\u00148oU;dG\u0016,G\rK\u00028\u0003\u0007\fQg\u001d5pk2$\u0017IY8si\u0006\u0003\b/\u001a8e)>dunZ(o\u000b:$G\u000b\u001f8XQ\u0016tgj\u001c;D_>\u0014H-\u001b8bi>\u0014XI\u001d:pe\"\u001a\u0001(a1\u0002}MDw.\u001e7e%\u0016$(/_!qa\u0016tG\rV8M_\u001e|e.\u00128e)btw\u000b[3o\u0007>|'\u000fZ5oCR|'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016,%O]8sQ\rI\u00141Y\u0001\u0012GJ,\u0017\r^3QS\u0012,%O]8s\u001b\u0006\u0004H\u0003BA~\u0005#\u0001\u0002\"!@\u0003\u0004\t\u001d!1B\u0007\u0003\u0003\u007fTAA!\u0001\u0002\f\u0005!Q\u000f^5m\u0013\u0011\u0011)!a@\u0003\u000f!\u000b7\u000f['baB!\u0011Q\u0001B\u0005\u0013\u0011\t\t#a\u0002\u0011\u000f\u0005u(Q\u00028\u0002\n&!!qBA\u0000\u0005\ri\u0015\r\u001d\u0005\b\u0005'Q\u0004\u0019AAE\u0003\u0019)'O]8sg\u0006i2\u000f[8vY\u0012\u001c%/Z1uK6+GO]5dg>s7\u000b^1si&tw\rK\u0002<\u0003\u0007\u0004")
public class TransactionMarkerChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)EasyMock.mock(TransactionStateManager.class);
    private final TopicPartition partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic1", 1);
    private final Node broker1 = new Node(1, "host", 10);
    private final Node broker2 = new Node(2, "otherhost", 10);
    private final String transactionalId1;
    private final String transactionalId2;
    private final long producerId1;
    private final long producerId2;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTopicPartition1;
    private final int txnTopicPartition2;
    private final int coordinatorEpoch;
    private final int txnTimeoutMs;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TransactionMetadata txnMetadata1 = new TransactionMetadata(this.transactionalId1(), this.producerId1(), this.producerId1(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1(), this.partition2()})), 0L, 0L);
    private final TransactionMetadata txnMetadata2 = new TransactionMetadata(this.transactionalId2(), this.producerId2(), this.producerId2(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1()})), 0L, 0L);
    private final Capture<Function1<Errors, BoxedUnit>> capturedErrorsCallback = EasyMock.newCapture();
    private final MockTime time = new MockTime();
    private final TransactionMarkerChannelManager channelManager = new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)), this.metadataCache(), this.networkClient(), this.txnStateManager(), (Time)this.time());

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TopicPartition partition1() {
        return this.partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    private Node broker1() {
        return this.broker1;
    }

    private Node broker2() {
        return this.broker2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTopicPartition1() {
        return this.txnTopicPartition1;
    }

    private int txnTopicPartition2() {
        return this.txnTopicPartition2;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    private TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    private Capture<Function1<Errors, BoxedUnit>> capturedErrorsCallback() {
        return this.capturedErrorsCallback;
    }

    private MockTime time() {
        return this.time;
    }

    private TransactionMarkerChannelManager channelManager() {
        return this.channelManager;
    }

    private void mockCache() {
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId1()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition1())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId2()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition2())).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId1()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())))).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId2()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())))).anyTimes();
    }

    @Test
    public void shouldOnlyWriteTxnCompletionOnce() {
        Future<Try> addMarkerFuture;
        this.mockCache();
        TxnTransitMetadata expectedTransition = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)expectedTransition), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$1(this, expectedTransition);
            return BoxedUnit.UNIT;
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        ExecutorService executor = Executors.newFixedThreadPool(1);
        this.txnMetadata2().lock().lock();
        try {
            addMarkerFuture = executor.submit(() -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), expectedTransition)));
            RequestHeader header = new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1);
            WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(Collections.singletonMap(Predef$.MODULE$.long2Long(this.producerId2()), Collections.singletonMap(this.partition1(), Errors.NONE)));
            ClientResponse clientResponse = new ClientResponse(header, null, null, this.time().milliseconds(), this.time().milliseconds(), false, null, null, (AbstractResponse)response);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$4(this, clientResponse)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Timed out waiting for expected WriteTxnMarkers request");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
        }
        finally {
            this.txnMetadata2().lock().unlock();
            executor.shutdown();
        }
        Assertions.assertNotNull(addMarkerFuture);
        Assertions.assertTrue((boolean)addMarkerFuture.get().isSuccess(), (String)new StringBuilder(38).append("Add marker task failed with exception ").append(addMarkerFuture.get().get()).toString());
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
    }

    @Test
    public void shouldGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldGenerateRequestPerPartitionPerBroker() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)2, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList(new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition1())), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition1())))).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList(new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition2())))).build();
        scala.collection.immutable.Map requests = ((IterableOnceOps)this.channelManager().generateRequests().map((Function1 & Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)requests);
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldSkipSendMarkersWhenLeaderNotFound() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)1, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldSaveForLaterWhenLeaderUnknownButNotAvailable() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)this.broker1())).andReturn((Object)new Some((Object)this.broker1()));
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)2, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers());
        Assertions.assertEquals((int)1, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList(new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition1())), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition1())))).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList(new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition2())))).build();
        scala.collection.immutable.Map firstDrainedRequests = ((IterableOnceOps)this.channelManager().generateRequests().map((Function1 & Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)firstDrainedRequests);
        scala.collection.immutable.Map secondDrainedRequests = ((IterableOnceOps)this.channelManager().generateRequests().map((Function1 & Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request)})), (Object)secondDrainedRequests);
    }

    @Test
    public void shouldRemoveMarkersForTxnPartitionWhenPartitionEmigrated() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)2, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        this.channelManager().removeMarkersForTxnTopicPartition(this.txnTopicPartition1());
        Assertions.assertEquals((int)1, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(this, txnTransitionMetadata2);
            return BoxedUnit.UNIT;
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$2(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    @Test
    public void shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(this);
            return BoxedUnit.UNIT;
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$2(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)PrepareCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    @Test
    public void shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(this);
            return BoxedUnit.UNIT;
        }).andAnswer(() -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$2(this, txnTransitionMetadata2);
            return BoxedUnit.UNIT;
        });
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$3(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        this.channelManager().generateRequests();
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createPidErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.partition1(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId2()), errorsMap);
        return var2_2;
    }

    @Test
    public void shouldCreateMetricsOnStarting() {
        scala.collection.mutable.Map metrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Assertions.assertEquals((int)1, (int)metrics.count((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$1(x0$1))));
        Assertions.assertEquals((int)1, (int)metrics.count((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$2(x0$2))));
    }

    public static final /* synthetic */ void $anonfun$shouldOnlyWriteTxnCompletionOnce$1(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata expectedTransition$1) {
        $this.txnMetadata2().completeTransitionTo(expectedTransition$1);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$shouldOnlyWriteTxnCompletionOnce$4(TransactionMarkerChannelManagerTest $this, ClientResponse clientResponse$1) {
        Iterable requests = $this.channelManager().generateRequests();
        if (requests.nonEmpty()) {
            Assertions.assertEquals((int)1, (int)requests.size());
            ((RequestAndCompletionHandler)requests.head()).handler().onComplete(clientResponse$1);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$shouldOnlyWriteTxnCompletionOnce$5() {
        return "Timed out waiting for expected WriteTxnMarkers request";
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata txnTransitionMetadata2$1) {
        $this.txnMetadata2().completeTransitionTo(txnTransitionMetadata2$1);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$2(WriteTxnMarkersResponse response$1, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$1));
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(TransactionMarkerChannelManagerTest $this) {
        $this.txnMetadata2().pendingState_$eq((Option)None$.MODULE$);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NOT_COORDINATOR);
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$2(WriteTxnMarkersResponse response$2, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$2));
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(TransactionMarkerChannelManagerTest $this) {
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.COORDINATOR_NOT_AVAILABLE);
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$2(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata txnTransitionMetadata2$2) {
        $this.txnMetadata2().completeTransitionTo(txnTransitionMetadata2$2);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$3(WriteTxnMarkersResponse response$3, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$3));
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=UnknownDestinationQueueSize";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$2._1()).getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=LogAppendRetryQueueSize";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public TransactionMarkerChannelManagerTest() {
        this.transactionalId1 = "txnId1";
        this.transactionalId2 = "txnId2";
        this.producerId1 = 0;
        this.producerId2 = 1;
        this.txnTopicPartition1 = 0;
        this.txnTopicPartition2 = 1;
        this.coordinatorEpoch = 0;
        this.txnTimeoutMs = 0;
    }
}

