/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.metadata.BrokerMetadataListener;
import kafka.server.metadata.MetadataPublisher;
import kafka.server.metadata.MetadataSnapshotter;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015g\u0001B\u0013'\u00015BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000f\u0001\u0005\u0002eBQA\u0013\u0001\u0005\u0002e2A\u0001\u0014\u0001\u0001\u001b\")A\u0007\u0002C\u0001#\"9A\u000b\u0002a\u0001\n\u0003)\u0006b\u00020\u0005\u0001\u0004%\ta\u0018\u0005\u0007E\u0012\u0001\u000b\u0015\u0002,\t\u000f\r$!\u0019!C\u0001I\"1Q\u0010\u0002Q\u0001\n\u0015DqA \u0003A\u0002\u0013\u0005q\u0010C\u0005\u0002\b\u0011\u0001\r\u0011\"\u0001\u0002\n!A\u0011Q\u0002\u0003!B\u0013\t\t\u0001\u0003\u0005\u0002\u0010\u0011\u0001\r\u0011\"\u0001\u0000\u0011%\t\t\u0002\u0002a\u0001\n\u0003\t\u0019\u0002\u0003\u0005\u0002\u0018\u0011\u0001\u000b\u0015BA\u0001\u0011%\tI\u0002\u0002a\u0001\n\u0003\tY\u0002C\u0005\u0002$\u0011\u0001\r\u0011\"\u0001\u0002&!A\u0011\u0011\u0006\u0003!B\u0013\ti\u0002\u0003\u0005\u0002,\u0011\u0001\r\u0011\"\u0001\u0000\u0011%\ti\u0003\u0002a\u0001\n\u0003\ty\u0003\u0003\u0005\u00024\u0011\u0001\u000b\u0015BA\u0001\u0011\u001d\t)\u0004\u0002C!\u0003o1a!a\u0014\u0001\u0001\u0005E\u0003B\u0002\u001b\u0019\t\u0003\tI\u0006C\u0004U1\u0001\u0007I\u0011A+\t\u0011yC\u0002\u0019!C\u0001\u0003;BaA\u0019\r!B\u00131\u0006bBA11\u0011\u0005\u00131\r\u0005\n\u0003k\u0002!\u0019!C\u0005\u0003oB\u0001\"!\"\u0001A\u0003%\u0011\u0011\u0010\u0005\b\u0003\u000f\u0003A\u0011BAE\u0011\u0019\tI\n\u0001C\u0001s!1\u0011Q\u0014\u0001\u0005\u0002eBq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u00024\u0002!I!!.\u00035\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uC2K7\u000f^3oKJ$Vm\u001d;\u000b\u0005\u001dB\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u0005%R\u0013AB:feZ,'OC\u0001,\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\ta%\u0001\nuKN$8I]3bi\u0016\fe\u000eZ\"m_N,G#\u0001\u001e\u0011\u0005=Z\u0014B\u0001\u001f1\u0005\u0011)f.\u001b;)\u0005\tq\u0004CA I\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\u000bqA[;qSR,'O\u0003\u0002F\r\u0006)!.\u001e8ji*\tq)A\u0002pe\u001eL!!\u0013!\u0003\tQ+7\u000f^\u0001\fi\u0016\u001cH\u000fU;cY&\u001c\b\u000e\u000b\u0002\u0004}\t9Rj\\2l\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R$XM]\n\u0004\t9r\u0005CA\u001cP\u0013\t\u0001fEA\nNKR\fG-\u0019;b':\f\u0007o\u001d5piR,'\u000fF\u0001S!\t\u0019F!D\u0001\u0001\u0003\u0015IW.Y4f+\u00051\u0006CA,]\u001b\u0005A&B\u0001+Z\u0015\tY#L\u0003\u0002\\\r\u00061\u0011\r]1dQ\u0016L!!\u0018-\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003%IW.Y4f?\u0012*\u0017\u000f\u0006\u0002;A\"9\u0011mBA\u0001\u0002\u00041\u0016a\u0001=%c\u00051\u0011.\\1hK\u0002\nqAZ1jYV\u0014X-F\u0001f!\r1w.]\u0007\u0002O*\u0011\u0001.[\u0001\u0007CR|W.[2\u000b\u0005)\\\u0017AC2p]\u000e,(O]3oi*\u0011A.\\\u0001\u0005kRLGNC\u0001o\u0003\u0011Q\u0017M^1\n\u0005A<'aD!u_6L7MU3gKJ,gnY3\u0011\u0005IThBA:y\u001d\t!x/D\u0001v\u0015\t1H&\u0001\u0004=e>|GOP\u0005\u0002c%\u0011\u0011\u0010M\u0001\ba\u0006\u001c7.Y4f\u0013\tYHPA\u0005UQJ|w/\u00192mK*\u0011\u0011\u0010M\u0001\tM\u0006LG.\u001e:fA\u0005!\u0012m\u0019;jm\u0016\u001cf.\u00199tQ>$xJ\u001a4tKR,\"!!\u0001\u0011\u0007=\n\u0019!C\u0002\u0002\u0006A\u0012A\u0001T8oO\u0006A\u0012m\u0019;jm\u0016\u001cf.\u00199tQ>$xJ\u001a4tKR|F%Z9\u0015\u0007i\nY\u0001\u0003\u0005b\u0019\u0005\u0005\t\u0019AA\u0001\u0003U\t7\r^5wKNs\u0017\r]:i_R|eMZ:fi\u0002\n1\u0003\u001d:fm\u000e{W.\\5ui\u0016$wJ\u001a4tKR\fq\u0003\u001d:fm\u000e{W.\\5ui\u0016$wJ\u001a4tKR|F%Z9\u0015\u0007i\n)\u0002\u0003\u0005b\u001f\u0005\u0005\t\u0019AA\u0001\u0003Q\u0001(/\u001a<D_6l\u0017\u000e\u001e;fI>3gm]3uA\u0005\u0011\u0002O]3w\u0007>lW.\u001b;uK\u0012,\u0005o\\2i+\t\ti\u0002E\u00020\u0003?I1!!\t1\u0005\rIe\u000e^\u0001\u0017aJ,goQ8n[&$H/\u001a3Fa>\u001c\u0007n\u0018\u0013fcR\u0019!(a\n\t\u0011\u0005\u0014\u0012\u0011!a\u0001\u0003;\t1\u0003\u001d:fm\u000e{W.\\5ui\u0016$W\t]8dQ\u0002\n\u0001\u0004\u001d:fm2\u000b7\u000f^\"p]R\f\u0017N\\3e\u0019><G+[7f\u0003q\u0001(/\u001a<MCN$8i\u001c8uC&tW\r\u001a'pORKW.Z0%KF$2AOA\u0019\u0011!\tW#!AA\u0002\u0005\u0005\u0011!\u00079sKZd\u0015m\u001d;D_:$\u0018-\u001b8fI2{w\rV5nK\u0002\n!#\\1zE\u0016\u001cF/\u0019:u':\f\u0007o\u001d5piRQ\u0011\u0011HA \u0003\u0007\n9%a\u0013\u0011\u0007=\nY$C\u0002\u0002>A\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002B]\u0001\r!!\u0001\u0002\u001f\r|W.\\5ui\u0016$wJ\u001a4tKRDq!!\u0012\u0018\u0001\u0004\ti\"\u0001\bd_6l\u0017\u000e\u001e;fI\u0016\u0003xn\u00195\t\u000f\u0005%s\u00031\u0001\u0002\u0002\u0005!B.Y:u\u0007>tG/Y5oK\u0012dun\u001a+j[\u0016Da!!\u0014\u0018\u0001\u00041\u0016\u0001\u00038fo&k\u0017mZ3\u0003+5{7m['fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feN!\u0001DLA*!\r9\u0014QK\u0005\u0004\u0003/2#!E'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5feR\u0011\u00111\f\t\u0003'b!2AOA0\u0011\u001d\t7$!AA\u0002Y\u000bq\u0001];cY&\u001c\b\u000eF\u0004;\u0003K\nI'a\u001d\t\u000f\u0005\u001dT\u00041\u0001\u0002\u0002\u0005Ab.Z<IS\u001eDWm\u001d;NKR\fG-\u0019;b\u001f\u001a47/\u001a;\t\u000f\u0005-T\u00041\u0001\u0002n\u0005)A-\u001a7uCB\u0019q+a\u001c\n\u0007\u0005E\u0004LA\u0007NKR\fG-\u0019;b\t\u0016dG/\u0019\u0005\u0007\u0003\u001bj\u0002\u0019\u0001,\u0002\r\u0019{ujX%E+\t\tI\b\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\r\ty(W\u0001\u0007G>lWn\u001c8\n\t\u0005\r\u0015Q\u0010\u0002\u0005+VLG-A\u0004G\u001f>{\u0016\n\u0012\u0011\u0002'\u001d,g.\u001a:bi\u0016l\u0015M\\=SK\u000e|'\u000fZ:\u0015\u000bi\nY)!&\t\u000f\u00055\u0005\u00051\u0001\u0002\u0010\u0006AA.[:uK:,'\u000fE\u00028\u0003#K1!a%'\u0005Y\u0011%o\\6fe6+G/\u00193bi\u0006d\u0015n\u001d;f]\u0016\u0014\bbBALA\u0001\u0007\u0011\u0011A\u0001\nK:$wJ\u001a4tKR\f\u0011\u0006^3ti\"\u000bg\u000e\u001a7f\u0007>lW.\u001b;t/&$\bNT8T]\u0006\u00048\u000f[8ui\u0016\u0014H)\u001a4j]\u0016$\u0007FA\u0011?\u0003I!Xm\u001d;De\u0016\fG/Z*oCB\u001c\bn\u001c;)\u0005\tr\u0014a\u0004:fO&\u001cH/\u001a:Ce>\\WM]:\u0015\u000fi\n)+a*\u00022\"9\u0011QR\u0012A\u0002\u0005=\u0005bBAUG\u0001\u0007\u00111V\u0001\nEJ|7.\u001a:JIN\u0004RA]AW\u0003;I1!a,}\u0005!IE/\u001a:bE2,\u0007bBALG\u0001\u0007\u0011\u0011A\u0001\u001cGJ,\u0017\r^3U_BL7mV5uQ>sW\rU1si&$\u0018n\u001c8\u0015\u000fi\n9,!/\u0002D\"9\u0011Q\u0012\u0013A\u0002\u0005=\u0005bBA^I\u0001\u0007\u0011QX\u0001\te\u0016\u0004H.[2bgB)!/a0\u0002\u001e%\u0019\u0011\u0011\u0019?\u0003\u0007M+\u0017\u000fC\u0004\u0002\u0018\u0012\u0002\r!!\u0001")
public class BrokerMetadataListenerTest {
    private final Uuid FOO_ID = Uuid.fromString((String)"jj1G9utnTuCegi_gpnRgYw");

    @Test
    public void testCreateAndClose() {
        new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, 1000000L, (Option)None$.MODULE$).close();
    }

    @Test
    public void testPublish() {
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, 1000000L, (Option)None$.MODULE$);){
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)100L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg")), (short)0))));
            List imageRecords = (List)listener.getImageRecords().get();
            Assertions.assertEquals((int)0, (int)imageRecords.size());
            Assertions.assertEquals((long)100L, (long)listener.highestMetadataOffset());
            listener.handleCommit(RecordTestUtils.mockBatchReader((long)200L, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(200L).setFenced(true).setRack(null).setIncarnationId(Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg")), (short)0))));
            listener.startPublishing(new MetadataPublisher(null){

                public void publish(long newHighestMetadataOffset, MetadataDelta delta, MetadataImage newImage) {
                    Assertions.assertEquals((long)200L, (long)newHighestMetadataOffset);
                    Assertions.assertEquals((Object)new BrokerRegistration(0, 100L, Uuid.fromString((String)"GFBwlTcpQUuLYQ2ig05CSg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), false), (Object)delta.clusterDelta().broker(0));
                    Assertions.assertEquals((Object)new BrokerRegistration(1, 200L, Uuid.fromString((String)"QkOQtNKVTYatADcaJ28xDg"), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), true), (Object)delta.clusterDelta().broker(1));
                }
            }).get();
        }
    }

    private Uuid FOO_ID() {
        return this.FOO_ID;
    }

    private void generateManyRecords(BrokerMetadataListener listener, long endOffset) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.singletonList(Predef$.MODULE$.int2Integer(1))), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setRemovingReplicas(Collections.emptyList()), (short)0)))));
        listener.getImageRecords().get();
    }

    @Test
    public void testHandleCommitsWithNoSnapshotterDefined() {
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, 1000L, (Option)None$.MODULE$);){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)listener.highestMetadataOffset());
        }
    }

    @Test
    public void testCreateSnapshot() {
        MockMetadataSnapshotter snapshotter = new MockMetadataSnapshotter();
        try (BrokerMetadataListener listener = new BrokerMetadataListener(0, Time.SYSTEM, (Option)None$.MODULE$, 1000L, (Option)new Some((Object)snapshotter));){
            Range.Inclusive brokerIds = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3);
            this.registerBrokers(listener, (Iterable<Object>)brokerIds, 100L);
            this.createTopicWithOnePartition(listener, (scala.collection.immutable.Seq<Object>)brokerIds, 200L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)200L, (long)listener.highestMetadataOffset());
            Assertions.assertEquals((long)-1L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 1000L);
            Assertions.assertEquals((long)1000L, (long)snapshotter.prevCommittedOffset());
            Assertions.assertEquals((long)1000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            MockMetadataPublisher publisher = new MockMetadataPublisher();
            listener.startPublishing((MetadataPublisher)publisher).get();
            this.generateManyRecords(listener, 2000L);
            listener.getImageRecords().get();
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals((long)2000L, (long)snapshotter.prevCommittedOffset());
            this.generateManyRecords(listener, 3000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            this.generateManyRecords(listener, 4000L);
            Assertions.assertEquals((long)2000L, (long)snapshotter.activeSnapshotOffset());
            snapshotter.activeSnapshotOffset_$eq(-1L);
            this.generateManyRecords(listener, 5000L);
            Assertions.assertEquals((long)5000L, (long)snapshotter.activeSnapshotOffset());
            Assertions.assertEquals(null, (Object)snapshotter.failure().get());
        }
    }

    private void registerBrokers(BrokerMetadataListener listener, Iterable<Object> brokerIds, long endOffset) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(brokerId).setBrokerEpoch(100L).setFenced(false).setRack(null).setIncarnationId(Uuid.fromString((String)new StringBuilder(21).append("GFBwlTcpQUuLYQ2ig05CS").append(brokerId).toString())), (short)0)))));
    }

    private void createTopicWithOnePartition(BrokerMetadataListener listener, scala.collection.immutable.Seq<Object> replicas, long endOffset) {
        listener.handleCommit(RecordTestUtils.mockBatchReader((long)endOffset, Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(this.FOO_ID()), (short)0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setPartitionId(0).setTopicId(this.FOO_ID()).setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$1(BoxesRunTime.unboxToInt((Object)x)))).asJava()).setLeader(0).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)replicas.map((Function1 & Serializable)x -> BrokerMetadataListenerTest.$anonfun$createTopicWithOnePartition$2(BoxesRunTime.unboxToInt((Object)x)))).asJava()), (short)0))));
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createTopicWithOnePartition$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public class MockMetadataPublisher
    implements MetadataPublisher {
        private MetadataImage image;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public void publish(long newHighestMetadataOffset, MetadataDelta delta, MetadataImage newImage) {
            this.image_$eq(newImage);
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataPublisher$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataPublisher() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
        }
    }

    public class MockMetadataSnapshotter
    implements MetadataSnapshotter {
        private MetadataImage image;
        private final AtomicReference<Throwable> failure;
        private long activeSnapshotOffset;
        private long prevCommittedOffset;
        private int prevCommittedEpoch;
        private long prevLastContainedLogTime;

        public MetadataImage image() {
            return this.image;
        }

        public void image_$eq(MetadataImage x$1) {
            this.image = x$1;
        }

        public AtomicReference<Throwable> failure() {
            return this.failure;
        }

        public long activeSnapshotOffset() {
            return this.activeSnapshotOffset;
        }

        public void activeSnapshotOffset_$eq(long x$1) {
            this.activeSnapshotOffset = x$1;
        }

        public long prevCommittedOffset() {
            return this.prevCommittedOffset;
        }

        public void prevCommittedOffset_$eq(long x$1) {
            this.prevCommittedOffset = x$1;
        }

        public int prevCommittedEpoch() {
            return this.prevCommittedEpoch;
        }

        public void prevCommittedEpoch_$eq(int x$1) {
            this.prevCommittedEpoch = x$1;
        }

        public long prevLastContainedLogTime() {
            return this.prevLastContainedLogTime;
        }

        public void prevLastContainedLogTime_$eq(long x$1) {
            this.prevLastContainedLogTime = x$1;
        }

        public boolean maybeStartSnapshot(long committedOffset, int committedEpoch, long lastContainedLogTime, MetadataImage newImage) {
            boolean bl;
            try {
                if (this.activeSnapshotOffset() != -1L) {
                    return false;
                }
                Assertions.assertTrue((this.prevCommittedOffset() <= committedOffset ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevCommittedEpoch() <= committedEpoch ? 1 : 0) != 0);
                Assertions.assertTrue((this.prevLastContainedLogTime() <= lastContainedLogTime ? 1 : 0) != 0);
                this.prevCommittedOffset_$eq(committedOffset);
                this.prevCommittedEpoch_$eq(committedEpoch);
                this.prevLastContainedLogTime_$eq(lastContainedLogTime);
                this.image_$eq(newImage);
                this.activeSnapshotOffset_$eq(committedOffset);
                bl = true;
            }
            catch (Throwable t) {
                bl = this.failure().compareAndSet(null, t);
            }
            return bl;
        }

        public /* synthetic */ BrokerMetadataListenerTest kafka$server$metadata$BrokerMetadataListenerTest$MockMetadataSnapshotter$$$outer() {
            return BrokerMetadataListenerTest.this;
        }

        public MockMetadataSnapshotter() {
            if (BrokerMetadataListenerTest.this == null) {
                throw null;
            }
            this.image = MetadataImage.EMPTY;
            this.failure = new AtomicReference<Object>(null);
            this.activeSnapshotOffset = -1L;
            this.prevCommittedOffset = -1L;
            this.prevCommittedEpoch = -1;
            this.prevLastContainedLogTime = -1L;
        }
    }
}

