/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import kafka.server.LogDirFailureChannel;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.server.common.CheckpointFile;
import scala.Function0;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005}4A\u0001D\u0007\u0001)!AA\u0004\u0001BC\u0002\u0013\u0005Q\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!9\u0003A!A!\u0002\u0013A\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u00061\u0002!\t!\u0017\u0005\bC\u0002\u0011\r\u0011\"\u0003c\u0011\u00191\u0007\u0001)A\u0005G\")q\r\u0001C\u0001Q\")q\u000f\u0001C\u0001q\n\u00013\t[3dWB|\u0017N\u001c;GS2,w+\u001b;i\r\u0006LG.\u001e:f\u0011\u0006tG\r\\3s\u0015\tqq\"A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c(B\u0001\t\u0012\u0003\u0019\u0019XM\u001d<fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0016\u0005Uq4C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fM\u0006!a-\u001b7f+\u0005q\u0002CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\tIwNC\u0001$\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0002#\u0001\u0002$jY\u0016\fQAZ5mK\u0002\nqA^3sg&|g\u000e\u0005\u0002\u0018S%\u0011!\u0006\u0007\u0002\u0004\u0013:$\u0018!\u00034pe6\fG\u000f^3s!\ri\u0013\b\u0010\b\u0003]]j\u0011a\f\u0006\u0003aE\naaY8n[>t'B\u0001\t3\u0015\t\u00112G\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d0\u00039\u0019\u0005.Z2la>Lg\u000e\u001e$jY\u0016L!AO\u001e\u0003\u001d\u0015sGO]=G_Jl\u0017\r\u001e;fe*\u0011\u0001h\f\t\u0003{yb\u0001\u0001B\u0003@\u0001\t\u0007\u0001IA\u0001U#\t\tE\t\u0005\u0002\u0018\u0005&\u00111\t\u0007\u0002\b\u001d>$\b.\u001b8h!\t9R)\u0003\u0002G1\t\u0019\u0011I\\=\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\tI%*D\u0001\u0010\u0013\tYuB\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0007Y><G)\u001b:\u0011\u00059+fBA(T!\t\u0001\u0006$D\u0001R\u0015\t\u00116#\u0001\u0004=e>|GOP\u0005\u0003)b\ta\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011A\u000bG\u0001\u0007y%t\u0017\u000e\u001e \u0015\ricVLX0a!\rY\u0006\u0001P\u0007\u0002\u001b!)Ad\u0002a\u0001=!)qe\u0002a\u0001Q!)1f\u0002a\u0001Y!)qi\u0002a\u0001\u0011\")Aj\u0002a\u0001\u001b\u0006q1\r[3dWB|\u0017N\u001c;GS2,W#A2\u0011\u00079\"G(\u0003\u0002f_\tq1\t[3dWB|\u0017N\u001c;GS2,\u0017aD2iK\u000e\\\u0007o\\5oi\u001aKG.\u001a\u0011\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005%d\u0007CA\fk\u0013\tY\u0007D\u0001\u0003V]&$\b\"B7\u000b\u0001\u0004q\u0017aB3oiJLWm\u001d\t\u0004_RddB\u00019s\u001d\t\u0001\u0016/C\u0001\u001a\u0013\t\u0019\b$A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(\u0001C%uKJ\f'\r\\3\u000b\u0005MD\u0012\u0001\u0002:fC\u0012$\u0012!\u001f\t\u0004uvdT\"A>\u000b\u0005qD\u0012AC2pY2,7\r^5p]&\u0011ap\u001f\u0002\u0004'\u0016\f\b")
public class CheckpointFileWithFailureHandler<T> {
    private final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String logDir;
    private final CheckpointFile<T> checkpointFile;

    public File file() {
        return this.file;
    }

    private CheckpointFile<T> checkpointFile() {
        return this.checkpointFile;
    }

    public void write(Iterable<T> entries) {
        try {
            this.checkpointFile().write((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)entries.toSeq()).asJava());
            return;
        }
        catch (IOException e) {
            String msg = new StringBuilder(39).append("Error while writing to checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public Seq<T> read() {
        try {
            return CollectionConverters$.MODULE$.ListHasAsScala(this.checkpointFile().read()).asScala();
        }
        catch (IOException e) {
            String msg = new StringBuilder(36).append("Error while reading checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public CheckpointFileWithFailureHandler(File file, int version, CheckpointFile.EntryFormatter<T> formatter, LogDirFailureChannel logDirFailureChannel, String logDir) {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        this.logDir = logDir;
        this.checkpointFile = new CheckpointFile(file, version, formatter);
    }
}

