/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.ZkIsrManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005=3A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C\u00011!)A\u0006\u0001C\u00011!)a\u0006\u0001C\u00011!)\u0001\u0007\u0001C\u00011!)!\u0007\u0001C\u00011!)A\u0007\u0001C\u00011!)a\u0007\u0001C\u0001o\ty1*\u00194lCN+'O^3s)\u0016\u001cHO\u0003\u0002\f\u0019\u000511/\u001a:wKJT\u0011!D\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012%5\t!\"\u0003\u0002\u0014\u0015\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u00051\u0002CA\t\u0001\u0003!\"Xm\u001d;BYJ,\u0017\rZ=SK\u001eL7\u000f^3sK\u0012\fEM^3si&\u001cX\r\u001a'jgR,g.\u001a:t)\u0005I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"\u0001B+oSRD#A\u0001\u0011\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013aA1qS*\u0011QEJ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0003&A\u0003kk:LGOC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012A\u0001V3ti\u0006AC/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[WRc7oQ8oM&<w\u000b[3o\t&\u001c\u0018M\u00197fI\"\u00121\u0001I\u0001+i\u0016\u001cHo\u0011:fCR,7\u000f\u0015:pa\u0016\u0014(l\u001b+mg\u000e{gNZ5h/&$\b\u000e\u0016:vKZ\u000bG.^3tQ\t!\u0001%\u0001\u001auKN$8I]3bi\u0016\u001c\bK]8qKJT6\u000e\u00167t\u0007>tg-[4XSRDg)\u00197tK\u0006sG\rT5tiZ\u000bG.^3tQ\t)\u0001%\u0001\tuKN$(l[%te6\u000bg.Y4fe\"\u0012a\u0001I\u0001\u0014i\u0016\u001cH/\u00117uKJL5O]'b]\u0006<WM\u001d\u0015\u0003\u000f\u0001\nAb\u0019:fCR,7+\u001a:wKJ$B\u0001O\u001eA\u001bB\u0011\u0011#O\u0005\u0003u)\u00111bS1gW\u0006\u001cVM\u001d<fe\")A\b\u0003a\u0001{\u00051an\u001c3f\u0013\u0012\u0004\"A\u0007 \n\u0005}Z\"aA%oi\")\u0011\t\u0003a\u0001\u0005\u0006A\u0001n\\:u\u001d\u0006lW\r\u0005\u0002D\u0015:\u0011A\t\u0013\t\u0003\u000bni\u0011A\u0012\u0006\u0003\u000f:\ta\u0001\u0010:p_Rt\u0014BA%\u001c\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%[\u0002\"\u0002(\t\u0001\u0004i\u0014\u0001\u00029peR\u0004")
public class KafkaServerTest
extends QuorumTestHarness {
    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort((KafkaBroker)server1, SecurityProtocol.PLAINTEXT)));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server1, server2})));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), false);
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkIsrManager() {
        void createServer_time;
        void createServer_config;
        Time time;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.7-IV1");
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var6_6 = null;
        Object var3_5 = null;
        kafkaConfig = null;
        time3 = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        if (!(server.replicaManager().alterIsrManager() instanceof ZkIsrManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterIsrManager() {
        void createServer_time;
        void createServer_config;
        Time time;
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var6_6 = null;
        Object var3_5 = null;
        kafkaConfig = null;
        time3 = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        if (!(server.replicaManager().alterIsrManager() instanceof DefaultAlterIsrManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(int nodeId, String hostName, int port) {
        void createServer_time;
        Time time;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        return createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "HTTPS" : someValue$1;
        }
        return string;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "true" : someValue$1;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "false";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }
}

